// ZH修改2021年8月26日16:23:59
#include "Line_in.h"
#include "GPIO.h"
#include "dr7f701441.dvf.h"
#include "CD4051.h"

/*ZH修改：2021.6.25 08:35*/
/*指示灯 相关的 硬线*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_ABS(void);              /*A22  ABS*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_PARK_BRAKE(void);       /*A23  PARK BRAKE*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_HI_BEAM(void);          /*A25  HI BEAM*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_BRAKE_AIR_EBS(void);    /*A28  BRAKE AIR/EBS*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_SEAT_BELT(void);        /*A30  SEAT BELT*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_MIL(void);              /*A31  MIL*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_ENG_OIL(void);          /*A32  ENG OIL*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_CHARGE(void);           /*A34  CHARGE*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_TRAILER_ABS_INFO(void); /*B03  TRAILER ABS INFO*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_Rr_FOG_LAMP(void);      /*B14  Rr FOG LAMP*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_ACC_AIR(void);          /*B15  ACC AIR*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_AIR_SUS(void);          /*B30  AIR SUS*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_TRAILER_BRAKE(void);    /*B31  TRAILER BRAKE*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_TRAILER_ABS(void);      /*B33  TRAILER ABS*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_RR_DIFF_LOCK(void);     /*B36  RR DIFF LOCK*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_WEAR_IND(void);         /*B38  WEAR IND*/

/*ZH新增：2021.6.28 18:38*/
/*非指示灯 相关的 硬线*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_ILLUMINATION(void);    /*A06  ILLUMINATION*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_RET_BLENDING(void);    /*A10  RET_BLENDING*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_BRAKE(void);           /*A21  BRAKE*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_TURN_R(void);          /*A26  TURN_R*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_TURN_L(void);          /*A27  TURN_L*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_ABS_DETECT(void);      /*A33  ABS_DETECT*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_PTO(void);             /*B01  PTO*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_GLOW(void);            /*B05  GLOW*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_TRAILER_CONNECT(void); /*B06  TRAILER_CONNECT*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_LOW_COOLANT(void);     /*B32  LOW_COOLANT*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_ACC(void);             /*B39  ACC*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_WEAR2(void);           /*B40  WEAR2*/

/*属性表与硬线索引号Line_In_Channel_en_t一一对应*/
const Line_In_Attribute_st_t g_stLineInAttribute[LINE_IN_MAX] =
{
    /*ZH修改：2021.6.24 19:47*/
    /*指示灯信号 硬线输入*/
    {LINE_IN_LEVEL_LOW, 200U, 0U, LINE_IN_IG_ON, LINE_IN_Get_ABS,},                         /*A22  ABS*/
    {LINE_IN_LEVEL_LOW, 200U, 0U, LINE_IN_IG_ON, LINE_IN_Get_PARK_BRAKE,},                  /*A23  PARK BRAKE*/
    {LINE_IN_LEVEL_HIGH, 200U, 0U, LINE_IN_IG_ON, LINE_IN_Get_HI_BEAM,},                    /*A25  HI BEAM*/
    {LINE_IN_LEVEL_LOW, 200U, 0U, LINE_IN_IG_ON, LINE_IN_Get_BRAKE_AIR_EBS,},               /*A28  BRAKE AIR/EBS*/
    {LINE_IN_LEVEL_LOW, 200U, 0U, LINE_IN_IG_ON, LINE_IN_Get_SEAT_BELT,},                   /*A30  SEAT BELT*/
    {LINE_IN_LEVEL_LOW, 200U, 0U, LINE_IN_IG_ON, LINE_IN_Get_MIL,},                         /*A31  MIL*/
    {LINE_IN_LEVEL_LOW, 200U, 0U, LINE_IN_IG_ON, LINE_IN_Get_ENG_OIL,},                     /*A32  ENG OIL*/
    {LINE_IN_LEVEL_LOW, 200U, 0U, LINE_IN_IG_ON, LINE_IN_Get_CHARGE,},                      /*A34  CHARGE*/
    {LINE_IN_LEVEL_LOW, 200U, 0U, LINE_IN_IG_ON, LINE_IN_Get_TRAILER_ABS_INFO,},            /*B03  TRAILER ABS INFO*/
    {LINE_IN_LEVEL_HIGH, 200U, 0U, LINE_IN_IG_ON, LINE_IN_Get_Rr_FOG_LAMP,},                /*B14  Rr FOG LAMP*/
    {LINE_IN_LEVEL_LOW, 200U, 0U, LINE_IN_IG_ON, LINE_IN_Get_ACC_AIR,},                     /*B15  ACC AIR*/
    {LINE_IN_LEVEL_HIGH, 200U, 0U, LINE_IN_IG_ON, LINE_IN_Get_AIR_SUS,},                    /*B30  AIR SUS*/
    {LINE_IN_LEVEL_LOW, 200U, 0U, LINE_IN_IG_ON, LINE_IN_Get_TRAILER_BRAKE,},               /*B31  TRAILER BRAKE*/
    {LINE_IN_LEVEL_LOW, 200U, 0U, LINE_IN_IG_ON, LINE_IN_Get_TRAILER_ABS,},                 /*B33  TRAILER ABS*/
    {LINE_IN_LEVEL_HIGH, 200U, 0U, LINE_IN_IG_ON, LINE_IN_Get_RR_DIFF_LOCK,},               /*B36  RR DIFF LOCK*/
    {LINE_IN_LEVEL_LOW, 200U, 0U, LINE_IN_IG_ON, LINE_IN_Get_WEAR_IND,},                    /*B38  WEAR IND*/

    /*ZH新增：2021.6.28 18:38*/
    /*非指示灯信号 硬线输入*/
    {LINE_IN_LEVEL_HIGH, 200U, 0U, LINE_IN_IG_ON, LINE_IN_Get_ILLUMINATION,},               /*A06  ILLUMINATION*/
    {LINE_IN_LEVEL_LOW, 200U, 0U, LINE_IN_IG_ON, LINE_IN_Get_RET_BLENDING,},                /*A10  RET_BLENDING*/
    {LINE_IN_LEVEL_LOW, 200U, 0U, LINE_IN_IG_ON, LINE_IN_Get_BRAKE,},                       /*A21  BRAKE*/
    {LINE_IN_LEVEL_HIGH, 200U, 0U, LINE_IN_IG_ONOFF, LINE_IN_Get_TURN_R,},                  /*A26  TURN_R*/
    {LINE_IN_LEVEL_HIGH, 200U, 0U, LINE_IN_IG_ONOFF, LINE_IN_Get_TURN_L,},                  /*A27  TURN_L*/
    {LINE_IN_LEVEL_LOW, 200U, 0U, LINE_IN_IG_ON, LINE_IN_Get_ABS_DETECT,},                  /*A33  ABS_DETECT*/
    {LINE_IN_LEVEL_HIGH, 200U, 0U, LINE_IN_IG_ON, LINE_IN_Get_PTO,},                        /*B01  PTO*/
    {LINE_IN_LEVEL_LOW, 200U, 0U, LINE_IN_IG_ON, LINE_IN_Get_GLOW,},                        /*B05  GLOW*/
    {LINE_IN_LEVEL_LOW, 200U, 0U, LINE_IN_IG_ON, LINE_IN_Get_TRAILER_CONNECT,},             /*B06  TRAILER_CONNECT*/
    {LINE_IN_LEVEL_LOW, 200U, 0U, LINE_IN_IG_ON, LINE_IN_Get_LOW_COOLANT,},                 /*B32  LOW_COOLANT*/
    {LINE_IN_LEVEL_HIGH, 200U, 0U, LINE_IN_IG_ON, LINE_IN_Get_ACC,},                        /*B39  ACC*/
    {LINE_IN_LEVEL_LOW, 200U, 0U, LINE_IN_IG_ON, LINE_IN_Get_WEAR2,},                       /*B40  WEAR2*/
};

/*ZH修改：2021.6.25 08:46*/

/*A22  ABS*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_ABS(void)
{
    LINE_IN_TriggerLevel_en_t Res = CD4051_COM1_X6_IN;

    return Res;
}

/*A23  PARK BRAKE*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_PARK_BRAKE(void)
{
    LINE_IN_TriggerLevel_en_t Res = CD4051_COM1_X7_IN;

    return Res;
}

/*A25  HI BEAM*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_HI_BEAM(void)
{
    LINE_IN_TriggerLevel_en_t Res = CD4051_COM1_X5_IN;

    return Res;
}

/*A28  BRAKE AIR/EBS*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_BRAKE_AIR_EBS(void)
{
    LINE_IN_TriggerLevel_en_t Res = CD4051_COM2_X7_IN;

    return Res;
}

/*A30  SEAT BELT*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_SEAT_BELT(void)
{
    LINE_IN_TriggerLevel_en_t Res = CD4051_COM2_X3_IN;

    return Res;
}

/*A31  MIL*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_MIL(void)
{
    LINE_IN_TriggerLevel_en_t Res = CD4051_COM2_X0_IN;

    return Res;
}

/*A32  ENG OIL*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_ENG_OIL(void)
{
    LINE_IN_TriggerLevel_en_t Res = CD4051_COM2_X1_IN;

    return Res;
}

/*A34  CHARGE*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_CHARGE(void)
{
    LINE_IN_TriggerLevel_en_t Res = CD4051_COM1_X3_IN;

    return Res;
}

/*B03  TRAILER ABS INFO*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_TRAILER_ABS_INFO(void)
{
    LINE_IN_TriggerLevel_en_t Res = CD4051_COM6_X7_IN;

    return Res;
}

/*B14  Rr FOG LAMP*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_Rr_FOG_LAMP(void)
{
    LINE_IN_TriggerLevel_en_t Res = CD4051_COM7_X3_IN;

    return Res;
}

/*B15  ACC AIR*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_ACC_AIR(void)
{
    LINE_IN_TriggerLevel_en_t Res = CD4051_COM7_X0_IN;

    return Res;
}

/*B30  AIR SUS*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_AIR_SUS(void)
{
    LINE_IN_TriggerLevel_en_t Res = CD4051_COM5_X7_IN;

    return Res;
}

/*B31  TRAILER BRAKE*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_TRAILER_BRAKE(void)
{
    LINE_IN_TriggerLevel_en_t Res = CD4051_COM5_X6_IN;

    return Res;
}

/*B33  TRAILER ABS*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_TRAILER_ABS(void)
{
    LINE_IN_TriggerLevel_en_t Res = CD4051_COM4_X2_IN;

    return Res;
}

/*B36  RR DIFF LOCK*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_RR_DIFF_LOCK(void)
{
    LINE_IN_TriggerLevel_en_t Res = CD4051_COM4_X3_IN;

    return Res;
}

/*B38  WEAR IND*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_WEAR_IND(void)
{
    LINE_IN_TriggerLevel_en_t Res = CD4051_COM4_X7_IN;

    return Res;
}

/*ZH新增：2021.6.29*/

/*A06  ILLUMINATION*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_ILLUMINATION(void)
{
    LINE_IN_TriggerLevel_en_t Res = ILLUMINAION_MCU;

    return Res;
}

/*A10  RET_BLENDING*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_RET_BLENDING(void)
{
    LINE_IN_TriggerLevel_en_t Res = CD4051_COM3_X4_IN;

    return Res;
}

/*A21  BRAKE*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_BRAKE(void)
{
    LINE_IN_TriggerLevel_en_t Res = CD4051_COM1_X4_IN;

    return Res;
}

/*A26  TURN_R*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_TURN_R(void)
{
    LINE_IN_TriggerLevel_en_t Res = CD4051_COM2_X4_IN;

    return Res;
}

/*A27  TURN_L*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_TURN_L(void)
{
    LINE_IN_TriggerLevel_en_t Res = CD4051_COM2_X6_IN;

    return Res;
}

/*A33  ABS_DETECT*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_ABS_DETECT(void)
{
    LINE_IN_TriggerLevel_en_t Res = CD4051_COM2_X2_IN;

    return Res;
}

/*B01  PTO*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_PTO(void)
{
    LINE_IN_TriggerLevel_en_t Res = CD4051_COM6_X4_IN;

    return Res;
}

/*B05  GLOW*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_GLOW(void)
{
    LINE_IN_TriggerLevel_en_t Res = CD4051_COM6_X3_IN;

    return Res;
}

/*B06  TRAILER_CONNECT*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_TRAILER_CONNECT(void)
{
    LINE_IN_TriggerLevel_en_t Res = CD4051_COM6_X0_IN;

    return Res;
}

/*B32  LOW_COOLANT*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_LOW_COOLANT(void)
{
    LINE_IN_TriggerLevel_en_t Res = CD4051_COM5_X4_IN;

    return Res;
}

/*B39  ACC*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_ACC(void)
{
    LINE_IN_TriggerLevel_en_t Res = ACC_MCU_IN;

    return Res;
}

/*B40  WEAR2*/
LINE_IN_TriggerLevel_en_t LINE_IN_Get_WEAR2(void)
{
    LINE_IN_TriggerLevel_en_t Res = CD4051_COM4_X6_IN;

    return Res;
}

/*A23  PARK BRAKE*/
/*A25  HI BEAM*/
/*A28  BRAKE AIR/EBS*/
/*A30  SEAT BELT*/
/*A31  MIL*/
/*A32  ENG OIL*/
/*A34  CHARGE*/
/*B03  TRAILER ABS INFO*/
/*B14  Rr FOG LAMP*/
/*B15  ACC AIR*/
/*B30  AIR SUS*/
/*B31  TRAILER BRAKE*/
/*B33  TRAILER ABS*/
/*B36  RR DIFF LOCK*/
/*B38  WEAR IND*/

/*A06  ILLUMINATION*/
/*A10  RET_BLENDING*/
/*A21  BRAKE*/
/*A26  TURN_R*/
/*A27  TURN_L*/
/*A33  ABS_DETECT*/
/*B01  PTO*/
/*B05  GLOW*/
/*B06  TRAILER_CONNECT*/
/*B32  LOW_COOLANT*/
/*B39  ACC*/
/*B40  WEAR2*/