#include "GUI_VC66_Usually.h"
#include "GUI_VC66_General.h"
#include "Data_Voltmeter.h"
#include "CAN_Communication_Matrix.h"
#include "Individual_ECU_Comm.h"
#include "RTE_TIME.h"
//---------------------------------------------------------
//wangboyu 2021年8月3日15:26:38
//---------------------------------------------------------
//344 - 3.3多目的性显示区域
//---------------------------------------------------------
//平均油耗==平均车速==电压计==时段表/计时表==DPD
//---------------------------------------------------------


/*-------------------------------------------------------------------------
 * Function Name  : GUI_Display_AvrFuelCons
 * Description    : 平均油耗显示
 * Input          : 0 - TRIPA 平均油耗      1 - TRIPB 平均油耗
 * Output         : None
 * Return         : None
 * onther         : 3.3.2.1平均油耗／平均车速显示画面
--------------------------------------------------------------------------*/
static const uint16_t AVR_FUEL_CONS_TITLE[4u] = //平均油耗标题
{
    CN_Fty_Menu2_04pingjunyouhao ,
    CN_Fty_Menu2_04pingjunyouhao ,
    CN_Fty_Menu2_04pingjunyouhao , 
    CN_Fty_Menu2_04pingjunyouhao ,
};
static const uint16_t GUI_AXISX_AvrFuelCons[4u] = {665,643,610,588};
void GUI_Display_Usually_AvrFuelCons(uint8_t Type)
{
    uint32_t Value = 0 ;

    GUI_General_Display(MultiPurpose_Sprite, AVR_FUEL_CONS_TITLE[0], GUI_BLENDMODE_SRC_OVER);
    GUI_General_Display(MultiPurpose_Sprite, CN_Fty_Menu2_04pingjunyouhao_danwei, GUI_BLENDMODE_SRC_OVER);

    if(Type == 0)
    {
        Value = Get_ECU_Data(ID_TripA_AvrFuelCost) ;
    }
    else
    {
        Value = Get_ECU_Data(ID_TripB_AvrFuelCost) ;
    }

    if (CAN_MSG_Status(ID_CanMsg18EF1718_Msg_Count) == CAN_SIG_LOST)
    {
        GUI_General_Display(MultiPurpose_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);//清图
    }
    else 
    {
        if(Value > 999)
        {
            /*小数点显示*/
            GUI_Translate_Display(MultiPurpose_Sprite, Nb_20_dian,633,248,GUI_BLENDMODE_SRC_OVER);
            //'-'
            GUI_Translate_Display(MultiPurpose_Sprite, Nb_20_heng,GUI_AXISX_AvrFuelCons[0],248,GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MultiPurpose_Sprite, Nb_20_heng,GUI_AXISX_AvrFuelCons[1],248,GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MultiPurpose_Sprite, Nb_20_heng,GUI_AXISX_AvrFuelCons[2],248,GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MultiPurpose_Sprite, Nb_20_heng,GUI_AXISX_AvrFuelCons[3],248,GUI_BLENDMODE_SRC_OVER);

        }
        else
        {                
            /*小数点显示*/
            GUI_Translate_Display(MultiPurpose_Sprite, Nb_20_dian,633,248,GUI_BLENDMODE_SRC_OVER);
            /*数值显示*/
            GUI_General_Digit_Display(MultiPurpose_Sprite, Value, Nb_20_0, 4u, 0u, GUI_AXISX_AvrFuelCons, 228u, GUI_BLENDMODE_SRC_OVER);
        }
    }    
}
/*-------------------------------------------------------------------------
 * Function Name  : GUI_Display_AvrSpeed
 * Description    : 平均车速显示
 * Input          : 0 - TRIPA 平均车速      1 - TRIPB 平均车速
 * Output         : None
 * Return         : None
 * onther         : 3.3.2.1平均油耗／平均车速显示画面
 --------------------------------------------------------------------------*/
static const uint16_t AVR_SPEED_TITLE[4u] = //平均车速标题
{
    CN_Fty_Menu2_04pingjunchesu ,
    CN_Fty_Menu2_04pingjunchesu ,
    CN_Fty_Menu2_04pingjunchesu , 
    CN_Fty_Menu2_04pingjunchesu ,
};
static const uint16_t GUI_AXISX_AvrSpeed[4u] = {665,643,610,588}; 
void GUI_Display_Usually_AvrSpeed(uint8_t Type)
{
    uint32_t Value = 0 ;

    GUI_General_Display(MultiPurpose_Sprite, AVR_SPEED_TITLE[0], GUI_BLENDMODE_SRC_OVER);
    GUI_General_Display(MultiPurpose_Sprite, CN_Fty_Menu2_04pingjunchesu_danwei, GUI_BLENDMODE_SRC_OVER);

    if(Type == 0)
    {
        Value = Get_ECU_Data(ID_TripA_AvrSpeed) ;
    }
    else
    {
        Value = Get_ECU_Data(ID_TripB_AvrSpeed) ;
    }

    if (CAN_MSG_Status(ID_CanMsg18EF1718_Msg_Count) == CAN_SIG_LOST)
    {
        GUI_General_Display(MultiPurpose_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);//清图
    }
    else
    {
        if(Value > 240)
        {
            /*小数点显示*/
            GUI_Translate_Display(MultiPurpose_Sprite, Nb_20_dian,633,302,GUI_BLENDMODE_SRC_OVER);
            //'-'
            GUI_Translate_Display(MultiPurpose_Sprite, Nb_20_heng,GUI_AXISX_AvrSpeed[0],302,GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MultiPurpose_Sprite, Nb_20_heng,GUI_AXISX_AvrSpeed[1],302,GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MultiPurpose_Sprite, Nb_20_heng,GUI_AXISX_AvrSpeed[2],302,GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MultiPurpose_Sprite, Nb_20_heng,GUI_AXISX_AvrSpeed[3],302,GUI_BLENDMODE_SRC_OVER);
        }
        else
        {
            /*小数点显示*/
            GUI_Translate_Display(MultiPurpose_Sprite, Nb_20_dian,633,302,GUI_BLENDMODE_SRC_OVER);
            /*数值显示*/
            GUI_General_Digit_Display(MultiPurpose_Sprite, Value, Nb_20_0, 4u, 0u, GUI_AXISX_AvrSpeed, 282, GUI_BLENDMODE_SRC_OVER);
        }
    } 
}
 /*-------------------------------------------------------------------------
 * Function Name  : GUI_Display_VoltMeter
 * Description    : 电压计显示
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 3.3.2.2电压计显示画面
 --------------------------------------------------------------------------*/
static const uint16_t GUI_AXISX_VoltMeter[13u] = {536,553,570,588,605,623,640,657,675,692,710,727,745}; 
void GUI_Display_Usually_VoltMeter(void)
{
    uint8_t i = 0 ;
    GUI_General_Display(MultiPurpose_Sprite, CN_dianyaji_H, GUI_BLENDMODE_SRC_OVER);
    GUI_General_Display(MultiPurpose_Sprite, CN_dianyaji_kedu, GUI_BLENDMODE_SRC_OVER);
    GUI_General_Display(MultiPurpose_Sprite, CN_dianyaji_L, GUI_BLENDMODE_SRC_OVER);
    GUI_General_Display(MultiPurpose_Sprite, CN_dianyaji_tubiao, GUI_BLENDMODE_SRC_OVER);

    GUI_General_Display(MultiPurpose_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    
    if(Get_Voltmeter_Valid())
    {
        for(i = Gui_Get_Voltmeter_DisplayMode() ; i > 0 ;i --)
        {
            GUI_Translate_Display(MultiPurpose_Sprite,CN_dianyaji_zouge1,GUI_AXISX_VoltMeter[i - 1],276,GUI_BLENDMODE_SRC_OVER);
        } 
        if(Gui_Get_Voltmeter_DisplayMode() < 13u)
        {
            GUI_General_Display(MultiPurpose_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);//清图
        }      
    }
    else
    {
        GUI_General_Display(MultiPurpose_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);//清图
    }
}
/*-------------------------------------------------------------------------
 * Function Name  : GUI_Display_TimeTable
 * Description    : 时段表显示
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 3.3.2.4时段表
 --------------------------------------------------------------------------*/
static const uint16_t USUALLY_TimeTable_TITLE[4u] = //时段表标题
{
    CN_Time_wenzi ,
    CN_Time_wenzi ,
    CN_Time_wenzi , 
    CN_Time_wenzi ,
};
static const uint16_t GUI_AXISX_TimeTable[13u] = {729,697,676,655,634,613,592}; 
void GUI_Display_Usually_TimeTable(void)
{
    uint32_t Value = 0 ;
    Value = Get_ID_18FEE518_Sig_Total_Engine_Hours();

    GUI_General_Display(MultiPurpose_Sprite, USUALLY_TimeTable_TITLE[0], GUI_BLENDMODE_SRC_OVER);
    GUI_General_Display(MultiPurpose_Sprite, CN_Time_danwei, GUI_BLENDMODE_SRC_OVER);

    if (CAN_MSG_Status(ID_CanMsg18FEE518_Msg_Count) == CAN_SIG_LOST)
    {
        GUI_General_Display(MultiPurpose_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);//清图
    }
    else
    {
        if(Value > 0xFAFFFFFF)
        {//范围外
            //' - '
            GUI_Translate_Display(MultiPurpose_Sprite, Nb_20_heng,588,232,GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MultiPurpose_Sprite, Nb_20_heng,609,232,GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MultiPurpose_Sprite, Nb_20_heng,630,232,GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MultiPurpose_Sprite, Nb_20_heng,652,232,GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MultiPurpose_Sprite, Nb_20_heng,673,232,GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MultiPurpose_Sprite, Nb_20_heng,694,232,GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MultiPurpose_Sprite, Nb_20_dian,728,232,GUI_BLENDMODE_SRC_OVER);  
        }
        else
        {
            Value /= 2 ;//放大10倍
            if(Value > 9999999)
            {
                Value = 9999999 ;
            }
            /*小数点显示*/
            GUI_Translate_Display(MultiPurpose_Sprite, Nb_20_dian,719,241,GUI_BLENDMODE_SRC_OVER);
            /*数值显示*/
            GUI_General_Digit_Display(MultiPurpose_Sprite, Value, Nb_20_0, 7u, 5u, GUI_AXISX_TimeTable, 221, GUI_BLENDMODE_SRC_OVER);
        }
    }  
}
/*-------------------------------------------------------------------------
 * Function Name  : GUI_Display_Usually_Calendar
 * Description    : 日历显示
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 3.3.2.5日期／时钟显示的画面
 --------------------------------------------------------------------------*/

#define GUI_AXISY_CALENDAR      243
#define GUI_AXISY_TIME          279

#define GUI_AXISX_TIME_COLON    592
#define GUI_AXISY_TIME_COLON    282


static const uint16_t USUALLY_CALENDAR_YEAR[4u] = //年
{
    CN_nian ,
    CN_nian ,
    CN_nian , 
    CN_nian ,
};
static const uint16_t GUI_AXISX_YEAR[4u] = {495,477,459,441}; 
static const uint16_t USUALLY_CALENDAR_MONTH[4u] = //月
{
    CN_yue ,
    CN_yue ,
    CN_yue , 
    CN_yue ,
};
static const uint16_t GUI_AXISX_MONTH[2u] = {572,554}; 
static const uint16_t USUALLY_CALENDAR_DAY[4u] = //日
{
    CN_ri  ,
    CN_ri  ,
    CN_ri  , 
    CN_ri  ,
};
static const uint16_t GUI_AXISX_DAY[2u] = {648,630}; 

static const uint16_t GUI_AXISX_HOUR[2u] = {578,560}; 

static const uint16_t GUI_AXISX_MINUTE[2u] = {623,605}; 

static const uint16_t USUALLY_CALENDAR_WEEK[7u] = //星期
{
    CN_Mon  ,
    CN_Tue  ,
    CN_Wed  , 
    CN_Thu  ,
    CN_Fri  ,
    CN_Sat  ,
    CN_Sun  ,
};

void GUI_Display_Usually_Calendar(void)
{
    uint8_t Type = 0 ;
    uint8_t Valid = 0 ;
    uint16_t Year = 0 ; 
    uint16_t Month = 0 ;
    uint16_t Day = 0 ;
    uint16_t Hour = 0 ;
    uint16_t Minute = 0 ;
    uint16_t Week = 0 ;

    Year = 2000+ Get_RTC_YEAR() ;
    Month = Get_RTC_MONTH() ;
    Day = Get_RTC_DATE();
    Hour = Get_RTC_HOUR();
    Minute = Get_RTC_MINUTE() ;
    Week = Get_RTC_WEEK();

    if( (Month >= 1)&&(Month <= 12)&&(Day >= 1)&&(Day <= 31)&&(Hour <= 24)&&(Minute <= 60)&&(Week >= 1)&&(Week <= 7) )
    {
        Valid = 1 ;
    }
    else
    {
        Valid = 0 ;
    }

    if(Valid)
    {
        if(Type)
        {
            GUI_General_Display(MultiPurpose_Sprite, CN_AM, GUI_BLENDMODE_SRC_OVER);//AM
        }
        else
        {
            GUI_General_Display(MultiPurpose_Sprite, CN_PM, GUI_BLENDMODE_SRC_OVER);//PM
        }
               
        GUI_General_Digit_Display(MultiPurpose_Sprite, Year, Nb_17_0, 4u, 0u, GUI_AXISX_YEAR, GUI_AXISY_CALENDAR, GUI_BLENDMODE_SRC_OVER);
        GUI_General_Display(MultiPurpose_Sprite, USUALLY_CALENDAR_YEAR[0], GUI_BLENDMODE_SRC_OVER);//'年'

        GUI_General_Digit_Display(MultiPurpose_Sprite, Month, Nb_17_0, 2u, 0u, GUI_AXISX_MONTH, GUI_AXISY_CALENDAR, GUI_BLENDMODE_SRC_OVER);
        GUI_General_Display(MultiPurpose_Sprite, USUALLY_CALENDAR_MONTH[0], GUI_BLENDMODE_SRC_OVER);//'月'

        GUI_General_Digit_Display(MultiPurpose_Sprite, Day, Nb_17_0, 2u, 0u, GUI_AXISX_DAY, GUI_AXISY_CALENDAR, GUI_BLENDMODE_SRC_OVER);
        GUI_General_Display(MultiPurpose_Sprite, USUALLY_CALENDAR_DAY[0], GUI_BLENDMODE_SRC_OVER);//'日'

        GUI_General_Display(MultiPurpose_Sprite, CN_kuohao, GUI_BLENDMODE_SRC_OVER);//'()'

        GUI_General_Display(MultiPurpose_Sprite, USUALLY_CALENDAR_WEEK[Week - 1], GUI_BLENDMODE_SRC_OVER);
        

        //小时
        GUI_General_Digit_Display(MultiPurpose_Sprite, Hour, Nb_17_0, 2u, 0u, GUI_AXISX_HOUR, GUI_AXISY_TIME, GUI_BLENDMODE_SRC_OVER);
        //':'
        GUI_Translate_Display(MultiPurpose_Sprite, Nb_17_maohao,GUI_AXISX_TIME_COLON,GUI_AXISY_TIME_COLON,GUI_BLENDMODE_SRC_OVER);
        //分钟
        GUI_General_Digit_Display(MultiPurpose_Sprite, Minute, Nb_17_0, 2u, 0u, GUI_AXISX_MINUTE, GUI_AXISY_TIME, GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MultiPurpose_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);//清图
    }

}
 /*-------------------------------------------------------------------------
 * Function Name  : GUI_Display_DPD
 * Description    : DPD显示
 * Input          : 0 - 堆积量  1 - 再生进度
 * Output         : None
 * Return         : None
 * onther         : 3.3.2.3DPD堆积量／再生进度显示画面
 --------------------------------------------------------------------------*/
static const uint16_t USUALLY_DPD_GRID[5u] = 
{
    CN_DPD_zouge1,
    CN_DPD_zouge2,
    CN_DPD_zouge3,
    CN_DPD_zouge4,
    CN_DPD_zouge5,
};

void GUI_Display_Usually_DPD(uint8_t Type)
{
    uint8_t i = 0 ;
    if(Type == 0)
    {
        GUI_General_Display(MultiPurpose_Sprite, CN_DPD_duijiliang, GUI_BLENDMODE_SRC_OVER);//DPD堆积量
    }
    else
    {
        GUI_General_Display(MultiPurpose_Sprite, CN_DPD_zaishengjindu, GUI_BLENDMODE_SRC_OVER);//DPD再生进度
    }
    
    GUI_General_Display(MultiPurpose_Sprite, CN_DPD_H, GUI_BLENDMODE_SRC_OVER);//'H'
    GUI_General_Display(MultiPurpose_Sprite, CN_DPD_L, GUI_BLENDMODE_SRC_OVER);//'L'

    GUI_General_Display(MultiPurpose_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);//清图
    for(i = 0 ;i < 5 ;i ++)
    {
        GUI_General_Display(MultiPurpose_Sprite, USUALLY_DPD_GRID[i], GUI_BLENDMODE_SRC_OVER);
    }
}


