#include "Data_EngineSpeed.h"
#include "CAN_Communication_Matrix.h"
#include "GaugesInterface.h"
#include "RTE_PWM_OUT.h"
//-------------------------------------------
//转速数据处理 wangboyu
//-------------------------------------------
//断码显示
//-------------------------------------------
//342 - 3.2.	行驶记录仪
//-------------------------------------------

static struct
{
	uint16_t Value ;
	uint16_t Valid ;
	uint8_t CurSeg ;
}TachoVariable ;

static uint8_t CalTacho_CurSeg(uint8_t Valid,uint16_t Value);
/*-------------------------------------------------------------------------
 * Function Name  : Tacho_KL30_Init
 * Description    : 转速KL30初始化
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Tacho_KL30_Init(void)
{
	TachoVariable.Value = 0 ;
	TachoVariable.Valid = 0 ;
	TachoVariable.CurSeg = 0 ;
}
void Tacho_KL15_ON_Init(void)
{
	TachoVariable.Value = 0 ;
	TachoVariable.Valid = 0 ;
	TachoVariable.CurSeg = 0 ;
}
void Tacho_KL15_OFF_Init(void)
{
	TachoVariable.Value = 0 ;
	TachoVariable.Valid = 0 ;
	TachoVariable.CurSeg = 0 ;
}
void Tacho_Wakeup_Init(void)
{
	TachoVariable.Value = 0 ;
	TachoVariable.Valid = 0 ;
	TachoVariable.CurSeg = 0 ;
}
void Tacho_Sleep_Init(void)
{
	TachoVariable.Value = 0 ;
	TachoVariable.Valid = 0 ;
	TachoVariable.CurSeg = 0 ;
}
/*-------------------------------------------------------------------------
 * Function Name  : Tacho_Processing_Service
 * Description    : 转速
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Tacho_Processing_Service(void)
{
	uint16_t Msg_Epm_nEng = 0 ;
	uint32_t u32Result = 0 ;
	uint16_t Fre = 0 ;

	Msg_Epm_nEng = Get_ID_CF00400_Sig_Engine_speed();
	
	TachoVariable.Valid = 0 ;
	if(Msg_Epm_nEng > 0xFAFF)
	{//abnormal
		u32Result = 0 ;
	}
	else if(Msg_Epm_nEng > 0x5DC0)
	{
		u32Result = 3000u ;
	}
	else
	{
		TachoVariable.Valid = 1 ;
		u32Result = Msg_Epm_nEng ;
		u32Result *= 125u ; 
		u32Result += 500u ;
		u32Result /= 1000u ;
	}
	
	if(u32Result > 3000u)
	{
		u32Result = 3000u ;
	}
	

	TachoVariable.Value = RevSpeedManage((uint16_t)u32Result);

	TachoVariable.CurSeg = CalTacho_CurSeg(TachoVariable.Valid,TachoVariable.Value);

	//转*每转脉冲数/60=频率

	u32Result *= 4 ;
	u32Result /= 60 ;

	Fre = (uint16_t)u32Result ;

	RTE_PWM_Set_Tacho_Out(Fre,500) ;
	

}
/*-------------------------------------------------------------------------
 * Function Name  : Tacho_Display
 * Description    : 计算转速当前格
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
static uint8_t CalTacho_CurSeg(uint8_t Valid,uint16_t Value)
{
	uint8_t u8Result = 0u;

	if(Valid)
	{	
		
	}
	else
	{
		//范围外/CAN中断
	}
	SetGaugesPara(RevGauges,Value);	
	u8Result = GetGaugesCurrentPos(RevGauges) ;

	return u8Result ;
}
/*-------------------------------------------------------------------------
 * Function Name  : Tacho_Get_ActualValue
 * Description    : 1倍转速
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
uint16_t Tacho_Get_ActualValue(void)
{
    uint16_t u16Result = 0u;
	u16Result = TachoVariable.Value ;
    return u16Result;
}
/*-------------------------------------------------------------------------
 * Function Name  : Tacho_Get_Valid
 * Description    : 
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
uint8_t Tacho_Get_Valid(void)
{
    uint8_t u8Result = 0u;
	u8Result = TachoVariable.Valid ;
    return u8Result;
}
/*-------------------------------------------------------------------------
 * Function Name  : Tacho_Get_CurSeg
 * Description    : 转速当前格
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 应用于断码
 --------------------------------------------------------------------------*/
uint8_t Tacho_Get_CurSeg(void)
{
	return TachoVariable.CurSeg ;
}




