#ifndef _BGLINTERFACE_H
#define _BGLINTERFACE_H
#define uint8_t unsigned char 
#define uint16_t unsigned short/*3360 324*/ 
/*#define uint16_t unsigned int*/ /*Freesecale */
/*#define uint32_t unsigned long*//*Freesecale */
#define uint32_t unsigned int
#define COLOR_LED_DEBUG 0u
/*占空比最大值*/
#define BACKLIGHTCYCLE 721u
#define NTC_AD_MAX 4096u
/*有小灯背光降到当前显示等级的百分比*/
#define POSITION_LIGHT_PERCENT 50u

enum {
    BL_TYPE_DAY,
    BL_TYPE_EVENING,
    BL_TYPE_NIGHT,
    BL_TYPE_TOTAL,
};
enum {
    BL_THEME_RED,
    BL_THEME_BLUE,
    BL_THEME_WHITE,
    BL_THEME_TOTAL,
};
enum {
    BL_LV_MIN = 0u,
    BL_LV_1,
    BL_LV_2,
    BL_LV_3,
    BL_LV_4,
    BL_LV_5,
    BL_LV_6,
    BL_LV_7,
    BL_LV_8,
    BL_LV_9,
    BL_LV_10,
    BL_LV_11,
    BL_LV_12,
    BL_LV_13,
    BL_LV_14,
    BL_LV_15,
    BL_LV_MAX,
    BL_LV_TOTAL,
};

extern void  BGLPwm_Config(uint8_t BGLType,  uint16_t DutyVal);
extern void BGLPwm_Stop(uint8_t BGLType);
extern void BGLPwm_Start(uint8_t BGLType);
/*以下主函数调用*/
/*得到主题模式可自己在枚举中定义 在BackGroundLight.c里填表*/
extern void GetBGLTheme(uint8_t BGLTheme);
/*得到工作模式 白天 傍晚 夜晚 在枚举中已定义*/
extern void GetBGLType(uint8_t BGLType);
/*得到背光等级 可自己在枚举中定义 在BackGroundLight.c里填表*/
extern void  GetBGLLvl(uint8_t BGLLvl,uint8_t FunPositionLight);
/*小灯暗级处理*/
uint8_t  ProcessLittleLight(uint8_t BGLLvl);
/*得到热敏电阻电压参数为100倍电压值*/
extern void GetBGLNTCVol(uint16_t BGLNTCVol);
/*主函数中调用第一个参数电源状态 1是 ON档 2 off 第二个参数 唤醒条件 1是TTF唤醒 2 是表盘唤醒 3 是表盘和屏都有唤醒，0无唤醒*/
extern void BackLightSchedu(uint8_t BGLPowerSt,uint8_t WakeFlag);
/*定时函数中调用 1ms函数中调用 TimeX 填1u*/
extern void BackLightDamp(uint8_t TimeX);
/*调试用*/
#if COLOR_LED_DEBUG
extern void  DebugBGLPara(void);
extern void  SetTFTDebugPara(uint16_t TestTFTDuty);
extern void  SetGaugesDebugPara(uint16_t TestGaugesDuty);
extern void  SetRDebugPara(uint16_t TestRDuty);
extern void  SetGDebugPara(uint16_t TestGDuty);
extern void  SetBDebugPara(uint16_t TestBDuty);
#endif

extern void  BGTask(void);
extern uint8_t BackLightTestWakeFlag;
#endif
