

#ifndef _SOUND_SOURCE_H_
#define _SOUND_SOURCE_H_

#include "TYW_stdint.h"
//#include "PCM_Sound_Tracks.h"
//#include "Sound_Tracks.h"
#include "Buzzer.h"
/******************************************************************************
音源名称列表

注意：音源名称所指代的序号应与该声音位于声音属性表中的序号一一对应
******************************************************************************/
typedef enum
{
    SND_SRC_Key_Notremoved = 0x00  , /*00 忘拔钥匙        */
    SND_SRC_LDWS            ,        /*   车道偏离*/
    SND_SRC_Collision_L1    ,        /*   一级碰撞预警 长鸣*/
    SND_SRC_Collision_L2    ,        /*   二级碰撞预警 4HZ*/
    SND_SRC_Collision_L3    ,        /*   三级碰撞预警 2HZ*/
    SND_SRC_Braking         ,        /*01 制动           */
    SND_SRC_Air_Brake       ,        /*02 制动气压        */
    SND_SRC_BRAKE_LOCK      ,        /*03 BRAKE LOCK     */
    SND_SRC_Parking_Brake   ,        /*04 停车制动忘记复位  */
    SND_SRC_Car_Dump_SPEED  ,        /*05 车厢报警自卸蜂鸣器*/
    SND_SRC_Temp_High       ,        /*06 水温过热         */
    SND_SRC_Coolant_Low     ,        /*07 冷却水量         */
    SND_SRC_Oil_pressure_Low,        /*08 -(预留：油压)     */
    SND_SRC_ACC_AIR         ,        /*09 ACC AIR         */
    SND_SRC_BackUP_SPEED    ,        /*10 倒车警报         */
    SND_SRC_DS_SPEED        ,        /*11 DS 警报          */
    SND_SRC_ROWS_SPEED      ,        /*12 ROWS 警报        */
    SND_SRC_Roll_SPEED      ,        /*13 Roll 警报        */
    SND_SRC_EVSC_SPEED      ,        /*14 EVSC             */
    SND_SRC_DPD_SPEED1      ,        /*15 DPD 手动再生      */
    SND_SRC_DPD_SPEED2      ,        /*15 DPD 手动再生      */
    SND_SRC_DPD_SPEED4      ,        /*15 DPD 手动再生      */
    SND_SRC_NEES            ,        /*16 NEES             */
    SND_SRC_ECO_STOP        ,        /*17 eco stop         */
    SND_SRC_Cyclone_High4HZ ,        /*18 气悬车高调整       */
    SND_SRC_Cyclone_High0_5 ,        /*18 气悬车高调整       */
    SND_SRC_SEATBELT_SPEED  ,        /*19 安全带            */
    SND_SRC_Fuel_Saving     ,        /*20 省油耗建议         */
    SND_SRC_TICK            ,        /*21 转向              */
    SND_SRC_TOCK            ,        /*22 转向              */

    SND_SRC_INDEX_MAX,
} SND_SRC_Index_en_t;

/******************************************************************************
伪音源名称列表
******************************************************************************/
#define   SND_SRC_NONE                      0xFF    //没有声音
#define   SND_SRC_CURRENT                   0xFE    //当前播放的声音

/******************************************************************************
音源循环次数
******************************************************************************/
#define   SND_CYCLE_NONSTOP                 0xFF    //不停播放

/******************************************************************************
音源播放模式
******************************************************************************/
#define   SND_MODE_SINGLE                   0x00    //使用ISD_Play_Vp方法播放
#define   SND_MODE_LOOP                     0x01    //使用ISD_Play_Vp_Loop方法播放

/******************************************************************************
声音属性结构
******************************************************************************/
typedef struct
{
    uint8_t   Index;
    uint8_t   Priority;
    uint8_t   Cycle;
    uint8_t   Mode;
    uint16_t  Period;
} SndAttributeStruct;

/******************************************************************************
音源属性表
******************************************************************************/
static const SndAttributeStruct SndAttributeTable[SND_SRC_INDEX_MAX] =
{
    /*================================================================================================
                  音源名称            | 音源序号      | 优先级 |     循环次数     |    播放模式    | 周期(ms)
    ------------------------------------------------------------------------------------------------*/
    {/*00 SND_SRC_Key_Notremoved  */  0x03u,    1,   SND_CYCLE_NONSTOP,  SND_MODE_SINGLE,   1000u,   },/*00 1HZ 4 忘拔钥匙    */
    {/*00 SND_SRC_LDWS            */  0x10u,    1,   SND_CYCLE_NONSTOP,  SND_MODE_SINGLE,    333u,   },
    {/*00 SND_SRC_Collision_L1    */  0x0Fu,    0,   SND_CYCLE_NONSTOP,  SND_MODE_LOOP,        0u,   },
    {/*00 SND_SRC_Collision_L2    */  0x10u,    0,   SND_CYCLE_NONSTOP,  SND_MODE_SINGLE,    250u,   },
    {/*00 SND_SRC_Collision_L3    */  0x11u,    0,   SND_CYCLE_NONSTOP,  SND_MODE_SINGLE,    500u,   },
    {/*01 SND_SRC_Braking         */  0x00u,    2,   SND_CYCLE_NONSTOP,  SND_MODE_SINGLE,   1000u,   },/*01 连续 1 制动       */
    {/*02 SND_SRC_Air_Brake       */  0x01u,    3,   SND_CYCLE_NONSTOP,  SND_MODE_SINGLE,   1000u,   },/*02 连续 2 制动气压    */
    {/*03 SND_SRC_BRAKE_LOCK      */  0x04u,    4,   SND_CYCLE_NONSTOP,  SND_MODE_SINGLE,   1000u,   },/*03       BRAKE LOCK */
    {/*04 SND_SRC_Parking_Brake   */  0x05u,    5,   SND_CYCLE_NONSTOP,  SND_MODE_SINGLE,   1000u,   },/*04       停车制动忘记复位*/
    {/*05 SND_SRC_Car_Dump_SPEED  */  0x06u,    6,   SND_CYCLE_NONSTOP,  SND_MODE_SINGLE,   1000u,   },/*05       车厢报警自卸蜂鸣器*/
    {/*06 SND_SRC_Temp_High       */  0x01u,    7,   SND_CYCLE_NONSTOP,  SND_MODE_SINGLE,   1000u,   },/*06 连续 2 水温过热 */
    {/*07 SND_SRC_Coolant_Low     */  0x01u,    8,   SND_CYCLE_NONSTOP,  SND_MODE_SINGLE,   1000u,   },/*07 连续 1 冷却水量 */
    {/*08 SND_SRC_Oil_pressure_Low*/  0x00u,    9,   SND_CYCLE_NONSTOP,  SND_MODE_SINGLE,   1000u,   },/*08      -(预留：油压)*/
    {/*09 SND_SRC_ACC_AIR         */  0x01u,   10,   SND_CYCLE_NONSTOP,  SND_MODE_SINGLE,   1000u,   },/*09 连续 2 ACC AIR */
    {/*10 SND_SRC_BackUP_SPEED    */  0x04u,   11,   SND_CYCLE_NONSTOP,  SND_MODE_SINGLE,   1000u,   },/*10 1HZ 5 倒车警报  */
    {/*11 SND_SRC_DS_SPEED        */  0x00u,   12,   SND_CYCLE_NONSTOP,  SND_MODE_SINGLE,   1000u,   },/*11       DS 警报   */
    {/*12 SND_SRC_ROWS_SPEED      */  0x00u,   13,   SND_CYCLE_NONSTOP,  SND_MODE_SINGLE,   1000u,   },/*12       ROWS 警报 */
    {/*13 SND_SRC_Roll_SPEED      */  0x00u,   14,   SND_CYCLE_NONSTOP,  SND_MODE_SINGLE,   1000u,   },/*13       Roll 警报 */
    {/*14 SND_SRC_EVSC_SPEED      */  0x01u,   15,   SND_CYCLE_NONSTOP,  SND_MODE_LOOP  ,    250u,   },/*14 4HZ 2 EVSC */
    {/*15 SND_SRC_DPD_SPEED       */  0x03u,   16,                   3,  SND_MODE_SINGLE,   1000u,   },/*15 1HZ 4 DPD 手动再生 */
    {/*15 SND_SRC_DPD_SPEED       */  0x03u,   16,                   3,  SND_MODE_SINGLE,    500u,   },/*15 2HZ 4 DPD 手动再生 */
    {/*15 SND_SRC_DPD_SPEED       */  0x03u,   16,                   3,  SND_MODE_SINGLE,    250u,   },/*15 4HZ 4 DPD 手动再生 */
    {/*16 SND_SRC_NEES            */  0x00u,   17,   SND_CYCLE_NONSTOP,  SND_MODE_SINGLE,   1000u,   },/*16       NEES */
    {/*17 SND_SRC_ECO_STOP        */  0x00u,   18,   SND_CYCLE_NONSTOP,  SND_MODE_SINGLE,   1000u,   },/*17       eco stop */
    {/*18 SND_SRC_Cyclone_High    */  0x03u,   19,   SND_CYCLE_NONSTOP,  SND_MODE_LOOP  ,    250u,   },/*18 4HZ   4 气悬车高调整 */
    {/*18 SND_SRC_Cyclone_High    */  0x03u,   19,   SND_CYCLE_NONSTOP,  SND_MODE_SINGLE,   2000u,   },/*18 0.5HZ 4 气悬车高调整 */
    {/*19 SND_SRC_SEATBELT_SPEED  */  0x02u,   20,   SND_CYCLE_NONSTOP,  SND_MODE_SINGLE,    500u,   },/*19 2HZ   3 安全带 */
    {/*20 SND_SRC_Fuel_Saving     */  0x03u,   21,   SND_CYCLE_NONSTOP,  SND_MODE_SINGLE,   1000u,   },/*20 1HZ   4 省油耗建议 */
    {/*21 SND_SRC_TICK            */  0x0Du,   22,                   1,  SND_MODE_SINGLE,    100u,   },
    {/*22 SND_SRC_TOCK            */  0x0Eu,   23,                   1,  SND_MODE_SINGLE,    100u,   },

    /*==============================================================================================*/
};



#define   SND_TOTAL_NUM              SND_SRC_INDEX_MAX//       (sizeof(SndAttributeTable) / sizeof(SndAttributeStruct))

#endif
