#include "Services_Interval.h"


/*该服务函数首次KL30是调用一次*/
void Data_Interval_KL30_Init(_DataInterVal *m_para1, _DataInputInterVal *m_para2)
{
    Data_Interval_Para.Sig.First_Flag = m_para1->Sig.First_Flag;/*0*/
    Data_Interval_Para.Sig.First_Interval = m_para1->Sig.First_Interval;/*5000km*/
    Data_Interval_Para.Sig.Second_Interval = m_para1->Sig.Second_Interval;/*7500km*/
    Data_Interval_Para.Sig.Timer_Interval = m_para1->Sig.Timer_Interval;/* 180*24*60*60*10  0.1s */
    Data_Interval_Para.Sig.DIM_KM = m_para1->Sig.DIM_KM;    /* DIM ODO */
    Data_Interval_Para.Sig.DIM_Timer = m_para1->Sig.DIM_Timer;/* DIM Timer */

    Data_Interval_Para.Sig.Servicekm = m_para1->Sig.Servicekm; /* Cur odo */
    Data_Interval_Para.Sig.ServiceTimer = m_para1->Sig.ServiceTimer; /* Cur timer */

    Data_Input_InterVal.PowerSts = m_para2->PowerSts;
}
/* 保养里程服务之前调用 */
void Data_Interval_KMSet(uint32_t CurTotalODO, uint8_t m_IG)
{
    Data_Interval_Para.Sig.Servicekm = CurTotalODO;
    Data_Input_InterVal.PowerSts = m_IG;
}
/* 100ms中断调用 */
void Data_Interval_TimerISR(void)
{
    if (Data_Interval_Para.Sig.ServiceTimer <= 0x1FFFFFFFul)
    {
        Data_Interval_Para.Sig.ServiceTimer++;
    }

}
/* Sleep之后停止计时  唤醒后 把这一阶段的时间差补正回来 */
void Data_Interval_TimerSleepFix(uint32_t FixTimer)
{
    if (Data_Interval_Para.Sig.ServiceTimer <= 0x1FFFFFFFul)
    {
        Data_Interval_Para.Sig.ServiceTimer += FixTimer;
    }
}

/******************************************************************************
函数名：Data_Service_Interval_Processing
功  能: 剩余保养里程处理
参  数: 无
返回值：无
******************************************************************************/
void Data_Service_Interval_Processing(void)
{
    if (Data_Input_InterVal.PowerSts == Services_PowerON)
    {
        if ((Data_Interval_Para.Sig.DIM_KM >= Data_Interval_Para.Sig.Servicekm) || \
                (Data_Interval_Para.Sig.DIM_Timer >= Data_Interval_Para.Sig.ServiceTimer))
        {
            if (Data_Interval_Para.Sig.DIM_KM >= Data_Interval_Para.Sig.Servicekm)
            {
                Servicekm = Data_Interval_Para.Sig.DIM_KM - Data_Interval_Para.Sig.Servicekm;
            }
            else
            {
                Servicekm = 0u;
            }

            if (Data_Interval_Para.Sig.DIM_Timer >= Data_Interval_Para.Sig.ServiceTimer)
            {
                ServiceTimer = Data_Interval_Para.Sig.DIM_Timer - Data_Interval_Para.Sig.ServiceTimer;
            }
            else
            {
                ServiceTimer = 0u;
            }
            if (Servicekm == 0u)
            {
                ServiceTimer = 0u;
            }
            if (ServiceTimer == 0u)
            {
                Servicekm = 0u;
            }
            Data_Service_Interval_Save_Call(&Data_Interval_Para, Services_NOForceSave);
        }
        else
        {
            Servicekm = 0u;
            ServiceTimer = 0u;
        }
    }
}


/******************************************************************************
函数名：Data_Service_Interval_Reset
功  能: 重置保养里程的目标里程,1是5000km;0是10000km
******************************************************************************/
void Data_Service_Interval_OverWriteDIM(uint8_t m_DIR)
{
    if (Data_Interval_Para.Sig.First_Flag == Services_FirstFlag)
    {
        if (m_DIR == 1u)
        {
            Data_Interval_Para.Sig.DIM_KM = 50000ul; /* DIM ODO */
        }
        else
        {
            Data_Interval_Para.Sig.DIM_KM = 100000ul; /* DIM ODO */
        }
        Data_Service_Interval_Save_Call(&Data_Interval_Para, Services_ForceSave);
    }
}


/******************************************************************************
函数名：Data_Service_Interval_Reset
功  能: 重置保养里程
******************************************************************************/
void Data_Service_Interval_Reset(_DataInterVal *m_para1, uint32_t m_CurODO)
{
    Data_Interval_Para.Sig.First_Flag = m_para1->Sig.First_Flag;/*0*/
    Data_Interval_Para.Sig.First_Interval = m_para1->Sig.First_Interval;/*5000km*/
    Data_Interval_Para.Sig.Second_Interval = m_para1->Sig.Second_Interval;/*7500km*/
    Data_Interval_Para.Sig.Timer_Interval = m_para1->Sig.Timer_Interval;/* 180*24*60*60*10  0.1s */
    if (Data_Interval_Para.Sig.First_Flag == Services_FirstFlag)
    {
        Data_Interval_Para.Sig.DIM_KM = Data_Interval_Para.Sig.First_Interval + m_CurODO; /* DIM ODO */
    }
    else
    {
        Data_Interval_Para.Sig.DIM_KM = Data_Interval_Para.Sig.Second_Interval + m_CurODO;  /* DIM ODO */
    }
    Data_Interval_Para.Sig.DIM_Timer = Data_Interval_Para.Sig.Timer_Interval;/* DIM Timer */

    Data_Interval_Para.Sig.Servicekm = m_CurODO; /* Cur odo */
    Data_Interval_Para.Sig.ServiceTimer = 0u; /* Cur timer */

    Data_Service_Interval_Save_Call(&Data_Interval_Para, Services_ForceSave);
}
/******************************************************************************
函数名：Get_IntervalKM
功  能: 获得保养里程
******************************************************************************/
uint32_t Get_IntervalKM(void)
{
    return Servicekm;/*87606-3*/
}
/******************************************************************************
函数名：Get_IntervalTime
功  能: 获得保养里程
******************************************************************************/
uint32_t Get_IntervalTime(void)
{
    return ServiceTimer;
}
/*
修改保养里程逻辑,内部不再判断报警信号
重置里程参数全靠外部传入
*/

uint16_t Read_Interval_Version(void)
{
    return 0x0003u;
}