#include "UDS_31Service_Main.h"

/**
  *31服务函数入口
  *@param A_TA_type 收到数据的地址
  *@param A_Length 收到数据的长度
  *@param A_Data 收到数据的数据
  */
void UDS_Service_31_Indication(uint32_t A_TA_type, uint16_t A_Length, uint8_t A_Data[])
{
    uint8_t NRC = positiveResponse;
    setDiagMSG(A_TA_type, A_Length, A_Data);
    if(NRC == positiveResponse)
    {
        NRC = UDS_31Service_NRC11();                                            /*31服务是否支持功能寻址*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_31Service_NRC7F();                                            /*31服务会话是否支持验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_31Service_Sub_NRC12();                                        /*31服务子功能是否支持验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_31Service_Sub_NRC7E();                                        /*31服务子功能会话是否支持验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_31Service_NRC31();                                           /*31服务能超出请求范围验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_31Service_Sub_NRC13_TotalLengthCheck();                       /*31服务子功能总长度长度验证-----------没完事*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_31Service_NRC33();                                            /*31服务解锁等级验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_31Service_NRC22();                                            /*31服务条件验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_31Service_Sub_NRC24();                                        /*31服务子功能请求顺序验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_31Service_Sub_NRC31();                                        /*31服务子功能超出请求范围验证*/
    }
    if(NRC == positiveResponse)
    {
        UDS_31Service_Sub();                                                    /*31服务子功能判断*/
    }
    clearDiagMSG();                                                             /*清除诊断信息*/
}

/**
  *31服务子功能
  */
void UDS_31Service_Sub(void)
{
    uint8_t NRC = positiveResponse;
    /*if(NRC == positiveResponse)
    {
        NRC = UDS_31Service_Sub_NRC13_MinLengthCheck();                         /*31服务子功能最小长度验证*/
    /*}
    if(NRC == positiveResponse)
    {
        NRC = UDS_31Service_Sub_NRC12();                                        /*31服务子功能是否支持验证*/
    /*}
    if(NRC == positiveResponse)
    {
        NRC = UDS_31Service_Sub_NRC7E();                                        /*31服务子功能会话是否支持验证*/
    /*}
    if(NRC == positiveResponse)
    {
        NRC = UDS_31Service_Sub_NRC31();                                        /*31服务子功能超出请求范围验证*/
    /*}
    if(NRC == positiveResponse)
    {
        NRC = UDS_31Service_Sub_NRC13_TotalLengthCheck();                       /*31服务子功能总长度长度验证*/
    /*}
    if(NRC == positiveResponse)
    {
        NRC = UDS_31Service_Sub_NRC24();                                        /*31服务子功能请求顺序验证*/
    /*}
    if(NRC == positiveResponse)
    {
        NRC = UDS_31Service_Sub_NRC22();                                        /*31服务子功能条件验证*/
    /*}*/
    if(NRC == positiveResponse)
    {
        switch(DiagMSG.msgData.SidDetail.SubID)                                 /*子服务判断*/
        {
        case startRoutine:
            UDS_31Service_Sub01();                                              /*31服务01子功能*/
            break;
        case stopRoutine:
            UDS_31Service_Sub02();                                              /*31服务02子功能*/
            break;
        case requestRoutineResults:
            UDS_31Service_Sub03();                                              /*31服务03子功能*/
            break;
        default:
            break;
        }
    }
}

/**
  *31服务01子功能
  */
void UDS_31Service_Sub01(void)
{
    switch(getDID(DiagMSG.msgData.S31Detail.DID_H, DiagMSG.msgData.S31Detail.DID_L))/*31服务DID判断*/
    {
    case CheckIndicator:
        UDS_31Service_Sub01_DID_C004();                         /*指示灯检测*/
        break;
    case CheckPointer:
        UDS_31Service_Sub01_DID_C005();                         /*指针检测*/
        break;
    case ActiveIC:
        UDS_31Service_Sub01_DID_C014();                         /*仪表激活*/
        break;
    default:
        break;
    }
}

/**
  *31服务02子功能
  */
void UDS_31Service_Sub02(void)
{
    switch(getDID(DiagMSG.msgData.S31Detail.DID_H, DiagMSG.msgData.S31Detail.DID_L))/*31服务DID判断*/
    {
    case CheckIndicator:
        UDS_31Service_Sub02_DID_C004();                         /*指示灯检测*/
        break;
    case CheckPointer:
        UDS_31Service_Sub02_DID_C005();                         /*指针检测*/
        break;
    default:
        break;
    }
}

/**
  *31服务03子功能
  */
void UDS_31Service_Sub03(void)
{
    switch(getDID(DiagMSG.msgData.S31Detail.DID_H, DiagMSG.msgData.S31Detail.DID_L))/*31服务DID判断*/
    {
    case CheckIndicator:
        UDS_31Service_Sub03_DID_C004();                         /*指示灯检测*/
        break;
    case CheckPointer:
        UDS_31Service_Sub03_DID_C005();                         /*指针检测*/
        break;
    case ActiveIC:
        UDS_31Service_Sub03_DID_C014();                         /*仪表激活*/
        break;
    default:
        break;
    }
}

/**
  *31服务01子功能DIDC004
  *指示灯检测
  */
 /*87607-16*/
void UDS_31Service_Sub01_DID_C004(void)
{
    IndicatorTurnOn(0x01u);
    S31DIDC004RequestStatus = 1;
    DiagMSG.msgData.S31Detail.Data[0] = 0x04u;
    UDS_Service_Response(0x31u, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *31服务01子功能C005
  *指针检测
  */
void UDS_31Service_Sub01_DID_C005(void)
{
    S31DIDC005RequestStatus = 1;
    DiagMSG.msgData.S31Detail.Data[0] = 0x04u;
    UDS_Service_Response(0x31u, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
 * 
  *31服务01子功能DIDC014
  *仪表激活
  */
void UDS_31Service_Sub01_DID_C014(void)
{
    S31DIDC014RequestStatus = 1;
    DiagMSG.msgData.S31Detail.Data[0] = 0x04u;
    UDS_Service_Response(0x31u, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *31服务02子功能DIDC004
  *指示灯检测
  */
 /*87607-16*/
void UDS_31Service_Sub02_DID_C004(void)
{
    IndicatorTurnOn(0x02u);
    S31DIDC004RequestStatus = 0;
    DiagMSG.msgData.S31Detail.Data[0] = 0x04u;
    UDS_Service_Response(0x31u, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *31服务02子功能C005
  *指针检测
  */
void UDS_31Service_Sub02_DID_C005(void)
{
    S31DIDC005RequestStatus = 0;
    DiagMSG.msgData.S31Detail.Data[0] = 0x04u;
    UDS_Service_Response(0x31u, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *31服务03子功能DIDC004
  *指示灯检测
  */
 /*87607-16*/
void UDS_31Service_Sub03_DID_C004(void)
{
    S31DIDC004RequestStatus = 0;
    DiagMSG.msgData.S31Detail.Data[0] = 0x04u;
    UDS_Service_Response(0x31u, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *31服务03子功能C005
  *指针检测
  */
void UDS_31Service_Sub03_DID_C005(void)
{
    S31DIDC005RequestStatus = 0;
    DiagMSG.msgData.S31Detail.Data[0] = 0x04u;
    UDS_Service_Response(0x31u, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}

/**
  *31服务03子功能DIDC014
  *仪表激活
  */
void UDS_31Service_Sub03_DID_C014(void)
{
    S31DIDC014RequestStatus = 0;
    DiagMSG.msgData.S31Detail.Data[0] = 0x04u;
    UDS_Service_Response(0x31u, POSITIVE_RSP, DIAG_ID_Tx, 4u, DiagMSG.msgData.Data);
}