#ifndef DATA_VEHICHLESPEED_H
#define DATA_VEHICHLESPEED_H


#include "TYW_stdint.h"

/*对频率计算车速做平均的个数*/
#define VehFreNum 3u


typedef union
{
    uint8_t   AccSpeed_Flag  ;
    uint8_t   SubSpeed_Flag  ;
    uint8_t   GslSpeed_Flag  ;
    uint8_t   YblSpeed_Flag  ;
    uint8_t   GslYbl_Flag    ;
    uint8_t   ACCSpeed_Time  ;
    uint8_t   reserveS1;
    uint8_t   reserveS2;
} _ACCSUBSPEED;

extern _ACCSUBSPEED   AccSubSpeed;
extern uint16_t       Speed_Old  ;
extern uint16_t       GslYblSpeedTime  ;

typedef struct
{
    uint32_t  Enable;
    uint32_t  Level;
    uint32_t  Timer;
    uint32_t  Period;
    uint32_t  ActPeriod;
} DriveInfoSpeedPlusConverterStruct;

extern void Speed_KL30_Init(void);
extern void Speed_KL15_ON_Init(void);
extern void Speed_KL15_OFF_Init(void);
extern void Speed_Wakeup_Init(void);
extern void Speed_Sleep_Init(void);
extern void Speed_Processing_Service(void);

extern void Set_Speed_PPK(uint32_t PPK);
extern void Set_Speed_Ratio(uint32_t Ratio);
extern uint32_t Get_Speed_PPK(void) ;

extern uint16_t Speed_Get_ActualValue(void);
extern uint16_t Speed_Get_Display_Value(void);
extern uint8_t Speed_Get_Valid(void);
extern uint8_t Speed_Get_CurSeg(void);
extern void Data_Acc_Speed_Processing(void);
extern void Data_GsLYbL_Speed_Processing(void);

extern void Drive_Info_Speed1_Plus_Conversion(void);
extern void Drive_Info_Speed1_Plus_Conversion_ISR ( void );

extern void Drive_Info_Speed2_Plus_Conversion(void);
extern void Drive_Info_Speed2_Plus_Conversion_ISR ( void );

#endif
