#ifndef IS31FL3236_H__
#define IS31FL3236_H__

#include "r_typedefs.h"

/*-------------------------------------------------------------------------------------------*/
/*芯片数量*/
#define IS31_CHIP_NUM 1U
/*灯的数量*/
#define IS31_LED_NUM 36U
#define IS31_CHIP1_ADDRESS 0X78U
#define IS31_CHIP2_ADDRESS 0X7EU
#define IS31_CHIP3_ADDRESS 0X7AU
#define IS31_CHIP4_ADDRESS 0X7CU

/*-------------------------------------------------------------------------------------------*/
#define IS31_CHANNEL_NUM 36U

extern uint8_t u8IS31Data[IS31_CHIP_NUM][IS31_CHANNEL_NUM];
extern uint8_t LED_Read[72];
/*-------------------------------------------------------------------------*/

#if (IS31_CHIP_NUM >= 1U)

#define IS31_CHIP0_CHANNEL01 u8IS31Data[0U][0U]
#define IS31_CHIP0_CHANNEL02 u8IS31Data[0U][1U]
#define IS31_CHIP0_CHANNEL03 u8IS31Data[0U][2U]
#define IS31_CHIP0_CHANNEL04 u8IS31Data[0U][3U]
#define IS31_CHIP0_CHANNEL05 u8IS31Data[0U][4U]
#define IS31_CHIP0_CHANNEL06 u8IS31Data[0U][5U]
#define IS31_CHIP0_CHANNEL07 u8IS31Data[0U][6U]
#define IS31_CHIP0_CHANNEL08 u8IS31Data[0U][7U]
#define IS31_CHIP0_CHANNEL09 u8IS31Data[0U][8U]
#define IS31_CHIP0_CHANNEL10 u8IS31Data[0U][9U]
#define IS31_CHIP0_CHANNEL11 u8IS31Data[0U][10U]
#define IS31_CHIP0_CHANNEL12 u8IS31Data[0U][11U]
#define IS31_CHIP0_CHANNEL13 u8IS31Data[0U][12U]
#define IS31_CHIP0_CHANNEL14 u8IS31Data[0U][13U]
#define IS31_CHIP0_CHANNEL15 u8IS31Data[0U][14U]
#define IS31_CHIP0_CHANNEL16 u8IS31Data[0U][15U]
#define IS31_CHIP0_CHANNEL17 u8IS31Data[0U][16U]
#define IS31_CHIP0_CHANNEL18 u8IS31Data[0U][17U]
#define IS31_CHIP0_CHANNEL19 u8IS31Data[0U][18U]
#define IS31_CHIP0_CHANNEL20 u8IS31Data[0U][19U]
#define IS31_CHIP0_CHANNEL21 u8IS31Data[0U][20U]
#define IS31_CHIP0_CHANNEL22 u8IS31Data[0U][21U]
#define IS31_CHIP0_CHANNEL23 u8IS31Data[0U][22U]
#define IS31_CHIP0_CHANNEL24 u8IS31Data[0U][23U]
#define IS31_CHIP0_CHANNEL25 u8IS31Data[0U][24U]
#define IS31_CHIP0_CHANNEL26 u8IS31Data[0U][25U]
#define IS31_CHIP0_CHANNEL27 u8IS31Data[0U][26U]
#define IS31_CHIP0_CHANNEL28 u8IS31Data[0U][27U]
#define IS31_CHIP0_CHANNEL29 u8IS31Data[0U][28U]
#define IS31_CHIP0_CHANNEL30 u8IS31Data[0U][29U]
#define IS31_CHIP0_CHANNEL31 u8IS31Data[0U][30U]
#define IS31_CHIP0_CHANNEL32 u8IS31Data[0U][31U]
#define IS31_CHIP0_CHANNEL33 u8IS31Data[0U][32U]
#define IS31_CHIP0_CHANNEL34 u8IS31Data[0U][33U]
#define IS31_CHIP0_CHANNEL35 u8IS31Data[0U][34U]
#define IS31_CHIP0_CHANNEL36 u8IS31Data[0U][35U]

#endif

#if (IS31_CHIP_NUM >= 2U)
#define IS31_CHIP1_CHANNEL01 u8IS31Data[1U][0U]
#define IS31_CHIP1_CHANNEL02 u8IS31Data[1U][1U]
#define IS31_CHIP1_CHANNEL03 u8IS31Data[1U][2U]
#define IS31_CHIP1_CHANNEL04 u8IS31Data[1U][3U]
#define IS31_CHIP1_CHANNEL05 u8IS31Data[1U][4U]
#define IS31_CHIP1_CHANNEL06 u8IS31Data[1U][5U]
#define IS31_CHIP1_CHANNEL07 u8IS31Data[1U][6U]
#define IS31_CHIP1_CHANNEL08 u8IS31Data[1U][7U]
#define IS31_CHIP1_CHANNEL09 u8IS31Data[1U][8U]
#define IS31_CHIP1_CHANNEL10 u8IS31Data[1U][9U]
#define IS31_CHIP1_CHANNEL11 u8IS31Data[1U][10U]
#define IS31_CHIP1_CHANNEL12 u8IS31Data[1U][11U]
#define IS31_CHIP1_CHANNEL13 u8IS31Data[1U][12U]
#define IS31_CHIP1_CHANNEL14 u8IS31Data[1U][13U]
#define IS31_CHIP1_CHANNEL15 u8IS31Data[1U][14U]
#define IS31_CHIP1_CHANNEL16 u8IS31Data[1U][15U]
#define IS31_CHIP1_CHANNEL17 u8IS31Data[1U][16U]
#define IS31_CHIP1_CHANNEL18 u8IS31Data[1U][17U]
#define IS31_CHIP1_CHANNEL19 u8IS31Data[1U][18U]
#define IS31_CHIP1_CHANNEL20 u8IS31Data[1U][19U]
#define IS31_CHIP1_CHANNEL21 u8IS31Data[1U][20U]
#define IS31_CHIP1_CHANNEL22 u8IS31Data[1U][21U]
#define IS31_CHIP1_CHANNEL23 u8IS31Data[1U][22U]
#define IS31_CHIP1_CHANNEL24 u8IS31Data[1U][23U]
#define IS31_CHIP1_CHANNEL25 u8IS31Data[1U][24U]
#define IS31_CHIP1_CHANNEL26 u8IS31Data[1U][25U]
#define IS31_CHIP1_CHANNEL27 u8IS31Data[1U][26U]
#define IS31_CHIP1_CHANNEL28 u8IS31Data[1U][27U]
#define IS31_CHIP1_CHANNEL29 u8IS31Data[1U][28U]
#define IS31_CHIP1_CHANNEL30 u8IS31Data[1U][29U]
#define IS31_CHIP1_CHANNEL31 u8IS31Data[1U][30U]
#define IS31_CHIP1_CHANNEL32 u8IS31Data[1U][31U]
#define IS31_CHIP1_CHANNEL33 u8IS31Data[1U][32U]
#define IS31_CHIP1_CHANNEL34 u8IS31Data[1U][33U]
#define IS31_CHIP1_CHANNEL35 u8IS31Data[1U][34U]
#define IS31_CHIP1_CHANNEL36 u8IS31Data[1U][35U]

#endif

#if (IS31_CHIP_NUM >= 3U)

#define IS31_CHIP2_CHANNEL01 u8IS31Data[2U][0U]
#define IS31_CHIP2_CHANNEL02 u8IS31Data[2U][1U]
#define IS31_CHIP2_CHANNEL03 u8IS31Data[2U][2U]
#define IS31_CHIP2_CHANNEL04 u8IS31Data[2U][3U]
#define IS31_CHIP2_CHANNEL05 u8IS31Data[2U][4U]
#define IS31_CHIP2_CHANNEL06 u8IS31Data[2U][5U]
#define IS31_CHIP2_CHANNEL07 u8IS31Data[2U][6U]
#define IS31_CHIP2_CHANNEL08 u8IS31Data[2U][7U]
#define IS31_CHIP2_CHANNEL09 u8IS31Data[2U][8U]
#define IS31_CHIP2_CHANNEL10 u8IS31Data[2U][9U]
#define IS31_CHIP2_CHANNEL11 u8IS31Data[2U][10U]
#define IS31_CHIP2_CHANNEL12 u8IS31Data[2U][11U]
#define IS31_CHIP2_CHANNEL13 u8IS31Data[2U][12U]
#define IS31_CHIP2_CHANNEL14 u8IS31Data[2U][13U]
#define IS31_CHIP2_CHANNEL15 u8IS31Data[2U][14U]
#define IS31_CHIP2_CHANNEL16 u8IS31Data[2U][15U]
#define IS31_CHIP2_CHANNEL17 u8IS31Data[2U][16U]
#define IS31_CHIP2_CHANNEL18 u8IS31Data[2U][17U]
#define IS31_CHIP2_CHANNEL19 u8IS31Data[2U][18U]
#define IS31_CHIP2_CHANNEL20 u8IS31Data[2U][19U]
#define IS31_CHIP2_CHANNEL21 u8IS31Data[2U][20U]
#define IS31_CHIP2_CHANNEL22 u8IS31Data[2U][21U]
#define IS31_CHIP2_CHANNEL23 u8IS31Data[2U][22U]
#define IS31_CHIP2_CHANNEL24 u8IS31Data[2U][23U]
#define IS31_CHIP2_CHANNEL25 u8IS31Data[2U][24U]
#define IS31_CHIP2_CHANNEL26 u8IS31Data[2U][25U]
#define IS31_CHIP2_CHANNEL27 u8IS31Data[2U][26U]
#define IS31_CHIP2_CHANNEL28 u8IS31Data[2U][27U]
#define IS31_CHIP2_CHANNEL29 u8IS31Data[2U][28U]
#define IS31_CHIP2_CHANNEL30 u8IS31Data[2U][29U]
#define IS31_CHIP2_CHANNEL31 u8IS31Data[2U][30U]
#define IS31_CHIP2_CHANNEL32 u8IS31Data[2U][31U]
#define IS31_CHIP2_CHANNEL33 u8IS31Data[2U][32U]
#define IS31_CHIP2_CHANNEL34 u8IS31Data[2U][33U]
#define IS31_CHIP2_CHANNEL35 u8IS31Data[2U][34U]
#define IS31_CHIP2_CHANNEL36 u8IS31Data[2U][35U]

#endif

#if (IS31_CHIP_NUM >= 4U)
#define IS31_CHIP3_CHANNEL01 u8IS31Data[3U][0U]
#define IS31_CHIP3_CHANNEL02 u8IS31Data[3U][1U]
#define IS31_CHIP3_CHANNEL03 u8IS31Data[3U][2U]
#define IS31_CHIP3_CHANNEL04 u8IS31Data[3U][3U]
#define IS31_CHIP3_CHANNEL05 u8IS31Data[3U][4U]
#define IS31_CHIP3_CHANNEL06 u8IS31Data[3U][5U]
#define IS31_CHIP3_CHANNEL07 u8IS31Data[3U][6U]
#define IS31_CHIP3_CHANNEL08 u8IS31Data[3U][7U]
#define IS31_CHIP3_CHANNEL09 u8IS31Data[3U][8U]
#define IS31_CHIP3_CHANNEL10 u8IS31Data[3U][9U]
#define IS31_CHIP3_CHANNEL11 u8IS31Data[3U][10U]
#define IS31_CHIP3_CHANNEL12 u8IS31Data[3U][11U]
#define IS31_CHIP3_CHANNEL13 u8IS31Data[3U][12U]
#define IS31_CHIP3_CHANNEL14 u8IS31Data[3U][13U]
#define IS31_CHIP3_CHANNEL15 u8IS31Data[3U][14U]
#define IS31_CHIP3_CHANNEL16 u8IS31Data[3U][15U]
#define IS31_CHIP3_CHANNEL17 u8IS31Data[3U][16U]
#define IS31_CHIP3_CHANNEL18 u8IS31Data[3U][17U]
#define IS31_CHIP3_CHANNEL19 u8IS31Data[3U][18U]
#define IS31_CHIP3_CHANNEL20 u8IS31Data[3U][19U]
#define IS31_CHIP3_CHANNEL21 u8IS31Data[3U][20U]
#define IS31_CHIP3_CHANNEL22 u8IS31Data[3U][21U]
#define IS31_CHIP3_CHANNEL23 u8IS31Data[3U][22U]
#define IS31_CHIP3_CHANNEL24 u8IS31Data[3U][23U]
#define IS31_CHIP3_CHANNEL25 u8IS31Data[3U][24U]
#define IS31_CHIP3_CHANNEL26 u8IS31Data[3U][25U]
#define IS31_CHIP3_CHANNEL27 u8IS31Data[3U][26U]
#define IS31_CHIP3_CHANNEL28 u8IS31Data[3U][27U]
#define IS31_CHIP3_CHANNEL29 u8IS31Data[3U][28U]
#define IS31_CHIP3_CHANNEL30 u8IS31Data[3U][29U]
#define IS31_CHIP3_CHANNEL31 u8IS31Data[3U][30U]
#define IS31_CHIP3_CHANNEL32 u8IS31Data[3U][31U]
#define IS31_CHIP3_CHANNEL33 u8IS31Data[3U][32U]
#define IS31_CHIP3_CHANNEL34 u8IS31Data[3U][33U]
#define IS31_CHIP3_CHANNEL35 u8IS31Data[3U][34U]
#define IS31_CHIP3_CHANNEL36 u8IS31Data[3U][35U]

#endif
/*-------------------------------------------------------------------------------------------*/
typedef struct
{
	uint8_t u8IS31Init;
	uint8_t u8IS31Operation;
	uint8_t u8IS31Step;

	uint8_t u8IS31Refresh;
	uint8_t u8IS31ChipCount;
	uint8_t u8IS31ChannelCount;

	uint8_t u8IS31ChannelBegin;
	uint8_t u8IS31ChannelEnd;
	uint8_t u8IS31ChannelWriteCount;
	uint8_t u8IS31ChannelDataUpdate;

} IS31_Ctr_st_t;
/*------------------------------------------------------*/
extern IS31_Ctr_st_t stIS31Ctr;

extern void IS31_Set_SDB_Pin(uint8_t u8Level);
extern void IS31_Init(void);
extern void IS31_Shutdown(void);
/*主循环实时调用*/
extern void IS31_Service(void);
void IS31_Scan_Refresh_Test(void);
/*50ms调用一次*/
extern void IS31_Scan_Refresh(void);
void LED_OFF_Init(void);
void LED_ON_Init(void);
/*被打断时调用*/
extern void IS31_Break(void);

#endif
