#include "Line_in.h"

/*硬线输入服务函数调用周期*/
#define LINE_IN_CYCLE 10U

typedef struct
{
    LineIn_LogicLevel_en_t u8Status;       /*硬线最后输出状态*/
    uint16_t u16TimeCount;  /*消抖计时变量*/
    uint8_t u8PinInputLast; /*实际硬线输入引脚记忆的上一次状态*/

} Line_In_Control_st_t;

Line_In_Control_st_t g_stLineInControl[LINE_IN_MAX];

/*以下内容不要改*/
/*电源状态*/
LINE_IN_WorkSt_en_t g_enLineInPowerStatus;



static void Line_In_Debounce_Handle(uint8_t Channel);
static void Line_In_Debounce_Handle(uint8_t Channel)
{
    LINE_IN_TriggerLevel_en_t enRealtimeLevel;
    LineIn_Read_Level pRead;

    pRead = g_stLineInAttribute[Channel].pfnLineIn_Read_Cbk;
    if (pRead != NULL)
    {
        enRealtimeLevel = pRead();
        if (g_stLineInControl[Channel].u8PinInputLast != enRealtimeLevel)
        {
            g_stLineInControl[Channel].u16TimeCount = 0U;
            g_stLineInControl[Channel].u8PinInputLast = enRealtimeLevel;
        }
        else
        {
            /*硬线输入等于有效电平*/
            if (g_stLineInAttribute[Channel].enValidLevel == enRealtimeLevel)
            {
                g_stLineInControl[Channel].u16TimeCount += LINE_IN_CYCLE;
                if (g_stLineInControl[Channel].u16TimeCount >= g_stLineInAttribute[Channel].u16ValidTime)
                {
                    g_stLineInControl[Channel].u16TimeCount = 0U;
                    g_stLineInControl[Channel].u8Status = LINE_IN_LOGIC_VALID;
                }
            }
            else
            {
                g_stLineInControl[Channel].u16TimeCount += LINE_IN_CYCLE;
                if (g_stLineInControl[Channel].u16TimeCount >= g_stLineInAttribute[Channel].u16InvalidTime)
                {
                    g_stLineInControl[Channel].u16TimeCount = 0U;
                    g_stLineInControl[Channel].u8Status = LINE_IN_LOGIC_INVALID;
                }
            }
        }
    }
}





void Line_In_SetPowerSt(LINE_IN_WorkSt_en_t u8PowerSt)
{
    g_enLineInPowerStatus = u8PowerSt;
}



/*推荐值10ms*/
void Line_In_Debounce_Service(void)
{
    uint8_t i;

    for (i = 0u; i < LINE_IN_MAX; i++)
    {
        if (g_stLineInAttribute[i].enPowerStatus == LINE_IN_IG_ONOFF)
        {
            Line_In_Debounce_Handle(i);
        }
        else if (g_stLineInAttribute[i].enPowerStatus == LINE_IN_IG_ON)
        {
            if (g_enLineInPowerStatus == LINE_IN_IG_ON)
            {
                Line_In_Debounce_Handle(i);
            }
            else /*切换电源状态时已经操作过了*/
            {
            }
        }
        else /* if(LINE_IN_IG_OFF==g_stLineInAttribute[i].enPowerStatus) */
        {
            if (g_enLineInPowerStatus == LINE_IN_IG_OFF)
            {
                Line_In_Debounce_Handle(i);
            }
            else /*切换电源状态时已经操作过了*/
            {
            }
        }
    }
}

LineIn_LogicLevel_en_t Line_In_Get_Status(uint8_t Channel)
{
    return g_stLineInControl[Channel].u8Status;
}


void Line_In_KL30_Init(void)
{
    uint8_t i = 0U;
    g_enLineInPowerStatus = LINE_IN_IG_OFF;
    for (i = 0U; i < LINE_IN_MAX; i++)
    {
        g_stLineInControl[i].u16TimeCount = 0U;
        g_stLineInControl[i].u8PinInputLast = 0U;
        g_stLineInControl[i].u8Status = LINE_IN_LOGIC_INVALID;
    }
}

void Line_In_KL15_ON_Init(void)
{
    uint8_t i = 0U;
    g_enLineInPowerStatus = LINE_IN_IG_ON;
    for (i = 0U; i < LINE_IN_MAX; i++)
    {
         /*硬线在当前电源状态下不工作*/
        if (g_stLineInAttribute[i].enPowerStatus == LINE_IN_IG_OFF)

        {
            g_stLineInControl[i].u8Status = LINE_IN_LOGIC_INVALID;
            g_stLineInControl[i].u16TimeCount = 0U;
        }
    }
}
void Line_In_KL15_OFF_Init(void)
{
    uint8_t i = 0U;
    g_enLineInPowerStatus = LINE_IN_IG_OFF;
    for (i = 0U; i < LINE_IN_MAX; i++)
    {
        /*硬线在当前电源状态下不工作*/
        if (g_stLineInAttribute[i].enPowerStatus == LINE_IN_IG_ON)
        {
            g_stLineInControl[i].u8Status = LINE_IN_LOGIC_INVALID;
            g_stLineInControl[i].u16TimeCount = 0U;
        }
    }
}

