
#ifndef GRAPHIC_H__
#define GRAPHIC_H__

#define   GFX_VO_NONE                       (0x00U)
#define   GFX_VO_SINGLE_RGB888              (0x01U)
#define   GFX_VO_SINGLE_RGB666              (0x02U)
#define   GFX_VO_SINGLE_OPENLDI             (0x03U)
/*
--- Reserved output mode for future expansion ---
#define   GFX_VO_SINGLE_SERRGB              (0x04U)
#define   GFX_VO_DUAL_OPENLDI_SERRGB        (0x05U)
#define   GFX_VO_DUAL_VODDR                 (0x06U)
*/

#define   GFX_VI_NONE                       (0x00U)
#define   GFX_VI_ITU656                     (0x10U)
/*
--- Reserved input mode for future expansion ---
#define   GFX_VI_RGB666                     (0x20U)
*/

#define   GFX_DHD_UNIT                      (0U)
#define   GFX_DHD_ALIGN(ADDR,BLOCK)         ((ADDR+(BLOCK-1)) & ~(BLOCK-1))
#define   GFX_DHD_USER_INSTANCES            (1U)
#define   GFX_DHD_JOB_SIZE                  (512U)    /* Jobsize: Number of bytes in one job buffer */
#define   GFX_DHD_JOB_COUNT                 (8U)      /* Jobcount: Recommended number of jobs in flight per client */
#define   GFX_DHD_RING_SIZE                 (1024U)   /* Ringsize: Number of bytes in ringbuffer, needs to be a power of two */
#define   GFX_DHD_USE_PC                    (1U)      /* Use performance counters: Set to 1 to reserve memory for performance counters */
#define   GFX_DHD_STATE_STORAGE             (480U)    /* one DHD context with a config with 2 tex units, 3 color unit passes and 4 const colors */

/* CAUTION: you have to adapt this when using dhd_alloc* manually, when using
 * DHD performance counter or when using DHD command list feature!
 *
 * Example: Each of the 4 available performance counters requires allocation of 4 bytes.
            Allocation is aligned to 128 bytes, thus for four PC's 512 additional bytes are required.
 */
#define   GFX_DHD_RING_SIZE_ALLOC           GFX_DHD_ALIGN(GFX_DHD_RING_SIZE + 4U, 128U)
#define   GFX_DHD_STATE_STORAGE_ALLOC       GFX_DHD_ALIGN(GFX_DHD_STATE_STORAGE, 128U)
#define   GFX_DHD_PC_ALLOC                  GFX_DHD_ALIGN(GFX_DHD_USE_PC * 4U * 128U, 128U)
#define   GFX_DHD_MEMORY_SIZE               (GFX_DHD_RING_SIZE_ALLOC + \
                                             GFX_DHD_USER_INSTANCES * (GFX_DHD_STATE_STORAGE_ALLOC + GFX_DHD_JOB_COUNT * GFX_DHD_JOB_SIZE) + \
                                             GFX_DHD_PC_ALLOC)

#define   GFX_VRAM0                         (0x3FD9C000)
#define   GFX_VRAM1                         (0x3FECE000)
#define   GFX_DHD_BASE                      GFX_VRAM0
#define   GFX_VO0_BASE                      (GFX_DHD_BASE + GFX_DHD_MEMORY_SIZE)
#define   GFX_VID_FB_BASE                   (GFX_VO0_BASE)
#define   GFX_SDRAM_FB_BASE                 (0x40000000)

#define   GFX_VRAM0_SIZE                    (0x132000)                   /* 1.195 MB */
#define   GFX_VRAM1_SIZE                    (0x132000)                   /* 1.195 MB */
#define   GFX_SDRAM_SIZE                    (32u  * 1024u * 1024u)       /*  32 MB */

#define   GFX_VIDMEM_SIZE                   (GFX_VRAM0_SIZE + GFX_VRAM1_SIZE - GFX_DHD_MEMORY_SIZE)
#define   GFX_VID_HP_BLOCK_SIZE             (4 * 1024)
#define   GFX_VID_HP_BLOCK_NB               (GFX_VIDMEM_SIZE / GFX_VID_HP_BLOCK_SIZE)
#define   GFX_SDRAM_HP_BLOCK_SIZE           (8 * 1024)
#define   GFX_SDRAM_HP_BLOCK_NB             (GFX_SDRAM_SIZE / GFX_SDRAM_HP_BLOCK_SIZE)

#define   GFX_CPU_HP_BLOCK_NB               (0x600UL) /* Number of blocks the CPU heap is divided into */
#define   GFX_CPU_HP_BLOCK_SIZE             (0x100UL)  /* Size of one CPU heap block  */
#define   GFX_HEAP_SIZE                     (GFX_CPU_HP_BLOCK_NB * GFX_CPU_HP_BLOCK_SIZE)




#define   GFX_WM_UNIT                       (0U)
#define   GFX_WM_MSG_QUEUE_LEN              (512U)

#define   GFX_DISPLAY_NAME                  "AUO_C070VAN02_7_800x480"
//#define   GFX_DISPLAY_NAME                  "AUO_C103VAN01_1_1280x480"




#define   GFX_USE_INTERNAL_VRAM             (0U)
#define   GFX_VRAM_SIZE_IN_SDRAM            (32UL * 1024UL * 1024UL)

// #define   GFX_VID_HP_BLOCK_SIZE             (0x400UL)











#define   GFX_USE_VOWE                      (0U)
/* VOWE DL buffer(x2) is allocated in bottom of VRAM */
#define   GFX_VOWE_DL_BUF_SIZE              (0x00010000UL)
#define   GFX_VOWE_WORK_BUFF_SIZE           (0x00020000UL)

#if 0
#define   GFX_USE_INTERNAL_VRAM             (0U)
#define   GFX_VRAM_SIZE_IN_SDRAM            (32UL * 1024UL * 1024UL)
#define   GFX_CPU_HP_BLOCK_NB               (0x800UL) /* Number of blocks the CPU heap is divided into */
#define   GFX_CPU_HP_BLOCK_SIZE             (0x40UL)  /* Size of one CPU heap block  */
#define   GFX_VID_HP_BLOCK_SIZE             (0x400UL)

#define   GFX_USE_VOWE                      (1U)
/* VOWE DL buffer(x2) is allocated in bottom of VRAM */
#define   GFX_VOWE_DL_BUF_SIZE              (0x00010000UL)
#define   GFX_VOWE_WORK_BUFF_SIZE           (0x00020000UL)


#define   GFX_DHD_UNIT                      (0U)
#define   GFX_DHD_ALIGN(ADDR,BLOCK)         ((ADDR+(BLOCK-1)) & ~(BLOCK-1))
#define   GFX_DHD_USER_INSTANCES            (1U)
#define   GFX_DHD_JOB_SIZE                  (512U)    /* Jobsize: Number of bytes in one job buffer */
#define   GFX_DHD_JOB_COUNT                 (8U)      /* Jobcount: Recommended number of jobs in flight per client */
#define   GFX_DHD_RING_SIZE                 (1024U)   /* Ringsize: Number of bytes in ringbuffer, needs to be a power of two */
#define   GFX_DHD_USE_PC                    (1U)       Use performance counters: Set to 1 to reserve memory for performance counters
#define   GFX_DHD_STATE_STORAGE             (480U)    /* one DHD context with a config with 2 tex units, 3 color unit passes and 4 const colors */

/* CAUTION: you have to adapt this when using dhd_alloc* manually, when using
 * DHD performance counter or when using DHD command list feature!
 *
 * Example: Each of the 4 available performance counters requires allocation of 4 bytes.
            Allocation is aligned to 128 bytes, thus for four PC's 512 additional bytes are required.
 */
#define   GFX_DHD_RING_SIZE_ALLOC           GFX_DHD_ALIGN(GFX_DHD_RING_SIZE + 4U, 128U)
#define   GFX_DHD_STATE_STORAGE_ALLOC       GFX_DHD_ALIGN(GFX_DHD_STATE_STORAGE, 128U)
#define   GFX_DHD_PC_ALLOC                  GFX_DHD_ALIGN(GFX_DHD_USE_PC * 4U * 128U, 128U)
#define   GFX_DHD_MEMORY_SIZE               (GFX_DHD_RING_SIZE_ALLOC + \
                                             GFX_DHD_USER_INSTANCES * (GFX_DHD_STATE_STORAGE_ALLOC + GFX_DHD_JOB_COUNT * GFX_DHD_JOB_SIZE) + \
                                             GFX_DHD_PC_ALLOC)

#define   GFX_WM_UNIT                       (0U)
#define   GFX_WM_MSG_QUEUE_LEN              (512U)

#define   GFX_DISPLAY_NAME                  "AUO_C070VAN02_7_800x480"
//#define   GFX_DISPLAY_NAME                  "AUO_C103VAN01_1_1280x480"








#endif







extern void Gfx_Init(uint8_t u8Mode);
extern void Gfx_Sys_Start(void);
extern void Gfx_Sys_Stop(void);
extern void Gfx_Create_Window(r_wm_WinMode_t      enMode,
                              uint32_t            u32PosX,
                              uint32_t            u32PosY,
                              uint32_t            u32PosZ,
                              uint32_t            u32Width,
                              uint32_t            u32Height,
                              uint32_t            u32Pitch,
                              uint32_t            u32Bnumber,
                              r_wm_WinColorFmt_t  enColorFmt,
                              r_wm_Window_t*      pstWindow);

void Loc_Display_Red(uint8_t ColorR, uint8_t ColorG, uint8_t ColorB);
#endif /* GRAPHIC_H__ */

