#include "CAN_FUNC.h"
#include "CAN_Communication_Matrix.h"
/*增加外发计算部分引用文件*/
#include "Common_Interface.h"
#include "Gauges.h"
#include "GaugesInterface.h"

#include "Telltales.h"

#include "GUI.h"
#include "Data_CoolantTemperature.h"
#include "Data_Voltmeter.h"
#include "Data_AirPressure.h"
#include "RTE_TIME.h"
#include "Services_Mileage.h"
#include "RTE_ADC.h"
#include "Data_Fuel_User.h"

#include "Line_in.h"
#include "Menu.h"

static uint8_t User_BCM_Flag;

uint8_t TpmsMsg18033317SendFlag = 0;

uint8_t Msg_18021733[8];
/*---------------------------------------------------------------------------
使用しない Byte、bit に関しては全て 1(B)をセットして出力すること
对于不使用的Byte、bit，全部设置1(B)并输出
----------------------------------------------------------------------------*/
USER_ECU User_ECU;
/*-------------------------------------------------------------------------
 * Function Name  : Can_Set_Buff_18FEAE17
 * Description    :
 * Input          : None  18FEAE17
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Can_Set_Buff_18FEAE17(uint8_t CopyData[])
{
    uint16_t Main_Air_Pressure = 0u;                  /*0～FA:0～2000 [kPa] FB～FF:Not used  8倍*/
    uint16_t Service_Brake_Circuit1_AirPressure = 0u; /*0～FA:0～2000 [kPa] FB～FF:Not used  8倍*/
    uint16_t Service_Brake_Circuit2_AirPressure = 0u; /*0～FA:0～2000 [kPa] FB～FF:Not used  8倍*/
    uint16_t Power_Supply_Voltage = 0u;               /*0～2D0:0～36 [V] 2D1～FFFF:Not used*/
    uint8_t Parking_Brake_Switch = 0u;
    uint8_t Rader_Stain_Information = 0u;
    uint8_t SW_ECONO = 0u;

    /*WET*/
    Main_Air_Pressure = (uint8_t)((Common_Get_WET_Data() - 500u) / 20u);

    /*气压状态*/
    if ((K_Line_Set.K_Line_LID42 == 0x00u) || (K_Line_Set.K_Line_LID42 == 0x03u))
    {
        if (Common_Get_Air1_Data() != 0u)
        {
            Service_Brake_Circuit1_AirPressure = (uint8_t)((Common_Get_Air1_Data() - 500u) / 20u);
        }
        else
        {
            Service_Brake_Circuit1_AirPressure = 0u;
        }

        if (Common_Get_Air2_Data() != 0u)
        {
            Service_Brake_Circuit2_AirPressure = (uint8_t)((Common_Get_Air2_Data() - 500u) / 20u);
        }
        else
        {
            Service_Brake_Circuit2_AirPressure = 0u;
        }
    }
    else if ((K_Line_Set.K_Line_LID42 == 0x01u) || (K_Line_Set.K_Line_LID42 == 0x02u))
    {
        if (Common_Get_Air2_Data() != 0u)
        {
            Service_Brake_Circuit1_AirPressure = (uint8_t)((Common_Get_Air2_Data() - 500u) / 20u);
        }
        else
        {
            Service_Brake_Circuit1_AirPressure = 0u;
        }

        if (Common_Get_Air1_Data() != 0u)
        {
            Service_Brake_Circuit2_AirPressure = (uint8_t)((Common_Get_Air1_Data() - 500u) / 20u);
        }
        else
        {
            Service_Brake_Circuit2_AirPressure = 0u;
        }
    }

    /*电源电压*/
    Power_Supply_Voltage = 0u;

    /*驻车制动外发*/
    if (Line_In_Get_Status(LINE_IN_PARK_BRAKE) == 0u)
    {
        Parking_Brake_Switch = 1u;
    }
    else
    {
        Parking_Brake_Switch = 0u;
    }

    Rader_Stain_Information = 0u;
    SW_ECONO = 0u;

    CopyData[0] = (uint8_t)(Main_Air_Pressure & 0xFFu);                  /* 1  */
    CopyData[1] = 0u;                                                    /* 2  */
    CopyData[2] = (uint8_t)(Service_Brake_Circuit1_AirPressure & 0xFFu); /* 3  */
    CopyData[3] = (uint8_t)(Service_Brake_Circuit2_AirPressure & 0xFFu); /* 4  */
    CopyData[4] = 0u;                                                    /* 5  */
    CopyData[5] = (uint8_t)(Power_Supply_Voltage & 0xFFU);               /* 6  */
    CopyData[6] = (uint8_t)((Power_Supply_Voltage >> 8u) & 0xFFu);       /* 7  */
    CopyData[7] = (uint8_t)(((Parking_Brake_Switch << 6u) & 0xC0u) |
                            ((Rader_Stain_Information << 2u) & 0x0Cu) |
                            (SW_ECONO & 0x03u)); /* 8  */
}

/*-------------------------------------------------------------------------
 * Function Name  : Can_Set_Buff_18FF3E17
 * Description    :
 * Input          : None   18FF3E17
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Can_Set_Buff_18FF3E17(uint8_t CopyData[])
{
    uint32_t Pulse_Correction_Facor = 0u;
    uint8_t SW_PTO = 0u;
    uint8_t AEBS_ON_OFF_Info = 0u;
    uint8_t HID_Auto_Leveling = 0u;
    uint8_t MIL_Lamp_Status = 0u;
    uint16_t Fuel_Gauges_AD_Value = 0u;
    uint8_t TURN_L_Lamp_Status = 0u;
    uint8_t DstWarnVolume_Set = 0u;

    CopyData[0] = (uint8_t)((Pulse_Correction_Facor) & 0xFFu);       /* 1  */
    CopyData[1] = (uint8_t)((Pulse_Correction_Facor >> 8u) & 0xFFu); /* 2  */
    CopyData[2] = (uint8_t)(((SW_PTO << 7u) & 0x80u) |
                            ((AEBS_ON_OFF_Info << 4u) & 0x30u) |
                            ((HID_Auto_Leveling << 1u) & 0x02u));       /* 3  */
    CopyData[3] = (uint8_t)(((MIL_Lamp_Status << 7u) & 0x80u) | 0x7Fu); /* 4  */
    CopyData[4] = (uint8_t)(Fuel_Gauges_AD_Value & 0xFFu);              /* 5  */
    CopyData[5] = 0u;                                                   /* 6  */
    CopyData[6] = 0u;                                                   /* 7  */
    CopyData[7] = (uint8_t)(((TURN_L_Lamp_Status << 5u) & 0x10u) |
                            ((DstWarnVolume_Set & 0x07))); /* 8  */
}
/*-------------------------------------------------------------------------
 * Function Name  : Can_Set_Buff_18FED917
 * Description    :
 * Input          : None  18FED917
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Can_Set_Buff_18FED917(uint8_t CopyData[])
{
    uint8_t Blanding_SW_Signal = 0u;
    uint8_t Tralier_ABS_Fully_Operational = 0u;
    uint8_t Tlailer_ABS_Detect = 0u;
    uint8_t Tlailer_Connected = 0u;

    Blanding_SW_Signal = Line_In_Get_Status(LINE_IN_RET_BLENDING); /*A10*/

    Tlailer_Connected = Line_In_Get_Status(LINE_IN_TRAILER_CONNECT); /*B6*/

    if (Line_In_Get_Status(LINE_IN_TRAILER_CONNECT) == 1u)
    {
        Tlailer_ABS_Detect = Line_In_Get_Status(LINE_IN_ABS_DETECT); /*A33*/

        if (Line_In_Get_Status(LINE_IN_ABS_DETECT) == 1u)
        {
            Tralier_ABS_Fully_Operational = Line_In_Get_Status(LINE_IN_TRAILER_ABS); /*B33*/
        }
        else
        {
            Tralier_ABS_Fully_Operational = 0u;
        }
    }
    else
    {
        Tlailer_ABS_Detect = 3u;
        Tralier_ABS_Fully_Operational = 3u;
    }

    CopyData[0] = (uint8_t)(((Blanding_SW_Signal << 4u) & 0x30u) |
                            0xCFu); /* 1  */
    CopyData[1] = (uint8_t)(((Tralier_ABS_Fully_Operational << 2u) & 0x0Cu) |
                            ((Tlailer_ABS_Detect << 4u) & 0x30u) |
                            ((Tlailer_Connected << 6u) & 0xC0u) |
                            0x03u); /* 2  */
    CopyData[2] = 0u;               /* 3  */
    CopyData[3] = 0u;               /* 4  */
    CopyData[4] = 0u;               /* 5  */
    CopyData[5] = 0u;               /* 6  */
    CopyData[6] = 0u;               /* 7  */
    CopyData[7] = 0u;               /* 8  */
}

/*-------------------------------------------------------------------------
 * Function Name  : Can_Set_Buff_18FEE617
 * Description    :
 * Input          : None  18FEE617
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Can_Set_Buff_18FEE617(uint8_t CopyData[])
{
    uint8_t Seconds = 0u;
    uint8_t Minutes = 0u;
    uint8_t Hours = 0u;
    uint8_t Month = 0u;
    uint8_t Day = 0u;
    uint8_t Year = 0u;

    Seconds = Get_RTC_SECOND() * 4u;
    Minutes = Get_RTC_MINUTE();
    Hours = Get_RTC_HOUR();
    Month = Get_RTC_MONTH();
    Day = Get_RTC_DATE() * 4u;
    Year = (uint8_t)((Get_RTC_YEAR() + 2000u - 1985u) & 0xFFu);

    CopyData[0] = (uint8_t)Seconds; /* 1  */
    CopyData[1] = (uint8_t)Minutes; /* 2  */
    CopyData[2] = (uint8_t)Hours;   /* 3  */
    CopyData[3] = (uint8_t)Month;   /* 4  */
    CopyData[4] = (uint8_t)Day;     /* 5  */
    CopyData[5] = (uint8_t)Year;    /* 6  */
    CopyData[6] = 0u;               /* 7  */
    CopyData[7] = 0u;               /* 8  */
}

/*-------------------------------------------------------------------------
 * Function Name  : Can_Set_Buff_18FEE017
 * Description    :
 * Input          : None  18FEE017
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Can_Set_Buff_18FEE017(uint8_t CopyData[])
{
    uint32_t Total_Vehicle_Distance = 0u; /*总计里程*/

    Total_Vehicle_Distance = Data_ODO_Read();

    CopyData[0] = 0xFFu;                                                           /* 1  */
    CopyData[1] = 0xFFu;                                                           /* 2  */
    CopyData[2] = 0xFFu;                                                           /* 3  */
    CopyData[3] = 0xFFu;                                                           /* 4  */
    CopyData[4] = (uint8_t)((Total_Vehicle_Distance * 8u / 10u) & 0xFFu);          /* 5  */
    CopyData[5] = (uint8_t)(((Total_Vehicle_Distance * 8u / 10u) >> 8u) & 0xFFu);  /* 6  */
    CopyData[6] = (uint8_t)(((Total_Vehicle_Distance * 8u / 10u) >> 16u) & 0xFFu); /* 7  */
    CopyData[7] = (uint8_t)(((Total_Vehicle_Distance * 8u / 10u) >> 24u) & 0xFFu); /* 8  */
}

/*-------------------------------------------------------------------------
 * Function Name  : Can_Set_Buff_18FEFC17
 * Description    :
 * Input          : None  18FEFC17
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Can_Set_Buff_18FEFC17(uint8_t CopyData[])
{
    uint8_t Washer_Fluid_Level = 0u;
    uint8_t Fuel_Level_1 = 0u; /*仪表外发*/
    uint8_t Engine_Fuel_Filter_Differential_Pressure = 0u;
    uint8_t Engine_Oil_Filter_Differential_Pressure = 0u;
    uint16_t Cargo_Ambient_Temperature = 0u;
    uint8_t Fuel_Level_2 = 0u;
    uint8_t Engine_Oil_Filter_Differential = 0u;

    uint16_t Get_Step = 0u;
    Get_Step = Fuel_Get_Step();

    if (Get_Step > 10u)
    {
        Fuel_Level_1 = (uint8_t)((Get_Step - 10u) * 50u / 24u);
    }
    else
    {
        Fuel_Level_1 = 0u;
    }

    CopyData[0] = (uint8_t)Washer_Fluid_Level;                          /* 1  */
    CopyData[1] = (uint8_t)Fuel_Level_1;                                /* 2  */
    CopyData[2] = (uint8_t)Engine_Fuel_Filter_Differential_Pressure;    /* 3  */
    CopyData[3] = (uint8_t)Engine_Oil_Filter_Differential_Pressure;     /* 4  */
    CopyData[4] = (uint8_t)(Cargo_Ambient_Temperature & 0xFFu);         /* 5  */
    CopyData[5] = (uint8_t)((Cargo_Ambient_Temperature >> 8u) & 0xFFu); /* 6  */
    CopyData[6] = (uint8_t)Fuel_Level_2;                                /* 7  */
    CopyData[7] = (uint8_t)Engine_Oil_Filter_Differential;              /* 8  */
}

/*-------------------------------------------------------------------------
 * Function Name  : Can_Set_Buff_18FF2517
 * Description    :
 * Input          : None  18FF2517
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Can_Set_Buff_18FF2517(uint8_t CopyData[])
{
    uint16_t Year = 0u;
    uint8_t Month = 0u;
    uint8_t Day = 0u;
    uint8_t Hour = 0u;
    uint8_t Minute = 0u;
    uint32_t ODO_Meter = 0u;

    Year = Get_RTC_YEAR();
    Month = Get_RTC_MONTH();
    Day = Get_RTC_DATE();
    Hour = Get_RTC_HOUR();
    Minute = Get_RTC_MINUTE();

    CopyData[0] = (uint8_t)(Year & 0xFFu);               /* 1  */
    CopyData[1] = (uint8_t)Month;                        /* 2  */
    CopyData[2] = (uint8_t)Day;                          /* 3  */
    CopyData[3] = (uint8_t)Hour;                         /* 4  */
    CopyData[4] = (uint8_t)Minute;                       /* 5  */
    CopyData[5] = (uint8_t)(ODO_Meter & 0xFFu);          /* 6  */
    CopyData[6] = (uint8_t)((ODO_Meter >> 8u) & 0xFFu);  /* 7  */
    CopyData[7] = (uint8_t)((ODO_Meter >> 16u) & 0xFFu); /* 8  */
}

/*-------------------------------------------------------------------------
 * Function Name  : Can_Set_Buff_18FF2A17
 * Description    :
 * Input          : None 18FF2A17
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Can_Set_Buff_18FF2A17(uint8_t CopyData[])
{
    uint8_t Water_Temp_Level = 0u;            /*水温状态*/
    uint8_t Remining_Fuel_Warning = 0u;       /*剩余燃料报警*/
    uint8_t Battery_Maintenance_Warning = 0u; /*电池维护报警*/
    uint8_t Over_Heat_Warning_Status = 0u;    /*水温状态*/
    uint8_t Meter_Malfunction = 0u;           /*仪表故障*/
    uint8_t SRS_Input = 0u;
    uint8_t SW_Rear_Body_Warning = 0u;
    uint8_t SW_Sheetbelt = 0u;
    uint8_t SW_Oil_Pressure = 0u;
    uint8_t SW_Coolant_Level = 0u;
    uint8_t SW_Water_Separator = 0u;
    uint8_t SW_Clutch = 0u;
    uint8_t SW_Air_Low_Pressure = 0u;
    uint8_t SW_MT_Range = 0u;
    uint8_t SW_MT_Spriter = 0u;
    uint8_t SW_KickDrive = 0u;
    uint8_t SW_DefLock = 0u;
    uint8_t ACG_L_Terminal = 0u;
    uint8_t Reserve = 0u;
    uint8_t SW_Dr_Door = 0u;
    uint8_t EDS_Smoother_WL_Status = 0u;
    uint8_t EBS_Warning_Red = 0u;
    uint8_t EBS_Warning_Yellow = 0u;
    uint8_t ESC_Operating = 0u;
    uint8_t Air_Sus_Warning = 0u;
    uint8_t Roll_Warning = 0u;
    uint8_t ROWS_Warning = 0u;
    uint8_t Mult_Indication = 0u;
    uint8_t SW_KeyRemind = 0u;
    uint8_t SW_Hi_Beam = 0u;
    uint8_t TURN_R_Lamp_Status = 0u;
    uint8_t SW_Illmi = 0u;
    uint8_t SW_SpotLamp = 0u;
    uint8_t SW_Accessory_Air = 0u;
    uint8_t SW_Trailer_Brake = 0u;
    uint8_t Input_Trailer_Info = 0u;
    uint8_t Input_Trailer_ABS = 0u;
    uint8_t SW_Coupler_Lock = 0u;
    uint8_t SW_Parking = 0u;
    uint8_t IGN_Voltage = 0u;
    uint8_t MJX_MEB9_Manual_TM_Range_Low = 0u;
    uint8_t Range_Air_Cut_Warning = 0u;
    uint8_t IRIS_Warning_Lamp_Status = 0u;

#if 0
    /*手刹状态*/
    if (LINK_PARK_BRAKE_IN_LG32_P03 == 0)
        SW_Parking = 1 ;
    else
        SW_Parking = 0 ;

    /*水温状态*/
    if ((ET1_Engine_Coolant_Temperature > 0xFA) || (ET1_STATUS & CAN_MSG_LOST))
    {
        Water_Temp_Level = 2;
        Over_Heat_Warning_Status = 0;
    }
    else if ((DataCoolantTempSegDisp >= 0) && (DataCoolantTempSegDisp < 12))
    {
        Water_Temp_Level = 0 ;
        Over_Heat_Warning_Status = 0 ;
    }
    else  if ((DataCoolantTempSegDisp >= 12) && (DataCoolantTempSegDisp <= 13))
    {
        Water_Temp_Level = 1 ;

        if (DataVSpeedDisp > 20)
            Over_Heat_Warning_Status = 0 ;
        else
            Over_Heat_Warning_Status = 1 ;
    }

    /*电源电压*/
    IGN_Voltage  = (9 + DataCoolantVolSegDisp) * 10 ;
#endif

    CopyData[0] = (uint8_t)(((Water_Temp_Level << 6u) & 0xC0u) |
                            ((Remining_Fuel_Warning << 5u) & 0x20u) |
                            ((Battery_Maintenance_Warning << 3u) & 0x18u) |
                            ((Over_Heat_Warning_Status << 2u) & 0x04u) |
                            (Meter_Malfunction & 0x03u)); /* 1  */
    CopyData[1] = (uint8_t)(((SRS_Input << 7u) & 0x80u) |
                            ((SW_Rear_Body_Warning << 6u) & 0x040u) |
                            ((SW_Sheetbelt << 5u) & 0x20u) |
                            ((SW_Oil_Pressure << 4u) & 0x10u) |
                            ((SW_Coolant_Level << 3u) & 0x08u) |
                            ((SW_Water_Separator << 2u) & 0x04u) |
                            ((SW_Clutch << 1u) & 0x02u) |
                            (SW_Air_Low_Pressure & 0x01u)); /* 2  */
    CopyData[2] = (uint8_t)(((SW_MT_Range << 7u) & 0x80u) |
                            ((SW_MT_Spriter << 6u) & 0x040u) |
                            ((SW_KickDrive << 5u) & 0x20u) |
                            ((SW_DefLock << 4u) & 0x10u) |
                            ((ACG_L_Terminal << 3u) & 0x08u) |
                            ((SW_Dr_Door << 1u) & 0x02u) |
                            (EDS_Smoother_WL_Status & 0x01u)); /* 3  */
    CopyData[3] = (uint8_t)(((EBS_Warning_Red << 7u) & 0x80u) |
                            ((EBS_Warning_Yellow << 6u) & 0x040u) |
                            ((ESC_Operating << 5u) & 0x20u) |
                            ((Air_Sus_Warning << 4u) & 0x10u) |
                            ((Roll_Warning << 3u) & 0x08u) |
                            ((ROWS_Warning << 2u) & 0x04u) |
                            (Mult_Indication & 0x03u)); /* 4  */
    CopyData[4] = (uint8_t)(((SW_KeyRemind << 7u) & 0x80u) |
                            ((SW_Hi_Beam << 6u) & 0x040u) |
                            ((TURN_R_Lamp_Status << 5u) & 0x20u) |
                            ((SW_Illmi << 3u) & 0x08u) |
                            ((SW_SpotLamp << 1u) & 0x02u) |
                            (SW_Accessory_Air & 0x01u)); /* 5  */
    CopyData[5] = (uint8_t)(((SW_Trailer_Brake << 6u) & 0xC0u) |
                            ((Input_Trailer_Info << 5u) & 0x20u) |
                            ((Input_Trailer_ABS << 4u) & 0x10u) |
                            ((SW_Coupler_Lock << 3u) & 0x04u) |
                            (SW_Parking & 0x03)); /* 6  */
    CopyData[6] = (uint8_t)(IGN_Voltage & 0xFFu); /* 7  */
    CopyData[7] = (uint8_t)(((MJX_MEB9_Manual_TM_Range_Low << 7u) & 0x80u) |
                            ((Range_Air_Cut_Warning << 6u) & 0x40u) |
                            ((IRIS_Warning_Lamp_Status << 5u) & 0x20u)); /* 8  */
}

/*-------------------------------------------------------------------------
 * Function Name  : Can_Set_Buff_18FF9D17
 * Description    :
 * Input          : None 18FF9D17
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Can_Set_Buff_18FF9D17(uint8_t CopyData[])
{
    uint8_t Fuel_Level = 0u;

    uint16_t Get_Step = 0u;
    Get_Step = Fuel_Get_Step();

    /*燃油剩余百分比     精度 1% 偏移量 0 */
    if (Get_Step > 10u)
    {
        Fuel_Level = (uint8_t)((Get_Step - 10u) * 100u / 120u);
    }
    else
    {
        Fuel_Level = 0u;
    }

    CopyData[0] = (uint8_t)(Fuel_Level & 0xFFu); /* 1  */
    CopyData[1] = 0u;                            /* 2  */
    CopyData[2] = 0u;                            /* 3  */
    CopyData[3] = 0u;                            /* 4  */
    CopyData[4] = 0u;                            /* 5  */
    CopyData[5] = 0u;                            /* 6  */
    CopyData[6] = 0u;                            /* 7  */
    CopyData[7] = 0u;                            /* 8  */
}

/*-------------------------------------------------------------------------
 * Function Name  : Can_Set_Buff_18FFE517
 * Description    :
 * Input          : None  18FFE517
 * Output         : None
 * Return         : None
 * onther         : Event triggered   事件型报文
 --------------------------------------------------------------------------*/
void Can_Set_Buff_18FFE517(uint8_t CopyData[])
{
    uint8_t DTC_Clear_Request = 0u;
    uint8_t Req_0Point = 0u;
    uint8_t Ferry_Mode_Cancel = 0u;
    uint8_t System_Demonstration_Request = 0u;

    DTC_Clear_Request = 0u;
    Req_0Point = 0u;
    Ferry_Mode_Cancel = 0u;
    System_Demonstration_Request = 0u;

    CopyData[0] = (uint8_t)(DTC_Clear_Request & 0xFFu); /* 1  */
    CopyData[1] = (uint8_t)(Req_0Point & 0xFFu);        /* 2  */
    CopyData[2] = (uint8_t)(((Ferry_Mode_Cancel << 7u) & 0x80U) |
                            (System_Demonstration_Request & 0x7Fu)); /* 3  */
    CopyData[3] = 0u;                                                /* 4  */
    CopyData[4] = 0u;                                                /* 5  */
    CopyData[5] = 0u;                                                /* 6  */
    CopyData[6] = 0u;                                                /* 7  */
    CopyData[7] = 0u;                                                /* 8  */
}
/*-------------------------------------------------------------------------
 * Function Name  : Can_Set_Buff_18EF2D17
 * Description    :
 * Input          : None 18EF2D17  未见此报文
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Can_Set_Buff_18EF2D17(uint8_t CopyData[])
{
    CopyData[0] = 0u; /* 1  */
    CopyData[1] = 0u; /* 2  */
    CopyData[2] = 0u; /* 3  */
    CopyData[3] = 0u; /* 4  */
    CopyData[4] = 0u; /* 5  */
    CopyData[5] = 0u; /* 6  */
    CopyData[6] = 0u; /* 7  */
    CopyData[7] = 0u; /* 8  */
}
/*-------------------------------------------------------------------------
 * Function Name  : Can_Set_Buff_18033317
 * Description    : 胎压匹配外发报文 事件型
 * Input          : None  18033317
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Can_Set_Buff_18033317(uint8_t CopyData[])
{
    uint8_t Pair_cmd = 0u;

    if (User_set_Num.User_TpmsStatus == 2)
    {
        CopyData[0] = 0x61u;
        switch (User_set_Num.User_Tpms)
        {
        case 1 :
            CopyData[1] = 0x12;
            break;
        case 2 :
            CopyData[1] = 0x13;
            break;
        case 3 :
            CopyData[1] = 0x22;
            break;
        case 4 :
            CopyData[1] = 0x23;
            break;
        case 5 :
            CopyData[1] = 0x31;
            break;
        case 6 :
            CopyData[1] = 0x32;
            break;
        case 7 :
            CopyData[1] = 0x33;
            break;
        case 8 :
            CopyData[1] = 0x34;
            break;
        case 9 :
            CopyData[1] = 0x41;
            break;
        case 10 :
            CopyData[1] = 0x42;
            break;
        case 11 :
            CopyData[1] = 0x43;
            break;
        case 12 :
            CopyData[1] = 0x44;
            break;
        default    :
            break   ;
        }
    }
    else
    {
        CopyData[0] = 0x91;                        /* 1  */
        CopyData[1] = 0u;                          /* 2  */
    }

    CopyData[2] = 0u;                          /* 3  */
    CopyData[3] = 0u;                          /* 4  */
    CopyData[4] = 0u;                          /* 5  */
    CopyData[5] = 0u;                          /* 6  */
    CopyData[6] = 0u;                          /* 7  */
    CopyData[7] = 0u;                          /* 8  */

    User_set_Num.User_TpmsSend = 0u;
}
void Id18033317_Send_Service(void)
{
    if (User_set_Num.User_TpmsSend == 3u)
    {
        Can_Msg_Tx_Overwrite(MSGID_18033317, 3u, 50 * 1000);
    }
}
/*-------------------------------------------------------------------------
 * Function Name  : Can_Set_Buff_180433A2
 * Description    :
 * Input          : None 180433A2
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Can_Set_Buff_180433A2(uint8_t CopyData[])
{
    uint8_t Setup_cmd = 0u;

    Setup_cmd = 0u;

    CopyData[0] = (uint8_t)(Setup_cmd & 0xFFu); /* 1  */
    CopyData[1] = 0u;                           /* 2  */
    CopyData[2] = 0u;                           /* 3  */
    CopyData[3] = 0u;                           /* 4  */
    CopyData[4] = 0u;                           /* 5  */
    CopyData[5] = 0u;                           /* 6  */
    CopyData[6] = 0u;                           /* 7  */
    CopyData[7] = 0u;                           /* 8  */
}

/*-------------------------------------------------------------------------
 * Function Name  : Can_Set_Buff_18EF1817
 * Description    :
 * Input          : None 18EF1817
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Can_Set_Buff_18EF1817(uint8_t CopyData[])
{
    uint8_t Trip_Type = 0u;

    if (State_Flag.FState_ClearOilTx == 0x02u)
    {
        if (Trip_Type == TRAPA)
        {
            CopyData[0] = 0x40;
            CopyData[1] = 0x50;
            CopyData[2] = 0x00;
            CopyData[3] = 0x00;
            CopyData[4] = 0x00;
            CopyData[5] = 0x00;
            CopyData[6] = 0xFF;
            CopyData[7] = 0xFF;
        }
        else if (Trip_Type == TRAPB)
        {
            CopyData[0] = 0x40;
            CopyData[1] = 0x60;
            CopyData[2] = 0x00;
            CopyData[3] = 0x00;
            CopyData[4] = 0x00;
            CopyData[5] = 0x00;
            CopyData[6] = 0xFF;
            CopyData[7] = 0xFF;
        }

        User_BCM_Flag = 1u; /*从头轮询*/
        State_Flag.FState_ClearOilTx = 0x00u;
        State_Flag.FState_ClearOilRx = 0u;
        State_Flag.FState_COilTimeOut = 0u;
    }
    else
    {
        if ((State_Flag.FState_ClearOilRx == 0u) && (State_Flag.FState_COilTimeOut != FState_COilTimeOutNum))
        {
            return;
        }

        User_BCM_Flag++;
        if (User_BCM_Flag > 11u)
        {
            User_BCM_Flag = 1u;
        }

        switch (User_BCM_Flag)
        {
        case 1:
            CopyData[0] = 0x01;
            CopyData[1] = 0x50;
            CopyData[2] = 0x00;
            CopyData[3] = 0x00;
            CopyData[4] = 0x00;
            CopyData[5] = 0x00;
            CopyData[6] = 0xFF;
            CopyData[7] = 0xFF;
            break;
        case 2:
            CopyData[0] = 0x01;
            CopyData[1] = 0x51;
            CopyData[2] = 0x00;
            CopyData[3] = 0x00;
            CopyData[4] = 0x00;
            CopyData[5] = 0x00;
            CopyData[6] = 0xFF;
            CopyData[7] = 0xFF;
            break;
        case 3:
            CopyData[0] = 0x01;
            CopyData[1] = 0x52;
            CopyData[2] = 0x00;
            CopyData[3] = 0x00;
            CopyData[4] = 0x00;
            CopyData[5] = 0x00;
            CopyData[6] = 0xFF;
            CopyData[7] = 0xFF;
            break;
        case 4:
            CopyData[0] = 0x01;
            CopyData[1] = 0x53;
            CopyData[2] = 0x00;
            CopyData[3] = 0x00;
            CopyData[4] = 0x00;
            CopyData[5] = 0x00;
            CopyData[6] = 0xFF;
            CopyData[7] = 0xFF;
            break;
        case 5:
            CopyData[0] = 0x01;
            CopyData[1] = 0x54;
            CopyData[2] = 0x00;
            CopyData[3] = 0x00;
            CopyData[4] = 0x00;
            CopyData[5] = 0x00;
            CopyData[6] = 0xFF;
            CopyData[7] = 0xFF;
            break;
        case 6:
            CopyData[0] = 0x01;
            CopyData[1] = 0x60;
            CopyData[2] = 0x00;
            CopyData[3] = 0x00;
            CopyData[4] = 0x00;
            CopyData[5] = 0x00;
            CopyData[6] = 0xFF;
            CopyData[7] = 0xFF;
            break;
        case 7:
            CopyData[0] = 0x01;
            CopyData[1] = 0x61;
            CopyData[2] = 0x00;
            CopyData[3] = 0x00;
            CopyData[4] = 0x00;
            CopyData[5] = 0x00;
            CopyData[6] = 0xFF;
            CopyData[7] = 0xFF;
            break;
        case 8:
            CopyData[0] = 0x01;
            CopyData[1] = 0x62;
            CopyData[2] = 0x00;
            CopyData[3] = 0x00;
            CopyData[4] = 0x00;
            CopyData[5] = 0x00;
            CopyData[6] = 0xFF;
            CopyData[7] = 0xFF;
            break;
        case 9:
            CopyData[0] = 0x01;
            CopyData[1] = 0x63;
            CopyData[2] = 0x00;
            CopyData[3] = 0x00;
            CopyData[4] = 0x00;
            CopyData[5] = 0x00;
            CopyData[6] = 0xFF;
            CopyData[7] = 0xFF;
            break;
        case 10:
            CopyData[0] = 0x01;
            CopyData[1] = 0x64;
            CopyData[2] = 0x00;
            CopyData[3] = 0x00;
            CopyData[4] = 0x00;
            CopyData[5] = 0x00;
            CopyData[6] = 0xFF;
            CopyData[7] = 0xFF;
            break;
        case 11:
            CopyData[0] = 0x01;
            CopyData[1] = 0x22;
            CopyData[2] = 0x00;
            CopyData[3] = 0x00;
            CopyData[4] = 0x00;
            CopyData[5] = 0x00;
            CopyData[6] = 0xFF;
            CopyData[7] = 0xFF;
            break;
        default:
            break;
        }
    }
}

void Id18EF1817_Send_Service(void)
{
    /*准备事件型*/
    if (State_Flag.FState_ClearOilTx == 1u)
    {
        Can_Msg_Tx_Overwrite(MSGID_18EF1817, 1u, 100 * 1000);
        /*事件型复制*/
        State_Flag.FState_ClearOilTx = 2u;
    }
    else
    {
        if ((State_Flag.FState_ClearOilRx == 0u) && (State_Flag.FState_COilTimeOut != FState_COilTimeOutNum))
        {
            Can_Msg_Tx_Overwrite(MSGID_18EF1817, 0u, 100 * 1000);
        }
        else
        {
            Can_Msg_Tx_Overwrite(MSGID_18EF1817, 0xFFFFu, 100 * 1000);
        }
    }
}

/*-------------------------------------------------------------------------
 * Function Name  : Drive_Info_IC1_STATUS_Rx
 * Description    : 18EF1718 报文循环接收处理  100ms任务中执行
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Drive_Info_IC1_STATUS_Rx(void)
{
    uint32_t Temp = 0u;
    uint8_t Data_Sig = 0u;
    uint8_t Data_Type = 0u;

    Data_Sig = Get_ID_18EF1718_Sig_Response_Code();
    Data_Type = Get_ID_18EF1718_Sig_Data_Type();
    Temp = Get_ID_18EF1718_Sig_Date();

    switch (Data_Sig)
    {
    case 0x81:
        switch (Data_Type)
        {
        case 0x50:
            User_ECU.TripA_Fuel = Temp;
            break;
        case 0x51:
            User_ECU.TripA_Average_Speed = Temp;
            break;
        case 0x52:
            User_ECU.TripA_Fuel_Consume = Temp;
            break;
        case 0x53:
            User_ECU.TripA_Idling = Temp;
            break;
        case 0x54:
            User_ECU.TripA_Runing = Temp;
            break;
        case 0x60:
            User_ECU.TripB_Fuel = Temp;
            break;
        case 0x61:
            User_ECU.TripB_Average_Speed = Temp;
            break;
        case 0x62:
            User_ECU.TripB_Fuel_Consume = Temp;
            break;
        case 0x63:
            User_ECU.TripB_Idling = Temp;
            break;
        case 0x64:
            User_ECU.TripB_Runing = Temp;
            break;
        case 0x22:
            User_ECU.Engine_Surplus = Temp;
            break;
        default:
            break;
        }
        break;
    case 0x40:
        switch (Data_Type)
        {
        case 0x50:
            User_ECU.TripA_Fuel = Temp;
            break;
        case 0x51:
            User_ECU.TripA_Average_Speed = Temp;
            break;
        case 0x52:
            User_ECU.TripA_Fuel_Consume = Temp;
            break;
        case 0x53:
            User_ECU.TripA_Idling = Temp;
            break;
        case 0x54:
            User_ECU.TripA_Runing = Temp;
            break;
        case 0x60:
            User_ECU.TripB_Fuel = Temp;
            break;
        case 0x61:
            User_ECU.TripB_Average_Speed = Temp;
            break;
        case 0x62:
            User_ECU.TripB_Fuel_Consume = Temp;
            break;
        case 0x63:
            User_ECU.TripB_Idling = Temp;
            break;
        case 0x64:
            User_ECU.TripB_Runing = Temp;
            break;
        case 0x22:
            User_ECU.Engine_Surplus = Temp;
            break;
        default:
            break;
        }
        break;
    default:
        break;
    }

#if 0
    if (State_Flag.FState_COilTimeOut < FState_COilTimeOutNum)
    {
        State_Flag.FState_COilTimeOut++;

        if (State_Flag.FState_COilTimeOut == FState_COilTimeOutNum)
        {
            State_Flag.FState_ClearOilTx = 0u;
        }
    }

    if (Data_Sig == 0x40u)
    {
        State_Flag.FState_ClearOilRx == 1;
    }
#endif
}

void Drive_Info_IC3_STATUS_Rx(void)
{
    if (bCurMenuIDX != _MN_DSP_LEVEL3_4_MENU_5)
    {
        if (TPMS_Matching.FLAG == 1)
            return;

        TPMS_Matching.T01 = 0u;
        TPMS_Matching.T02 = 0u;
        TPMS_Matching.T03 = 0u;
        TPMS_Matching.T04 = 0u;
        TPMS_Matching.T05 = 0u;
        TPMS_Matching.T06 = 0u;
        TPMS_Matching.T07 = 0u;
        TPMS_Matching.T08 = 0u;
        TPMS_Matching.T09 = 0u;
        TPMS_Matching.T10 = 0u;
        TPMS_Matching.T11 = 0u;
        TPMS_Matching.T12 = 0u;

        TPMS_Matching.FLAG = 1u;
    }

    if ((Msg_18021733[0] == 0x61) && (Common_Get_TPMS_TEST_OFF_Time_Sta() == 0))
    {
        TPMS_Matching.FLAG = 0;

        Msg_18021733[0] = 0;

        if ((User_set_Num.User_TpmsStatus == 2) && (User_set_Num.User_TpmsSend == 0))
        {
            switch (User_set_Num.User_Tpms)
            {
            case 1:
                TPMS_Matching.T01 = 1;
                break;
            case 2:
                TPMS_Matching.T02 = 1;
                break;
            case 3:
                TPMS_Matching.T03 = 1;
                break;
            case 4:
                TPMS_Matching.T04 = 1;
                break;
            case 5:
                TPMS_Matching.T05 = 1;
                break;
            case 6:
                TPMS_Matching.T06 = 1;
                break;
            case 7:
                TPMS_Matching.T07 = 1;
                break;
            case 8:
                TPMS_Matching.T08 = 1;
                break;
            case 9:
                TPMS_Matching.T09 = 1;
                break;
            case 10:
                TPMS_Matching.T10 = 1;
                break;
            case 11:
                TPMS_Matching.T11 = 1;
                break;
            case 12:
                TPMS_Matching.T12 = 1;
                break;
            default:
                break;
            }

            User_set_Num.User_Tpms ++;

            if (User_set_Num.User_Tpms == 0x0d)
                User_set_Num.User_TpmsStatus = 0;
            else
                User_set_Num.User_TpmsStatus = 1;
        }
    }
    else  if ((Msg_18021733[0]  == 0xFF) && (Msg_18021733[1]  == 0x06))
    {
        TPMS_Matching.FLAG = 0;

        Msg_18021733[0] = 0;
        Msg_18021733[1] = 0;
        User_set_Num.User_TpmsStatus = 1;
    }
    else if (Common_Get_TPMS_TEST_OFF_Time_Sta() == 1u)
    {
        TPMS_Matching.FLAG = 0;

        Msg_18021733[0] = 0;
        Msg_18021733[1] = 0;
        User_set_Num.User_TpmsStatus = 1;
    }
}

void MSG_18021733_REC_COPY(uint8_t copy[])
{
    uint8_t i = 0u;
    for (i = 0u; i < 8u; i++)
    {
        Msg_18021733[i] = copy[i];
    }
}
/*-------------------------------------------------------------------------
 * Function Name  : Common_Data_Get_TripA_Fuel
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
uint32_t Common_Data_Get_TripA_Fuel(void)
{
    return User_ECU.TripA_Fuel;
}

/*-------------------------------------------------------------------------
 * Function Name  : Common_Data_Get_TripA_Average_Speed
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
uint32_t Common_Data_Get_TripA_Average_Speed(void)
{
    return User_ECU.TripA_Average_Speed;
}

/*-------------------------------------------------------------------------
 * Function Name  : Common_Data_Get_TripB_Fuel
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
uint32_t Common_Data_Get_TripB_Fuel(void)
{
    return User_ECU.TripB_Fuel;
}

/*-------------------------------------------------------------------------
 * Function Name  : Common_Data_Get_TripB_Average_Speed
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
uint32_t Common_Data_Get_TripB_Average_Speed(void)
{
    return User_ECU.TripB_Average_Speed;
}
