/****************************************************************************
 *  License : All rights reserved for TES Electronic Solutions GmbH
 *            See included /docs/license.txt for details
 *  Project : D/AVE HD
 *  Purpose : Operatingsystem abstraction
 ****************************************************************************
 * Version Control Information :
 *  $Revision: 5416 $
 *  $Date: 2015-07-06 15:28:42 +0200 (Mo, 06. Jul 2015) $
 *  $LastChangedBy: florian.zimmermann $
 ****************************************************************************
 * Change History (autogenerated):
 ****************************************************************************/    

#ifndef DAVEHD_KERNEL_OS_H_INCLUDED
#define DAVEHD_KERNEL_OS_H_INCLUDED

#include "davehd_types.h"

/*----------------------------------------------------------------------------------------------------------*/
/**/
typedef enum tagdhd_kalloc_element {
  E_DHD_KALLOC_STATESTORE,
  E_DHD_KALLOC_CONNECTION,  
  E_DHD_KALLOC_VMEMBLOCK,
  E_DHD_KALLOC_VMEMHEAP,

  E_DHD_KALLOC_QUANTITY
} dhd_kalloc_element_t;

/*----------------------------------------------------------------------------------------------------------*/
/* control structure for a kernel side CPU pool*/

typedef struct tagdhd_kalloc_pool {  
  void           *m_memory;                                         /* Start of memory to be used for pool*/
  dhd_uint32_t    m_size;                                           /* Size of memory block in bytes*/
  dhd_uint32_t    m_align;                                          /* Alignment in bytes to be guaranteed*/

} dhd_kalloc_pool_t;


/*----------------------------------------------------------------------------------------------------------*/

typedef void *dhd_lock_t;                                           /* abstract type representing an OS lock */

/*----------------------------------------------------------------------------------------------------------*/

dhd_uint32_t dhd_get_kalloc_size(dhd_kalloc_element_t a_element);

/*----------------------------------------------------------------------------------------------------------*/

void *dhd_kalloc(dhd_kalloc_element_t a_element, dhd_uint32_t a_alignment);
void dhd_kfree(void *a_memory);
#ifdef DHD_KERNEL_USE_POOLING
dhd_enum_t dhd_kalloc_init(void);
dhd_enum_t dhd_kalloc_shutdown(void);
dhd_enum_t dhd_kalloc_setup_pool(dhd_kalloc_element_t a_element, dhd_kalloc_pool_t *a_out);
dhd_enum_t dhd_kalloc_shutdown_pool(dhd_kalloc_element_t a_element, dhd_kalloc_pool_t *a_out);
#endif

/*----------------------------------------------------------------------------------------------------------*/
/* note: passing 0 to enter_lock, exit_lock or destory_lock should be a no-op. the kernel is using this to*/
/* implement the (default) asynchronous mode*/
/**/

dhd_lock_t dhd_create_lock(void);

void dhd_destroy_lock(dhd_lock_t a_lock);

void dhd_enter_lock(dhd_lock_t a_lock);

void dhd_exit_lock(dhd_lock_t a_lock);

/*----------------------------------------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------------------------------------*/

#endif /*DAVEHD_KERNEL_OS_H_INCLUDED*/
