/**********************************************************************************************************
* @file    Data_FuelConsump.h
* @author  qitiancun
* @version V1.0.0
* @date    2020.04.21
* @brief   c header file
********************************************************************************************************/
#include "TYW_stdint.h"

#ifndef _DATA_FUELCONSUMP_H_
#define _DATA_FUELCONSUMP_H_

extern uint32_t OldTotalFuel_Trip;
extern uint8_t EngineType;
extern uint32_t OldTotalFuel_Comprehensive;
extern uint32_t OldTotalFuel_ThisTime;
extern uint32_t OldOdo_ThisTime;

extern void Fuel_Consump_K15_Init(void);


extern void  Fuel_Consump_K30_Init(void);
/*综合油耗*/
extern void Data_FuelCounsComprehensive(void);
extern uint32_t  Get_FuelCounsComprehensive_ToalFuelLitre(void);
extern uint32_t  Get_FuelCounsComprehensive_ODO(void);
extern uint16_t  Get_FuelCounsComprehensive_Value(void);
extern uint32_t  Get_FuelCounsComprehensive_RunTime(void);
/*小计油耗*/
extern void Data_FuelCounsumpTrip(void);
extern void Rest_FuelCounsumpTrip_Data(void);
extern uint32_t  Get_FuelCounsumpTrip_ToalFuelLitre(void);
extern uint32_t  Get_FuelCounsumpTrip_ODO(void);
extern uint16_t  Get_FuelCounsumpTrip_Value(void);
/*本次油耗*/
extern void Data_FuelCounsumpThisTime(void);
extern void Rest_FuelCounsumpThisTime_Data(void);
extern uint32_t  Get_FuelCounsumpThisTime_ToalFuelLitre(void);
extern uint32_t  Get_FuelCounsumpThisTime_ODO(void);
extern uint16_t  Get_FuelCounsumpThisTime_Value(void);
/*加油油行车信息*/
extern void Data_Info_Last_Refueling(void);
extern void  Rest_Refueling_Data(void);
extern uint16_t  Get_Refueling_AVF(void);
extern uint32_t  Get_Refueling_Trip(void);
extern uint32_t  Get_Refueling_ToalFuelLitre(void);

#endif