
#ifndef CLOCK_H__
#define CLOCK_H__

/*Oscillator*/
#define CLOCK_MAIN_OSC_FREQ_HZ (8000000UL)
#define CLOCK_SUB_OSC_FREQ_HZ (0UL) /*32768U*/
#define CLOCK_FAST_CR_OSC_FREQ_HZ (8000000UL)
#define CLOCK_SLOW_CR_OSC_FREQ_HZ (240000UL)
#define CLOCK_EMCLK_FREQ_HZ (CLOCK_FAST_CR_OSC_FREQ_HZ)

/*   PLL  */
#define CLOCK_PLL0_FREQ_HZ (480000000UL)
#define CLOCK_PLL1_FREQ_HZ (480000000UL)
#define CLOCK_PLLFIX_FREQ_HZ (CLOCK_PLL1_FREQ_HZ)

#define CLOCK_JIT_FREQ_HZ (80000000UL)
#define CLOCK_FIX_FREQ_HZ (80000000UL)
#define CLOCK_SDRB_FREQ_HZ (240000000UL)
#define CLOCK_CPU_FREQ_HZ (240000000UL)
#define CLOCK_XC_FREQ_HZ (120000000UL)
#define CLOCK_PCLK_FREQ_HZ (CLOCK_XC_FREQ_HZ / 2)
#define CLOCK_ETNBP_FREQ_HZ (60000000UL)   /*Enable or Disable*/
#define CLOCK_ETNBXC_FREQ_HZ (120000000UL) /*Enable or Disable*/
#define CLOCK_RSCANP_FREQ_HZ (80000000UL)  /*Enable or Disable*/
#define CLOCK_AWOT_FREQ_HZ (8000000UL)
#define CLOCK_WDTA0_FREQ_HZ (240000UL)
#define CLOCK_RTCA_FREQ_HZ (4000000UL)
#define CLOCK_FOUT_FREQ_HZ (20000000UL)
#define CLOCK_SFMA_FREQ_HZ (240000000UL)
#define CLOCK_RSCAN_FREQ_HZ (40000000UL)
#define CLOCK_RSCANXIN_FREQ_HZ (16000000UL) /*MAIN_OSC or Disable*/
#define CLOCK_SSIF_FREQ_HZ (50000000UL)
#define CLOCK_TAUB01_FREQ_HZ (80000000UL)
#define CLOCK_TAUB2_FREQ_HZ (80000000UL)
#define CLOCK_TAUJ_FREQ_HZ (80000000UL)
#define CLOCK_OSTM_FREQ_HZ (80000000UL)
/*#define CLOCK_LCBI_FREQ_HZ (CLOCK_JIT_FREQ_HZ)*/
#define CLOCK_ADCE_FREQ_HZ (40000000UL)
#define CLOCK_ISM_FREQ_HZ (80000000UL)
#define CLOCK_RLIN_FREQ_HZ (48000000UL)





/*    Registers  */
#define   CLOCK_CFG_CLKJIT_DIVIDER           (0x0001010FUL)
#define   CLOCK_CFG_CLKJIT_SOURCE         (0x00210100UL)
#define   CLOCK_CFG_CLKJIT_ACTIVE       (0x00210100UL)


typedef enum
{
  CLOCK_STARTUP_PWR_ON = 0,
  CLOCK_STARTUP_WAKE_UP,
  CLOCK_STARTUP_SYSTEM_RESET,
} Clock_Startup_Mode_en_t;

extern void Clock_Pre_Init(void);
extern void Clock_Init(void);

extern void Clock_Enter_Sleep_Mode(void);
extern Clock_Startup_Mode_en_t Clock_Get_Startup_Mode(void);
extern void Sys_Enter_Sleep_Mode(void);

#endif
