
#ifndef TIMER_B_HEADER__
#define TIMER_B_HEADER__
/*
typedef char char_t;
typedef signed char int8_t;
typedef signed short int16_t;
typedef signed int int32_t;
typedef signed long long int64_t;
typedef unsigned char uint8_t;
typedef unsigned short uint16_t;
typedef unsigned int uint32_t;
typedef unsigned long long uint64_t;
typedef float float32_t;
typedef double float64_t;
*/
#include "r_typedefs.h"

typedef enum
{
	TIMERB_HIGH = 0U,
	TIMERB_LOW,
} TIMERB_Polarity_en_t;

typedef enum
{
	TIMERB_FALL = 0U,
	TIMERB_RISING,
	TIMERB_RISING_FALL,
} TIMERB_Edge_en_t;


typedef enum
{
	TIMERB_CLOCK_0 = 0U,
	TIMERB_CLOCK_1,
	TIMERB_CLOCK_2,
	TIMERB_CLOCK_3,
} TIMERB_Clock_en_t;
typedef enum
{
	TIMERB_0_CH0 = 0,
	TIMERB_0_CH1,
	TIMERB_0_CH2,
	TIMERB_0_CH3,
	TIMERB_0_CH4,
	TIMERB_0_CH5,
	TIMERB_0_CH6,
	TIMERB_0_CH7,
	TIMERB_0_CH8,
	TIMERB_0_CH9,
	TIMERB_0_CH10,
	TIMERB_0_CH11,
	TIMERB_0_CH12,
	TIMERB_0_CH13,
	TIMERB_0_CH14,
	TIMERB_0_CH15,
	TIMERB_1_CH0,
	TIMERB_1_CH1,
	TIMERB_1_CH2,
	TIMERB_1_CH3,
	TIMERB_1_CH4,
	TIMERB_1_CH5,
	TIMERB_1_CH6,
	TIMERB_1_CH7,
	TIMERB_1_CH8,
	TIMERB_1_CH9,
	TIMERB_1_CH10,
	TIMERB_1_CH11,
	TIMERB_1_CH12,
	TIMERB_1_CH13,
	TIMERB_1_CH14,
	TIMERB_1_CH15,
	TIMERB_2_CH0,
	TIMERB_2_CH1,
	TIMERB_2_CH2,
	TIMERB_2_CH3,
	TIMERB_2_CH4,
	TIMERB_2_CH5,
	TIMERB_2_CH6,
	TIMERB_2_CH7,
	TIMERB_2_CH8,
	TIMERB_2_CH9,
	TIMERB_2_CH10,
	TIMERB_2_CH11,
	TIMERB_2_CH12,
	TIMERB_2_CH13,
	TIMERB_2_CH14,
	TIMERB_2_CH15,

} TIMERB_Channel_en_t;

/*-----------------------------------------*/

extern void TimerB_PWM_Init(void);
extern uint8_t TimerB_PWM_Channel_Init(TIMERB_Channel_en_t enTimerBChannel, TIMERB_Clock_en_t enTimerBClock, TIMERB_Polarity_en_t enTimerBPolarity);
extern uint32_t TimerB_PWM_Channel_Fre_Set(TIMERB_Channel_en_t enTimerBChannel, uint16_t u16Fre, uint16_t u16Duty);
/*占空比精度千分之一*/
extern void TimerB_PWM_Channel_Duty_Set(TIMERB_Channel_en_t enTimerBChannel, uint16_t u16Duty);
extern void TimerB_PWM_Channel_Start(TIMERB_Channel_en_t enTimerBChannel);
/*调用该函数后，仅重新调用开始函数功能即可正常使用*/
extern void TimerB_PWM_Channel_Stop(TIMERB_Channel_en_t enTimerBChannel);
/*仅休眠时可调用，调用该函数后需要重新初始化相关通道才可以正常使用。*/
extern void TimerB_PWM_Channel_Sleep(TIMERB_Channel_en_t enTimerBChannel);

/*--------------------------------------------*/
extern void TimerB_Overflow_Isr(void);
extern void TimerB_Input_Isr(TIMERB_Channel_en_t enTimerBChannel);
extern void TimerB_Input_Channel_Stop(TIMERB_Channel_en_t enTimerBChannel);
extern void TimerB_Input_Channel_Start(TIMERB_Channel_en_t enTimerBChannel);
extern void TimerB_Input_Channel_Init(TIMERB_Channel_en_t enTimerBChannel, TIMERB_Clock_en_t enTimerBClock, TIMERB_Edge_en_t enTimerBEdge);
/*----------------------------------------------------------*/
extern void TimerB_Fre_Timeout(uint8_t Time);
extern uint16_t Get_Veh_Fre(void);
extern uint8_t Get_Veh_Fre_Event(void) ;

extern void TimerB_Buzzer_Init(void);
#endif
