#include "UDS_19Service_Filter.h"

/**
  *19服务是否支持功能寻址
  *功能寻址下屏蔽该负反馈
  *@return 负反馈编号
  */
uint8_t UDS_19Service_NRC11(void)
{
    uint8_t NRC = positiveResponse;
    return NRC;
}

/**
  *19服务会话是否支持验证
  *功能寻址下屏蔽该负反馈
  *@return 负反馈编号
  */
uint8_t UDS_19Service_NRC7F(void)
{
    uint8_t NRC = positiveResponse;
    return NRC;
}

/**
  *19服务解锁等级验证
  *@return 负反馈编号
  */
uint8_t UDS_19Service_NRC33(void)
{
    uint8_t NRC = positiveResponse;
    return NRC;
}

/**
  *19服务最小长度验证
  *@return 负反馈编号
  */
uint8_t UDS_19Service_NRC13_MinLengthCheck(void)
{
    uint8_t NRC = positiveResponse;
    if(DiagMSG.msgDLC < 1u)
    {
        NRC = incorrectMessageLength;
        UDS_Service_Response(0x19u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
    }
    else
    {
        NRC = positiveResponse;
    }
    return NRC;
}

/**
  *19服务超出请求范围验证
  *功能寻址下屏蔽该负反馈
  *@return 负反馈编号
  */
uint8_t UDS_19Service_NRC31(void)
{
    uint8_t NRC = positiveResponse;
    return NRC;
}

/**
  *19服务总长度长度验证
  *@return 负反馈编号
  */
uint8_t UDS_19Service_NRC13_TotalLengthCheck(void)
{
    uint8_t NRC = positiveResponse;
    return NRC;
}

/**
  *19服务条件验证
  *@return 负反馈编号
  */
uint8_t UDS_19Service_NRC22(void)
{
    uint8_t NRC = positiveResponse;
    return NRC;
}

/**
  *19服务子功能最小长度验证
  *@return 负反馈编号
  */
uint8_t UDS_19Service_Sub_NRC13_MinLengthCheck(void)
{
    uint8_t NRC = positiveResponse;
    return NRC;
}

/**
  *19服务子功能是否支持验证
  *功能寻址下屏蔽该负反馈
  *@return 负反馈编号
  */
uint8_t UDS_19Service_Sub_NRC12(void)
{
    uint8_t NRC = positiveResponse;
    if((DiagMSG.msgData.SidDetail.SubID == ReportNumberOfDTCByStatusMask) || (DiagMSG.msgData.SidDetail.SubID == ReportDTCByStatusMask) /*|| (DiagMSG.msgData.SidDetail.SubID == ReportDTCSnapshotRecordByDTCNumber)*/ || (DiagMSG.msgData.SidDetail.SubID == ReportSupportedDTC))
    {
        if(DiagMSG.msgData.SidDetail.PositiveSuppression == 0u)
        {
            NRC = positiveResponse;
        }
        else
        {
            NRC = subFunctionNotSupported;
            if(DiagMSG.msgID == DIAG_ID_Rx_PHY)
            {
                UDS_Service_Response(0x19u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
            }
        }
    }
    else
    {
        NRC = subFunctionNotSupported;
        if(DiagMSG.msgID == DIAG_ID_Rx_PHY)
        {
            UDS_Service_Response(0x19u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
        }
    }
    return NRC;
}

/**
  *19服务子功能会话是否支持验证
  *功能寻址下屏蔽该负反馈
  *@return 负反馈编号
  */
uint8_t UDS_19Service_Sub_NRC7E(void)
{
    uint8_t NRC = positiveResponse;
    return NRC;
}

/**
  *19服务子功能超出请求范围验证
  *功能寻址下屏蔽该负反馈
  *@return 负反馈编号
  */
uint8_t UDS_19Service_Sub_NRC31(void)
{
    uint8_t  i;
    uint8_t  NRC = positiveResponse;
    /*uint32_t DTC;
    if(DiagMSG.msgData.SidDetail.SubID == ReportDTCSnapshotRecordByDTCNumber)
    {
        if(DiagMSG.msgDLC == 5u)
        {
            DTC = ((uint32_t)DiagMSG.msgData.SidDetail.Data[0] << 16u) | ((uint32_t)DiagMSG.msgData.SidDetail.Data[1] << 8u) | (uint32_t)DiagMSG.msgData.SidDetail.Data[2];
            for(i = 0u; i < (sizeof(DTCList) / sizeof(DTCList[0u])); ++i)
            {
                if(DTCList[i][0] == DTC)
                {
                    if(DTCList[i][1] == NoSupport)
                    {
                        NRC = requestOutOfRange;
                        if(DiagMSG.msgID == DIAG_ID_Rx_PHY)
                        {
                            UDS_Service_Response(0x19u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
                        }
                    }
                    else
                    {
                        if((DiagMSG.msgData.SidDetail.Data[3] == 0xFFu) || (DiagMSG.msgData.SidDetail.Data[3] == 0x01u))
                        {
                            NRC = positiveResponse;
                        }
                        else
                        {
                            NRC = requestOutOfRange;
                            if(DiagMSG.msgID == DIAG_ID_Rx_PHY)
                            {
                                UDS_Service_Response(0x19u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
                            }
                        }
                    }
                    break;
                }
            }
            if((i == (sizeof(DTCList) / sizeof(DTCList[0u])))&&(DiagMSG.msgID == DIAG_ID_Rx_PHY))
            {
                NRC = requestOutOfRange;
                if(DiagMSG.msgID == DIAG_ID_Rx_PHY)
                {
                    UDS_Service_Response(0x19u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
                }
            }
        }
    }*/
    return NRC;
}

/**
  *19服务子功能总长度长度验证
  *@return 负反馈编号
  */
uint8_t UDS_19Service_Sub_NRC13_TotalLengthCheck(void)
{
    uint8_t NRC = positiveResponse;
    if(DiagMSG.msgData.SidDetail.SubID == ReportNumberOfDTCByStatusMask)
    {
        if(DiagMSG.msgDLC != 2u)
        {
            NRC = incorrectMessageLength;
            UDS_Service_Response(0x19u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
        }
        else
        {
            NRC = positiveResponse;
        }
    }
    if(DiagMSG.msgData.SidDetail.SubID == ReportDTCByStatusMask)
    {
        if(DiagMSG.msgDLC != 2u)
        {
            NRC = incorrectMessageLength;
            UDS_Service_Response(0x19u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
        }
        else
        {
            NRC = positiveResponse;
        }
    }
    if(DiagMSG.msgData.SidDetail.SubID == ReportDTCSnapshotRecordByDTCNumber)
    {
        if(DiagMSG.msgDLC != 5u)
        {
            NRC = incorrectMessageLength;
            UDS_Service_Response(0x19u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
        }
        else
        {
            NRC = positiveResponse;
        }
    }
    /*if(DiagMSG.msgData.SidDetail.SubID == ReportSupportedDTC)
    {
        if(DiagMSG.msgDLC != 1u)
        {
            NRC = incorrectMessageLength;
            UDS_Service_Response(0x19u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
        }
        else
        {
            NRC = positiveResponse;
        }
    }*/
    return NRC;
}

/**
  *19服务子功能请求顺序验证
  *@return 负反馈编号
  */
uint8_t UDS_19Service_Sub_NRC24(void)
{
    uint8_t NRC = positiveResponse;
    return NRC;
}

/**
  *19服务子功能条件验证
  *@return 负反馈编号
  */
uint8_t UDS_19Service_Sub_NRC22(void)
{
    uint8_t NRC = positiveResponse;
    return NRC;
}
