/****************************************************************************
 *  License : All rights reserved for TES Electronic Solutions GmbH
 *            See included /docs/license.txt for details
 *  Project : D/AVE HD
 *  Purpose : C register parameter defines
 ****************************************************************************
 * Version Control Information :
 * DO NOT EDIT THIS FILE - This file will be automatically generated by
 * 'gen_type_headers_sw.py'
 ****************************************************************************
 * Change History (autogenerated):
 ****************************************************************************/    

#ifndef DAVEHD_REGISTERPARAMS_D1MX_H_INCLUDED
#define DAVEHD_REGISTERPARAMS_D1MX_H_INCLUDED

/* COLOR_PASS_ID_WIDTH: Selector width required to select a color unit pass. Needs to be big enough to encode MAX_COLOR_PASSES-1.*/
#define DHD_PARAM_COLOR_PASS_ID_WIDTH (2)

/* COL_ADD1_WIDTH: Width of Adder1 output in color unit*/
#define DHD_PARAM_COL_ADD1_WIDTH (11)

/* COL_ADD2_WIDTH: Width of Adder2 output in color unit*/
#define DHD_PARAM_COL_ADD2_WIDTH (11)

/* COL_ADD3_WIDTH: Width of Adder3 output in color unit*/
#define DHD_PARAM_COL_ADD3_WIDTH (16)

/* COL_MUL_WIDTH: Width of multiplier output in color unit*/
#define DHD_PARAM_COL_MUL_WIDTH (21)

/* COL_OP1A_WIDTH: Width of Op1a input to adder in color unit*/
#define DHD_PARAM_COL_OP1A_WIDTH (10)

/* COL_OP1B_WIDTH: Width of Op1b input to adder in color unit*/
#define DHD_PARAM_COL_OP1B_WIDTH (10)

/* COL_OP2A_WIDTH: Width of Op2a input to adder in color unit*/
#define DHD_PARAM_COL_OP2A_WIDTH (10)

/* COL_OP2B_WIDTH: Width of Op2b input to adder in color unit*/
#define DHD_PARAM_COL_OP2B_WIDTH (10)

/* COL_OP3_WIDTH: Width of Op3 input to adder in color unit*/
#define DHD_PARAM_COL_OP3_WIDTH (10)

/* DAVEHD_COMPLIANT: configure registers and types to be DAVE HD compliant*/
#define DHD_PARAM_DAVEHD_COMPLIANT (4)

/* CONFIG_COMPLIANCE: configure registers and types accordingly*/
#define DHD_PARAM_CONFIG_COMPLIANCE (DHD_PARAM_DAVEHD_COMPLIANT)

/* DAVE2_COMPLIANT: configure registers and types to be DAVE2 compliant*/
#define DHD_PARAM_DAVE2_COMPLIANT (2)

/* DAVE3_COMPLIANT: configure registers and types to be DAVE3 compliant*/
#define DHD_PARAM_DAVE3_COMPLIANT (3)

/* FBCACHE_WORD_SEL_WIDTH: Selector width required to select a MBI data word in a framebuffer cache line. Number of MBI data words per framebuffer cache line (line length) is 2^FBCACHE_WORD_SEL_WIDTH.*/
#define DHD_PARAM_FBCACHE_WORD_SEL_WIDTH (4)

/* FBCACHE_LINE_LENGTH: Number of words per line in the framebuffer cache*/
#define DHD_PARAM_FBCACHE_LINE_LENGTH (1<<DHD_PARAM_FBCACHE_WORD_SEL_WIDTH)

/* FBCACHE_LINE_SEL_WIDTH: Selector width required to select a framebuffer cache line. Total number of framebuffer cache lines is 2^FBCACHE_LINE_SEL_WIDTH.*/
#define DHD_PARAM_FBCACHE_LINE_SEL_WIDTH (3)

/* FBCACHE_NUM_LINES: Number of lines in the framebuffer cache*/
#define DHD_PARAM_FBCACHE_NUM_LINES (1<<DHD_PARAM_FBCACHE_LINE_SEL_WIDTH)

/* FBCACHE_OUTSTANDING_READ_QUEUE_ADDR_WIDTH: Number of address bits of the FIFO for the outstanding reads in the framebuffer cache. Maximum number of outstanding framebuffer cache read requests is 2^FBCACHE_OUTSTANDING_READ_QUEUE_ADDR_WIDTH.*/
#define DHD_PARAM_FBCACHE_OUTSTANDING_READ_QUEUE_ADDR_WIDTH (3)

/* FBCACHE_PREFETCH_QUEUE_ADDR_WIDTH: Number of address bits of the FIFO implementing the framebuffer cache prefetch queue. Maximum number of prefetchable framebuffer cache lines is 2^FBCACHE_PREFETCH_QUEUE_ADDR_WIDTH.*/
#define DHD_PARAM_FBCACHE_PREFETCH_QUEUE_ADDR_WIDTH (3)

/* FBREAD_FIFO_ADDR_WIDTH: Address width of the pixel FIFO before the framebuffer read. Depth of the FIFO is 2^FBREAD_FIFO_ADDR_WIDTH.*/
#define DHD_PARAM_FBREAD_FIFO_ADDR_WIDTH (8)

/* FBREAD_FIFO_DEPTH: Depth of the FIFO before the framebuffer cache read*/
#define DHD_PARAM_FBREAD_FIFO_DEPTH (1<<DHD_PARAM_FBREAD_FIFO_ADDR_WIDTH)

/* HW_REVISION: Current HW revision*/
#define DHD_PARAM_HW_REVISION (4)

/* HW_VERSION_MAJOR: Current major HW version */
#define DHD_PARAM_HW_VERSION_MAJOR (0)

/* HW_VERSION_MINOR: Current minor HW version */
#define DHD_PARAM_HW_VERSION_MINOR (5)

/* INTERNAL_REGISTER_READ_POSSIBLE: Read access to internal registers through STC resp. stream dumping available or not.*/
#define DHD_PARAM_INTERNAL_REGISTER_READ_POSSIBLE (1)

/* L1_TEXCACHE_BUFFER_ADDR_WIDTH: Selector width required to select an MBI data word in the L1 texture cache buffer (buffering the cache RAM accesses). Number of bufferable MBI data words is 2^L1_TEXCACHE_BUFFER_ADDR_WIDTH.*/
#define DHD_PARAM_L1_TEXCACHE_BUFFER_ADDR_WIDTH (3)

/* L1_TEXCACHE_BUFFER_SIZE: number of MBI words in the texel buffer of the L1 texture cache*/
#define DHD_PARAM_L1_TEXCACHE_BUFFER_SIZE (1<<DHD_PARAM_L1_TEXCACHE_BUFFER_ADDR_WIDTH)

/* L1_TEXCACHE_LINES_PER_SET_WIDTH: Selector width required to select a line in a set in the L1 texture cache. Number of lines per set is 2^L1_TEXCACHE_LINES_PER_SET_WIDTH.*/
#define DHD_PARAM_L1_TEXCACHE_LINES_PER_SET_WIDTH (2)

/* L1_TEXCACHE_LINES_PER_SET: Number of lines per set in the L1 texture cache*/
#define DHD_PARAM_L1_TEXCACHE_LINES_PER_SET (1<<DHD_PARAM_L1_TEXCACHE_LINES_PER_SET_WIDTH)

/* L1_TEXCACHE_LINE_LENGTH_WIDTH: Selector width required to select a MBI data word in a line in the L1 texture cache. Number of MBI data words per line (line length) is 2^L1_TEXCACHE_LINE_LENGTH_WIDTH.*/
#define DHD_PARAM_L1_TEXCACHE_LINE_LENGTH_WIDTH (4)

/* L1_TEXCACHE_LINE_LENGTH: Number of words per line in the L1 texture cache.*/
#define DHD_PARAM_L1_TEXCACHE_LINE_LENGTH (1<<DHD_PARAM_L1_TEXCACHE_LINE_LENGTH_WIDTH)

/* L1_TEXCACHE_NUM_SETS_WIDTH: Selector width required to select a set in the L1 texture cache. Number of sets is 2^L1_TEXCACHE_NUM_SETS_WIDTH.*/
#define DHD_PARAM_L1_TEXCACHE_NUM_SETS_WIDTH (1)

/* L1_TEXCACHE_NUM_SETS: Number of sets in the L1 texture cache*/
#define DHD_PARAM_L1_TEXCACHE_NUM_SETS (1<<DHD_PARAM_L1_TEXCACHE_NUM_SETS_WIDTH)

/* L1_TEXCACHE_OUTSTANDING_READ_QUEUE_ADDR_WIDTH: Number of address bits of the FIFO for the outstanding reads in the L1 texture cache. Maximum number of outstanding texture cache read requests is 2^L1_TEXCACHE_OUTSTANDING_READ_QUEUE_ADDR_WIDTH.*/
#define DHD_PARAM_L1_TEXCACHE_OUTSTANDING_READ_QUEUE_ADDR_WIDTH (3)

/* L1_TEXCACHE_PREFETCH_QUEUE_ADDR_WIDTH: Number of address bits of the FIFO implementing the L1 texture cache prefetch queue. Maximum number of prefetchable texture cache lines is 2^L1_TEXCACHE_PREFETCH_QUEUE_ADDR_WIDTH.*/
#define DHD_PARAM_L1_TEXCACHE_PREFETCH_QUEUE_ADDR_WIDTH (3)

/* L1_TEXCACHE_SHADOW_LINE_SEL_WIDTH: Width of a selector for shadow lines for additional prefetch in the texture cache.*/
#define DHD_PARAM_L1_TEXCACHE_SHADOW_LINE_SEL_WIDTH (0)

/* L2_TEXCACHE_LINES_PER_SET: Number of lines per set in the L2 texture cache*/
#define DHD_PARAM_L2_TEXCACHE_LINES_PER_SET (4)

/* L2_TEXCACHE_LINE_LENGTH: Number of words per line in the L2 texture cache*/
#define DHD_PARAM_L2_TEXCACHE_LINE_LENGTH (16)

/* L2_TEXCACHE_NUM_SETS: Number of sets in the L2 texture cache*/
#define DHD_PARAM_L2_TEXCACHE_NUM_SETS (4)

/* LIMITER_FRAC_WIDTH: width of fractional part of limiter values*/
#define DHD_PARAM_LIMITER_FRAC_WIDTH (18)

/* LIMITER_INT_WIDTH: width of integer part of limiter values*/
#define DHD_PARAM_LIMITER_INT_WIDTH (14)

/* MAX_COLOR_PASSES: Maximum number of usable color unit passes. Needs to be at least 2 to support OpenVG.*/
#define DHD_PARAM_MAX_COLOR_PASSES (3)

/* MAX_TEXTURE_UNITS: Maximum number of usable texture units. Needs to be at least 2 to support OpenVG.*/
#define DHD_PARAM_MAX_TEXTURE_UNITS (2)

/* MBI_BURSTCOUNT_WIDTH: Width of MBI burstcount signal. Maximum burst length is 2^BURSTCOUNT_WIDTH+1. Default value for AXI systems should be 4.*/
#define DHD_PARAM_MBI_BURSTCOUNT_WIDTH (4)

/* MBI_BYTE_SEL_WIDTH: Selector width required to select a byte from a MBI data word. MBI data width is 2^MBI_BYTE_SEL_WIDTH bytes.*/
#define DHD_PARAM_MBI_BYTE_SEL_WIDTH (3)

/* MBI_NUM_BYTES: Number of bytes in MBI data*/
#define DHD_PARAM_MBI_NUM_BYTES (1<<DHD_PARAM_MBI_BYTE_SEL_WIDTH)

/* MBI_DATA_WIDTH: Width of MBI data*/
#define DHD_PARAM_MBI_DATA_WIDTH (8*DHD_PARAM_MBI_NUM_BYTES)

/* MBI_MAX_BURST_LENGTH: Maximum length of a burst on MBI. Maximum burst length is 2^BURSTCOUNT_WIDTH+1*/
#define DHD_PARAM_MBI_MAX_BURST_LENGTH (1<<DHD_PARAM_MBI_BURSTCOUNT_WIDTH)

/* MBI_OUTSTANDING_READ_COUNT_WIDTH: Width of a counter to count the number of outstanding reads. Maximum number of outstanding reads is 2^MBI_OUTSTANDING_READ_COUNT_WIDTH-1.*/
#define DHD_PARAM_MBI_OUTSTANDING_READ_COUNT_WIDTH (3)

/* MBI_OUTSTANDING_WRITE_COUNT_WIDTH: Width of a counter to count the number of outstanding writes. Maximum number of outstanding writes is 2^MBI_OUTSTANDING_WRITE_COUNT_WIDTH-1.*/
#define DHD_PARAM_MBI_OUTSTANDING_WRITE_COUNT_WIDTH (3)

/* NUM_CONST_COLORS: Number of constant color registers. Needs to be at least 3 to support OpenVG 1.1.*/
#define DHD_PARAM_NUM_CONST_COLORS (4)

/* NUM_LIMITERS: Number of Limiters*/
#define DHD_PARAM_NUM_LIMITERS (6)

/* NUM_PERF_COUNTERS: Number of performance counter units.*/
#define DHD_PARAM_NUM_PERF_COUNTERS (4)

/* PIXEL_PIPELINE_SEL_WIDTH: Width of a selector signal selecting a pixel pipeline. Number of pixel pipelines is 2^PIXEL_PIPELINE_SEL_WIDTH.*/
#define DHD_PARAM_PIXEL_PIPELINE_SEL_WIDTH (0)

/* NUM_PIXEL_PIPES: Number of pixel pipelines*/
#define DHD_PARAM_NUM_PIXEL_PIPES (1<<DHD_PARAM_PIXEL_PIPELINE_SEL_WIDTH)

/* REGISTER_GROUP_ADDRESS_WIDTH: defining address space of a group in the register file*/
#define DHD_PARAM_REGISTER_GROUP_ADDRESS_WIDTH (6)

/* RLD_FIFO_ADDR_WIDTH: Number of address bits of the RLD FIFO. FIFO must not be deeper than 2 bursts of maximum possible size!*/
#define DHD_PARAM_RLD_FIFO_ADDR_WIDTH (DHD_PARAM_MBI_BURSTCOUNT_WIDTH+1)

/* STC_CALL_STACK_ADDR_WIDTH: Address width of call stack in stream controller. Depth of the call stack is 2^STC_CALL_STACK_ADDR_WIDTH. Needs to be at least 1.*/
#define DHD_PARAM_STC_CALL_STACK_ADDR_WIDTH (2)

/* STC_CALL_STACK_DEPTH: Depth of stream controller call stack*/
#define DHD_PARAM_STC_CALL_STACK_DEPTH (1<<DHD_PARAM_STC_CALL_STACK_ADDR_WIDTH)

/* STRIPE_WIDTH_WIDTH: log2 of width of Stripewidth registers*/
#define DHD_PARAM_STRIPE_WIDTH_WIDTH (8)

/* STR_BURST_SEL_WIDTH: Selector width required to select a MBI burst in the stream reader FIFO. Depth of the stream reader FIFO is 2^(STR_BURST_SEL_WIDTH+STR_BURST_WORD_SEL_WIDTH).*/
#define DHD_PARAM_STR_BURST_SEL_WIDTH (2)

/* STR_BURST_WORD_SEL_WIDTH: Selector width required to select a MBI data word in an MBI burst for the stream reader FIFO. Normal MBI burst length for the stream reader FIFO is 2^STR_BURST_WORD_SEL_WIDTH.*/
#define DHD_PARAM_STR_BURST_WORD_SEL_WIDTH (4)

/* STR_DATA_FIFO_ADDR_WIDTH: address width of STR FIFO*/
#define DHD_PARAM_STR_DATA_FIFO_ADDR_WIDTH (DHD_PARAM_STR_BURST_WORD_SEL_WIDTH+DHD_PARAM_STR_BURST_SEL_WIDTH)

/* STR_LINE_LENGTH: length of a STR burst*/
#define DHD_PARAM_STR_LINE_LENGTH (1<<DHD_PARAM_STR_BURST_WORD_SEL_WIDTH)

/* STR_NUM_LINES: Number of lines in the STR FIFO*/
#define DHD_PARAM_STR_NUM_LINES (1<<DHD_PARAM_STR_BURST_SEL_WIDTH)

/* STR_OUTSTANDING_READ_QUEUE_ADDR_WIDTH: Number of address bits of the FIFO for the outstanding reads in the stream reader. Maximum number of outstanding stream read requests is 2^STR_OUTSTANDING_READ_QUEUE_ADDR_WIDTH.*/
#define DHD_PARAM_STR_OUTSTANDING_READ_QUEUE_ADDR_WIDTH (2)

/* TEXEL_FIFO_ADDR_WIDTH: Address width of the pixel FIFO before the texture read. Depth of the FIFO is 2^TEXEL_FIFO_ADDR_WIDTH.*/
#define DHD_PARAM_TEXEL_FIFO_ADDR_WIDTH (7)

/* TEXEL_FIFO_DEPTH: Depth of the FIFO before the texture read.*/
#define DHD_PARAM_TEXEL_FIFO_DEPTH (1<<DHD_PARAM_TEXEL_FIFO_ADDR_WIDTH)

/* TEXTURE_ID_WIDTH: Selector width required to select a texture unit. Needs to be big enough to encode MAX_TEXTURE_UNITS-1.*/
#define DHD_PARAM_TEXTURE_ID_WIDTH (1)

/* TEX_CLUT_ADDRESS_WIDTH: Address with of the texture CLUT RAM.*/
#define DHD_PARAM_TEX_CLUT_ADDRESS_WIDTH (9)

/* TEX_CLUT_AVAILABLE: A CLUT RAM is available in the texel processing unit. The CLUT RAM is shared with other functionality as well. Needs to be 1 to support OpenVG.*/
#define DHD_PARAM_TEX_CLUT_AVAILABLE (1)

/* TEX_CLUT_DEPTH: Depth of the texture CLUT. Typically 2^TEX_CLUT_ADDRESS_WIDTH, but may be less.*/
#define DHD_PARAM_TEX_CLUT_DEPTH (512)

/* TEX_CLUT_HAS_ALPHA: The CLUT contains full ARGB32 values instead of RGB24 only. Needs to be 1 to support OpenVG.*/
#define DHD_PARAM_TEX_CLUT_HAS_ALPHA (1)

/* TEX_CLUT_REGISTER_ADDRESS: CLUT's address in register map*/
#define DHD_PARAM_TEX_CLUT_REGISTER_ADDRESS (1024*2)

/* TEX_MIRRORING_AVAILABLE: Wrap mode "mirror" for textures is available. Needs to be 1 to support OpenVG.*/
#define DHD_PARAM_TEX_MIRRORING_AVAILABLE (1)

/* TEX_RLD_AVAILABLE: A RLD unit is available as an extra input to TXC*/
#define DHD_PARAM_TEX_RLD_AVAILABLE (1)

/* ZSACACHE_WORD_SEL_WIDTH: Selector width required to select a MBI data word in a ZSA buffer cache line. Number of MBI data words per ZSA buffer cache line (line length) is 2^ZSACACHE_WORD_SEL_WIDTH.*/
#define DHD_PARAM_ZSACACHE_WORD_SEL_WIDTH (4)

/* ZSACACHE_LINE_LENGTH: Number of words per line in the ZSA cache*/
#define DHD_PARAM_ZSACACHE_LINE_LENGTH (1<<DHD_PARAM_ZSACACHE_WORD_SEL_WIDTH)

/* ZSACACHE_LINE_SEL_WIDTH: Selector width required to select a ZSA buffer cache line. Total number of ZSA buffer cache lines is 2^ZSACACHE_LINE_SEL_WIDTH.*/
#define DHD_PARAM_ZSACACHE_LINE_SEL_WIDTH (3)

/* ZSACACHE_NUM_LINES: Number of lines in the ZSA cache*/
#define DHD_PARAM_ZSACACHE_NUM_LINES (1<<DHD_PARAM_ZSACACHE_LINE_SEL_WIDTH)

/* ZSACACHE_OUTSTANDING_READ_QUEUE_ADDR_WIDTH: Number of address bits of the FIFO for the outstanding reads in the ZSA buffer cache. Maximum number of outstanding ZSA buffer cache read requests is 2^FBCACHE_OUTSTANDING_READ_QUEUE_ADDR_WIDTH.*/
#define DHD_PARAM_ZSACACHE_OUTSTANDING_READ_QUEUE_ADDR_WIDTH (3)

/* ZSACACHE_PREFETCH_QUEUE_ADDR_WIDTH: Number of address bits of the FIFO implementing the ZSA buffer cache prefetch queue. Maximum number of prefetchable ZSA buffer cache lines is 2^ZSACACHE_PREFETCH_QUEUE_ADDR_WIDTH.*/
#define DHD_PARAM_ZSACACHE_PREFETCH_QUEUE_ADDR_WIDTH (3)

/* ZSAREAD_FIFO_ADDR_WIDTH: Address width of the pixel FIFO before the ZSA buffer read. Depth of the FIFO is 2^ZSAREAD_FIFO_ADDR_WIDTH.*/
#define DHD_PARAM_ZSAREAD_FIFO_ADDR_WIDTH (8)

/* ZSAREAD_FIFO_DEPTH: Depth of the FIFO before the ZSA buffer read*/
#define DHD_PARAM_ZSAREAD_FIFO_DEPTH (1<<DHD_PARAM_ZSAREAD_FIFO_ADDR_WIDTH)

#endif /*DAVEHD_REGISTERPARAMS_D1MX_H_INCLUDED*/
