#include "CAN_Communication_Matrix.h"
#include "CAN_FUNC.h"
#include "Common_Interface.h"
/* 2021/09/22 11:03:12 */

const st_CAN_SendAttribute    st_CANSendAttr[ID_SEND_TOTAL] =
{
    {0x18FEAE17ul,  200ul * 1000ul,  0ul, 0u, MSG_EXT,  3u, 8u, CAN_MSG_TX_CYCLE,       Can_Set_Buff_18FEAE17, (void *)0},
    {0x18FF3E17ul,  500ul * 1000ul,  1ul, 0u, MSG_EXT,  4u, 8u, CAN_MSG_TX_CYCLE,       Can_Set_Buff_18FF3E17, (void *)0},
    {0x18FED917ul,  100ul * 1000ul,  3ul, 0u, MSG_EXT,  5u, 8u, CAN_MSG_TX_CYCLE,       Can_Set_Buff_18FED917, (void *)0},
    {0x18FEE617ul, 1000ul * 1000ul,  5ul, 0u, MSG_EXT,  6u, 8u, CAN_MSG_TX_CYCLE,       Can_Set_Buff_18FEE617, (void *)0},
    {0x18EF1817ul,    0ul * 1000ul,  7ul, 0u, MSG_EXT,  7u, 8u, CAN_MSG_TX_CYCKE_EVENT, Can_Set_Buff_18EF1817, (void *)0},
    {0x18FEE017ul,  100ul * 1000ul, 11ul, 0u, MSG_EXT,  8u, 8u, CAN_MSG_TX_CYCLE,       Can_Set_Buff_18FEE017, (void *)0},
    {0x18FEFC17ul, 1000ul * 1000ul, 13ul, 0u, MSG_EXT,  9u, 8u, CAN_MSG_TX_CYCLE,       Can_Set_Buff_18FEFC17, (void *)0},
    {0x18FF2517ul, 1000ul * 1000ul, 17ul, 0u, MSG_EXT, 10u, 8u, CAN_MSG_TX_CYCLE,       Can_Set_Buff_18FF2517, (void *)0},
    {0x18FF2A17ul, 2000ul * 1000ul, 19ul, 0u, MSG_EXT, 11u, 8u, CAN_MSG_TX_CYCLE,       Can_Set_Buff_18FF2A17, (void *)0},
    {0x18FF9D17ul,  100ul * 1000ul, 23ul, 0u, MSG_EXT, 12u, 8u, CAN_MSG_TX_CYCLE,       Can_Set_Buff_18FF9D17, (void *)0},
    {0x18FFE517ul,    0ul * 1000ul, 29ul, 0u, MSG_EXT, 13u, 8u, CAN_MSG_TX_CYCKE_EVENT, Can_Set_Buff_18FFE517, Common_SetId18FFE517Msg_TXSUCCESS},
    //{0x18EF2D17ul, 1000ul * 1000ul, 31ul, 0u, MSG_EXT, 13u, 8u, CAN_MSG_TX_CYCLE,       Can_Set_Buff_18EF2D17, (void *)0},
    {0x18033317ul,    0ul * 1000ul, 34ul, 0u, MSG_EXT, 14u, 8u, CAN_MSG_TX_CYCKE_EVENT, Can_Set_Buff_18033317, (void *)0},
    //{0x180433A2ul,  100ul * 1000ul, 47ul, 0u, MSG_EXT, 15u, 8u, CAN_MSG_TX_CYCLE,       Can_Set_Buff_180433A2, (void *)0},
    {0x18EA0017ul, 5000ul * 1000ul, 47ul, 0u, MSG_EXT, 15u, 8u, CAN_MSG_TX_CYCLE,       Can_Set_Buff_18EA0017, (void *)0},
};

const st_CANMsgAttribute CAN_MSG_CONST_ARRAY[ID_TOTAL_MAX] =
{
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FF5510ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        2000ul,
        0x18FF2300ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        2000ul,
        0x18FED900ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0xFFu, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0xFFu, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        3000ul,
        0x18FE5BE8ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FECA0Bul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18011733ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FE4F0Bul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18F0010Bul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        7500ul,
        0xCF02F2Aul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        7500ul,
        0xCF02FA1ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        7500ul,
        0xCF02FA0ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18EBFF03ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18ECFF03ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FECA03ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        2000ul,
        0xCF00400ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        2000ul,
        0x18FEEE00ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0xC0320C8ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0xC0320C0ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0xC0320B8ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0xC0320B0ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0xC0320A8ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0xCFF0F15ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FF4925ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18F00503ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FF8503ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FE4A03ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0xFFu, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FF4100ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x10F007E8ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        2000ul,
        0x18EF1718ul,
        (Common_Set_18EF1718_Msg_Sta),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        2000ul,
        0x18FEE518ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FF3018ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FF1211ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x10FF462Dul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x10FF477Eul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FF5612ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FD7C00ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FECAE8ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0xFFu, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FEED00ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
//    {
//        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
//        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
//        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
//        5000ul,
//        0x18FF3018ul,
//        (( void * )0),
//        (( void * )0),
//        (( void * )0),
//    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18021733ul,
        (( void * )0),
        (MSG_18021733_REC_COPY),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x0C010305ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FECA2Aul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FECAA1ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FECAA0ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FF064Aul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FEE64Aul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FDC40Bul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },


    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FECA00ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FECA10ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18ECFF00ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18EBFF00ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18ECFF0Bul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18EBFF0Bul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18ECFF10ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18EBFF10ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18ECFFA0ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18EBFFA0ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18ECFFE8ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18EBFFE8ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
};

uint8_t  Get_ID_18FF5510_Sig_Intarder_Pilot_Lamp_State(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FF5510_Msg_Count, 0u) >> 0u) & 0x03u));
}

uint8_t  Get_ID_18FF2300_Sig_EXH_System(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FF2300_Msg_Count, 6u) >> 4u) & 0x03u));
}

uint8_t  Get_ID_18FF2300_Sig_Engine_Derate(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FF2300_Msg_Count, 6u) >> 2u) & 0x03u));
}

uint8_t  Get_ID_18FF2300_Sig_Amber3(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FF2300_Msg_Count, 2u) >> 4u) & 0x03u));
}

uint8_t  Get_ID_18FF2300_Sig_Amber2(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FF2300_Msg_Count, 2u) >> 2u) & 0x03u));
}

uint8_t  Get_ID_18FF2300_Sig_Amber1(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FF2300_Msg_Count, 2u) >> 0u) & 0x03u));
}

uint8_t  Get_ID_18FF2300_Sig_Level_blinking(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FF2300_Msg_Count, 3u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FF2300_Sig_Tank_Level(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FF2300_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FF2300_Sig_Glow_Lamp(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FF2300_Msg_Count, 1u) >> 4u) & 0x03u));
}

uint8_t  Get_ID_18FF2300_Sig_Exh_Lamp(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FF2300_Msg_Count, 1u) >> 0u) & 0x03u));
}

uint8_t  Get_ID_18FED900_Sig_PTO_SW(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FED900_Msg_Count, 1u) >> 6u) & 0x03u));
}

uint8_t  Get_ID_18FED900_Sig_DPF_Regeneration_Status(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FED900_Msg_Count, 7u) >> 3u) & 0x03u));
}

uint8_t  Get_ID_18FED900_Sig_DPF_storage(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FED900_Msg_Count, 6u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FED900_Sig_SVS_Lamp_Status(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FED900_Msg_Count, 4u) >> 6u) & 0x03u));
}

uint8_t  Get_ID_18FE5BE8_Sig_Camera_Status(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FE5BE8_Msg_Count, 6u) >> 4u) & 0x0Fu));
}

uint8_t  Get_ID_18FE5BE8_Sig_Lane_Tracking_Status_Right_Side(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FE5BE8_Msg_Count, 0u) >> 2u) & 0x03u));
}

uint8_t  Get_ID_18FE5BE8_Sig_Lane_Tracking_Status_Left_Side(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FE5BE8_Msg_Count, 0u) >> 4u) & 0x03u));
}

uint8_t  Get_ID_18FE5BE8_Sig_Lane_Departure_Warning_Sys_Sta(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FE5BE8_Msg_Count, 6u) >> 0u) & 0x0Fu));
}

uint8_t  Get_ID_18FECA0B_Sig_Amber_Warning_Lamp_Status(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FECA0B_Msg_Count, 0u) >> 2u) & 0x03u));
}

uint8_t  Get_ID_18011733_Sig_Data_invalid(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18011733_Msg_Count, 4u) >> 0u) & 0x01u));
}

uint8_t  Get_ID_18011733_Sig_Data_updating(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18011733_Msg_Count, 4u) >> 1u) & 0x01u));
}

uint8_t  Get_ID_18011733_Sig_Tire_Temperature(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18011733_Msg_Count, 3u) >> 0u) & 0x7Fu));
}

uint8_t  Get_ID_18011733_Sig_Tire_Temperature_Sign(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18011733_Msg_Count, 3u) >> 7u) & 0x01u));
}

uint16_t Get_ID_18011733_Sig_Tire_Pressure(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(ID_CanMsg18011733_Msg_Count, 2u) >> 0u) & 0xFFu) << 8u) + \
            ((uint16_t)((uint16_t)CAN_MSG_Read(ID_CanMsg18011733_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18011733_Sig_Tire_Index(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18011733_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18011733_Sig_Fast_air_leakage_alarm(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18011733_Msg_Count, 4u) >> 4u) & 0x01u));
}

uint8_t  Get_ID_18011733_Sig_Low_Voltage_Alarm(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18011733_Msg_Count, 4u) >> 3u) & 0x01u));
}

uint8_t  Get_ID_18011733_Sig_Sensor_fault_information(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18011733_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18011733_Sig_No_signal_Alarm(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18011733_Msg_Count, 4u) >> 2u) & 0x01u));
}

uint8_t  Get_ID_18011733_Sig_High_Temperature_Alarm(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18011733_Msg_Count, 4u) >> 5u) & 0x01u));
}

uint8_t  Get_ID_18011733_Sig_High_Presure_Alarm(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18011733_Msg_Count, 4u) >> 6u) & 0x01u));
}

uint8_t  Get_ID_18011733_Sig_Low_Presure_Alarm(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18011733_Msg_Count, 4u) >> 7u) & 0x01u));
}

uint8_t  Get_ID_18FE4F0B_Sig_ROP_Engine_Control_Active(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FE4F0B_Msg_Count, 1u) >> 0u) & 0x03u));
}

uint8_t  Get_ID_18FE4F0B_Sig_YC_Engine_Control_Active(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FE4F0B_Msg_Count, 1u) >> 4u) & 0x03u));
}

uint8_t  Get_ID_18FE4F0B_Sig_YC_Brake_Control_Active(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FE4F0B_Msg_Count, 1u) >> 6u) & 0x03u));
}

uint8_t  Get_ID_18FE4F0B_Sig_ROP_Brake_Control_Active(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FE4F0B_Msg_Count, 1u) >> 2u) & 0x03u));
}

uint8_t  Get_ID_18FE4F0B_Sig_VDC_Lamp_State(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FE4F0B_Msg_Count, 0u) >> 0u) & 0x03u));
}

uint8_t  Get_ID_18FE4F0B_Sig_VDC_Fully_operational(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FE4F0B_Msg_Count, 0u) >> 2u) & 0x03u));
}

uint8_t  Get_ID_18F0010B_Sig_ASR_Lamp_State(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18F0010B_Msg_Count, 0u) >> 0u) & 0x03u));
}

uint8_t  Get_ID_18F0010B_Sig_ASR_Brake_Control_Active(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18F0010B_Msg_Count, 0u) >> 2u) & 0x03u));
}

uint8_t  Get_ID_18F0010B_Sig_HSAGreen_Sta(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18F0010B_Msg_Count, 0u) >> 4u) & 0x03u));
}

uint8_t  Get_ID_18F0010B_Sig_ASR_Offroad_Switch(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18F0010B_Msg_Count, 2u) >> 2u) & 0x03u));
}

uint8_t  Get_ID_18F0010B_Sig_ABS_Fully_Operational(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18F0010B_Msg_Count, 5u) >> 0u) & 0x03u));
}

uint8_t  Get_ID_18F0010B_Sig_EBS_Red_Warning_Lamp_State(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18F0010B_Msg_Count, 5u) >> 2u) & 0x03u));
}

uint8_t  Get_ID_18F0010B_Sig_EBS_Amber_Warning_State(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18F0010B_Msg_Count, 5u) >> 4u) & 0x03u));
}

uint8_t  Get_ID_18F0010B_Sig_ATC_or_ASR_Lamp_State(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18F0010B_Msg_Count, 5u) >> 6u) & 0x03u));
}


uint8_t  Get_ID_CF02F2A_Sig_Relevant_objected_for_AEBS(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg0CF02F2A_Msg_Count, 1u) >> 0u) & 0x07u));
}

uint8_t  Get_ID_CF02F2A_Sig_Advanced_Emerg_Braking_Sys_Sta(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg0CF02F2A_Msg_Count, 0u) >> 0u) & 0x0Fu));
}

uint8_t  Get_ID_CF02FA1_Sig_Relevant_objected_for_AEBS(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg0CF02FA1_Msg_Count, 1u) >> 0u) & 0x07u));
}

uint8_t  Get_ID_CF02FA1_Sig_Advanced_Emerg_Braking_Sys_Sta(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg0CF02FA1_Msg_Count, 0u) >> 0u) & 0x0Fu));
}

uint8_t  Get_ID_CF02FA0_Sig_Relevant_objected_for_AEBS(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg0CF02FA0_Msg_Count, 1u) >> 0u) & 0x07u));
}

uint8_t  Get_ID_CF02FA0_Sig_Advanced_Emerg_Braking_Sys_Sta(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg0CF02FA0_Msg_Count, 0u) >> 0u) & 0x0Fu));
}

uint8_t  Get_ID_18EBFF03_Sig_Malfunction_indicator_Lamp(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18EBFF03_Msg_Count, 0u) >> 6u) & 0x03u));
}

uint8_t  Get_ID_18EBFF03_Sig_Amber_Warning_Lamp_Status(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18EBFF03_Msg_Count, 0u) >> 2u) & 0x03u));
}

uint8_t  Get_ID_18ECFF03_Sig_Malfunction_indicator_Lamp(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18ECFF03_Msg_Count, 0u) >> 6u) & 0x03u));
}

uint8_t  Get_ID_18ECFF03_Sig_Amber_Warning_Lamp_Status(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18ECFF03_Msg_Count, 0u) >> 2u) & 0x03u));
}

uint8_t  Get_ID_18FECA03_Sig_Malfunction_indicator_Lamp(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FECA03_Msg_Count, 0u) >> 6u) & 0x03u));
}

uint8_t  Get_ID_18FECA03_Sig_Amber_Warning_Lamp_Status(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FECA03_Msg_Count, 0u) >> 2u) & 0x03u));
}

uint8_t  Get_ID_CF00400_Sig_Speed_Limiter_Control_Mode(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg0CF00400_Msg_Count, 5u) >> 0u) & 0x03u));
}

uint16_t Get_ID_CF00400_Sig_Engine_speed(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(ID_CanMsg0CF00400_Msg_Count, 4u) >> 0u) & 0xFFu) << 8u) + \
            ((uint16_t)((uint16_t)CAN_MSG_Read(ID_CanMsg0CF00400_Msg_Count, 3u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FEEE00_Sig_Engine_Coolant_Temperature(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FEEE00_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_C0320C8_Sig_ID0C0320C8_byte2_bit1_2(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg0C0320C8_Msg_Count, 1u) >> 0u) & 0x03u));
}

uint8_t  Get_ID_C0320C0_Sig_ID0C0320C0_byte2_bit1_2(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg0C0320C0_Msg_Count, 1u) >> 0u) & 0x03u));
}

uint8_t  Get_ID_C0320B8_Sig_ID0C0320B8_byte2_bit1_2(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg0C0320B8_Msg_Count, 1u) >> 0u) & 0x03u));
}

uint8_t  Get_ID_C0320B0_Sig_ID0C0320B0_byte2_bit1_2(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg0C0320B0_Msg_Count, 1u) >> 0u) & 0x03u));
}

uint8_t  Get_ID_C0320A8_Sig_ID0C0320A8_byte2_bit1_2(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg0C0320A8_Msg_Count, 1u) >> 0u) & 0x03u));
}

uint8_t  Get_ID_CFF0F15_Sig_ID0CFF0F15_byte2_bit1_8(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg0CFF0F15_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_CFF0F15_Sig_ID0CFF0F15_byte1_bit4_5(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg0CFF0F15_Msg_Count, 0u) >> 3u) & 0x03u));
}

uint8_t  Get_ID_18FF4925_Sig_ID18FF4925_byte3_bit1_2(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FF4925_Msg_Count, 2u) >> 0u) & 0x03u));
}

uint8_t  Get_ID_18FF4925_Sig_ID18FF4925_byte3_bit3_4(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FF4925_Msg_Count, 2u) >> 2u) & 0x03u));
}

uint8_t  Get_ID_18F00503_Sig_ID18F00503_byte5(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18F00503_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18F00503_Sig_Current_Gear(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18F00503_Msg_Count, 3u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FF8503_Sig_Temperature_too_high(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FF8503_Msg_Count, 1u) >> 6u) & 0x03u));
}

uint8_t  Get_ID_18FF8503_Sig_Low_air_warning(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FF8503_Msg_Count, 1u) >> 4u) & 0x03u));
}

uint8_t  Get_ID_18FF8503_Sig_Clutch_Overload_warning(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FF8503_Msg_Count, 1u) >> 2u) & 0x03u));
}

uint8_t  Get_ID_18FF8503_Sig_Clutch_Wear_warning(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FF8503_Msg_Count, 1u) >> 0u) & 0x03u));
}

uint8_t  Get_ID_18FF8503_Sig_Spanner_Warning(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FF8503_Msg_Count, 0u) >> 2u) & 0x03u));
}

uint8_t  Get_ID_18FF8503_Sig_Stop_Warning(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FF8503_Msg_Count, 0u) >> 0u) & 0x03u));
}

uint8_t  Get_ID_18FF8503_Sig_Automatic_or_Manual_Mode(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FF8503_Msg_Count, 0u) >> 6u) & 0x03u));
}

uint8_t  Get_ID_18FF8503_Sig_Manouvering_mode(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FF8503_Msg_Count, 0u) >> 4u) & 0x03u));
}

uint8_t  Get_ID_18FE4A03_Sig_TransmissionSiftMode1_Indicator(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FE4A03_Msg_Count, 2u) >> 6u) & 0x03u));
}

uint8_t  Get_ID_18FF4100_Sig_Cruise_VariableSLD_Cont_Staus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FF4100_Msg_Count, 3u) >> 2u) & 0x07u));
}

uint8_t  Get_ID_18FF4100_Sig_Indicate_Lamp_Speed(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FF4100_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FF4100_Sig_Cruise_VariableSLD_Disp(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FF4100_Msg_Count, 3u) >> 5u) & 0x07u));
}

uint8_t  Get_ID_10F007E8_Sig_Lane_Departure_Imminent_Right(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg10F007E8_Msg_Count, 0u) >> 4u) & 0x03u));
}

uint8_t  Get_ID_10F007E8_Sig_Lane_Departure_Imminent_Left(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg10F007E8_Msg_Count, 0u) >> 6u) & 0x03u));
}

uint8_t  Get_ID_18EF1718_Sig_Door_SW(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18EF1718_Msg_Count, 7u) >> 4u) & 0x03u));
}

uint32_t Get_ID_18EF1718_Sig_Date(void)
{
    return (((uint32_t)((uint32_t)((uint32_t)((uint32_t)((uint32_t)CAN_MSG_Read(ID_CanMsg18EF1718_Msg_Count, 5u) >> 0u) & 0xFFu) << 8u) + \
                        ((uint32_t)((uint32_t)CAN_MSG_Read(ID_CanMsg18EF1718_Msg_Count, 4u) >> 0u) & 0xFFu) << 8u) + \
             ((uint32_t)((uint32_t)CAN_MSG_Read(ID_CanMsg18EF1718_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
            ((uint32_t)((uint32_t)CAN_MSG_Read(ID_CanMsg18EF1718_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18EF1718_Sig_Data_Type(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18EF1718_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18EF1718_Sig_Response_Code(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18EF1718_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint32_t Get_ID_18FEE518_Sig_Total_Engine_Hours(void)
{
    return (((uint32_t)((uint32_t)((uint32_t)((uint32_t)((uint32_t)CAN_MSG_Read(ID_CanMsg18FEE518_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
                        ((uint32_t)((uint32_t)CAN_MSG_Read(ID_CanMsg18FEE518_Msg_Count, 2u) >> 0u) & 0xFFu) << 8u) + \
             ((uint32_t)((uint32_t)CAN_MSG_Read(ID_CanMsg18FEE518_Msg_Count, 1u) >> 0u) & 0xFFu) << 8u) + \
            ((uint32_t)((uint32_t)CAN_MSG_Read(ID_CanMsg18FEE518_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FF3018_Sig_Current_Gear(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FF3018_Msg_Count, 7u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FF3018_Sig_ECO_Data(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FF3018_Msg_Count, 6u) >> 4u) & 0x0Fu));
}

uint8_t  Get_ID_18FF3018_Sig_TM_OH_Warnning(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FF3018_Msg_Count, 1u) >> 6u) & 0x03u));
}

uint8_t  Get_ID_18FF3018_Sig_Exh_Valve_OH_Warnning(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FF3018_Msg_Count, 0u) >> 4u) & 0x03u));
}

uint8_t  Get_ID_18FF3018_Sig_ACG_OH_Warnning(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FF3018_Msg_Count, 0u) >> 2u) & 0x03u));
}

uint8_t  Get_ID_18FF3018_Sig_Starter_OH_Warnning(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FF3018_Msg_Count, 0u) >> 0u) & 0x03u));
}

uint8_t  Get_ID_18FF3018_Sig_Engine_Oil_Warnning(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FF3018_Msg_Count, 0u) >> 6u) & 0x03u));
}

uint8_t  Get_ID_18FF1211_Sig_ID18FF1211_byte3_bit1_8(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FF1211_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_10FF462D_Sig_ID10FF462D_byte5(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg10FF462D_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_10FF462D_Sig_ID10FF462D_byte2_bit1_8(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg10FF462D_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_10FF477E_Sig_ID10FF477E_byte2_bit1_8(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg10FF477E_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FF5612_Sig_ID18FF5612_byte3_bit1_8(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FF5612_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FD7C00_Sig_DPF_Lamp_Status_Amber(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FD7C00_Msg_Count, 0u) >> 0u) & 0x07u));
}

uint8_t  Get_ID_18FECAE8_Sig_Amber_Warning_Lamp_Status(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FECAE8_Msg_Count, 0u) >> 2u) & 0x03u));
}

uint8_t  Get_ID_18FEED00_Sig_Maximum_Vehicle_Speed_Limit(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FEED00_Msg_Count, 0u) >> 0u) & 0xFFu));
}

//uint32_t Get_ID_18EA0021_Sig_CruiseControl_VehicleSpeedSetup(void)
//{
//    return (((uint32_t)((uint32_t)((uint32_t)((uint32_t)CAN_MSG_Read(ID_CanMsg18EA0021_Msg_Count, 2u) >> 0u) & 0xFFu) << 8u) + \
//             ((uint32_t)((uint32_t)CAN_MSG_Read(ID_CanMsg18EA0021_Msg_Count, 1u) >> 0u) & 0xFFu) << 8u) + \
//            ((uint32_t)((uint32_t)CAN_MSG_Read(ID_CanMsg18EA0021_Msg_Count, 0u) >> 0u) & 0xFFu));
//}

uint8_t  Get_ID_0C010305_Sig_Auto_EcoPow(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg0C010305_Msg_Count, 5u) >> 2u) & 0x03u));
}

uint32_t  Get_ID_18FECA03_Sig_SPN(void)
{
    return ((((uint32_t)((uint32_t)CAN_MSG_Read(ID_CanMsg18FECA03_Msg_Count, 4u) >> 0u) & 0xE0u) << 16u) + \
            (((uint32_t)((uint32_t)CAN_MSG_Read(ID_CanMsg18FECA03_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
            ((uint32_t)((uint32_t)CAN_MSG_Read(ID_CanMsg18FECA03_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FECA03_Sig_FMI(void)
{
    return ((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FECA03_Msg_Count, 4u) >> 0u) & 0x1Fu);
}

uint8_t  Get_ID_18FECA2A_Sig_AebsOff(void)
{
    return ((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FECA2A_Msg_Count, 0u) >> 2u) & 0x03u);
}

uint8_t  Get_ID_18FECAA1_Sig_AebsOff(void)
{
    return ((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FECAA1_Msg_Count, 0u) >> 2u) & 0x03u);
}

uint8_t  Get_ID_18FECAA0_Sig_AebsOff(void)
{
    return ((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FECAA0_Msg_Count, 0u) >> 2u) & 0x03u);
}

uint16_t Get_ID_18FECA00_Sig_DM1(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(ID_CanMsg18FECA00_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
            ((uint16_t)((uint16_t)CAN_MSG_Read(ID_CanMsg18FECA00_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18ECFF00_Sig_PRIO(void)
{
    return ((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18ECFF00_Msg_Count, 0u) >> 0u) & 0xFFu);
}

uint8_t  Get_ID_18ECFF00_Sig_DATA_NUM(void)
{
    return ((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18ECFF00_Msg_Count, 1u) >> 0u) & 0xFFu);
}

uint8_t  Get_ID_18ECFF00_Sig_FRAME_NUM(void)
{
    return ((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18ECFF00_Msg_Count, 3u) >> 0u) & 0xFFu);
}

uint8_t  Get_ID_18ECFF00_Sig_PS(void)
{
    return ((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18ECFF00_Msg_Count, 4u) >> 0u) & 0xFFu);
}

uint16_t  Get_ID_18ECFF00_Sig_PGN(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(ID_CanMsg18ECFF00_Msg_Count, 6u) >> 0u) & 0xFFu) << 8u) + \
            ((uint16_t)((uint16_t)CAN_MSG_Read(ID_CanMsg18ECFF00_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18ECFF00_Sig_SA(void)
{
    return ((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18ECFF00_Msg_Count, 7u) >> 0u) & 0xFFu);
}

uint8_t  Get_ID_18EBFF00_Sig_DATA(uint8_t Data_Buff)
{
    return ((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18EBFF00_Msg_Count, Data_Buff) >> 0u) & 0xFFu);
}

uint16_t Get_ID_18FECA03_Sig_DM1(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(ID_CanMsg18FECA03_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
            ((uint16_t)((uint16_t)CAN_MSG_Read(ID_CanMsg18FECA03_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18ECFF03_Sig_PRIO(void)
{
    return ((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18ECFF03_Msg_Count, 0u) >> 0u) & 0xFFu);
}

uint8_t  Get_ID_18ECFF03_Sig_DATA_NUM(void)
{
    return ((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18ECFF03_Msg_Count, 1u) >> 0u) & 0xFFu);
}

uint8_t  Get_ID_18ECFF03_Sig_FRAME_NUM(void)
{
    return ((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18ECFF03_Msg_Count, 3u) >> 0u) & 0xFFu);
}

uint8_t  Get_ID_18ECFF03_Sig_PS(void)
{
    return ((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18ECFF03_Msg_Count, 4u) >> 0u) & 0xFFu);
}

uint16_t  Get_ID_18ECFF03_Sig_PGN(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(ID_CanMsg18ECFF03_Msg_Count, 6u) >> 0u) & 0xFFu) << 8u) + \
            ((uint16_t)((uint16_t)CAN_MSG_Read(ID_CanMsg18ECFF03_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18ECFF03_Sig_SA(void)
{
    return ((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18ECFF03_Msg_Count, 7u) >> 0u) & 0xFFu);
}

uint8_t  Get_ID_18EBFF03_Sig_DATA(uint8_t Data_Buff)
{
    return ((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18EBFF03_Msg_Count, Data_Buff) >> 0u) & 0xFFu);
}

uint16_t Get_ID_18FECA0B_Sig_DM1(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(ID_CanMsg18FECA0B_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
            ((uint16_t)((uint16_t)CAN_MSG_Read(ID_CanMsg18FECA0B_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18ECFF0B_Sig_PRIO(void)
{
    return ((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18ECFF0B_Msg_Count, 0u) >> 0u) & 0xFFu);
}

uint8_t  Get_ID_18ECFF0B_Sig_DATA_NUM(void)
{
    return ((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18ECFF0B_Msg_Count, 1u) >> 0u) & 0xFFu);
}

uint8_t  Get_ID_18ECFF0B_Sig_FRAME_NUM(void)
{
    return ((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18ECFF0B_Msg_Count, 3u) >> 0u) & 0xFFu);
}

uint8_t  Get_ID_18ECFF0B_Sig_PS(void)
{
    return ((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18ECFF0B_Msg_Count, 4u) >> 0u) & 0xFFu);
}

uint16_t  Get_ID_18ECFF0B_Sig_PGN(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(ID_CanMsg18ECFF0B_Msg_Count, 6u) >> 0u) & 0xFFu) << 8u) + \
            ((uint16_t)((uint16_t)CAN_MSG_Read(ID_CanMsg18ECFF0B_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18ECFF0B_Sig_SA(void)
{
    return ((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18ECFF0B_Msg_Count, 7u) >> 0u) & 0xFFu);
}

uint8_t  Get_ID_18EBFF0B_Sig_DATA(uint8_t Data_Buff)
{
    return ((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18EBFF0B_Msg_Count, Data_Buff) >> 0u) & 0xFFu);
}

uint16_t Get_ID_18FECA10_Sig_DM1(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(ID_CanMsg18FECA10_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
            ((uint16_t)((uint16_t)CAN_MSG_Read(ID_CanMsg18FECA10_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18ECFF10_Sig_PRIO(void)
{
    return ((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18ECFF10_Msg_Count, 0u) >> 0u) & 0xFFu);
}

uint8_t  Get_ID_18ECFF10_Sig_DATA_NUM(void)
{
    return ((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18ECFF10_Msg_Count, 1u) >> 0u) & 0xFFu);
}

uint8_t  Get_ID_18ECFF10_Sig_FRAME_NUM(void)
{
    return ((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18ECFF10_Msg_Count, 3u) >> 0u) & 0xFFu);
}

uint8_t  Get_ID_18ECFF10_Sig_PS(void)
{
    return ((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18ECFF10_Msg_Count, 4u) >> 0u) & 0xFFu);
}

uint16_t  Get_ID_18ECFF10_Sig_PGN(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(ID_CanMsg18ECFF10_Msg_Count, 6u) >> 0u) & 0xFFu) << 8u) + \
            ((uint16_t)((uint16_t)CAN_MSG_Read(ID_CanMsg18ECFF10_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18ECFF10_Sig_SA(void)
{
    return ((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18ECFF10_Msg_Count, 7u) >> 0u) & 0xFFu);
}

uint8_t  Get_ID_18EBFF10_Sig_DATA(uint8_t Data_Buff)
{
    return ((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18EBFF10_Msg_Count, Data_Buff) >> 0u) & 0xFFu);
}

uint16_t Get_ID_18FECAA0_Sig_DM1(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(ID_CanMsg18FECAA0_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
            ((uint16_t)((uint16_t)CAN_MSG_Read(ID_CanMsg18FECAA0_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18FF064A_Sig_TBOX_Sta(void)
{
    return ((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FF064A_Msg_Count, 0u) >> 0u) & 0x03u);
}

uint8_t  Get_ID_18FF064A_Sig_TBOX_Sig(void)
{
    return ((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FF064A_Msg_Count, 0u) >> 2u) & 0x03u);
}

uint8_t  Get_ID_18FF064A_Sig_TBOX_Sig_Error(void)
{
    return ((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FF064A_Msg_Count, 1u) >> 4u) & 0x0Fu);
}

uint8_t  Get_ID_18FEE64A_Sig_TBOX_Seconds(void)
{
    return ((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FEE64A_Msg_Count, 0u) >> 0u) & 0xFFu);
}

uint8_t  Get_ID_18FEE64A_Sig_TBOX_Minutes(void)
{
    return ((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FEE64A_Msg_Count, 1u) >> 0u) & 0xFFu);
}

uint8_t  Get_ID_18FEE64A_Sig_TBOX_Hours(void)
{
    return ((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FEE64A_Msg_Count, 2u) >> 0u) & 0xFFu);
}

uint8_t  Get_ID_18FEE64A_Sig_TBOX_Month(void)
{
    return ((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FEE64A_Msg_Count, 3u) >> 0u) & 0xFFu);
}

uint8_t  Get_ID_18FEE64A_Sig_TBOX_Day(void)
{
    return ((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FEE64A_Msg_Count, 4u) >> 0u) & 0xFFu);
}

uint8_t  Get_ID_18FEE64A_Sig_TBOX_Year(void)
{
    return ((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FEE64A_Msg_Count, 5u) >> 0u) & 0xFFu);
}

uint8_t  Get_ID_18FDC40B_Sig_HSAYellow_Sta(void)
{
    return ((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18FDC40B_Msg_Count, 0u) >> 5u) & 0x07u);
}






uint8_t  Get_ID_18ECFFA0_Sig_PRIO(void)
{
    return ((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18ECFFA0_Msg_Count, 0u) >> 0u) & 0xFFu);
}

uint8_t  Get_ID_18ECFFA0_Sig_DATA_NUM(void)
{
    return ((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18ECFFA0_Msg_Count, 1u) >> 0u) & 0xFFu);
}

uint8_t  Get_ID_18ECFFA0_Sig_FRAME_NUM(void)
{
    return ((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18ECFFA0_Msg_Count, 3u) >> 0u) & 0xFFu);
}

uint8_t  Get_ID_18ECFFA0_Sig_PS(void)
{
    return ((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18ECFFA0_Msg_Count, 4u) >> 0u) & 0xFFu);
}

uint16_t  Get_ID_18ECFFA0_Sig_PGN(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(ID_CanMsg18ECFFA0_Msg_Count, 6u) >> 0u) & 0xFFu) << 8u) + \
            ((uint16_t)((uint16_t)CAN_MSG_Read(ID_CanMsg18ECFFA0_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18ECFFA0_Sig_SA(void)
{
    return ((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18ECFFA0_Msg_Count, 7u) >> 0u) & 0xFFu);
}

uint8_t  Get_ID_18EBFFA0_Sig_DATA(uint8_t Data_Buff)
{
    return ((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18EBFFA0_Msg_Count, Data_Buff) >> 0u) & 0xFFu);
}

uint16_t Get_ID_18FECAE8_Sig_DM1(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(ID_CanMsg18FECAE8_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
            ((uint16_t)((uint16_t)CAN_MSG_Read(ID_CanMsg18FECAE8_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18ECFFE8_Sig_PRIO(void)
{
    return ((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18ECFFE8_Msg_Count, 0u) >> 0u) & 0xFFu);
}

uint8_t  Get_ID_18ECFFE8_Sig_DATA_NUM(void)
{
    return ((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18ECFFE8_Msg_Count, 1u) >> 0u) & 0xFFu);
}

uint8_t  Get_ID_18ECFFE8_Sig_FRAME_NUM(void)
{
    return ((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18ECFFE8_Msg_Count, 3u) >> 0u) & 0xFFu);
}

uint8_t  Get_ID_18ECFFE8_Sig_PS(void)
{
    return ((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18ECFFE8_Msg_Count, 4u) >> 0u) & 0xFFu);
}

uint16_t  Get_ID_18ECFFE8_Sig_PGN(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(ID_CanMsg18ECFFE8_Msg_Count, 6u) >> 0u) & 0xFFu) << 8u) + \
            ((uint16_t)((uint16_t)CAN_MSG_Read(ID_CanMsg18ECFFE8_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint8_t  Get_ID_18ECFFE8_Sig_SA(void)
{
    return ((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18ECFFE8_Msg_Count, 7u) >> 0u) & 0xFFu);
}

uint8_t  Get_ID_18EBFFE8_Sig_DATA(uint8_t Data_Buff)
{
    return ((uint8_t)((uint8_t)CAN_MSG_Read(ID_CanMsg18EBFFE8_Msg_Count, Data_Buff) >> 0u) & 0xFFu);
}

uint8_t  Co_Can_ConvertSubID(uint32_t MsgID)
{
    uint8_t u8Result = ID_TOTAL_MAX;
    switch (MsgID)
    {
    case ID_CanMsg18FF5510_Msg:
        u8Result = ID_CanMsg18FF5510_Msg_Count;
        break;
    case ID_CanMsg18FF2300_Msg:
        u8Result = ID_CanMsg18FF2300_Msg_Count;
        break;
    case ID_CanMsg18FED900_Msg:
        u8Result = ID_CanMsg18FED900_Msg_Count;
        break;
    case ID_CanMsg18FE5BE8_Msg:
        u8Result = ID_CanMsg18FE5BE8_Msg_Count;
        break;
    case ID_CanMsg18FECA0B_Msg:
        u8Result = ID_CanMsg18FECA0B_Msg_Count;
        break;
    case ID_CanMsg18011733_Msg:
        u8Result = ID_CanMsg18011733_Msg_Count;
        break;
    case ID_CanMsg18FE4F0B_Msg:
        u8Result = ID_CanMsg18FE4F0B_Msg_Count;
        break;
    case ID_CanMsg18F0010B_Msg:
        u8Result = ID_CanMsg18F0010B_Msg_Count;
        break;
    case ID_CanMsg0CF02F2A_Msg:
        u8Result = ID_CanMsg0CF02F2A_Msg_Count;
        break;
    case ID_CanMsg0CF02FA1_Msg:
        u8Result = ID_CanMsg0CF02FA1_Msg_Count;
        break;
    case ID_CanMsg0CF02FA0_Msg:
        u8Result = ID_CanMsg0CF02FA0_Msg_Count;
        break;
    case ID_CanMsg18EBFF03_Msg:
        u8Result = ID_CanMsg18EBFF03_Msg_Count;
        break;
    case ID_CanMsg18ECFF03_Msg:
        u8Result = ID_CanMsg18ECFF03_Msg_Count;
        break;
    case ID_CanMsg18FECA03_Msg:
        u8Result = ID_CanMsg18FECA03_Msg_Count;
        break;
    case ID_CanMsg0CF00400_Msg:
        u8Result = ID_CanMsg0CF00400_Msg_Count;
        break;
    case ID_CanMsg18FEEE00_Msg:
        u8Result = ID_CanMsg18FEEE00_Msg_Count;
        break;
    case ID_CanMsg0C0320C8_Msg:
        u8Result = ID_CanMsg0C0320C8_Msg_Count;
        break;
    case ID_CanMsg0C0320C0_Msg:
        u8Result = ID_CanMsg0C0320C0_Msg_Count;
        break;
    case ID_CanMsg0C0320B8_Msg:
        u8Result = ID_CanMsg0C0320B8_Msg_Count;
        break;
    case ID_CanMsg0C0320B0_Msg:
        u8Result = ID_CanMsg0C0320B0_Msg_Count;
        break;
    case ID_CanMsg0C0320A8_Msg:
        u8Result = ID_CanMsg0C0320A8_Msg_Count;
        break;
    case ID_CanMsg0CFF0F15_Msg:
        u8Result = ID_CanMsg0CFF0F15_Msg_Count;
        break;
    case ID_CanMsg18FF4925_Msg:
        u8Result = ID_CanMsg18FF4925_Msg_Count;
        break;
    case ID_CanMsg18F00503_Msg:
        u8Result = ID_CanMsg18F00503_Msg_Count;
        break;
    case ID_CanMsg18FF8503_Msg:
        u8Result = ID_CanMsg18FF8503_Msg_Count;
        break;
    case ID_CanMsg18FE4A03_Msg:
        u8Result = ID_CanMsg18FE4A03_Msg_Count;
        break;
    case ID_CanMsg18FF4100_Msg:
        u8Result = ID_CanMsg18FF4100_Msg_Count;
        break;
    case ID_CanMsg10F007E8_Msg:
        u8Result = ID_CanMsg10F007E8_Msg_Count;
        break;
    case ID_CanMsg18EF1718_Msg:
        u8Result = ID_CanMsg18EF1718_Msg_Count;
        break;
    case ID_CanMsg18FEE518_Msg:
        u8Result = ID_CanMsg18FEE518_Msg_Count;
        break;
    case ID_CanMsg18FF3018_Msg:
        u8Result = ID_CanMsg18FF3018_Msg_Count;
        break;
    case ID_CanMsg18FF1211_Msg:
        u8Result = ID_CanMsg18FF1211_Msg_Count;
        break;
    case ID_CanMsg10FF462D_Msg:
        u8Result = ID_CanMsg10FF462D_Msg_Count;
        break;
    case ID_CanMsg10FF477E_Msg:
        u8Result = ID_CanMsg10FF477E_Msg_Count;
        break;
    case ID_CanMsg18FF5612_Msg:
        u8Result = ID_CanMsg18FF5612_Msg_Count;
        break;
    case ID_CanMsg18FD7C00_Msg:
        u8Result = ID_CanMsg18FD7C00_Msg_Count;
        break;
    case ID_CanMsg18FECAE8_Msg:
        u8Result = ID_CanMsg18FECAE8_Msg_Count;
        break;
    case ID_CanMsg18FEED00_Msg:
        u8Result = ID_CanMsg18FEED00_Msg_Count;
        break;
    //case ID_CanMsg18FF3018_Msg:
    //    u8Result = ID_CanMsg18FF3018_Msg_Count;
    //    break;
    case ID_CanMsg18021733_Msg:
        u8Result = ID_CanMsg18021733_Msg_Count;
        break;
    case ID_CanMsg0C010305_Msg:
        u8Result = ID_CanMsg0C010305_Msg_Count;
        break;
    case ID_CanMsg18FECA2A_Msg:
        u8Result = ID_CanMsg18FECA2A_Msg_Count;
        break;
    case ID_CanMsg18FECAA1_Msg:
        u8Result = ID_CanMsg18FECAA1_Msg_Count;
        break;
    case ID_CanMsg18FECAA0_Msg:
        u8Result = ID_CanMsg18FECAA0_Msg_Count;
        break;
    case ID_CanMsg18FF064A_Msg:
        u8Result = ID_CanMsg18FF064A_Msg_Count;
        break;
    case ID_CanMsg18FEE64A_Msg:
        u8Result = ID_CanMsg18FEE64A_Msg_Count;
        break;
    case ID_CanMsg18FDC40B_Msg:
        u8Result = ID_CanMsg18FDC40B_Msg_Count;
        break;


    case ID_CanMsg18FECA00_Msg:
        u8Result = ID_CanMsg18FECA00_Msg_Count;
        break;
    case ID_CanMsg18FECA10_Msg:
        u8Result = ID_CanMsg18FECA10_Msg_Count;
        break;
    case ID_CanMsg18ECFF00_Msg:
        u8Result = ID_CanMsg18ECFF00_Msg_Count;
        break;
    case ID_CanMsg18EBFF00_Msg:
        u8Result = ID_CanMsg18EBFF00_Msg_Count;
        break;
    case ID_CanMsg18ECFF0B_Msg:
        u8Result = ID_CanMsg18ECFF0B_Msg_Count;
        break;
    case ID_CanMsg18EBFF0B_Msg:
        u8Result = ID_CanMsg18EBFF0B_Msg_Count;
        break;
    case ID_CanMsg18ECFF10_Msg:
        u8Result = ID_CanMsg18ECFF10_Msg_Count;
        break;
    case ID_CanMsg18EBFF10_Msg:
        u8Result = ID_CanMsg18EBFF10_Msg_Count;
        break;
    case ID_CanMsg18ECFFA0_Msg:
        u8Result = ID_CanMsg18ECFFA0_Msg_Count;
        break;
    case ID_CanMsg18EBFFA0_Msg:
        u8Result = ID_CanMsg18EBFFA0_Msg_Count;
        break;
    case ID_CanMsg18ECFFE8_Msg:
        u8Result = ID_CanMsg18ECFFE8_Msg_Count;
        break;
    case ID_CanMsg18EBFFE8_Msg:
        u8Result = ID_CanMsg18EBFFE8_Msg_Count;
        break;

    default :
        u8Result = ID_TOTAL_MAX;
        break;
    }
    return u8Result;
}
