#include "BackLight_APP.h"
#include "RTE_PWM_OUT.h"
#include "Common_Interface.h"
#include "Popup_List.h"
#include "Popup_Scheduler.h"
#include "GPIO.h"
#include "dr7f701441.dvf.h"
#include "CAN_Communication_Matrix.h"
#include "BGLInterface.h"
#include "Line_in.h"

#include "TimerB.h"
#include "Data_Fuel_User.h"

typedef struct
{
    uint8_t   Brightness;
    uint8_t   Window;
} SEGLCDBackupStruct;

typedef struct
{
    uint8_t   DoorStatusBackup;
    uint16_t  Timer;
    uint16_t  BackupPwm;
} BlOFFCtrlStruct;


BlOFFCtrlStruct     BlOFFCtrl;
SEGLCDBackupStruct   SEGLCDBackup;


uint8_t WARNING_DOOR_STATUS ;

uint32_t Left_Right_Delay;


void SEG_LCD_Window_Switch ( uint8_t Sw );
void BL_Init ( void )
{

    SEG_LCD_Init();
}
uint16_t BackLightVLv = 10u;
uint8_t BackLightTestIG = 1u;
uint8_t BackLightWakeFlag = 0u;
uint8_t BackLightTPostLight = 0u;
uint16_t testBG = 500 ;
void BL_Management_service ( void )
{

    uint8_t  Msg;
    uint8_t  LED_Pos;
    uint8_t  LED_Left;
    uint8_t  LED_Right;
    uint8_t  LED_Plus;
    uint8_t WARNING_PARKING_BRAKE_TEL = 0u;
    uint8_t BCM_PositionLight = 0;

    uint8_t DutyCycle;

    uint8_t ILL = 0 ;

    if (Line_In_Get_Status(LINE_IN_ILLUMINATION) )
    {
        ILL = 2 ;
    }
    else
    {
        ILL = 0 ;
    }

    if ( Common_Get_IG_Sts() == COMMON_POWER_OFF )
    {

#if 0

        LED_Pos = Get_ID_245_Sig_BCM_PosiLightSts();
        LED_Left = Get_ID_245_Sig_BCM_TurnLightSts_L();
        LED_Right = Get_ID_245_Sig_BCM_TurnLightSts_R();


        LED_Plus = LED_Left + LED_Right ;
        if (LED_Plus != 0u)
        {
            Left_Right_Delay = 0u;
            WARNING_PARKING_BRAKE_TEL =  LED_Left + LED_Right;
        }
        else
        {
            if (Left_Right_Delay <= 500ul)
            {
                Left_Right_Delay++;
            }
            if (Left_Right_Delay >= 15)
            {
                WARNING_PARKING_BRAKE_TEL =  LED_Left + LED_Right;
            }
            else
            {
                WARNING_PARKING_BRAKE_TEL =  1;
            }
        }


        if (( Get_Current_DispType() == Disp_Alarm ) || (WARNING_PARKING_BRAKE_TEL != 0) || (LED_Pos != 0))
        {

            Msg =  Popup_Get_Current_Message();

            //if (( Msg != POPUP_MSG_DOOR_OPEN_LOW_SPEED ) || (WARNING_PARKING_BRAKE_TEL != 0))
            //    BlOFFCtrl.Timer = 0;
            //else
            //{
            //    if ( ( WARNING_DOOR_STATUS != 0 ) && ( WARNING_DOOR_STATUS != BlOFFCtrl.DoorStatusBackup ) )
            //        BlOFFCtrl.Timer = 0;
            //    else
            //    {
            //        if ( BlOFFCtrl.Timer < 30 * 50 )
            //            BlOFFCtrl.Timer++;
            //    }

            //    BlOFFCtrl.DoorStatusBackup = WARNING_DOOR_STATUS;
            //}

            if ( BlOFFCtrl.Timer < 30 * 50 )
            {

                SEG_LCD_Window_Switch ( 1 );
                BackLightWakeFlag = 1u;
            }
            else
            {
                SEG_LCD_Window_Switch ( 0 );
                BackLightWakeFlag = 0u;
            }
        }
        else
        {
            BlOFFCtrl.Timer = 0;
            SEG_LCD_Window_Switch ( 0 );
            BackLightWakeFlag = 0u;
        }
#endif
    }
    else
    {
        //if ( BCM_PositionLight )
        //{
        //    RTE_PWM_Set_Panel ( 47, 42, 43 );
        //    RTE_PWM_Set_LCD ( DutyCycle );
        //    RTE_PWM_Set_Point ( DutyCycle );
        //}
        //else
        //{
        //    RTE_PWM_Set_Panel ( 95, 85, 86 );
        //    RTE_PWM_Set_LCD ( DutyCycle );           //LCD_BL   = 1;
        //    RTE_PWM_Set_Point ( DutyCycle );           //LCD_BL   = 1;
        //}
        SEG_LCD_Window_Switch ( 1 );
    }
    /*得到主题模式可自己在枚举中定义 在BackGroundLight.c里填表*/
    GetBGLTheme(0);
    /*得到工作模式 白天 傍晚 夜晚 在枚举中已定义*/

    GetBGLType(ILL);
    //GetBGLType(0);
    /*得到背光等级 可自己在枚举中定义 在BackGroundLight.c里填表*/
    GetBGLLvl(BackLightVLv, LED_Pos);
    /*得到热敏电阻电压参数为100倍电压值*/

    GetBGLNTCVol(0);
    /*主函数中调用第一个参数电源状态 1是 ON档 2 off 第二个参数 唤醒条件 1是TTF唤醒 2 是表盘唤醒 3 是表盘和屏都有唤醒，0无唤醒*/

    if (Common_Get_IG_Sts() == COMMON_POWER_ON)
    {
        BackLightWakeFlag = 0u;
    }
    else
    {
        BackLightWakeFlag = 1u;
    }

    BackLightSchedu(Common_Get_IG_Sts(), BackLightWakeFlag);
}

void BL_PWM_Duty_Cycle_Capture_ISR ( void )
{



}
void SEG_LCD_Init ( void )
{
    SEGLCDBackup.Brightness = 0xFF;
    SEGLCDBackup.Window     = 0x00;
    SEG0_MCU_OUT = 0;
    COMM_MCU_OUT = 0;
}

void SEG_LCD_Window_Switch ( uint8_t Sw )
{
    if ( Sw == SEGLCDBackup.Window )
        return;

    SEGLCDBackup.Window = Sw;

    if ( Sw )
    {
        SEG0_MCU_OUT = 1;
        COMM_MCU_OUT = 0;
    }
    else
    {
        SEG0_MCU_OUT = 0;
        COMM_MCU_OUT = 0;
    }
}


//10ms

void SEG_LCD_Window_Control_Service ( void )
{
    if ( SEGLCDBackup.Window )
    {
        if (SEG0_MCU_OUT == 1)
        {
            SEG0_MCU_OUT = 0;
            COMM_MCU_OUT = 1;
        }
        else
        {
            SEG0_MCU_OUT = 1;
            COMM_MCU_OUT = 0;
        }
    }
    else
    {
        SEG0_MCU_OUT = 0;
        COMM_MCU_OUT = 0;
    }
}
