/******************************************************************************/
/* DISCLAIMER                                                                 */
/* This software is supplied by Renesas Electronics Corporation and is only   */
/* intended for use with Renesas products. No other uses are authorized.This  */
/* software is owned by Renesas Electronics Corporation and is protected      */
/* under all applicable laws, including copyright laws.                       */
/* THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES          */
/* REGARDING THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING  */
/* BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR */
/* PURPOSE AND NON-INFRINGEMENT.  ALL SUCH WARRANTIES ARE EXPRESSLY           */
/* DISCLAIMED.                                                                */
/* TO THE MAXIMUM EXTENT PERMITTED NOT PROHIBITED BY LAW, NEITHER RENESAS     */
/* ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES SHALL BE       */
/* LIABLE FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL      */
/* DAMAGES FOR ANY REASON RELATED TO THIS SOFTWARE, EVEN IF RENESAS OR ITS    */
/* AFFILIATES HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.           */
/* Renesas reserves the right, without notice, to make changes to this        */
/* software and to discontinue the availability of this software.             */
/* By using this software, you agree to the additional terms and conditions   */
/* found by accessing the following link:                                     */
/* http://www.renesas.com/disclaimer                                          */
/*                                                                            */
/* Device     : RH/RH850G3M/R7F701441                                         */
/* File Name  : dr7f701441.dvf.h                                              */
/* Abstract   : Definition of I/O Register                                    */
/* History    : V1.10  [Device File version]                                  */
/* Options    : -ghs_pragma_io=off -anonymous=off -indent=4 -structure=on -ty */
/*              pedef=on -def=on -autosar=on -modulearray=on -const=off -bitf */
/*              ield=on -bitsfr=on -df=.\dr7f701441.dvf -o=..\output\update\i */
/*              nc_ansiplus\dr7f701441.dvf.h                                  */
/* Date       : 16.10.2017                                                    */
/* Version    : V1.07.00.02  [df2iodef.exe version]                           */
/* This is a typical example.                                                 */
/*                                                                            */
/******************************************************************************/
#ifndef __R7F701441IODEFINE_HEADER__
#define __R7F701441IODEFINE_HEADER__

#ifndef _IODEF_AUTOSAR_TYPEDEF_
#define _IODEF_AUTOSAR_TYPEDEF_
typedef unsigned char   uint8;
typedef unsigned short  uint16;
typedef unsigned long   uint32;
#endif

typedef struct
{
    uint8 bit00:1;
    uint8 bit01:1;
    uint8 bit02:1;
    uint8 bit03:1;
    uint8 bit04:1;
    uint8 bit05:1;
    uint8 bit06:1;
    uint8 bit07:1;
} __bitf_T;

#define  L 0
#define  H 1
#define LL 0
#define LH 1
#define HL 2
#define HH 3

typedef struct 
{                                                          /* Bit Access       */
    uint32 RS:1;                                           /* RS               */
    uint32 ARS:1;                                          /* ARS              */
    uint32 :13;                                            /* Reserved Bits    */
    uint32 SWRST:1;                                        /* SWRST            */
    uint32 :16;                                            /* Reserved Bits    */
} __type0;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TRA:1;                                          /* TRA              */
    uint32 IER:1;                                          /* IER              */
    uint32 INT:1;                                          /* INT              */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 REN:1;                                          /* REN              */
    uint32 DSA:1;                                          /* DSA              */
    uint32 :25;                                            /* Reserved Bits    */
} __type1;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TRACLR:1;                                       /* TRACLR           */
    uint32 IERCLR:1;                                       /* IERCLR           */
    uint32 INTCLR:1;                                       /* INTCLR           */
    uint32 :29;                                            /* Reserved Bits    */
} __type2;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TRAENB:1;                                       /* TRAENB           */
    uint32 IERENB:1;                                       /* IERENB           */
    uint32 INTENB:1;                                       /* INTENB           */
    uint32 :29;                                            /* Reserved Bits    */
} __type3;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TRAM:1;                                         /* TRAM             */
    uint32 IEM:1;                                          /* IEM              */
    uint32 INM:1;                                          /* INM              */
    uint32 :29;                                            /* Reserved Bits    */
} __type4;
typedef struct 
{                                                          /* Bit Access       */
    uint32 DLP:32;                                         /* DLP[31:0]        */
} __type5;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 DLSA:29;                                        /* DLSA[31:3]       */
} __type6;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 DSA:27;                                         /* DSA[31:5]        */
} __type7;
typedef struct 
{                                                          /* Bit Access       */
    uint32 DST:14;                                         /* DST[13:0]        */
    uint32 :18;                                            /* Reserved Bits    */
} __type8;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 DSA2:27;                                        /* DSA2[31:5]       */
} __type9;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TME:1;                                          /* TME              */
    uint32 BFE:1;                                          /* BFE              */
    uint32 AUTODG:1;                                       /* AUTODG           */
    uint32 AUTOSG:1;                                       /* AUTOSG           */
    uint32 DXDYM:1;                                        /* DXDYM            */
    uint32 DUDVM:1;                                        /* DUDVM            */
    uint32 TCM:1;                                          /* TCM              */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 DTHE:1;                                         /* DTHE             */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 CAS:4;                                          /* CAS[14:11]       */
    uint32 CFS:1;                                          /* CFS              */
    uint32 :16;                                            /* Reserved Bits    */
} __type10;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TMES:1;                                         /* TMES             */
    uint32 BFES:1;                                         /* BFES             */
    uint32 AUTODGS:1;                                      /* AUTODGS          */
    uint32 AUTOSGS:1;                                      /* AUTOSGS          */
    uint32 DXDYMS:1;                                       /* DXDYMS           */
    uint32 DUDVMS:1;                                       /* DUDVMS           */
    uint32 TCMS:1;                                         /* TCMS             */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 DTHES:1;                                        /* DTHES            */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 CASS0:1;                                        /* CASS0            */
    uint32 CASS1:1;                                        /* CASS1            */
    uint32 CASS2:1;                                        /* CASS2            */
    uint32 CASS3:1;                                        /* CASS3            */
    uint32 CFSS:1;                                         /* CFSS             */
    uint32 :16;                                            /* Reserved Bits    */
} __type11;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TMEC:1;                                         /* TMEC             */
    uint32 BFEC:1;                                         /* BFEC             */
    uint32 AUTODGC:1;                                      /* AUTODGC          */
    uint32 AUTOSGC:1;                                      /* AUTOSGC          */
    uint32 DXDYMC:1;                                       /* DXDYMC           */
    uint32 DUDVMC:1;                                       /* DUDVMC           */
    uint32 TCMC:1;                                         /* TCMC             */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 DTHEC:1;                                        /* DTHEC            */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 CASC0:1;                                        /* CASC0            */
    uint32 CASC1:1;                                        /* CASC1            */
    uint32 CASC2:1;                                        /* CASC2            */
    uint32 CASC3:1;                                        /* CASC3            */
    uint32 CFSC:1;                                         /* CFSC             */
    uint32 :16;                                            /* Reserved Bits    */
} __type12;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TCA:8;                                          /* TCA[7:0]         */
    uint32 TCR:8;                                          /* TCR[15:8]        */
    uint32 TCG:8;                                          /* TCG[23:16]       */
    uint32 TCB:8;                                          /* TCB[31:24]       */
} __type13;
typedef struct 
{                                                          /* Bit Access       */
    uint32 UVDPO:3;                                        /* UVDPO[2:0]       */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 DDP:1;                                          /* DDP              */
    uint32 :23;                                            /* Reserved Bits    */
} __type14;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SVW:11;                                         /* SVW[10:0]        */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 SUW:11;                                         /* SUW[26:16]       */
    uint32 :5;                                             /* Reserved Bits    */
} __type15;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SVS:11;                                         /* SVS[10:0]        */
    uint32 :21;                                            /* Reserved Bits    */
} __type16;
typedef struct 
{                                                          /* Bit Access       */
    uint32 XMIN:13;                                        /* XMIN[12:0]       */
    uint32 :19;                                            /* Reserved Bits    */
} __type17;
typedef struct 
{                                                          /* Bit Access       */
    uint32 YMIN:13;                                        /* YMIN[12:0]       */
    uint32 :19;                                            /* Reserved Bits    */
} __type18;
typedef struct 
{                                                          /* Bit Access       */
    uint32 XMAX:13;                                        /* XMAX[12:0]       */
    uint32 :19;                                            /* Reserved Bits    */
} __type19;
typedef struct 
{                                                          /* Bit Access       */
    uint32 YMAX:13;                                        /* YMAX[12:0]       */
    uint32 :19;                                            /* Reserved Bits    */
} __type20;
typedef struct 
{                                                          /* Bit Access       */
    uint32 AMXS:13;                                        /* AMXS[12:0]       */
    uint32 :19;                                            /* Reserved Bits    */
} __type21;
typedef struct 
{                                                          /* Bit Access       */
    uint32 AMYS:13;                                        /* AMYS[12:0]       */
    uint32 :19;                                            /* Reserved Bits    */
} __type22;
typedef struct 
{                                                          /* Bit Access       */
    uint32 AMXO:13;                                        /* AMXO[12:0]       */
    uint32 :19;                                            /* Reserved Bits    */
} __type23;
typedef struct 
{                                                          /* Bit Access       */
    uint32 AMYO:13;                                        /* AMYO[12:0]       */
    uint32 :19;                                            /* Reserved Bits    */
} __type24;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :12;                                            /* Reserved Bits    */
    uint32 EMAM:1;                                         /* EMAM             */
    uint32 :19;                                            /* Reserved Bits    */
} __type25;
typedef struct 
{                                                          /* Bit Access       */
    uint32 LSPR:10;                                        /* LSPR[9:0]        */
    uint32 :22;                                            /* Reserved Bits    */
} __type26;
typedef struct 
{                                                          /* Bit Access       */
    uint32 LEPR:10;                                        /* LEPR[9:0]        */
    uint32 :22;                                            /* Reserved Bits    */
} __type27;
typedef struct 
{                                                          /* Bit Access       */
    uint32 LMSR:3;                                         /* LMSR[2:0]        */
    uint32 :29;                                            /* Reserved Bits    */
} __type28;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CLK_START:1;                                    /* CLK_START        */
    uint32 :15;                                            /* Reserved Bits    */
    uint32 VO1_ENABLE:1;                                   /* VO1_ENABLE       */
    uint32 :15;                                            /* Reserved Bits    */
} __type29;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CLK_DIV0:8;                                     /* CLK_DIV0[7:0]    */
    uint32 :8;                                             /* Reserved Bits    */
    uint32 CLK_DIV1:8;                                     /* CLK_DIV1[23:16]  */
    uint32 :8;                                             /* Reserved Bits    */
} __type30;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CONFIG0:3;                                      /* CONFIG0[2:0]     */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 CONFIG1:3;                                      /* CONFIG1[10:8]    */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 OUT_TIM0:3;                                     /* OUT_TIM0[18:16]  */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 OUT_TIM1:3;                                     /* OUT_TIM1[26:24]  */
    uint32 :5;                                             /* Reserved Bits    */
} __type31;
typedef struct 
{                                                          /* Bit Access       */
    uint32 LVRES:1;                                        /* LVRES            */
    uint32 LVEN:1;                                         /* LVEN             */
    uint32 :6;                                             /* Reserved Bits    */
    uint32 LVMD:4;                                         /* LVMD[11:8]       */
    uint32 :20;                                            /* Reserved Bits    */
} __type32;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CLKSTBY:2;                                      /* CLKSTBY[1:0]     */
    uint32 CH1STBY:2;                                      /* CH1STBY[3:2]     */
    uint32 CH2STBY:2;                                      /* CH2STBY[5:4]     */
    uint32 CH3STBY:2;                                      /* CH3STBY[7:6]     */
    uint32 CH4STBY:2;                                      /* CH4STBY[9:8]     */
    uint32 :22;                                            /* Reserved Bits    */
} __type33;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CTR0SEL:3;                                      /* CTR0SEL[2:0]     */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 CTR1SEL:3;                                      /* CTR1SEL[6:4]     */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 CTR2SEL:3;                                      /* CTR2SEL[10:8]    */
    uint32 :21;                                            /* Reserved Bits    */
} __type34;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CH1SEL:2;                                       /* CH1SEL[1:0]      */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 CH2SEL:2;                                       /* CH2SEL[5:4]      */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 CH3SEL:2;                                       /* CH3SEL[9:8]      */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 CH4SEL:2;                                       /* CH4SEL[13:12]    */
    uint32 :18;                                            /* Reserved Bits    */
} __type35;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SKEW1:3;                                        /* SKEW1[2:0]       */
    uint32 SKEW2:3;                                        /* SKEW2[5:3]       */
    uint32 SKEW3:3;                                        /* SKEW3[8:6]       */
    uint32 SKEW4:3;                                        /* SKEW4[11:9]      */
    uint32 SKEWC:3;                                        /* SKEWC[14:12]     */
    uint32 :17;                                            /* Reserved Bits    */
} __type36;
typedef struct 
{                                                          /* Bit Access       */
    uint32 INP_IMG_UPDATE:1;                               /* INP_IMG_UPDATE   */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 INP_EXT_UPDATE:1;                               /* INP_EXT_UPDATE   */
    uint32 :27;                                            /* Reserved Bits    */
} __type37;
typedef struct 
{                                                          /* Bit Access       */
    uint32 INP_HS_EDGE:1;                                  /* INP_HS_EDGE      */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 INP_VS_EDGE:1;                                  /* INP_VS_EDGE      */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 INP_PXD_EDGE:1;                                 /* INP_PXD_EDGE     */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 INP_FORMAT:3;                                   /* INP_FORMAT[14:12] */
    uint32 :17;                                            /* Reserved Bits    */
} __type38;
typedef struct 
{                                                          /* Bit Access       */
    uint32 INP_H_POS:2;                                    /* INP_H_POS[1:0]   */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 INP_F525_625:1;                                 /* INP_F525_625     */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 INP_H_EDGE_SEL:1;                               /* INP_H_EDGE_SEL   */
    uint32 :7;                                             /* Reserved Bits    */
    uint32 INP_HS_INV:1;                                   /* INP_HS_INV       */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 INP_VS_INV:1;                                   /* INP_VS_INV       */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 INP_SWAP_ON:1;                                  /* INP_SWAP_ON      */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 INP_ENDIAN_ON:1;                                /* INP_ENDIAN_ON    */
    uint32 :3;                                             /* Reserved Bits    */
} __type39;
typedef struct 
{                                                          /* Bit Access       */
    uint32 INP_FH25:10;                                    /* INP_FH25[9:0]    */
    uint32 :6;                                             /* Reserved Bits    */
    uint32 INP_FH50:10;                                    /* INP_FH50[25:16]  */
    uint32 :6;                                             /* Reserved Bits    */
} __type40;
typedef struct 
{                                                          /* Bit Access       */
    uint32 INP_HS_DLY:8;                                   /* INP_HS_DLY[7:0]  */
    uint32 INP_VS_DLY:8;                                   /* INP_VS_DLY[15:8] */
    uint32 INP_FLD_DLY:8;                                  /* INP_FLD_DLY[23:16] */
    uint32 INP_VS_DLY_L:3;                                 /* INP_VS_DLY_L[26:24] */
    uint32 :5;                                             /* Reserved Bits    */
} __type41;
typedef struct 
{                                                          /* Bit Access       */
    uint32 IMGCNT_VEN:1;                                   /* IMGCNT_VEN       */
    uint32 :31;                                            /* Reserved Bits    */
} __type42;
typedef struct 
{                                                          /* Bit Access       */
    uint32 IMGCNT_MTX_MD:2;                                /* IMGCNT_MTX_MD[1:0] */
    uint32 :30;                                            /* Reserved Bits    */
} __type43;
typedef struct 
{                                                          /* Bit Access       */
    uint32 IMGCNT_MTX_GG:11;                               /* IMGCNT_MTX_GG[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 IMGCNT_MTX_YG:8;                                /* IMGCNT_MTX_YG[23:16] */
    uint32 :8;                                             /* Reserved Bits    */
} __type44;
typedef struct 
{                                                          /* Bit Access       */
    uint32 IMGCNT_MTX_GR:11;                               /* IMGCNT_MTX_GR[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 IMGCNT_MTX_GB:11;                               /* IMGCNT_MTX_GB[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type45;
typedef struct 
{                                                          /* Bit Access       */
    uint32 IMGCNT_MTX_BG:11;                               /* IMGCNT_MTX_BG[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 IMGCNT_MTX_B:8;                                 /* IMGCNT_MTX_B[23:16] */
    uint32 :8;                                             /* Reserved Bits    */
} __type46;
typedef struct 
{                                                          /* Bit Access       */
    uint32 IMGCNT_MTX_BR:11;                               /* IMGCNT_MTX_BR[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 IMGCNT_MTX_BB:11;                               /* IMGCNT_MTX_BB[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type47;
typedef struct 
{                                                          /* Bit Access       */
    uint32 IMGCNT_MTX_RG:11;                               /* IMGCNT_MTX_RG[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 IMGCNT_MTX_R:8;                                 /* IMGCNT_MTX_R[23:16] */
    uint32 :8;                                             /* Reserved Bits    */
} __type48;
typedef struct 
{                                                          /* Bit Access       */
    uint32 IMGCNT_MTX_RR:11;                               /* IMGCNT_MTX_RR[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 IMGCNT_MTX_RB:11;                               /* IMGCNT_MTX_RB[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type49;
typedef struct 
{                                                          /* Bit Access       */
    uint32 DRC_EN:1;                                       /* DRC_EN           */
    uint32 :31;                                            /* Reserved Bits    */
} __type50;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC0_SCL0_VEN_A:1;                               /* SC0_SCL0_VEN_A   */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 SC0_SCL0_VEN_B:1;                               /* SC0_SCL0_VEN_B   */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 SC0_SCL0_UPDATE:1;                              /* SC0_SCL0_UPDATE  */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 SC0_SCL0_VEN_C:1;                               /* SC0_SCL0_VEN_C   */
    uint32 SC0_SCL0_VEN_D:1;                               /* SC0_SCL0_VEN_D   */
    uint32 :18;                                            /* Reserved Bits    */
} __type51;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC0_RES_VMASK_ON:1;                             /* SC0_RES_VMASK_ON */
    uint32 :15;                                            /* Reserved Bits    */
    uint32 SC0_RES_VMASK:16;                               /* SC0_RES_VMASK[31:16] */
} __type52;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC0_RES_VLACK_ON:1;                             /* SC0_RES_VLACK_ON */
    uint32 :15;                                            /* Reserved Bits    */
    uint32 SC0_RES_VLACK:16;                               /* SC0_RES_VLACK[31:16] */
} __type53;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC0_RES_VS_SEL:1;                               /* SC0_RES_VS_SEL   */
    uint32 :7;                                             /* Reserved Bits    */
    uint32 SC0_RES_VS_IN_SEL:1;                            /* SC0_RES_VS_IN_SEL */
    uint32 :23;                                            /* Reserved Bits    */
} __type54;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC0_RES_FH:11;                                  /* SC0_RES_FH[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 SC0_RES_FV:11;                                  /* SC0_RES_FV[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type55;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC0_RES_VSDLY:8;                                /* SC0_RES_VSDLY[7:0] */
    uint32 SC0_RES_FLD_DLY_SEL:1;                          /* SC0_RES_FLD_DLY_SEL */
    uint32 :23;                                            /* Reserved Bits    */
} __type56;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC0_RES_F_VW:11;                                /* SC0_RES_F_VW[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 SC0_RES_F_VS:11;                                /* SC0_RES_F_VS[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type57;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC0_RES_F_HW:11;                                /* SC0_RES_F_HW[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 SC0_RES_F_HS:11;                                /* SC0_RES_F_HS[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type58;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC0_RES_QVLACK:1;                               /* SC0_RES_QVLACK   */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 SC0_RES_QVLOCK:1;                               /* SC0_RES_QVLOCK   */
    uint32 :27;                                            /* Reserved Bits    */
} __type59;
typedef struct 
{                                                          /* Bit Access       */
    uint16 SC0_RES_LIN_STAT:11;                            /* SC0_RES_LIN_STAT[10:0] */
    uint16 :5;                                             /* Reserved Bits    */
} __type60;
typedef struct 
{                                                          /* Bit Access       */
    uint16 SC0_RES_LINE:11;                                /* SC0_RES_LINE[10:0] */
    uint16 :5;                                             /* Reserved Bits    */
} __type61;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC0_RES_DS_H_ON:1;                              /* SC0_RES_DS_H_ON  */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 SC0_RES_DS_V_ON:1;                              /* SC0_RES_DS_V_ON  */
    uint32 :27;                                            /* Reserved Bits    */
} __type62;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC0_RES_VW:11;                                  /* SC0_RES_VW[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 SC0_RES_VS:11;                                  /* SC0_RES_VS[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type63;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC0_RES_HW:11;                                  /* SC0_RES_HW[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 SC0_RES_HS:11;                                  /* SC0_RES_HS[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type64;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC0_RES_DS_H_RATIO:16;                          /* SC0_RES_DS_H_RATIO[15:0] */
    uint32 :12;                                            /* Reserved Bits    */
    uint32 SC0_RES_DS_H_INTERPOTYP:1;                      /* SC0_RES_DS_H_INTERPOTYP */
    uint32 SC0_RES_PFIL_SEL:1;                             /* SC0_RES_PFIL_SEL */
    uint32 :2;                                             /* Reserved Bits    */
} __type65;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC0_RES_BTM_INIPHASE:12;                        /* SC0_RES_BTM_INIPHASE[11:0] */
    uint32 :4;                                             /* Reserved Bits    */
    uint32 SC0_RES_TOP_INIPHASE:12;                        /* SC0_RES_TOP_INIPHASE[27:16] */
    uint32 SC0_RES_V_INTERPOTYP:1;                         /* SC0_RES_V_INTERPOTYP */
    uint32 :3;                                             /* Reserved Bits    */
} __type66;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC0_RES_V_RATIO:16;                             /* SC0_RES_V_RATIO[15:0] */
    uint32 :16;                                            /* Reserved Bits    */
} __type67;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC0_RES_OUT_HW:11;                              /* SC0_RES_OUT_HW[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 SC0_RES_OUT_VW:11;                              /* SC0_RES_OUT_VW[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type68;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC0_RES_US_H_ON:1;                              /* SC0_RES_US_H_ON  */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 SC0_RES_US_V_ON:1;                              /* SC0_RES_US_V_ON  */
    uint32 :27;                                            /* Reserved Bits    */
} __type69;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC0_RES_P_VW:11;                                /* SC0_RES_P_VW[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 SC0_RES_P_VS:11;                                /* SC0_RES_P_VS[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type70;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC0_RES_P_HW:11;                                /* SC0_RES_P_HW[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 SC0_RES_P_HS:11;                                /* SC0_RES_P_HS[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type71;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC0_RES_IN_HW:11;                               /* SC0_RES_IN_HW[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 SC0_RES_IN_VW:11;                               /* SC0_RES_IN_VW[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type72;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC0_RES_US_H_RATIO:16;                          /* SC0_RES_US_H_RATIO[15:0] */
    uint32 :16;                                            /* Reserved Bits    */
} __type73;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC0_RES_US_HB_INIPHASE:12;                      /* SC0_RES_US_HB_INIPHASE[11:0] */
    uint32 :4;                                             /* Reserved Bits    */
    uint32 SC0_RES_US_HT_INIPHASE:12;                      /* SC0_RES_US_HT_INIPHASE[27:16] */
    uint32 SC0_RES_US_H_INTERPOTYP:1;                      /* SC0_RES_US_H_INTERPOTYP */
    uint32 :3;                                             /* Reserved Bits    */
} __type74;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC0_RES_VCUT:8;                                 /* SC0_RES_VCUT[7:0] */
    uint32 SC0_RES_HCUT:8;                                 /* SC0_RES_HCUT[15:8] */
    uint32 :16;                                            /* Reserved Bits    */
} __type75;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC0_RES_DISP_ON:1;                              /* SC0_RES_DISP_ON  */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 SC0_RES_IBUS_SYNC_SEL:1;                        /* SC0_RES_IBUS_SYNC_SEL */
    uint32 :27;                                            /* Reserved Bits    */
} __type76;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC0_RES_BK_COL_B:8;                             /* SC0_RES_BK_COL_B[7:0] */
    uint32 SC0_RES_BK_COL_G:8;                             /* SC0_RES_BK_COL_G[15:8] */
    uint32 SC0_RES_BK_COL_R:8;                             /* SC0_RES_BK_COL_R[23:16] */
    uint32 :8;                                             /* Reserved Bits    */
} __type77;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC0_SCL1_VEN_A:1;                               /* SC0_SCL1_VEN_A   */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 SC0_SCL1_VEN_B:1;                               /* SC0_SCL1_VEN_B   */
    uint32 :11;                                            /* Reserved Bits    */
    uint32 SC0_SCL1_UPDATE_A:1;                            /* SC0_SCL1_UPDATE_A */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 SC0_SCL1_UPDATE_B:1;                            /* SC0_SCL1_UPDATE_B */
    uint32 :11;                                            /* Reserved Bits    */
} __type78;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 SC0_RES_LOOP:1;                                 /* SC0_RES_LOOP     */
    uint32 SC0_RES_MD:2;                                   /* SC0_RES_MD[3:2]  */
    uint32 SC0_RES_DS_WR_MD:3;                             /* SC0_RES_DS_WR_MD[6:4] */
    uint32 SC0_RES_TB_ADD_MOD:1;                           /* SC0_RES_TB_ADD_MOD */
    uint32 :8;                                             /* Reserved Bits    */
    uint32 SC0_RES_WRSWA:3;                                /* SC0_RES_WRSWA[18:16] */
    uint32 :13;                                            /* Reserved Bits    */
} __type79;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC0_RES_BASE:32;                                /* SC0_RES_BASE[31:0] */
} __type80;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC0_RES_FLM_NUM:10;                             /* SC0_RES_FLM_NUM[9:0] */
    uint32 :6;                                             /* Reserved Bits    */
    uint32 SC0_RES_LN_OFF:15;                              /* SC0_RES_LN_OFF[30:16] */
    uint32 :1;                                             /* Reserved Bits    */
} __type81;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC0_RES_FLM_OFF:23;                             /* SC0_RES_FLM_OFF[22:0] */
    uint32 :9;                                             /* Reserved Bits    */
} __type82;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC0_RES_WENB:1;                                 /* SC0_RES_WENB     */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 SC0_RES_FLD_SEL:1;                              /* SC0_RES_FLD_SEL  */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 SC0_RES_FS_RATE:2;                              /* SC0_RES_FS_RATE[9:8] */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 SC0_RES_INTER:1;                                /* SC0_RES_INTER    */
    uint32 :19;                                            /* Reserved Bits    */
} __type83;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC0_RES_BITDEC_ON:1;                            /* SC0_RES_BITDEC_ON */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 SC0_RES_DTH_ON:1;                               /* SC0_RES_DTH_ON   */
    uint32 :27;                                            /* Reserved Bits    */
} __type84;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC0_RES_FLM_CNT:10;                             /* SC0_RES_FLM_CNT[9:0] */
    uint32 :6;                                             /* Reserved Bits    */
    uint32 SC0_RES_OVERFLOW:1;                             /* SC0_RES_OVERFLOW */
    uint32 :15;                                            /* Reserved Bits    */
} __type85;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC0_RES_BASE_B:32;                              /* SC0_RES_BASE_B[31:0] */
} __type86;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC0_RES_FLM_NUM_B:10;                           /* SC0_RES_FLM_NUM_B[9:0] */
    uint32 :6;                                             /* Reserved Bits    */
    uint32 SC0_RES_LN_OFF_B:15;                            /* SC0_RES_LN_OFF_B[30:16] */
    uint32 :1;                                             /* Reserved Bits    */
} __type87;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC0_RES_FLM_OFF_B:23;                           /* SC0_RES_FLM_OFF_B[22:0] */
    uint32 :9;                                             /* Reserved Bits    */
} __type88;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC0_RES_FLM_CNT_B:10;                           /* SC0_RES_FLM_CNT_B[9:0] */
    uint32 :22;                                            /* Reserved Bits    */
} __type89;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR0_IBUS_VEN:1;                                 /* GR0_IBUS_VEN     */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 GR0_P_VEN:1;                                    /* GR0_P_VEN        */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 GR0_UPDATE:1;                                   /* GR0_UPDATE       */
    uint32 :23;                                            /* Reserved Bits    */
} __type90;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR0_R_ENB:1;                                    /* GR0_R_ENB        */
    uint32 :31;                                            /* Reserved Bits    */
} __type91;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :8;                                             /* Reserved Bits    */
    uint32 GR0_FLM_SEL:2;                                  /* GR0_FLM_SEL[9:8] */
    uint32 :6;                                             /* Reserved Bits    */
    uint32 GR0_LN_OFF_DIR:1;                               /* GR0_LN_OFF_DIR   */
    uint32 :14;                                            /* Reserved Bits    */
    uint32 GR0_FLD_SEL:1;                                  /* GR0_FLD_SEL      */
} __type92;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR0_BASE:32;                                    /* GR0_BASE[31:0]   */
} __type93;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR0_FLM_NUM:10;                                 /* GR0_FLM_NUM[9:0] */
    uint32 :6;                                             /* Reserved Bits    */
    uint32 GR0_LN_OFF:15;                                  /* GR0_LN_OFF[30:16] */
    uint32 GR0_FLD_NXT:1;                                  /* GR0_FLD_NXT      */
} __type94;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR0_FLM_OFF:23;                                 /* GR0_FLM_OFF[22:0] */
    uint32 :9;                                             /* Reserved Bits    */
} __type95;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR0_FLM_LOOP:11;                                /* GR0_FLM_LOOP[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GR0_FLM_LNUM:11;                                /* GR0_FLM_LNUM[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type96;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR0_STA_POS:6;                                  /* GR0_STA_POS[5:0] */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 GR0_CNV444_MD:1;                                /* GR0_CNV444_MD    */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 GR0_RDSWA:3;                                    /* GR0_RDSWA[12:10] */
    uint32 GR0_YCC_SWAP:3;                                 /* GR0_YCC_SWAP[15:13] */
    uint32 GR0_HW:11;                                      /* GR0_HW[26:16]    */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 GR0_FORMAT:4;                                   /* GR0_FORMAT[31:28] */
} __type97;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR0_DISP_SEL:2;                                 /* GR0_DISP_SEL[1:0] */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 GR0_GRC_DISP_ON:1;                              /* GR0_GRC_DISP_ON  */
    uint32 :27;                                            /* Reserved Bits    */
} __type98;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR0_GRC_VW:11;                                  /* GR0_GRC_VW[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GR0_GRC_VS:11;                                  /* GR0_GRC_VS[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type99;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR0_GRC_HW:11;                                  /* GR0_GRC_HW[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GR0_GRC_HS:11;                                  /* GR0_GRC_HS[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type100;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR0_CK_ON:1;                                    /* GR0_CK_ON        */
    uint32 :31;                                            /* Reserved Bits    */
} __type101;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR0_CK_KR:8;                                    /* GR0_CK_KR[7:0]   */
    uint32 GR0_CK_KB:8;                                    /* GR0_CK_KB[15:8]  */
    uint32 GR0_CK_KG:8;                                    /* GR0_CK_KG[23:16] */
    uint32 GR0_CK_KCLUT:8;                                 /* GR0_CK_KCLUT[31:24] */
} __type102;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR0_CK_R:8;                                     /* GR0_CK_R[7:0]    */
    uint32 GR0_CK_B:8;                                     /* GR0_CK_B[15:8]   */
    uint32 GR0_CK_G:8;                                     /* GR0_CK_G[23:16]  */
    uint32 GR0_CK_A:8;                                     /* GR0_CK_A[31:24]  */
} __type103;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR0_R0:8;                                       /* GR0_R0[7:0]      */
    uint32 GR0_B0:8;                                       /* GR0_B0[15:8]     */
    uint32 GR0_G0:8;                                       /* GR0_G0[23:16]    */
    uint32 GR0_A0:8;                                       /* GR0_A0[31:24]    */
} __type104;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR0_R1:8;                                       /* GR0_R1[7:0]      */
    uint32 GR0_B1:8;                                       /* GR0_B1[15:8]     */
    uint32 GR0_G1:8;                                       /* GR0_G1[23:16]    */
    uint32 GR0_A1:8;                                       /* GR0_A1[31:24]    */
} __type105;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR0_BASE_R:8;                                   /* GR0_BASE_R[7:0]  */
    uint32 GR0_BASE_B:8;                                   /* GR0_BASE_B[15:8] */
    uint32 GR0_BASE_G:8;                                   /* GR0_BASE_G[23:16] */
    uint32 :8;                                             /* Reserved Bits    */
} __type106;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :16;                                            /* Reserved Bits    */
    uint32 GR0_CLT_SEL:1;                                  /* GR0_CLT_SEL      */
    uint32 :15;                                            /* Reserved Bits    */
} __type107;
typedef struct 
{                                                          /* Bit Access       */
    uint32 ADJ0_VEN:1;                                     /* ADJ0_VEN         */
    uint32 :31;                                            /* Reserved Bits    */
} __type108;
typedef struct 
{                                                          /* Bit Access       */
    uint32 ADJ0_MTX_MD:2;                                  /* ADJ0_MTX_MD[1:0] */
    uint32 :30;                                            /* Reserved Bits    */
} __type109;
typedef struct 
{                                                          /* Bit Access       */
    uint32 ADJ0_MTX_GG:11;                                 /* ADJ0_MTX_GG[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 ADJ0_MTX_YG:8;                                  /* ADJ0_MTX_YG[23:16] */
    uint32 :8;                                             /* Reserved Bits    */
} __type110;
typedef struct 
{                                                          /* Bit Access       */
    uint32 ADJ0_MTX_GR:11;                                 /* ADJ0_MTX_GR[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 ADJ0_MTX_GB:11;                                 /* ADJ0_MTX_GB[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type111;
typedef struct 
{                                                          /* Bit Access       */
    uint32 ADJ0_MTX_BG:11;                                 /* ADJ0_MTX_BG[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 ADJ0_MTX_B:8;                                   /* ADJ0_MTX_B[23:16] */
    uint32 :8;                                             /* Reserved Bits    */
} __type112;
typedef struct 
{                                                          /* Bit Access       */
    uint32 ADJ0_MTX_BR:11;                                 /* ADJ0_MTX_BR[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 ADJ0_MTX_BB:11;                                 /* ADJ0_MTX_BB[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type113;
typedef struct 
{                                                          /* Bit Access       */
    uint32 ADJ0_MTX_RG:11;                                 /* ADJ0_MTX_RG[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 ADJ0_MTX_R:8;                                   /* ADJ0_MTX_R[23:16] */
    uint32 :8;                                             /* Reserved Bits    */
} __type114;
typedef struct 
{                                                          /* Bit Access       */
    uint32 ADJ0_MTX_RR:11;                                 /* ADJ0_MTX_RR[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 ADJ0_MTX_RB:11;                                 /* ADJ0_MTX_RB[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type115;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR2_IBUS_VEN:1;                                 /* GR2_IBUS_VEN     */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 GR2_P_VEN:1;                                    /* GR2_P_VEN        */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 GR2_UPDATE:1;                                   /* GR2_UPDATE       */
    uint32 :23;                                            /* Reserved Bits    */
} __type116;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR2_R_ENB:1;                                    /* GR2_R_ENB        */
    uint32 :31;                                            /* Reserved Bits    */
} __type117;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :8;                                             /* Reserved Bits    */
    uint32 GR2_FLM_SEL:2;                                  /* GR2_FLM_SEL[9:8] */
    uint32 :6;                                             /* Reserved Bits    */
    uint32 GR2_LN_OFF_DIR:1;                               /* GR2_LN_OFF_DIR   */
    uint32 :15;                                            /* Reserved Bits    */
} __type118;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR2_BASE:32;                                    /* GR2_BASE[31:0]   */
} __type119;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR2_FLM_NUM:10;                                 /* GR2_FLM_NUM[9:0] */
    uint32 :6;                                             /* Reserved Bits    */
    uint32 GR2_LN_OFF:15;                                  /* GR2_LN_OFF[30:16] */
    uint32 :1;                                             /* Reserved Bits    */
} __type120;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR2_FLM_OFF:23;                                 /* GR2_FLM_OFF[22:0] */
    uint32 :9;                                             /* Reserved Bits    */
} __type121;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR2_FLM_LOOP:11;                                /* GR2_FLM_LOOP[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GR2_FLM_LNUM:11;                                /* GR2_FLM_LNUM[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type122;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR2_STA_POS:6;                                  /* GR2_STA_POS[5:0] */
    uint32 :4;                                             /* Reserved Bits    */
    uint32 GR2_RDSWA:3;                                    /* GR2_RDSWA[12:10] */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 GR2_HW:11;                                      /* GR2_HW[26:16]    */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 GR2_FORMAT:4;                                   /* GR2_FORMAT[31:28] */
} __type123;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR2_DISP_SEL:2;                                 /* GR2_DISP_SEL[1:0] */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 GR2_GRC_DISP_ON:1;                              /* GR2_GRC_DISP_ON  */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 GR2_ARC_DISP_ON:1;                              /* GR2_ARC_DISP_ON  */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 GR2_ARC_ON:1;                                   /* GR2_ARC_ON       */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 GR2_ACALC_MD:1;                                 /* GR2_ACALC_MD     */
    uint32 GR2_ARC_MUL:1;                                  /* GR2_ARC_MUL      */
    uint32 :16;                                            /* Reserved Bits    */
} __type124;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR2_GRC_VW:11;                                  /* GR2_GRC_VW[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GR2_GRC_VS:11;                                  /* GR2_GRC_VS[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type125;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR2_GRC_HW:11;                                  /* GR2_GRC_HW[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GR2_GRC_HS:11;                                  /* GR2_GRC_HS[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type126;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR2_ARC_VW:11;                                  /* GR2_ARC_VW[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GR2_ARC_VS:11;                                  /* GR2_ARC_VS[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type127;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR2_ARC_HW:11;                                  /* GR2_ARC_HW[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GR2_ARC_HS:11;                                  /* GR2_ARC_HS[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type128;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR2_ARC_RATE:8;                                 /* GR2_ARC_RATE[7:0] */
    uint32 :8;                                             /* Reserved Bits    */
    uint32 GR2_ARC_COEF:8;                                 /* GR2_ARC_COEF[23:16] */
    uint32 GR2_ARC_MODE:1;                                 /* GR2_ARC_MODE     */
    uint32 :7;                                             /* Reserved Bits    */
} __type129;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR2_CK_ON:1;                                    /* GR2_CK_ON        */
    uint32 :15;                                            /* Reserved Bits    */
    uint32 GR2_ARC_DEF:8;                                  /* GR2_ARC_DEF[23:16] */
    uint32 :8;                                             /* Reserved Bits    */
} __type130;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR2_CK_KR:8;                                    /* GR2_CK_KR[7:0]   */
    uint32 GR2_CK_KB:8;                                    /* GR2_CK_KB[15:8]  */
    uint32 GR2_CK_KG:8;                                    /* GR2_CK_KG[23:16] */
    uint32 GR2_CK_KCLUT:8;                                 /* GR2_CK_KCLUT[31:24] */
} __type131;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR2_CK_R:8;                                     /* GR2_CK_R[7:0]    */
    uint32 GR2_CK_B:8;                                     /* GR2_CK_B[15:8]   */
    uint32 GR2_CK_G:8;                                     /* GR2_CK_G[23:16]  */
    uint32 GR2_CK_A:8;                                     /* GR2_CK_A[31:24]  */
} __type132;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR2_R0:8;                                       /* GR2_R0[7:0]      */
    uint32 GR2_B0:8;                                       /* GR2_B0[15:8]     */
    uint32 GR2_G0:8;                                       /* GR2_G0[23:16]    */
    uint32 GR2_A0:8;                                       /* GR2_A0[31:24]    */
} __type133;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR2_R1:8;                                       /* GR2_R1[7:0]      */
    uint32 GR2_B1:8;                                       /* GR2_B1[15:8]     */
    uint32 GR2_G1:8;                                       /* GR2_G1[23:16]    */
    uint32 GR2_A1:8;                                       /* GR2_A1[31:24]    */
} __type134;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR2_BASE_R:8;                                   /* GR2_BASE_R[7:0]  */
    uint32 GR2_BASE_B:8;                                   /* GR2_BASE_B[15:8] */
    uint32 GR2_BASE_G:8;                                   /* GR2_BASE_G[23:16] */
    uint32 :8;                                             /* Reserved Bits    */
} __type135;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :16;                                            /* Reserved Bits    */
    uint32 GR2_CLT_SEL:1;                                  /* GR2_CLT_SEL      */
    uint32 :15;                                            /* Reserved Bits    */
} __type136;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR2_ARC_ST:1;                                   /* GR2_ARC_ST       */
    uint32 :31;                                            /* Reserved Bits    */
} __type137;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR3_IBUS_VEN:1;                                 /* GR3_IBUS_VEN     */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 GR3_P_VEN:1;                                    /* GR3_P_VEN        */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 GR3_UPDATE:1;                                   /* GR3_UPDATE       */
    uint32 :23;                                            /* Reserved Bits    */
} __type138;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR3_R_ENB:1;                                    /* GR3_R_ENB        */
    uint32 :31;                                            /* Reserved Bits    */
} __type139;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :8;                                             /* Reserved Bits    */
    uint32 GR3_FLM_SEL:2;                                  /* GR3_FLM_SEL[9:8] */
    uint32 :6;                                             /* Reserved Bits    */
    uint32 GR3_LN_OFF_DIR:1;                               /* GR3_LN_OFF_DIR   */
    uint32 :15;                                            /* Reserved Bits    */
} __type140;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR3_BASE:32;                                    /* GR3_BASE[31:0]   */
} __type141;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR3_FLM_NUM:10;                                 /* GR3_FLM_NUM[9:0] */
    uint32 :6;                                             /* Reserved Bits    */
    uint32 GR3_LN_OFF:15;                                  /* GR3_LN_OFF[30:16] */
    uint32 :1;                                             /* Reserved Bits    */
} __type142;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR3_FLM_OFF:23;                                 /* GR3_FLM_OFF[22:0] */
    uint32 :9;                                             /* Reserved Bits    */
} __type143;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR3_FLM_LOOP:11;                                /* GR3_FLM_LOOP[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GR3_FLM_LNUM:11;                                /* GR3_FLM_LNUM[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type144;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR3_STA_POS:6;                                  /* GR3_STA_POS[5:0] */
    uint32 :4;                                             /* Reserved Bits    */
    uint32 GR3_RDSWA:3;                                    /* GR3_RDSWA[12:10] */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 GR3_HW:11;                                      /* GR3_HW[26:16]    */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 GR3_FORMAT:4;                                   /* GR3_FORMAT[31:28] */
} __type145;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR3_DISP_SEL:2;                                 /* GR3_DISP_SEL[1:0] */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 GR3_GRC_DISP_ON:1;                              /* GR3_GRC_DISP_ON  */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 GR3_ARC_DISP_ON:1;                              /* GR3_ARC_DISP_ON  */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 GR3_ARC_ON:1;                                   /* GR3_ARC_ON       */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 GR3_ACALC_MD:1;                                 /* GR3_ACALC_MD     */
    uint32 GR3_ARC_MUL:1;                                  /* GR3_ARC_MUL      */
    uint32 :16;                                            /* Reserved Bits    */
} __type146;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR3_GRC_VW:11;                                  /* GR3_GRC_VW[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GR3_GRC_VS:11;                                  /* GR3_GRC_VS[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type147;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR3_GRC_HW:11;                                  /* GR3_GRC_HW[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GR3_GRC_HS:11;                                  /* GR3_GRC_HS[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type148;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR3_ARC_VW:11;                                  /* GR3_ARC_VW[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GR3_ARC_VS:11;                                  /* GR3_ARC_VS[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type149;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR3_ARC_HW:11;                                  /* GR3_ARC_HW[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GR3_ARC_HS:11;                                  /* GR3_ARC_HS[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type150;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR3_ARC_RATE:8;                                 /* GR3_ARC_RATE[7:0] */
    uint32 :8;                                             /* Reserved Bits    */
    uint32 GR3_ARC_COEF:8;                                 /* GR3_ARC_COEF[23:16] */
    uint32 GR3_ARC_MODE:1;                                 /* GR3_ARC_MODE     */
    uint32 :7;                                             /* Reserved Bits    */
} __type151;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR3_CK_ON:1;                                    /* GR3_CK_ON        */
    uint32 :15;                                            /* Reserved Bits    */
    uint32 GR3_ARC_DEF:8;                                  /* GR3_ARC_DEF[23:16] */
    uint32 :8;                                             /* Reserved Bits    */
} __type152;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR3_CK_KR:8;                                    /* GR3_CK_KR[7:0]   */
    uint32 GR3_CK_KB:8;                                    /* GR3_CK_KB[15:8]  */
    uint32 GR3_CK_KG:8;                                    /* GR3_CK_KG[23:16] */
    uint32 GR3_CK_KCLUT:8;                                 /* GR3_CK_KCLUT[31:24] */
} __type153;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR3_CK_R:8;                                     /* GR3_CK_R[7:0]    */
    uint32 GR3_CK_B:8;                                     /* GR3_CK_B[15:8]   */
    uint32 GR3_CK_G:8;                                     /* GR3_CK_G[23:16]  */
    uint32 GR3_CK_A:8;                                     /* GR3_CK_A[31:24]  */
} __type154;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR3_R0:8;                                       /* GR3_R0[7:0]      */
    uint32 GR3_B0:8;                                       /* GR3_B0[15:8]     */
    uint32 GR3_G0:8;                                       /* GR3_G0[23:16]    */
    uint32 GR3_A0:8;                                       /* GR3_A0[31:24]    */
} __type155;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR3_R1:8;                                       /* GR3_R1[7:0]      */
    uint32 GR3_B1:8;                                       /* GR3_B1[15:8]     */
    uint32 GR3_G1:8;                                       /* GR3_G1[23:16]    */
    uint32 GR3_A1:8;                                       /* GR3_A1[31:24]    */
} __type156;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR3_BASE_R:8;                                   /* GR3_BASE_R[7:0]  */
    uint32 GR3_BASE_B:8;                                   /* GR3_BASE_B[15:8] */
    uint32 GR3_BASE_G:8;                                   /* GR3_BASE_G[23:16] */
    uint32 :8;                                             /* Reserved Bits    */
} __type157;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR3_LINE:11;                                    /* GR3_LINE[10:0]   */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GR3_CLT_SEL:1;                                  /* GR3_CLT_SEL      */
    uint32 :15;                                            /* Reserved Bits    */
} __type158;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR3_ARC_ST:1;                                   /* GR3_ARC_ST       */
    uint32 :15;                                            /* Reserved Bits    */
    uint32 GR3_LIN_STAT:11;                                /* GR3_LIN_STAT[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type159;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_G_VEN:1;                                    /* GAM_G_VEN        */
    uint32 :31;                                            /* Reserved Bits    */
} __type160;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_ON:1;                                       /* GAM_ON           */
    uint32 :31;                                            /* Reserved Bits    */
} __type161;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_G_GAIN_00:11;                               /* GAM_G_GAIN_00[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GAM_G_GAIN_01:11;                               /* GAM_G_GAIN_01[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type162;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_G_GAIN_02:11;                               /* GAM_G_GAIN_02[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GAM_G_GAIN_03:11;                               /* GAM_G_GAIN_03[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type163;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_G_GAIN_04:11;                               /* GAM_G_GAIN_04[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GAM_G_GAIN_05:11;                               /* GAM_G_GAIN_05[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type164;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_G_GAIN_06:11;                               /* GAM_G_GAIN_06[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GAM_G_GAIN_07:11;                               /* GAM_G_GAIN_07[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type165;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_G_GAIN_08:11;                               /* GAM_G_GAIN_08[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GAM_G_GAIN_09:11;                               /* GAM_G_GAIN_09[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type166;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_G_GAIN_10:11;                               /* GAM_G_GAIN_10[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GAM_G_GAIN_11:11;                               /* GAM_G_GAIN_11[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type167;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_G_GAIN_12:11;                               /* GAM_G_GAIN_12[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GAM_G_GAIN_13:11;                               /* GAM_G_GAIN_13[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type168;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_G_GAIN_14:11;                               /* GAM_G_GAIN_14[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GAM_G_GAIN_15:11;                               /* GAM_G_GAIN_15[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type169;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_G_GAIN_16:11;                               /* GAM_G_GAIN_16[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GAM_G_GAIN_17:11;                               /* GAM_G_GAIN_17[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type170;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_G_GAIN_18:11;                               /* GAM_G_GAIN_18[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GAM_G_GAIN_19:11;                               /* GAM_G_GAIN_19[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type171;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_G_GAIN_20:11;                               /* GAM_G_GAIN_20[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GAM_G_GAIN_21:11;                               /* GAM_G_GAIN_21[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type172;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_G_GAIN_22:11;                               /* GAM_G_GAIN_22[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GAM_G_GAIN_23:11;                               /* GAM_G_GAIN_23[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type173;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_G_GAIN_24:11;                               /* GAM_G_GAIN_24[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GAM_G_GAIN_25:11;                               /* GAM_G_GAIN_25[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type174;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_G_GAIN_26:11;                               /* GAM_G_GAIN_26[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GAM_G_GAIN_27:11;                               /* GAM_G_GAIN_27[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type175;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_G_GAIN_28:11;                               /* GAM_G_GAIN_28[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GAM_G_GAIN_29:11;                               /* GAM_G_GAIN_29[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type176;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_G_GAIN_30:11;                               /* GAM_G_GAIN_30[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GAM_G_GAIN_31:11;                               /* GAM_G_GAIN_31[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type177;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_G_TH_03:8;                                  /* GAM_G_TH_03[7:0] */
    uint32 GAM_G_TH_02:8;                                  /* GAM_G_TH_02[15:8] */
    uint32 GAM_G_TH_01:8;                                  /* GAM_G_TH_01[23:16] */
    uint32 :8;                                             /* Reserved Bits    */
} __type178;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_G_TH_07:8;                                  /* GAM_G_TH_07[7:0] */
    uint32 GAM_G_TH_06:8;                                  /* GAM_G_TH_06[15:8] */
    uint32 GAM_G_TH_05:8;                                  /* GAM_G_TH_05[23:16] */
    uint32 GAM_G_TH_04:8;                                  /* GAM_G_TH_04[31:24] */
} __type179;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_G_TH_11:8;                                  /* GAM_G_TH_11[7:0] */
    uint32 GAM_G_TH_10:8;                                  /* GAM_G_TH_10[15:8] */
    uint32 GAM_G_TH_09:8;                                  /* GAM_G_TH_09[23:16] */
    uint32 GAM_G_TH_08:8;                                  /* GAM_G_TH_08[31:24] */
} __type180;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_G_TH_15:8;                                  /* GAM_G_TH_15[7:0] */
    uint32 GAM_G_TH_14:8;                                  /* GAM_G_TH_14[15:8] */
    uint32 GAM_G_TH_13:8;                                  /* GAM_G_TH_13[23:16] */
    uint32 GAM_G_TH_12:8;                                  /* GAM_G_TH_12[31:24] */
} __type181;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_G_TH_19:8;                                  /* GAM_G_TH_19[7:0] */
    uint32 GAM_G_TH_18:8;                                  /* GAM_G_TH_18[15:8] */
    uint32 GAM_G_TH_17:8;                                  /* GAM_G_TH_17[23:16] */
    uint32 GAM_G_TH_16:8;                                  /* GAM_G_TH_16[31:24] */
} __type182;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_G_TH_23:8;                                  /* GAM_G_TH_23[7:0] */
    uint32 GAM_G_TH_22:8;                                  /* GAM_G_TH_22[15:8] */
    uint32 GAM_G_TH_21:8;                                  /* GAM_G_TH_21[23:16] */
    uint32 GAM_G_TH_20:8;                                  /* GAM_G_TH_20[31:24] */
} __type183;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_G_TH_27:8;                                  /* GAM_G_TH_27[7:0] */
    uint32 GAM_G_TH_26:8;                                  /* GAM_G_TH_26[15:8] */
    uint32 GAM_G_TH_25:8;                                  /* GAM_G_TH_25[23:16] */
    uint32 GAM_G_TH_24:8;                                  /* GAM_G_TH_24[31:24] */
} __type184;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_G_TH_31:8;                                  /* GAM_G_TH_31[7:0] */
    uint32 GAM_G_TH_30:8;                                  /* GAM_G_TH_30[15:8] */
    uint32 GAM_G_TH_29:8;                                  /* GAM_G_TH_29[23:16] */
    uint32 GAM_G_TH_28:8;                                  /* GAM_G_TH_28[31:24] */
} __type185;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_B_VEN:1;                                    /* GAM_B_VEN        */
    uint32 :31;                                            /* Reserved Bits    */
} __type186;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_B_GAIN_00:11;                               /* GAM_B_GAIN_00[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GAM_B_GAIN_01:11;                               /* GAM_B_GAIN_01[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type187;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_B_GAIN_02:11;                               /* GAM_B_GAIN_02[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GAM_B_GAIN_03:11;                               /* GAM_B_GAIN_03[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type188;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_B_GAIN_04:11;                               /* GAM_B_GAIN_04[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GAM_B_GAIN_05:11;                               /* GAM_B_GAIN_05[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type189;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_B_GAIN_06:11;                               /* GAM_B_GAIN_06[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GAM_B_GAIN_07:11;                               /* GAM_B_GAIN_07[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type190;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_B_GAIN_08:11;                               /* GAM_B_GAIN_08[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GAM_B_GAIN_09:11;                               /* GAM_B_GAIN_09[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type191;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_B_GAIN_10:11;                               /* GAM_B_GAIN_10[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GAM_B_GAIN_11:11;                               /* GAM_B_GAIN_11[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type192;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_B_GAIN_12:11;                               /* GAM_B_GAIN_12[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GAM_B_GAIN_13:11;                               /* GAM_B_GAIN_13[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type193;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_B_GAIN_14:11;                               /* GAM_B_GAIN_14[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GAM_B_GAIN_15:11;                               /* GAM_B_GAIN_15[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type194;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_B_GAIN_16:11;                               /* GAM_B_GAIN_16[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GAM_B_GAIN_17:11;                               /* GAM_B_GAIN_17[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type195;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_B_GAIN_18:11;                               /* GAM_B_GAIN_18[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GAM_B_GAIN_19:11;                               /* GAM_B_GAIN_19[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type196;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_B_GAIN_20:11;                               /* GAM_B_GAIN_20[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GAM_B_GAIN_21:11;                               /* GAM_B_GAIN_21[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type197;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_B_GAIN_22:11;                               /* GAM_B_GAIN_22[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GAM_B_GAIN_23:11;                               /* GAM_B_GAIN_23[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type198;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_B_GAIN_24:11;                               /* GAM_B_GAIN_24[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GAM_B_GAIN_25:11;                               /* GAM_B_GAIN_25[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type199;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_B_GAIN_26:11;                               /* GAM_B_GAIN_26[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GAM_B_GAIN_27:11;                               /* GAM_B_GAIN_27[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type200;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_B_GAIN_28:11;                               /* GAM_B_GAIN_28[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GAM_B_GAIN_29:11;                               /* GAM_B_GAIN_29[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type201;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_B_GAIN_30:11;                               /* GAM_B_GAIN_30[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GAM_B_GAIN_31:11;                               /* GAM_B_GAIN_31[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type202;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_B_TH_03:8;                                  /* GAM_B_TH_03[7:0] */
    uint32 GAM_B_TH_02:8;                                  /* GAM_B_TH_02[15:8] */
    uint32 GAM_B_TH_01:8;                                  /* GAM_B_TH_01[23:16] */
    uint32 :8;                                             /* Reserved Bits    */
} __type203;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_B_TH_07:8;                                  /* GAM_B_TH_07[7:0] */
    uint32 GAM_B_TH_06:8;                                  /* GAM_B_TH_06[15:8] */
    uint32 GAM_B_TH_05:8;                                  /* GAM_B_TH_05[23:16] */
    uint32 GAM_B_TH_04:8;                                  /* GAM_B_TH_04[31:24] */
} __type204;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_B_TH_11:8;                                  /* GAM_B_TH_11[7:0] */
    uint32 GAM_B_TH_10:8;                                  /* GAM_B_TH_10[15:8] */
    uint32 GAM_B_TH_09:8;                                  /* GAM_B_TH_09[23:16] */
    uint32 GAM_B_TH_08:8;                                  /* GAM_B_TH_08[31:24] */
} __type205;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_B_TH_15:8;                                  /* GAM_B_TH_15[7:0] */
    uint32 GAM_B_TH_14:8;                                  /* GAM_B_TH_14[15:8] */
    uint32 GAM_B_TH_13:8;                                  /* GAM_B_TH_13[23:16] */
    uint32 GAM_B_TH_12:8;                                  /* GAM_B_TH_12[31:24] */
} __type206;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_B_TH_19:8;                                  /* GAM_B_TH_19[7:0] */
    uint32 GAM_B_TH_18:8;                                  /* GAM_B_TH_18[15:8] */
    uint32 GAM_B_TH_17:8;                                  /* GAM_B_TH_17[23:16] */
    uint32 GAM_B_TH_16:8;                                  /* GAM_B_TH_16[31:24] */
} __type207;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_B_TH_23:8;                                  /* GAM_B_TH_23[7:0] */
    uint32 GAM_B_TH_22:8;                                  /* GAM_B_TH_22[15:8] */
    uint32 GAM_B_TH_21:8;                                  /* GAM_B_TH_21[23:16] */
    uint32 GAM_B_TH_20:8;                                  /* GAM_B_TH_20[31:24] */
} __type208;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_B_TH_27:8;                                  /* GAM_B_TH_27[7:0] */
    uint32 GAM_B_TH_26:8;                                  /* GAM_B_TH_26[15:8] */
    uint32 GAM_B_TH_25:8;                                  /* GAM_B_TH_25[23:16] */
    uint32 GAM_B_TH_24:8;                                  /* GAM_B_TH_24[31:24] */
} __type209;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_B_TH_31:8;                                  /* GAM_B_TH_31[7:0] */
    uint32 GAM_B_TH_30:8;                                  /* GAM_B_TH_30[15:8] */
    uint32 GAM_B_TH_29:8;                                  /* GAM_B_TH_29[23:16] */
    uint32 GAM_B_TH_28:8;                                  /* GAM_B_TH_28[31:24] */
} __type210;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_R_VEN:1;                                    /* GAM_R_VEN        */
    uint32 :31;                                            /* Reserved Bits    */
} __type211;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_R_GAIN_00:11;                               /* GAM_R_GAIN_00[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GAM_R_GAIN_01:11;                               /* GAM_R_GAIN_01[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type212;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_R_GAIN_02:11;                               /* GAM_R_GAIN_02[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GAM_R_GAIN_03:11;                               /* GAM_R_GAIN_03[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type213;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_R_GAIN_04:11;                               /* GAM_R_GAIN_04[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GAM_R_GAIN_05:11;                               /* GAM_R_GAIN_05[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type214;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_R_GAIN_06:11;                               /* GAM_R_GAIN_06[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GAM_R_GAIN_07:11;                               /* GAM_R_GAIN_07[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type215;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_R_GAIN_08:11;                               /* GAM_R_GAIN_08[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GAM_R_GAIN_09:11;                               /* GAM_R_GAIN_09[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type216;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_R_GAIN_10:11;                               /* GAM_R_GAIN_10[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GAM_R_GAIN_11:11;                               /* GAM_R_GAIN_11[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type217;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_R_GAIN_12:11;                               /* GAM_R_GAIN_12[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GAM_R_GAIN_13:11;                               /* GAM_R_GAIN_13[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type218;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_R_GAIN_14:11;                               /* GAM_R_GAIN_14[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GAM_R_GAIN_15:11;                               /* GAM_R_GAIN_15[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type219;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_R_GAIN_16:11;                               /* GAM_R_GAIN_16[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GAM_R_GAIN_17:11;                               /* GAM_R_GAIN_17[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type220;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_R_GAIN_18:11;                               /* GAM_R_GAIN_18[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GAM_R_GAIN_19:11;                               /* GAM_R_GAIN_19[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type221;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_R_GAIN_20:11;                               /* GAM_R_GAIN_20[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GAM_R_GAIN_21:11;                               /* GAM_R_GAIN_21[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type222;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_R_GAIN_22:11;                               /* GAM_R_GAIN_22[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GAM_R_GAIN_23:11;                               /* GAM_R_GAIN_23[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type223;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_R_GAIN_24:11;                               /* GAM_R_GAIN_24[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GAM_R_GAIN_25:11;                               /* GAM_R_GAIN_25[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type224;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_R_GAIN_26:11;                               /* GAM_R_GAIN_26[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GAM_R_GAIN_27:11;                               /* GAM_R_GAIN_27[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type225;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_R_GAIN_28:11;                               /* GAM_R_GAIN_28[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GAM_R_GAIN_29:11;                               /* GAM_R_GAIN_29[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type226;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_R_GAIN_30:11;                               /* GAM_R_GAIN_30[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GAM_R_GAIN_31:11;                               /* GAM_R_GAIN_31[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type227;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_R_TH_03:8;                                  /* GAM_R_TH_03[7:0] */
    uint32 GAM_R_TH_02:8;                                  /* GAM_R_TH_02[15:8] */
    uint32 GAM_R_TH_01:8;                                  /* GAM_R_TH_01[23:16] */
    uint32 :8;                                             /* Reserved Bits    */
} __type228;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_R_TH_07:8;                                  /* GAM_R_TH_07[7:0] */
    uint32 GAM_R_TH_06:8;                                  /* GAM_R_TH_06[15:8] */
    uint32 GAM_R_TH_05:8;                                  /* GAM_R_TH_05[23:16] */
    uint32 GAM_R_TH_04:8;                                  /* GAM_R_TH_04[31:24] */
} __type229;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_R_TH_11:8;                                  /* GAM_R_TH_11[7:0] */
    uint32 GAM_R_TH_10:8;                                  /* GAM_R_TH_10[15:8] */
    uint32 GAM_R_TH_09:8;                                  /* GAM_R_TH_09[23:16] */
    uint32 GAM_R_TH_08:8;                                  /* GAM_R_TH_08[31:24] */
} __type230;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_R_TH_15:8;                                  /* GAM_R_TH_15[7:0] */
    uint32 GAM_R_TH_14:8;                                  /* GAM_R_TH_14[15:8] */
    uint32 GAM_R_TH_13:8;                                  /* GAM_R_TH_13[23:16] */
    uint32 GAM_R_TH_12:8;                                  /* GAM_R_TH_12[31:24] */
} __type231;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_R_TH_19:8;                                  /* GAM_R_TH_19[7:0] */
    uint32 GAM_R_TH_18:8;                                  /* GAM_R_TH_18[15:8] */
    uint32 GAM_R_TH_17:8;                                  /* GAM_R_TH_17[23:16] */
    uint32 GAM_R_TH_16:8;                                  /* GAM_R_TH_16[31:24] */
} __type232;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_R_TH_23:8;                                  /* GAM_R_TH_23[7:0] */
    uint32 GAM_R_TH_22:8;                                  /* GAM_R_TH_22[15:8] */
    uint32 GAM_R_TH_21:8;                                  /* GAM_R_TH_21[23:16] */
    uint32 GAM_R_TH_20:8;                                  /* GAM_R_TH_20[31:24] */
} __type233;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_R_TH_27:8;                                  /* GAM_R_TH_27[7:0] */
    uint32 GAM_R_TH_26:8;                                  /* GAM_R_TH_26[15:8] */
    uint32 GAM_R_TH_25:8;                                  /* GAM_R_TH_25[23:16] */
    uint32 GAM_R_TH_24:8;                                  /* GAM_R_TH_24[31:24] */
} __type234;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAM_R_TH_31:8;                                  /* GAM_R_TH_31[7:0] */
    uint32 GAM_R_TH_30:8;                                  /* GAM_R_TH_30[15:8] */
    uint32 GAM_R_TH_29:8;                                  /* GAM_R_TH_29[23:16] */
    uint32 GAM_R_TH_28:8;                                  /* GAM_R_TH_28[31:24] */
} __type235;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TCON_VEN:1;                                     /* TCON_VEN         */
    uint32 :31;                                            /* Reserved Bits    */
} __type236;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TCON_OFFSET:11;                                 /* TCON_OFFSET[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 TCON_HALF:11;                                   /* TCON_HALF[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type237;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TCON_STVA_VW:11;                                /* TCON_STVA_VW[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 TCON_STVA_VS:11;                                /* TCON_STVA_VS[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type238;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TCON_STVA_SEL:3;                                /* TCON_STVA_SEL[2:0] */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 TCON_STVA_INV:1;                                /* TCON_STVA_INV    */
    uint32 :27;                                            /* Reserved Bits    */
} __type239;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TCON_STVB_VW:11;                                /* TCON_STVB_VW[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 TCON_STVB_VS:11;                                /* TCON_STVB_VS[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type240;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TCON_STVB_SEL:3;                                /* TCON_STVB_SEL[2:0] */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 TCON_STVB_INV:1;                                /* TCON_STVB_INV    */
    uint32 :27;                                            /* Reserved Bits    */
} __type241;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TCON_STH_HW:11;                                 /* TCON_STH_HW[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 TCON_STH_HS:11;                                 /* TCON_STH_HS[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type242;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TCON_STH_SEL:3;                                 /* TCON_STH_SEL[2:0] */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 TCON_STH_INV:1;                                 /* TCON_STH_INV     */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 TCON_STH_HS_SEL:1;                              /* TCON_STH_HS_SEL  */
    uint32 :23;                                            /* Reserved Bits    */
} __type243;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TCON_STB_HW:11;                                 /* TCON_STB_HW[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 TCON_STB_HS:11;                                 /* TCON_STB_HS[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type244;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TCON_STB_SEL:3;                                 /* TCON_STB_SEL[2:0] */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 TCON_STB_INV:1;                                 /* TCON_STB_INV     */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 TCON_STB_HS_SEL:1;                              /* TCON_STB_HS_SEL  */
    uint32 :23;                                            /* Reserved Bits    */
} __type245;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TCON_CPV_HW:11;                                 /* TCON_CPV_HW[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 TCON_CPV_HS:11;                                 /* TCON_CPV_HS[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type246;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TCON_CPV_SEL:3;                                 /* TCON_CPV_SEL[2:0] */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 TCON_CPV_INV:1;                                 /* TCON_CPV_INV     */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 TCON_CPV_HS_SEL:1;                              /* TCON_CPV_HS_SEL  */
    uint32 :23;                                            /* Reserved Bits    */
} __type247;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TCON_POLA_HW:11;                                /* TCON_POLA_HW[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 TCON_POLA_HS:11;                                /* TCON_POLA_HS[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type248;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TCON_POLA_SEL:3;                                /* TCON_POLA_SEL[2:0] */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 TCON_POLA_INV:1;                                /* TCON_POLA_INV    */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 TCON_POLA_HS_SEL:1;                             /* TCON_POLA_HS_SEL */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 TCON_POLA_MD:2;                                 /* TCON_POLA_MD[13:12] */
    uint32 :18;                                            /* Reserved Bits    */
} __type249;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TCON_POLB_HW:11;                                /* TCON_POLB_HW[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 TCON_POLB_HS:11;                                /* TCON_POLB_HS[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type250;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TCON_POLB_SEL:3;                                /* TCON_POLB_SEL[2:0] */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 TCON_POLB_INV:1;                                /* TCON_POLB_INV    */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 TCON_POLB_HS_SEL:1;                             /* TCON_POLB_HS_SEL */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 TCON_POLB_MD:2;                                 /* TCON_POLB_MD[13:12] */
    uint32 :18;                                            /* Reserved Bits    */
} __type251;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TCON_DE_INV:1;                                  /* TCON_DE_INV      */
    uint32 :31;                                            /* Reserved Bits    */
} __type252;
typedef struct 
{                                                          /* Bit Access       */
    uint32 OUTCNT_VEN:1;                                   /* OUTCNT_VEN       */
    uint32 :31;                                            /* Reserved Bits    */
} __type253;
typedef struct 
{                                                          /* Bit Access       */
    uint32 OUT_PHASE:2;                                    /* OUT_PHASE[1:0]   */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 OUT_DIR_SEL:1;                                  /* OUT_DIR_SEL      */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 OUT_FRQ_SEL:2;                                  /* OUT_FRQ_SEL[9:8] */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 OUT_FORMAT:2;                                   /* OUT_FORMAT[13:12] */
    uint32 :10;                                            /* Reserved Bits    */
    uint32 OUT_SWAP_ON:1;                                  /* OUT_SWAP_ON      */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 OUT_ENDIAN_ON:1;                                /* OUT_ENDIAN_ON    */
    uint32 :3;                                             /* Reserved Bits    */
} __type254;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PBRT_G:10;                                      /* PBRT_G[9:0]      */
    uint32 :22;                                            /* Reserved Bits    */
} __type255;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PBRT_R:10;                                      /* PBRT_R[9:0]      */
    uint32 :6;                                             /* Reserved Bits    */
    uint32 PBRT_B:10;                                      /* PBRT_B[25:16]    */
    uint32 :6;                                             /* Reserved Bits    */
} __type256;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CONT_R:8;                                       /* CONT_R[7:0]      */
    uint32 CONT_B:8;                                       /* CONT_B[15:8]     */
    uint32 CONT_G:8;                                       /* CONT_G[23:16]    */
    uint32 :8;                                             /* Reserved Bits    */
} __type257;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PDTH_PD:2;                                      /* PDTH_PD[1:0]     */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 PDTH_PC:2;                                      /* PDTH_PC[5:4]     */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 PDTH_PB:2;                                      /* PDTH_PB[9:8]     */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 PDTH_PA:2;                                      /* PDTH_PA[13:12]   */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 PDTH_FORMAT:2;                                  /* PDTH_FORMAT[17:16] */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 PDTH_SEL:2;                                     /* PDTH_SEL[21:20]  */
    uint32 :10;                                            /* Reserved Bits    */
} __type258;
typedef struct 
{                                                          /* Bit Access       */
    uint32 OUTCNT_POLB_EDGE:1;                             /* OUTCNT_POLB_EDGE */
    uint32 OUTCNT_POLA_EDGE:1;                             /* OUTCNT_POLA_EDGE */
    uint32 OUTCNT_CPV_EDGE:1;                              /* OUTCNT_CPV_EDGE  */
    uint32 OUTCNT_STB_EDGE:1;                              /* OUTCNT_STB_EDGE  */
    uint32 OUTCNT_STH_EDGE:1;                              /* OUTCNT_STH_EDGE  */
    uint32 OUTCNT_STVB_EDGE:1;                             /* OUTCNT_STVB_EDGE */
    uint32 OUTCNT_STVA_EDGE:1;                             /* OUTCNT_STVA_EDGE */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 OUTCNT_LCD_EDGE:1;                              /* OUTCNT_LCD_EDGE  */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 OUTCNT_FRONT_GAM:1;                             /* OUTCNT_FRONT_GAM */
    uint32 :19;                                            /* Reserved Bits    */
} __type259;
typedef struct 
{                                                          /* Bit Access       */
    uint32 INT_STA0:1;                                     /* INT_STA0         */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 INT_STA1:1;                                     /* INT_STA1         */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 INT_STA2:1;                                     /* INT_STA2         */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 INT_STA3:1;                                     /* INT_STA3         */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 INT_STA4:1;                                     /* INT_STA4         */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 INT_STA5:1;                                     /* INT_STA5         */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 INT_STA6:1;                                     /* INT_STA6         */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 INT_STA7:1;                                     /* INT_STA7         */
    uint32 :3;                                             /* Reserved Bits    */
} __type260;
typedef struct 
{                                                          /* Bit Access       */
    uint32 INT_STA8:1;                                     /* INT_STA8         */
    uint32 :11;                                            /* Reserved Bits    */
    uint32 INT_STA11:1;                                    /* INT_STA11        */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 INT_STA12:1;                                    /* INT_STA12        */
    uint32 :11;                                            /* Reserved Bits    */
    uint32 INT_STA15:1;                                    /* INT_STA15        */
    uint32 :3;                                             /* Reserved Bits    */
} __type261;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :4;                                             /* Reserved Bits    */
    uint32 INT_STA17:1;                                    /* INT_STA17        */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 INT_STA18:1;                                    /* INT_STA18        */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 INT_STA19:1;                                    /* INT_STA19        */
    uint32 :11;                                            /* Reserved Bits    */
    uint32 INT_STA22:1;                                    /* INT_STA22        */
    uint32 :7;                                             /* Reserved Bits    */
} __type262;
typedef struct 
{                                                          /* Bit Access       */
    uint32 INT_OUT0_ON:1;                                  /* INT_OUT0_ON      */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 INT_OUT1_ON:1;                                  /* INT_OUT1_ON      */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 INT_OUT2_ON:1;                                  /* INT_OUT2_ON      */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 INT_OUT3_ON:1;                                  /* INT_OUT3_ON      */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 INT_OUT4_ON:1;                                  /* INT_OUT4_ON      */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 INT_OUT5_ON:1;                                  /* INT_OUT5_ON      */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 INT_OUT6_ON:1;                                  /* INT_OUT6_ON      */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 INT_OUT7_ON:1;                                  /* INT_OUT7_ON      */
    uint32 :3;                                             /* Reserved Bits    */
} __type263;
typedef struct 
{                                                          /* Bit Access       */
    uint32 INT_OUT8_ON:1;                                  /* INT_OUT8_ON      */
    uint32 :11;                                            /* Reserved Bits    */
    uint32 INT_OUT11_ON:1;                                 /* INT_OUT11_ON     */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 INT_OUT12_ON:1;                                 /* INT_OUT12_ON     */
    uint32 :11;                                            /* Reserved Bits    */
    uint32 INT_OUT15_ON:1;                                 /* INT_OUT15_ON     */
    uint32 :3;                                             /* Reserved Bits    */
} __type264;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :4;                                             /* Reserved Bits    */
    uint32 INT_OUT17_ON:1;                                 /* INT_OUT17_ON     */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 INT_OUT18_ON:1;                                 /* INT_OUT18_ON     */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 INT_OUT19_ON:1;                                 /* INT_OUT19_ON     */
    uint32 :11;                                            /* Reserved Bits    */
    uint32 INT_OUT22_ON:1;                                 /* INT_OUT22_ON     */
    uint32 :7;                                             /* Reserved Bits    */
} __type265;
typedef struct 
{                                                          /* Bit Access       */
    uint16 GR0_CLT_SEL_ST:1;                               /* GR0_CLT_SEL_ST   */
    uint16 :3;                                             /* Reserved Bits    */
    uint16 GR1_CLT_SEL_ST:1;                               /* GR1_CLT_SEL_ST   */
    uint16 :3;                                             /* Reserved Bits    */
    uint16 GR2_CLT_SEL_ST:1;                               /* GR2_CLT_SEL_ST   */
    uint16 :3;                                             /* Reserved Bits    */
    uint16 GR3_CLT_SEL_ST:1;                               /* GR3_CLT_SEL_ST   */
    uint16 :3;                                             /* Reserved Bits    */
} __type266;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 DE_VLAST_EN:1;                                  /* DE_VLAST_EN      */
    uint32 DE_HSBYPS_EN:1;                                 /* DE_HSBYPS_EN     */
    uint32 DE_4HS_EN:1;                                    /* DE_4HS_EN        */
    uint32 :27;                                            /* Reserved Bits    */
} __type267;
typedef struct 
{                                                          /* Bit Access       */
    uint32 DE_VLAST:11;                                    /* DE_VLAST[10:0]   */
    uint32 :21;                                            /* Reserved Bits    */
} __type268;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC1_SCL0_VEN_A:1;                               /* SC1_SCL0_VEN_A   */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 SC1_SCL0_VEN_B:1;                               /* SC1_SCL0_VEN_B   */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 SC1_SCL0_UPDATE:1;                              /* SC1_SCL0_UPDATE  */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 SC1_SCL0_VEN_C:1;                               /* SC1_SCL0_VEN_C   */
    uint32 SC1_SCL0_VEN_D:1;                               /* SC1_SCL0_VEN_D   */
    uint32 :18;                                            /* Reserved Bits    */
} __type269;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC1_RES_VMASK_ON:1;                             /* SC1_RES_VMASK_ON */
    uint32 :15;                                            /* Reserved Bits    */
    uint32 SC1_RES_VMASK:16;                               /* SC1_RES_VMASK[31:16] */
} __type270;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC1_RES_VLACK_ON:1;                             /* SC1_RES_VLACK_ON */
    uint32 :15;                                            /* Reserved Bits    */
    uint32 SC1_RES_VLACK:16;                               /* SC1_RES_VLACK[31:16] */
} __type271;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC1_RES_VS_SEL:1;                               /* SC1_RES_VS_SEL   */
    uint32 :7;                                             /* Reserved Bits    */
    uint32 SC1_RES_VS_IN_SEL:1;                            /* SC1_RES_VS_IN_SEL */
    uint32 :23;                                            /* Reserved Bits    */
} __type272;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC1_RES_FH:11;                                  /* SC1_RES_FH[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 SC1_RES_FV:11;                                  /* SC1_RES_FV[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type273;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC1_RES_VSDLY:8;                                /* SC1_RES_VSDLY[7:0] */
    uint32 SC1_RES_FLD_DLY_SEL:1;                          /* SC1_RES_FLD_DLY_SEL */
    uint32 :23;                                            /* Reserved Bits    */
} __type274;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC1_RES_F_VW:11;                                /* SC1_RES_F_VW[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 SC1_RES_F_VS:11;                                /* SC1_RES_F_VS[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type275;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC1_RES_F_HW:11;                                /* SC1_RES_F_HW[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 SC1_RES_F_HS:11;                                /* SC1_RES_F_HS[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type276;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC1_RES_QVLACK:1;                               /* SC1_RES_QVLACK   */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 SC1_RES_QVLOCK:1;                               /* SC1_RES_QVLOCK   */
    uint32 :27;                                            /* Reserved Bits    */
} __type277;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC1_RES_DS_H_ON:1;                              /* SC1_RES_DS_H_ON  */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 SC1_RES_DS_V_ON:1;                              /* SC1_RES_DS_V_ON  */
    uint32 :27;                                            /* Reserved Bits    */
} __type278;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC1_RES_V_RATIO:16;                             /* SC1_RES_V_RATIO[15:0] */
    uint32 :16;                                            /* Reserved Bits    */
} __type279;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC1_RES_US_H_ON:1;                              /* SC1_RES_US_H_ON  */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 SC1_RES_US_V_ON:1;                              /* SC1_RES_US_V_ON  */
    uint32 :27;                                            /* Reserved Bits    */
} __type280;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC1_RES_P_VW:11;                                /* SC1_RES_P_VW[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 SC1_RES_P_VS:11;                                /* SC1_RES_P_VS[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type281;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC1_RES_P_HW:11;                                /* SC1_RES_P_HW[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 SC1_RES_P_HS:11;                                /* SC1_RES_P_HS[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type282;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC1_RES_IN_HW:11;                               /* SC1_RES_IN_HW[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 SC1_RES_IN_VW:11;                               /* SC1_RES_IN_VW[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type283;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC1_RES_US_H_RATIO:16;                          /* SC1_RES_US_H_RATIO[15:0] */
    uint32 :16;                                            /* Reserved Bits    */
} __type284;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC1_RES_US_HB_INIPHASE:12;                      /* SC1_RES_US_HB_INIPHASE[11:0] */
    uint32 :4;                                             /* Reserved Bits    */
    uint32 SC1_RES_US_HT_INIPHASE:12;                      /* SC1_RES_US_HT_INIPHASE[27:16] */
    uint32 SC1_RES_US_H_INTERPOTYP:1;                      /* SC1_RES_US_H_INTERPOTYP */
    uint32 :3;                                             /* Reserved Bits    */
} __type285;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC1_RES_VCUT:8;                                 /* SC1_RES_VCUT[7:0] */
    uint32 SC1_RES_HCUT:8;                                 /* SC1_RES_HCUT[15:8] */
    uint32 :16;                                            /* Reserved Bits    */
} __type286;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC1_RES_DISP_ON:1;                              /* SC1_RES_DISP_ON  */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 SC1_RES_IBUS_SYNC_SEL:1;                        /* SC1_RES_IBUS_SYNC_SEL */
    uint32 :27;                                            /* Reserved Bits    */
} __type287;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SC1_RES_BK_COL_B:8;                             /* SC1_RES_BK_COL_B[7:0] */
    uint32 SC1_RES_BK_COL_G:8;                             /* SC1_RES_BK_COL_G[15:8] */
    uint32 SC1_RES_BK_COL_R:8;                             /* SC1_RES_BK_COL_R[23:16] */
    uint32 :8;                                             /* Reserved Bits    */
} __type288;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR1_IBUS_VEN:1;                                 /* GR1_IBUS_VEN     */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 GR1_P_VEN:1;                                    /* GR1_P_VEN        */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 GR1_UPDATE:1;                                   /* GR1_UPDATE       */
    uint32 :23;                                            /* Reserved Bits    */
} __type289;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR1_R_ENB:1;                                    /* GR1_R_ENB        */
    uint32 :31;                                            /* Reserved Bits    */
} __type290;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :8;                                             /* Reserved Bits    */
    uint32 GR1_FLM_SEL:2;                                  /* GR1_FLM_SEL[9:8] */
    uint32 :6;                                             /* Reserved Bits    */
    uint32 GR1_LN_OFF_DIR:1;                               /* GR1_LN_OFF_DIR   */
    uint32 :14;                                            /* Reserved Bits    */
    uint32 GR1_FLD_SEL:1;                                  /* GR1_FLD_SEL      */
} __type291;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR1_BASE:32;                                    /* GR1_BASE[31:0]   */
} __type292;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR1_FLM_NUM:10;                                 /* GR1_FLM_NUM[9:0] */
    uint32 :6;                                             /* Reserved Bits    */
    uint32 GR1_LN_OFF:15;                                  /* GR1_LN_OFF[30:16] */
    uint32 GR1_FLD_NXT:1;                                  /* GR1_FLD_NXT      */
} __type293;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR1_FLM_OFF:23;                                 /* GR1_FLM_OFF[22:0] */
    uint32 :9;                                             /* Reserved Bits    */
} __type294;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR1_FLM_LOOP:11;                                /* GR1_FLM_LOOP[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GR1_FLM_LNUM:11;                                /* GR1_FLM_LNUM[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type295;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR1_STA_POS:6;                                  /* GR1_STA_POS[5:0] */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 GR1_CNV444_MD:1;                                /* GR1_CNV444_MD    */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 GR1_RDSWA:3;                                    /* GR1_RDSWA[12:10] */
    uint32 GR1_YCC_SWAP:3;                                 /* GR1_YCC_SWAP[15:13] */
    uint32 GR1_HW:11;                                      /* GR1_HW[26:16]    */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 GR1_FORMAT:4;                                   /* GR1_FORMAT[31:28] */
} __type296;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR1_DISP_SEL:2;                                 /* GR1_DISP_SEL[1:0] */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 GR1_GRC_DISP_ON:1;                              /* GR1_GRC_DISP_ON  */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 GR1_ARC_DISP_ON:1;                              /* GR1_ARC_DISP_ON  */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 GR1_ARC_ON:1;                                   /* GR1_ARC_ON       */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 GR1_ACALC_MD:1;                                 /* GR1_ACALC_MD     */
    uint32 GR1_ARC_MUL:1;                                  /* GR1_ARC_MUL      */
    uint32 :12;                                            /* Reserved Bits    */
    uint32 GR1_CUS_CON_ON:1;                               /* GR1_CUS_CON_ON   */
    uint32 :3;                                             /* Reserved Bits    */
} __type297;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR1_GRC_VW:11;                                  /* GR1_GRC_VW[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GR1_GRC_VS:11;                                  /* GR1_GRC_VS[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type298;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR1_GRC_HW:11;                                  /* GR1_GRC_HW[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GR1_GRC_HS:11;                                  /* GR1_GRC_HS[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type299;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR1_ARC_VW:11;                                  /* GR1_ARC_VW[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GR1_ARC_VS:11;                                  /* GR1_ARC_VS[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type300;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR1_ARC_HW:11;                                  /* GR1_ARC_HW[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GR1_ARC_HS:11;                                  /* GR1_ARC_HS[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type301;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR1_ARC_RATE:8;                                 /* GR1_ARC_RATE[7:0] */
    uint32 :8;                                             /* Reserved Bits    */
    uint32 GR1_ARC_COEF:8;                                 /* GR1_ARC_COEF[23:16] */
    uint32 GR1_ARC_MODE:1;                                 /* GR1_ARC_MODE     */
    uint32 :7;                                             /* Reserved Bits    */
} __type302;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR1_CK_ON:1;                                    /* GR1_CK_ON        */
    uint32 :15;                                            /* Reserved Bits    */
    uint32 GR1_ARC_DEF:8;                                  /* GR1_ARC_DEF[23:16] */
    uint32 :8;                                             /* Reserved Bits    */
} __type303;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR1_CK_KR:8;                                    /* GR1_CK_KR[7:0]   */
    uint32 GR1_CK_KB:8;                                    /* GR1_CK_KB[15:8]  */
    uint32 GR1_CK_KG:8;                                    /* GR1_CK_KG[23:16] */
    uint32 GR1_CK_KCLUT:8;                                 /* GR1_CK_KCLUT[31:24] */
} __type304;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR1_CK_R:8;                                     /* GR1_CK_R[7:0]    */
    uint32 GR1_CK_B:8;                                     /* GR1_CK_B[15:8]   */
    uint32 GR1_CK_G:8;                                     /* GR1_CK_G[23:16]  */
    uint32 GR1_CK_A:8;                                     /* GR1_CK_A[31:24]  */
} __type305;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR1_R0:8;                                       /* GR1_R0[7:0]      */
    uint32 GR1_B0:8;                                       /* GR1_B0[15:8]     */
    uint32 GR1_G0:8;                                       /* GR1_G0[23:16]    */
    uint32 GR1_A0:8;                                       /* GR1_A0[31:24]    */
} __type306;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR1_R1:8;                                       /* GR1_R1[7:0]      */
    uint32 GR1_B1:8;                                       /* GR1_B1[15:8]     */
    uint32 GR1_G1:8;                                       /* GR1_G1[23:16]    */
    uint32 GR1_A1:8;                                       /* GR1_A1[31:24]    */
} __type307;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR1_BASE_R:8;                                   /* GR1_BASE_R[7:0]  */
    uint32 GR1_BASE_B:8;                                   /* GR1_BASE_B[15:8] */
    uint32 GR1_BASE_G:8;                                   /* GR1_BASE_G[23:16] */
    uint32 :8;                                             /* Reserved Bits    */
} __type308;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :16;                                            /* Reserved Bits    */
    uint32 GR1_CLT_SEL:1;                                  /* GR1_CLT_SEL      */
    uint32 :15;                                            /* Reserved Bits    */
} __type309;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR1_ARC_ST:1;                                   /* GR1_ARC_ST       */
    uint32 :31;                                            /* Reserved Bits    */
} __type310;
typedef struct 
{                                                          /* Bit Access       */
    uint32 ADJ1_VEN:1;                                     /* ADJ1_VEN         */
    uint32 :31;                                            /* Reserved Bits    */
} __type311;
typedef struct 
{                                                          /* Bit Access       */
    uint32 ADJ1_MTX_MD:2;                                  /* ADJ1_MTX_MD[1:0] */
    uint32 :30;                                            /* Reserved Bits    */
} __type312;
typedef struct 
{                                                          /* Bit Access       */
    uint32 ADJ1_MTX_GG:11;                                 /* ADJ1_MTX_GG[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 ADJ1_MTX_YG:8;                                  /* ADJ1_MTX_YG[23:16] */
    uint32 :8;                                             /* Reserved Bits    */
} __type313;
typedef struct 
{                                                          /* Bit Access       */
    uint32 ADJ1_MTX_GR:11;                                 /* ADJ1_MTX_GR[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 ADJ1_MTX_GB:11;                                 /* ADJ1_MTX_GB[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type314;
typedef struct 
{                                                          /* Bit Access       */
    uint32 ADJ1_MTX_BG:11;                                 /* ADJ1_MTX_BG[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 ADJ1_MTX_B:8;                                   /* ADJ1_MTX_B[23:16] */
    uint32 :8;                                             /* Reserved Bits    */
} __type315;
typedef struct 
{                                                          /* Bit Access       */
    uint32 ADJ1_MTX_BR:11;                                 /* ADJ1_MTX_BR[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 ADJ1_MTX_BB:11;                                 /* ADJ1_MTX_BB[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type316;
typedef struct 
{                                                          /* Bit Access       */
    uint32 ADJ1_MTX_RG:11;                                 /* ADJ1_MTX_RG[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 ADJ1_MTX_R:8;                                   /* ADJ1_MTX_R[23:16] */
    uint32 :8;                                             /* Reserved Bits    */
} __type317;
typedef struct 
{                                                          /* Bit Access       */
    uint32 ADJ1_MTX_RR:11;                                 /* ADJ1_MTX_RR[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 ADJ1_MTX_RB:11;                                 /* ADJ1_MTX_RB[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type318;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :4;                                             /* Reserved Bits    */
    uint32 GR_VIN_P_VEN:1;                                 /* GR_VIN_P_VEN     */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 GR_VIN_UPDATE:1;                                /* GR_VIN_UPDATE    */
    uint32 :23;                                            /* Reserved Bits    */
} __type319;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR_VIN_DISP_SEL:2;                              /* GR_VIN_DISP_SEL[1:0] */
    uint32 GR_VIN_SCL_UND_SEL:1;                           /* GR_VIN_SCL_UND_SEL */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 GR_VIN_GRC_DISP_ON:1;                           /* GR_VIN_GRC_DISP_ON */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 GR_VIN_ARC_DISP_ON:1;                           /* GR_VIN_ARC_DISP_ON */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 GR_VIN_ARC_ON:1;                                /* GR_VIN_ARC_ON    */
    uint32 :19;                                            /* Reserved Bits    */
} __type320;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR_VIN_GRC_VW:11;                               /* GR_VIN_GRC_VW[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GR_VIN_GRC_VS:11;                               /* GR_VIN_GRC_VS[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type321;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR_VIN_GRC_HW:11;                               /* GR_VIN_GRC_HW[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GR_VIN_GRC_HS:11;                               /* GR_VIN_GRC_HS[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type322;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR_VIN_ARC_VW:11;                               /* GR_VIN_ARC_VW[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GR_VIN_ARC_VS:11;                               /* GR_VIN_ARC_VS[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type323;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR_VIN_ARC_HW:11;                               /* GR_VIN_ARC_HW[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GR_VIN_ARC_HS:11;                               /* GR_VIN_ARC_HS[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type324;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR_VIN_ARC_RATE:8;                              /* GR_VIN_ARC_RATE[7:0] */
    uint32 :8;                                             /* Reserved Bits    */
    uint32 GR_VIN_ARC_COEF:8;                              /* GR_VIN_ARC_COEF[23:16] */
    uint32 GR_VIN_ARC_MODE:1;                              /* GR_VIN_ARC_MODE  */
    uint32 :7;                                             /* Reserved Bits    */
} __type325;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :16;                                            /* Reserved Bits    */
    uint32 GR_VIN_ARC_DEF:8;                               /* GR_VIN_ARC_DEF[23:16] */
    uint32 :8;                                             /* Reserved Bits    */
} __type326;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR_VIN_BASE_R:8;                                /* GR_VIN_BASE_R[7:0] */
    uint32 GR_VIN_BASE_B:8;                                /* GR_VIN_BASE_B[15:8] */
    uint32 GR_VIN_BASE_G:8;                                /* GR_VIN_BASE_G[23:16] */
    uint32 :8;                                             /* Reserved Bits    */
} __type327;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR_VIN_ARC_ST:1;                                /* GR_VIN_ARC_ST    */
    uint32 :31;                                            /* Reserved Bits    */
} __type328;
typedef struct 
{                                                          /* Bit Access       */
    uint32 OIR_SCL0_VEN_A:1;                               /* OIR_SCL0_VEN_A   */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 OIR_SCL0_VEN_B:1;                               /* OIR_SCL0_VEN_B   */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 OIR_SCL0_UPDATE:1;                              /* OIR_SCL0_UPDATE  */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 OIR_SCL0_VEN_C:1;                               /* OIR_SCL0_VEN_C   */
    uint32 OIR_SCL0_VEN_D:1;                               /* OIR_SCL0_VEN_D   */
    uint32 :18;                                            /* Reserved Bits    */
} __type329;
typedef struct 
{                                                          /* Bit Access       */
    uint32 OIR_RES_VMASK_ON:1;                             /* OIR_RES_VMASK_ON */
    uint32 :15;                                            /* Reserved Bits    */
    uint32 OIR_RES_VMASK:16;                               /* OIR_RES_VMASK[31:16] */
} __type330;
typedef struct 
{                                                          /* Bit Access       */
    uint32 OIR_RES_VLACK_ON:1;                             /* OIR_RES_VLACK_ON */
    uint32 :15;                                            /* Reserved Bits    */
    uint32 OIR_RES_VLACK:16;                               /* OIR_RES_VLACK[31:16] */
} __type331;
typedef struct 
{                                                          /* Bit Access       */
    uint32 OIR_RES_VS_SEL:1;                               /* OIR_RES_VS_SEL   */
    uint32 :15;                                            /* Reserved Bits    */
    uint32 OIR_RES_EN:1;                                   /* OIR_RES_EN       */
    uint32 :15;                                            /* Reserved Bits    */
} __type332;
typedef struct 
{                                                          /* Bit Access       */
    uint32 OIR_RES_FH:11;                                  /* OIR_RES_FH[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 OIR_RES_FV:11;                                  /* OIR_RES_FV[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type333;
typedef struct 
{                                                          /* Bit Access       */
    uint32 OIR_RES_VSDLY:8;                                /* OIR_RES_VSDLY[7:0] */
    uint32 :24;                                            /* Reserved Bits    */
} __type334;
typedef struct 
{                                                          /* Bit Access       */
    uint32 OIR_RES_F_VW:11;                                /* OIR_RES_F_VW[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 OIR_RES_F_VS:11;                                /* OIR_RES_F_VS[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type335;
typedef struct 
{                                                          /* Bit Access       */
    uint32 OIR_RES_F_HW:11;                                /* OIR_RES_F_HW[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 OIR_RES_F_HS:11;                                /* OIR_RES_F_HS[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type336;
typedef struct 
{                                                          /* Bit Access       */
    uint32 OIR_RES_VW:11;                                  /* OIR_RES_VW[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 OIR_RES_VS:11;                                  /* OIR_RES_VS[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type337;
typedef struct 
{                                                          /* Bit Access       */
    uint32 OIR_RES_HW:11;                                  /* OIR_RES_HW[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 OIR_RES_HS:11;                                  /* OIR_RES_HS[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type338;
typedef struct 
{                                                          /* Bit Access       */
    uint32 OIR_RES_OUT_HW:11;                              /* OIR_RES_OUT_HW[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 OIR_RES_OUT_VW:11;                              /* OIR_RES_OUT_VW[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type339;
typedef struct 
{                                                          /* Bit Access       */
    uint32 OIR_RES_P_VW:11;                                /* OIR_RES_P_VW[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 OIR_RES_P_VS:11;                                /* OIR_RES_P_VS[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type340;
typedef struct 
{                                                          /* Bit Access       */
    uint32 OIR_RES_P_HW:11;                                /* OIR_RES_P_HW[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 OIR_RES_P_HS:11;                                /* OIR_RES_P_HS[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type341;
typedef struct 
{                                                          /* Bit Access       */
    uint32 OIR_SCL1_VEN_A:1;                               /* OIR_SCL1_VEN_A   */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 OIR_SCL1_VEN_B:1;                               /* OIR_SCL1_VEN_B   */
    uint32 :11;                                            /* Reserved Bits    */
    uint32 OIR_SCL1_UPDATE_A:1;                            /* OIR_SCL1_UPDATE_A */
    uint32 :15;                                            /* Reserved Bits    */
} __type342;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR_OIR_IBUS_VEN:1;                              /* GR_OIR_IBUS_VEN  */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 GR_OIR_P_VEN:1;                                 /* GR_OIR_P_VEN     */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 GR_OIR_UPDATE:1;                                /* GR_OIR_UPDATE    */
    uint32 :23;                                            /* Reserved Bits    */
} __type343;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR_OIR_R_ENB:1;                                 /* GR_OIR_R_ENB     */
    uint32 :31;                                            /* Reserved Bits    */
} __type344;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR_OIR_BASE:32;                                 /* GR_OIR_BASE[31:0] */
} __type345;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :16;                                            /* Reserved Bits    */
    uint32 GR_OIR_LN_OFF:15;                               /* GR_OIR_LN_OFF[30:16] */
    uint32 :1;                                             /* Reserved Bits    */
} __type346;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR_OIR_FLM_OFF:23;                              /* GR_OIR_FLM_OFF[22:0] */
    uint32 :9;                                             /* Reserved Bits    */
} __type347;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR_OIR_FLM_LOOP:11;                             /* GR_OIR_FLM_LOOP[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GR_OIR_FLM_LNUM:11;                             /* GR_OIR_FLM_LNUM[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type348;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR_OIR_STA_POS:6;                               /* GR_OIR_STA_POS[5:0] */
    uint32 :4;                                             /* Reserved Bits    */
    uint32 GR_OIR_RDSWA:3;                                 /* GR_OIR_RDSWA[12:10] */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 GR_OIR_HW:11;                                   /* GR_OIR_HW[26:16] */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 GR_OIR_FORMAT:4;                                /* GR_OIR_FORMAT[31:28] */
} __type349;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR_OIR_DISP_SEL:2;                              /* GR_OIR_DISP_SEL[1:0] */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 GR_OIR_GRC_DISP_ON:1;                           /* GR_OIR_GRC_DISP_ON */
    uint32 :27;                                            /* Reserved Bits    */
} __type350;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR_OIR_GRC_VW:11;                               /* GR_OIR_GRC_VW[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GR_OIR_GRC_VS:11;                               /* GR_OIR_GRC_VS[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type351;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR_OIR_GRC_HW:11;                               /* GR_OIR_GRC_HW[10:0] */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 GR_OIR_GRC_HS:11;                               /* GR_OIR_GRC_HS[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type352;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR_OIR_CK_ON:1;                                 /* GR_OIR_CK_ON     */
    uint32 :31;                                            /* Reserved Bits    */
} __type353;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR_OIR_CK_KR:8;                                 /* GR_OIR_CK_KR[7:0] */
    uint32 GR_OIR_CK_KB:8;                                 /* GR_OIR_CK_KB[15:8] */
    uint32 GR_OIR_CK_KG:8;                                 /* GR_OIR_CK_KG[23:16] */
    uint32 :8;                                             /* Reserved Bits    */
} __type354;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR_OIR_CK_R:8;                                  /* GR_OIR_CK_R[7:0] */
    uint32 GR_OIR_CK_B:8;                                  /* GR_OIR_CK_B[15:8] */
    uint32 GR_OIR_CK_G:8;                                  /* GR_OIR_CK_G[23:16] */
    uint32 GR_OIR_CK_A:8;                                  /* GR_OIR_CK_A[31:24] */
} __type355;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR_OIR_BASE_R:8;                                /* GR_OIR_BASE_R[7:0] */
    uint32 GR_OIR_BASE_B:8;                                /* GR_OIR_BASE_B[15:8] */
    uint32 GR_OIR_BASE_G:8;                                /* GR_OIR_BASE_G[23:16] */
    uint32 :8;                                             /* Reserved Bits    */
} __type356;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GR_OIR_LINE:11;                                 /* GR_OIR_LINE[10:0] */
    uint32 :21;                                            /* Reserved Bits    */
} __type357;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :16;                                            /* Reserved Bits    */
    uint32 OIR_LIN_STAT:11;                                /* OIR_LIN_STAT[26:16] */
    uint32 :5;                                             /* Reserved Bits    */
} __type358;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CMPR:1;                                         /* CMPR             */
    uint32 :15;                                            /* Reserved Bits    */
    uint32 CMPRU:1;                                        /* CMPRU            */
    uint32 :15;                                            /* Reserved Bits    */
} __type359;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CMPST:1;                                        /* CMPST            */
    uint32 :31;                                            /* Reserved Bits    */
} __type360;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CMPCLST:1;                                      /* CMPCLST          */
    uint32 :31;                                            /* Reserved Bits    */
} __type361;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CMPIEN:1;                                       /* CMPIEN           */
    uint32 :31;                                            /* Reserved Bits    */
} __type362;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CMPSELP:4;                                      /* CMPSELP[3:0]     */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 CMPDAUF:1;                                      /* CMPDAUF          */
    uint32 CMPDFA:8;                                       /* CMPDFA[15:8]     */
    uint32 CMPBT:1;                                        /* CMPBT            */
    uint32 :15;                                            /* Reserved Bits    */
} __type363;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CMPECRC:32;                                     /* CMPECRC[31:0]    */
} __type364;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CMPCCRC:32;                                     /* CMPCCRC[31:0]    */
} __type365;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CMPSPX:11;                                      /* CMPSPX[10:0]     */
    uint32 :21;                                            /* Reserved Bits    */
} __type366;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CMPSPY:11;                                      /* CMPSPY[10:0]     */
    uint32 :21;                                            /* Reserved Bits    */
} __type367;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CMPSZX:11;                                      /* CMPSZX[10:0]     */
    uint32 :21;                                            /* Reserved Bits    */
} __type368;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CMPSZY:11;                                      /* CMPSZY[10:0]     */
    uint32 :21;                                            /* Reserved Bits    */
} __type369;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CRCINI:32;                                      /* CRCINI[31:0]     */
} __type370;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PRLEN:1;                                        /* PRLEN            */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PRLID0:4;                                       /* PRLID0[7:4]      */
    uint32 PRLID1:4;                                       /* PRLID1[11:8]     */
    uint32 PRLID2:4;                                       /* PRLID2[15:12]    */
    uint32 PRLISS:2;                                       /* PRLISS[17:16]    */
    uint32 :6;                                             /* Reserved Bits    */
    uint32 PRLTO:4;                                        /* PRLTO[27:24]     */
    uint32 :4;                                             /* Reserved Bits    */
} __type371;
typedef struct 
{                                                          /* Bit Access       */
    uint8  REDU:3;                                         /* REDU[2:0]        */
    uint8  DSP:1;                                          /* DSP              */
    uint8  :4;                                             /* Reserved Bits    */
} __type372;
typedef struct 
{                                                          /* Bit Access       */
    uint8  JSRT:1;                                         /* JSRT             */
    uint8  JRST:1;                                         /* JRST             */
    uint8  JEND:1;                                         /* JEND             */
    uint8  :5;                                             /* Reserved Bits    */
} __type373;
typedef struct 
{                                                          /* Bit Access       */
    uint8  QT1:2;                                          /* QT1[1:0]         */
    uint8  QT2:2;                                          /* QT2[3:2]         */
    uint8  QT3:2;                                          /* QT3[5:4]         */
    uint8  :2;                                             /* Reserved Bits    */
} __type374;
typedef struct 
{                                                          /* Bit Access       */
    uint8  HTD1:1;                                         /* HTD1             */
    uint8  HTA1:1;                                         /* HTA1             */
    uint8  HTD2:1;                                         /* HTD2             */
    uint8  HTA2:1;                                         /* HTA2             */
    uint8  HTD3:1;                                         /* HTD3             */
    uint8  HTA3:1;                                         /* HTA3             */
    uint8  :2;                                             /* Reserved Bits    */
} __type375;
typedef struct 
{                                                          /* Bit Access       */
    uint8  DRIU:8;                                         /* DRIU[7:0]        */
} __type376;
typedef struct 
{                                                          /* Bit Access       */
    uint8  DRID:8;                                         /* DRID[7:0]        */
} __type377;
typedef struct 
{                                                          /* Bit Access       */
    uint8  VSZU:8;                                         /* VSZU[7:0]        */
} __type378;
typedef struct 
{                                                          /* Bit Access       */
    uint8  VSZD:8;                                         /* VSZD[7:0]        */
} __type379;
typedef struct 
{                                                          /* Bit Access       */
    uint8  HSZU:8;                                         /* HSZU[7:0]        */
} __type380;
typedef struct 
{                                                          /* Bit Access       */
    uint8  HSZD:8;                                         /* HSZD[7:0]        */
} __type381;
typedef struct 
{                                                          /* Bit Access       */
    uint8  DCU:8;                                          /* DCU[7:0]         */
} __type382;
typedef struct 
{                                                          /* Bit Access       */
    uint8  DCM:8;                                          /* DCM[7:0]         */
} __type383;
typedef struct 
{                                                          /* Bit Access       */
    uint8  DCD:8;                                          /* DCD[7:0]         */
} __type384;
typedef struct 
{                                                          /* Bit Access       */
    uint8  :3;                                             /* Reserved Bits    */
    uint8  INT3:1;                                         /* INT3             */
    uint8  :1;                                             /* Reserved Bits    */
    uint8  INT5:1;                                         /* INT5             */
    uint8  INT6:1;                                         /* INT6             */
    uint8  INT7:1;                                         /* INT7             */
} __type385;
typedef struct 
{                                                          /* Bit Access       */
    uint8  :3;                                             /* Reserved Bits    */
    uint8  INS3:1;                                         /* INS3             */
    uint8  :1;                                             /* Reserved Bits    */
    uint8  INS5:1;                                         /* INS5             */
    uint8  INS6:1;                                         /* INS6             */
    uint8  :1;                                             /* Reserved Bits    */
} __type386;
typedef struct 
{                                                          /* Bit Access       */
    uint8  ERR:4;                                          /* ERR[3:0]         */
    uint8  :4;                                             /* Reserved Bits    */
} __type387;
typedef struct 
{                                                          /* Bit Access       */
    uint8  RST:1;                                          /* RST              */
    uint8  :7;                                             /* Reserved Bits    */
} __type388;
typedef struct 
{                                                          /* Bit Access       */
    uint32 DINSWAP:3;                                      /* DINSWAP[2:0]     */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 DINLC:1;                                        /* DINLC            */
    uint32 DINRCMD:1;                                      /* DINRCMD          */
    uint32 DINRINI:1;                                      /* DINRINI          */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 JOUTSWAP:3;                                     /* JOUTSWAP[10:8]   */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 JOUTC:1;                                        /* JOUTC            */
    uint32 JOUTRCMD:1;                                     /* JOUTRCMD         */
    uint32 JOUTRINI:1;                                     /* JOUTRINI         */
    uint32 :17;                                            /* Reserved Bits    */
} __type389;
typedef struct 
{                                                          /* Bit Access       */
    uint32 ESA:32;                                         /* ESA[31:0]        */
} __type390;
typedef struct 
{                                                          /* Bit Access       */
    uint32 ESMW:15;                                        /* ESMW[14:0]       */
    uint32 :17;                                            /* Reserved Bits    */
} __type391;
typedef struct 
{                                                          /* Bit Access       */
    uint32 EDA:32;                                         /* EDA[31:0]        */
} __type392;
typedef struct 
{                                                          /* Bit Access       */
    uint32 LINES:16;                                       /* LINES[15:0]      */
    uint32 :16;                                            /* Reserved Bits    */
} __type393;
typedef struct 
{                                                          /* Bit Access       */
    uint32 JDATAS:16;                                      /* JDATAS[15:0]     */
    uint32 :16;                                            /* Reserved Bits    */
} __type394;
typedef struct 
{                                                          /* Bit Access       */
    uint32 DOUTSWAP:3;                                     /* DOUTSWAP[2:0]    */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 DOUTLC:1;                                       /* DOUTLC           */
    uint32 DOUTRCMD:1;                                     /* DOUTRCMD         */
    uint32 DOUTRINI:1;                                     /* DOUTRINI         */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 JINSWAP:3;                                      /* JINSWAP[10:8]    */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 JINC:1;                                         /* JINC             */
    uint32 JINRCMD:1;                                      /* JINRCMD          */
    uint32 JINRINI:1;                                      /* JINRINI          */
    uint32 :9;                                             /* Reserved Bits    */
    uint32 OPF:2;                                          /* OPF[25:24]       */
    uint32 HINTER:2;                                       /* HINTER[27:26]    */
    uint32 VINTER:2;                                       /* VINTER[29:28]    */
    uint32 :2;                                             /* Reserved Bits    */
} __type395;
typedef struct 
{                                                          /* Bit Access       */
    uint32 DSA:32;                                         /* DSA[31:0]        */
} __type396;
typedef struct 
{                                                          /* Bit Access       */
    uint32 DDMW:15;                                        /* DDMW[14:0]       */
    uint32 :17;                                            /* Reserved Bits    */
} __type397;
typedef struct 
{                                                          /* Bit Access       */
    uint32 DDA:32;                                         /* DDA[31:0]        */
} __type398;
typedef struct 
{                                                          /* Bit Access       */
    uint32 ALPHA:8;                                        /* ALPHA[7:0]       */
    uint32 :24;                                            /* Reserved Bits    */
} __type399;
typedef struct 
{                                                          /* Bit Access       */
    uint32 DOUTLEN:1;                                      /* DOUTLEN          */
    uint32 JINEN:1;                                        /* JINEN            */
    uint32 DBTEN:1;                                        /* DBTEN            */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 JOUTEN:1;                                       /* JOUTEN           */
    uint32 DINLEN:1;                                       /* DINLEN           */
    uint32 CBTEN:1;                                        /* CBTEN            */
    uint32 :25;                                            /* Reserved Bits    */
} __type400;
typedef struct 
{                                                          /* Bit Access       */
    uint32 DOUTLF:1;                                       /* DOUTLF           */
    uint32 JINF:1;                                         /* JINF             */
    uint32 DBTF:1;                                         /* DBTF             */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 JOUTF:1;                                        /* JOUTF            */
    uint32 DINLF:1;                                        /* DINLF            */
    uint32 CBTF:1;                                         /* CBTF             */
    uint32 :25;                                            /* Reserved Bits    */
} __type401;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :15;                                            /* Reserved Bits    */
    uint32 DINYCHG:1;                                      /* DINYCHG          */
    uint32 :16;                                            /* Reserved Bits    */
} __type402;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :15;                                            /* Reserved Bits    */
    uint32 DOUTYCHG:1;                                     /* DOUTYCHG         */
    uint32 :16;                                            /* Reserved Bits    */
} __type403;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 ERR_SNT:1;                                      /* ERR_SNT          */
    uint32 BAD_ADDR:1;                                     /* BAD_ADDR         */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 BAD_OPC:1;                                      /* BAD_OPC          */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 INACTIVE:1;                                     /* INACTIVE         */
    uint32 SRFPDN:1;                                       /* SRFPDN           */
    uint32 :22;                                            /* Reserved Bits    */
} __type404;
typedef struct 
{                                                          /* Bit Access       */
    uint32 DDCG:3;                                         /* DDCG[2:0]        */
    uint32 :29;                                            /* Reserved Bits    */
} __type405;
typedef struct 
{                                                          /* Bit Access       */
    uint32 ACEN:1;                                         /* ACEN             */
    uint32 :31;                                            /* Reserved Bits    */
} __type406;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CMD:3;                                          /* CMD[2:0]         */
    uint32 :29;                                            /* Reserved Bits    */
} __type407;
typedef struct 
{                                                          /* Bit Access       */
    uint32 BWIDTH:2;                                       /* BWIDTH[1:0]      */
    uint32 BKADB:6;                                        /* BKADB[7:2]       */
    uint32 BKADP:6;                                        /* BKADP[13:8]      */
    uint32 BKADM:2;                                        /* BKADM[15:14]     */
    uint32 SPLIT:9;                                        /* SPLIT[24:16]     */
    uint32 :7;                                             /* Reserved Bits    */
} __type408;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 TRCDC:2;                                        /* TRCDC[3:2]       */
    uint32 :28;                                            /* Reserved Bits    */
} __type409;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TRCD:3;                                         /* TRCD[2:0]        */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 TRFC:7;                                         /* TRFC[14:8]       */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 TRAS:5;                                         /* TRAS[20:16]      */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 CL:3;                                           /* CL[26:24]        */
    uint32 :5;                                             /* Reserved Bits    */
} __type410;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TWR:3;                                          /* TWR[2:0]         */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 TRRD:3;                                         /* TRRD[10:8]       */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 TRP:3;                                          /* TRP[18:16]       */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 CKEH:3;                                         /* CKEH[26:24]      */
    uint32 :5;                                             /* Reserved Bits    */
} __type411;
typedef struct 
{                                                          /* Bit Access       */
    uint32 WRRD:4;                                         /* WRRD[3:0]        */
    uint32 :4;                                             /* Reserved Bits    */
    uint32 RDWR:4;                                         /* RDWR[11:8]       */
    uint32 :4;                                             /* Reserved Bits    */
    uint32 TRC:5;                                          /* TRC[20:16]       */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 TRTP:2;                                         /* TRTP[25:24]      */
    uint32 :6;                                             /* Reserved Bits    */
} __type412;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SRFEN:1;                                        /* SRFEN            */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PDN:1;                                          /* PDN              */
    uint32 :13;                                            /* Reserved Bits    */
    uint32 ARFEN:1;                                        /* ARFEN            */
    uint32 :15;                                            /* Reserved Bits    */
} __type413;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TREFI:13;                                       /* TREFI[12:0]      */
    uint32 :19;                                            /* Reserved Bits    */
} __type414;
typedef struct 
{                                                          /* Bit Access       */
    uint32 LV0TH:10;                                       /* LV0TH[9:0]       */
    uint32 :6;                                             /* Reserved Bits    */
    uint32 LV1TH:15;                                       /* LV1TH[30:16]     */
    uint32 :1;                                             /* Reserved Bits    */
} __type415;
typedef struct 
{                                                          /* Bit Access       */
    uint32 RFUDF:1;                                        /* RFUDF            */
    uint32 :31;                                            /* Reserved Bits    */
} __type416;
typedef struct 
{                                                          /* Bit Access       */
    uint32 MA:13;                                          /* MA[12:0]         */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 BA:2;                                           /* BA[17:16]        */
    uint32 :14;                                            /* Reserved Bits    */
} __type417;
typedef struct 
{                                                          /* Bit Access       */
    uint32 STBYN:1;                                        /* STBYN            */
    uint32 :23;                                            /* Reserved Bits    */
    uint32 ENOFFSET:4;                                     /* ENOFFSET[27:24]  */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 OFFSET:3;                                       /* OFFSET[31:29]    */
} __type418;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 WTOVFL:7;                                       /* WTOVFL[7:1]      */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 RTOVFL:7;                                       /* RTOVFL[15:9]     */
    uint32 RCTL:2;                                         /* RCTL[17:16]      */
    uint32 :6;                                             /* Reserved Bits    */
    uint32 IDLTIM:8;                                       /* IDLTIM[31:24]    */
} __type419;
typedef struct 
{                                                          /* Bit Access       */
    uint32 ITVLTIM:8;                                      /* ITVLTIM[7:0]     */
    uint32 :24;                                            /* Reserved Bits    */
} __type420;
typedef struct 
{                                                          /* Bit Access       */
    uint32 BSZ:2;                                          /* BSZ[1:0]         */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 CPOL:1;                                         /* CPOL             */
    uint32 SSLP:1;                                         /* SSLP             */
    uint32 CPHAR:1;                                        /* CPHAR            */
    uint32 CPHAT:1;                                        /* CPHAT            */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 IO0FV:2;                                        /* IO0FV[9:8]       */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 IO2FV:2;                                        /* IO2FV[13:12]     */
    uint32 IO3FV:2;                                        /* IO3FV[15:14]     */
    uint32 MOIIO0:2;                                       /* MOIIO0[17:16]    */
    uint32 MOIIO1:2;                                       /* MOIIO1[19:18]    */
    uint32 MOIIO2:2;                                       /* MOIIO2[21:20]    */
    uint32 MOIIO3:2;                                       /* MOIIO3[23:22]    */
    uint32 SFDE:1;                                         /* SFDE             */
    uint32 :6;                                             /* Reserved Bits    */
    uint32 MD:1;                                           /* MD               */
} __type421;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SCKDL:3;                                        /* SCKDL[2:0]       */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 SLNDL:3;                                        /* SLNDL[10:8]      */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 SPNDL:3;                                        /* SPNDL[18:16]     */
    uint32 :13;                                            /* Reserved Bits    */
} __type422;
typedef struct 
{                                                          /* Bit Access       */
    uint32 BRDV:2;                                         /* BRDV[1:0]        */
    uint32 :6;                                             /* Reserved Bits    */
    uint32 SPBR:8;                                         /* SPBR[15:8]       */
    uint32 :16;                                            /* Reserved Bits    */
} __type423;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SSLE:1;                                         /* SSLE             */
    uint32 :7;                                             /* Reserved Bits    */
    uint32 RBE:1;                                          /* RBE              */
    uint32 RCF:1;                                          /* RCF              */
    uint32 :6;                                             /* Reserved Bits    */
    uint32 RBURST:4;                                       /* RBURST[19:16]    */
    uint32 :4;                                             /* Reserved Bits    */
    uint32 SSLN:1;                                         /* SSLN             */
    uint32 :4;                                             /* Reserved Bits    */
    uint32 BFM:3;                                          /* BFM[31:29]       */
} __type424;
typedef struct 
{                                                          /* Bit Access       */
    uint32 OCMD:8;                                         /* OCMD[7:0]        */
    uint32 :8;                                             /* Reserved Bits    */
    uint32 CMD:8;                                          /* CMD[23:16]       */
    uint32 :8;                                             /* Reserved Bits    */
} __type425;
typedef struct 
{                                                          /* Bit Access       */
    uint32 EAC:3;                                          /* EAC[2:0]         */
    uint32 :13;                                            /* Reserved Bits    */
    uint32 EAV:8;                                          /* EAV[23:16]       */
    uint32 :8;                                             /* Reserved Bits    */
} __type426;
typedef struct 
{                                                          /* Bit Access       */
    uint32 OPD0:8;                                         /* OPD0[7:0]        */
    uint32 OPD1:8;                                         /* OPD1[15:8]       */
    uint32 OPD2:8;                                         /* OPD2[23:16]      */
    uint32 OPD3:8;                                         /* OPD3[31:24]      */
} __type427;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :4;                                             /* Reserved Bits    */
    uint32 OPDE:4;                                         /* OPDE[7:4]        */
    uint32 ADE:4;                                          /* ADE[11:8]        */
    uint32 OCDE:1;                                         /* OCDE             */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 CDE:1;                                          /* CDE              */
    uint32 DME:1;                                          /* DME              */
    uint32 DRDB:2;                                         /* DRDB[17:16]      */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 OPDB:2;                                         /* OPDB[21:20]      */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 ADB:2;                                          /* ADB[25:24]       */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 OCDB:2;                                         /* OCDB[29:28]      */
    uint32 CDB:2;                                          /* CDB[31:30]       */
} __type428;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SPIE:1;                                         /* SPIE             */
    uint32 SPIWE:1;                                        /* SPIWE            */
    uint32 SPIRE:1;                                        /* SPIRE            */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 SSLKP:1;                                        /* SSLKP            */
    uint32 :23;                                            /* Reserved Bits    */
} __type429;
typedef struct 
{                                                          /* Bit Access       */
    uint32 ADR:32;                                         /* ADR[31:0]        */
} __type430;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SPIDE:4;                                        /* SPIDE[3:0]       */
    uint32 OPDE:4;                                         /* OPDE[7:4]        */
    uint32 ADE:4;                                          /* ADE[11:8]        */
    uint32 OCDE:1;                                         /* OCDE             */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 CDE:1;                                          /* CDE              */
    uint32 DME:1;                                          /* DME              */
    uint32 SPIDB:2;                                        /* SPIDB[17:16]     */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 OPDB:2;                                         /* OPDB[21:20]      */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 ADB:2;                                          /* ADB[25:24]       */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 OCDB:2;                                         /* OCDB[29:28]      */
    uint32 CDB:2;                                          /* CDB[31:30]       */
} __type431;
typedef struct 
{                                                          /* Bit Access       */
    uint32 RDATA0:32;                                      /* RDATA0[31:0]     */
} __type432;
typedef struct 
{                                                          /* Bit Access       */
    uint32 RDATA1:32;                                      /* RDATA1[31:0]     */
} __type433;
typedef struct 
{                                                          /* Bit Access       */
    uint32 WDATA0:32;                                      /* WDATA0[31:0]     */
} __type434;
typedef struct 
{                                                          /* Bit Access       */
    uint32 WDATA1:32;                                      /* WDATA1[31:0]     */
} __type435;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TEND:1;                                         /* TEND             */
    uint32 SSLF:1;                                         /* SSLF             */
    uint32 :30;                                            /* Reserved Bits    */
} __type436;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CKDLYRX:3;                                      /* CKDLYRX[2:0]     */
    uint32 :13;                                            /* Reserved Bits    */
    uint32 CKDLYOC:3;                                      /* CKDLYOC[18:16]   */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 PROT_CKDLY:8;                                   /* PROT_CKDLY[31:24] */
} __type437;
typedef struct 
{                                                          /* Bit Access       */
    uint32 DMCYC:3;                                        /* DMCYC[2:0]       */
    uint32 :13;                                            /* Reserved Bits    */
    uint32 DMDB:2;                                         /* DMDB[17:16]      */
    uint32 :14;                                            /* Reserved Bits    */
} __type438;
typedef struct 
{                                                          /* Bit Access       */
    uint32 DRDRE:1;                                        /* DRDRE            */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 OPDRE:1;                                        /* OPDRE            */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 ADDRE:1;                                        /* ADDRE            */
    uint32 :23;                                            /* Reserved Bits    */
} __type439;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SPIDRE:1;                                       /* SPIDRE           */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 OPDRE:1;                                        /* OPDRE            */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 ADDRE:1;                                        /* ADDRE            */
    uint32 :23;                                            /* Reserved Bits    */
} __type440;
typedef struct 
{                                                          /* Bit Access       */
    uint32 DLYO0:1;                                        /* DLYO0            */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 DLYOE0:1;                                       /* DLYOE0           */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 DLYO1:1;                                        /* DLYO1            */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 DLYOE1:1;                                       /* DLYOE1           */
    uint32 :11;                                            /* Reserved Bits    */
    uint32 PROT_SPODLY:8;                                  /* PROT_SPODLY[31:24] */
} __type441;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :31;                                            /* Reserved Bits    */
    uint32 MD:1;                                           /* MD               */
} __type442;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SSLE:1;                                         /* SSLE             */
    uint32 :4;                                             /* Reserved Bits    */
    uint32 BST:4;                                          /* BST[8:5]         */
    uint32 RCF:1;                                          /* RCF              */
    uint32 :14;                                            /* Reserved Bits    */
    uint32 SSLN:1;                                         /* SSLN             */
    uint32 :7;                                             /* Reserved Bits    */
} __type443;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :4;                                             /* Reserved Bits    */
    uint32 OPDE:4;                                         /* OPDE[7:4]        */
    uint32 :4;                                             /* Reserved Bits    */
    uint32 OCDE:1;                                         /* OCDE             */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 CDE:1;                                          /* CDE              */
    uint32 DME:1;                                          /* DME              */
    uint32 :16;                                            /* Reserved Bits    */
} __type444;
typedef struct 
{                                                          /* Bit Access       */
    uint32 RDATA0:32;                                      /* RDATA0[31:0]     */
} __type445;
typedef struct 
{                                                          /* Bit Access       */
    uint32 RDATA1:32;                                      /* RDATA1[31:0]     */
} __type446;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 DMCYC:4;                                        /* DMCYC[4:1]       */
    uint32 :27;                                            /* Reserved Bits    */
} __type447;
typedef struct 
{                                                          /* Bit Access       */
    uint32 DMCYC:5;                                        /* DMCYC[4:0]       */
    uint32 :27;                                            /* Reserved Bits    */
} __type448;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SPIDRE:1;                                       /* SPIDRE           */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 OPDRE:1;                                        /* OPDRE            */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 ADDRE:1;                                        /* ADDRE            */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 HYPE:3;                                         /* HYPE[14:12]      */
    uint32 :17;                                            /* Reserved Bits    */
} __type449;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PHYMEM:2;                                       /* PHYMEM[1:0]      */
    uint32 WBUF:1;                                         /* WBUF             */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 WBUF2:1;                                        /* WBUF2            */
    uint32 :26;                                            /* Reserved Bits    */
    uint32 CAL:1;                                          /* CAL              */
} __type450;
typedef struct 
{                                                          /* Bit Access       */
    uint32 DVC0:8;                                         /* DVC0[7:0]        */
    uint32 DVC1:8;                                         /* DVC1[15:8]       */
    uint32 DVC2:8;                                         /* DVC2[23:16]      */
    uint32 DVC3:8;                                         /* DVC3[31:24]      */
} __type451;
typedef struct 
{                                                          /* Bit Access       */
    uint32 DVA0:8;                                         /* DVA0[7:0]        */
    uint32 DVA1:8;                                         /* DVA1[15:8]       */
    uint32 DVA2:8;                                         /* DVA2[23:16]      */
    uint32 DVA3:8;                                         /* DVA3[31:24]      */
} __type452;
typedef struct 
{                                                          /* Bit Access       */
    uint32 DTL:8;                                          /* DTL[7:0]         */
    uint32 DML:8;                                          /* DML[15:8]        */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 ACD:1;                                          /* ACD              */
    uint32 CML:3;                                          /* CML[22:20]       */
    uint32 DTO:1;                                          /* DTO              */
    uint32 ADL:3;                                          /* ADL[26:24]       */
    uint32 DOPISB:1;                                       /* DOPISB           */
    uint32 ACMA:1;                                         /* ACMA             */
    uint32 PRBE:1;                                         /* PRBE             */
    uint32 :2;                                             /* Reserved Bits    */
} __type453;
typedef struct 
{                                                          /* Bit Access       */
    uint32 DV0S:30;                                        /* DV0S[29:0]       */
    uint32 DV0T:2;                                         /* DV0T[31:30]      */
} __type454;
typedef struct 
{                                                          /* Bit Access       */
    uint32 DV1S:30;                                        /* DV1S[29:0]       */
    uint32 DV1T:2;                                         /* DV1T[31:30]      */
} __type455;
typedef struct 
{                                                          /* Bit Access       */
    uint32 DV0D:8;                                         /* DV0D[7:0]        */
    uint32 DQER:4;                                         /* DQER[11:8]       */
    uint32 DQES:4;                                         /* DQES[15:12]      */
    uint32 DV1D:8;                                         /* DV1D[23:16]      */
    uint32 DQED:4;                                         /* DQED[27:24]      */
    uint32 :4;                                             /* Reserved Bits    */
} __type456;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TMPD:32;                                        /* TMPD[31:0]       */
} __type457;
typedef struct 
{                                                          /* Bit Access       */
    uint32 ADDR:32;                                        /* ADDR[31:0]       */
} __type458;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CRWC0:7;                                        /* CRWC0[6:0]       */
    uint32 CRWE0:1;                                        /* CRWE0            */
    uint32 DCSBC0:3;                                       /* DCSBC0[10:8]     */
    uint32 DCSHAC0:3;                                      /* DCSHAC0[13:11]   */
    uint32 DCSLFC0:2;                                      /* DCSLFC0[15:14]   */
    uint32 CRWC1:7;                                        /* CRWC1[22:16]     */
    uint32 CRWE1:1;                                        /* CRWE1            */
    uint32 DCSBC1:3;                                       /* DCSBC1[26:24]    */
    uint32 DCSHAC1:3;                                      /* DCSHAC1[29:27]   */
    uint32 DCSLFC1:2;                                      /* DCSLFC1[31:30]   */
} __type459;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :8;                                             /* Reserved Bits    */
    uint32 DCSBC0:3;                                       /* DCSBC0[10:8]     */
    uint32 DCSHAC0:3;                                      /* DCSHAC0[13:11]   */
    uint32 DCSLFC0:2;                                      /* DCSLFC0[15:14]   */
    uint32 :8;                                             /* Reserved Bits    */
    uint32 DCSBC1:3;                                       /* DCSBC1[26:24]    */
    uint32 DCSHAC1:3;                                      /* DCSHAC1[29:27]   */
    uint32 DCSLFC1:2;                                      /* DCSLFC1[31:30]   */
} __type460;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :8;                                             /* Reserved Bits    */
    uint32 DCSBC:3;                                        /* DCSBC[10:8]      */
    uint32 DCSHAC:3;                                       /* DCSHAC[13:11]    */
    uint32 DCSLFC:2;                                       /* DCSLFC[15:14]    */
    uint32 :16;                                            /* Reserved Bits    */
} __type461;
typedef struct 
{                                                          /* Bit Access       */
    uint32 D0TT:2;                                         /* D0TT[1:0]        */
    uint32 D1TT:2;                                         /* D1TT[3:2]        */
    uint32 D0PC:1;                                         /* D0PC             */
    uint32 D1PC:1;                                         /* D1PC             */
    uint32 :4;                                             /* Reserved Bits    */
    uint32 ACME:2;                                         /* ACME[11:10]      */
    uint32 ACMD:2;                                         /* ACMD[13:12]      */
    uint32 :17;                                            /* Reserved Bits    */
    uint32 DLFTE:1;                                        /* DLFTE            */
} __type462;
typedef struct 
{                                                          /* Bit Access       */
    uint32 D0RDL:8;                                        /* D0RDL[7:0]       */
    uint32 D0WDL:8;                                        /* D0WDL[15:8]      */
    uint32 D1RDL:8;                                        /* D1RDL[23:16]     */
    uint32 D1WDL:8;                                        /* D1WDL[31:24]     */
} __type463;
typedef struct 
{                                                          /* Bit Access       */
    uint32 MMRC0:8;                                        /* MMRC0[7:0]       */
    uint32 MMRC1:8;                                        /* MMRC1[15:8]      */
    uint32 MMWC0:8;                                        /* MMWC0[23:16]     */
    uint32 MMWC1:8;                                        /* MMWC1[31:24]     */
} __type464;
typedef struct 
{                                                          /* Bit Access       */
    uint32 MMRAL0:3;                                       /* MMRAL0[2:0]      */
    uint32 MMRCL0:3;                                       /* MMRCL0[5:3]      */
    uint32 RDO0:1;                                         /* RDO0             */
    uint32 PRBE0:1;                                        /* PRBE0            */
    uint32 MMWAL0:3;                                       /* MMWAL0[10:8]     */
    uint32 MMWCL0:3;                                       /* MMWCL0[13:11]    */
    uint32 WDO0:1;                                         /* WDO0             */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 MMRAL1:3;                                       /* MMRAL1[18:16]    */
    uint32 MMRCL1:3;                                       /* MMRCL1[21:19]    */
    uint32 RDO1:1;                                         /* RDO1             */
    uint32 PRBE1:1;                                        /* PRBE1            */
    uint32 MMWAL1:3;                                       /* MMWAL1[26:24]    */
    uint32 MMWCL1:3;                                       /* MMWCL1[29:27]    */
    uint32 WDO1:1;                                         /* WDO1             */
    uint32 :1;                                             /* Reserved Bits    */
} __type465;
typedef struct 
{                                                          /* Bit Access       */
    uint32 MRES:8;                                         /* MRES[7:0]        */
    uint32 MWES:8;                                         /* MWES[15:8]       */
    uint32 :16;                                            /* Reserved Bits    */
} __type466;
typedef struct 
{                                                          /* Bit Access       */
    uint32 DB0:8;                                          /* DB0[7:0]         */
    uint32 DB1:8;                                          /* DB1[15:8]        */
    uint32 DB2:8;                                          /* DB2[23:16]       */
    uint32 DB3:8;                                          /* DB3[31:24]       */
} __type467;
typedef struct 
{                                                          /* Bit Access       */
    uint32 ACSD0:3;                                        /* ACSD0[2:0]       */
    uint32 ACSD1:3;                                        /* ACSD1[5:3]       */
    uint32 :26;                                            /* Reserved Bits    */
} __type468;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CFRD0:16;                                       /* CFRD0[15:0]      */
    uint32 CCRD0:16;                                       /* CCRD0[31:16]     */
} __type469;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CFRD1:16;                                       /* CFRD1[15:0]      */
    uint32 CCRD1:16;                                       /* CCRD1[31:16]     */
} __type470;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPTCD0:8;                                       /* FPTCD0[7:0]      */
    uint32 LPTCD0:8;                                       /* LPTCD0[15:8]     */
    uint32 FPTCSD0:8;                                      /* FPTCSD0[23:16]   */
    uint32 LPTCSD0:8;                                      /* LPTCSD0[31:24]   */
} __type471;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPTCD1:8;                                       /* FPTCD1[7:0]      */
    uint32 LPTCD1:8;                                       /* LPTCD1[15:8]     */
    uint32 FPTCSD1:8;                                      /* FPTCSD1[23:16]   */
    uint32 LPTCSD1:8;                                      /* LPTCSD1[31:24]   */
} __type472;
typedef struct 
{                                                          /* Bit Access       */
    uint16 P1_0:1;                                         /* P1_0             */
    uint16 P1_1:1;                                         /* P1_1             */
    uint16 P1_2:1;                                         /* P1_2             */
    uint16 P1_3:1;                                         /* P1_3             */
    uint16 P1_4:1;                                         /* P1_4             */
    uint16 P1_5:1;                                         /* P1_5             */
    uint16 :10;                                            /* Reserved Bits    */
} __type473;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PSR1_0:1;                                       /* PSR1_0           */
    uint32 PSR1_1:1;                                       /* PSR1_1           */
    uint32 PSR1_2:1;                                       /* PSR1_2           */
    uint32 PSR1_3:1;                                       /* PSR1_3           */
    uint32 PSR1_4:1;                                       /* PSR1_4           */
    uint32 PSR1_5:1;                                       /* PSR1_5           */
    uint32 :10;                                            /* Reserved Bits    */
    uint32 PSR1_16:1;                                      /* PSR1_16          */
    uint32 PSR1_17:1;                                      /* PSR1_17          */
    uint32 PSR1_18:1;                                      /* PSR1_18          */
    uint32 PSR1_19:1;                                      /* PSR1_19          */
    uint32 PSR1_20:1;                                      /* PSR1_20          */
    uint32 PSR1_21:1;                                      /* PSR1_21          */
    uint32 :10;                                            /* Reserved Bits    */
} __type474;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PNOT1_0:1;                                      /* PNOT1_0          */
    uint16 PNOT1_1:1;                                      /* PNOT1_1          */
    uint16 PNOT1_2:1;                                      /* PNOT1_2          */
    uint16 PNOT1_3:1;                                      /* PNOT1_3          */
    uint16 PNOT1_4:1;                                      /* PNOT1_4          */
    uint16 PNOT1_5:1;                                      /* PNOT1_5          */
    uint16 :10;                                            /* Reserved Bits    */
} __type475;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PPR1_0:1;                                       /* PPR1_0           */
    uint16 PPR1_1:1;                                       /* PPR1_1           */
    uint16 PPR1_2:1;                                       /* PPR1_2           */
    uint16 PPR1_3:1;                                       /* PPR1_3           */
    uint16 PPR1_4:1;                                       /* PPR1_4           */
    uint16 PPR1_5:1;                                       /* PPR1_5           */
    uint16 :10;                                            /* Reserved Bits    */
} __type476;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PM1_0:1;                                        /* PM1_0            */
    uint16 PM1_1:1;                                        /* PM1_1            */
    uint16 PM1_2:1;                                        /* PM1_2            */
    uint16 PM1_3:1;                                        /* PM1_3            */
    uint16 PM1_4:1;                                        /* PM1_4            */
    uint16 PM1_5:1;                                        /* PM1_5            */
    uint16 :10;                                            /* Reserved Bits    */
} __type477;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PMC1_0:1;                                       /* PMC1_0           */
    uint16 PMC1_1:1;                                       /* PMC1_1           */
    uint16 PMC1_2:1;                                       /* PMC1_2           */
    uint16 PMC1_3:1;                                       /* PMC1_3           */
    uint16 PMC1_4:1;                                       /* PMC1_4           */
    uint16 PMC1_5:1;                                       /* PMC1_5           */
    uint16 :10;                                            /* Reserved Bits    */
} __type478;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PFC1_0:1;                                       /* PFC1_0           */
    uint16 PFC1_1:1;                                       /* PFC1_1           */
    uint16 PFC1_2:1;                                       /* PFC1_2           */
    uint16 PFC1_3:1;                                       /* PFC1_3           */
    uint16 PFC1_4:1;                                       /* PFC1_4           */
    uint16 PFC1_5:1;                                       /* PFC1_5           */
    uint16 :10;                                            /* Reserved Bits    */
} __type479;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PFCE1_0:1;                                      /* PFCE1_0          */
    uint16 PFCE1_1:1;                                      /* PFCE1_1          */
    uint16 PFCE1_2:1;                                      /* PFCE1_2          */
    uint16 PFCE1_3:1;                                      /* PFCE1_3          */
    uint16 PFCE1_4:1;                                      /* PFCE1_4          */
    uint16 PFCE1_5:1;                                      /* PFCE1_5          */
    uint16 :10;                                            /* Reserved Bits    */
} __type480;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PMSR1_0:1;                                      /* PMSR1_0          */
    uint32 PMSR1_1:1;                                      /* PMSR1_1          */
    uint32 PMSR1_2:1;                                      /* PMSR1_2          */
    uint32 PMSR1_3:1;                                      /* PMSR1_3          */
    uint32 PMSR1_4:1;                                      /* PMSR1_4          */
    uint32 PMSR1_5:1;                                      /* PMSR1_5          */
    uint32 :10;                                            /* Reserved Bits    */
    uint32 PMSR1_16:1;                                     /* PMSR1_16         */
    uint32 PMSR1_17:1;                                     /* PMSR1_17         */
    uint32 PMSR1_18:1;                                     /* PMSR1_18         */
    uint32 PMSR1_19:1;                                     /* PMSR1_19         */
    uint32 PMSR1_20:1;                                     /* PMSR1_20         */
    uint32 PMSR1_21:1;                                     /* PMSR1_21         */
    uint32 :10;                                            /* Reserved Bits    */
} __type481;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PMCSR1_0:1;                                     /* PMCSR1_0         */
    uint32 PMCSR1_1:1;                                     /* PMCSR1_1         */
    uint32 PMCSR1_2:1;                                     /* PMCSR1_2         */
    uint32 PMCSR1_3:1;                                     /* PMCSR1_3         */
    uint32 PMCSR1_4:1;                                     /* PMCSR1_4         */
    uint32 PMCSR1_5:1;                                     /* PMCSR1_5         */
    uint32 :10;                                            /* Reserved Bits    */
    uint32 PMCSR1_16:1;                                    /* PMCSR1_16        */
    uint32 PMCSR1_17:1;                                    /* PMCSR1_17        */
    uint32 PMCSR1_18:1;                                    /* PMCSR1_18        */
    uint32 PMCSR1_19:1;                                    /* PMCSR1_19        */
    uint32 PMCSR1_20:1;                                    /* PMCSR1_20        */
    uint32 PMCSR1_21:1;                                    /* PMCSR1_21        */
    uint32 :10;                                            /* Reserved Bits    */
} __type482;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PINV1_0:1;                                      /* PINV1_0          */
    uint16 PINV1_1:1;                                      /* PINV1_1          */
    uint16 PINV1_2:1;                                      /* PINV1_2          */
    uint16 PINV1_3:1;                                      /* PINV1_3          */
    uint16 PINV1_4:1;                                      /* PINV1_4          */
    uint16 PINV1_5:1;                                      /* PINV1_5          */
    uint16 :10;                                            /* Reserved Bits    */
} __type483;
typedef struct 
{                                                          /* Bit Access       */
    uint16 P3_0:1;                                         /* P3_0             */
    uint16 P3_1:1;                                         /* P3_1             */
    uint16 P3_2:1;                                         /* P3_2             */
    uint16 P3_3:1;                                         /* P3_3             */
    uint16 P3_4:1;                                         /* P3_4             */
    uint16 P3_5:1;                                         /* P3_5             */
    uint16 P3_6:1;                                         /* P3_6             */
    uint16 P3_7:1;                                         /* P3_7             */
    uint16 P3_8:1;                                         /* P3_8             */
    uint16 P3_9:1;                                         /* P3_9             */
    uint16 :6;                                             /* Reserved Bits    */
} __type484;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PSR3_0:1;                                       /* PSR3_0           */
    uint32 PSR3_1:1;                                       /* PSR3_1           */
    uint32 PSR3_2:1;                                       /* PSR3_2           */
    uint32 PSR3_3:1;                                       /* PSR3_3           */
    uint32 PSR3_4:1;                                       /* PSR3_4           */
    uint32 PSR3_5:1;                                       /* PSR3_5           */
    uint32 PSR3_6:1;                                       /* PSR3_6           */
    uint32 PSR3_7:1;                                       /* PSR3_7           */
    uint32 PSR3_8:1;                                       /* PSR3_8           */
    uint32 PSR3_9:1;                                       /* PSR3_9           */
    uint32 :6;                                             /* Reserved Bits    */
    uint32 PSR3_16:1;                                      /* PSR3_16          */
    uint32 PSR3_17:1;                                      /* PSR3_17          */
    uint32 PSR3_18:1;                                      /* PSR3_18          */
    uint32 PSR3_19:1;                                      /* PSR3_19          */
    uint32 PSR3_20:1;                                      /* PSR3_20          */
    uint32 PSR3_21:1;                                      /* PSR3_21          */
    uint32 PSR3_22:1;                                      /* PSR3_22          */
    uint32 PSR3_23:1;                                      /* PSR3_23          */
    uint32 PSR3_24:1;                                      /* PSR3_24          */
    uint32 PSR3_25:1;                                      /* PSR3_25          */
    uint32 :6;                                             /* Reserved Bits    */
} __type485;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PNOT3_0:1;                                      /* PNOT3_0          */
    uint16 PNOT3_1:1;                                      /* PNOT3_1          */
    uint16 PNOT3_2:1;                                      /* PNOT3_2          */
    uint16 PNOT3_3:1;                                      /* PNOT3_3          */
    uint16 PNOT3_4:1;                                      /* PNOT3_4          */
    uint16 PNOT3_5:1;                                      /* PNOT3_5          */
    uint16 PNOT3_6:1;                                      /* PNOT3_6          */
    uint16 PNOT3_7:1;                                      /* PNOT3_7          */
    uint16 PNOT3_8:1;                                      /* PNOT3_8          */
    uint16 PNOT3_9:1;                                      /* PNOT3_9          */
    uint16 :6;                                             /* Reserved Bits    */
} __type486;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PPR3_0:1;                                       /* PPR3_0           */
    uint16 PPR3_1:1;                                       /* PPR3_1           */
    uint16 PPR3_2:1;                                       /* PPR3_2           */
    uint16 PPR3_3:1;                                       /* PPR3_3           */
    uint16 PPR3_4:1;                                       /* PPR3_4           */
    uint16 PPR3_5:1;                                       /* PPR3_5           */
    uint16 PPR3_6:1;                                       /* PPR3_6           */
    uint16 PPR3_7:1;                                       /* PPR3_7           */
    uint16 PPR3_8:1;                                       /* PPR3_8           */
    uint16 PPR3_9:1;                                       /* PPR3_9           */
    uint16 :6;                                             /* Reserved Bits    */
} __type487;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PM3_0:1;                                        /* PM3_0            */
    uint16 PM3_1:1;                                        /* PM3_1            */
    uint16 PM3_2:1;                                        /* PM3_2            */
    uint16 PM3_3:1;                                        /* PM3_3            */
    uint16 PM3_4:1;                                        /* PM3_4            */
    uint16 PM3_5:1;                                        /* PM3_5            */
    uint16 PM3_6:1;                                        /* PM3_6            */
    uint16 PM3_7:1;                                        /* PM3_7            */
    uint16 PM3_8:1;                                        /* PM3_8            */
    uint16 PM3_9:1;                                        /* PM3_9            */
    uint16 :6;                                             /* Reserved Bits    */
} __type488;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PMC3_0:1;                                       /* PMC3_0           */
    uint16 PMC3_1:1;                                       /* PMC3_1           */
    uint16 PMC3_2:1;                                       /* PMC3_2           */
    uint16 PMC3_3:1;                                       /* PMC3_3           */
    uint16 PMC3_4:1;                                       /* PMC3_4           */
    uint16 PMC3_5:1;                                       /* PMC3_5           */
    uint16 PMC3_6:1;                                       /* PMC3_6           */
    uint16 PMC3_7:1;                                       /* PMC3_7           */
    uint16 PMC3_8:1;                                       /* PMC3_8           */
    uint16 PMC3_9:1;                                       /* PMC3_9           */
    uint16 :6;                                             /* Reserved Bits    */
} __type489;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PFC3_0:1;                                       /* PFC3_0           */
    uint16 PFC3_1:1;                                       /* PFC3_1           */
    uint16 PFC3_2:1;                                       /* PFC3_2           */
    uint16 PFC3_3:1;                                       /* PFC3_3           */
    uint16 PFC3_4:1;                                       /* PFC3_4           */
    uint16 PFC3_5:1;                                       /* PFC3_5           */
    uint16 PFC3_6:1;                                       /* PFC3_6           */
    uint16 PFC3_7:1;                                       /* PFC3_7           */
    uint16 PFC3_8:1;                                       /* PFC3_8           */
    uint16 PFC3_9:1;                                       /* PFC3_9           */
    uint16 :6;                                             /* Reserved Bits    */
} __type490;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PFCE3_0:1;                                      /* PFCE3_0          */
    uint16 PFCE3_1:1;                                      /* PFCE3_1          */
    uint16 PFCE3_2:1;                                      /* PFCE3_2          */
    uint16 PFCE3_3:1;                                      /* PFCE3_3          */
    uint16 PFCE3_4:1;                                      /* PFCE3_4          */
    uint16 PFCE3_5:1;                                      /* PFCE3_5          */
    uint16 PFCE3_6:1;                                      /* PFCE3_6          */
    uint16 PFCE3_7:1;                                      /* PFCE3_7          */
    uint16 PFCE3_8:1;                                      /* PFCE3_8          */
    uint16 PFCE3_9:1;                                      /* PFCE3_9          */
    uint16 :6;                                             /* Reserved Bits    */
} __type491;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PMSR3_0:1;                                      /* PMSR3_0          */
    uint32 PMSR3_1:1;                                      /* PMSR3_1          */
    uint32 PMSR3_2:1;                                      /* PMSR3_2          */
    uint32 PMSR3_3:1;                                      /* PMSR3_3          */
    uint32 PMSR3_4:1;                                      /* PMSR3_4          */
    uint32 PMSR3_5:1;                                      /* PMSR3_5          */
    uint32 PMSR3_6:1;                                      /* PMSR3_6          */
    uint32 PMSR3_7:1;                                      /* PMSR3_7          */
    uint32 PMSR3_8:1;                                      /* PMSR3_8          */
    uint32 PMSR3_9:1;                                      /* PMSR3_9          */
    uint32 :6;                                             /* Reserved Bits    */
    uint32 PMSR3_16:1;                                     /* PMSR3_16         */
    uint32 PMSR3_17:1;                                     /* PMSR3_17         */
    uint32 PMSR3_18:1;                                     /* PMSR3_18         */
    uint32 PMSR3_19:1;                                     /* PMSR3_19         */
    uint32 PMSR3_20:1;                                     /* PMSR3_20         */
    uint32 PMSR3_21:1;                                     /* PMSR3_21         */
    uint32 PMSR3_22:1;                                     /* PMSR3_22         */
    uint32 PMSR3_23:1;                                     /* PMSR3_23         */
    uint32 PMSR3_24:1;                                     /* PMSR3_24         */
    uint32 PMSR3_25:1;                                     /* PMSR3_25         */
    uint32 :6;                                             /* Reserved Bits    */
} __type492;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PMCSR3_0:1;                                     /* PMCSR3_0         */
    uint32 PMCSR3_1:1;                                     /* PMCSR3_1         */
    uint32 PMCSR3_2:1;                                     /* PMCSR3_2         */
    uint32 PMCSR3_3:1;                                     /* PMCSR3_3         */
    uint32 PMCSR3_4:1;                                     /* PMCSR3_4         */
    uint32 PMCSR3_5:1;                                     /* PMCSR3_5         */
    uint32 PMCSR3_6:1;                                     /* PMCSR3_6         */
    uint32 PMCSR3_7:1;                                     /* PMCSR3_7         */
    uint32 PMCSR3_8:1;                                     /* PMCSR3_8         */
    uint32 PMCSR3_9:1;                                     /* PMCSR3_9         */
    uint32 :6;                                             /* Reserved Bits    */
    uint32 PMCSR3_16:1;                                    /* PMCSR3_16        */
    uint32 PMCSR3_17:1;                                    /* PMCSR3_17        */
    uint32 PMCSR3_18:1;                                    /* PMCSR3_18        */
    uint32 PMCSR3_19:1;                                    /* PMCSR3_19        */
    uint32 PMCSR3_20:1;                                    /* PMCSR3_20        */
    uint32 PMCSR3_21:1;                                    /* PMCSR3_21        */
    uint32 PMCSR3_22:1;                                    /* PMCSR3_22        */
    uint32 PMCSR3_23:1;                                    /* PMCSR3_23        */
    uint32 PMCSR3_24:1;                                    /* PMCSR3_24        */
    uint32 PMCSR3_25:1;                                    /* PMCSR3_25        */
    uint32 :6;                                             /* Reserved Bits    */
} __type493;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PINV3_0:1;                                      /* PINV3_0          */
    uint16 PINV3_1:1;                                      /* PINV3_1          */
    uint16 PINV3_2:1;                                      /* PINV3_2          */
    uint16 PINV3_3:1;                                      /* PINV3_3          */
    uint16 PINV3_4:1;                                      /* PINV3_4          */
    uint16 PINV3_5:1;                                      /* PINV3_5          */
    uint16 PINV3_6:1;                                      /* PINV3_6          */
    uint16 PINV3_7:1;                                      /* PINV3_7          */
    uint16 PINV3_8:1;                                      /* PINV3_8          */
    uint16 PINV3_9:1;                                      /* PINV3_9          */
    uint16 :6;                                             /* Reserved Bits    */
} __type494;
typedef struct 
{                                                          /* Bit Access       */
    uint16 P10_0:1;                                        /* P10_0            */
    uint16 P10_1:1;                                        /* P10_1            */
    uint16 P10_2:1;                                        /* P10_2            */
    uint16 P10_3:1;                                        /* P10_3            */
    uint16 P10_4:1;                                        /* P10_4            */
    uint16 P10_5:1;                                        /* P10_5            */
    uint16 P10_6:1;                                        /* P10_6            */
    uint16 P10_7:1;                                        /* P10_7            */
    uint16 P10_8:1;                                        /* P10_8            */
    uint16 P10_9:1;                                        /* P10_9            */
    uint16 P10_10:1;                                       /* P10_10           */
    uint16 P10_11:1;                                       /* P10_11           */
    uint16 :4;                                             /* Reserved Bits    */
} __type495;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PSR10_0:1;                                      /* PSR10_0          */
    uint32 PSR10_1:1;                                      /* PSR10_1          */
    uint32 PSR10_2:1;                                      /* PSR10_2          */
    uint32 PSR10_3:1;                                      /* PSR10_3          */
    uint32 PSR10_4:1;                                      /* PSR10_4          */
    uint32 PSR10_5:1;                                      /* PSR10_5          */
    uint32 PSR10_6:1;                                      /* PSR10_6          */
    uint32 PSR10_7:1;                                      /* PSR10_7          */
    uint32 PSR10_8:1;                                      /* PSR10_8          */
    uint32 PSR10_9:1;                                      /* PSR10_9          */
    uint32 PSR10_10:1;                                     /* PSR10_10         */
    uint32 PSR10_11:1;                                     /* PSR10_11         */
    uint32 :4;                                             /* Reserved Bits    */
    uint32 PSR10_16:1;                                     /* PSR10_16         */
    uint32 PSR10_17:1;                                     /* PSR10_17         */
    uint32 PSR10_18:1;                                     /* PSR10_18         */
    uint32 PSR10_19:1;                                     /* PSR10_19         */
    uint32 PSR10_20:1;                                     /* PSR10_20         */
    uint32 PSR10_21:1;                                     /* PSR10_21         */
    uint32 PSR10_22:1;                                     /* PSR10_22         */
    uint32 PSR10_23:1;                                     /* PSR10_23         */
    uint32 PSR10_24:1;                                     /* PSR10_24         */
    uint32 PSR10_25:1;                                     /* PSR10_25         */
    uint32 PSR10_26:1;                                     /* PSR10_26         */
    uint32 PSR10_27:1;                                     /* PSR10_27         */
    uint32 :4;                                             /* Reserved Bits    */
} __type496;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PNOT10_0:1;                                     /* PNOT10_0         */
    uint16 PNOT10_1:1;                                     /* PNOT10_1         */
    uint16 PNOT10_2:1;                                     /* PNOT10_2         */
    uint16 PNOT10_3:1;                                     /* PNOT10_3         */
    uint16 PNOT10_4:1;                                     /* PNOT10_4         */
    uint16 PNOT10_5:1;                                     /* PNOT10_5         */
    uint16 PNOT10_6:1;                                     /* PNOT10_6         */
    uint16 PNOT10_7:1;                                     /* PNOT10_7         */
    uint16 PNOT10_8:1;                                     /* PNOT10_8         */
    uint16 PNOT10_9:1;                                     /* PNOT10_9         */
    uint16 PNOT10_10:1;                                    /* PNOT10_10        */
    uint16 PNOT10_11:1;                                    /* PNOT10_11        */
    uint16 :4;                                             /* Reserved Bits    */
} __type497;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PPR10_0:1;                                      /* PPR10_0          */
    uint16 PPR10_1:1;                                      /* PPR10_1          */
    uint16 PPR10_2:1;                                      /* PPR10_2          */
    uint16 PPR10_3:1;                                      /* PPR10_3          */
    uint16 PPR10_4:1;                                      /* PPR10_4          */
    uint16 PPR10_5:1;                                      /* PPR10_5          */
    uint16 PPR10_6:1;                                      /* PPR10_6          */
    uint16 PPR10_7:1;                                      /* PPR10_7          */
    uint16 PPR10_8:1;                                      /* PPR10_8          */
    uint16 PPR10_9:1;                                      /* PPR10_9          */
    uint16 PPR10_10:1;                                     /* PPR10_10         */
    uint16 PPR10_11:1;                                     /* PPR10_11         */
    uint16 :4;                                             /* Reserved Bits    */
} __type498;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PM10_0:1;                                       /* PM10_0           */
    uint16 PM10_1:1;                                       /* PM10_1           */
    uint16 PM10_2:1;                                       /* PM10_2           */
    uint16 PM10_3:1;                                       /* PM10_3           */
    uint16 PM10_4:1;                                       /* PM10_4           */
    uint16 PM10_5:1;                                       /* PM10_5           */
    uint16 PM10_6:1;                                       /* PM10_6           */
    uint16 PM10_7:1;                                       /* PM10_7           */
    uint16 PM10_8:1;                                       /* PM10_8           */
    uint16 PM10_9:1;                                       /* PM10_9           */
    uint16 PM10_10:1;                                      /* PM10_10          */
    uint16 PM10_11:1;                                      /* PM10_11          */
    uint16 :4;                                             /* Reserved Bits    */
} __type499;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PMC10_0:1;                                      /* PMC10_0          */
    uint16 PMC10_1:1;                                      /* PMC10_1          */
    uint16 PMC10_2:1;                                      /* PMC10_2          */
    uint16 PMC10_3:1;                                      /* PMC10_3          */
    uint16 PMC10_4:1;                                      /* PMC10_4          */
    uint16 PMC10_5:1;                                      /* PMC10_5          */
    uint16 PMC10_6:1;                                      /* PMC10_6          */
    uint16 PMC10_7:1;                                      /* PMC10_7          */
    uint16 PMC10_8:1;                                      /* PMC10_8          */
    uint16 PMC10_9:1;                                      /* PMC10_9          */
    uint16 PMC10_10:1;                                     /* PMC10_10         */
    uint16 PMC10_11:1;                                     /* PMC10_11         */
    uint16 :4;                                             /* Reserved Bits    */
} __type500;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PFC10_0:1;                                      /* PFC10_0          */
    uint16 PFC10_1:1;                                      /* PFC10_1          */
    uint16 PFC10_2:1;                                      /* PFC10_2          */
    uint16 PFC10_3:1;                                      /* PFC10_3          */
    uint16 PFC10_4:1;                                      /* PFC10_4          */
    uint16 PFC10_5:1;                                      /* PFC10_5          */
    uint16 PFC10_6:1;                                      /* PFC10_6          */
    uint16 PFC10_7:1;                                      /* PFC10_7          */
    uint16 PFC10_8:1;                                      /* PFC10_8          */
    uint16 PFC10_9:1;                                      /* PFC10_9          */
    uint16 PFC10_10:1;                                     /* PFC10_10         */
    uint16 PFC10_11:1;                                     /* PFC10_11         */
    uint16 :4;                                             /* Reserved Bits    */
} __type501;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PFCE10_0:1;                                     /* PFCE10_0         */
    uint16 PFCE10_1:1;                                     /* PFCE10_1         */
    uint16 PFCE10_2:1;                                     /* PFCE10_2         */
    uint16 PFCE10_3:1;                                     /* PFCE10_3         */
    uint16 PFCE10_4:1;                                     /* PFCE10_4         */
    uint16 PFCE10_5:1;                                     /* PFCE10_5         */
    uint16 PFCE10_6:1;                                     /* PFCE10_6         */
    uint16 PFCE10_7:1;                                     /* PFCE10_7         */
    uint16 PFCE10_8:1;                                     /* PFCE10_8         */
    uint16 PFCE10_9:1;                                     /* PFCE10_9         */
    uint16 PFCE10_10:1;                                    /* PFCE10_10        */
    uint16 PFCE10_11:1;                                    /* PFCE10_11        */
    uint16 :4;                                             /* Reserved Bits    */
} __type502;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PMSR10_0:1;                                     /* PMSR10_0         */
    uint32 PMSR10_1:1;                                     /* PMSR10_1         */
    uint32 PMSR10_2:1;                                     /* PMSR10_2         */
    uint32 PMSR10_3:1;                                     /* PMSR10_3         */
    uint32 PMSR10_4:1;                                     /* PMSR10_4         */
    uint32 PMSR10_5:1;                                     /* PMSR10_5         */
    uint32 PMSR10_6:1;                                     /* PMSR10_6         */
    uint32 PMSR10_7:1;                                     /* PMSR10_7         */
    uint32 PMSR10_8:1;                                     /* PMSR10_8         */
    uint32 PMSR10_9:1;                                     /* PMSR10_9         */
    uint32 PMSR10_10:1;                                    /* PMSR10_10        */
    uint32 PMSR10_11:1;                                    /* PMSR10_11        */
    uint32 :4;                                             /* Reserved Bits    */
    uint32 PMSR10_16:1;                                    /* PMSR10_16        */
    uint32 PMSR10_17:1;                                    /* PMSR10_17        */
    uint32 PMSR10_18:1;                                    /* PMSR10_18        */
    uint32 PMSR10_19:1;                                    /* PMSR10_19        */
    uint32 PMSR10_20:1;                                    /* PMSR10_20        */
    uint32 PMSR10_21:1;                                    /* PMSR10_21        */
    uint32 PMSR10_22:1;                                    /* PMSR10_22        */
    uint32 PMSR10_23:1;                                    /* PMSR10_23        */
    uint32 PMSR10_24:1;                                    /* PMSR10_24        */
    uint32 PMSR10_25:1;                                    /* PMSR10_25        */
    uint32 PMSR10_26:1;                                    /* PMSR10_26        */
    uint32 PMSR10_27:1;                                    /* PMSR10_27        */
    uint32 :4;                                             /* Reserved Bits    */
} __type503;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PMCSR10_0:1;                                    /* PMCSR10_0        */
    uint32 PMCSR10_1:1;                                    /* PMCSR10_1        */
    uint32 PMCSR10_2:1;                                    /* PMCSR10_2        */
    uint32 PMCSR10_3:1;                                    /* PMCSR10_3        */
    uint32 PMCSR10_4:1;                                    /* PMCSR10_4        */
    uint32 PMCSR10_5:1;                                    /* PMCSR10_5        */
    uint32 PMCSR10_6:1;                                    /* PMCSR10_6        */
    uint32 PMCSR10_7:1;                                    /* PMCSR10_7        */
    uint32 PMCSR10_8:1;                                    /* PMCSR10_8        */
    uint32 PMCSR10_9:1;                                    /* PMCSR10_9        */
    uint32 PMCSR10_10:1;                                   /* PMCSR10_10       */
    uint32 PMCSR10_11:1;                                   /* PMCSR10_11       */
    uint32 :4;                                             /* Reserved Bits    */
    uint32 PMCSR10_16:1;                                   /* PMCSR10_16       */
    uint32 PMCSR10_17:1;                                   /* PMCSR10_17       */
    uint32 PMCSR10_18:1;                                   /* PMCSR10_18       */
    uint32 PMCSR10_19:1;                                   /* PMCSR10_19       */
    uint32 PMCSR10_20:1;                                   /* PMCSR10_20       */
    uint32 PMCSR10_21:1;                                   /* PMCSR10_21       */
    uint32 PMCSR10_22:1;                                   /* PMCSR10_22       */
    uint32 PMCSR10_23:1;                                   /* PMCSR10_23       */
    uint32 PMCSR10_24:1;                                   /* PMCSR10_24       */
    uint32 PMCSR10_25:1;                                   /* PMCSR10_25       */
    uint32 PMCSR10_26:1;                                   /* PMCSR10_26       */
    uint32 PMCSR10_27:1;                                   /* PMCSR10_27       */
    uint32 :4;                                             /* Reserved Bits    */
} __type504;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PINV10_0:1;                                     /* PINV10_0         */
    uint16 PINV10_1:1;                                     /* PINV10_1         */
    uint16 PINV10_2:1;                                     /* PINV10_2         */
    uint16 PINV10_3:1;                                     /* PINV10_3         */
    uint16 PINV10_4:1;                                     /* PINV10_4         */
    uint16 PINV10_5:1;                                     /* PINV10_5         */
    uint16 PINV10_6:1;                                     /* PINV10_6         */
    uint16 PINV10_7:1;                                     /* PINV10_7         */
    uint16 PINV10_8:1;                                     /* PINV10_8         */
    uint16 PINV10_9:1;                                     /* PINV10_9         */
    uint16 PINV10_10:1;                                    /* PINV10_10        */
    uint16 PINV10_11:1;                                    /* PINV10_11        */
    uint16 :4;                                             /* Reserved Bits    */
} __type505;
typedef struct 
{                                                          /* Bit Access       */
    uint16 P11_0:1;                                        /* P11_0            */
    uint16 P11_1:1;                                        /* P11_1            */
    uint16 P11_2:1;                                        /* P11_2            */
    uint16 P11_3:1;                                        /* P11_3            */
    uint16 :12;                                            /* Reserved Bits    */
} __type506;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PSR11_0:1;                                      /* PSR11_0          */
    uint32 PSR11_1:1;                                      /* PSR11_1          */
    uint32 PSR11_2:1;                                      /* PSR11_2          */
    uint32 PSR11_3:1;                                      /* PSR11_3          */
    uint32 :12;                                            /* Reserved Bits    */
    uint32 PSR11_16:1;                                     /* PSR11_16         */
    uint32 PSR11_17:1;                                     /* PSR11_17         */
    uint32 PSR11_18:1;                                     /* PSR11_18         */
    uint32 PSR11_19:1;                                     /* PSR11_19         */
    uint32 :12;                                            /* Reserved Bits    */
} __type507;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PNOT11_0:1;                                     /* PNOT11_0         */
    uint16 PNOT11_1:1;                                     /* PNOT11_1         */
    uint16 PNOT11_2:1;                                     /* PNOT11_2         */
    uint16 PNOT11_3:1;                                     /* PNOT11_3         */
    uint16 :12;                                            /* Reserved Bits    */
} __type508;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PPR11_0:1;                                      /* PPR11_0          */
    uint16 PPR11_1:1;                                      /* PPR11_1          */
    uint16 PPR11_2:1;                                      /* PPR11_2          */
    uint16 PPR11_3:1;                                      /* PPR11_3          */
    uint16 :12;                                            /* Reserved Bits    */
} __type509;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PM11_0:1;                                       /* PM11_0           */
    uint16 PM11_1:1;                                       /* PM11_1           */
    uint16 PM11_2:1;                                       /* PM11_2           */
    uint16 PM11_3:1;                                       /* PM11_3           */
    uint16 :12;                                            /* Reserved Bits    */
} __type510;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PMC11_0:1;                                      /* PMC11_0          */
    uint16 PMC11_1:1;                                      /* PMC11_1          */
    uint16 PMC11_2:1;                                      /* PMC11_2          */
    uint16 PMC11_3:1;                                      /* PMC11_3          */
    uint16 :12;                                            /* Reserved Bits    */
} __type511;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PFC11_0:1;                                      /* PFC11_0          */
    uint16 PFC11_1:1;                                      /* PFC11_1          */
    uint16 PFC11_2:1;                                      /* PFC11_2          */
    uint16 PFC11_3:1;                                      /* PFC11_3          */
    uint16 :12;                                            /* Reserved Bits    */
} __type512;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PMSR11_0:1;                                     /* PMSR11_0         */
    uint32 PMSR11_1:1;                                     /* PMSR11_1         */
    uint32 PMSR11_2:1;                                     /* PMSR11_2         */
    uint32 PMSR11_3:1;                                     /* PMSR11_3         */
    uint32 :12;                                            /* Reserved Bits    */
    uint32 PMSR11_16:1;                                    /* PMSR11_16        */
    uint32 PMSR11_17:1;                                    /* PMSR11_17        */
    uint32 PMSR11_18:1;                                    /* PMSR11_18        */
    uint32 PMSR11_19:1;                                    /* PMSR11_19        */
    uint32 :12;                                            /* Reserved Bits    */
} __type513;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PMCSR11_0:1;                                    /* PMCSR11_0        */
    uint32 PMCSR11_1:1;                                    /* PMCSR11_1        */
    uint32 PMCSR11_2:1;                                    /* PMCSR11_2        */
    uint32 PMCSR11_3:1;                                    /* PMCSR11_3        */
    uint32 :12;                                            /* Reserved Bits    */
    uint32 PMCSR11_16:1;                                   /* PMCSR11_16       */
    uint32 PMCSR11_17:1;                                   /* PMCSR11_17       */
    uint32 PMCSR11_18:1;                                   /* PMCSR11_18       */
    uint32 PMCSR11_19:1;                                   /* PMCSR11_19       */
    uint32 :12;                                            /* Reserved Bits    */
} __type514;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PINV11_0:1;                                     /* PINV11_0         */
    uint16 PINV11_1:1;                                     /* PINV11_1         */
    uint16 PINV11_2:1;                                     /* PINV11_2         */
    uint16 PINV11_3:1;                                     /* PINV11_3         */
    uint16 :12;                                            /* Reserved Bits    */
} __type515;
typedef struct 
{                                                          /* Bit Access       */
    uint16 P16_0:1;                                        /* P16_0            */
    uint16 P16_1:1;                                        /* P16_1            */
    uint16 P16_2:1;                                        /* P16_2            */
    uint16 P16_3:1;                                        /* P16_3            */
    uint16 P16_4:1;                                        /* P16_4            */
    uint16 P16_5:1;                                        /* P16_5            */
    uint16 P16_6:1;                                        /* P16_6            */
    uint16 P16_7:1;                                        /* P16_7            */
    uint16 P16_8:1;                                        /* P16_8            */
    uint16 P16_9:1;                                        /* P16_9            */
    uint16 P16_10:1;                                       /* P16_10           */
    uint16 P16_11:1;                                       /* P16_11           */
    uint16 :4;                                             /* Reserved Bits    */
} __type516;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PSR16_0:1;                                      /* PSR16_0          */
    uint32 PSR16_1:1;                                      /* PSR16_1          */
    uint32 PSR16_2:1;                                      /* PSR16_2          */
    uint32 PSR16_3:1;                                      /* PSR16_3          */
    uint32 PSR16_4:1;                                      /* PSR16_4          */
    uint32 PSR16_5:1;                                      /* PSR16_5          */
    uint32 PSR16_6:1;                                      /* PSR16_6          */
    uint32 PSR16_7:1;                                      /* PSR16_7          */
    uint32 PSR16_8:1;                                      /* PSR16_8          */
    uint32 PSR16_9:1;                                      /* PSR16_9          */
    uint32 PSR16_10:1;                                     /* PSR16_10         */
    uint32 PSR16_11:1;                                     /* PSR16_11         */
    uint32 :4;                                             /* Reserved Bits    */
    uint32 PSR16_16:1;                                     /* PSR16_16         */
    uint32 PSR16_17:1;                                     /* PSR16_17         */
    uint32 PSR16_18:1;                                     /* PSR16_18         */
    uint32 PSR16_19:1;                                     /* PSR16_19         */
    uint32 PSR16_20:1;                                     /* PSR16_20         */
    uint32 PSR16_21:1;                                     /* PSR16_21         */
    uint32 PSR16_22:1;                                     /* PSR16_22         */
    uint32 PSR16_23:1;                                     /* PSR16_23         */
    uint32 PSR16_24:1;                                     /* PSR16_24         */
    uint32 PSR16_25:1;                                     /* PSR16_25         */
    uint32 PSR16_26:1;                                     /* PSR16_26         */
    uint32 PSR16_27:1;                                     /* PSR16_27         */
    uint32 :4;                                             /* Reserved Bits    */
} __type517;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PNOT16_0:1;                                     /* PNOT16_0         */
    uint16 PNOT16_1:1;                                     /* PNOT16_1         */
    uint16 PNOT16_2:1;                                     /* PNOT16_2         */
    uint16 PNOT16_3:1;                                     /* PNOT16_3         */
    uint16 PNOT16_4:1;                                     /* PNOT16_4         */
    uint16 PNOT16_5:1;                                     /* PNOT16_5         */
    uint16 PNOT16_6:1;                                     /* PNOT16_6         */
    uint16 PNOT16_7:1;                                     /* PNOT16_7         */
    uint16 PNOT16_8:1;                                     /* PNOT16_8         */
    uint16 PNOT16_9:1;                                     /* PNOT16_9         */
    uint16 PNOT16_10:1;                                    /* PNOT16_10        */
    uint16 PNOT16_11:1;                                    /* PNOT16_11        */
    uint16 :4;                                             /* Reserved Bits    */
} __type518;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PPR16_0:1;                                      /* PPR16_0          */
    uint16 PPR16_1:1;                                      /* PPR16_1          */
    uint16 PPR16_2:1;                                      /* PPR16_2          */
    uint16 PPR16_3:1;                                      /* PPR16_3          */
    uint16 PPR16_4:1;                                      /* PPR16_4          */
    uint16 PPR16_5:1;                                      /* PPR16_5          */
    uint16 PPR16_6:1;                                      /* PPR16_6          */
    uint16 PPR16_7:1;                                      /* PPR16_7          */
    uint16 PPR16_8:1;                                      /* PPR16_8          */
    uint16 PPR16_9:1;                                      /* PPR16_9          */
    uint16 PPR16_10:1;                                     /* PPR16_10         */
    uint16 PPR16_11:1;                                     /* PPR16_11         */
    uint16 :4;                                             /* Reserved Bits    */
} __type519;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PM16_0:1;                                       /* PM16_0           */
    uint16 PM16_1:1;                                       /* PM16_1           */
    uint16 PM16_2:1;                                       /* PM16_2           */
    uint16 PM16_3:1;                                       /* PM16_3           */
    uint16 PM16_4:1;                                       /* PM16_4           */
    uint16 PM16_5:1;                                       /* PM16_5           */
    uint16 PM16_6:1;                                       /* PM16_6           */
    uint16 PM16_7:1;                                       /* PM16_7           */
    uint16 PM16_8:1;                                       /* PM16_8           */
    uint16 PM16_9:1;                                       /* PM16_9           */
    uint16 PM16_10:1;                                      /* PM16_10          */
    uint16 PM16_11:1;                                      /* PM16_11          */
    uint16 :4;                                             /* Reserved Bits    */
} __type520;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PMC16_0:1;                                      /* PMC16_0          */
    uint16 PMC16_1:1;                                      /* PMC16_1          */
    uint16 PMC16_2:1;                                      /* PMC16_2          */
    uint16 PMC16_3:1;                                      /* PMC16_3          */
    uint16 PMC16_4:1;                                      /* PMC16_4          */
    uint16 PMC16_5:1;                                      /* PMC16_5          */
    uint16 PMC16_6:1;                                      /* PMC16_6          */
    uint16 PMC16_7:1;                                      /* PMC16_7          */
    uint16 PMC16_8:1;                                      /* PMC16_8          */
    uint16 PMC16_9:1;                                      /* PMC16_9          */
    uint16 PMC16_10:1;                                     /* PMC16_10         */
    uint16 PMC16_11:1;                                     /* PMC16_11         */
    uint16 :4;                                             /* Reserved Bits    */
} __type521;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PFC16_0:1;                                      /* PFC16_0          */
    uint16 PFC16_1:1;                                      /* PFC16_1          */
    uint16 PFC16_2:1;                                      /* PFC16_2          */
    uint16 PFC16_3:1;                                      /* PFC16_3          */
    uint16 PFC16_4:1;                                      /* PFC16_4          */
    uint16 PFC16_5:1;                                      /* PFC16_5          */
    uint16 PFC16_6:1;                                      /* PFC16_6          */
    uint16 PFC16_7:1;                                      /* PFC16_7          */
    uint16 PFC16_8:1;                                      /* PFC16_8          */
    uint16 PFC16_9:1;                                      /* PFC16_9          */
    uint16 PFC16_10:1;                                     /* PFC16_10         */
    uint16 PFC16_11:1;                                     /* PFC16_11         */
    uint16 :4;                                             /* Reserved Bits    */
} __type522;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PFCE16_0:1;                                     /* PFCE16_0         */
    uint16 PFCE16_1:1;                                     /* PFCE16_1         */
    uint16 PFCE16_2:1;                                     /* PFCE16_2         */
    uint16 PFCE16_3:1;                                     /* PFCE16_3         */
    uint16 PFCE16_4:1;                                     /* PFCE16_4         */
    uint16 PFCE16_5:1;                                     /* PFCE16_5         */
    uint16 PFCE16_6:1;                                     /* PFCE16_6         */
    uint16 PFCE16_7:1;                                     /* PFCE16_7         */
    uint16 PFCE16_8:1;                                     /* PFCE16_8         */
    uint16 PFCE16_9:1;                                     /* PFCE16_9         */
    uint16 PFCE16_10:1;                                    /* PFCE16_10        */
    uint16 PFCE16_11:1;                                    /* PFCE16_11        */
    uint16 :4;                                             /* Reserved Bits    */
} __type523;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PMSR16_0:1;                                     /* PMSR16_0         */
    uint32 PMSR16_1:1;                                     /* PMSR16_1         */
    uint32 PMSR16_2:1;                                     /* PMSR16_2         */
    uint32 PMSR16_3:1;                                     /* PMSR16_3         */
    uint32 PMSR16_4:1;                                     /* PMSR16_4         */
    uint32 PMSR16_5:1;                                     /* PMSR16_5         */
    uint32 PMSR16_6:1;                                     /* PMSR16_6         */
    uint32 PMSR16_7:1;                                     /* PMSR16_7         */
    uint32 PMSR16_8:1;                                     /* PMSR16_8         */
    uint32 PMSR16_9:1;                                     /* PMSR16_9         */
    uint32 PMSR16_10:1;                                    /* PMSR16_10        */
    uint32 PMSR16_11:1;                                    /* PMSR16_11        */
    uint32 :4;                                             /* Reserved Bits    */
    uint32 PMSR16_16:1;                                    /* PMSR16_16        */
    uint32 PMSR16_17:1;                                    /* PMSR16_17        */
    uint32 PMSR16_18:1;                                    /* PMSR16_18        */
    uint32 PMSR16_19:1;                                    /* PMSR16_19        */
    uint32 PMSR16_20:1;                                    /* PMSR16_20        */
    uint32 PMSR16_21:1;                                    /* PMSR16_21        */
    uint32 PMSR16_22:1;                                    /* PMSR16_22        */
    uint32 PMSR16_23:1;                                    /* PMSR16_23        */
    uint32 PMSR16_24:1;                                    /* PMSR16_24        */
    uint32 PMSR16_25:1;                                    /* PMSR16_25        */
    uint32 PMSR16_26:1;                                    /* PMSR16_26        */
    uint32 PMSR16_27:1;                                    /* PMSR16_27        */
    uint32 :4;                                             /* Reserved Bits    */
} __type524;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PMCSR16_0:1;                                    /* PMCSR16_0        */
    uint32 PMCSR16_1:1;                                    /* PMCSR16_1        */
    uint32 PMCSR16_2:1;                                    /* PMCSR16_2        */
    uint32 PMCSR16_3:1;                                    /* PMCSR16_3        */
    uint32 PMCSR16_4:1;                                    /* PMCSR16_4        */
    uint32 PMCSR16_5:1;                                    /* PMCSR16_5        */
    uint32 PMCSR16_6:1;                                    /* PMCSR16_6        */
    uint32 PMCSR16_7:1;                                    /* PMCSR16_7        */
    uint32 PMCSR16_8:1;                                    /* PMCSR16_8        */
    uint32 PMCSR16_9:1;                                    /* PMCSR16_9        */
    uint32 PMCSR16_10:1;                                   /* PMCSR16_10       */
    uint32 PMCSR16_11:1;                                   /* PMCSR16_11       */
    uint32 :4;                                             /* Reserved Bits    */
    uint32 PMCSR16_16:1;                                   /* PMCSR16_16       */
    uint32 PMCSR16_17:1;                                   /* PMCSR16_17       */
    uint32 PMCSR16_18:1;                                   /* PMCSR16_18       */
    uint32 PMCSR16_19:1;                                   /* PMCSR16_19       */
    uint32 PMCSR16_20:1;                                   /* PMCSR16_20       */
    uint32 PMCSR16_21:1;                                   /* PMCSR16_21       */
    uint32 PMCSR16_22:1;                                   /* PMCSR16_22       */
    uint32 PMCSR16_23:1;                                   /* PMCSR16_23       */
    uint32 PMCSR16_24:1;                                   /* PMCSR16_24       */
    uint32 PMCSR16_25:1;                                   /* PMCSR16_25       */
    uint32 PMCSR16_26:1;                                   /* PMCSR16_26       */
    uint32 PMCSR16_27:1;                                   /* PMCSR16_27       */
    uint32 :4;                                             /* Reserved Bits    */
} __type525;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PINV16_0:1;                                     /* PINV16_0         */
    uint16 PINV16_1:1;                                     /* PINV16_1         */
    uint16 PINV16_2:1;                                     /* PINV16_2         */
    uint16 PINV16_3:1;                                     /* PINV16_3         */
    uint16 PINV16_4:1;                                     /* PINV16_4         */
    uint16 PINV16_5:1;                                     /* PINV16_5         */
    uint16 PINV16_6:1;                                     /* PINV16_6         */
    uint16 PINV16_7:1;                                     /* PINV16_7         */
    uint16 PINV16_8:1;                                     /* PINV16_8         */
    uint16 PINV16_9:1;                                     /* PINV16_9         */
    uint16 PINV16_10:1;                                    /* PINV16_10        */
    uint16 PINV16_11:1;                                    /* PINV16_11        */
    uint16 :4;                                             /* Reserved Bits    */
} __type526;
typedef struct 
{                                                          /* Bit Access       */
    uint16 P17_0:1;                                        /* P17_0            */
    uint16 P17_1:1;                                        /* P17_1            */
    uint16 P17_2:1;                                        /* P17_2            */
    uint16 P17_3:1;                                        /* P17_3            */
    uint16 P17_4:1;                                        /* P17_4            */
    uint16 P17_5:1;                                        /* P17_5            */
    uint16 P17_6:1;                                        /* P17_6            */
    uint16 P17_7:1;                                        /* P17_7            */
    uint16 P17_8:1;                                        /* P17_8            */
    uint16 P17_9:1;                                        /* P17_9            */
    uint16 P17_10:1;                                       /* P17_10           */
    uint16 P17_11:1;                                       /* P17_11           */
    uint16 :4;                                             /* Reserved Bits    */
} __type527;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PSR17_0:1;                                      /* PSR17_0          */
    uint32 PSR17_1:1;                                      /* PSR17_1          */
    uint32 PSR17_2:1;                                      /* PSR17_2          */
    uint32 PSR17_3:1;                                      /* PSR17_3          */
    uint32 PSR17_4:1;                                      /* PSR17_4          */
    uint32 PSR17_5:1;                                      /* PSR17_5          */
    uint32 PSR17_6:1;                                      /* PSR17_6          */
    uint32 PSR17_7:1;                                      /* PSR17_7          */
    uint32 PSR17_8:1;                                      /* PSR17_8          */
    uint32 PSR17_9:1;                                      /* PSR17_9          */
    uint32 PSR17_10:1;                                     /* PSR17_10         */
    uint32 PSR17_11:1;                                     /* PSR17_11         */
    uint32 :4;                                             /* Reserved Bits    */
    uint32 PSR17_16:1;                                     /* PSR17_16         */
    uint32 PSR17_17:1;                                     /* PSR17_17         */
    uint32 PSR17_18:1;                                     /* PSR17_18         */
    uint32 PSR17_19:1;                                     /* PSR17_19         */
    uint32 PSR17_20:1;                                     /* PSR17_20         */
    uint32 PSR17_21:1;                                     /* PSR17_21         */
    uint32 PSR17_22:1;                                     /* PSR17_22         */
    uint32 PSR17_23:1;                                     /* PSR17_23         */
    uint32 PSR17_24:1;                                     /* PSR17_24         */
    uint32 PSR17_25:1;                                     /* PSR17_25         */
    uint32 PSR17_26:1;                                     /* PSR17_26         */
    uint32 PSR17_27:1;                                     /* PSR17_27         */
    uint32 :4;                                             /* Reserved Bits    */
} __type528;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PNOT17_0:1;                                     /* PNOT17_0         */
    uint16 PNOT17_1:1;                                     /* PNOT17_1         */
    uint16 PNOT17_2:1;                                     /* PNOT17_2         */
    uint16 PNOT17_3:1;                                     /* PNOT17_3         */
    uint16 PNOT17_4:1;                                     /* PNOT17_4         */
    uint16 PNOT17_5:1;                                     /* PNOT17_5         */
    uint16 PNOT17_6:1;                                     /* PNOT17_6         */
    uint16 PNOT17_7:1;                                     /* PNOT17_7         */
    uint16 PNOT17_8:1;                                     /* PNOT17_8         */
    uint16 PNOT17_9:1;                                     /* PNOT17_9         */
    uint16 PNOT17_10:1;                                    /* PNOT17_10        */
    uint16 PNOT17_11:1;                                    /* PNOT17_11        */
    uint16 :4;                                             /* Reserved Bits    */
} __type529;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PPR17_0:1;                                      /* PPR17_0          */
    uint16 PPR17_1:1;                                      /* PPR17_1          */
    uint16 PPR17_2:1;                                      /* PPR17_2          */
    uint16 PPR17_3:1;                                      /* PPR17_3          */
    uint16 PPR17_4:1;                                      /* PPR17_4          */
    uint16 PPR17_5:1;                                      /* PPR17_5          */
    uint16 PPR17_6:1;                                      /* PPR17_6          */
    uint16 PPR17_7:1;                                      /* PPR17_7          */
    uint16 PPR17_8:1;                                      /* PPR17_8          */
    uint16 PPR17_9:1;                                      /* PPR17_9          */
    uint16 PPR17_10:1;                                     /* PPR17_10         */
    uint16 PPR17_11:1;                                     /* PPR17_11         */
    uint16 :4;                                             /* Reserved Bits    */
} __type530;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PM17_0:1;                                       /* PM17_0           */
    uint16 PM17_1:1;                                       /* PM17_1           */
    uint16 PM17_2:1;                                       /* PM17_2           */
    uint16 PM17_3:1;                                       /* PM17_3           */
    uint16 PM17_4:1;                                       /* PM17_4           */
    uint16 PM17_5:1;                                       /* PM17_5           */
    uint16 PM17_6:1;                                       /* PM17_6           */
    uint16 PM17_7:1;                                       /* PM17_7           */
    uint16 PM17_8:1;                                       /* PM17_8           */
    uint16 PM17_9:1;                                       /* PM17_9           */
    uint16 PM17_10:1;                                      /* PM17_10          */
    uint16 PM17_11:1;                                      /* PM17_11          */
    uint16 :4;                                             /* Reserved Bits    */
} __type531;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PMC17_0:1;                                      /* PMC17_0          */
    uint16 PMC17_1:1;                                      /* PMC17_1          */
    uint16 PMC17_2:1;                                      /* PMC17_2          */
    uint16 PMC17_3:1;                                      /* PMC17_3          */
    uint16 PMC17_4:1;                                      /* PMC17_4          */
    uint16 PMC17_5:1;                                      /* PMC17_5          */
    uint16 PMC17_6:1;                                      /* PMC17_6          */
    uint16 PMC17_7:1;                                      /* PMC17_7          */
    uint16 PMC17_8:1;                                      /* PMC17_8          */
    uint16 PMC17_9:1;                                      /* PMC17_9          */
    uint16 PMC17_10:1;                                     /* PMC17_10         */
    uint16 PMC17_11:1;                                     /* PMC17_11         */
    uint16 :4;                                             /* Reserved Bits    */
} __type532;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PFC17_0:1;                                      /* PFC17_0          */
    uint16 PFC17_1:1;                                      /* PFC17_1          */
    uint16 PFC17_2:1;                                      /* PFC17_2          */
    uint16 PFC17_3:1;                                      /* PFC17_3          */
    uint16 PFC17_4:1;                                      /* PFC17_4          */
    uint16 PFC17_5:1;                                      /* PFC17_5          */
    uint16 PFC17_6:1;                                      /* PFC17_6          */
    uint16 PFC17_7:1;                                      /* PFC17_7          */
    uint16 PFC17_8:1;                                      /* PFC17_8          */
    uint16 PFC17_9:1;                                      /* PFC17_9          */
    uint16 PFC17_10:1;                                     /* PFC17_10         */
    uint16 PFC17_11:1;                                     /* PFC17_11         */
    uint16 :4;                                             /* Reserved Bits    */
} __type533;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PFCE17_0:1;                                     /* PFCE17_0         */
    uint16 PFCE17_1:1;                                     /* PFCE17_1         */
    uint16 PFCE17_2:1;                                     /* PFCE17_2         */
    uint16 PFCE17_3:1;                                     /* PFCE17_3         */
    uint16 :12;                                            /* Reserved Bits    */
} __type534;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PMSR17_0:1;                                     /* PMSR17_0         */
    uint32 PMSR17_1:1;                                     /* PMSR17_1         */
    uint32 PMSR17_2:1;                                     /* PMSR17_2         */
    uint32 PMSR17_3:1;                                     /* PMSR17_3         */
    uint32 PMSR17_4:1;                                     /* PMSR17_4         */
    uint32 PMSR17_5:1;                                     /* PMSR17_5         */
    uint32 PMSR17_6:1;                                     /* PMSR17_6         */
    uint32 PMSR17_7:1;                                     /* PMSR17_7         */
    uint32 PMSR17_8:1;                                     /* PMSR17_8         */
    uint32 PMSR17_9:1;                                     /* PMSR17_9         */
    uint32 PMSR17_10:1;                                    /* PMSR17_10        */
    uint32 PMSR17_11:1;                                    /* PMSR17_11        */
    uint32 :4;                                             /* Reserved Bits    */
    uint32 PMSR17_16:1;                                    /* PMSR17_16        */
    uint32 PMSR17_17:1;                                    /* PMSR17_17        */
    uint32 PMSR17_18:1;                                    /* PMSR17_18        */
    uint32 PMSR17_19:1;                                    /* PMSR17_19        */
    uint32 PMSR17_20:1;                                    /* PMSR17_20        */
    uint32 PMSR17_21:1;                                    /* PMSR17_21        */
    uint32 PMSR17_22:1;                                    /* PMSR17_22        */
    uint32 PMSR17_23:1;                                    /* PMSR17_23        */
    uint32 PMSR17_24:1;                                    /* PMSR17_24        */
    uint32 PMSR17_25:1;                                    /* PMSR17_25        */
    uint32 PMSR17_26:1;                                    /* PMSR17_26        */
    uint32 PMSR17_27:1;                                    /* PMSR17_27        */
    uint32 :4;                                             /* Reserved Bits    */
} __type535;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PMCSR17_0:1;                                    /* PMCSR17_0        */
    uint32 PMCSR17_1:1;                                    /* PMCSR17_1        */
    uint32 PMCSR17_2:1;                                    /* PMCSR17_2        */
    uint32 PMCSR17_3:1;                                    /* PMCSR17_3        */
    uint32 PMCSR17_4:1;                                    /* PMCSR17_4        */
    uint32 PMCSR17_5:1;                                    /* PMCSR17_5        */
    uint32 PMCSR17_6:1;                                    /* PMCSR17_6        */
    uint32 PMCSR17_7:1;                                    /* PMCSR17_7        */
    uint32 PMCSR17_8:1;                                    /* PMCSR17_8        */
    uint32 PMCSR17_9:1;                                    /* PMCSR17_9        */
    uint32 PMCSR17_10:1;                                   /* PMCSR17_10       */
    uint32 PMCSR17_11:1;                                   /* PMCSR17_11       */
    uint32 :4;                                             /* Reserved Bits    */
    uint32 PMCSR17_16:1;                                   /* PMCSR17_16       */
    uint32 PMCSR17_17:1;                                   /* PMCSR17_17       */
    uint32 PMCSR17_18:1;                                   /* PMCSR17_18       */
    uint32 PMCSR17_19:1;                                   /* PMCSR17_19       */
    uint32 PMCSR17_20:1;                                   /* PMCSR17_20       */
    uint32 PMCSR17_21:1;                                   /* PMCSR17_21       */
    uint32 PMCSR17_22:1;                                   /* PMCSR17_22       */
    uint32 PMCSR17_23:1;                                   /* PMCSR17_23       */
    uint32 PMCSR17_24:1;                                   /* PMCSR17_24       */
    uint32 PMCSR17_25:1;                                   /* PMCSR17_25       */
    uint32 PMCSR17_26:1;                                   /* PMCSR17_26       */
    uint32 PMCSR17_27:1;                                   /* PMCSR17_27       */
    uint32 :4;                                             /* Reserved Bits    */
} __type536;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PINV17_0:1;                                     /* PINV17_0         */
    uint16 PINV17_1:1;                                     /* PINV17_1         */
    uint16 PINV17_2:1;                                     /* PINV17_2         */
    uint16 PINV17_3:1;                                     /* PINV17_3         */
    uint16 PINV17_4:1;                                     /* PINV17_4         */
    uint16 PINV17_5:1;                                     /* PINV17_5         */
    uint16 PINV17_6:1;                                     /* PINV17_6         */
    uint16 PINV17_7:1;                                     /* PINV17_7         */
    uint16 PINV17_8:1;                                     /* PINV17_8         */
    uint16 PINV17_9:1;                                     /* PINV17_9         */
    uint16 PINV17_10:1;                                    /* PINV17_10        */
    uint16 PINV17_11:1;                                    /* PINV17_11        */
    uint16 :4;                                             /* Reserved Bits    */
} __type537;
typedef struct 
{                                                          /* Bit Access       */
    uint16 P21_0:1;                                        /* P21_0            */
    uint16 P21_1:1;                                        /* P21_1            */
    uint16 P21_2:1;                                        /* P21_2            */
    uint16 P21_3:1;                                        /* P21_3            */
    uint16 P21_4:1;                                        /* P21_4            */
    uint16 P21_5:1;                                        /* P21_5            */
    uint16 P21_6:1;                                        /* P21_6            */
    uint16 P21_7:1;                                        /* P21_7            */
    uint16 P21_8:1;                                        /* P21_8            */
    uint16 P21_9:1;                                        /* P21_9            */
    uint16 :6;                                             /* Reserved Bits    */
} __type538;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PSR21_0:1;                                      /* PSR21_0          */
    uint32 PSR21_1:1;                                      /* PSR21_1          */
    uint32 PSR21_2:1;                                      /* PSR21_2          */
    uint32 PSR21_3:1;                                      /* PSR21_3          */
    uint32 PSR21_4:1;                                      /* PSR21_4          */
    uint32 PSR21_5:1;                                      /* PSR21_5          */
    uint32 PSR21_6:1;                                      /* PSR21_6          */
    uint32 PSR21_7:1;                                      /* PSR21_7          */
    uint32 PSR21_8:1;                                      /* PSR21_8          */
    uint32 PSR21_9:1;                                      /* PSR21_9          */
    uint32 :6;                                             /* Reserved Bits    */
    uint32 PSR21_16:1;                                     /* PSR21_16         */
    uint32 PSR21_17:1;                                     /* PSR21_17         */
    uint32 PSR21_18:1;                                     /* PSR21_18         */
    uint32 PSR21_19:1;                                     /* PSR21_19         */
    uint32 PSR21_20:1;                                     /* PSR21_20         */
    uint32 PSR21_21:1;                                     /* PSR21_21         */
    uint32 PSR21_22:1;                                     /* PSR21_22         */
    uint32 PSR21_23:1;                                     /* PSR21_23         */
    uint32 PSR21_24:1;                                     /* PSR21_24         */
    uint32 PSR21_25:1;                                     /* PSR21_25         */
    uint32 :6;                                             /* Reserved Bits    */
} __type539;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PNOT21_0:1;                                     /* PNOT21_0         */
    uint16 PNOT21_1:1;                                     /* PNOT21_1         */
    uint16 PNOT21_2:1;                                     /* PNOT21_2         */
    uint16 PNOT21_3:1;                                     /* PNOT21_3         */
    uint16 PNOT21_4:1;                                     /* PNOT21_4         */
    uint16 PNOT21_5:1;                                     /* PNOT21_5         */
    uint16 PNOT21_6:1;                                     /* PNOT21_6         */
    uint16 PNOT21_7:1;                                     /* PNOT21_7         */
    uint16 PNOT21_8:1;                                     /* PNOT21_8         */
    uint16 PNOT21_9:1;                                     /* PNOT21_9         */
    uint16 :6;                                             /* Reserved Bits    */
} __type540;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PPR21_0:1;                                      /* PPR21_0          */
    uint16 PPR21_1:1;                                      /* PPR21_1          */
    uint16 PPR21_2:1;                                      /* PPR21_2          */
    uint16 PPR21_3:1;                                      /* PPR21_3          */
    uint16 PPR21_4:1;                                      /* PPR21_4          */
    uint16 PPR21_5:1;                                      /* PPR21_5          */
    uint16 PPR21_6:1;                                      /* PPR21_6          */
    uint16 PPR21_7:1;                                      /* PPR21_7          */
    uint16 PPR21_8:1;                                      /* PPR21_8          */
    uint16 PPR21_9:1;                                      /* PPR21_9          */
    uint16 :6;                                             /* Reserved Bits    */
} __type541;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PM21_0:1;                                       /* PM21_0           */
    uint16 PM21_1:1;                                       /* PM21_1           */
    uint16 PM21_2:1;                                       /* PM21_2           */
    uint16 PM21_3:1;                                       /* PM21_3           */
    uint16 PM21_4:1;                                       /* PM21_4           */
    uint16 PM21_5:1;                                       /* PM21_5           */
    uint16 PM21_6:1;                                       /* PM21_6           */
    uint16 PM21_7:1;                                       /* PM21_7           */
    uint16 PM21_8:1;                                       /* PM21_8           */
    uint16 PM21_9:1;                                       /* PM21_9           */
    uint16 :6;                                             /* Reserved Bits    */
} __type542;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PMC21_0:1;                                      /* PMC21_0          */
    uint16 PMC21_1:1;                                      /* PMC21_1          */
    uint16 PMC21_2:1;                                      /* PMC21_2          */
    uint16 PMC21_3:1;                                      /* PMC21_3          */
    uint16 PMC21_4:1;                                      /* PMC21_4          */
    uint16 PMC21_5:1;                                      /* PMC21_5          */
    uint16 PMC21_6:1;                                      /* PMC21_6          */
    uint16 PMC21_7:1;                                      /* PMC21_7          */
    uint16 PMC21_8:1;                                      /* PMC21_8          */
    uint16 PMC21_9:1;                                      /* PMC21_9          */
    uint16 :6;                                             /* Reserved Bits    */
} __type543;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PFC21_0:1;                                      /* PFC21_0          */
    uint16 PFC21_1:1;                                      /* PFC21_1          */
    uint16 PFC21_2:1;                                      /* PFC21_2          */
    uint16 PFC21_3:1;                                      /* PFC21_3          */
    uint16 PFC21_4:1;                                      /* PFC21_4          */
    uint16 PFC21_5:1;                                      /* PFC21_5          */
    uint16 PFC21_6:1;                                      /* PFC21_6          */
    uint16 PFC21_7:1;                                      /* PFC21_7          */
    uint16 PFC21_8:1;                                      /* PFC21_8          */
    uint16 PFC21_9:1;                                      /* PFC21_9          */
    uint16 :6;                                             /* Reserved Bits    */
} __type544;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PFCE21_0:1;                                     /* PFCE21_0         */
    uint16 PFCE21_1:1;                                     /* PFCE21_1         */
    uint16 PFCE21_2:1;                                     /* PFCE21_2         */
    uint16 PFCE21_3:1;                                     /* PFCE21_3         */
    uint16 PFCE21_4:1;                                     /* PFCE21_4         */
    uint16 PFCE21_5:1;                                     /* PFCE21_5         */
    uint16 PFCE21_6:1;                                     /* PFCE21_6         */
    uint16 PFCE21_7:1;                                     /* PFCE21_7         */
    uint16 PFCE21_8:1;                                     /* PFCE21_8         */
    uint16 PFCE21_9:1;                                     /* PFCE21_9         */
    uint16 :6;                                             /* Reserved Bits    */
} __type545;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PMSR21_0:1;                                     /* PMSR21_0         */
    uint32 PMSR21_1:1;                                     /* PMSR21_1         */
    uint32 PMSR21_2:1;                                     /* PMSR21_2         */
    uint32 PMSR21_3:1;                                     /* PMSR21_3         */
    uint32 PMSR21_4:1;                                     /* PMSR21_4         */
    uint32 PMSR21_5:1;                                     /* PMSR21_5         */
    uint32 PMSR21_6:1;                                     /* PMSR21_6         */
    uint32 PMSR21_7:1;                                     /* PMSR21_7         */
    uint32 PMSR21_8:1;                                     /* PMSR21_8         */
    uint32 PMSR21_9:1;                                     /* PMSR21_9         */
    uint32 :6;                                             /* Reserved Bits    */
    uint32 PMSR21_16:1;                                    /* PMSR21_16        */
    uint32 PMSR21_17:1;                                    /* PMSR21_17        */
    uint32 PMSR21_18:1;                                    /* PMSR21_18        */
    uint32 PMSR21_19:1;                                    /* PMSR21_19        */
    uint32 PMSR21_20:1;                                    /* PMSR21_20        */
    uint32 PMSR21_21:1;                                    /* PMSR21_21        */
    uint32 PMSR21_22:1;                                    /* PMSR21_22        */
    uint32 PMSR21_23:1;                                    /* PMSR21_23        */
    uint32 PMSR21_24:1;                                    /* PMSR21_24        */
    uint32 PMSR21_25:1;                                    /* PMSR21_25        */
    uint32 :6;                                             /* Reserved Bits    */
} __type546;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PMCSR21_0:1;                                    /* PMCSR21_0        */
    uint32 PMCSR21_1:1;                                    /* PMCSR21_1        */
    uint32 PMCSR21_2:1;                                    /* PMCSR21_2        */
    uint32 PMCSR21_3:1;                                    /* PMCSR21_3        */
    uint32 PMCSR21_4:1;                                    /* PMCSR21_4        */
    uint32 PMCSR21_5:1;                                    /* PMCSR21_5        */
    uint32 PMCSR21_6:1;                                    /* PMCSR21_6        */
    uint32 PMCSR21_7:1;                                    /* PMCSR21_7        */
    uint32 PMCSR21_8:1;                                    /* PMCSR21_8        */
    uint32 PMCSR21_9:1;                                    /* PMCSR21_9        */
    uint32 :6;                                             /* Reserved Bits    */
    uint32 PMCSR21_16:1;                                   /* PMCSR21_16       */
    uint32 PMCSR21_17:1;                                   /* PMCSR21_17       */
    uint32 PMCSR21_18:1;                                   /* PMCSR21_18       */
    uint32 PMCSR21_19:1;                                   /* PMCSR21_19       */
    uint32 PMCSR21_20:1;                                   /* PMCSR21_20       */
    uint32 PMCSR21_21:1;                                   /* PMCSR21_21       */
    uint32 PMCSR21_22:1;                                   /* PMCSR21_22       */
    uint32 PMCSR21_23:1;                                   /* PMCSR21_23       */
    uint32 PMCSR21_24:1;                                   /* PMCSR21_24       */
    uint32 PMCSR21_25:1;                                   /* PMCSR21_25       */
    uint32 :6;                                             /* Reserved Bits    */
} __type547;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PINV21_0:1;                                     /* PINV21_0         */
    uint16 PINV21_1:1;                                     /* PINV21_1         */
    uint16 PINV21_2:1;                                     /* PINV21_2         */
    uint16 PINV21_3:1;                                     /* PINV21_3         */
    uint16 PINV21_4:1;                                     /* PINV21_4         */
    uint16 PINV21_5:1;                                     /* PINV21_5         */
    uint16 PINV21_6:1;                                     /* PINV21_6         */
    uint16 PINV21_7:1;                                     /* PINV21_7         */
    uint16 PINV21_8:1;                                     /* PINV21_8         */
    uint16 PINV21_9:1;                                     /* PINV21_9         */
    uint16 :6;                                             /* Reserved Bits    */
} __type548;
typedef struct 
{                                                          /* Bit Access       */
    uint16 :10;                                            /* Reserved Bits    */
    uint16 P22_10:1;                                       /* P22_10           */
    uint16 :5;                                             /* Reserved Bits    */
} __type549;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :10;                                            /* Reserved Bits    */
    uint32 PSR22_10:1;                                     /* PSR22_10         */
    uint32 :15;                                            /* Reserved Bits    */
    uint32 PSR22_26:1;                                     /* PSR22_26         */
    uint32 :5;                                             /* Reserved Bits    */
} __type550;
typedef struct 
{                                                          /* Bit Access       */
    uint16 :10;                                            /* Reserved Bits    */
    uint16 PNOT22_10:1;                                    /* PNOT22_10        */
    uint16 :5;                                             /* Reserved Bits    */
} __type551;
typedef struct 
{                                                          /* Bit Access       */
    uint16 :10;                                            /* Reserved Bits    */
    uint16 PPR22_10:1;                                     /* PPR22_10         */
    uint16 :5;                                             /* Reserved Bits    */
} __type552;
typedef struct 
{                                                          /* Bit Access       */
    uint16 :10;                                            /* Reserved Bits    */
    uint16 PM22_10:1;                                      /* PM22_10          */
    uint16 :5;                                             /* Reserved Bits    */
} __type553;
typedef struct 
{                                                          /* Bit Access       */
    uint16 :10;                                            /* Reserved Bits    */
    uint16 PMC22_10:1;                                     /* PMC22_10         */
    uint16 :5;                                             /* Reserved Bits    */
} __type554;
typedef struct 
{                                                          /* Bit Access       */
    uint16 :10;                                            /* Reserved Bits    */
    uint16 PFC22_10:1;                                     /* PFC22_10         */
    uint16 :5;                                             /* Reserved Bits    */
} __type555;
typedef struct 
{                                                          /* Bit Access       */
    uint16 :10;                                            /* Reserved Bits    */
    uint16 PFCE22_10:1;                                    /* PFCE22_10        */
    uint16 :5;                                             /* Reserved Bits    */
} __type556;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :10;                                            /* Reserved Bits    */
    uint32 PMSR22_10:1;                                    /* PMSR22_10        */
    uint32 :15;                                            /* Reserved Bits    */
    uint32 PMSR22_26:1;                                    /* PMSR22_26        */
    uint32 :5;                                             /* Reserved Bits    */
} __type557;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :10;                                            /* Reserved Bits    */
    uint32 PMCSR22_10:1;                                   /* PMCSR22_10       */
    uint32 :15;                                            /* Reserved Bits    */
    uint32 PMCSR22_26:1;                                   /* PMCSR22_26       */
    uint32 :5;                                             /* Reserved Bits    */
} __type558;
typedef struct 
{                                                          /* Bit Access       */
    uint16 :10;                                            /* Reserved Bits    */
    uint16 PINV22_10:1;                                    /* PINV22_10        */
    uint16 :5;                                             /* Reserved Bits    */
} __type559;
typedef struct 
{                                                          /* Bit Access       */
    uint16 P42_0:1;                                        /* P42_0            */
    uint16 P42_1:1;                                        /* P42_1            */
    uint16 P42_2:1;                                        /* P42_2            */
    uint16 P42_3:1;                                        /* P42_3            */
    uint16 P42_4:1;                                        /* P42_4            */
    uint16 P42_5:1;                                        /* P42_5            */
    uint16 P42_6:1;                                        /* P42_6            */
    uint16 P42_7:1;                                        /* P42_7            */
    uint16 P42_8:1;                                        /* P42_8            */
    uint16 P42_9:1;                                        /* P42_9            */
    uint16 P42_10:1;                                       /* P42_10           */
    uint16 P42_11:1;                                       /* P42_11           */
    uint16 P42_12:1;                                       /* P42_12           */
    uint16 P42_13:1;                                       /* P42_13           */
    uint16 P42_14:1;                                       /* P42_14           */
    uint16 P42_15:1;                                       /* P42_15           */
} __type560;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PSR42_0:1;                                      /* PSR42_0          */
    uint32 PSR42_1:1;                                      /* PSR42_1          */
    uint32 PSR42_2:1;                                      /* PSR42_2          */
    uint32 PSR42_3:1;                                      /* PSR42_3          */
    uint32 PSR42_4:1;                                      /* PSR42_4          */
    uint32 PSR42_5:1;                                      /* PSR42_5          */
    uint32 PSR42_6:1;                                      /* PSR42_6          */
    uint32 PSR42_7:1;                                      /* PSR42_7          */
    uint32 PSR42_8:1;                                      /* PSR42_8          */
    uint32 PSR42_9:1;                                      /* PSR42_9          */
    uint32 PSR42_10:1;                                     /* PSR42_10         */
    uint32 PSR42_11:1;                                     /* PSR42_11         */
    uint32 PSR42_12:1;                                     /* PSR42_12         */
    uint32 PSR42_13:1;                                     /* PSR42_13         */
    uint32 PSR42_14:1;                                     /* PSR42_14         */
    uint32 PSR42_15:1;                                     /* PSR42_15         */
    uint32 PSR42_16:1;                                     /* PSR42_16         */
    uint32 PSR42_17:1;                                     /* PSR42_17         */
    uint32 PSR42_18:1;                                     /* PSR42_18         */
    uint32 PSR42_19:1;                                     /* PSR42_19         */
    uint32 PSR42_20:1;                                     /* PSR42_20         */
    uint32 PSR42_21:1;                                     /* PSR42_21         */
    uint32 PSR42_22:1;                                     /* PSR42_22         */
    uint32 PSR42_23:1;                                     /* PSR42_23         */
    uint32 PSR42_24:1;                                     /* PSR42_24         */
    uint32 PSR42_25:1;                                     /* PSR42_25         */
    uint32 PSR42_26:1;                                     /* PSR42_26         */
    uint32 PSR42_27:1;                                     /* PSR42_27         */
    uint32 PSR42_28:1;                                     /* PSR42_28         */
    uint32 PSR42_29:1;                                     /* PSR42_29         */
    uint32 PSR42_30:1;                                     /* PSR42_30         */
    uint32 PSR42_31:1;                                     /* PSR42_31         */
} __type561;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PNOT42_0:1;                                     /* PNOT42_0         */
    uint16 PNOT42_1:1;                                     /* PNOT42_1         */
    uint16 PNOT42_2:1;                                     /* PNOT42_2         */
    uint16 PNOT42_3:1;                                     /* PNOT42_3         */
    uint16 PNOT42_4:1;                                     /* PNOT42_4         */
    uint16 PNOT42_5:1;                                     /* PNOT42_5         */
    uint16 PNOT42_6:1;                                     /* PNOT42_6         */
    uint16 PNOT42_7:1;                                     /* PNOT42_7         */
    uint16 PNOT42_8:1;                                     /* PNOT42_8         */
    uint16 PNOT42_9:1;                                     /* PNOT42_9         */
    uint16 PNOT42_10:1;                                    /* PNOT42_10        */
    uint16 PNOT42_11:1;                                    /* PNOT42_11        */
    uint16 PNOT42_12:1;                                    /* PNOT42_12        */
    uint16 PNOT42_13:1;                                    /* PNOT42_13        */
    uint16 PNOT42_14:1;                                    /* PNOT42_14        */
    uint16 PNOT42_15:1;                                    /* PNOT42_15        */
} __type562;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PPR42_0:1;                                      /* PPR42_0          */
    uint16 PPR42_1:1;                                      /* PPR42_1          */
    uint16 PPR42_2:1;                                      /* PPR42_2          */
    uint16 PPR42_3:1;                                      /* PPR42_3          */
    uint16 PPR42_4:1;                                      /* PPR42_4          */
    uint16 PPR42_5:1;                                      /* PPR42_5          */
    uint16 PPR42_6:1;                                      /* PPR42_6          */
    uint16 PPR42_7:1;                                      /* PPR42_7          */
    uint16 PPR42_8:1;                                      /* PPR42_8          */
    uint16 PPR42_9:1;                                      /* PPR42_9          */
    uint16 PPR42_10:1;                                     /* PPR42_10         */
    uint16 PPR42_11:1;                                     /* PPR42_11         */
    uint16 PPR42_12:1;                                     /* PPR42_12         */
    uint16 PPR42_13:1;                                     /* PPR42_13         */
    uint16 PPR42_14:1;                                     /* PPR42_14         */
    uint16 PPR42_15:1;                                     /* PPR42_15         */
} __type563;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PM42_0:1;                                       /* PM42_0           */
    uint16 PM42_1:1;                                       /* PM42_1           */
    uint16 PM42_2:1;                                       /* PM42_2           */
    uint16 PM42_3:1;                                       /* PM42_3           */
    uint16 PM42_4:1;                                       /* PM42_4           */
    uint16 PM42_5:1;                                       /* PM42_5           */
    uint16 PM42_6:1;                                       /* PM42_6           */
    uint16 PM42_7:1;                                       /* PM42_7           */
    uint16 PM42_8:1;                                       /* PM42_8           */
    uint16 PM42_9:1;                                       /* PM42_9           */
    uint16 PM42_10:1;                                      /* PM42_10          */
    uint16 PM42_11:1;                                      /* PM42_11          */
    uint16 PM42_12:1;                                      /* PM42_12          */
    uint16 PM42_13:1;                                      /* PM42_13          */
    uint16 PM42_14:1;                                      /* PM42_14          */
    uint16 PM42_15:1;                                      /* PM42_15          */
} __type564;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PMC42_0:1;                                      /* PMC42_0          */
    uint16 PMC42_1:1;                                      /* PMC42_1          */
    uint16 PMC42_2:1;                                      /* PMC42_2          */
    uint16 PMC42_3:1;                                      /* PMC42_3          */
    uint16 PMC42_4:1;                                      /* PMC42_4          */
    uint16 PMC42_5:1;                                      /* PMC42_5          */
    uint16 PMC42_6:1;                                      /* PMC42_6          */
    uint16 PMC42_7:1;                                      /* PMC42_7          */
    uint16 PMC42_8:1;                                      /* PMC42_8          */
    uint16 PMC42_9:1;                                      /* PMC42_9          */
    uint16 PMC42_10:1;                                     /* PMC42_10         */
    uint16 PMC42_11:1;                                     /* PMC42_11         */
    uint16 PMC42_12:1;                                     /* PMC42_12         */
    uint16 PMC42_13:1;                                     /* PMC42_13         */
    uint16 PMC42_14:1;                                     /* PMC42_14         */
    uint16 PMC42_15:1;                                     /* PMC42_15         */
} __type565;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PFC42_0:1;                                      /* PFC42_0          */
    uint16 PFC42_1:1;                                      /* PFC42_1          */
    uint16 PFC42_2:1;                                      /* PFC42_2          */
    uint16 PFC42_3:1;                                      /* PFC42_3          */
    uint16 PFC42_4:1;                                      /* PFC42_4          */
    uint16 PFC42_5:1;                                      /* PFC42_5          */
    uint16 PFC42_6:1;                                      /* PFC42_6          */
    uint16 PFC42_7:1;                                      /* PFC42_7          */
    uint16 PFC42_8:1;                                      /* PFC42_8          */
    uint16 PFC42_9:1;                                      /* PFC42_9          */
    uint16 PFC42_10:1;                                     /* PFC42_10         */
    uint16 PFC42_11:1;                                     /* PFC42_11         */
    uint16 PFC42_12:1;                                     /* PFC42_12         */
    uint16 PFC42_13:1;                                     /* PFC42_13         */
    uint16 PFC42_14:1;                                     /* PFC42_14         */
    uint16 PFC42_15:1;                                     /* PFC42_15         */
} __type566;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PFCE42_0:1;                                     /* PFCE42_0         */
    uint16 PFCE42_1:1;                                     /* PFCE42_1         */
    uint16 PFCE42_2:1;                                     /* PFCE42_2         */
    uint16 PFCE42_3:1;                                     /* PFCE42_3         */
    uint16 PFCE42_4:1;                                     /* PFCE42_4         */
    uint16 PFCE42_5:1;                                     /* PFCE42_5         */
    uint16 PFCE42_6:1;                                     /* PFCE42_6         */
    uint16 PFCE42_7:1;                                     /* PFCE42_7         */
    uint16 PFCE42_8:1;                                     /* PFCE42_8         */
    uint16 PFCE42_9:1;                                     /* PFCE42_9         */
    uint16 PFCE42_10:1;                                    /* PFCE42_10        */
    uint16 PFCE42_11:1;                                    /* PFCE42_11        */
    uint16 PFCE42_12:1;                                    /* PFCE42_12        */
    uint16 PFCE42_13:1;                                    /* PFCE42_13        */
    uint16 PFCE42_14:1;                                    /* PFCE42_14        */
    uint16 PFCE42_15:1;                                    /* PFCE42_15        */
} __type567;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PMSR42_0:1;                                     /* PMSR42_0         */
    uint32 PMSR42_1:1;                                     /* PMSR42_1         */
    uint32 PMSR42_2:1;                                     /* PMSR42_2         */
    uint32 PMSR42_3:1;                                     /* PMSR42_3         */
    uint32 PMSR42_4:1;                                     /* PMSR42_4         */
    uint32 PMSR42_5:1;                                     /* PMSR42_5         */
    uint32 PMSR42_6:1;                                     /* PMSR42_6         */
    uint32 PMSR42_7:1;                                     /* PMSR42_7         */
    uint32 PMSR42_8:1;                                     /* PMSR42_8         */
    uint32 PMSR42_9:1;                                     /* PMSR42_9         */
    uint32 PMSR42_10:1;                                    /* PMSR42_10        */
    uint32 PMSR42_11:1;                                    /* PMSR42_11        */
    uint32 PMSR42_12:1;                                    /* PMSR42_12        */
    uint32 PMSR42_13:1;                                    /* PMSR42_13        */
    uint32 PMSR42_14:1;                                    /* PMSR42_14        */
    uint32 PMSR42_15:1;                                    /* PMSR42_15        */
    uint32 PMSR42_16:1;                                    /* PMSR42_16        */
    uint32 PMSR42_17:1;                                    /* PMSR42_17        */
    uint32 PMSR42_18:1;                                    /* PMSR42_18        */
    uint32 PMSR42_19:1;                                    /* PMSR42_19        */
    uint32 PMSR42_20:1;                                    /* PMSR42_20        */
    uint32 PMSR42_21:1;                                    /* PMSR42_21        */
    uint32 PMSR42_22:1;                                    /* PMSR42_22        */
    uint32 PMSR42_23:1;                                    /* PMSR42_23        */
    uint32 PMSR42_24:1;                                    /* PMSR42_24        */
    uint32 PMSR42_25:1;                                    /* PMSR42_25        */
    uint32 PMSR42_26:1;                                    /* PMSR42_26        */
    uint32 PMSR42_27:1;                                    /* PMSR42_27        */
    uint32 PMSR42_28:1;                                    /* PMSR42_28        */
    uint32 PMSR42_29:1;                                    /* PMSR42_29        */
    uint32 PMSR42_30:1;                                    /* PMSR42_30        */
    uint32 PMSR42_31:1;                                    /* PMSR42_31        */
} __type568;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PMCSR42_0:1;                                    /* PMCSR42_0        */
    uint32 PMCSR42_1:1;                                    /* PMCSR42_1        */
    uint32 PMCSR42_2:1;                                    /* PMCSR42_2        */
    uint32 PMCSR42_3:1;                                    /* PMCSR42_3        */
    uint32 PMCSR42_4:1;                                    /* PMCSR42_4        */
    uint32 PMCSR42_5:1;                                    /* PMCSR42_5        */
    uint32 PMCSR42_6:1;                                    /* PMCSR42_6        */
    uint32 PMCSR42_7:1;                                    /* PMCSR42_7        */
    uint32 PMCSR42_8:1;                                    /* PMCSR42_8        */
    uint32 PMCSR42_9:1;                                    /* PMCSR42_9        */
    uint32 PMCSR42_10:1;                                   /* PMCSR42_10       */
    uint32 PMCSR42_11:1;                                   /* PMCSR42_11       */
    uint32 PMCSR42_12:1;                                   /* PMCSR42_12       */
    uint32 PMCSR42_13:1;                                   /* PMCSR42_13       */
    uint32 PMCSR42_14:1;                                   /* PMCSR42_14       */
    uint32 PMCSR42_15:1;                                   /* PMCSR42_15       */
    uint32 PMCSR42_16:1;                                   /* PMCSR42_16       */
    uint32 PMCSR42_17:1;                                   /* PMCSR42_17       */
    uint32 PMCSR42_18:1;                                   /* PMCSR42_18       */
    uint32 PMCSR42_19:1;                                   /* PMCSR42_19       */
    uint32 PMCSR42_20:1;                                   /* PMCSR42_20       */
    uint32 PMCSR42_21:1;                                   /* PMCSR42_21       */
    uint32 PMCSR42_22:1;                                   /* PMCSR42_22       */
    uint32 PMCSR42_23:1;                                   /* PMCSR42_23       */
    uint32 PMCSR42_24:1;                                   /* PMCSR42_24       */
    uint32 PMCSR42_25:1;                                   /* PMCSR42_25       */
    uint32 PMCSR42_26:1;                                   /* PMCSR42_26       */
    uint32 PMCSR42_27:1;                                   /* PMCSR42_27       */
    uint32 PMCSR42_28:1;                                   /* PMCSR42_28       */
    uint32 PMCSR42_29:1;                                   /* PMCSR42_29       */
    uint32 PMCSR42_30:1;                                   /* PMCSR42_30       */
    uint32 PMCSR42_31:1;                                   /* PMCSR42_31       */
} __type569;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PFCAE42_0:1;                                    /* PFCAE42_0        */
    uint16 PFCAE42_1:1;                                    /* PFCAE42_1        */
    uint16 PFCAE42_2:1;                                    /* PFCAE42_2        */
    uint16 PFCAE42_3:1;                                    /* PFCAE42_3        */
    uint16 PFCAE42_4:1;                                    /* PFCAE42_4        */
    uint16 PFCAE42_5:1;                                    /* PFCAE42_5        */
    uint16 PFCAE42_6:1;                                    /* PFCAE42_6        */
    uint16 PFCAE42_7:1;                                    /* PFCAE42_7        */
    uint16 PFCAE42_8:1;                                    /* PFCAE42_8        */
    uint16 PFCAE42_9:1;                                    /* PFCAE42_9        */
    uint16 PFCAE42_10:1;                                   /* PFCAE42_10       */
    uint16 PFCAE42_11:1;                                   /* PFCAE42_11       */
    uint16 PFCAE42_12:1;                                   /* PFCAE42_12       */
    uint16 PFCAE42_13:1;                                   /* PFCAE42_13       */
    uint16 PFCAE42_14:1;                                   /* PFCAE42_14       */
    uint16 PFCAE42_15:1;                                   /* PFCAE42_15       */
} __type570;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PINV42_0:1;                                     /* PINV42_0         */
    uint16 PINV42_1:1;                                     /* PINV42_1         */
    uint16 PINV42_2:1;                                     /* PINV42_2         */
    uint16 PINV42_3:1;                                     /* PINV42_3         */
    uint16 PINV42_4:1;                                     /* PINV42_4         */
    uint16 PINV42_5:1;                                     /* PINV42_5         */
    uint16 PINV42_6:1;                                     /* PINV42_6         */
    uint16 PINV42_7:1;                                     /* PINV42_7         */
    uint16 PINV42_8:1;                                     /* PINV42_8         */
    uint16 PINV42_9:1;                                     /* PINV42_9         */
    uint16 PINV42_10:1;                                    /* PINV42_10        */
    uint16 PINV42_11:1;                                    /* PINV42_11        */
    uint16 PINV42_12:1;                                    /* PINV42_12        */
    uint16 PINV42_13:1;                                    /* PINV42_13        */
    uint16 PINV42_14:1;                                    /* PINV42_14        */
    uint16 PINV42_15:1;                                    /* PINV42_15        */
} __type571;
typedef struct 
{                                                          /* Bit Access       */
    uint16 P43_0:1;                                        /* P43_0            */
    uint16 P43_1:1;                                        /* P43_1            */
    uint16 :14;                                            /* Reserved Bits    */
} __type572;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PSR43_0:1;                                      /* PSR43_0          */
    uint32 PSR43_1:1;                                      /* PSR43_1          */
    uint32 :14;                                            /* Reserved Bits    */
    uint32 PSR43_16:1;                                     /* PSR43_16         */
    uint32 PSR43_17:1;                                     /* PSR43_17         */
    uint32 :14;                                            /* Reserved Bits    */
} __type573;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PNOT43_0:1;                                     /* PNOT43_0         */
    uint16 PNOT43_1:1;                                     /* PNOT43_1         */
    uint16 :14;                                            /* Reserved Bits    */
} __type574;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PPR43_0:1;                                      /* PPR43_0          */
    uint16 PPR43_1:1;                                      /* PPR43_1          */
    uint16 :14;                                            /* Reserved Bits    */
} __type575;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PM43_0:1;                                       /* PM43_0           */
    uint16 PM43_1:1;                                       /* PM43_1           */
    uint16 :14;                                            /* Reserved Bits    */
} __type576;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PMC43_0:1;                                      /* PMC43_0          */
    uint16 PMC43_1:1;                                      /* PMC43_1          */
    uint16 :14;                                            /* Reserved Bits    */
} __type577;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PFC43_0:1;                                      /* PFC43_0          */
    uint16 :15;                                            /* Reserved Bits    */
} __type578;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PMSR43_0:1;                                     /* PMSR43_0         */
    uint32 PMSR43_1:1;                                     /* PMSR43_1         */
    uint32 :14;                                            /* Reserved Bits    */
    uint32 PMSR43_16:1;                                    /* PMSR43_16        */
    uint32 PMSR43_17:1;                                    /* PMSR43_17        */
    uint32 :14;                                            /* Reserved Bits    */
} __type579;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PMCSR43_0:1;                                    /* PMCSR43_0        */
    uint32 PMCSR43_1:1;                                    /* PMCSR43_1        */
    uint32 :14;                                            /* Reserved Bits    */
    uint32 PMCSR43_16:1;                                   /* PMCSR43_16       */
    uint32 PMCSR43_17:1;                                   /* PMCSR43_17       */
    uint32 :14;                                            /* Reserved Bits    */
} __type580;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PINV43_0:1;                                     /* PINV43_0         */
    uint16 PINV43_1:1;                                     /* PINV43_1         */
    uint16 :14;                                            /* Reserved Bits    */
} __type581;
typedef struct 
{                                                          /* Bit Access       */
    uint16 P44_0:1;                                        /* P44_0            */
    uint16 P44_1:1;                                        /* P44_1            */
    uint16 P44_2:1;                                        /* P44_2            */
    uint16 P44_3:1;                                        /* P44_3            */
    uint16 P44_4:1;                                        /* P44_4            */
    uint16 P44_5:1;                                        /* P44_5            */
    uint16 P44_6:1;                                        /* P44_6            */
    uint16 P44_7:1;                                        /* P44_7            */
    uint16 P44_8:1;                                        /* P44_8            */
    uint16 P44_9:1;                                        /* P44_9            */
    uint16 P44_10:1;                                       /* P44_10           */
    uint16 P44_11:1;                                       /* P44_11           */
    uint16 :4;                                             /* Reserved Bits    */
} __type582;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PSR44_0:1;                                      /* PSR44_0          */
    uint32 PSR44_1:1;                                      /* PSR44_1          */
    uint32 PSR44_2:1;                                      /* PSR44_2          */
    uint32 PSR44_3:1;                                      /* PSR44_3          */
    uint32 PSR44_4:1;                                      /* PSR44_4          */
    uint32 PSR44_5:1;                                      /* PSR44_5          */
    uint32 PSR44_6:1;                                      /* PSR44_6          */
    uint32 PSR44_7:1;                                      /* PSR44_7          */
    uint32 PSR44_8:1;                                      /* PSR44_8          */
    uint32 PSR44_9:1;                                      /* PSR44_9          */
    uint32 PSR44_10:1;                                     /* PSR44_10         */
    uint32 PSR44_11:1;                                     /* PSR44_11         */
    uint32 :4;                                             /* Reserved Bits    */
    uint32 PSR44_16:1;                                     /* PSR44_16         */
    uint32 PSR44_17:1;                                     /* PSR44_17         */
    uint32 PSR44_18:1;                                     /* PSR44_18         */
    uint32 PSR44_19:1;                                     /* PSR44_19         */
    uint32 PSR44_20:1;                                     /* PSR44_20         */
    uint32 PSR44_21:1;                                     /* PSR44_21         */
    uint32 PSR44_22:1;                                     /* PSR44_22         */
    uint32 PSR44_23:1;                                     /* PSR44_23         */
    uint32 PSR44_24:1;                                     /* PSR44_24         */
    uint32 PSR44_25:1;                                     /* PSR44_25         */
    uint32 PSR44_26:1;                                     /* PSR44_26         */
    uint32 PSR44_27:1;                                     /* PSR44_27         */
    uint32 :4;                                             /* Reserved Bits    */
} __type583;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PNOT44_0:1;                                     /* PNOT44_0         */
    uint16 PNOT44_1:1;                                     /* PNOT44_1         */
    uint16 PNOT44_2:1;                                     /* PNOT44_2         */
    uint16 PNOT44_3:1;                                     /* PNOT44_3         */
    uint16 PNOT44_4:1;                                     /* PNOT44_4         */
    uint16 PNOT44_5:1;                                     /* PNOT44_5         */
    uint16 PNOT44_6:1;                                     /* PNOT44_6         */
    uint16 PNOT44_7:1;                                     /* PNOT44_7         */
    uint16 PNOT44_8:1;                                     /* PNOT44_8         */
    uint16 PNOT44_9:1;                                     /* PNOT44_9         */
    uint16 PNOT44_10:1;                                    /* PNOT44_10        */
    uint16 PNOT44_11:1;                                    /* PNOT44_11        */
    uint16 :4;                                             /* Reserved Bits    */
} __type584;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PPR44_0:1;                                      /* PPR44_0          */
    uint16 PPR44_1:1;                                      /* PPR44_1          */
    uint16 PPR44_2:1;                                      /* PPR44_2          */
    uint16 PPR44_3:1;                                      /* PPR44_3          */
    uint16 PPR44_4:1;                                      /* PPR44_4          */
    uint16 PPR44_5:1;                                      /* PPR44_5          */
    uint16 PPR44_6:1;                                      /* PPR44_6          */
    uint16 PPR44_7:1;                                      /* PPR44_7          */
    uint16 PPR44_8:1;                                      /* PPR44_8          */
    uint16 PPR44_9:1;                                      /* PPR44_9          */
    uint16 PPR44_10:1;                                     /* PPR44_10         */
    uint16 PPR44_11:1;                                     /* PPR44_11         */
    uint16 :4;                                             /* Reserved Bits    */
} __type585;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PM44_0:1;                                       /* PM44_0           */
    uint16 PM44_1:1;                                       /* PM44_1           */
    uint16 PM44_2:1;                                       /* PM44_2           */
    uint16 PM44_3:1;                                       /* PM44_3           */
    uint16 PM44_4:1;                                       /* PM44_4           */
    uint16 PM44_5:1;                                       /* PM44_5           */
    uint16 PM44_6:1;                                       /* PM44_6           */
    uint16 PM44_7:1;                                       /* PM44_7           */
    uint16 PM44_8:1;                                       /* PM44_8           */
    uint16 PM44_9:1;                                       /* PM44_9           */
    uint16 PM44_10:1;                                      /* PM44_10          */
    uint16 PM44_11:1;                                      /* PM44_11          */
    uint16 :4;                                             /* Reserved Bits    */
} __type586;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PMC44_0:1;                                      /* PMC44_0          */
    uint16 PMC44_1:1;                                      /* PMC44_1          */
    uint16 PMC44_2:1;                                      /* PMC44_2          */
    uint16 PMC44_3:1;                                      /* PMC44_3          */
    uint16 PMC44_4:1;                                      /* PMC44_4          */
    uint16 PMC44_5:1;                                      /* PMC44_5          */
    uint16 PMC44_6:1;                                      /* PMC44_6          */
    uint16 PMC44_7:1;                                      /* PMC44_7          */
    uint16 PMC44_8:1;                                      /* PMC44_8          */
    uint16 PMC44_9:1;                                      /* PMC44_9          */
    uint16 PMC44_10:1;                                     /* PMC44_10         */
    uint16 PMC44_11:1;                                     /* PMC44_11         */
    uint16 :4;                                             /* Reserved Bits    */
} __type587;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PFC44_0:1;                                      /* PFC44_0          */
    uint16 PFC44_1:1;                                      /* PFC44_1          */
    uint16 PFC44_2:1;                                      /* PFC44_2          */
    uint16 PFC44_3:1;                                      /* PFC44_3          */
    uint16 PFC44_4:1;                                      /* PFC44_4          */
    uint16 PFC44_5:1;                                      /* PFC44_5          */
    uint16 PFC44_6:1;                                      /* PFC44_6          */
    uint16 PFC44_7:1;                                      /* PFC44_7          */
    uint16 PFC44_8:1;                                      /* PFC44_8          */
    uint16 PFC44_9:1;                                      /* PFC44_9          */
    uint16 PFC44_10:1;                                     /* PFC44_10         */
    uint16 PFC44_11:1;                                     /* PFC44_11         */
    uint16 :4;                                             /* Reserved Bits    */
} __type588;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PFCE44_0:1;                                     /* PFCE44_0         */
    uint16 PFCE44_1:1;                                     /* PFCE44_1         */
    uint16 PFCE44_2:1;                                     /* PFCE44_2         */
    uint16 PFCE44_3:1;                                     /* PFCE44_3         */
    uint16 PFCE44_4:1;                                     /* PFCE44_4         */
    uint16 PFCE44_5:1;                                     /* PFCE44_5         */
    uint16 PFCE44_6:1;                                     /* PFCE44_6         */
    uint16 PFCE44_7:1;                                     /* PFCE44_7         */
    uint16 PFCE44_8:1;                                     /* PFCE44_8         */
    uint16 PFCE44_9:1;                                     /* PFCE44_9         */
    uint16 PFCE44_10:1;                                    /* PFCE44_10        */
    uint16 PFCE44_11:1;                                    /* PFCE44_11        */
    uint16 :4;                                             /* Reserved Bits    */
} __type589;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PMSR44_0:1;                                     /* PMSR44_0         */
    uint32 PMSR44_1:1;                                     /* PMSR44_1         */
    uint32 PMSR44_2:1;                                     /* PMSR44_2         */
    uint32 PMSR44_3:1;                                     /* PMSR44_3         */
    uint32 PMSR44_4:1;                                     /* PMSR44_4         */
    uint32 PMSR44_5:1;                                     /* PMSR44_5         */
    uint32 PMSR44_6:1;                                     /* PMSR44_6         */
    uint32 PMSR44_7:1;                                     /* PMSR44_7         */
    uint32 PMSR44_8:1;                                     /* PMSR44_8         */
    uint32 PMSR44_9:1;                                     /* PMSR44_9         */
    uint32 PMSR44_10:1;                                    /* PMSR44_10        */
    uint32 PMSR44_11:1;                                    /* PMSR44_11        */
    uint32 :4;                                             /* Reserved Bits    */
    uint32 PMSR44_16:1;                                    /* PMSR44_16        */
    uint32 PMSR44_17:1;                                    /* PMSR44_17        */
    uint32 PMSR44_18:1;                                    /* PMSR44_18        */
    uint32 PMSR44_19:1;                                    /* PMSR44_19        */
    uint32 PMSR44_20:1;                                    /* PMSR44_20        */
    uint32 PMSR44_21:1;                                    /* PMSR44_21        */
    uint32 PMSR44_22:1;                                    /* PMSR44_22        */
    uint32 PMSR44_23:1;                                    /* PMSR44_23        */
    uint32 PMSR44_24:1;                                    /* PMSR44_24        */
    uint32 PMSR44_25:1;                                    /* PMSR44_25        */
    uint32 PMSR44_26:1;                                    /* PMSR44_26        */
    uint32 PMSR44_27:1;                                    /* PMSR44_27        */
    uint32 :4;                                             /* Reserved Bits    */
} __type590;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PMCSR44_0:1;                                    /* PMCSR44_0        */
    uint32 PMCSR44_1:1;                                    /* PMCSR44_1        */
    uint32 PMCSR44_2:1;                                    /* PMCSR44_2        */
    uint32 PMCSR44_3:1;                                    /* PMCSR44_3        */
    uint32 PMCSR44_4:1;                                    /* PMCSR44_4        */
    uint32 PMCSR44_5:1;                                    /* PMCSR44_5        */
    uint32 PMCSR44_6:1;                                    /* PMCSR44_6        */
    uint32 PMCSR44_7:1;                                    /* PMCSR44_7        */
    uint32 PMCSR44_8:1;                                    /* PMCSR44_8        */
    uint32 PMCSR44_9:1;                                    /* PMCSR44_9        */
    uint32 PMCSR44_10:1;                                   /* PMCSR44_10       */
    uint32 PMCSR44_11:1;                                   /* PMCSR44_11       */
    uint32 :4;                                             /* Reserved Bits    */
    uint32 PMCSR44_16:1;                                   /* PMCSR44_16       */
    uint32 PMCSR44_17:1;                                   /* PMCSR44_17       */
    uint32 PMCSR44_18:1;                                   /* PMCSR44_18       */
    uint32 PMCSR44_19:1;                                   /* PMCSR44_19       */
    uint32 PMCSR44_20:1;                                   /* PMCSR44_20       */
    uint32 PMCSR44_21:1;                                   /* PMCSR44_21       */
    uint32 PMCSR44_22:1;                                   /* PMCSR44_22       */
    uint32 PMCSR44_23:1;                                   /* PMCSR44_23       */
    uint32 PMCSR44_24:1;                                   /* PMCSR44_24       */
    uint32 PMCSR44_25:1;                                   /* PMCSR44_25       */
    uint32 PMCSR44_26:1;                                   /* PMCSR44_26       */
    uint32 PMCSR44_27:1;                                   /* PMCSR44_27       */
    uint32 :4;                                             /* Reserved Bits    */
} __type591;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PINV44_0:1;                                     /* PINV44_0         */
    uint16 PINV44_1:1;                                     /* PINV44_1         */
    uint16 PINV44_2:1;                                     /* PINV44_2         */
    uint16 PINV44_3:1;                                     /* PINV44_3         */
    uint16 PINV44_4:1;                                     /* PINV44_4         */
    uint16 PINV44_5:1;                                     /* PINV44_5         */
    uint16 PINV44_6:1;                                     /* PINV44_6         */
    uint16 PINV44_7:1;                                     /* PINV44_7         */
    uint16 PINV44_8:1;                                     /* PINV44_8         */
    uint16 PINV44_9:1;                                     /* PINV44_9         */
    uint16 PINV44_10:1;                                    /* PINV44_10        */
    uint16 PINV44_11:1;                                    /* PINV44_11        */
    uint16 :4;                                             /* Reserved Bits    */
} __type592;
typedef struct 
{                                                          /* Bit Access       */
    uint16 P45_0:1;                                        /* P45_0            */
    uint16 P45_1:1;                                        /* P45_1            */
    uint16 P45_2:1;                                        /* P45_2            */
    uint16 P45_3:1;                                        /* P45_3            */
    uint16 P45_4:1;                                        /* P45_4            */
    uint16 P45_5:1;                                        /* P45_5            */
    uint16 P45_6:1;                                        /* P45_6            */
    uint16 P45_7:1;                                        /* P45_7            */
    uint16 P45_8:1;                                        /* P45_8            */
    uint16 P45_9:1;                                        /* P45_9            */
    uint16 P45_10:1;                                       /* P45_10           */
    uint16 P45_11:1;                                       /* P45_11           */
    uint16 P45_12:1;                                       /* P45_12           */
    uint16 P45_13:1;                                       /* P45_13           */
    uint16 :2;                                             /* Reserved Bits    */
} __type593;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PSR45_0:1;                                      /* PSR45_0          */
    uint32 PSR45_1:1;                                      /* PSR45_1          */
    uint32 PSR45_2:1;                                      /* PSR45_2          */
    uint32 PSR45_3:1;                                      /* PSR45_3          */
    uint32 PSR45_4:1;                                      /* PSR45_4          */
    uint32 PSR45_5:1;                                      /* PSR45_5          */
    uint32 PSR45_6:1;                                      /* PSR45_6          */
    uint32 PSR45_7:1;                                      /* PSR45_7          */
    uint32 PSR45_8:1;                                      /* PSR45_8          */
    uint32 PSR45_9:1;                                      /* PSR45_9          */
    uint32 PSR45_10:1;                                     /* PSR45_10         */
    uint32 PSR45_11:1;                                     /* PSR45_11         */
    uint32 PSR45_12:1;                                     /* PSR45_12         */
    uint32 PSR45_13:1;                                     /* PSR45_13         */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 PSR45_16:1;                                     /* PSR45_16         */
    uint32 PSR45_17:1;                                     /* PSR45_17         */
    uint32 PSR45_18:1;                                     /* PSR45_18         */
    uint32 PSR45_19:1;                                     /* PSR45_19         */
    uint32 PSR45_20:1;                                     /* PSR45_20         */
    uint32 PSR45_21:1;                                     /* PSR45_21         */
    uint32 PSR45_22:1;                                     /* PSR45_22         */
    uint32 PSR45_23:1;                                     /* PSR45_23         */
    uint32 PSR45_24:1;                                     /* PSR45_24         */
    uint32 PSR45_25:1;                                     /* PSR45_25         */
    uint32 PSR45_26:1;                                     /* PSR45_26         */
    uint32 PSR45_27:1;                                     /* PSR45_27         */
    uint32 PSR45_28:1;                                     /* PSR45_28         */
    uint32 PSR45_29:1;                                     /* PSR45_29         */
    uint32 :2;                                             /* Reserved Bits    */
} __type594;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PNOT45_0:1;                                     /* PNOT45_0         */
    uint16 PNOT45_1:1;                                     /* PNOT45_1         */
    uint16 PNOT45_2:1;                                     /* PNOT45_2         */
    uint16 PNOT45_3:1;                                     /* PNOT45_3         */
    uint16 PNOT45_4:1;                                     /* PNOT45_4         */
    uint16 PNOT45_5:1;                                     /* PNOT45_5         */
    uint16 PNOT45_6:1;                                     /* PNOT45_6         */
    uint16 PNOT45_7:1;                                     /* PNOT45_7         */
    uint16 PNOT45_8:1;                                     /* PNOT45_8         */
    uint16 PNOT45_9:1;                                     /* PNOT45_9         */
    uint16 PNOT45_10:1;                                    /* PNOT45_10        */
    uint16 PNOT45_11:1;                                    /* PNOT45_11        */
    uint16 PNOT45_12:1;                                    /* PNOT45_12        */
    uint16 PNOT45_13:1;                                    /* PNOT45_13        */
    uint16 :2;                                             /* Reserved Bits    */
} __type595;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PPR45_0:1;                                      /* PPR45_0          */
    uint16 PPR45_1:1;                                      /* PPR45_1          */
    uint16 PPR45_2:1;                                      /* PPR45_2          */
    uint16 PPR45_3:1;                                      /* PPR45_3          */
    uint16 PPR45_4:1;                                      /* PPR45_4          */
    uint16 PPR45_5:1;                                      /* PPR45_5          */
    uint16 PPR45_6:1;                                      /* PPR45_6          */
    uint16 PPR45_7:1;                                      /* PPR45_7          */
    uint16 PPR45_8:1;                                      /* PPR45_8          */
    uint16 PPR45_9:1;                                      /* PPR45_9          */
    uint16 PPR45_10:1;                                     /* PPR45_10         */
    uint16 PPR45_11:1;                                     /* PPR45_11         */
    uint16 PPR45_12:1;                                     /* PPR45_12         */
    uint16 PPR45_13:1;                                     /* PPR45_13         */
    uint16 :2;                                             /* Reserved Bits    */
} __type596;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PM45_0:1;                                       /* PM45_0           */
    uint16 PM45_1:1;                                       /* PM45_1           */
    uint16 PM45_2:1;                                       /* PM45_2           */
    uint16 PM45_3:1;                                       /* PM45_3           */
    uint16 PM45_4:1;                                       /* PM45_4           */
    uint16 PM45_5:1;                                       /* PM45_5           */
    uint16 PM45_6:1;                                       /* PM45_6           */
    uint16 PM45_7:1;                                       /* PM45_7           */
    uint16 PM45_8:1;                                       /* PM45_8           */
    uint16 PM45_9:1;                                       /* PM45_9           */
    uint16 PM45_10:1;                                      /* PM45_10          */
    uint16 PM45_11:1;                                      /* PM45_11          */
    uint16 PM45_12:1;                                      /* PM45_12          */
    uint16 PM45_13:1;                                      /* PM45_13          */
    uint16 :2;                                             /* Reserved Bits    */
} __type597;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PMC45_0:1;                                      /* PMC45_0          */
    uint16 PMC45_1:1;                                      /* PMC45_1          */
    uint16 PMC45_2:1;                                      /* PMC45_2          */
    uint16 PMC45_3:1;                                      /* PMC45_3          */
    uint16 PMC45_4:1;                                      /* PMC45_4          */
    uint16 PMC45_5:1;                                      /* PMC45_5          */
    uint16 PMC45_6:1;                                      /* PMC45_6          */
    uint16 PMC45_7:1;                                      /* PMC45_7          */
    uint16 PMC45_8:1;                                      /* PMC45_8          */
    uint16 PMC45_9:1;                                      /* PMC45_9          */
    uint16 PMC45_10:1;                                     /* PMC45_10         */
    uint16 PMC45_11:1;                                     /* PMC45_11         */
    uint16 PMC45_12:1;                                     /* PMC45_12         */
    uint16 PMC45_13:1;                                     /* PMC45_13         */
    uint16 :2;                                             /* Reserved Bits    */
} __type598;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PFC45_0:1;                                      /* PFC45_0          */
    uint16 PFC45_1:1;                                      /* PFC45_1          */
    uint16 PFC45_2:1;                                      /* PFC45_2          */
    uint16 PFC45_3:1;                                      /* PFC45_3          */
    uint16 PFC45_4:1;                                      /* PFC45_4          */
    uint16 PFC45_5:1;                                      /* PFC45_5          */
    uint16 PFC45_6:1;                                      /* PFC45_6          */
    uint16 PFC45_7:1;                                      /* PFC45_7          */
    uint16 PFC45_8:1;                                      /* PFC45_8          */
    uint16 PFC45_9:1;                                      /* PFC45_9          */
    uint16 PFC45_10:1;                                     /* PFC45_10         */
    uint16 PFC45_11:1;                                     /* PFC45_11         */
    uint16 PFC45_12:1;                                     /* PFC45_12         */
    uint16 PFC45_13:1;                                     /* PFC45_13         */
    uint16 :2;                                             /* Reserved Bits    */
} __type599;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PFCE45_0:1;                                     /* PFCE45_0         */
    uint16 PFCE45_1:1;                                     /* PFCE45_1         */
    uint16 PFCE45_2:1;                                     /* PFCE45_2         */
    uint16 PFCE45_3:1;                                     /* PFCE45_3         */
    uint16 PFCE45_4:1;                                     /* PFCE45_4         */
    uint16 PFCE45_5:1;                                     /* PFCE45_5         */
    uint16 PFCE45_6:1;                                     /* PFCE45_6         */
    uint16 PFCE45_7:1;                                     /* PFCE45_7         */
    uint16 PFCE45_8:1;                                     /* PFCE45_8         */
    uint16 PFCE45_9:1;                                     /* PFCE45_9         */
    uint16 PFCE45_10:1;                                    /* PFCE45_10        */
    uint16 PFCE45_11:1;                                    /* PFCE45_11        */
    uint16 PFCE45_12:1;                                    /* PFCE45_12        */
    uint16 PFCE45_13:1;                                    /* PFCE45_13        */
    uint16 :2;                                             /* Reserved Bits    */
} __type600;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PMSR45_0:1;                                     /* PMSR45_0         */
    uint32 PMSR45_1:1;                                     /* PMSR45_1         */
    uint32 PMSR45_2:1;                                     /* PMSR45_2         */
    uint32 PMSR45_3:1;                                     /* PMSR45_3         */
    uint32 PMSR45_4:1;                                     /* PMSR45_4         */
    uint32 PMSR45_5:1;                                     /* PMSR45_5         */
    uint32 PMSR45_6:1;                                     /* PMSR45_6         */
    uint32 PMSR45_7:1;                                     /* PMSR45_7         */
    uint32 PMSR45_8:1;                                     /* PMSR45_8         */
    uint32 PMSR45_9:1;                                     /* PMSR45_9         */
    uint32 PMSR45_10:1;                                    /* PMSR45_10        */
    uint32 PMSR45_11:1;                                    /* PMSR45_11        */
    uint32 PMSR45_12:1;                                    /* PMSR45_12        */
    uint32 PMSR45_13:1;                                    /* PMSR45_13        */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 PMSR45_16:1;                                    /* PMSR45_16        */
    uint32 PMSR45_17:1;                                    /* PMSR45_17        */
    uint32 PMSR45_18:1;                                    /* PMSR45_18        */
    uint32 PMSR45_19:1;                                    /* PMSR45_19        */
    uint32 PMSR45_20:1;                                    /* PMSR45_20        */
    uint32 PMSR45_21:1;                                    /* PMSR45_21        */
    uint32 PMSR45_22:1;                                    /* PMSR45_22        */
    uint32 PMSR45_23:1;                                    /* PMSR45_23        */
    uint32 PMSR45_24:1;                                    /* PMSR45_24        */
    uint32 PMSR45_25:1;                                    /* PMSR45_25        */
    uint32 PMSR45_26:1;                                    /* PMSR45_26        */
    uint32 PMSR45_27:1;                                    /* PMSR45_27        */
    uint32 PMSR45_28:1;                                    /* PMSR45_28        */
    uint32 PMSR45_29:1;                                    /* PMSR45_29        */
    uint32 :2;                                             /* Reserved Bits    */
} __type601;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PMCSR45_0:1;                                    /* PMCSR45_0        */
    uint32 PMCSR45_1:1;                                    /* PMCSR45_1        */
    uint32 PMCSR45_2:1;                                    /* PMCSR45_2        */
    uint32 PMCSR45_3:1;                                    /* PMCSR45_3        */
    uint32 PMCSR45_4:1;                                    /* PMCSR45_4        */
    uint32 PMCSR45_5:1;                                    /* PMCSR45_5        */
    uint32 PMCSR45_6:1;                                    /* PMCSR45_6        */
    uint32 PMCSR45_7:1;                                    /* PMCSR45_7        */
    uint32 PMCSR45_8:1;                                    /* PMCSR45_8        */
    uint32 PMCSR45_9:1;                                    /* PMCSR45_9        */
    uint32 PMCSR45_10:1;                                   /* PMCSR45_10       */
    uint32 PMCSR45_11:1;                                   /* PMCSR45_11       */
    uint32 PMCSR45_12:1;                                   /* PMCSR45_12       */
    uint32 PMCSR45_13:1;                                   /* PMCSR45_13       */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 PMCSR45_16:1;                                   /* PMCSR45_16       */
    uint32 PMCSR45_17:1;                                   /* PMCSR45_17       */
    uint32 PMCSR45_18:1;                                   /* PMCSR45_18       */
    uint32 PMCSR45_19:1;                                   /* PMCSR45_19       */
    uint32 PMCSR45_20:1;                                   /* PMCSR45_20       */
    uint32 PMCSR45_21:1;                                   /* PMCSR45_21       */
    uint32 PMCSR45_22:1;                                   /* PMCSR45_22       */
    uint32 PMCSR45_23:1;                                   /* PMCSR45_23       */
    uint32 PMCSR45_24:1;                                   /* PMCSR45_24       */
    uint32 PMCSR45_25:1;                                   /* PMCSR45_25       */
    uint32 PMCSR45_26:1;                                   /* PMCSR45_26       */
    uint32 PMCSR45_27:1;                                   /* PMCSR45_27       */
    uint32 PMCSR45_28:1;                                   /* PMCSR45_28       */
    uint32 PMCSR45_29:1;                                   /* PMCSR45_29       */
    uint32 :2;                                             /* Reserved Bits    */
} __type602;
typedef struct 
{                                                          /* Bit Access       */
    uint16 :13;                                            /* Reserved Bits    */
    uint16 PFCAE45_13:1;                                   /* PFCAE45_13       */
    uint16 :2;                                             /* Reserved Bits    */
} __type603;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PINV45_0:1;                                     /* PINV45_0         */
    uint16 PINV45_1:1;                                     /* PINV45_1         */
    uint16 PINV45_2:1;                                     /* PINV45_2         */
    uint16 PINV45_3:1;                                     /* PINV45_3         */
    uint16 PINV45_4:1;                                     /* PINV45_4         */
    uint16 PINV45_5:1;                                     /* PINV45_5         */
    uint16 PINV45_6:1;                                     /* PINV45_6         */
    uint16 PINV45_7:1;                                     /* PINV45_7         */
    uint16 PINV45_8:1;                                     /* PINV45_8         */
    uint16 PINV45_9:1;                                     /* PINV45_9         */
    uint16 PINV45_10:1;                                    /* PINV45_10        */
    uint16 PINV45_11:1;                                    /* PINV45_11        */
    uint16 PINV45_12:1;                                    /* PINV45_12        */
    uint16 PINV45_13:1;                                    /* PINV45_13        */
    uint16 :2;                                             /* Reserved Bits    */
} __type604;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PFC:1;                                          /* PFC              */
    uint32 PFCE:1;                                         /* PFCE             */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 PM:1;                                           /* PM               */
    uint32 PIPC:1;                                         /* PIPC             */
    uint32 PMC:1;                                          /* PMC              */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PPR:1;                                          /* PPR              */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 P:1;                                            /* P                */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PIBC:1;                                         /* PIBC             */
    uint32 PBDC:1;                                         /* PBDC             */
    uint32 PD:1;                                           /* PD               */
    uint32 PU:1;                                           /* PU               */
    uint32 PIS:1;                                          /* PIS              */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PISA:1;                                         /* PISA             */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PDSC:1;                                         /* PDSC             */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PODC:1;                                         /* PODC             */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PINV:1;                                         /* PINV             */
    uint32 :1;                                             /* Reserved Bits    */
} __type605;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PFC:1;                                          /* PFC              */
    uint32 PFCE:1;                                         /* PFCE             */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 PM:1;                                           /* PM               */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PMC:1;                                          /* PMC              */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PPR:1;                                          /* PPR              */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 P:1;                                            /* P                */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PIBC:1;                                         /* PIBC             */
    uint32 PBDC:1;                                         /* PBDC             */
    uint32 PD:1;                                           /* PD               */
    uint32 PU:1;                                           /* PU               */
    uint32 PIS:1;                                          /* PIS              */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PISA:1;                                         /* PISA             */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PDSC:1;                                         /* PDSC             */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PODC:1;                                         /* PODC             */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PINV:1;                                         /* PINV             */
    uint32 :1;                                             /* Reserved Bits    */
} __type606;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PFC:1;                                          /* PFC              */
    uint32 PFCE:1;                                         /* PFCE             */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 PM:1;                                           /* PM               */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PMC:1;                                          /* PMC              */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PPR:1;                                          /* PPR              */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 P:1;                                            /* P                */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PIBC:1;                                         /* PIBC             */
    uint32 PBDC:1;                                         /* PBDC             */
    uint32 :10;                                            /* Reserved Bits    */
    uint32 PODC:1;                                         /* PODC             */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PINV:1;                                         /* PINV             */
    uint32 :1;                                             /* Reserved Bits    */
} __type607;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PFC:1;                                          /* PFC              */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PM:1;                                           /* PM               */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PMC:1;                                          /* PMC              */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PPR:1;                                          /* PPR              */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 P:1;                                            /* P                */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PIBC:1;                                         /* PIBC             */
    uint32 PBDC:1;                                         /* PBDC             */
    uint32 :10;                                            /* Reserved Bits    */
    uint32 PODC:1;                                         /* PODC             */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PINV:1;                                         /* PINV             */
    uint32 :1;                                             /* Reserved Bits    */
} __type608;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PFC:1;                                          /* PFC              */
    uint32 PFCE:1;                                         /* PFCE             */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 PM:1;                                           /* PM               */
    uint32 PIPC:1;                                         /* PIPC             */
    uint32 PMC:1;                                          /* PMC              */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PPR:1;                                          /* PPR              */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 P:1;                                            /* P                */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PIBC:1;                                         /* PIBC             */
    uint32 PBDC:1;                                         /* PBDC             */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 PIS:1;                                          /* PIS              */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PISA:1;                                         /* PISA             */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PDSC:1;                                         /* PDSC             */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PODC:1;                                         /* PODC             */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PINV:1;                                         /* PINV             */
    uint32 :1;                                             /* Reserved Bits    */
} __type609;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PFC:1;                                          /* PFC              */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PM:1;                                           /* PM               */
    uint32 PIPC:1;                                         /* PIPC             */
    uint32 PMC:1;                                          /* PMC              */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PPR:1;                                          /* PPR              */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 P:1;                                            /* P                */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PIBC:1;                                         /* PIBC             */
    uint32 PBDC:1;                                         /* PBDC             */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 PIS:1;                                          /* PIS              */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PISA:1;                                         /* PISA             */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PDSC:1;                                         /* PDSC             */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PODC:1;                                         /* PODC             */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PINV:1;                                         /* PINV             */
    uint32 :1;                                             /* Reserved Bits    */
} __type610;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PFC:1;                                          /* PFC              */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PM:1;                                           /* PM               */
    uint32 PIPC:1;                                         /* PIPC             */
    uint32 PMC:1;                                          /* PMC              */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PPR:1;                                          /* PPR              */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 P:1;                                            /* P                */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PIBC:1;                                         /* PIBC             */
    uint32 PBDC:1;                                         /* PBDC             */
    uint32 PD:1;                                           /* PD               */
    uint32 PU:1;                                           /* PU               */
    uint32 :8;                                             /* Reserved Bits    */
    uint32 PODC:1;                                         /* PODC             */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PINV:1;                                         /* PINV             */
    uint32 :1;                                             /* Reserved Bits    */
} __type611;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PFC:1;                                          /* PFC              */
    uint32 PFCE:1;                                         /* PFCE             */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 PM:1;                                           /* PM               */
    uint32 PIPC:1;                                         /* PIPC             */
    uint32 PMC:1;                                          /* PMC              */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PPR:1;                                          /* PPR              */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 P:1;                                            /* P                */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PIBC:1;                                         /* PIBC             */
    uint32 PBDC:1;                                         /* PBDC             */
    uint32 PD:1;                                           /* PD               */
    uint32 PU:1;                                           /* PU               */
    uint32 :8;                                             /* Reserved Bits    */
    uint32 PODC:1;                                         /* PODC             */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PINV:1;                                         /* PINV             */
    uint32 :1;                                             /* Reserved Bits    */
} __type612;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PFC:1;                                          /* PFC              */
    uint32 PFCE:1;                                         /* PFCE             */
    uint32 PFCAE:1;                                        /* PFCAE            */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PM:1;                                           /* PM               */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PMC:1;                                          /* PMC              */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PPR:1;                                          /* PPR              */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 P:1;                                            /* P                */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PIBC:1;                                         /* PIBC             */
    uint32 PBDC:1;                                         /* PBDC             */
    uint32 PD:1;                                           /* PD               */
    uint32 PU:1;                                           /* PU               */
    uint32 PIS:1;                                          /* PIS              */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PISA:1;                                         /* PISA             */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PDSC:1;                                         /* PDSC             */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PODC:1;                                         /* PODC             */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PINV:1;                                         /* PINV             */
    uint32 :1;                                             /* Reserved Bits    */
} __type613;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PFC:1;                                          /* PFC              */
    uint32 PFCE:1;                                         /* PFCE             */
    uint32 PFCAE:1;                                        /* PFCAE            */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PM:1;                                           /* PM               */
    uint32 PIPC:1;                                         /* PIPC             */
    uint32 PMC:1;                                          /* PMC              */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PPR:1;                                          /* PPR              */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 P:1;                                            /* P                */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PIBC:1;                                         /* PIBC             */
    uint32 PBDC:1;                                         /* PBDC             */
    uint32 PD:1;                                           /* PD               */
    uint32 PU:1;                                           /* PU               */
    uint32 PIS:1;                                          /* PIS              */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PISA:1;                                         /* PISA             */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PDSC:1;                                         /* PDSC             */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PODC:1;                                         /* PODC             */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PINV:1;                                         /* PINV             */
    uint32 :1;                                             /* Reserved Bits    */
} __type614;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PFC:1;                                          /* PFC              */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PM:1;                                           /* PM               */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PMC:1;                                          /* PMC              */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PPR:1;                                          /* PPR              */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 P:1;                                            /* P                */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PIBC:1;                                         /* PIBC             */
    uint32 PBDC:1;                                         /* PBDC             */
    uint32 PD:1;                                           /* PD               */
    uint32 PU:1;                                           /* PU               */
    uint32 PIS:1;                                          /* PIS              */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PISA:1;                                         /* PISA             */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PDSC:1;                                         /* PDSC             */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PODC:1;                                         /* PODC             */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PINV:1;                                         /* PINV             */
    uint32 :1;                                             /* Reserved Bits    */
} __type615;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :4;                                             /* Reserved Bits    */
    uint32 PM:1;                                           /* PM               */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PMC:1;                                          /* PMC              */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PPR:1;                                          /* PPR              */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 P:1;                                            /* P                */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PIBC:1;                                         /* PIBC             */
    uint32 PBDC:1;                                         /* PBDC             */
    uint32 PD:1;                                           /* PD               */
    uint32 PU:1;                                           /* PU               */
    uint32 PIS:1;                                          /* PIS              */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PISA:1;                                         /* PISA             */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PDSC:1;                                         /* PDSC             */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PODC:1;                                         /* PODC             */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PINV:1;                                         /* PINV             */
    uint32 :1;                                             /* Reserved Bits    */
} __type616;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PIBC1_0:1;                                      /* PIBC1_0          */
    uint16 PIBC1_1:1;                                      /* PIBC1_1          */
    uint16 PIBC1_2:1;                                      /* PIBC1_2          */
    uint16 PIBC1_3:1;                                      /* PIBC1_3          */
    uint16 PIBC1_4:1;                                      /* PIBC1_4          */
    uint16 PIBC1_5:1;                                      /* PIBC1_5          */
    uint16 :10;                                            /* Reserved Bits    */
} __type617;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PBDC1_0:1;                                      /* PBDC1_0          */
    uint16 PBDC1_1:1;                                      /* PBDC1_1          */
    uint16 PBDC1_2:1;                                      /* PBDC1_2          */
    uint16 PBDC1_3:1;                                      /* PBDC1_3          */
    uint16 PBDC1_4:1;                                      /* PBDC1_4          */
    uint16 PBDC1_5:1;                                      /* PBDC1_5          */
    uint16 :10;                                            /* Reserved Bits    */
} __type618;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PIPC1_0:1;                                      /* PIPC1_0          */
    uint16 :1;                                             /* Reserved Bits    */
    uint16 PIPC1_2:1;                                      /* PIPC1_2          */
    uint16 PIPC1_3:1;                                      /* PIPC1_3          */
    uint16 :1;                                             /* Reserved Bits    */
    uint16 PIPC1_5:1;                                      /* PIPC1_5          */
    uint16 :10;                                            /* Reserved Bits    */
} __type619;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PU1_0:1;                                        /* PU1_0            */
    uint16 PU1_1:1;                                        /* PU1_1            */
    uint16 PU1_2:1;                                        /* PU1_2            */
    uint16 PU1_3:1;                                        /* PU1_3            */
    uint16 PU1_4:1;                                        /* PU1_4            */
    uint16 PU1_5:1;                                        /* PU1_5            */
    uint16 :10;                                            /* Reserved Bits    */
} __type620;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PD1_0:1;                                        /* PD1_0            */
    uint16 PD1_1:1;                                        /* PD1_1            */
    uint16 PD1_2:1;                                        /* PD1_2            */
    uint16 PD1_3:1;                                        /* PD1_3            */
    uint16 PD1_4:1;                                        /* PD1_4            */
    uint16 PD1_5:1;                                        /* PD1_5            */
    uint16 :10;                                            /* Reserved Bits    */
} __type621;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PODC1_0:1;                                      /* PODC1_0          */
    uint32 PODC1_1:1;                                      /* PODC1_1          */
    uint32 PODC1_2:1;                                      /* PODC1_2          */
    uint32 PODC1_3:1;                                      /* PODC1_3          */
    uint32 PODC1_4:1;                                      /* PODC1_4          */
    uint32 PODC1_5:1;                                      /* PODC1_5          */
    uint32 :26;                                            /* Reserved Bits    */
} __type622;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PDSC1_0:1;                                      /* PDSC1_0          */
    uint32 PDSC1_1:1;                                      /* PDSC1_1          */
    uint32 PDSC1_2:1;                                      /* PDSC1_2          */
    uint32 PDSC1_3:1;                                      /* PDSC1_3          */
    uint32 PDSC1_4:1;                                      /* PDSC1_4          */
    uint32 PDSC1_5:1;                                      /* PDSC1_5          */
    uint32 :26;                                            /* Reserved Bits    */
} __type623;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PIS1_0:1;                                       /* PIS1_0           */
    uint16 PIS1_1:1;                                       /* PIS1_1           */
    uint16 PIS1_2:1;                                       /* PIS1_2           */
    uint16 PIS1_3:1;                                       /* PIS1_3           */
    uint16 PIS1_4:1;                                       /* PIS1_4           */
    uint16 PIS1_5:1;                                       /* PIS1_5           */
    uint16 :10;                                            /* Reserved Bits    */
} __type624;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PISA1_0:1;                                      /* PISA1_0          */
    uint16 PISA1_1:1;                                      /* PISA1_1          */
    uint16 PISA1_2:1;                                      /* PISA1_2          */
    uint16 PISA1_3:1;                                      /* PISA1_3          */
    uint16 PISA1_4:1;                                      /* PISA1_4          */
    uint16 PISA1_5:1;                                      /* PISA1_5          */
    uint16 :10;                                            /* Reserved Bits    */
} __type625;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PPCMD1:8;                                       /* PPCMD1[7:0]      */
    uint32 :24;                                            /* Reserved Bits    */
} __type626;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PPROTS1PRERR:1;                                 /* PPROTS1PRERR     */
    uint32 :31;                                            /* Reserved Bits    */
} __type627;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PIBC3_0:1;                                      /* PIBC3_0          */
    uint16 PIBC3_1:1;                                      /* PIBC3_1          */
    uint16 PIBC3_2:1;                                      /* PIBC3_2          */
    uint16 PIBC3_3:1;                                      /* PIBC3_3          */
    uint16 PIBC3_4:1;                                      /* PIBC3_4          */
    uint16 PIBC3_5:1;                                      /* PIBC3_5          */
    uint16 PIBC3_6:1;                                      /* PIBC3_6          */
    uint16 PIBC3_7:1;                                      /* PIBC3_7          */
    uint16 PIBC3_8:1;                                      /* PIBC3_8          */
    uint16 PIBC3_9:1;                                      /* PIBC3_9          */
    uint16 :6;                                             /* Reserved Bits    */
} __type628;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PBDC3_0:1;                                      /* PBDC3_0          */
    uint16 PBDC3_1:1;                                      /* PBDC3_1          */
    uint16 PBDC3_2:1;                                      /* PBDC3_2          */
    uint16 PBDC3_3:1;                                      /* PBDC3_3          */
    uint16 PBDC3_4:1;                                      /* PBDC3_4          */
    uint16 PBDC3_5:1;                                      /* PBDC3_5          */
    uint16 PBDC3_6:1;                                      /* PBDC3_6          */
    uint16 PBDC3_7:1;                                      /* PBDC3_7          */
    uint16 PBDC3_8:1;                                      /* PBDC3_8          */
    uint16 PBDC3_9:1;                                      /* PBDC3_9          */
    uint16 :6;                                             /* Reserved Bits    */
} __type629;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PIPC3_0:1;                                      /* PIPC3_0          */
    uint16 :2;                                             /* Reserved Bits    */
    uint16 PIPC3_3:1;                                      /* PIPC3_3          */
    uint16 PIPC3_4:1;                                      /* PIPC3_4          */
    uint16 PIPC3_5:1;                                      /* PIPC3_5          */
    uint16 PIPC3_6:1;                                      /* PIPC3_6          */
    uint16 PIPC3_7:1;                                      /* PIPC3_7          */
    uint16 PIPC3_8:1;                                      /* PIPC3_8          */
    uint16 PIPC3_9:1;                                      /* PIPC3_9          */
    uint16 :6;                                             /* Reserved Bits    */
} __type630;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PU3_0:1;                                        /* PU3_0            */
    uint16 PU3_1:1;                                        /* PU3_1            */
    uint16 PU3_2:1;                                        /* PU3_2            */
    uint16 PU3_3:1;                                        /* PU3_3            */
    uint16 PU3_4:1;                                        /* PU3_4            */
    uint16 PU3_5:1;                                        /* PU3_5            */
    uint16 PU3_6:1;                                        /* PU3_6            */
    uint16 PU3_7:1;                                        /* PU3_7            */
    uint16 PU3_8:1;                                        /* PU3_8            */
    uint16 PU3_9:1;                                        /* PU3_9            */
    uint16 :6;                                             /* Reserved Bits    */
} __type631;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PD3_0:1;                                        /* PD3_0            */
    uint16 PD3_1:1;                                        /* PD3_1            */
    uint16 PD3_2:1;                                        /* PD3_2            */
    uint16 PD3_3:1;                                        /* PD3_3            */
    uint16 PD3_4:1;                                        /* PD3_4            */
    uint16 PD3_5:1;                                        /* PD3_5            */
    uint16 PD3_6:1;                                        /* PD3_6            */
    uint16 PD3_7:1;                                        /* PD3_7            */
    uint16 PD3_8:1;                                        /* PD3_8            */
    uint16 PD3_9:1;                                        /* PD3_9            */
    uint16 :6;                                             /* Reserved Bits    */
} __type632;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PODC3_0:1;                                      /* PODC3_0          */
    uint32 PODC3_1:1;                                      /* PODC3_1          */
    uint32 PODC3_2:1;                                      /* PODC3_2          */
    uint32 PODC3_3:1;                                      /* PODC3_3          */
    uint32 PODC3_4:1;                                      /* PODC3_4          */
    uint32 PODC3_5:1;                                      /* PODC3_5          */
    uint32 PODC3_6:1;                                      /* PODC3_6          */
    uint32 PODC3_7:1;                                      /* PODC3_7          */
    uint32 PODC3_8:1;                                      /* PODC3_8          */
    uint32 PODC3_9:1;                                      /* PODC3_9          */
    uint32 :22;                                            /* Reserved Bits    */
} __type633;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PDSC3_0:1;                                      /* PDSC3_0          */
    uint32 PDSC3_1:1;                                      /* PDSC3_1          */
    uint32 PDSC3_2:1;                                      /* PDSC3_2          */
    uint32 PDSC3_3:1;                                      /* PDSC3_3          */
    uint32 PDSC3_4:1;                                      /* PDSC3_4          */
    uint32 PDSC3_5:1;                                      /* PDSC3_5          */
    uint32 PDSC3_6:1;                                      /* PDSC3_6          */
    uint32 PDSC3_7:1;                                      /* PDSC3_7          */
    uint32 PDSC3_8:1;                                      /* PDSC3_8          */
    uint32 PDSC3_9:1;                                      /* PDSC3_9          */
    uint32 :22;                                            /* Reserved Bits    */
} __type634;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PIS3_0:1;                                       /* PIS3_0           */
    uint16 PIS3_1:1;                                       /* PIS3_1           */
    uint16 PIS3_2:1;                                       /* PIS3_2           */
    uint16 PIS3_3:1;                                       /* PIS3_3           */
    uint16 PIS3_4:1;                                       /* PIS3_4           */
    uint16 PIS3_5:1;                                       /* PIS3_5           */
    uint16 PIS3_6:1;                                       /* PIS3_6           */
    uint16 PIS3_7:1;                                       /* PIS3_7           */
    uint16 PIS3_8:1;                                       /* PIS3_8           */
    uint16 PIS3_9:1;                                       /* PIS3_9           */
    uint16 :6;                                             /* Reserved Bits    */
} __type635;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PISA3_0:1;                                      /* PISA3_0          */
    uint16 PISA3_1:1;                                      /* PISA3_1          */
    uint16 PISA3_2:1;                                      /* PISA3_2          */
    uint16 PISA3_3:1;                                      /* PISA3_3          */
    uint16 PISA3_4:1;                                      /* PISA3_4          */
    uint16 PISA3_5:1;                                      /* PISA3_5          */
    uint16 PISA3_6:1;                                      /* PISA3_6          */
    uint16 PISA3_7:1;                                      /* PISA3_7          */
    uint16 PISA3_8:1;                                      /* PISA3_8          */
    uint16 PISA3_9:1;                                      /* PISA3_9          */
    uint16 :6;                                             /* Reserved Bits    */
} __type636;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PPCMD3:8;                                       /* PPCMD3[7:0]      */
    uint32 :24;                                            /* Reserved Bits    */
} __type637;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PPROTS3PRERR:1;                                 /* PPROTS3PRERR     */
    uint32 :31;                                            /* Reserved Bits    */
} __type638;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PIBC10_0:1;                                     /* PIBC10_0         */
    uint16 PIBC10_1:1;                                     /* PIBC10_1         */
    uint16 PIBC10_2:1;                                     /* PIBC10_2         */
    uint16 PIBC10_3:1;                                     /* PIBC10_3         */
    uint16 PIBC10_4:1;                                     /* PIBC10_4         */
    uint16 PIBC10_5:1;                                     /* PIBC10_5         */
    uint16 PIBC10_6:1;                                     /* PIBC10_6         */
    uint16 PIBC10_7:1;                                     /* PIBC10_7         */
    uint16 PIBC10_8:1;                                     /* PIBC10_8         */
    uint16 PIBC10_9:1;                                     /* PIBC10_9         */
    uint16 PIBC10_10:1;                                    /* PIBC10_10        */
    uint16 PIBC10_11:1;                                    /* PIBC10_11        */
    uint16 :4;                                             /* Reserved Bits    */
} __type639;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PBDC10_0:1;                                     /* PBDC10_0         */
    uint16 PBDC10_1:1;                                     /* PBDC10_1         */
    uint16 PBDC10_2:1;                                     /* PBDC10_2         */
    uint16 PBDC10_3:1;                                     /* PBDC10_3         */
    uint16 PBDC10_4:1;                                     /* PBDC10_4         */
    uint16 PBDC10_5:1;                                     /* PBDC10_5         */
    uint16 PBDC10_6:1;                                     /* PBDC10_6         */
    uint16 PBDC10_7:1;                                     /* PBDC10_7         */
    uint16 PBDC10_8:1;                                     /* PBDC10_8         */
    uint16 PBDC10_9:1;                                     /* PBDC10_9         */
    uint16 PBDC10_10:1;                                    /* PBDC10_10        */
    uint16 PBDC10_11:1;                                    /* PBDC10_11        */
    uint16 :4;                                             /* Reserved Bits    */
} __type640;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PODC10_0:1;                                     /* PODC10_0         */
    uint32 PODC10_1:1;                                     /* PODC10_1         */
    uint32 PODC10_2:1;                                     /* PODC10_2         */
    uint32 PODC10_3:1;                                     /* PODC10_3         */
    uint32 PODC10_4:1;                                     /* PODC10_4         */
    uint32 PODC10_5:1;                                     /* PODC10_5         */
    uint32 PODC10_6:1;                                     /* PODC10_6         */
    uint32 PODC10_7:1;                                     /* PODC10_7         */
    uint32 PODC10_8:1;                                     /* PODC10_8         */
    uint32 PODC10_9:1;                                     /* PODC10_9         */
    uint32 PODC10_10:1;                                    /* PODC10_10        */
    uint32 PODC10_11:1;                                    /* PODC10_11        */
    uint32 :20;                                            /* Reserved Bits    */
} __type641;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PPCMD10:8;                                      /* PPCMD10[7:0]     */
    uint32 :24;                                            /* Reserved Bits    */
} __type642;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PPROTS10PRERR:1;                                /* PPROTS10PRERR    */
    uint32 :31;                                            /* Reserved Bits    */
} __type643;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PIBC11_0:1;                                     /* PIBC11_0         */
    uint16 PIBC11_1:1;                                     /* PIBC11_1         */
    uint16 PIBC11_2:1;                                     /* PIBC11_2         */
    uint16 PIBC11_3:1;                                     /* PIBC11_3         */
    uint16 :12;                                            /* Reserved Bits    */
} __type644;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PBDC11_0:1;                                     /* PBDC11_0         */
    uint16 PBDC11_1:1;                                     /* PBDC11_1         */
    uint16 PBDC11_2:1;                                     /* PBDC11_2         */
    uint16 PBDC11_3:1;                                     /* PBDC11_3         */
    uint16 :12;                                            /* Reserved Bits    */
} __type645;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PODC11_0:1;                                     /* PODC11_0         */
    uint32 PODC11_1:1;                                     /* PODC11_1         */
    uint32 PODC11_2:1;                                     /* PODC11_2         */
    uint32 PODC11_3:1;                                     /* PODC11_3         */
    uint32 :28;                                            /* Reserved Bits    */
} __type646;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PPCMD11:8;                                      /* PPCMD11[7:0]     */
    uint32 :24;                                            /* Reserved Bits    */
} __type647;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PPROTS11PRERR:1;                                /* PPROTS11PRERR    */
    uint32 :31;                                            /* Reserved Bits    */
} __type648;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PIBC16_0:1;                                     /* PIBC16_0         */
    uint16 PIBC16_1:1;                                     /* PIBC16_1         */
    uint16 PIBC16_2:1;                                     /* PIBC16_2         */
    uint16 PIBC16_3:1;                                     /* PIBC16_3         */
    uint16 PIBC16_4:1;                                     /* PIBC16_4         */
    uint16 PIBC16_5:1;                                     /* PIBC16_5         */
    uint16 PIBC16_6:1;                                     /* PIBC16_6         */
    uint16 PIBC16_7:1;                                     /* PIBC16_7         */
    uint16 PIBC16_8:1;                                     /* PIBC16_8         */
    uint16 PIBC16_9:1;                                     /* PIBC16_9         */
    uint16 PIBC16_10:1;                                    /* PIBC16_10        */
    uint16 PIBC16_11:1;                                    /* PIBC16_11        */
    uint16 :4;                                             /* Reserved Bits    */
} __type649;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PBDC16_0:1;                                     /* PBDC16_0         */
    uint16 PBDC16_1:1;                                     /* PBDC16_1         */
    uint16 PBDC16_2:1;                                     /* PBDC16_2         */
    uint16 PBDC16_3:1;                                     /* PBDC16_3         */
    uint16 PBDC16_4:1;                                     /* PBDC16_4         */
    uint16 PBDC16_5:1;                                     /* PBDC16_5         */
    uint16 PBDC16_6:1;                                     /* PBDC16_6         */
    uint16 PBDC16_7:1;                                     /* PBDC16_7         */
    uint16 PBDC16_8:1;                                     /* PBDC16_8         */
    uint16 PBDC16_9:1;                                     /* PBDC16_9         */
    uint16 PBDC16_10:1;                                    /* PBDC16_10        */
    uint16 PBDC16_11:1;                                    /* PBDC16_11        */
    uint16 :4;                                             /* Reserved Bits    */
} __type650;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PIPC16_0:1;                                     /* PIPC16_0         */
    uint16 PIPC16_1:1;                                     /* PIPC16_1         */
    uint16 PIPC16_2:1;                                     /* PIPC16_2         */
    uint16 PIPC16_3:1;                                     /* PIPC16_3         */
    uint16 PIPC16_4:1;                                     /* PIPC16_4         */
    uint16 PIPC16_5:1;                                     /* PIPC16_5         */
    uint16 PIPC16_6:1;                                     /* PIPC16_6         */
    uint16 PIPC16_7:1;                                     /* PIPC16_7         */
    uint16 PIPC16_8:1;                                     /* PIPC16_8         */
    uint16 PIPC16_9:1;                                     /* PIPC16_9         */
    uint16 PIPC16_10:1;                                    /* PIPC16_10        */
    uint16 PIPC16_11:1;                                    /* PIPC16_11        */
    uint16 :4;                                             /* Reserved Bits    */
} __type651;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PODC16_0:1;                                     /* PODC16_0         */
    uint32 PODC16_1:1;                                     /* PODC16_1         */
    uint32 PODC16_2:1;                                     /* PODC16_2         */
    uint32 PODC16_3:1;                                     /* PODC16_3         */
    uint32 PODC16_4:1;                                     /* PODC16_4         */
    uint32 PODC16_5:1;                                     /* PODC16_5         */
    uint32 PODC16_6:1;                                     /* PODC16_6         */
    uint32 PODC16_7:1;                                     /* PODC16_7         */
    uint32 PODC16_8:1;                                     /* PODC16_8         */
    uint32 PODC16_9:1;                                     /* PODC16_9         */
    uint32 PODC16_10:1;                                    /* PODC16_10        */
    uint32 PODC16_11:1;                                    /* PODC16_11        */
    uint32 :20;                                            /* Reserved Bits    */
} __type652;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PDSC16_0:1;                                     /* PDSC16_0         */
    uint32 PDSC16_1:1;                                     /* PDSC16_1         */
    uint32 PDSC16_2:1;                                     /* PDSC16_2         */
    uint32 PDSC16_3:1;                                     /* PDSC16_3         */
    uint32 PDSC16_4:1;                                     /* PDSC16_4         */
    uint32 PDSC16_5:1;                                     /* PDSC16_5         */
    uint32 PDSC16_6:1;                                     /* PDSC16_6         */
    uint32 PDSC16_7:1;                                     /* PDSC16_7         */
    uint32 PDSC16_8:1;                                     /* PDSC16_8         */
    uint32 PDSC16_9:1;                                     /* PDSC16_9         */
    uint32 PDSC16_10:1;                                    /* PDSC16_10        */
    uint32 PDSC16_11:1;                                    /* PDSC16_11        */
    uint32 :20;                                            /* Reserved Bits    */
} __type653;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PIS16_0:1;                                      /* PIS16_0          */
    uint16 PIS16_1:1;                                      /* PIS16_1          */
    uint16 PIS16_2:1;                                      /* PIS16_2          */
    uint16 PIS16_3:1;                                      /* PIS16_3          */
    uint16 PIS16_4:1;                                      /* PIS16_4          */
    uint16 PIS16_5:1;                                      /* PIS16_5          */
    uint16 PIS16_6:1;                                      /* PIS16_6          */
    uint16 PIS16_7:1;                                      /* PIS16_7          */
    uint16 PIS16_8:1;                                      /* PIS16_8          */
    uint16 PIS16_9:1;                                      /* PIS16_9          */
    uint16 PIS16_10:1;                                     /* PIS16_10         */
    uint16 PIS16_11:1;                                     /* PIS16_11         */
    uint16 :4;                                             /* Reserved Bits    */
} __type654;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PISA16_0:1;                                     /* PISA16_0         */
    uint16 PISA16_1:1;                                     /* PISA16_1         */
    uint16 PISA16_2:1;                                     /* PISA16_2         */
    uint16 PISA16_3:1;                                     /* PISA16_3         */
    uint16 PISA16_4:1;                                     /* PISA16_4         */
    uint16 PISA16_5:1;                                     /* PISA16_5         */
    uint16 PISA16_6:1;                                     /* PISA16_6         */
    uint16 PISA16_7:1;                                     /* PISA16_7         */
    uint16 PISA16_8:1;                                     /* PISA16_8         */
    uint16 PISA16_9:1;                                     /* PISA16_9         */
    uint16 PISA16_10:1;                                    /* PISA16_10        */
    uint16 PISA16_11:1;                                    /* PISA16_11        */
    uint16 :4;                                             /* Reserved Bits    */
} __type655;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PPCMD16:8;                                      /* PPCMD16[7:0]     */
    uint32 :24;                                            /* Reserved Bits    */
} __type656;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PPROTS16PRERR:1;                                /* PPROTS16PRERR    */
    uint32 :31;                                            /* Reserved Bits    */
} __type657;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PIBC17_0:1;                                     /* PIBC17_0         */
    uint16 PIBC17_1:1;                                     /* PIBC17_1         */
    uint16 PIBC17_2:1;                                     /* PIBC17_2         */
    uint16 PIBC17_3:1;                                     /* PIBC17_3         */
    uint16 PIBC17_4:1;                                     /* PIBC17_4         */
    uint16 PIBC17_5:1;                                     /* PIBC17_5         */
    uint16 PIBC17_6:1;                                     /* PIBC17_6         */
    uint16 PIBC17_7:1;                                     /* PIBC17_7         */
    uint16 PIBC17_8:1;                                     /* PIBC17_8         */
    uint16 PIBC17_9:1;                                     /* PIBC17_9         */
    uint16 PIBC17_10:1;                                    /* PIBC17_10        */
    uint16 PIBC17_11:1;                                    /* PIBC17_11        */
    uint16 :4;                                             /* Reserved Bits    */
} __type658;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PBDC17_0:1;                                     /* PBDC17_0         */
    uint16 PBDC17_1:1;                                     /* PBDC17_1         */
    uint16 PBDC17_2:1;                                     /* PBDC17_2         */
    uint16 PBDC17_3:1;                                     /* PBDC17_3         */
    uint16 PBDC17_4:1;                                     /* PBDC17_4         */
    uint16 PBDC17_5:1;                                     /* PBDC17_5         */
    uint16 PBDC17_6:1;                                     /* PBDC17_6         */
    uint16 PBDC17_7:1;                                     /* PBDC17_7         */
    uint16 PBDC17_8:1;                                     /* PBDC17_8         */
    uint16 PBDC17_9:1;                                     /* PBDC17_9         */
    uint16 PBDC17_10:1;                                    /* PBDC17_10        */
    uint16 PBDC17_11:1;                                    /* PBDC17_11        */
    uint16 :4;                                             /* Reserved Bits    */
} __type659;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PIPC17_0:1;                                     /* PIPC17_0         */
    uint16 PIPC17_1:1;                                     /* PIPC17_1         */
    uint16 PIPC17_2:1;                                     /* PIPC17_2         */
    uint16 PIPC17_3:1;                                     /* PIPC17_3         */
    uint16 PIPC17_4:1;                                     /* PIPC17_4         */
    uint16 PIPC17_5:1;                                     /* PIPC17_5         */
    uint16 PIPC17_6:1;                                     /* PIPC17_6         */
    uint16 PIPC17_7:1;                                     /* PIPC17_7         */
    uint16 PIPC17_8:1;                                     /* PIPC17_8         */
    uint16 PIPC17_9:1;                                     /* PIPC17_9         */
    uint16 PIPC17_10:1;                                    /* PIPC17_10        */
    uint16 PIPC17_11:1;                                    /* PIPC17_11        */
    uint16 :4;                                             /* Reserved Bits    */
} __type660;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PODC17_0:1;                                     /* PODC17_0         */
    uint32 PODC17_1:1;                                     /* PODC17_1         */
    uint32 PODC17_2:1;                                     /* PODC17_2         */
    uint32 PODC17_3:1;                                     /* PODC17_3         */
    uint32 PODC17_4:1;                                     /* PODC17_4         */
    uint32 PODC17_5:1;                                     /* PODC17_5         */
    uint32 PODC17_6:1;                                     /* PODC17_6         */
    uint32 PODC17_7:1;                                     /* PODC17_7         */
    uint32 PODC17_8:1;                                     /* PODC17_8         */
    uint32 PODC17_9:1;                                     /* PODC17_9         */
    uint32 PODC17_10:1;                                    /* PODC17_10        */
    uint32 PODC17_11:1;                                    /* PODC17_11        */
    uint32 :20;                                            /* Reserved Bits    */
} __type661;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PDSC17_0:1;                                     /* PDSC17_0         */
    uint32 PDSC17_1:1;                                     /* PDSC17_1         */
    uint32 PDSC17_2:1;                                     /* PDSC17_2         */
    uint32 PDSC17_3:1;                                     /* PDSC17_3         */
    uint32 PDSC17_4:1;                                     /* PDSC17_4         */
    uint32 PDSC17_5:1;                                     /* PDSC17_5         */
    uint32 PDSC17_6:1;                                     /* PDSC17_6         */
    uint32 PDSC17_7:1;                                     /* PDSC17_7         */
    uint32 PDSC17_8:1;                                     /* PDSC17_8         */
    uint32 PDSC17_9:1;                                     /* PDSC17_9         */
    uint32 PDSC17_10:1;                                    /* PDSC17_10        */
    uint32 PDSC17_11:1;                                    /* PDSC17_11        */
    uint32 :20;                                            /* Reserved Bits    */
} __type662;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PIS17_0:1;                                      /* PIS17_0          */
    uint16 PIS17_1:1;                                      /* PIS17_1          */
    uint16 PIS17_2:1;                                      /* PIS17_2          */
    uint16 PIS17_3:1;                                      /* PIS17_3          */
    uint16 PIS17_4:1;                                      /* PIS17_4          */
    uint16 PIS17_5:1;                                      /* PIS17_5          */
    uint16 PIS17_6:1;                                      /* PIS17_6          */
    uint16 PIS17_7:1;                                      /* PIS17_7          */
    uint16 PIS17_8:1;                                      /* PIS17_8          */
    uint16 PIS17_9:1;                                      /* PIS17_9          */
    uint16 PIS17_10:1;                                     /* PIS17_10         */
    uint16 PIS17_11:1;                                     /* PIS17_11         */
    uint16 :4;                                             /* Reserved Bits    */
} __type663;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PISA17_0:1;                                     /* PISA17_0         */
    uint16 PISA17_1:1;                                     /* PISA17_1         */
    uint16 PISA17_2:1;                                     /* PISA17_2         */
    uint16 PISA17_3:1;                                     /* PISA17_3         */
    uint16 PISA17_4:1;                                     /* PISA17_4         */
    uint16 PISA17_5:1;                                     /* PISA17_5         */
    uint16 PISA17_6:1;                                     /* PISA17_6         */
    uint16 PISA17_7:1;                                     /* PISA17_7         */
    uint16 PISA17_8:1;                                     /* PISA17_8         */
    uint16 PISA17_9:1;                                     /* PISA17_9         */
    uint16 PISA17_10:1;                                    /* PISA17_10        */
    uint16 PISA17_11:1;                                    /* PISA17_11        */
    uint16 :4;                                             /* Reserved Bits    */
} __type664;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PPCMD17:8;                                      /* PPCMD17[7:0]     */
    uint32 :24;                                            /* Reserved Bits    */
} __type665;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PPROTS17PRERR:1;                                /* PPROTS17PRERR    */
    uint32 :31;                                            /* Reserved Bits    */
} __type666;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PIBC21_0:1;                                     /* PIBC21_0         */
    uint16 PIBC21_1:1;                                     /* PIBC21_1         */
    uint16 PIBC21_2:1;                                     /* PIBC21_2         */
    uint16 PIBC21_3:1;                                     /* PIBC21_3         */
    uint16 PIBC21_4:1;                                     /* PIBC21_4         */
    uint16 PIBC21_5:1;                                     /* PIBC21_5         */
    uint16 PIBC21_6:1;                                     /* PIBC21_6         */
    uint16 PIBC21_7:1;                                     /* PIBC21_7         */
    uint16 PIBC21_8:1;                                     /* PIBC21_8         */
    uint16 PIBC21_9:1;                                     /* PIBC21_9         */
    uint16 :6;                                             /* Reserved Bits    */
} __type667;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PBDC21_0:1;                                     /* PBDC21_0         */
    uint16 PBDC21_1:1;                                     /* PBDC21_1         */
    uint16 PBDC21_2:1;                                     /* PBDC21_2         */
    uint16 PBDC21_3:1;                                     /* PBDC21_3         */
    uint16 PBDC21_4:1;                                     /* PBDC21_4         */
    uint16 PBDC21_5:1;                                     /* PBDC21_5         */
    uint16 PBDC21_6:1;                                     /* PBDC21_6         */
    uint16 PBDC21_7:1;                                     /* PBDC21_7         */
    uint16 PBDC21_8:1;                                     /* PBDC21_8         */
    uint16 PBDC21_9:1;                                     /* PBDC21_9         */
    uint16 :6;                                             /* Reserved Bits    */
} __type668;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PIPC21_0:1;                                     /* PIPC21_0         */
    uint16 PIPC21_1:1;                                     /* PIPC21_1         */
    uint16 PIPC21_2:1;                                     /* PIPC21_2         */
    uint16 PIPC21_3:1;                                     /* PIPC21_3         */
    uint16 PIPC21_4:1;                                     /* PIPC21_4         */
    uint16 PIPC21_5:1;                                     /* PIPC21_5         */
    uint16 PIPC21_6:1;                                     /* PIPC21_6         */
    uint16 PIPC21_7:1;                                     /* PIPC21_7         */
    uint16 PIPC21_8:1;                                     /* PIPC21_8         */
    uint16 PIPC21_9:1;                                     /* PIPC21_9         */
    uint16 :6;                                             /* Reserved Bits    */
} __type669;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PU21_0:1;                                       /* PU21_0           */
    uint16 PU21_1:1;                                       /* PU21_1           */
    uint16 PU21_2:1;                                       /* PU21_2           */
    uint16 PU21_3:1;                                       /* PU21_3           */
    uint16 PU21_4:1;                                       /* PU21_4           */
    uint16 PU21_5:1;                                       /* PU21_5           */
    uint16 PU21_6:1;                                       /* PU21_6           */
    uint16 PU21_7:1;                                       /* PU21_7           */
    uint16 PU21_8:1;                                       /* PU21_8           */
    uint16 PU21_9:1;                                       /* PU21_9           */
    uint16 :6;                                             /* Reserved Bits    */
} __type670;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PD21_0:1;                                       /* PD21_0           */
    uint16 PD21_1:1;                                       /* PD21_1           */
    uint16 PD21_2:1;                                       /* PD21_2           */
    uint16 PD21_3:1;                                       /* PD21_3           */
    uint16 PD21_4:1;                                       /* PD21_4           */
    uint16 PD21_5:1;                                       /* PD21_5           */
    uint16 PD21_6:1;                                       /* PD21_6           */
    uint16 PD21_7:1;                                       /* PD21_7           */
    uint16 PD21_8:1;                                       /* PD21_8           */
    uint16 PD21_9:1;                                       /* PD21_9           */
    uint16 :6;                                             /* Reserved Bits    */
} __type671;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PODC21_0:1;                                     /* PODC21_0         */
    uint32 PODC21_1:1;                                     /* PODC21_1         */
    uint32 PODC21_2:1;                                     /* PODC21_2         */
    uint32 PODC21_3:1;                                     /* PODC21_3         */
    uint32 PODC21_4:1;                                     /* PODC21_4         */
    uint32 PODC21_5:1;                                     /* PODC21_5         */
    uint32 PODC21_6:1;                                     /* PODC21_6         */
    uint32 PODC21_7:1;                                     /* PODC21_7         */
    uint32 PODC21_8:1;                                     /* PODC21_8         */
    uint32 PODC21_9:1;                                     /* PODC21_9         */
    uint32 :22;                                            /* Reserved Bits    */
} __type672;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PPCMD21:8;                                      /* PPCMD21[7:0]     */
    uint32 :24;                                            /* Reserved Bits    */
} __type673;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PPROTS21PRERR:1;                                /* PPROTS21PRERR    */
    uint32 :31;                                            /* Reserved Bits    */
} __type674;
typedef struct 
{                                                          /* Bit Access       */
    uint16 :10;                                            /* Reserved Bits    */
    uint16 PIBC22_10:1;                                    /* PIBC22_10        */
    uint16 :5;                                             /* Reserved Bits    */
} __type675;
typedef struct 
{                                                          /* Bit Access       */
    uint16 :10;                                            /* Reserved Bits    */
    uint16 PBDC22_10:1;                                    /* PBDC22_10        */
    uint16 :5;                                             /* Reserved Bits    */
} __type676;
typedef struct 
{                                                          /* Bit Access       */
    uint16 :10;                                            /* Reserved Bits    */
    uint16 PIPC22_10:1;                                    /* PIPC22_10        */
    uint16 :5;                                             /* Reserved Bits    */
} __type677;
typedef struct 
{                                                          /* Bit Access       */
    uint16 :10;                                            /* Reserved Bits    */
    uint16 PU22_10:1;                                      /* PU22_10          */
    uint16 :5;                                             /* Reserved Bits    */
} __type678;
typedef struct 
{                                                          /* Bit Access       */
    uint16 :10;                                            /* Reserved Bits    */
    uint16 PD22_10:1;                                      /* PD22_10          */
    uint16 :5;                                             /* Reserved Bits    */
} __type679;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :10;                                            /* Reserved Bits    */
    uint32 PODC22_10:1;                                    /* PODC22_10        */
    uint32 :21;                                            /* Reserved Bits    */
} __type680;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PPCMD22:8;                                      /* PPCMD22[7:0]     */
    uint32 :24;                                            /* Reserved Bits    */
} __type681;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PPROTS22PRERR:1;                                /* PPROTS22PRERR    */
    uint32 :31;                                            /* Reserved Bits    */
} __type682;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PIBC42_0:1;                                     /* PIBC42_0         */
    uint16 PIBC42_1:1;                                     /* PIBC42_1         */
    uint16 PIBC42_2:1;                                     /* PIBC42_2         */
    uint16 PIBC42_3:1;                                     /* PIBC42_3         */
    uint16 PIBC42_4:1;                                     /* PIBC42_4         */
    uint16 PIBC42_5:1;                                     /* PIBC42_5         */
    uint16 PIBC42_6:1;                                     /* PIBC42_6         */
    uint16 PIBC42_7:1;                                     /* PIBC42_7         */
    uint16 PIBC42_8:1;                                     /* PIBC42_8         */
    uint16 PIBC42_9:1;                                     /* PIBC42_9         */
    uint16 PIBC42_10:1;                                    /* PIBC42_10        */
    uint16 PIBC42_11:1;                                    /* PIBC42_11        */
    uint16 PIBC42_12:1;                                    /* PIBC42_12        */
    uint16 PIBC42_13:1;                                    /* PIBC42_13        */
    uint16 PIBC42_14:1;                                    /* PIBC42_14        */
    uint16 PIBC42_15:1;                                    /* PIBC42_15        */
} __type683;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PBDC42_0:1;                                     /* PBDC42_0         */
    uint16 PBDC42_1:1;                                     /* PBDC42_1         */
    uint16 PBDC42_2:1;                                     /* PBDC42_2         */
    uint16 PBDC42_3:1;                                     /* PBDC42_3         */
    uint16 PBDC42_4:1;                                     /* PBDC42_4         */
    uint16 PBDC42_5:1;                                     /* PBDC42_5         */
    uint16 PBDC42_6:1;                                     /* PBDC42_6         */
    uint16 PBDC42_7:1;                                     /* PBDC42_7         */
    uint16 PBDC42_8:1;                                     /* PBDC42_8         */
    uint16 PBDC42_9:1;                                     /* PBDC42_9         */
    uint16 PBDC42_10:1;                                    /* PBDC42_10        */
    uint16 PBDC42_11:1;                                    /* PBDC42_11        */
    uint16 PBDC42_12:1;                                    /* PBDC42_12        */
    uint16 PBDC42_13:1;                                    /* PBDC42_13        */
    uint16 PBDC42_14:1;                                    /* PBDC42_14        */
    uint16 PBDC42_15:1;                                    /* PBDC42_15        */
} __type684;
typedef struct 
{                                                          /* Bit Access       */
    uint16 :2;                                             /* Reserved Bits    */
    uint16 PIPC42_2:1;                                     /* PIPC42_2         */
    uint16 PIPC42_3:1;                                     /* PIPC42_3         */
    uint16 PIPC42_4:1;                                     /* PIPC42_4         */
    uint16 PIPC42_5:1;                                     /* PIPC42_5         */
    uint16 PIPC42_6:1;                                     /* PIPC42_6         */
    uint16 PIPC42_7:1;                                     /* PIPC42_7         */
    uint16 PIPC42_8:1;                                     /* PIPC42_8         */
    uint16 PIPC42_9:1;                                     /* PIPC42_9         */
    uint16 PIPC42_10:1;                                    /* PIPC42_10        */
    uint16 PIPC42_11:1;                                    /* PIPC42_11        */
    uint16 PIPC42_12:1;                                    /* PIPC42_12        */
    uint16 PIPC42_13:1;                                    /* PIPC42_13        */
    uint16 :2;                                             /* Reserved Bits    */
} __type685;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PU42_0:1;                                       /* PU42_0           */
    uint16 PU42_1:1;                                       /* PU42_1           */
    uint16 PU42_2:1;                                       /* PU42_2           */
    uint16 PU42_3:1;                                       /* PU42_3           */
    uint16 PU42_4:1;                                       /* PU42_4           */
    uint16 PU42_5:1;                                       /* PU42_5           */
    uint16 PU42_6:1;                                       /* PU42_6           */
    uint16 PU42_7:1;                                       /* PU42_7           */
    uint16 PU42_8:1;                                       /* PU42_8           */
    uint16 PU42_9:1;                                       /* PU42_9           */
    uint16 PU42_10:1;                                      /* PU42_10          */
    uint16 PU42_11:1;                                      /* PU42_11          */
    uint16 PU42_12:1;                                      /* PU42_12          */
    uint16 PU42_13:1;                                      /* PU42_13          */
    uint16 PU42_14:1;                                      /* PU42_14          */
    uint16 PU42_15:1;                                      /* PU42_15          */
} __type686;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PD42_0:1;                                       /* PD42_0           */
    uint16 PD42_1:1;                                       /* PD42_1           */
    uint16 PD42_2:1;                                       /* PD42_2           */
    uint16 PD42_3:1;                                       /* PD42_3           */
    uint16 PD42_4:1;                                       /* PD42_4           */
    uint16 PD42_5:1;                                       /* PD42_5           */
    uint16 PD42_6:1;                                       /* PD42_6           */
    uint16 PD42_7:1;                                       /* PD42_7           */
    uint16 PD42_8:1;                                       /* PD42_8           */
    uint16 PD42_9:1;                                       /* PD42_9           */
    uint16 PD42_10:1;                                      /* PD42_10          */
    uint16 PD42_11:1;                                      /* PD42_11          */
    uint16 PD42_12:1;                                      /* PD42_12          */
    uint16 PD42_13:1;                                      /* PD42_13          */
    uint16 PD42_14:1;                                      /* PD42_14          */
    uint16 PD42_15:1;                                      /* PD42_15          */
} __type687;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PODC42_0:1;                                     /* PODC42_0         */
    uint32 PODC42_1:1;                                     /* PODC42_1         */
    uint32 PODC42_2:1;                                     /* PODC42_2         */
    uint32 PODC42_3:1;                                     /* PODC42_3         */
    uint32 PODC42_4:1;                                     /* PODC42_4         */
    uint32 PODC42_5:1;                                     /* PODC42_5         */
    uint32 PODC42_6:1;                                     /* PODC42_6         */
    uint32 PODC42_7:1;                                     /* PODC42_7         */
    uint32 PODC42_8:1;                                     /* PODC42_8         */
    uint32 PODC42_9:1;                                     /* PODC42_9         */
    uint32 PODC42_10:1;                                    /* PODC42_10        */
    uint32 PODC42_11:1;                                    /* PODC42_11        */
    uint32 PODC42_12:1;                                    /* PODC42_12        */
    uint32 PODC42_13:1;                                    /* PODC42_13        */
    uint32 PODC42_14:1;                                    /* PODC42_14        */
    uint32 PODC42_15:1;                                    /* PODC42_15        */
    uint32 :16;                                            /* Reserved Bits    */
} __type688;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PDSC42_0:1;                                     /* PDSC42_0         */
    uint32 PDSC42_1:1;                                     /* PDSC42_1         */
    uint32 PDSC42_2:1;                                     /* PDSC42_2         */
    uint32 PDSC42_3:1;                                     /* PDSC42_3         */
    uint32 PDSC42_4:1;                                     /* PDSC42_4         */
    uint32 PDSC42_5:1;                                     /* PDSC42_5         */
    uint32 PDSC42_6:1;                                     /* PDSC42_6         */
    uint32 PDSC42_7:1;                                     /* PDSC42_7         */
    uint32 PDSC42_8:1;                                     /* PDSC42_8         */
    uint32 PDSC42_9:1;                                     /* PDSC42_9         */
    uint32 PDSC42_10:1;                                    /* PDSC42_10        */
    uint32 PDSC42_11:1;                                    /* PDSC42_11        */
    uint32 PDSC42_12:1;                                    /* PDSC42_12        */
    uint32 PDSC42_13:1;                                    /* PDSC42_13        */
    uint32 PDSC42_14:1;                                    /* PDSC42_14        */
    uint32 PDSC42_15:1;                                    /* PDSC42_15        */
    uint32 :16;                                            /* Reserved Bits    */
} __type689;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PIS42_0:1;                                      /* PIS42_0          */
    uint16 PIS42_1:1;                                      /* PIS42_1          */
    uint16 PIS42_2:1;                                      /* PIS42_2          */
    uint16 PIS42_3:1;                                      /* PIS42_3          */
    uint16 PIS42_4:1;                                      /* PIS42_4          */
    uint16 PIS42_5:1;                                      /* PIS42_5          */
    uint16 PIS42_6:1;                                      /* PIS42_6          */
    uint16 PIS42_7:1;                                      /* PIS42_7          */
    uint16 PIS42_8:1;                                      /* PIS42_8          */
    uint16 PIS42_9:1;                                      /* PIS42_9          */
    uint16 PIS42_10:1;                                     /* PIS42_10         */
    uint16 PIS42_11:1;                                     /* PIS42_11         */
    uint16 PIS42_12:1;                                     /* PIS42_12         */
    uint16 PIS42_13:1;                                     /* PIS42_13         */
    uint16 PIS42_14:1;                                     /* PIS42_14         */
    uint16 PIS42_15:1;                                     /* PIS42_15         */
} __type690;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PISA42_0:1;                                     /* PISA42_0         */
    uint16 PISA42_1:1;                                     /* PISA42_1         */
    uint16 PISA42_2:1;                                     /* PISA42_2         */
    uint16 PISA42_3:1;                                     /* PISA42_3         */
    uint16 PISA42_4:1;                                     /* PISA42_4         */
    uint16 PISA42_5:1;                                     /* PISA42_5         */
    uint16 PISA42_6:1;                                     /* PISA42_6         */
    uint16 PISA42_7:1;                                     /* PISA42_7         */
    uint16 PISA42_8:1;                                     /* PISA42_8         */
    uint16 PISA42_9:1;                                     /* PISA42_9         */
    uint16 PISA42_10:1;                                    /* PISA42_10        */
    uint16 PISA42_11:1;                                    /* PISA42_11        */
    uint16 PISA42_12:1;                                    /* PISA42_12        */
    uint16 PISA42_13:1;                                    /* PISA42_13        */
    uint16 PISA42_14:1;                                    /* PISA42_14        */
    uint16 PISA42_15:1;                                    /* PISA42_15        */
} __type691;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PPCMD42:8;                                      /* PPCMD42[7:0]     */
    uint32 :24;                                            /* Reserved Bits    */
} __type692;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PPROTS42PRERR:1;                                /* PPROTS42PRERR    */
    uint32 :31;                                            /* Reserved Bits    */
} __type693;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PIBC43_0:1;                                     /* PIBC43_0         */
    uint16 PIBC43_1:1;                                     /* PIBC43_1         */
    uint16 :14;                                            /* Reserved Bits    */
} __type694;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PBDC43_0:1;                                     /* PBDC43_0         */
    uint16 PBDC43_1:1;                                     /* PBDC43_1         */
    uint16 :14;                                            /* Reserved Bits    */
} __type695;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PU43_0:1;                                       /* PU43_0           */
    uint16 PU43_1:1;                                       /* PU43_1           */
    uint16 :14;                                            /* Reserved Bits    */
} __type696;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PD43_0:1;                                       /* PD43_0           */
    uint16 PD43_1:1;                                       /* PD43_1           */
    uint16 :14;                                            /* Reserved Bits    */
} __type697;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PODC43_0:1;                                     /* PODC43_0         */
    uint32 PODC43_1:1;                                     /* PODC43_1         */
    uint32 :30;                                            /* Reserved Bits    */
} __type698;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PDSC43_0:1;                                     /* PDSC43_0         */
    uint32 PDSC43_1:1;                                     /* PDSC43_1         */
    uint32 :30;                                            /* Reserved Bits    */
} __type699;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PIS43_0:1;                                      /* PIS43_0          */
    uint16 PIS43_1:1;                                      /* PIS43_1          */
    uint16 :14;                                            /* Reserved Bits    */
} __type700;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PISA43_0:1;                                     /* PISA43_0         */
    uint16 PISA43_1:1;                                     /* PISA43_1         */
    uint16 :14;                                            /* Reserved Bits    */
} __type701;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PPCMD43:8;                                      /* PPCMD43[7:0]     */
    uint32 :24;                                            /* Reserved Bits    */
} __type702;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PPROTS43PRERR:1;                                /* PPROTS43PRERR    */
    uint32 :31;                                            /* Reserved Bits    */
} __type703;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PIBC44_0:1;                                     /* PIBC44_0         */
    uint16 PIBC44_1:1;                                     /* PIBC44_1         */
    uint16 PIBC44_2:1;                                     /* PIBC44_2         */
    uint16 PIBC44_3:1;                                     /* PIBC44_3         */
    uint16 PIBC44_4:1;                                     /* PIBC44_4         */
    uint16 PIBC44_5:1;                                     /* PIBC44_5         */
    uint16 PIBC44_6:1;                                     /* PIBC44_6         */
    uint16 PIBC44_7:1;                                     /* PIBC44_7         */
    uint16 PIBC44_8:1;                                     /* PIBC44_8         */
    uint16 PIBC44_9:1;                                     /* PIBC44_9         */
    uint16 PIBC44_10:1;                                    /* PIBC44_10        */
    uint16 PIBC44_11:1;                                    /* PIBC44_11        */
    uint16 :4;                                             /* Reserved Bits    */
} __type704;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PBDC44_0:1;                                     /* PBDC44_0         */
    uint16 PBDC44_1:1;                                     /* PBDC44_1         */
    uint16 PBDC44_2:1;                                     /* PBDC44_2         */
    uint16 PBDC44_3:1;                                     /* PBDC44_3         */
    uint16 PBDC44_4:1;                                     /* PBDC44_4         */
    uint16 PBDC44_5:1;                                     /* PBDC44_5         */
    uint16 PBDC44_6:1;                                     /* PBDC44_6         */
    uint16 PBDC44_7:1;                                     /* PBDC44_7         */
    uint16 PBDC44_8:1;                                     /* PBDC44_8         */
    uint16 PBDC44_9:1;                                     /* PBDC44_9         */
    uint16 PBDC44_10:1;                                    /* PBDC44_10        */
    uint16 PBDC44_11:1;                                    /* PBDC44_11        */
    uint16 :4;                                             /* Reserved Bits    */
} __type705;
typedef struct 
{                                                          /* Bit Access       */
    uint16 :2;                                             /* Reserved Bits    */
    uint16 PIPC44_2:1;                                     /* PIPC44_2         */
    uint16 :1;                                             /* Reserved Bits    */
    uint16 PIPC44_4:1;                                     /* PIPC44_4         */
    uint16 :2;                                             /* Reserved Bits    */
    uint16 PIPC44_7:1;                                     /* PIPC44_7         */
    uint16 :1;                                             /* Reserved Bits    */
    uint16 PIPC44_9:1;                                     /* PIPC44_9         */
    uint16 :6;                                             /* Reserved Bits    */
} __type706;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PU44_0:1;                                       /* PU44_0           */
    uint16 PU44_1:1;                                       /* PU44_1           */
    uint16 PU44_2:1;                                       /* PU44_2           */
    uint16 PU44_3:1;                                       /* PU44_3           */
    uint16 PU44_4:1;                                       /* PU44_4           */
    uint16 PU44_5:1;                                       /* PU44_5           */
    uint16 PU44_6:1;                                       /* PU44_6           */
    uint16 PU44_7:1;                                       /* PU44_7           */
    uint16 PU44_8:1;                                       /* PU44_8           */
    uint16 PU44_9:1;                                       /* PU44_9           */
    uint16 PU44_10:1;                                      /* PU44_10          */
    uint16 PU44_11:1;                                      /* PU44_11          */
    uint16 :4;                                             /* Reserved Bits    */
} __type707;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PD44_0:1;                                       /* PD44_0           */
    uint16 PD44_1:1;                                       /* PD44_1           */
    uint16 PD44_2:1;                                       /* PD44_2           */
    uint16 PD44_3:1;                                       /* PD44_3           */
    uint16 PD44_4:1;                                       /* PD44_4           */
    uint16 PD44_5:1;                                       /* PD44_5           */
    uint16 PD44_6:1;                                       /* PD44_6           */
    uint16 PD44_7:1;                                       /* PD44_7           */
    uint16 PD44_8:1;                                       /* PD44_8           */
    uint16 PD44_9:1;                                       /* PD44_9           */
    uint16 PD44_10:1;                                      /* PD44_10          */
    uint16 PD44_11:1;                                      /* PD44_11          */
    uint16 :4;                                             /* Reserved Bits    */
} __type708;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PODC44_0:1;                                     /* PODC44_0         */
    uint32 PODC44_1:1;                                     /* PODC44_1         */
    uint32 PODC44_2:1;                                     /* PODC44_2         */
    uint32 PODC44_3:1;                                     /* PODC44_3         */
    uint32 PODC44_4:1;                                     /* PODC44_4         */
    uint32 PODC44_5:1;                                     /* PODC44_5         */
    uint32 PODC44_6:1;                                     /* PODC44_6         */
    uint32 PODC44_7:1;                                     /* PODC44_7         */
    uint32 PODC44_8:1;                                     /* PODC44_8         */
    uint32 PODC44_9:1;                                     /* PODC44_9         */
    uint32 PODC44_10:1;                                    /* PODC44_10        */
    uint32 PODC44_11:1;                                    /* PODC44_11        */
    uint32 :20;                                            /* Reserved Bits    */
} __type709;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PDSC44_0:1;                                     /* PDSC44_0         */
    uint32 PDSC44_1:1;                                     /* PDSC44_1         */
    uint32 PDSC44_2:1;                                     /* PDSC44_2         */
    uint32 PDSC44_3:1;                                     /* PDSC44_3         */
    uint32 PDSC44_4:1;                                     /* PDSC44_4         */
    uint32 PDSC44_5:1;                                     /* PDSC44_5         */
    uint32 PDSC44_6:1;                                     /* PDSC44_6         */
    uint32 PDSC44_7:1;                                     /* PDSC44_7         */
    uint32 PDSC44_8:1;                                     /* PDSC44_8         */
    uint32 PDSC44_9:1;                                     /* PDSC44_9         */
    uint32 PDSC44_10:1;                                    /* PDSC44_10        */
    uint32 PDSC44_11:1;                                    /* PDSC44_11        */
    uint32 :20;                                            /* Reserved Bits    */
} __type710;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PIS44_0:1;                                      /* PIS44_0          */
    uint16 PIS44_1:1;                                      /* PIS44_1          */
    uint16 PIS44_2:1;                                      /* PIS44_2          */
    uint16 PIS44_3:1;                                      /* PIS44_3          */
    uint16 PIS44_4:1;                                      /* PIS44_4          */
    uint16 PIS44_5:1;                                      /* PIS44_5          */
    uint16 PIS44_6:1;                                      /* PIS44_6          */
    uint16 PIS44_7:1;                                      /* PIS44_7          */
    uint16 PIS44_8:1;                                      /* PIS44_8          */
    uint16 PIS44_9:1;                                      /* PIS44_9          */
    uint16 PIS44_10:1;                                     /* PIS44_10         */
    uint16 PIS44_11:1;                                     /* PIS44_11         */
    uint16 :4;                                             /* Reserved Bits    */
} __type711;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PISA44_0:1;                                     /* PISA44_0         */
    uint16 PISA44_1:1;                                     /* PISA44_1         */
    uint16 PISA44_2:1;                                     /* PISA44_2         */
    uint16 PISA44_3:1;                                     /* PISA44_3         */
    uint16 PISA44_4:1;                                     /* PISA44_4         */
    uint16 PISA44_5:1;                                     /* PISA44_5         */
    uint16 PISA44_6:1;                                     /* PISA44_6         */
    uint16 PISA44_7:1;                                     /* PISA44_7         */
    uint16 PISA44_8:1;                                     /* PISA44_8         */
    uint16 PISA44_9:1;                                     /* PISA44_9         */
    uint16 PISA44_10:1;                                    /* PISA44_10        */
    uint16 PISA44_11:1;                                    /* PISA44_11        */
    uint16 :4;                                             /* Reserved Bits    */
} __type712;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PPCMD44:8;                                      /* PPCMD44[7:0]     */
    uint32 :24;                                            /* Reserved Bits    */
} __type713;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PPROTS44PRERR:1;                                /* PPROTS44PRERR    */
    uint32 :31;                                            /* Reserved Bits    */
} __type714;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PIBC45_0:1;                                     /* PIBC45_0         */
    uint16 PIBC45_1:1;                                     /* PIBC45_1         */
    uint16 PIBC45_2:1;                                     /* PIBC45_2         */
    uint16 PIBC45_3:1;                                     /* PIBC45_3         */
    uint16 PIBC45_4:1;                                     /* PIBC45_4         */
    uint16 PIBC45_5:1;                                     /* PIBC45_5         */
    uint16 PIBC45_6:1;                                     /* PIBC45_6         */
    uint16 PIBC45_7:1;                                     /* PIBC45_7         */
    uint16 PIBC45_8:1;                                     /* PIBC45_8         */
    uint16 PIBC45_9:1;                                     /* PIBC45_9         */
    uint16 PIBC45_10:1;                                    /* PIBC45_10        */
    uint16 PIBC45_11:1;                                    /* PIBC45_11        */
    uint16 PIBC45_12:1;                                    /* PIBC45_12        */
    uint16 PIBC45_13:1;                                    /* PIBC45_13        */
    uint16 :2;                                             /* Reserved Bits    */
} __type715;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PBDC45_0:1;                                     /* PBDC45_0         */
    uint16 PBDC45_1:1;                                     /* PBDC45_1         */
    uint16 PBDC45_2:1;                                     /* PBDC45_2         */
    uint16 PBDC45_3:1;                                     /* PBDC45_3         */
    uint16 PBDC45_4:1;                                     /* PBDC45_4         */
    uint16 PBDC45_5:1;                                     /* PBDC45_5         */
    uint16 PBDC45_6:1;                                     /* PBDC45_6         */
    uint16 PBDC45_7:1;                                     /* PBDC45_7         */
    uint16 PBDC45_8:1;                                     /* PBDC45_8         */
    uint16 PBDC45_9:1;                                     /* PBDC45_9         */
    uint16 PBDC45_10:1;                                    /* PBDC45_10        */
    uint16 PBDC45_11:1;                                    /* PBDC45_11        */
    uint16 PBDC45_12:1;                                    /* PBDC45_12        */
    uint16 PBDC45_13:1;                                    /* PBDC45_13        */
    uint16 :2;                                             /* Reserved Bits    */
} __type716;
typedef struct 
{                                                          /* Bit Access       */
    uint16 :1;                                             /* Reserved Bits    */
    uint16 PIPC45_1:1;                                     /* PIPC45_1         */
    uint16 :1;                                             /* Reserved Bits    */
    uint16 PIPC45_3:1;                                     /* PIPC45_3         */
    uint16 :1;                                             /* Reserved Bits    */
    uint16 PIPC45_5:1;                                     /* PIPC45_5         */
    uint16 :6;                                             /* Reserved Bits    */
    uint16 PIPC45_12:1;                                    /* PIPC45_12        */
    uint16 PIPC45_13:1;                                    /* PIPC45_13        */
    uint16 :2;                                             /* Reserved Bits    */
} __type717;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PU45_0:1;                                       /* PU45_0           */
    uint16 PU45_1:1;                                       /* PU45_1           */
    uint16 PU45_2:1;                                       /* PU45_2           */
    uint16 PU45_3:1;                                       /* PU45_3           */
    uint16 PU45_4:1;                                       /* PU45_4           */
    uint16 PU45_5:1;                                       /* PU45_5           */
    uint16 PU45_6:1;                                       /* PU45_6           */
    uint16 PU45_7:1;                                       /* PU45_7           */
    uint16 PU45_8:1;                                       /* PU45_8           */
    uint16 PU45_9:1;                                       /* PU45_9           */
    uint16 PU45_10:1;                                      /* PU45_10          */
    uint16 PU45_11:1;                                      /* PU45_11          */
    uint16 PU45_12:1;                                      /* PU45_12          */
    uint16 PU45_13:1;                                      /* PU45_13          */
    uint16 :2;                                             /* Reserved Bits    */
} __type718;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PD45_0:1;                                       /* PD45_0           */
    uint16 PD45_1:1;                                       /* PD45_1           */
    uint16 PD45_2:1;                                       /* PD45_2           */
    uint16 PD45_3:1;                                       /* PD45_3           */
    uint16 PD45_4:1;                                       /* PD45_4           */
    uint16 PD45_5:1;                                       /* PD45_5           */
    uint16 PD45_6:1;                                       /* PD45_6           */
    uint16 PD45_7:1;                                       /* PD45_7           */
    uint16 PD45_8:1;                                       /* PD45_8           */
    uint16 PD45_9:1;                                       /* PD45_9           */
    uint16 PD45_10:1;                                      /* PD45_10          */
    uint16 PD45_11:1;                                      /* PD45_11          */
    uint16 PD45_12:1;                                      /* PD45_12          */
    uint16 PD45_13:1;                                      /* PD45_13          */
    uint16 :2;                                             /* Reserved Bits    */
} __type719;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PODC45_0:1;                                     /* PODC45_0         */
    uint32 PODC45_1:1;                                     /* PODC45_1         */
    uint32 PODC45_2:1;                                     /* PODC45_2         */
    uint32 PODC45_3:1;                                     /* PODC45_3         */
    uint32 PODC45_4:1;                                     /* PODC45_4         */
    uint32 PODC45_5:1;                                     /* PODC45_5         */
    uint32 PODC45_6:1;                                     /* PODC45_6         */
    uint32 PODC45_7:1;                                     /* PODC45_7         */
    uint32 PODC45_8:1;                                     /* PODC45_8         */
    uint32 PODC45_9:1;                                     /* PODC45_9         */
    uint32 PODC45_10:1;                                    /* PODC45_10        */
    uint32 PODC45_11:1;                                    /* PODC45_11        */
    uint32 PODC45_12:1;                                    /* PODC45_12        */
    uint32 PODC45_13:1;                                    /* PODC45_13        */
    uint32 :18;                                            /* Reserved Bits    */
} __type720;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PDSC45_0:1;                                     /* PDSC45_0         */
    uint32 PDSC45_1:1;                                     /* PDSC45_1         */
    uint32 PDSC45_2:1;                                     /* PDSC45_2         */
    uint32 PDSC45_3:1;                                     /* PDSC45_3         */
    uint32 PDSC45_4:1;                                     /* PDSC45_4         */
    uint32 PDSC45_5:1;                                     /* PDSC45_5         */
    uint32 PDSC45_6:1;                                     /* PDSC45_6         */
    uint32 PDSC45_7:1;                                     /* PDSC45_7         */
    uint32 PDSC45_8:1;                                     /* PDSC45_8         */
    uint32 PDSC45_9:1;                                     /* PDSC45_9         */
    uint32 PDSC45_10:1;                                    /* PDSC45_10        */
    uint32 PDSC45_11:1;                                    /* PDSC45_11        */
    uint32 PDSC45_12:1;                                    /* PDSC45_12        */
    uint32 PDSC45_13:1;                                    /* PDSC45_13        */
    uint32 :18;                                            /* Reserved Bits    */
} __type721;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PIS45_0:1;                                      /* PIS45_0          */
    uint16 PIS45_1:1;                                      /* PIS45_1          */
    uint16 PIS45_2:1;                                      /* PIS45_2          */
    uint16 PIS45_3:1;                                      /* PIS45_3          */
    uint16 PIS45_4:1;                                      /* PIS45_4          */
    uint16 PIS45_5:1;                                      /* PIS45_5          */
    uint16 PIS45_6:1;                                      /* PIS45_6          */
    uint16 PIS45_7:1;                                      /* PIS45_7          */
    uint16 PIS45_8:1;                                      /* PIS45_8          */
    uint16 PIS45_9:1;                                      /* PIS45_9          */
    uint16 PIS45_10:1;                                     /* PIS45_10         */
    uint16 PIS45_11:1;                                     /* PIS45_11         */
    uint16 PIS45_12:1;                                     /* PIS45_12         */
    uint16 PIS45_13:1;                                     /* PIS45_13         */
    uint16 :2;                                             /* Reserved Bits    */
} __type722;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PISA45_0:1;                                     /* PISA45_0         */
    uint16 PISA45_1:1;                                     /* PISA45_1         */
    uint16 PISA45_2:1;                                     /* PISA45_2         */
    uint16 PISA45_3:1;                                     /* PISA45_3         */
    uint16 PISA45_4:1;                                     /* PISA45_4         */
    uint16 PISA45_5:1;                                     /* PISA45_5         */
    uint16 PISA45_6:1;                                     /* PISA45_6         */
    uint16 PISA45_7:1;                                     /* PISA45_7         */
    uint16 PISA45_8:1;                                     /* PISA45_8         */
    uint16 PISA45_9:1;                                     /* PISA45_9         */
    uint16 PISA45_10:1;                                    /* PISA45_10        */
    uint16 PISA45_11:1;                                    /* PISA45_11        */
    uint16 PISA45_12:1;                                    /* PISA45_12        */
    uint16 PISA45_13:1;                                    /* PISA45_13        */
    uint16 :2;                                             /* Reserved Bits    */
} __type723;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PPCMD45:8;                                      /* PPCMD45[7:0]     */
    uint32 :24;                                            /* Reserved Bits    */
} __type724;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PPROTS45PRERR:1;                                /* PPROTS45PRERR    */
    uint32 :31;                                            /* Reserved Bits    */
} __type725;
typedef struct 
{                                                          /* Bit Access       */
    uint16 P0_0:1;                                         /* P0_0             */
    uint16 P0_1:1;                                         /* P0_1             */
    uint16 P0_2:1;                                         /* P0_2             */
    uint16 P0_3:1;                                         /* P0_3             */
    uint16 P0_4:1;                                         /* P0_4             */
    uint16 P0_5:1;                                         /* P0_5             */
    uint16 P0_6:1;                                         /* P0_6             */
    uint16 P0_7:1;                                         /* P0_7             */
    uint16 P0_8:1;                                         /* P0_8             */
    uint16 P0_9:1;                                         /* P0_9             */
    uint16 :6;                                             /* Reserved Bits    */
} __type726;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PSR0_0:1;                                       /* PSR0_0           */
    uint32 PSR0_1:1;                                       /* PSR0_1           */
    uint32 PSR0_2:1;                                       /* PSR0_2           */
    uint32 PSR0_3:1;                                       /* PSR0_3           */
    uint32 PSR0_4:1;                                       /* PSR0_4           */
    uint32 PSR0_5:1;                                       /* PSR0_5           */
    uint32 PSR0_6:1;                                       /* PSR0_6           */
    uint32 PSR0_7:1;                                       /* PSR0_7           */
    uint32 PSR0_8:1;                                       /* PSR0_8           */
    uint32 PSR0_9:1;                                       /* PSR0_9           */
    uint32 :6;                                             /* Reserved Bits    */
    uint32 PSR0_16:1;                                      /* PSR0_16          */
    uint32 PSR0_17:1;                                      /* PSR0_17          */
    uint32 PSR0_18:1;                                      /* PSR0_18          */
    uint32 PSR0_19:1;                                      /* PSR0_19          */
    uint32 PSR0_20:1;                                      /* PSR0_20          */
    uint32 PSR0_21:1;                                      /* PSR0_21          */
    uint32 PSR0_22:1;                                      /* PSR0_22          */
    uint32 PSR0_23:1;                                      /* PSR0_23          */
    uint32 PSR0_24:1;                                      /* PSR0_24          */
    uint32 PSR0_25:1;                                      /* PSR0_25          */
    uint32 :6;                                             /* Reserved Bits    */
} __type727;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PNOT0_0:1;                                      /* PNOT0_0          */
    uint16 PNOT0_1:1;                                      /* PNOT0_1          */
    uint16 PNOT0_2:1;                                      /* PNOT0_2          */
    uint16 PNOT0_3:1;                                      /* PNOT0_3          */
    uint16 PNOT0_4:1;                                      /* PNOT0_4          */
    uint16 PNOT0_5:1;                                      /* PNOT0_5          */
    uint16 PNOT0_6:1;                                      /* PNOT0_6          */
    uint16 PNOT0_7:1;                                      /* PNOT0_7          */
    uint16 PNOT0_8:1;                                      /* PNOT0_8          */
    uint16 PNOT0_9:1;                                      /* PNOT0_9          */
    uint16 :6;                                             /* Reserved Bits    */
} __type728;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PPR0_0:1;                                       /* PPR0_0           */
    uint16 PPR0_1:1;                                       /* PPR0_1           */
    uint16 PPR0_2:1;                                       /* PPR0_2           */
    uint16 PPR0_3:1;                                       /* PPR0_3           */
    uint16 PPR0_4:1;                                       /* PPR0_4           */
    uint16 PPR0_5:1;                                       /* PPR0_5           */
    uint16 PPR0_6:1;                                       /* PPR0_6           */
    uint16 PPR0_7:1;                                       /* PPR0_7           */
    uint16 PPR0_8:1;                                       /* PPR0_8           */
    uint16 PPR0_9:1;                                       /* PPR0_9           */
    uint16 :6;                                             /* Reserved Bits    */
} __type729;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PM0_0:1;                                        /* PM0_0            */
    uint16 PM0_1:1;                                        /* PM0_1            */
    uint16 PM0_2:1;                                        /* PM0_2            */
    uint16 PM0_3:1;                                        /* PM0_3            */
    uint16 PM0_4:1;                                        /* PM0_4            */
    uint16 PM0_5:1;                                        /* PM0_5            */
    uint16 PM0_6:1;                                        /* PM0_6            */
    uint16 PM0_7:1;                                        /* PM0_7            */
    uint16 PM0_8:1;                                        /* PM0_8            */
    uint16 PM0_9:1;                                        /* PM0_9            */
    uint16 :6;                                             /* Reserved Bits    */
} __type730;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PMC0_0:1;                                       /* PMC0_0           */
    uint16 PMC0_1:1;                                       /* PMC0_1           */
    uint16 PMC0_2:1;                                       /* PMC0_2           */
    uint16 PMC0_3:1;                                       /* PMC0_3           */
    uint16 PMC0_4:1;                                       /* PMC0_4           */
    uint16 PMC0_5:1;                                       /* PMC0_5           */
    uint16 PMC0_6:1;                                       /* PMC0_6           */
    uint16 PMC0_7:1;                                       /* PMC0_7           */
    uint16 PMC0_8:1;                                       /* PMC0_8           */
    uint16 PMC0_9:1;                                       /* PMC0_9           */
    uint16 :6;                                             /* Reserved Bits    */
} __type731;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PFC0_0:1;                                       /* PFC0_0           */
    uint16 PFC0_1:1;                                       /* PFC0_1           */
    uint16 PFC0_2:1;                                       /* PFC0_2           */
    uint16 PFC0_3:1;                                       /* PFC0_3           */
    uint16 PFC0_4:1;                                       /* PFC0_4           */
    uint16 PFC0_5:1;                                       /* PFC0_5           */
    uint16 PFC0_6:1;                                       /* PFC0_6           */
    uint16 PFC0_7:1;                                       /* PFC0_7           */
    uint16 PFC0_8:1;                                       /* PFC0_8           */
    uint16 PFC0_9:1;                                       /* PFC0_9           */
    uint16 :6;                                             /* Reserved Bits    */
} __type732;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PFCE0_0:1;                                      /* PFCE0_0          */
    uint16 PFCE0_1:1;                                      /* PFCE0_1          */
    uint16 PFCE0_2:1;                                      /* PFCE0_2          */
    uint16 PFCE0_3:1;                                      /* PFCE0_3          */
    uint16 PFCE0_4:1;                                      /* PFCE0_4          */
    uint16 PFCE0_5:1;                                      /* PFCE0_5          */
    uint16 PFCE0_6:1;                                      /* PFCE0_6          */
    uint16 PFCE0_7:1;                                      /* PFCE0_7          */
    uint16 PFCE0_8:1;                                      /* PFCE0_8          */
    uint16 PFCE0_9:1;                                      /* PFCE0_9          */
    uint16 :6;                                             /* Reserved Bits    */
} __type733;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PMSR0_0:1;                                      /* PMSR0_0          */
    uint32 PMSR0_1:1;                                      /* PMSR0_1          */
    uint32 PMSR0_2:1;                                      /* PMSR0_2          */
    uint32 PMSR0_3:1;                                      /* PMSR0_3          */
    uint32 PMSR0_4:1;                                      /* PMSR0_4          */
    uint32 PMSR0_5:1;                                      /* PMSR0_5          */
    uint32 PMSR0_6:1;                                      /* PMSR0_6          */
    uint32 PMSR0_7:1;                                      /* PMSR0_7          */
    uint32 PMSR0_8:1;                                      /* PMSR0_8          */
    uint32 PMSR0_9:1;                                      /* PMSR0_9          */
    uint32 :6;                                             /* Reserved Bits    */
    uint32 PMSR0_16:1;                                     /* PMSR0_16         */
    uint32 PMSR0_17:1;                                     /* PMSR0_17         */
    uint32 PMSR0_18:1;                                     /* PMSR0_18         */
    uint32 PMSR0_19:1;                                     /* PMSR0_19         */
    uint32 PMSR0_20:1;                                     /* PMSR0_20         */
    uint32 PMSR0_21:1;                                     /* PMSR0_21         */
    uint32 PMSR0_22:1;                                     /* PMSR0_22         */
    uint32 PMSR0_23:1;                                     /* PMSR0_23         */
    uint32 PMSR0_24:1;                                     /* PMSR0_24         */
    uint32 PMSR0_25:1;                                     /* PMSR0_25         */
    uint32 :6;                                             /* Reserved Bits    */
} __type734;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PMCSR0_0:1;                                     /* PMCSR0_0         */
    uint32 PMCSR0_1:1;                                     /* PMCSR0_1         */
    uint32 PMCSR0_2:1;                                     /* PMCSR0_2         */
    uint32 PMCSR0_3:1;                                     /* PMCSR0_3         */
    uint32 PMCSR0_4:1;                                     /* PMCSR0_4         */
    uint32 PMCSR0_5:1;                                     /* PMCSR0_5         */
    uint32 PMCSR0_6:1;                                     /* PMCSR0_6         */
    uint32 PMCSR0_7:1;                                     /* PMCSR0_7         */
    uint32 PMCSR0_8:1;                                     /* PMCSR0_8         */
    uint32 PMCSR0_9:1;                                     /* PMCSR0_9         */
    uint32 :6;                                             /* Reserved Bits    */
    uint32 PMCSR0_16:1;                                    /* PMCSR0_16        */
    uint32 PMCSR0_17:1;                                    /* PMCSR0_17        */
    uint32 PMCSR0_18:1;                                    /* PMCSR0_18        */
    uint32 PMCSR0_19:1;                                    /* PMCSR0_19        */
    uint32 PMCSR0_20:1;                                    /* PMCSR0_20        */
    uint32 PMCSR0_21:1;                                    /* PMCSR0_21        */
    uint32 PMCSR0_22:1;                                    /* PMCSR0_22        */
    uint32 PMCSR0_23:1;                                    /* PMCSR0_23        */
    uint32 PMCSR0_24:1;                                    /* PMCSR0_24        */
    uint32 PMCSR0_25:1;                                    /* PMCSR0_25        */
    uint32 :6;                                             /* Reserved Bits    */
} __type735;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PINV0_0:1;                                      /* PINV0_0          */
    uint16 PINV0_1:1;                                      /* PINV0_1          */
    uint16 PINV0_2:1;                                      /* PINV0_2          */
    uint16 PINV0_3:1;                                      /* PINV0_3          */
    uint16 PINV0_4:1;                                      /* PINV0_4          */
    uint16 PINV0_5:1;                                      /* PINV0_5          */
    uint16 PINV0_6:1;                                      /* PINV0_6          */
    uint16 PINV0_7:1;                                      /* PINV0_7          */
    uint16 PINV0_8:1;                                      /* PINV0_8          */
    uint16 PINV0_9:1;                                      /* PINV0_9          */
    uint16 :6;                                             /* Reserved Bits    */
} __type736;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PCR_PFC0_0:1;                                   /* PCR_PFC0_0       */
    uint32 PCR_PFCE0_0:1;                                  /* PCR_PFCE0_0      */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 PCR_PM0_0:1;                                    /* PCR_PM0_0        */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_PMC0_0:1;                                   /* PCR_PMC0_0       */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_PPR0_0:1;                                   /* PCR_PPR0_0       */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PCR_P0_0:1;                                     /* PCR_P0_0         */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PCR_PIBC0_0:1;                                  /* PCR_PIBC0_0      */
    uint32 PCR_PBDC0_0:1;                                  /* PCR_PBDC0_0      */
    uint32 PCR_PD0_0:1;                                    /* PCR_PD0_0        */
    uint32 PCR_PU0_0:1;                                    /* PCR_PU0_0        */
    uint32 PCR_PIS0_0:1;                                   /* PCR_PIS0_0       */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_PISA0_0:1;                                  /* PCR_PISA0_0      */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_PDSC0_0:1;                                  /* PCR_PDSC0_0      */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PCR_PODC0_0:1;                                  /* PCR_PODC0_0      */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_PINV0_0:1;                                  /* PCR_PINV0_0      */
    uint32 :1;                                             /* Reserved Bits    */
} __type737;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PCR_PFC0_1:1;                                   /* PCR_PFC0_1       */
    uint32 PCR_PFCE0_1:1;                                  /* PCR_PFCE0_1      */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 PCR_PM0_1:1;                                    /* PCR_PM0_1        */
    uint32 PCR_PIPC0_1:1;                                  /* PCR_PIPC0_1      */
    uint32 PCR_PMC0_1:1;                                   /* PCR_PMC0_1       */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_PPR0_1:1;                                   /* PCR_PPR0_1       */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PCR_P0_1:1;                                     /* PCR_P0_1         */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PCR_PIBC0_1:1;                                  /* PCR_PIBC0_1      */
    uint32 PCR_PBDC0_1:1;                                  /* PCR_PBDC0_1      */
    uint32 PCR_PD0_1:1;                                    /* PCR_PD0_1        */
    uint32 PCR_PU0_1:1;                                    /* PCR_PU0_1        */
    uint32 PCR_PIS0_1:1;                                   /* PCR_PIS0_1       */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_PISA0_1:1;                                  /* PCR_PISA0_1      */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_PDSC0_1:1;                                  /* PCR_PDSC0_1      */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PCR_PODC0_1:1;                                  /* PCR_PODC0_1      */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_PINV0_1:1;                                  /* PCR_PINV0_1      */
    uint32 :1;                                             /* Reserved Bits    */
} __type738;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PCR_PFC0_2:1;                                   /* PCR_PFC0_2       */
    uint32 PCR_PFCE0_2:1;                                  /* PCR_PFCE0_2      */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 PCR_PM0_2:1;                                    /* PCR_PM0_2        */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_PMC0_2:1;                                   /* PCR_PMC0_2       */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_PPR0_2:1;                                   /* PCR_PPR0_2       */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PCR_P0_2:1;                                     /* PCR_P0_2         */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PCR_PIBC0_2:1;                                  /* PCR_PIBC0_2      */
    uint32 PCR_PBDC0_2:1;                                  /* PCR_PBDC0_2      */
    uint32 PCR_PD0_2:1;                                    /* PCR_PD0_2        */
    uint32 PCR_PU0_2:1;                                    /* PCR_PU0_2        */
    uint32 PCR_PIS0_2:1;                                   /* PCR_PIS0_2       */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_PISA0_2:1;                                  /* PCR_PISA0_2      */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_PDSC0_2:1;                                  /* PCR_PDSC0_2      */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PCR_PODC0_2:1;                                  /* PCR_PODC0_2      */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_PINV0_2:1;                                  /* PCR_PINV0_2      */
    uint32 :1;                                             /* Reserved Bits    */
} __type739;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PCR_PFC0_3:1;                                   /* PCR_PFC0_3       */
    uint32 PCR_PFCE0_3:1;                                  /* PCR_PFCE0_3      */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 PCR_PM0_3:1;                                    /* PCR_PM0_3        */
    uint32 PCR_PIPC0_3:1;                                  /* PCR_PIPC0_3      */
    uint32 PCR_PMC0_3:1;                                   /* PCR_PMC0_3       */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_PPR0_3:1;                                   /* PCR_PPR0_3       */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PCR_P0_3:1;                                     /* PCR_P0_3         */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PCR_PIBC0_3:1;                                  /* PCR_PIBC0_3      */
    uint32 PCR_PBDC0_3:1;                                  /* PCR_PBDC0_3      */
    uint32 PCR_PD0_3:1;                                    /* PCR_PD0_3        */
    uint32 PCR_PU0_3:1;                                    /* PCR_PU0_3        */
    uint32 PCR_PIS0_3:1;                                   /* PCR_PIS0_3       */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_PISA0_3:1;                                  /* PCR_PISA0_3      */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_PDSC0_3:1;                                  /* PCR_PDSC0_3      */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PCR_PODC0_3:1;                                  /* PCR_PODC0_3      */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_PINV0_3:1;                                  /* PCR_PINV0_3      */
    uint32 :1;                                             /* Reserved Bits    */
} __type740;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PCR_PFC0_4:1;                                   /* PCR_PFC0_4       */
    uint32 PCR_PFCE0_4:1;                                  /* PCR_PFCE0_4      */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 PCR_PM0_4:1;                                    /* PCR_PM0_4        */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_PMC0_4:1;                                   /* PCR_PMC0_4       */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_PPR0_4:1;                                   /* PCR_PPR0_4       */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PCR_P0_4:1;                                     /* PCR_P0_4         */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PCR_PIBC0_4:1;                                  /* PCR_PIBC0_4      */
    uint32 PCR_PBDC0_4:1;                                  /* PCR_PBDC0_4      */
    uint32 PCR_PD0_4:1;                                    /* PCR_PD0_4        */
    uint32 PCR_PU0_4:1;                                    /* PCR_PU0_4        */
    uint32 PCR_PIS0_4:1;                                   /* PCR_PIS0_4       */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_PISA0_4:1;                                  /* PCR_PISA0_4      */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_PDSC0_4:1;                                  /* PCR_PDSC0_4      */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PCR_PODC0_4:1;                                  /* PCR_PODC0_4      */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_PINV0_4:1;                                  /* PCR_PINV0_4      */
    uint32 :1;                                             /* Reserved Bits    */
} __type741;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PCR_PFC0_5:1;                                   /* PCR_PFC0_5       */
    uint32 PCR_PFCE0_5:1;                                  /* PCR_PFCE0_5      */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 PCR_PM0_5:1;                                    /* PCR_PM0_5        */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_PMC0_5:1;                                   /* PCR_PMC0_5       */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_PPR0_5:1;                                   /* PCR_PPR0_5       */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PCR_P0_5:1;                                     /* PCR_P0_5         */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PCR_PIBC0_5:1;                                  /* PCR_PIBC0_5      */
    uint32 PCR_PBDC0_5:1;                                  /* PCR_PBDC0_5      */
    uint32 PCR_PD0_5:1;                                    /* PCR_PD0_5        */
    uint32 PCR_PU0_5:1;                                    /* PCR_PU0_5        */
    uint32 PCR_PIS0_5:1;                                   /* PCR_PIS0_5       */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_PISA0_5:1;                                  /* PCR_PISA0_5      */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_PDSC0_5:1;                                  /* PCR_PDSC0_5      */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PCR_PODC0_5:1;                                  /* PCR_PODC0_5      */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_PINV0_5:1;                                  /* PCR_PINV0_5      */
    uint32 :1;                                             /* Reserved Bits    */
} __type742;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PCR_PFC0_6:1;                                   /* PCR_PFC0_6       */
    uint32 PCR_PFCE0_6:1;                                  /* PCR_PFCE0_6      */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 PCR_PM0_6:1;                                    /* PCR_PM0_6        */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_PMC0_6:1;                                   /* PCR_PMC0_6       */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_PPR0_6:1;                                   /* PCR_PPR0_6       */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PCR_P0_6:1;                                     /* PCR_P0_6         */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PCR_PIBC0_6:1;                                  /* PCR_PIBC0_6      */
    uint32 PCR_PBDC0_6:1;                                  /* PCR_PBDC0_6      */
    uint32 PCR_PD0_6:1;                                    /* PCR_PD0_6        */
    uint32 PCR_PU0_6:1;                                    /* PCR_PU0_6        */
    uint32 PCR_PIS0_6:1;                                   /* PCR_PIS0_6       */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_PISA0_6:1;                                  /* PCR_PISA0_6      */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_PDSC0_6:1;                                  /* PCR_PDSC0_6      */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PCR_PODC0_6:1;                                  /* PCR_PODC0_6      */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_PINV0_6:1;                                  /* PCR_PINV0_6      */
    uint32 :1;                                             /* Reserved Bits    */
} __type743;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PCR_PFC0_7:1;                                   /* PCR_PFC0_7       */
    uint32 PCR_PFCE0_7:1;                                  /* PCR_PFCE0_7      */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 PCR_PM0_7:1;                                    /* PCR_PM0_7        */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_PMC0_7:1;                                   /* PCR_PMC0_7       */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_PPR0_7:1;                                   /* PCR_PPR0_7       */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PCR_P0_7:1;                                     /* PCR_P0_7         */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PCR_PIBC0_7:1;                                  /* PCR_PIBC0_7      */
    uint32 PCR_PBDC0_7:1;                                  /* PCR_PBDC0_7      */
    uint32 PCR_PD0_7:1;                                    /* PCR_PD0_7        */
    uint32 PCR_PU0_7:1;                                    /* PCR_PU0_7        */
    uint32 PCR_PIS0_7:1;                                   /* PCR_PIS0_7       */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_PISA0_7:1;                                  /* PCR_PISA0_7      */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_PDSC0_7:1;                                  /* PCR_PDSC0_7      */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PCR_PODC0_7:1;                                  /* PCR_PODC0_7      */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_PINV0_7:1;                                  /* PCR_PINV0_7      */
    uint32 :1;                                             /* Reserved Bits    */
} __type744;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PCR_PFC0_8:1;                                   /* PCR_PFC0_8       */
    uint32 PCR_PFCE0_8:1;                                  /* PCR_PFCE0_8      */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 PCR_PM0_8:1;                                    /* PCR_PM0_8        */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_PMC0_8:1;                                   /* PCR_PMC0_8       */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_PPR0_8:1;                                   /* PCR_PPR0_8       */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PCR_P0_8:1;                                     /* PCR_P0_8         */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PCR_PIBC0_8:1;                                  /* PCR_PIBC0_8      */
    uint32 PCR_PBDC0_8:1;                                  /* PCR_PBDC0_8      */
    uint32 PCR_PD0_8:1;                                    /* PCR_PD0_8        */
    uint32 PCR_PU0_8:1;                                    /* PCR_PU0_8        */
    uint32 PCR_PIS0_8:1;                                   /* PCR_PIS0_8       */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_PISA0_8:1;                                  /* PCR_PISA0_8      */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_PDSC0_8:1;                                  /* PCR_PDSC0_8      */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PCR_PODC0_8:1;                                  /* PCR_PODC0_8      */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_PINV0_8:1;                                  /* PCR_PINV0_8      */
    uint32 :1;                                             /* Reserved Bits    */
} __type745;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PCR_PFC0_9:1;                                   /* PCR_PFC0_9       */
    uint32 PCR_PFCE0_9:1;                                  /* PCR_PFCE0_9      */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 PCR_PM0_9:1;                                    /* PCR_PM0_9        */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_PMC0_9:1;                                   /* PCR_PMC0_9       */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_PPR0_9:1;                                   /* PCR_PPR0_9       */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PCR_P0_9:1;                                     /* PCR_P0_9         */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PCR_PIBC0_9:1;                                  /* PCR_PIBC0_9      */
    uint32 PCR_PBDC0_9:1;                                  /* PCR_PBDC0_9      */
    uint32 PCR_PD0_9:1;                                    /* PCR_PD0_9        */
    uint32 PCR_PU0_9:1;                                    /* PCR_PU0_9        */
    uint32 PCR_PIS0_9:1;                                   /* PCR_PIS0_9       */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_PISA0_9:1;                                  /* PCR_PISA0_9      */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_PDSC0_9:1;                                  /* PCR_PDSC0_9      */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PCR_PODC0_9:1;                                  /* PCR_PODC0_9      */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_PINV0_9:1;                                  /* PCR_PINV0_9      */
    uint32 :1;                                             /* Reserved Bits    */
} __type746;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PIBC0_0:1;                                      /* PIBC0_0          */
    uint16 PIBC0_1:1;                                      /* PIBC0_1          */
    uint16 PIBC0_2:1;                                      /* PIBC0_2          */
    uint16 PIBC0_3:1;                                      /* PIBC0_3          */
    uint16 PIBC0_4:1;                                      /* PIBC0_4          */
    uint16 PIBC0_5:1;                                      /* PIBC0_5          */
    uint16 PIBC0_6:1;                                      /* PIBC0_6          */
    uint16 PIBC0_7:1;                                      /* PIBC0_7          */
    uint16 PIBC0_8:1;                                      /* PIBC0_8          */
    uint16 PIBC0_9:1;                                      /* PIBC0_9          */
    uint16 :6;                                             /* Reserved Bits    */
} __type747;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PBDC0_0:1;                                      /* PBDC0_0          */
    uint16 PBDC0_1:1;                                      /* PBDC0_1          */
    uint16 PBDC0_2:1;                                      /* PBDC0_2          */
    uint16 PBDC0_3:1;                                      /* PBDC0_3          */
    uint16 PBDC0_4:1;                                      /* PBDC0_4          */
    uint16 PBDC0_5:1;                                      /* PBDC0_5          */
    uint16 PBDC0_6:1;                                      /* PBDC0_6          */
    uint16 PBDC0_7:1;                                      /* PBDC0_7          */
    uint16 PBDC0_8:1;                                      /* PBDC0_8          */
    uint16 PBDC0_9:1;                                      /* PBDC0_9          */
    uint16 :6;                                             /* Reserved Bits    */
} __type748;
typedef struct 
{                                                          /* Bit Access       */
    uint16 :1;                                             /* Reserved Bits    */
    uint16 PIPC0_1:1;                                      /* PIPC0_1          */
    uint16 :1;                                             /* Reserved Bits    */
    uint16 PIPC0_3:1;                                      /* PIPC0_3          */
    uint16 :12;                                            /* Reserved Bits    */
} __type749;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PU0_0:1;                                        /* PU0_0            */
    uint16 PU0_1:1;                                        /* PU0_1            */
    uint16 PU0_2:1;                                        /* PU0_2            */
    uint16 PU0_3:1;                                        /* PU0_3            */
    uint16 PU0_4:1;                                        /* PU0_4            */
    uint16 PU0_5:1;                                        /* PU0_5            */
    uint16 PU0_6:1;                                        /* PU0_6            */
    uint16 PU0_7:1;                                        /* PU0_7            */
    uint16 PU0_8:1;                                        /* PU0_8            */
    uint16 PU0_9:1;                                        /* PU0_9            */
    uint16 :6;                                             /* Reserved Bits    */
} __type750;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PD0_0:1;                                        /* PD0_0            */
    uint16 PD0_1:1;                                        /* PD0_1            */
    uint16 PD0_2:1;                                        /* PD0_2            */
    uint16 PD0_3:1;                                        /* PD0_3            */
    uint16 PD0_4:1;                                        /* PD0_4            */
    uint16 PD0_5:1;                                        /* PD0_5            */
    uint16 PD0_6:1;                                        /* PD0_6            */
    uint16 PD0_7:1;                                        /* PD0_7            */
    uint16 PD0_8:1;                                        /* PD0_8            */
    uint16 PD0_9:1;                                        /* PD0_9            */
    uint16 :6;                                             /* Reserved Bits    */
} __type751;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PODC0_0:1;                                      /* PODC0_0          */
    uint32 PODC0_1:1;                                      /* PODC0_1          */
    uint32 PODC0_2:1;                                      /* PODC0_2          */
    uint32 PODC0_3:1;                                      /* PODC0_3          */
    uint32 PODC0_4:1;                                      /* PODC0_4          */
    uint32 PODC0_5:1;                                      /* PODC0_5          */
    uint32 PODC0_6:1;                                      /* PODC0_6          */
    uint32 PODC0_7:1;                                      /* PODC0_7          */
    uint32 PODC0_8:1;                                      /* PODC0_8          */
    uint32 PODC0_9:1;                                      /* PODC0_9          */
    uint32 :22;                                            /* Reserved Bits    */
} __type752;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PDSC0_0:1;                                      /* PDSC0_0          */
    uint32 PDSC0_1:1;                                      /* PDSC0_1          */
    uint32 PDSC0_2:1;                                      /* PDSC0_2          */
    uint32 PDSC0_3:1;                                      /* PDSC0_3          */
    uint32 PDSC0_4:1;                                      /* PDSC0_4          */
    uint32 PDSC0_5:1;                                      /* PDSC0_5          */
    uint32 PDSC0_6:1;                                      /* PDSC0_6          */
    uint32 PDSC0_7:1;                                      /* PDSC0_7          */
    uint32 PDSC0_8:1;                                      /* PDSC0_8          */
    uint32 PDSC0_9:1;                                      /* PDSC0_9          */
    uint32 :22;                                            /* Reserved Bits    */
} __type753;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PIS0_0:1;                                       /* PIS0_0           */
    uint16 PIS0_1:1;                                       /* PIS0_1           */
    uint16 PIS0_2:1;                                       /* PIS0_2           */
    uint16 PIS0_3:1;                                       /* PIS0_3           */
    uint16 PIS0_4:1;                                       /* PIS0_4           */
    uint16 PIS0_5:1;                                       /* PIS0_5           */
    uint16 PIS0_6:1;                                       /* PIS0_6           */
    uint16 PIS0_7:1;                                       /* PIS0_7           */
    uint16 PIS0_8:1;                                       /* PIS0_8           */
    uint16 PIS0_9:1;                                       /* PIS0_9           */
    uint16 :6;                                             /* Reserved Bits    */
} __type754;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PISA0_0:1;                                      /* PISA0_0          */
    uint16 PISA0_1:1;                                      /* PISA0_1          */
    uint16 PISA0_2:1;                                      /* PISA0_2          */
    uint16 PISA0_3:1;                                      /* PISA0_3          */
    uint16 PISA0_4:1;                                      /* PISA0_4          */
    uint16 PISA0_5:1;                                      /* PISA0_5          */
    uint16 PISA0_6:1;                                      /* PISA0_6          */
    uint16 PISA0_7:1;                                      /* PISA0_7          */
    uint16 PISA0_8:1;                                      /* PISA0_8          */
    uint16 PISA0_9:1;                                      /* PISA0_9          */
    uint16 :6;                                             /* Reserved Bits    */
} __type755;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PPCMD0:8;                                       /* PPCMD0[7:0]      */
    uint32 :24;                                            /* Reserved Bits    */
} __type756;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PPROTS0PRERR:1;                                 /* PPROTS0PRERR     */
    uint32 :31;                                            /* Reserved Bits    */
} __type757;
typedef struct 
{                                                          /* Bit Access       */
    uint8  JP0_0:1;                                        /* JP0_0            */
    uint8  JP0_1:1;                                        /* JP0_1            */
    uint8  JP0_2:1;                                        /* JP0_2            */
    uint8  JP0_3:1;                                        /* JP0_3            */
    uint8  JP0_4:1;                                        /* JP0_4            */
    uint8  JP0_5:1;                                        /* JP0_5            */
    uint8  :2;                                             /* Reserved Bits    */
} __type758;
typedef struct 
{                                                          /* Bit Access       */
    uint32 JPSR0_0:1;                                      /* JPSR0_0          */
    uint32 JPSR0_1:1;                                      /* JPSR0_1          */
    uint32 JPSR0_2:1;                                      /* JPSR0_2          */
    uint32 JPSR0_3:1;                                      /* JPSR0_3          */
    uint32 JPSR0_4:1;                                      /* JPSR0_4          */
    uint32 JPSR0_5:1;                                      /* JPSR0_5          */
    uint32 :10;                                            /* Reserved Bits    */
    uint32 JPSR0_16:1;                                     /* JPSR0_16         */
    uint32 JPSR0_17:1;                                     /* JPSR0_17         */
    uint32 JPSR0_18:1;                                     /* JPSR0_18         */
    uint32 JPSR0_19:1;                                     /* JPSR0_19         */
    uint32 JPSR0_20:1;                                     /* JPSR0_20         */
    uint32 JPSR0_21:1;                                     /* JPSR0_21         */
    uint32 :10;                                            /* Reserved Bits    */
} __type759;
typedef struct 
{                                                          /* Bit Access       */
    uint8  JPNOT0_0:1;                                     /* JPNOT0_0         */
    uint8  JPNOT0_1:1;                                     /* JPNOT0_1         */
    uint8  JPNOT0_2:1;                                     /* JPNOT0_2         */
    uint8  JPNOT0_3:1;                                     /* JPNOT0_3         */
    uint8  JPNOT0_4:1;                                     /* JPNOT0_4         */
    uint8  JPNOT0_5:1;                                     /* JPNOT0_5         */
    uint8  :2;                                             /* Reserved Bits    */
} __type760;
typedef struct 
{                                                          /* Bit Access       */
    uint8  JPPR0_0:1;                                      /* JPPR0_0          */
    uint8  JPPR0_1:1;                                      /* JPPR0_1          */
    uint8  JPPR0_2:1;                                      /* JPPR0_2          */
    uint8  JPPR0_3:1;                                      /* JPPR0_3          */
    uint8  JPPR0_4:1;                                      /* JPPR0_4          */
    uint8  JPPR0_5:1;                                      /* JPPR0_5          */
    uint8  :2;                                             /* Reserved Bits    */
} __type761;
typedef struct 
{                                                          /* Bit Access       */
    uint8  JPM0_0:1;                                       /* JPM0_0           */
    uint8  JPM0_1:1;                                       /* JPM0_1           */
    uint8  JPM0_2:1;                                       /* JPM0_2           */
    uint8  JPM0_3:1;                                       /* JPM0_3           */
    uint8  JPM0_4:1;                                       /* JPM0_4           */
    uint8  JPM0_5:1;                                       /* JPM0_5           */
    uint8  :2;                                             /* Reserved Bits    */
} __type762;
typedef struct 
{                                                          /* Bit Access       */
    uint8  JPMC0_0:1;                                      /* JPMC0_0          */
    uint8  JPMC0_1:1;                                      /* JPMC0_1          */
    uint8  JPMC0_2:1;                                      /* JPMC0_2          */
    uint8  JPMC0_3:1;                                      /* JPMC0_3          */
    uint8  JPMC0_4:1;                                      /* JPMC0_4          */
    uint8  JPMC0_5:1;                                      /* JPMC0_5          */
    uint8  :2;                                             /* Reserved Bits    */
} __type763;
typedef struct 
{                                                          /* Bit Access       */
    uint8  JPFC0_0:1;                                      /* JPFC0_0          */
    uint8  JPFC0_1:1;                                      /* JPFC0_1          */
    uint8  JPFC0_2:1;                                      /* JPFC0_2          */
    uint8  JPFC0_3:1;                                      /* JPFC0_3          */
    uint8  :1;                                             /* Reserved Bits    */
    uint8  JPFC0_5:1;                                      /* JPFC0_5          */
    uint8  :2;                                             /* Reserved Bits    */
} __type764;
typedef struct 
{                                                          /* Bit Access       */
    uint8  JPFCE0_0:1;                                     /* JPFCE0_0         */
    uint8  JPFCE0_1:1;                                     /* JPFCE0_1         */
    uint8  JPFCE0_2:1;                                     /* JPFCE0_2         */
    uint8  JPFCE0_3:1;                                     /* JPFCE0_3         */
    uint8  :1;                                             /* Reserved Bits    */
    uint8  JPFCE0_5:1;                                     /* JPFCE0_5         */
    uint8  :2;                                             /* Reserved Bits    */
} __type765;
typedef struct 
{                                                          /* Bit Access       */
    uint32 JPMSR0_0:1;                                     /* JPMSR0_0         */
    uint32 JPMSR0_1:1;                                     /* JPMSR0_1         */
    uint32 JPMSR0_2:1;                                     /* JPMSR0_2         */
    uint32 JPMSR0_3:1;                                     /* JPMSR0_3         */
    uint32 JPMSR0_4:1;                                     /* JPMSR0_4         */
    uint32 JPMSR0_5:1;                                     /* JPMSR0_5         */
    uint32 :10;                                            /* Reserved Bits    */
    uint32 JPMSR0_16:1;                                    /* JPMSR0_16        */
    uint32 JPMSR0_17:1;                                    /* JPMSR0_17        */
    uint32 JPMSR0_18:1;                                    /* JPMSR0_18        */
    uint32 JPMSR0_19:1;                                    /* JPMSR0_19        */
    uint32 JPMSR0_20:1;                                    /* JPMSR0_20        */
    uint32 JPMSR0_21:1;                                    /* JPMSR0_21        */
    uint32 :10;                                            /* Reserved Bits    */
} __type766;
typedef struct 
{                                                          /* Bit Access       */
    uint32 JPMCSR0_0:1;                                    /* JPMCSR0_0        */
    uint32 JPMCSR0_1:1;                                    /* JPMCSR0_1        */
    uint32 JPMCSR0_2:1;                                    /* JPMCSR0_2        */
    uint32 JPMCSR0_3:1;                                    /* JPMCSR0_3        */
    uint32 JPMCSR0_4:1;                                    /* JPMCSR0_4        */
    uint32 JPMCSR0_5:1;                                    /* JPMCSR0_5        */
    uint32 :10;                                            /* Reserved Bits    */
    uint32 JPMCSR0_16:1;                                   /* JPMCSR0_16       */
    uint32 JPMCSR0_17:1;                                   /* JPMCSR0_17       */
    uint32 JPMCSR0_18:1;                                   /* JPMCSR0_18       */
    uint32 JPMCSR0_19:1;                                   /* JPMCSR0_19       */
    uint32 JPMCSR0_20:1;                                   /* JPMCSR0_20       */
    uint32 JPMCSR0_21:1;                                   /* JPMCSR0_21       */
    uint32 :10;                                            /* Reserved Bits    */
} __type767;
typedef struct 
{                                                          /* Bit Access       */
    uint8  JPINV0_0:1;                                     /* JPINV0_0         */
    uint8  JPINV0_1:1;                                     /* JPINV0_1         */
    uint8  JPINV0_2:1;                                     /* JPINV0_2         */
    uint8  JPINV0_3:1;                                     /* JPINV0_3         */
    uint8  JPINV0_4:1;                                     /* JPINV0_4         */
    uint8  JPINV0_5:1;                                     /* JPINV0_5         */
    uint8  :2;                                             /* Reserved Bits    */
} __type768;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PCR_JPFC0_0:1;                                  /* PCR_JPFC0_0      */
    uint32 PCR_JPFCE0_0:1;                                 /* PCR_JPFCE0_0     */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 PCR_JPM0_0:1;                                   /* PCR_JPM0_0       */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_JPMC0_0:1;                                  /* PCR_JPMC0_0      */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_JPPR0_0:1;                                  /* PCR_JPPR0_0      */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PCR_JP0_0:1;                                    /* PCR_JP0_0        */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PCR_JPIBC0_0:1;                                 /* PCR_JPIBC0_0     */
    uint32 PCR_JPBDC0_0:1;                                 /* PCR_JPBDC0_0     */
    uint32 PCR_JPD0_0:1;                                   /* PCR_JPD0_0       */
    uint32 PCR_JPU0_0:1;                                   /* PCR_JPU0_0       */
    uint32 PCR_JPIS0_0:1;                                  /* PCR_JPIS0_0      */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_JPISA0_0:1;                                 /* PCR_JPISA0_0     */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 PCR_JPODC0_0:1;                                 /* PCR_JPODC0_0     */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_JPINV0_0:1;                                 /* PCR_JPINV0_0     */
    uint32 :1;                                             /* Reserved Bits    */
} __type769;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PCR_JPFC0_1:1;                                  /* PCR_JPFC0_1      */
    uint32 PCR_JPFCE0_1:1;                                 /* PCR_JPFCE0_1     */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 PCR_JPM0_1:1;                                   /* PCR_JPM0_1       */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_JPMC0_1:1;                                  /* PCR_JPMC0_1      */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_JPPR0_1:1;                                  /* PCR_JPPR0_1      */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PCR_JP0_1:1;                                    /* PCR_JP0_1        */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PCR_JPIBC0_1:1;                                 /* PCR_JPIBC0_1     */
    uint32 PCR_JPBDC0_1:1;                                 /* PCR_JPBDC0_1     */
    uint32 PCR_JPD0_1:1;                                   /* PCR_JPD0_1       */
    uint32 PCR_JPU0_1:1;                                   /* PCR_JPU0_1       */
    uint32 :4;                                             /* Reserved Bits    */
    uint32 PCR_JPDSC0_1:1;                                 /* PCR_JPDSC0_1     */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PCR_JPODC0_1:1;                                 /* PCR_JPODC0_1     */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_JPINV0_1:1;                                 /* PCR_JPINV0_1     */
    uint32 :1;                                             /* Reserved Bits    */
} __type770;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PCR_JPFC0_2:1;                                  /* PCR_JPFC0_2      */
    uint32 PCR_JPFCE0_2:1;                                 /* PCR_JPFCE0_2     */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 PCR_JPM0_2:1;                                   /* PCR_JPM0_2       */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_JPMC0_2:1;                                  /* PCR_JPMC0_2      */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_JPPR0_2:1;                                  /* PCR_JPPR0_2      */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PCR_JP0_2:1;                                    /* PCR_JP0_2        */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PCR_JPIBC0_2:1;                                 /* PCR_JPIBC0_2     */
    uint32 PCR_JPBDC0_2:1;                                 /* PCR_JPBDC0_2     */
    uint32 PCR_JPD0_2:1;                                   /* PCR_JPD0_2       */
    uint32 PCR_JPU0_2:1;                                   /* PCR_JPU0_2       */
    uint32 PCR_JPIS0_2:1;                                  /* PCR_JPIS0_2      */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_JPISA0_2:1;                                 /* PCR_JPISA0_2     */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 PCR_JPODC0_2:1;                                 /* PCR_JPODC0_2     */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_JPINV0_2:1;                                 /* PCR_JPINV0_2     */
    uint32 :1;                                             /* Reserved Bits    */
} __type771;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PCR_JPFC0_3:1;                                  /* PCR_JPFC0_3      */
    uint32 PCR_JPFCE0_3:1;                                 /* PCR_JPFCE0_3     */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 PCR_JPM0_3:1;                                   /* PCR_JPM0_3       */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_JPMC0_3:1;                                  /* PCR_JPMC0_3      */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_JPPR0_3:1;                                  /* PCR_JPPR0_3      */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PCR_JP0_3:1;                                    /* PCR_JP0_3        */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PCR_JPIBC0_3:1;                                 /* PCR_JPIBC0_3     */
    uint32 PCR_JPBDC0_3:1;                                 /* PCR_JPBDC0_3     */
    uint32 PCR_JPD0_3:1;                                   /* PCR_JPD0_3       */
    uint32 PCR_JPU0_3:1;                                   /* PCR_JPU0_3       */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 PCR_JPISA0_3:1;                                 /* PCR_JPISA0_3     */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 PCR_JPODC0_3:1;                                 /* PCR_JPODC0_3     */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_JPINV0_3:1;                                 /* PCR_JPINV0_3     */
    uint32 :1;                                             /* Reserved Bits    */
} __type772;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :4;                                             /* Reserved Bits    */
    uint32 PCR_JPM0_4:1;                                   /* PCR_JPM0_4       */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_JPMC0_4:1;                                  /* PCR_JPMC0_4      */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_JPPR0_4:1;                                  /* PCR_JPPR0_4      */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PCR_JP0_4:1;                                    /* PCR_JP0_4        */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PCR_JPIBC0_4:1;                                 /* PCR_JPIBC0_4     */
    uint32 PCR_JPBDC0_4:1;                                 /* PCR_JPBDC0_4     */
    uint32 PCR_JPD0_4:1;                                   /* PCR_JPD0_4       */
    uint32 PCR_JPU0_4:1;                                   /* PCR_JPU0_4       */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 PCR_JPISA0_4:1;                                 /* PCR_JPISA0_4     */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 PCR_JPODC0_4:1;                                 /* PCR_JPODC0_4     */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_JPINV0_4:1;                                 /* PCR_JPINV0_4     */
    uint32 :1;                                             /* Reserved Bits    */
} __type773;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PCR_JPFC0_5:1;                                  /* PCR_JPFC0_5      */
    uint32 PCR_JPFCE0_5:1;                                 /* PCR_JPFCE0_5     */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 PCR_JPM0_5:1;                                   /* PCR_JPM0_5       */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_JPMC0_5:1;                                  /* PCR_JPMC0_5      */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_JPPR0_5:1;                                  /* PCR_JPPR0_5      */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PCR_JP0_5:1;                                    /* PCR_JP0_5        */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PCR_JPIBC0_5:1;                                 /* PCR_JPIBC0_5     */
    uint32 PCR_JPBDC0_5:1;                                 /* PCR_JPBDC0_5     */
    uint32 PCR_JPD0_5:1;                                   /* PCR_JPD0_5       */
    uint32 PCR_JPU0_5:1;                                   /* PCR_JPU0_5       */
    uint32 :4;                                             /* Reserved Bits    */
    uint32 PCR_JPDSC0_5:1;                                 /* PCR_JPDSC0_5     */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 PCR_JPODC0_5:1;                                 /* PCR_JPODC0_5     */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PCR_JPINV0_5:1;                                 /* PCR_JPINV0_5     */
    uint32 :1;                                             /* Reserved Bits    */
} __type774;
typedef struct 
{                                                          /* Bit Access       */
    uint8  JPIBC0_0:1;                                     /* JPIBC0_0         */
    uint8  JPIBC0_1:1;                                     /* JPIBC0_1         */
    uint8  JPIBC0_2:1;                                     /* JPIBC0_2         */
    uint8  JPIBC0_3:1;                                     /* JPIBC0_3         */
    uint8  JPIBC0_4:1;                                     /* JPIBC0_4         */
    uint8  JPIBC0_5:1;                                     /* JPIBC0_5         */
    uint8  :2;                                             /* Reserved Bits    */
} __type775;
typedef struct 
{                                                          /* Bit Access       */
    uint8  JPBDC0_0:1;                                     /* JPBDC0_0         */
    uint8  JPBDC0_1:1;                                     /* JPBDC0_1         */
    uint8  JPBDC0_2:1;                                     /* JPBDC0_2         */
    uint8  JPBDC0_3:1;                                     /* JPBDC0_3         */
    uint8  JPBDC0_4:1;                                     /* JPBDC0_4         */
    uint8  JPBDC0_5:1;                                     /* JPBDC0_5         */
    uint8  :2;                                             /* Reserved Bits    */
} __type776;
typedef struct 
{                                                          /* Bit Access       */
    uint8  JPU0_0:1;                                       /* JPU0_0           */
    uint8  JPU0_1:1;                                       /* JPU0_1           */
    uint8  JPU0_2:1;                                       /* JPU0_2           */
    uint8  JPU0_3:1;                                       /* JPU0_3           */
    uint8  JPU0_4:1;                                       /* JPU0_4           */
    uint8  JPU0_5:1;                                       /* JPU0_5           */
    uint8  :2;                                             /* Reserved Bits    */
} __type777;
typedef struct 
{                                                          /* Bit Access       */
    uint8  JPD0_0:1;                                       /* JPD0_0           */
    uint8  JPD0_1:1;                                       /* JPD0_1           */
    uint8  JPD0_2:1;                                       /* JPD0_2           */
    uint8  JPD0_3:1;                                       /* JPD0_3           */
    uint8  JPD0_4:1;                                       /* JPD0_4           */
    uint8  JPD0_5:1;                                       /* JPD0_5           */
    uint8  :2;                                             /* Reserved Bits    */
} __type778;
typedef struct 
{                                                          /* Bit Access       */
    uint32 JPODC0_0:1;                                     /* JPODC0_0         */
    uint32 JPODC0_1:1;                                     /* JPODC0_1         */
    uint32 JPODC0_2:1;                                     /* JPODC0_2         */
    uint32 JPODC0_3:1;                                     /* JPODC0_3         */
    uint32 JPODC0_4:1;                                     /* JPODC0_4         */
    uint32 JPODC0_5:1;                                     /* JPODC0_5         */
    uint32 :26;                                            /* Reserved Bits    */
} __type779;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 JPDSC0_1:1;                                     /* JPDSC0_1         */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 JPDSC0_5:1;                                     /* JPDSC0_5         */
    uint32 :26;                                            /* Reserved Bits    */
} __type780;
typedef struct 
{                                                          /* Bit Access       */
    uint8  JPIS0_0:1;                                      /* JPIS0_0          */
    uint8  :1;                                             /* Reserved Bits    */
    uint8  JPIS0_2:1;                                      /* JPIS0_2          */
    uint8  :5;                                             /* Reserved Bits    */
} __type781;
typedef struct 
{                                                          /* Bit Access       */
    uint8  JPISA0_0:1;                                     /* JPISA0_0         */
    uint8  :1;                                             /* Reserved Bits    */
    uint8  JPISA0_2:1;                                     /* JPISA0_2         */
    uint8  JPISA0_3:1;                                     /* JPISA0_3         */
    uint8  JPISA0_4:1;                                     /* JPISA0_4         */
    uint8  :3;                                             /* Reserved Bits    */
} __type782;
typedef struct 
{                                                          /* Bit Access       */
    uint32 JPPCMD0:8;                                      /* JPPCMD0[7:0]     */
    uint32 :24;                                            /* Reserved Bits    */
} __type783;
typedef struct 
{                                                          /* Bit Access       */
    uint32 JPPROTS0PRERR:1;                                /* JPPROTS0PRERR    */
    uint32 :31;                                            /* Reserved Bits    */
} __type784;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PUP:1;                                          /* PUP              */
    uint32 :31;                                            /* Reserved Bits    */
} __type785;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PC:8;                                           /* PC[7:0]          */
    uint32 :24;                                            /* Reserved Bits    */
} __type786;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PRERR:1;                                        /* PRERR            */
    uint32 :31;                                            /* Reserved Bits    */
} __type787;
typedef struct 
{                                                          /* Bit Access       */
    uint8  IDST:1;                                         /* IDST             */
    uint8  :7;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type788;
typedef struct 
{                                                          /* Bit Access       */
    uint8  :7;                                             /* Reserved Bits    */
    uint8  FWE:1;                                          /* FWE              */
} __type789;
typedef struct 
{                                                          /* Bit Access       */
    uint8  ECRCT:1;                                        /* ECRCT            */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  DFAE:1;                                         /* DFAE             */
    uint8  CMDLK:1;                                        /* CMDLK            */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  CFAE:1;                                         /* CFAE             */
} __type790;
typedef struct 
{                                                          /* Bit Access       */
    uint8  ECRCTIE:1;                                      /* ECRCTIE          */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  DFAEIE:1;                                       /* DFAEIE           */
    uint8  CMDLKIE:1;                                      /* CMDLKIE          */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  CFAEIE:1;                                       /* CFAEIE           */
} __type791;
typedef struct 
{                                                          /* Bit Access       */
    uint16 :1;                                             /* Reserved Bits    */
    uint16 CFAS:1;                                         /* CFAS             */
    uint16 :6;                                             /* Reserved Bits    */
    uint16 KEY:8;                                          /* KEY[15:8]        */
} __type792;
typedef struct 
{                                                          /* Bit Access       */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBLCRCT:1;                                      /* TBLCRCT          */
    uint8  TBLDTCT:1;                                      /* TBLDTCT          */
    uint8  CFGCRCT:1;                                      /* CFGCRCT          */
    uint8  CFGDTCT:1;                                      /* CFGDTCT          */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  PRGSPD:1;                                       /* PRGSPD           */
    uint8  ERSSPD:1;                                       /* ERSSPD           */
    uint8  DBFULL:1;                                       /* DBFULL           */
    uint8  SUSRDY:1;                                       /* SUSRDY           */
    uint8  PRGERR:1;                                       /* PRGERR           */
    uint8  ERSERR:1;                                       /* ERSERR           */
    uint8  ILGLERR:1;                                      /* ILGLERR          */
    uint8  FRDY:1;                                         /* FRDY             */
    uint8  OTPCRCT:1;                                      /* OTPCRCT          */
    uint8  OTPDTCT:1;                                      /* OTPDTCT          */
    uint8  EBFULL:1;                                       /* EBFULL           */
    uint8  :5;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type793;
typedef struct 
{                                                          /* Bit Access       */
    uint16 FENTRYC:1;                                      /* FENTRYC          */
    uint16 :6;                                             /* Reserved Bits    */
    uint16 FENTRYD:1;                                      /* FENTRYD          */
    uint16 KEY:8;                                          /* KEY[15:8]        */
} __type794;
typedef struct 
{                                                          /* Bit Access       */
    uint16 FPROTCN:1;                                      /* FPROTCN          */
    uint16 :7;                                             /* Reserved Bits    */
    uint16 KEY:8;                                          /* KEY[15:8]        */
} __type795;
typedef struct 
{                                                          /* Bit Access       */
    uint16 SUINIT:1;                                       /* SUINIT           */
    uint16 :7;                                             /* Reserved Bits    */
    uint16 KEY:8;                                          /* KEY[15:8]        */
} __type796;
typedef struct 
{                                                          /* Bit Access       */
    uint8  FLOCKST:1;                                      /* FLOCKST          */
    uint8  :7;                                             /* Reserved Bits    */
} __type797;
typedef struct 
{                                                          /* Bit Access       */
    uint8  RTECRCT:1;                                      /* RTECRCT          */
    uint8  RTEDTCT:1;                                      /* RTEDTCT          */
    uint8  :6;                                             /* Reserved Bits    */
} __type798;
typedef struct 
{                                                          /* Bit Access       */
    uint8  RTECIE:1;                                       /* RTECIE           */
    uint8  RTEDIE:1;                                       /* RTEDIE           */
    uint8  :6;                                             /* Reserved Bits    */
} __type799;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PCMDR:8;                                        /* PCMDR[7:0]       */
    uint16 CMDR:8;                                         /* CMDR[15:8]       */
} __type800;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PEERRST:8;                                      /* PEERRST[7:0]     */
    uint16 :8;                                             /* Reserved Bits    */
} __type801;
typedef struct 
{                                                          /* Bit Access       */
    uint8  BCDIR:1;                                        /* BCDIR            */
    uint8  :7;                                             /* Reserved Bits    */
} __type802;
typedef struct 
{                                                          /* Bit Access       */
    uint8  BCST:1;                                         /* BCST             */
    uint8  :7;                                             /* Reserved Bits    */
} __type803;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PSADR:19;                                       /* PSADR[18:0]      */
    uint32 :13;                                            /* Reserved Bits    */
} __type804;
typedef struct 
{                                                          /* Bit Access       */
    uint16 ESUSPMD:1;                                      /* ESUSPMD          */
    uint16 :15;                                            /* Reserved Bits    */
} __type805;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PCKA:8;                                         /* PCKA[7:0]        */
    uint16 KEY:8;                                          /* KEY[15:8]        */
} __type806;
typedef struct 
{                                                          /* Bit Access       */
    uint8  EMSQMD:4;                                       /* EMSQMD[3:0]      */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  ERREMU:1;                                       /* ERREMU           */
    uint8  EMMODE:1;                                       /* EMMODE           */
} __type807;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FLAPE:32;                                       /* FLAPE[31:0]      */
} __type808;
typedef struct 
{                                                          /* Bit Access       */
    uint16 FECCM:9;                                        /* FECCM[8:0]       */
    uint16 :7;                                             /* Reserved Bits    */
} __type809;
typedef struct 
{                                                          /* Bit Access       */
    uint16 ECCDISE:1;                                      /* ECCDISE          */
    uint16 :3;                                             /* Reserved Bits    */
    uint16 DECCVE:1;                                       /* DECCVE           */
    uint16 CECCVE:1;                                       /* CECCVE           */
    uint16 :2;                                             /* Reserved Bits    */
    uint16 KEY:8;                                          /* KEY[15:8]        */
} __type810;
typedef struct 
{                                                          /* Bit Access       */
    uint16 DMYECC:9;                                       /* DMYECC[8:0]      */
    uint16 :7;                                             /* Reserved Bits    */
} __type811;
typedef struct 
{                                                          /* Bit Access       */
    uint32 XDBE01:1;                                       /* XDBE01           */
    uint32 XDBE03:1;                                       /* XDBE03           */
    uint32 XDBE05:1;                                       /* XDBE05           */
    uint32 XDBE07:1;                                       /* XDBE07           */
    uint32 XDBE09:1;                                       /* XDBE09           */
    uint32 XDBE011:1;                                      /* XDBE011          */
    uint32 XDBE013:1;                                      /* XDBE013          */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 XDBE11:1;                                       /* XDBE11           */
    uint32 XDBE13:1;                                       /* XDBE13           */
    uint32 XDBE15:1;                                       /* XDBE15           */
    uint32 XDBE17:1;                                       /* XDBE17           */
    uint32 XDBE19:1;                                       /* XDBE19           */
    uint32 :19;                                            /* Reserved Bits    */
} __type812;
typedef struct 
{                                                          /* Bit Access       */
    uint32 XDPE0:1;                                        /* XDPE0            */
    uint32 XDPE1:1;                                        /* XDPE1            */
    uint32 XDPE2:1;                                        /* XDPE2            */
    uint32 XDPE3:1;                                        /* XDPE3            */
    uint32 XDPE4:1;                                        /* XDPE4            */
    uint32 XDPE5:1;                                        /* XDPE5            */
    uint32 XDPE6:1;                                        /* XDPE6            */
    uint32 XDPE7:1;                                        /* XDPE7            */
    uint32 :24;                                            /* Reserved Bits    */
} __type813;
typedef struct 
{                                                          /* Bit Access       */
    uint32 XDPE0:1;                                        /* XDPE0            */
    uint32 XDPE1:1;                                        /* XDPE1            */
    uint32 XDPE2:1;                                        /* XDPE2            */
    uint32 :29;                                            /* Reserved Bits    */
} __type814;
typedef struct 
{                                                          /* Bit Access       */
    uint8  TMSL:1;                                         /* TMSL             */
    uint8  :7;                                             /* Reserved Bits    */
} __type815;
typedef struct 
{                                                          /* Bit Access       */
    uint8  SL0:1;                                          /* SL0              */
    uint8  :7;                                             /* Reserved Bits    */
} __type816;
typedef struct 
{                                                          /* Bit Access       */
    uint32 MIE000:1;                                       /* MIE000           */
    uint32 MIE001:1;                                       /* MIE001           */
    uint32 MIE002:1;                                       /* MIE002           */
    uint32 MIE003:1;                                       /* MIE003           */
    uint32 MIE004:1;                                       /* MIE004           */
    uint32 MIE005:1;                                       /* MIE005           */
    uint32 MIE006:1;                                       /* MIE006           */
    uint32 MIE007:1;                                       /* MIE007           */
    uint32 MIE008:1;                                       /* MIE008           */
    uint32 MIE009:1;                                       /* MIE009           */
    uint32 MIE010:1;                                       /* MIE010           */
    uint32 MIE011:1;                                       /* MIE011           */
    uint32 MIE012:1;                                       /* MIE012           */
    uint32 MIE013:1;                                       /* MIE013           */
    uint32 MIE014:1;                                       /* MIE014           */
    uint32 MIE015:1;                                       /* MIE015           */
    uint32 MIE016:1;                                       /* MIE016           */
    uint32 MIE017:1;                                       /* MIE017           */
    uint32 MIE018:1;                                       /* MIE018           */
    uint32 MIE019:1;                                       /* MIE019           */
    uint32 MIE020:1;                                       /* MIE020           */
    uint32 MIE021:1;                                       /* MIE021           */
    uint32 MIE022:1;                                       /* MIE022           */
    uint32 MIE023:1;                                       /* MIE023           */
    uint32 MIE024:1;                                       /* MIE024           */
    uint32 MIE025:1;                                       /* MIE025           */
    uint32 MIE026:1;                                       /* MIE026           */
    uint32 MIE027:1;                                       /* MIE027           */
    uint32 MIE028:1;                                       /* MIE028           */
    uint32 MIE029:1;                                       /* MIE029           */
    uint32 MIE030:1;                                       /* MIE030           */
    uint32 MIE031:1;                                       /* MIE031           */
} __type817;
typedef struct 
{                                                          /* Bit Access       */
    uint32 MIE100:1;                                       /* MIE100           */
    uint32 MIE101:1;                                       /* MIE101           */
    uint32 MIE102:1;                                       /* MIE102           */
    uint32 MIE103:1;                                       /* MIE103           */
    uint32 MIE104:1;                                       /* MIE104           */
    uint32 MIE105:1;                                       /* MIE105           */
    uint32 MIE106:1;                                       /* MIE106           */
    uint32 MIE107:1;                                       /* MIE107           */
    uint32 MIE108:1;                                       /* MIE108           */
    uint32 MIE109:1;                                       /* MIE109           */
    uint32 MIE110:1;                                       /* MIE110           */
    uint32 MIE111:1;                                       /* MIE111           */
    uint32 MIE112:1;                                       /* MIE112           */
    uint32 MIE113:1;                                       /* MIE113           */
    uint32 MIE114:1;                                       /* MIE114           */
    uint32 MIE115:1;                                       /* MIE115           */
    uint32 :16;                                            /* Reserved Bits    */
} __type818;
typedef struct 
{                                                          /* Bit Access       */
    uint32 NMIE000:1;                                      /* NMIE000          */
    uint32 NMIE001:1;                                      /* NMIE001          */
    uint32 NMIE002:1;                                      /* NMIE002          */
    uint32 NMIE003:1;                                      /* NMIE003          */
    uint32 NMIE004:1;                                      /* NMIE004          */
    uint32 NMIE005:1;                                      /* NMIE005          */
    uint32 NMIE006:1;                                      /* NMIE006          */
    uint32 NMIE007:1;                                      /* NMIE007          */
    uint32 NMIE008:1;                                      /* NMIE008          */
    uint32 NMIE009:1;                                      /* NMIE009          */
    uint32 NMIE010:1;                                      /* NMIE010          */
    uint32 NMIE011:1;                                      /* NMIE011          */
    uint32 NMIE012:1;                                      /* NMIE012          */
    uint32 NMIE013:1;                                      /* NMIE013          */
    uint32 NMIE014:1;                                      /* NMIE014          */
    uint32 NMIE015:1;                                      /* NMIE015          */
    uint32 NMIE016:1;                                      /* NMIE016          */
    uint32 NMIE017:1;                                      /* NMIE017          */
    uint32 NMIE018:1;                                      /* NMIE018          */
    uint32 NMIE019:1;                                      /* NMIE019          */
    uint32 NMIE020:1;                                      /* NMIE020          */
    uint32 NMIE021:1;                                      /* NMIE021          */
    uint32 NMIE022:1;                                      /* NMIE022          */
    uint32 NMIE023:1;                                      /* NMIE023          */
    uint32 NMIE024:1;                                      /* NMIE024          */
    uint32 NMIE025:1;                                      /* NMIE025          */
    uint32 NMIE026:1;                                      /* NMIE026          */
    uint32 NMIE027:1;                                      /* NMIE027          */
    uint32 NMIE028:1;                                      /* NMIE028          */
    uint32 NMIE029:1;                                      /* NMIE029          */
    uint32 NMIE030:1;                                      /* NMIE030          */
    uint32 NMIE031:1;                                      /* NMIE031          */
} __type819;
typedef struct 
{                                                          /* Bit Access       */
    uint32 NMIE100:1;                                      /* NMIE100          */
    uint32 NMIE101:1;                                      /* NMIE101          */
    uint32 NMIE102:1;                                      /* NMIE102          */
    uint32 NMIE103:1;                                      /* NMIE103          */
    uint32 NMIE104:1;                                      /* NMIE104          */
    uint32 NMIE105:1;                                      /* NMIE105          */
    uint32 NMIE106:1;                                      /* NMIE106          */
    uint32 NMIE107:1;                                      /* NMIE107          */
    uint32 NMIE108:1;                                      /* NMIE108          */
    uint32 NMIE109:1;                                      /* NMIE109          */
    uint32 NMIE110:1;                                      /* NMIE110          */
    uint32 NMIE111:1;                                      /* NMIE111          */
    uint32 NMIE112:1;                                      /* NMIE112          */
    uint32 NMIE113:1;                                      /* NMIE113          */
    uint32 NMIE114:1;                                      /* NMIE114          */
    uint32 NMIE115:1;                                      /* NMIE115          */
    uint32 :16;                                            /* Reserved Bits    */
} __type820;
typedef struct 
{                                                          /* Bit Access       */
    uint32 IRE000:1;                                       /* IRE000           */
    uint32 IRE001:1;                                       /* IRE001           */
    uint32 IRE002:1;                                       /* IRE002           */
    uint32 IRE003:1;                                       /* IRE003           */
    uint32 IRE004:1;                                       /* IRE004           */
    uint32 IRE005:1;                                       /* IRE005           */
    uint32 IRE006:1;                                       /* IRE006           */
    uint32 IRE007:1;                                       /* IRE007           */
    uint32 IRE008:1;                                       /* IRE008           */
    uint32 IRE009:1;                                       /* IRE009           */
    uint32 IRE010:1;                                       /* IRE010           */
    uint32 IRE011:1;                                       /* IRE011           */
    uint32 IRE012:1;                                       /* IRE012           */
    uint32 IRE013:1;                                       /* IRE013           */
    uint32 IRE014:1;                                       /* IRE014           */
    uint32 IRE015:1;                                       /* IRE015           */
    uint32 IRE016:1;                                       /* IRE016           */
    uint32 IRE017:1;                                       /* IRE017           */
    uint32 IRE018:1;                                       /* IRE018           */
    uint32 IRE019:1;                                       /* IRE019           */
    uint32 IRE020:1;                                       /* IRE020           */
    uint32 IRE021:1;                                       /* IRE021           */
    uint32 IRE022:1;                                       /* IRE022           */
    uint32 IRE023:1;                                       /* IRE023           */
    uint32 IRE024:1;                                       /* IRE024           */
    uint32 IRE025:1;                                       /* IRE025           */
    uint32 IRE026:1;                                       /* IRE026           */
    uint32 IRE027:1;                                       /* IRE027           */
    uint32 IRE028:1;                                       /* IRE028           */
    uint32 IRE029:1;                                       /* IRE029           */
    uint32 IRE030:1;                                       /* IRE030           */
    uint32 IRE031:1;                                       /* IRE031           */
} __type821;
typedef struct 
{                                                          /* Bit Access       */
    uint32 IRE100:1;                                       /* IRE100           */
    uint32 IRE101:1;                                       /* IRE101           */
    uint32 IRE102:1;                                       /* IRE102           */
    uint32 IRE103:1;                                       /* IRE103           */
    uint32 IRE104:1;                                       /* IRE104           */
    uint32 IRE105:1;                                       /* IRE105           */
    uint32 IRE106:1;                                       /* IRE106           */
    uint32 IRE107:1;                                       /* IRE107           */
    uint32 IRE108:1;                                       /* IRE108           */
    uint32 IRE109:1;                                       /* IRE109           */
    uint32 IRE110:1;                                       /* IRE110           */
    uint32 IRE111:1;                                       /* IRE111           */
    uint32 IRE112:1;                                       /* IRE112           */
    uint32 IRE113:1;                                       /* IRE113           */
    uint32 IRE114:1;                                       /* IRE114           */
    uint32 IRE115:1;                                       /* IRE115           */
    uint32 :13;                                            /* Reserved Bits    */
    uint32 IRE129:1;                                       /* IRE129           */
    uint32 :2;                                             /* Reserved Bits    */
} __type822;
typedef struct 
{                                                          /* Bit Access       */
    uint16 EMK000:1;                                       /* EMK000           */
    uint16 EMK001:1;                                       /* EMK001           */
    uint16 EMK002:1;                                       /* EMK002           */
    uint16 EMK003:1;                                       /* EMK003           */
    uint16 EMK004:1;                                       /* EMK004           */
    uint16 EMK005:1;                                       /* EMK005           */
    uint16 EMK006:1;                                       /* EMK006           */
    uint16 EMK007:1;                                       /* EMK007           */
    uint16 EMK008:1;                                       /* EMK008           */
    uint16 EMK009:1;                                       /* EMK009           */
    uint16 EMK010:1;                                       /* EMK010           */
    uint16 EMK011:1;                                       /* EMK011           */
    uint16 EMK012:1;                                       /* EMK012           */
    uint16 EMK013:1;                                       /* EMK013           */
    uint16 EMK014:1;                                       /* EMK014           */
    uint16 EMK015:1;                                       /* EMK015           */
    uint16 EMK016:1;                                       /* EMK016           */
    uint16 EMK017:1;                                       /* EMK017           */
    uint16 EMK018:1;                                       /* EMK018           */
    uint16 EMK019:1;                                       /* EMK019           */
    uint16 EMK020:1;                                       /* EMK020           */
    uint16 EMK021:1;                                       /* EMK021           */
    uint16 EMK022:1;                                       /* EMK022           */
    uint16 EMK023:1;                                       /* EMK023           */
    uint16 EMK024:1;                                       /* EMK024           */
    uint16 EMK025:1;                                       /* EMK025           */
    uint16 EMK026:1;                                       /* EMK026           */
    uint16 EMK027:1;                                       /* EMK027           */
    uint16 EMK028:1;                                       /* EMK028           */
    uint16 EMK029:1;                                       /* EMK029           */
    uint16 EMK030:1;                                       /* EMK030           */
    uint16 EMK031:1;                                       /* EMK031           */
} __type823;
typedef struct 
{                                                          /* Bit Access       */
    uint32 EMK100:1;                                       /* EMK100           */
    uint32 EMK101:1;                                       /* EMK101           */
    uint32 EMK102:1;                                       /* EMK102           */
    uint32 EMK103:1;                                       /* EMK103           */
    uint32 EMK104:1;                                       /* EMK104           */
    uint32 EMK105:1;                                       /* EMK105           */
    uint32 EMK106:1;                                       /* EMK106           */
    uint32 EMK107:1;                                       /* EMK107           */
    uint32 EMK108:1;                                       /* EMK108           */
    uint32 EMK109:1;                                       /* EMK109           */
    uint32 EMK110:1;                                       /* EMK110           */
    uint32 EMK111:1;                                       /* EMK111           */
    uint32 EMK112:1;                                       /* EMK112           */
    uint32 EMK113:1;                                       /* EMK113           */
    uint32 EMK114:1;                                       /* EMK114           */
    uint32 EMK115:1;                                       /* EMK115           */
    uint32 :13;                                            /* Reserved Bits    */
    uint32 EMK129:1;                                       /* EMK129           */
    uint32 :2;                                             /* Reserved Bits    */
} __type824;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CLSSE000:1;                                     /* CLSSE000         */
    uint32 CLSSE001:1;                                     /* CLSSE001         */
    uint32 CLSSE002:1;                                     /* CLSSE002         */
    uint32 CLSSE003:1;                                     /* CLSSE003         */
    uint32 CLSSE004:1;                                     /* CLSSE004         */
    uint32 CLSSE005:1;                                     /* CLSSE005         */
    uint32 CLSSE006:1;                                     /* CLSSE006         */
    uint32 CLSSE007:1;                                     /* CLSSE007         */
    uint32 CLSSE008:1;                                     /* CLSSE008         */
    uint32 CLSSE009:1;                                     /* CLSSE009         */
    uint32 CLSSE010:1;                                     /* CLSSE010         */
    uint32 CLSSE011:1;                                     /* CLSSE011         */
    uint32 CLSSE012:1;                                     /* CLSSE012         */
    uint32 CLSSE013:1;                                     /* CLSSE013         */
    uint32 CLSSE014:1;                                     /* CLSSE014         */
    uint32 CLSSE015:1;                                     /* CLSSE015         */
    uint32 CLSSE016:1;                                     /* CLSSE016         */
    uint32 CLSSE017:1;                                     /* CLSSE017         */
    uint32 CLSSE018:1;                                     /* CLSSE018         */
    uint32 CLSSE019:1;                                     /* CLSSE019         */
    uint32 CLSSE020:1;                                     /* CLSSE020         */
    uint32 CLSSE021:1;                                     /* CLSSE021         */
    uint32 CLSSE022:1;                                     /* CLSSE022         */
    uint32 CLSSE023:1;                                     /* CLSSE023         */
    uint32 CLSSE024:1;                                     /* CLSSE024         */
    uint32 CLSSE025:1;                                     /* CLSSE025         */
    uint32 CLSSE026:1;                                     /* CLSSE026         */
    uint32 CLSSE027:1;                                     /* CLSSE027         */
    uint32 CLSSE028:1;                                     /* CLSSE028         */
    uint32 CLSSE029:1;                                     /* CLSSE029         */
    uint32 CLSSE030:1;                                     /* CLSSE030         */
    uint32 CLSSE031:1;                                     /* CLSSE031         */
} __type825;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CLSSE100:1;                                     /* CLSSE100         */
    uint32 CLSSE101:1;                                     /* CLSSE101         */
    uint32 CLSSE102:1;                                     /* CLSSE102         */
    uint32 CLSSE103:1;                                     /* CLSSE103         */
    uint32 CLSSE104:1;                                     /* CLSSE104         */
    uint32 CLSSE105:1;                                     /* CLSSE105         */
    uint32 CLSSE106:1;                                     /* CLSSE106         */
    uint32 CLSSE107:1;                                     /* CLSSE107         */
    uint32 CLSSE108:1;                                     /* CLSSE108         */
    uint32 CLSSE109:1;                                     /* CLSSE109         */
    uint32 CLSSE110:1;                                     /* CLSSE110         */
    uint32 CLSSE111:1;                                     /* CLSSE111         */
    uint32 CLSSE112:1;                                     /* CLSSE112         */
    uint32 CLSSE113:1;                                     /* CLSSE113         */
    uint32 CLSSE114:1;                                     /* CLSSE114         */
    uint32 CLSSE115:1;                                     /* CLSSE115         */
    uint32 :13;                                            /* Reserved Bits    */
    uint32 CLSSE129:1;                                     /* CLSSE129         */
    uint32 CLSSE130:1;                                     /* CLSSE130         */
    uint32 :1;                                             /* Reserved Bits    */
} __type826;
typedef struct 
{                                                          /* Bit Access       */
    uint32 REG1:8;                                         /* REG1[7:0]        */
    uint32 :24;                                            /* Reserved Bits    */
} __type827;
typedef struct 
{                                                          /* Bit Access       */
    uint8  PRERR:1;                                        /* PRERR            */
    uint8  :7;                                             /* Reserved Bits    */
} __type828;
typedef struct 
{                                                          /* Bit Access       */
    uint8  PE000:1;                                        /* PE000            */
    uint8  PE001:1;                                        /* PE001            */
    uint8  PE002:1;                                        /* PE002            */
    uint8  PE003:1;                                        /* PE003            */
    uint8  PE004:1;                                        /* PE004            */
    uint8  PE005:1;                                        /* PE005            */
    uint8  PE006:1;                                        /* PE006            */
    uint8  PE007:1;                                        /* PE007            */
    uint8  PE008:1;                                        /* PE008            */
    uint8  PE009:1;                                        /* PE009            */
    uint8  PE010:1;                                        /* PE010            */
    uint8  PE011:1;                                        /* PE011            */
    uint8  PE012:1;                                        /* PE012            */
    uint8  PE013:1;                                        /* PE013            */
    uint8  PE014:1;                                        /* PE014            */
    uint8  PE015:1;                                        /* PE015            */
    uint8  PE016:1;                                        /* PE016            */
    uint8  PE017:1;                                        /* PE017            */
    uint8  PE018:1;                                        /* PE018            */
    uint8  PE019:1;                                        /* PE019            */
    uint8  PE020:1;                                        /* PE020            */
    uint8  PE021:1;                                        /* PE021            */
    uint8  PE022:1;                                        /* PE022            */
    uint8  PE023:1;                                        /* PE023            */
    uint8  PE024:1;                                        /* PE024            */
    uint8  PE025:1;                                        /* PE025            */
    uint8  PE026:1;                                        /* PE026            */
    uint8  PE027:1;                                        /* PE027            */
    uint8  PE028:1;                                        /* PE028            */
    uint8  PE029:1;                                        /* PE029            */
    uint8  PE030:1;                                        /* PE030            */
    uint8  PE031:1;                                        /* PE031            */
} __type829;
typedef struct 
{                                                          /* Bit Access       */
    uint8  PE100:1;                                        /* PE100            */
    uint8  PE101:1;                                        /* PE101            */
    uint8  PE102:1;                                        /* PE102            */
    uint8  PE103:1;                                        /* PE103            */
    uint8  PE104:1;                                        /* PE104            */
    uint8  PE105:1;                                        /* PE105            */
    uint8  PE106:1;                                        /* PE106            */
    uint8  PE107:1;                                        /* PE107            */
    uint8  PE108:1;                                        /* PE108            */
    uint8  PE109:1;                                        /* PE109            */
    uint8  PE110:1;                                        /* PE110            */
    uint8  PE111:1;                                        /* PE111            */
    uint8  PE112:1;                                        /* PE112            */
    uint8  PE113:1;                                        /* PE113            */
    uint8  PE114:1;                                        /* PE114            */
    uint8  PE115:1;                                        /* PE115            */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :5;                                             /* Reserved Bits    */
    uint8  PE129:1;                                        /* PE129            */
    uint8  :2;                                             /* Reserved Bits    */
} __type830;
typedef struct 
{                                                          /* Bit Access       */
    uint8  STA:1;                                          /* STA              */
    uint8  STP:1;                                          /* STP              */
    uint8  :6;                                             /* Reserved Bits    */
} __type831;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TE000:1;                                        /* TE000            */
    uint32 TE001:1;                                        /* TE001            */
    uint32 TE002:1;                                        /* TE002            */
    uint32 TE003:1;                                        /* TE003            */
    uint32 TE004:1;                                        /* TE004            */
    uint32 TE005:1;                                        /* TE005            */
    uint32 TE006:1;                                        /* TE006            */
    uint32 TE007:1;                                        /* TE007            */
    uint32 TE008:1;                                        /* TE008            */
    uint32 TE009:1;                                        /* TE009            */
    uint32 TE010:1;                                        /* TE010            */
    uint32 TE011:1;                                        /* TE011            */
    uint32 TE012:1;                                        /* TE012            */
    uint32 TE013:1;                                        /* TE013            */
    uint32 TE014:1;                                        /* TE014            */
    uint32 TE015:1;                                        /* TE015            */
    uint32 TE016:1;                                        /* TE016            */
    uint32 TE017:1;                                        /* TE017            */
    uint32 TE018:1;                                        /* TE018            */
    uint32 TE019:1;                                        /* TE019            */
    uint32 TE020:1;                                        /* TE020            */
    uint32 TE021:1;                                        /* TE021            */
    uint32 TE022:1;                                        /* TE022            */
    uint32 TE023:1;                                        /* TE023            */
    uint32 TE024:1;                                        /* TE024            */
    uint32 TE025:1;                                        /* TE025            */
    uint32 TE026:1;                                        /* TE026            */
    uint32 TE027:1;                                        /* TE027            */
    uint32 TE028:1;                                        /* TE028            */
    uint32 TE029:1;                                        /* TE029            */
    uint32 TE030:1;                                        /* TE030            */
    uint32 TE031:1;                                        /* TE031            */
} __type832;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TE100:1;                                        /* TE100            */
    uint32 TE101:1;                                        /* TE101            */
    uint32 TE102:1;                                        /* TE102            */
    uint32 TE103:1;                                        /* TE103            */
    uint32 TE104:1;                                        /* TE104            */
    uint32 TE105:1;                                        /* TE105            */
    uint32 TE106:1;                                        /* TE106            */
    uint32 TE107:1;                                        /* TE107            */
    uint32 TE108:1;                                        /* TE108            */
    uint32 TE109:1;                                        /* TE109            */
    uint32 TE110:1;                                        /* TE110            */
    uint32 TE111:1;                                        /* TE111            */
    uint32 TE112:1;                                        /* TE112            */
    uint32 TE113:1;                                        /* TE113            */
    uint32 TE114:1;                                        /* TE114            */
    uint32 TE115:1;                                        /* TE115            */
    uint32 :16;                                            /* Reserved Bits    */
} __type833;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TE200:1;                                        /* TE200            */
    uint32 TE201:1;                                        /* TE201            */
    uint32 TE202:1;                                        /* TE202            */
    uint32 TE203:1;                                        /* TE203            */
    uint32 TE204:1;                                        /* TE204            */
    uint32 TE205:1;                                        /* TE205            */
    uint32 TE206:1;                                        /* TE206            */
    uint32 TE207:1;                                        /* TE207            */
    uint32 TE208:1;                                        /* TE208            */
    uint32 TE209:1;                                        /* TE209            */
    uint32 TE210:1;                                        /* TE210            */
    uint32 TE211:1;                                        /* TE211            */
    uint32 TE212:1;                                        /* TE212            */
    uint32 TE213:1;                                        /* TE213            */
    uint32 TE214:1;                                        /* TE214            */
    uint32 TE215:1;                                        /* TE215            */
    uint32 TE216:1;                                        /* TE216            */
    uint32 TE217:1;                                        /* TE217            */
    uint32 TE218:1;                                        /* TE218            */
    uint32 TE219:1;                                        /* TE219            */
    uint32 TE220:1;                                        /* TE220            */
    uint32 TE221:1;                                        /* TE221            */
    uint32 TE222:1;                                        /* TE222            */
    uint32 TE223:1;                                        /* TE223            */
    uint32 TE224:1;                                        /* TE224            */
    uint32 TE225:1;                                        /* TE225            */
    uint32 TE226:1;                                        /* TE226            */
    uint32 TE227:1;                                        /* TE227            */
    uint32 TE228:1;                                        /* TE228            */
    uint32 TE229:1;                                        /* TE229            */
    uint32 TE230:1;                                        /* TE230            */
    uint32 TE231:1;                                        /* TE231            */
} __type834;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TE300:1;                                        /* TE300            */
    uint32 TE301:1;                                        /* TE301            */
    uint32 TE302:1;                                        /* TE302            */
    uint32 TE303:1;                                        /* TE303            */
    uint32 TE304:1;                                        /* TE304            */
    uint32 TE305:1;                                        /* TE305            */
    uint32 TE306:1;                                        /* TE306            */
    uint32 TE307:1;                                        /* TE307            */
    uint32 TE308:1;                                        /* TE308            */
    uint32 TE309:1;                                        /* TE309            */
    uint32 TE310:1;                                        /* TE310            */
    uint32 TE311:1;                                        /* TE311            */
    uint32 TE312:1;                                        /* TE312            */
    uint32 TE313:1;                                        /* TE313            */
    uint32 TE314:1;                                        /* TE314            */
    uint32 TE315:1;                                        /* TE315            */
    uint32 :16;                                            /* Reserved Bits    */
} __type835;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :8;                                             /* Reserved Bits    */
    uint32 JCUA0RES:1;                                     /* JCUA0RES         */
    uint32 :23;                                            /* Reserved Bits    */
} __type836;
typedef struct 
{                                                          /* Bit Access       */
    uint32 VISL0:1;                                        /* VISL0            */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 VOSL:1;                                         /* VOSL             */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 UPDT0:1;                                        /* UPDT0            */
    uint32 UPDT1:1;                                        /* UPDT1            */
    uint32 :26;                                            /* Reserved Bits    */
} __type837;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :4;                                             /* Reserved Bits    */
    uint32 VODDR_OEN:1;                                    /* VODDR_OEN        */
    uint32 OLDI_OEN:1;                                     /* OLDI_OEN         */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 SRGB1_OEN:1;                                    /* SRGB1_OEN        */
    uint32 :23;                                            /* Reserved Bits    */
} __type838;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PRMR01SSW:1;                                    /* PRMR01SSW        */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PRMR02SSW:1;                                    /* PRMR02SSW        */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PRMR03SSW:1;                                    /* PRMR03SSW        */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PRMR04SSW:1;                                    /* PRMR04SSW        */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PRMR05SSW:1;                                    /* PRMR05SSW        */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PRMR06SSW:1;                                    /* PRMR06SSW        */
    uint32 :20;                                            /* Reserved Bits    */
} __type839;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PRMR0ISMS:1;                                    /* PRMR0ISMS        */
    uint32 PRMR0ISMA:1;                                    /* PRMR0ISMA        */
    uint32 PRMR0ISSA:1;                                    /* PRMR0ISSA        */
    uint32 :29;                                            /* Reserved Bits    */
} __type840;
typedef struct 
{                                                          /* Bit Access       */
    uint32 IDDATA:1;                                       /* IDDATA           */
    uint32 IDEN:1;                                         /* IDEN             */
    uint32 :30;                                            /* Reserved Bits    */
} __type841;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TSNEN:1;                                        /* TSNEN            */
    uint32 :31;                                            /* Reserved Bits    */
} __type842;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TSNRDY:1;                                       /* TSNRDY           */
    uint32 :31;                                            /* Reserved Bits    */
} __type843;
typedef struct 
{                                                          /* Bit Access       */
    uint32 INTP0ESEL:2;                                    /* INTP0ESEL[1:0]   */
    uint32 INTP1ESEL:2;                                    /* INTP1ESEL[3:2]   */
    uint32 INTP2ESEL:2;                                    /* INTP2ESEL[5:4]   */
    uint32 :26;                                            /* Reserved Bits    */
} __type844;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :10;                                            /* Reserved Bits    */
    uint32 RBBADR:22;                                      /* RBBADR[31:10]    */
} __type845;
typedef struct 
{                                                          /* Bit Access       */
    uint32 RBMASK:32;                                      /* RBMASK[31:0]     */
} __type846;
typedef struct 
{                                                          /* Bit Access       */
    uint32 UPDEN:16;                                       /* UPDEN[15:0]      */
    uint32 :16;                                            /* Reserved Bits    */
} __type847;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :8;                                             /* Reserved Bits    */
    uint32 HYPBSEL:1;                                      /* HYPBSEL          */
    uint32 SFMASEL:1;                                      /* SFMASEL          */
    uint32 :10;                                            /* Reserved Bits    */
    uint32 CSSEL:1;                                        /* CSSEL            */
    uint32 CSSEL2:1;                                       /* CSSEL2           */
    uint32 :10;                                            /* Reserved Bits    */
} __type848;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 SDRDSC:2;                                       /* SDRDSC[3:2]      */
    uint32 SDRDSD0:2;                                      /* SDRDSD0[5:4]     */
    uint32 SDRDSD1:2;                                      /* SDRDSD1[7:6]     */
    uint32 SDRDSD2:2;                                      /* SDRDSD2[9:8]     */
    uint32 SDRDSD3:2;                                      /* SDRDSD3[11:10]   */
    uint32 SDRDSA:2;                                       /* SDRDSA[13:12]    */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 P21_0_DS:2;                                     /* P21_0_DS[17:16]  */
    uint32 P21_9_1_DS:2;                                   /* P21_9_1_DS[19:18] */
    uint32 P22_10_DS:2;                                    /* P22_10_DS[21:20] */
    uint32 :10;                                            /* Reserved Bits    */
} __type849;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :8;                                             /* Reserved Bits    */
    uint32 DHDTREN:1;                                      /* DHDTREN          */
    uint32 :23;                                            /* Reserved Bits    */
} __type850;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SLPWGA:24;                                      /* SLPWGA[23:0]     */
    uint32 :8;                                             /* Reserved Bits    */
} __type851;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SSF000:1;                                       /* SSF000           */
    uint32 SSF001:1;                                       /* SSF001           */
    uint32 SSF002:1;                                       /* SSF002           */
    uint32 SSF003:1;                                       /* SSF003           */
    uint32 SSF004:1;                                       /* SSF004           */
    uint32 SSF005:1;                                       /* SSF005           */
    uint32 SSF006:1;                                       /* SSF006           */
    uint32 SSF007:1;                                       /* SSF007           */
    uint32 SSF008:1;                                       /* SSF008           */
    uint32 :9;                                             /* Reserved Bits    */
    uint32 SSF018:1;                                       /* SSF018           */
    uint32 :13;                                            /* Reserved Bits    */
} __type852;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SSF100:1;                                       /* SSF100           */
    uint32 SSF101:1;                                       /* SSF101           */
    uint32 SSF102:1;                                       /* SSF102           */
    uint32 SSF103:1;                                       /* SSF103           */
    uint32 SSF104:1;                                       /* SSF104           */
    uint32 SSF105:1;                                       /* SSF105           */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 SSF108:1;                                       /* SSF108           */
    uint32 SSF109:1;                                       /* SSF109           */
    uint32 SSF110:1;                                       /* SSF110           */
    uint32 SSF111:1;                                       /* SSF111           */
    uint32 SSF112:1;                                       /* SSF112           */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 SSF116:1;                                       /* SSF116           */
    uint32 :11;                                            /* Reserved Bits    */
    uint32 SSF128:1;                                       /* SSF128           */
    uint32 SSF129:1;                                       /* SSF129           */
    uint32 SSF130:1;                                       /* SSF130           */
    uint32 SSF131:1;                                       /* SSF131           */
} __type853;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CL000:1;                                        /* CL000            */
    uint32 CL001:1;                                        /* CL001            */
    uint32 CL002:1;                                        /* CL002            */
    uint32 CL003:1;                                        /* CL003            */
    uint32 CL004:1;                                        /* CL004            */
    uint32 CL005:1;                                        /* CL005            */
    uint32 CL006:1;                                        /* CL006            */
    uint32 CL007:1;                                        /* CL007            */
    uint32 CL008:1;                                        /* CL008            */
    uint32 :9;                                             /* Reserved Bits    */
    uint32 CL018:1;                                        /* CL018            */
    uint32 :13;                                            /* Reserved Bits    */
} __type854;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CL100:1;                                        /* CL100            */
    uint32 CL101:1;                                        /* CL101            */
    uint32 CL102:1;                                        /* CL102            */
    uint32 CL103:1;                                        /* CL103            */
    uint32 CL104:1;                                        /* CL104            */
    uint32 CL105:1;                                        /* CL105            */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 CL108:1;                                        /* CL108            */
    uint32 CL109:1;                                        /* CL109            */
    uint32 CL110:1;                                        /* CL110            */
    uint32 CL111:1;                                        /* CL111            */
    uint32 CL112:1;                                        /* CL112            */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 CL116:1;                                        /* CL116            */
    uint32 :11;                                            /* Reserved Bits    */
    uint32 CL128:1;                                        /* CL128            */
    uint32 CL129:1;                                        /* CL129            */
    uint32 CL130:1;                                        /* CL130            */
    uint32 CL131:1;                                        /* CL131            */
} __type855;
typedef struct 
{                                                          /* Bit Access       */
    uint8  PRS:3;                                          /* PRS[2:0]         */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  NFSTS:2;                                        /* NFSTS[6:5]       */
    uint8  :1;                                             /* Reserved Bits    */
} __type856;
typedef struct 
{                                                          /* Bit Access       */
    uint16 NFEN0:1;                                        /* NFEN0            */
    uint16 NFEN1:1;                                        /* NFEN1            */
    uint16 NFEN2:1;                                        /* NFEN2            */
    uint16 NFEN3:1;                                        /* NFEN3            */
    uint16 NFEN4:1;                                        /* NFEN4            */
    uint16 NFEN5:1;                                        /* NFEN5            */
    uint16 NFEN6:1;                                        /* NFEN6            */
    uint16 NFEN7:1;                                        /* NFEN7            */
    uint16 NFEN8:1;                                        /* NFEN8            */
    uint16 NFEN9:1;                                        /* NFEN9            */
    uint16 NFEN10:1;                                       /* NFEN10           */
    uint16 NFEN11:1;                                       /* NFEN11           */
    uint16 NFEN12:1;                                       /* NFEN12           */
    uint16 NFEN13:1;                                       /* NFEN13           */
    uint16 NFEN14:1;                                       /* NFEN14           */
    uint16 NFEN15:1;                                       /* NFEN15           */
} __type857;
typedef struct 
{                                                          /* Bit Access       */
    uint16 NFEN0:1;                                        /* NFEN0            */
    uint16 NFEN1:1;                                        /* NFEN1            */
    uint16 NFEN2:1;                                        /* NFEN2            */
    uint16 NFEN3:1;                                        /* NFEN3            */
    uint16 NFEN4:1;                                        /* NFEN4            */
    uint16 NFEN5:1;                                        /* NFEN5            */
    uint16 NFEN6:1;                                        /* NFEN6            */
    uint16 NFEN7:1;                                        /* NFEN7            */
    uint16 NFEN8:1;                                        /* NFEN8            */
    uint16 :7;                                             /* Reserved Bits    */
} __type858;
typedef struct 
{                                                          /* Bit Access       */
    uint8  INTR0:1;                                        /* INTR0            */
    uint8  INTF0:1;                                        /* INTF0            */
    uint8  INTL0:1;                                        /* INTL0            */
    uint8  :5;                                             /* Reserved Bits    */
} __type859;
typedef struct 
{                                                          /* Bit Access       */
    uint8  INTR1:1;                                        /* INTR1            */
    uint8  INTF1:1;                                        /* INTF1            */
    uint8  INTL1:1;                                        /* INTL1            */
    uint8  :5;                                             /* Reserved Bits    */
} __type860;
typedef struct 
{                                                          /* Bit Access       */
    uint8  INTR2:1;                                        /* INTR2            */
    uint8  INTF2:1;                                        /* INTF2            */
    uint8  INTL2:1;                                        /* INTL2            */
    uint8  :5;                                             /* Reserved Bits    */
} __type861;
typedef struct 
{                                                          /* Bit Access       */
    uint8  INTR3:1;                                        /* INTR3            */
    uint8  INTF3:1;                                        /* INTF3            */
    uint8  INTL3:1;                                        /* INTL3            */
    uint8  :5;                                             /* Reserved Bits    */
} __type862;
typedef struct 
{                                                          /* Bit Access       */
    uint8  INTR4:1;                                        /* INTR4            */
    uint8  INTF4:1;                                        /* INTF4            */
    uint8  INTL4:1;                                        /* INTL4            */
    uint8  :5;                                             /* Reserved Bits    */
} __type863;
typedef struct 
{                                                          /* Bit Access       */
    uint8  INTR5:1;                                        /* INTR5            */
    uint8  INTF5:1;                                        /* INTF5            */
    uint8  INTL5:1;                                        /* INTL5            */
    uint8  :5;                                             /* Reserved Bits    */
} __type864;
typedef struct 
{                                                          /* Bit Access       */
    uint8  INTR6:1;                                        /* INTR6            */
    uint8  INTF6:1;                                        /* INTF6            */
    uint8  INTL6:1;                                        /* INTL6            */
    uint8  :5;                                             /* Reserved Bits    */
} __type865;
typedef struct 
{                                                          /* Bit Access       */
    uint8  INTR7:1;                                        /* INTR7            */
    uint8  INTF7:1;                                        /* INTF7            */
    uint8  INTL7:1;                                        /* INTL7            */
    uint8  :5;                                             /* Reserved Bits    */
} __type866;
typedef struct 
{                                                          /* Bit Access       */
    uint8  PROTWR:1;                                       /* PROTWR           */
    uint8  PROTRD:1;                                       /* PROTRD           */
    uint8  PROTWRPDEF:1;                                   /* PROTWRPDEF       */
    uint8  PROTRDPDEF:1;                                   /* PROTRDPDEF       */
    uint8  PROTDEB:1;                                      /* PROTDEB          */
    uint16 PROTSPID:4;                                     /* PROTSPID[8:5]    */
    uint32 VCID:8;                                         /* VCID[16:9]       */
    uint16 PROTPEID:8;                                     /* PROTPEID[24:17]  */
    uint8  PROTUM:1;                                       /* PROTUM           */
    uint8  PROTVM:1;                                       /* PROTVM           */
    uint8  :5;                                             /* Reserved Bits    */
} __type867;
typedef struct 
{                                                          /* Bit Access       */
    uint8  CLRE:1;                                         /* CLRE             */
    uint8  CLRO:1;                                         /* CLRO             */
    uint8  :6;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type868;
typedef struct 
{                                                          /* Bit Access       */
    uint8  ERR:1;                                          /* ERR              */
    uint8  OVF:1;                                          /* OVF              */
    uint8  :6;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type869;
typedef struct 
{                                                          /* Bit Access       */
    uint8  WRITE:1;                                        /* WRITE            */
    uint8  STRB:4;                                         /* STRB[4:1]        */
    uint8  :1;                                             /* Reserved Bits    */
    uint8  UM:1;                                           /* UM               */
    uint8  VM:1;                                           /* VM               */
    uint8  SPID:2;                                         /* SPID[9:8]        */
    uint8  VCID:3;                                         /* VCID[12:10]      */
    uint8  PEID:3;                                         /* PEID[15:13]      */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type870;
typedef struct 
{                                                          /* Bit Access       */
    uint8  PROTWR:1;                                       /* PROTWR           */
    uint8  PROTRD:1;                                       /* PROTRD           */
    uint8  PROTWRPDEF:1;                                   /* PROTWRPDEF       */
    uint8  PROTRDPDEF:1;                                   /* PROTRDPDEF       */
    uint8  PROTDEB:1;                                      /* PROTDEB          */
    uint16 PROTSPID:4;                                     /* PROTSPID[8:5]    */
    uint32 VCID:8;                                         /* VCID[16:9]       */
    uint16 PROTPEID:8;                                     /* PROTPEID[24:17]  */
    uint8  PROTUM:1;                                       /* PROTUM           */
    uint8  PROTVM:1;                                       /* PROTVM           */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  PROTLOCK:1;                                     /* PROTLOCK         */
} __type871;
typedef struct 
{                                                          /* Bit Access       */
    uint32 ADDR:32;                                        /* ADDR[31:0]       */
} __type872;
typedef struct 
{                                                          /* Bit Access       */
    uint8  WRITE:1;                                        /* WRITE            */
    uint8  STRB:4;                                         /* STRB[4:1]        */
    uint8  :1;                                             /* Reserved Bits    */
    uint8  UM:1;                                           /* UM               */
    uint8  VM:1;                                           /* VM               */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  VCID:3;                                         /* VCID[12:10]      */
    uint8  PEID:3;                                         /* PEID[15:13]      */
    uint8  SPID:5;                                         /* SPID[20:16]      */
    uint8  :3;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type873;
typedef struct 
{                                                          /* Bit Access       */
    uint8  :6;                                             /* Reserved Bits    */
    uint8  SVSTOP:1;                                       /* SVSTOP           */
    uint8  :1;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type874;
typedef struct 
{                                                          /* Bit Access       */
    uint8  FCUFSEL:1;                                      /* FCUFSEL          */
    uint8  :7;                                             /* Reserved Bits    */
} __type875;
typedef struct 
{                                                          /* Bit Access       */
    uint8  FRDCYCLD:4;                                     /* FRDCYCLD[3:0]    */
    uint8  :4;                                             /* Reserved Bits    */
} __type876;
typedef struct 
{                                                          /* Bit Access       */
    uint16 ECCDIS:1;                                       /* ECCDIS           */
    uint16 :13;                                            /* Reserved Bits    */
    uint16 PROT:2;                                         /* PROT[15:14]      */
    uint16 :16;                                            /* Reserved Bits    */
} __type877;
typedef struct 
{                                                          /* Bit Access       */
    uint8  SEDIE:1;                                        /* SEDIE            */
    uint8  DEDIE:1;                                        /* DEDIE            */
    uint8  :6;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type878;
typedef struct 
{                                                          /* Bit Access       */
    uint8  SSTCLR0:1;                                      /* SSTCLR0          */
    uint8  SSTCLR1:1;                                      /* SSTCLR1          */
    uint8  :6;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type879;
typedef struct 
{                                                          /* Bit Access       */
    uint8  ERROVF0:1;                                      /* ERROVF0          */
    uint8  ERROVF1:1;                                      /* ERROVF1          */
    uint8  :6;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type880;
typedef struct 
{                                                          /* Bit Access       */
    uint8  SEDF0:1;                                        /* SEDF0            */
    uint8  DEDF0:1;                                        /* DEDF0            */
    uint8  :6;                                             /* Reserved Bits    */
    uint8  SEDF1:1;                                        /* SEDF1            */
    uint8  DEDF1:1;                                        /* DEDF1            */
    uint8  :6;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type881;
typedef struct 
{                                                          /* Bit Access       */
    uint16 EADR0:9;                                        /* EADR0[8:0]       */
    uint8  :7;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type882;
typedef struct 
{                                                          /* Bit Access       */
    uint16 EADR1:9;                                        /* EADR1[8:0]       */
    uint8  :7;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type883;
typedef struct 
{                                                          /* Bit Access       */
    uint8  STCLR0:1;                                       /* STCLR0           */
    uint8  :7;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type884;
typedef struct 
{                                                          /* Bit Access       */
    uint8  ERROVF0:1;                                      /* ERROVF0          */
    uint8  :7;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type885;
typedef struct 
{                                                          /* Bit Access       */
    uint8  SEDF0:1;                                        /* SEDF0            */
    uint8  DEDF0:1;                                        /* DEDF0            */
    uint8  :6;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type886;
typedef struct 
{                                                          /* Bit Access       */
    uint16 EADR:9;                                         /* EADR[8:0]        */
    uint8  :7;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type887;
typedef struct 
{                                                          /* Bit Access       */
    uint32 ECCDIS:1;                                       /* ECCDIS           */
    uint32 SECDIS:1;                                       /* SECDIS           */
    uint32 :12;                                            /* Reserved Bits    */
    uint32 PROT:2;                                         /* PROT[15:14]      */
    uint32 :16;                                            /* Reserved Bits    */
} __type888;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SEDIE:1;                                        /* SEDIE            */
    uint32 DEDIE:1;                                        /* DEDIE            */
    uint32 :30;                                            /* Reserved Bits    */
} __type889;
typedef struct 
{                                                          /* Bit Access       */
    uint32 STCLR0:1;                                       /* STCLR0           */
    uint32 :31;                                            /* Reserved Bits    */
} __type890;
typedef struct 
{                                                          /* Bit Access       */
    uint32 ERROVF0:1;                                      /* ERROVF0          */
    uint32 :31;                                            /* Reserved Bits    */
} __type891;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SEDF0:1;                                        /* SEDF0            */
    uint32 DEDF0:1;                                        /* DEDF0            */
    uint32 :30;                                            /* Reserved Bits    */
} __type892;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :4;                                             /* Reserved Bits    */
    uint32 EADR:21;                                        /* EADR[24:4]       */
    uint32 :7;                                             /* Reserved Bits    */
} __type893;
typedef struct 
{                                                          /* Bit Access       */
    uint32 ECCTST:1;                                       /* ECCTST           */
    uint32 :13;                                            /* Reserved Bits    */
    uint32 PROT:2;                                         /* PROT[15:14]      */
    uint32 :16;                                            /* Reserved Bits    */
} __type894;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SEDF:1;                                         /* SEDF             */
    uint32 DEDF:1;                                         /* DEDF             */
    uint32 :30;                                            /* Reserved Bits    */
} __type895;
typedef struct 
{                                                          /* Bit Access       */
    uint32 ERRCLR:1;                                       /* ERRCLR           */
    uint32 :31;                                            /* Reserved Bits    */
} __type896;
typedef struct 
{                                                          /* Bit Access       */
    uint16 DATSEL:1;                                       /* DATSEL           */
    uint16 ECCTST:1;                                       /* ECCTST           */
    uint16 :12;                                            /* Reserved Bits    */
    uint16 PROT:2;                                         /* PROT[15:14]      */
    uint16 :16;                                            /* Reserved Bits    */
} __type897;
typedef struct 
{                                                          /* Bit Access       */
    uint32 LRDATBF0:9;                                     /* LRDATBF0[8:0]    */
    uint32 :7;                                             /* Reserved Bits    */
    uint32 LRDATBF1:9;                                     /* LRDATBF1[24:16]  */
    uint32 :7;                                             /* Reserved Bits    */
} __type898;
typedef struct 
{                                                          /* Bit Access       */
    uint32 LRDATBF2:9;                                     /* LRDATBF2[8:0]    */
    uint32 :7;                                             /* Reserved Bits    */
    uint32 LRDATBF3:9;                                     /* LRDATBF3[24:16]  */
    uint32 :7;                                             /* Reserved Bits    */
} __type899;
typedef struct 
{                                                          /* Bit Access       */
    uint16 ECCDIS:1;                                       /* ECCDIS           */
    uint16 SECDIS:1;                                       /* SECDIS           */
    uint16 :12;                                            /* Reserved Bits    */
    uint16 PROT:2;                                         /* PROT[15:14]      */
    uint16 :16;                                            /* Reserved Bits    */
} __type900;
typedef struct 
{                                                          /* Bit Access       */
    uint8  STCLR0:1;                                       /* STCLR0           */
    uint8  STCLR1:1;                                       /* STCLR1           */
    uint8  STCLR2:1;                                       /* STCLR2           */
    uint8  STCLR3:1;                                       /* STCLR3           */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type901;
typedef struct 
{                                                          /* Bit Access       */
    uint8  ERROVF0:1;                                      /* ERROVF0          */
    uint8  ERROVF1:1;                                      /* ERROVF1          */
    uint8  ERROVF2:1;                                      /* ERROVF2          */
    uint8  ERROVF3:1;                                      /* ERROVF3          */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type902;
typedef struct 
{                                                          /* Bit Access       */
    uint8  SEDF0:1;                                        /* SEDF0            */
    uint8  DEDF0:1;                                        /* DEDF0            */
    uint8  :6;                                             /* Reserved Bits    */
    uint8  SEDF1:1;                                        /* SEDF1            */
    uint8  DEDF1:1;                                        /* DEDF1            */
    uint8  :6;                                             /* Reserved Bits    */
    uint8  SEDF2:1;                                        /* SEDF2            */
    uint8  DEDF2:1;                                        /* DEDF2            */
    uint8  :6;                                             /* Reserved Bits    */
    uint8  SEDF3:1;                                        /* SEDF3            */
    uint8  DEDF3:1;                                        /* DEDF3            */
    uint8  :6;                                             /* Reserved Bits    */
} __type903;
typedef struct 
{                                                          /* Bit Access       */
    uint16 EADR:15;                                        /* EADR[14:0]       */
    uint8  :1;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type904;
typedef struct 
{                                                          /* Bit Access       */
    uint8  SSTCLR0:1;                                      /* SSTCLR0          */
    uint8  SSTCLR1:1;                                      /* SSTCLR1          */
    uint8  SSTCLR2:1;                                      /* SSTCLR2          */
    uint8  SSTCLR3:1;                                      /* SSTCLR3          */
    uint8  SSTCLR4:1;                                      /* SSTCLR4          */
    uint8  SSTCLR5:1;                                      /* SSTCLR5          */
    uint8  SSTCLR6:1;                                      /* SSTCLR6          */
    uint8  SSTCLR7:1;                                      /* SSTCLR7          */
    uint8  SSTCLR8:1;                                      /* SSTCLR8          */
    uint8  SSTCLR9:1;                                      /* SSTCLR9          */
    uint8  SSTCLR10:1;                                     /* SSTCLR10         */
    uint8  SSTCLR11:1;                                     /* SSTCLR11         */
    uint8  SSTCLR12:1;                                     /* SSTCLR12         */
    uint8  SSTCLR13:1;                                     /* SSTCLR13         */
    uint8  SSTCLR14:1;                                     /* SSTCLR14         */
    uint8  SSTCLR15:1;                                     /* SSTCLR15         */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type905;
typedef struct 
{                                                          /* Bit Access       */
    uint8  ERROVF0:1;                                      /* ERROVF0          */
    uint8  ERROVF1:1;                                      /* ERROVF1          */
    uint8  ERROVF2:1;                                      /* ERROVF2          */
    uint8  ERROVF3:1;                                      /* ERROVF3          */
    uint8  ERROVF4:1;                                      /* ERROVF4          */
    uint8  ERROVF5:1;                                      /* ERROVF5          */
    uint8  ERROVF6:1;                                      /* ERROVF6          */
    uint8  ERROVF7:1;                                      /* ERROVF7          */
    uint8  ERROVF8:1;                                      /* ERROVF8          */
    uint8  ERROVF9:1;                                      /* ERROVF9          */
    uint8  ERROVF10:1;                                     /* ERROVF10         */
    uint8  ERROVF11:1;                                     /* ERROVF11         */
    uint8  ERROVF12:1;                                     /* ERROVF12         */
    uint8  ERROVF13:1;                                     /* ERROVF13         */
    uint8  ERROVF14:1;                                     /* ERROVF14         */
    uint8  ERROVF15:1;                                     /* ERROVF15         */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type906;
typedef struct 
{                                                          /* Bit Access       */
    uint8  SEDF4:1;                                        /* SEDF4            */
    uint8  DEDF4:1;                                        /* DEDF4            */
    uint8  :6;                                             /* Reserved Bits    */
    uint8  SEDF5:1;                                        /* SEDF5            */
    uint8  DEDF5:1;                                        /* DEDF5            */
    uint8  :6;                                             /* Reserved Bits    */
    uint8  SEDF6:1;                                        /* SEDF6            */
    uint8  DEDF6:1;                                        /* DEDF6            */
    uint8  :6;                                             /* Reserved Bits    */
    uint8  SEDF7:1;                                        /* SEDF7            */
    uint8  DEDF7:1;                                        /* DEDF7            */
    uint8  :6;                                             /* Reserved Bits    */
} __type907;
typedef struct 
{                                                          /* Bit Access       */
    uint8  SEDF8:1;                                        /* SEDF8            */
    uint8  DEDF8:1;                                        /* DEDF8            */
    uint8  :6;                                             /* Reserved Bits    */
    uint8  SEDF9:1;                                        /* SEDF9            */
    uint8  DEDF9:1;                                        /* DEDF9            */
    uint8  :6;                                             /* Reserved Bits    */
    uint8  SEDF10:1;                                       /* SEDF10           */
    uint8  DEDF10:1;                                       /* DEDF10           */
    uint8  :6;                                             /* Reserved Bits    */
    uint8  SEDF11:1;                                       /* SEDF11           */
    uint8  DEDF11:1;                                       /* DEDF11           */
    uint8  :6;                                             /* Reserved Bits    */
} __type908;
typedef struct 
{                                                          /* Bit Access       */
    uint8  SEDF12:1;                                       /* SEDF12           */
    uint8  DEDF12:1;                                       /* DEDF12           */
    uint8  :6;                                             /* Reserved Bits    */
    uint8  SEDF13:1;                                       /* SEDF13           */
    uint8  DEDF13:1;                                       /* DEDF13           */
    uint8  :6;                                             /* Reserved Bits    */
    uint8  SEDF14:1;                                       /* SEDF14           */
    uint8  DEDF14:1;                                       /* DEDF14           */
    uint8  :6;                                             /* Reserved Bits    */
    uint8  SEDF15:1;                                       /* SEDF15           */
    uint8  DEDF15:1;                                       /* DEDF15           */
    uint8  :6;                                             /* Reserved Bits    */
} __type909;
typedef struct 
{                                                          /* Bit Access       */
    uint32 EADR0:32;                                       /* EADR0[31:0]      */
} __type910;
typedef struct 
{                                                          /* Bit Access       */
    uint32 EADR1:32;                                       /* EADR1[31:0]      */
} __type911;
typedef struct 
{                                                          /* Bit Access       */
    uint32 EADR2:32;                                       /* EADR2[31:0]      */
} __type912;
typedef struct 
{                                                          /* Bit Access       */
    uint32 EADR3:32;                                       /* EADR3[31:0]      */
} __type913;
typedef struct 
{                                                          /* Bit Access       */
    uint32 EADR4:32;                                       /* EADR4[31:0]      */
} __type914;
typedef struct 
{                                                          /* Bit Access       */
    uint32 EADR5:32;                                       /* EADR5[31:0]      */
} __type915;
typedef struct 
{                                                          /* Bit Access       */
    uint32 EADR6:32;                                       /* EADR6[31:0]      */
} __type916;
typedef struct 
{                                                          /* Bit Access       */
    uint32 EADR7:32;                                       /* EADR7[31:0]      */
} __type917;
typedef struct 
{                                                          /* Bit Access       */
    uint32 EADR8:32;                                       /* EADR8[31:0]      */
} __type918;
typedef struct 
{                                                          /* Bit Access       */
    uint32 EADR9:32;                                       /* EADR9[31:0]      */
} __type919;
typedef struct 
{                                                          /* Bit Access       */
    uint32 EADR10:32;                                      /* EADR10[31:0]     */
} __type920;
typedef struct 
{                                                          /* Bit Access       */
    uint32 EADR11:32;                                      /* EADR11[31:0]     */
} __type921;
typedef struct 
{                                                          /* Bit Access       */
    uint32 EADR12:32;                                      /* EADR12[31:0]     */
} __type922;
typedef struct 
{                                                          /* Bit Access       */
    uint32 EADR13:32;                                      /* EADR13[31:0]     */
} __type923;
typedef struct 
{                                                          /* Bit Access       */
    uint32 EADR14:32;                                      /* EADR14[31:0]     */
} __type924;
typedef struct 
{                                                          /* Bit Access       */
    uint32 EADR15:32;                                      /* EADR15[31:0]     */
} __type925;
typedef struct 
{                                                          /* Bit Access       */
    uint8  STCLR0:1;                                       /* STCLR0           */
    uint8  STCLR1:1;                                       /* STCLR1           */
    uint8  :6;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type926;
typedef struct 
{                                                          /* Bit Access       */
    uint16 ECEMF:1;                                        /* ECEMF            */
    uint16 ECER1F:1;                                       /* ECER1F           */
    uint16 ECER2F:1;                                       /* ECER2F           */
    uint16 EC1EDIC:1;                                      /* EC1EDIC          */
    uint16 EC2EDIC:1;                                      /* EC2EDIC          */
    uint16 EC1ECP:1;                                       /* EC1ECP           */
    uint16 ECERVF:1;                                       /* ECERVF           */
    uint16 ECTHM:1;                                        /* ECTHM            */
    uint16 :1;                                             /* Reserved Bits    */
    uint16 ECER1C:1;                                       /* ECER1C           */
    uint16 ECER2C:1;                                       /* ECER2C           */
    uint16 :3;                                             /* Reserved Bits    */
    uint16 EMCA0:1;                                        /* EMCA0            */
    uint16 EMCA1:1;                                        /* EMCA1            */
} __type927;
typedef struct 
{                                                          /* Bit Access       */
    uint16 ECREIS:1;                                       /* ECREIS           */
    uint16 ECDCS:1;                                        /* ECDCS            */
    uint16 ECENS:1;                                        /* ECENS            */
    uint16 ECREOS:1;                                       /* ECREOS           */
    uint16 ECTRRS:1;                                       /* ECTRRS           */
    uint16 :2;                                             /* Reserved Bits    */
    uint16 ECTMCE:1;                                       /* ECTMCE           */
    uint16 :6;                                             /* Reserved Bits    */
    uint16 ETMA0:1;                                        /* ETMA0            */
    uint16 ETMA1:1;                                        /* ETMA1            */
} __type928;
typedef struct 
{                                                          /* Bit Access       */
    uint8  ERDB:7;                                         /* ERDB[6:0]        */
    uint8  :1;                                             /* Reserved Bits    */
    uint8  ECRD:7;                                         /* ECRD[14:8]       */
    uint8  :1;                                             /* Reserved Bits    */
    uint8  HORD:7;                                         /* HORD[22:16]      */
    uint8  :1;                                             /* Reserved Bits    */
    uint8  SYND:7;                                         /* SYND[30:24]      */
    uint8  :1;                                             /* Reserved Bits    */
} __type929;
typedef struct 
{                                                          /* Bit Access       */
    uint32 ECEDB:32;                                       /* ECEDB[31:0]      */
} __type930;
typedef struct 
{                                                          /* Bit Access       */
    uint32 ECEAD:32;                                       /* ECEAD[31:0]      */
} __type931;
typedef struct 
{                                                          /* Bit Access       */
    uint32 ECEMF:1;                                        /* ECEMF            */
    uint32 ECER1F:1;                                       /* ECER1F           */
    uint32 ECER2F:1;                                       /* ECER2F           */
    uint32 EC1EDIC:1;                                      /* EC1EDIC          */
    uint32 EC2EDIC:1;                                      /* EC2EDIC          */
    uint32 EC1ECP:1;                                       /* EC1ECP           */
    uint32 ECERVF:1;                                       /* ECERVF           */
    uint32 ECTHM:1;                                        /* ECTHM            */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 ECER1C:1;                                       /* ECER1C           */
    uint32 ECER2C:1;                                       /* ECER2C           */
    uint32 ECOVFF:1;                                       /* ECOVFF           */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 EMCA0:1;                                        /* EMCA0            */
    uint32 EMCA1:1;                                        /* EMCA1            */
    uint32 ECSEDF0:1;                                      /* ECSEDF0          */
    uint32 ECDEDF0:1;                                      /* ECDEDF0          */
    uint32 ECSEDF1:1;                                      /* ECSEDF1          */
    uint32 ECDEDF1:1;                                      /* ECDEDF1          */
    uint32 ECSEDF2:1;                                      /* ECSEDF2          */
    uint32 ECDEDF2:1;                                      /* ECDEDF2          */
    uint32 ECSEDF3:1;                                      /* ECSEDF3          */
    uint32 ECDEDF3:1;                                      /* ECDEDF3          */
    uint32 ECSEDF4:1;                                      /* ECSEDF4          */
    uint32 ECDEDF4:1;                                      /* ECDEDF4          */
    uint32 ECSEDF5:1;                                      /* ECSEDF5          */
    uint32 ECDEDF5:1;                                      /* ECDEDF5          */
    uint32 ECSEDF6:1;                                      /* ECSEDF6          */
    uint32 ECDEDF6:1;                                      /* ECDEDF6          */
    uint32 ECSEDF7:1;                                      /* ECSEDF7          */
    uint32 ECDEDF7:1;                                      /* ECDEDF7          */
} __type932;
typedef struct 
{                                                          /* Bit Access       */
    uint16 ECREIS:1;                                       /* ECREIS           */
    uint16 ECDCS:1;                                        /* ECDCS            */
    uint16 ECENS:1;                                        /* ECENS            */
    uint16 ECREOS:1;                                       /* ECREOS           */
    uint16 ECTRRS:1;                                       /* ECTRRS           */
    uint16 :2;                                             /* Reserved Bits    */
    uint16 ECTMCE:1;                                       /* ECTMCE           */
    uint16 :6;                                             /* Reserved Bits    */
    uint16 ETMA:2;                                         /* ETMA[15:14]      */
} __type933;
typedef struct 
{                                                          /* Bit Access       */
    uint8  EST:1;                                          /* EST              */
    uint8  :7;                                             /* Reserved Bits    */
} __type934;
typedef struct 
{                                                          /* Bit Access       */
    uint8  ECT:1;                                          /* ECT              */
    uint8  :7;                                             /* Reserved Bits    */
} __type935;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SSE000:1;                                       /* SSE000           */
    uint32 SSE001:1;                                       /* SSE001           */
    uint32 SSE002:1;                                       /* SSE002           */
    uint32 SSE003:1;                                       /* SSE003           */
    uint32 SSE004:1;                                       /* SSE004           */
    uint32 SSE005:1;                                       /* SSE005           */
    uint32 SSE006:1;                                       /* SSE006           */
    uint32 SSE007:1;                                       /* SSE007           */
    uint32 SSE008:1;                                       /* SSE008           */
    uint32 SSE009:1;                                       /* SSE009           */
    uint32 SSE010:1;                                       /* SSE010           */
    uint32 SSE011:1;                                       /* SSE011           */
    uint32 SSE012:1;                                       /* SSE012           */
    uint32 SSE013:1;                                       /* SSE013           */
    uint32 SSE014:1;                                       /* SSE014           */
    uint32 SSE015:1;                                       /* SSE015           */
    uint32 SSE016:1;                                       /* SSE016           */
    uint32 SSE017:1;                                       /* SSE017           */
    uint32 SSE018:1;                                       /* SSE018           */
    uint32 SSE019:1;                                       /* SSE019           */
    uint32 SSE020:1;                                       /* SSE020           */
    uint32 SSE021:1;                                       /* SSE021           */
    uint32 SSE022:1;                                       /* SSE022           */
    uint32 SSE023:1;                                       /* SSE023           */
    uint32 SSE024:1;                                       /* SSE024           */
    uint32 SSE025:1;                                       /* SSE025           */
    uint32 SSE026:1;                                       /* SSE026           */
    uint32 SSE027:1;                                       /* SSE027           */
    uint32 SSE028:1;                                       /* SSE028           */
    uint32 SSE029:1;                                       /* SSE029           */
    uint32 SSE030:1;                                       /* SSE030           */
    uint32 SSE031:1;                                       /* SSE031           */
} __type936;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SSE100:1;                                       /* SSE100           */
    uint32 SSE101:1;                                       /* SSE101           */
    uint32 SSE102:1;                                       /* SSE102           */
    uint32 SSE103:1;                                       /* SSE103           */
    uint32 SSE104:1;                                       /* SSE104           */
    uint32 SSE105:1;                                       /* SSE105           */
    uint32 SSE106:1;                                       /* SSE106           */
    uint32 SSE107:1;                                       /* SSE107           */
    uint32 SSE108:1;                                       /* SSE108           */
    uint32 SSE109:1;                                       /* SSE109           */
    uint32 SSE110:1;                                       /* SSE110           */
    uint32 SSE111:1;                                       /* SSE111           */
    uint32 SSE112:1;                                       /* SSE112           */
    uint32 SSE113:1;                                       /* SSE113           */
    uint32 SSE114:1;                                       /* SSE114           */
    uint32 SSE115:1;                                       /* SSE115           */
    uint32 :13;                                            /* Reserved Bits    */
    uint32 SSE129:1;                                       /* SSE129           */
    uint32 SSE130:1;                                       /* SSE130           */
    uint32 SSE131:1;                                       /* SSE131           */
} __type937;
typedef struct 
{                                                          /* Bit Access       */
    uint32 REG0:8;                                         /* REG0[7:0]        */
    uint32 :24;                                            /* Reserved Bits    */
} __type938;
typedef struct 
{                                                          /* Bit Access       */
    uint32 WDT0OPWDOVF:3;                                  /* WDT0OPWDOVF[2:0] */
    uint32 WDT0OPWDEN:1;                                   /* WDT0OPWDEN       */
    uint32 WDT0OPWDRUN:1;                                  /* WDT0OPWDRUN      */
    uint32 WDT0OPWDTPR:1;                                  /* WDT0OPWDTPR      */
    uint32 WDT0OPWDVAC:1;                                  /* WDT0OPWDVAC      */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 WDT1OPWDOVF:3;                                  /* WDT1OPWDOVF[10:8] */
    uint32 WDT1OPWDEN:1;                                   /* WDT1OPWDEN       */
    uint32 WDT1OPWDRUN:1;                                  /* WDT1OPWDRUN      */
    uint32 WDT1OPWDTPR:1;                                  /* WDT1OPWDTPR      */
    uint32 WDT1OPWDVAC:1;                                  /* WDT1OPWDVAC      */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 OPJTAG:2;                                       /* OPJTAG[17:16]    */
    uint32 :14;                                            /* Reserved Bits    */
} __type939;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SDRTRC:32;                                      /* SDRTRC[31:0]     */
} __type940;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SDRTRC:8;                                       /* SDRTRC[7:0]      */
    uint32 TSNREFDL:12;                                    /* TSNREFDL[19:8]   */
    uint32 TSNREFDH:12;                                    /* TSNREFDH[31:20]  */
} __type941;
typedef struct 
{                                                          /* Bit Access       */
    uint32 QOS_MODE:3;                                     /* QOS_MODE[2:0]    */
    uint32 :29;                                            /* Reserved Bits    */
} __type942;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CPU0_MAX_COUNT:9;                               /* CPU0_MAX_COUNT[8:0] */
    uint32 :23;                                            /* Reserved Bits    */
} __type943;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CPU0_MAX_RACC:3;                                /* CPU0_MAX_RACC[2:0] */
    uint32 :29;                                            /* Reserved Bits    */
} __type944;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CPU0_MAX_WACC:3;                                /* CPU0_MAX_WACC[2:0] */
    uint32 :29;                                            /* Reserved Bits    */
} __type945;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CPU1_MAX_COUNT:9;                               /* CPU1_MAX_COUNT[8:0] */
    uint32 :23;                                            /* Reserved Bits    */
} __type946;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CPU1_MAX_RACC:3;                                /* CPU1_MAX_RACC[2:0] */
    uint32 :29;                                            /* Reserved Bits    */
} __type947;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CPU1_MAX_WACC:3;                                /* CPU1_MAX_WACC[2:0] */
    uint32 :29;                                            /* Reserved Bits    */
} __type948;
typedef struct 
{                                                          /* Bit Access       */
    uint32 VACC0_MAX_COUNT:9;                              /* VACC0_MAX_COUNT[8:0] */
    uint32 :23;                                            /* Reserved Bits    */
} __type949;
typedef struct 
{                                                          /* Bit Access       */
    uint32 VACC0_MAX_RACC:3;                               /* VACC0_MAX_RACC[2:0] */
    uint32 :29;                                            /* Reserved Bits    */
} __type950;
typedef struct 
{                                                          /* Bit Access       */
    uint32 VACC0_MAX_WACC:3;                               /* VACC0_MAX_WACC[2:0] */
    uint32 :29;                                            /* Reserved Bits    */
} __type951;
typedef struct 
{                                                          /* Bit Access       */
    uint32 VACC1_MAX_COUNT:9;                              /* VACC1_MAX_COUNT[8:0] */
    uint32 :23;                                            /* Reserved Bits    */
} __type952;
typedef struct 
{                                                          /* Bit Access       */
    uint32 VACC1_MAX_RACC:3;                               /* VACC1_MAX_RACC[2:0] */
    uint32 :29;                                            /* Reserved Bits    */
} __type953;
typedef struct 
{                                                          /* Bit Access       */
    uint32 VACC1_MAX_WACC:3;                               /* VACC1_MAX_WACC[2:0] */
    uint32 :29;                                            /* Reserved Bits    */
} __type954;
typedef struct 
{                                                          /* Bit Access       */
    uint32 JCUA_MAX_COUNT:9;                               /* JCUA_MAX_COUNT[8:0] */
    uint32 :23;                                            /* Reserved Bits    */
} __type955;
typedef struct 
{                                                          /* Bit Access       */
    uint32 JCUA_MAX_RACC:3;                                /* JCUA_MAX_RACC[2:0] */
    uint32 :29;                                            /* Reserved Bits    */
} __type956;
typedef struct 
{                                                          /* Bit Access       */
    uint32 JCUA_MAX_WACC:3;                                /* JCUA_MAX_WACC[2:0] */
    uint32 :29;                                            /* Reserved Bits    */
} __type957;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GPU2D_MAX_COUNT:9;                              /* GPU2D_MAX_COUNT[8:0] */
    uint32 :23;                                            /* Reserved Bits    */
} __type958;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GPU2D_MAX_RACC:3;                               /* GPU2D_MAX_RACC[2:0] */
    uint32 :29;                                            /* Reserved Bits    */
} __type959;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GPU2D_MAX_WACC:3;                               /* GPU2D_MAX_WACC[2:0] */
    uint32 :29;                                            /* Reserved Bits    */
} __type960;
typedef struct 
{                                                          /* Bit Access       */
    uint32 ETNB_MAX_COUNT:9;                               /* ETNB_MAX_COUNT[8:0] */
    uint32 :23;                                            /* Reserved Bits    */
} __type961;
typedef struct 
{                                                          /* Bit Access       */
    uint32 ETNB_MAX_RACC:3;                                /* ETNB_MAX_RACC[2:0] */
    uint32 :29;                                            /* Reserved Bits    */
} __type962;
typedef struct 
{                                                          /* Bit Access       */
    uint32 ETNB_MAX_WACC:3;                                /* ETNB_MAX_WACC[2:0] */
    uint32 :29;                                            /* Reserved Bits    */
} __type963;
typedef struct 
{                                                          /* Bit Access       */
    uint8  LWBR0:1;                                        /* LWBR0            */
    uint8  LPRS:3;                                         /* LPRS[3:1]        */
    uint8  NSPB:4;                                         /* NSPB[7:4]        */
} __type964;
typedef struct 
{                                                          /* Bit Access       */
    uint8  LBRP0:8;                                        /* LBRP0[7:0]       */
    uint8  LBRP1:8;                                        /* LBRP1[15:8]      */
} __type965;
typedef struct 
{                                                          /* Bit Access       */
    uint8  LSTM:1;                                         /* LSTM             */
    uint8  :7;                                             /* Reserved Bits    */
} __type966;
typedef struct 
{                                                          /* Bit Access       */
    uint8  LMD:2;                                          /* LMD[1:0]         */
    uint8  LCKS:2;                                         /* LCKS[3:2]        */
    uint8  LIOS:1;                                         /* LIOS             */
    uint8  LRDNFS:1;                                       /* LRDNFS           */
    uint8  :2;                                             /* Reserved Bits    */
} __type967;
typedef struct 
{                                                          /* Bit Access       */
    uint8  BLT:4;                                          /* BLT[3:0]         */
    uint8  BDT:2;                                          /* BDT[5:4]         */
    uint8  :2;                                             /* Reserved Bits    */
} __type968;
typedef struct 
{                                                          /* Bit Access       */
    uint8  IBHS:3;                                         /* IBHS[2:0]        */
    uint8  :1;                                             /* Reserved Bits    */
    uint8  IBS:2;                                          /* IBS[5:4]         */
    uint8  :2;                                             /* Reserved Bits    */
} __type969;
typedef struct 
{                                                          /* Bit Access       */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  WUTL:4;                                         /* WUTL[7:4]        */
} __type970;
typedef struct 
{                                                          /* Bit Access       */
    uint8  FTCIE:1;                                        /* FTCIE            */
    uint8  FRCIE:1;                                        /* FRCIE            */
    uint8  ERRIE:1;                                        /* ERRIE            */
    uint8  SHIE:1;                                         /* SHIE             */
    uint8  :4;                                             /* Reserved Bits    */
} __type971;
typedef struct 
{                                                          /* Bit Access       */
    uint8  BERE:1;                                         /* BERE             */
    uint8  PBERE:1;                                        /* PBERE            */
    uint8  FTERE:1;                                        /* FTERE            */
    uint8  FERE:1;                                         /* FERE             */
    uint8  :3;                                             /* Reserved Bits    */
    uint8  LTES:1;                                         /* LTES             */
} __type972;
typedef struct 
{                                                          /* Bit Access       */
    uint8  OM0:1;                                          /* OM0              */
    uint8  OM1:1;                                          /* OM1              */
    uint8  :6;                                             /* Reserved Bits    */
} __type973;
typedef struct 
{                                                          /* Bit Access       */
    uint8  FTS:1;                                          /* FTS              */
    uint8  RTS:1;                                          /* RTS              */
    uint8  :6;                                             /* Reserved Bits    */
} __type974;
typedef struct 
{                                                          /* Bit Access       */
    uint8  OMM0:1;                                         /* OMM0             */
    uint8  OMM1:1;                                         /* OMM1             */
    uint8  :6;                                             /* Reserved Bits    */
} __type975;
typedef struct 
{                                                          /* Bit Access       */
    uint8  FTC:1;                                          /* FTC              */
    uint8  FRC:1;                                          /* FRC              */
    uint8  :1;                                             /* Reserved Bits    */
    uint8  ERR:1;                                          /* ERR              */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  D1RC:1;                                         /* D1RC             */
    uint8  HTRC:1;                                         /* HTRC             */
} __type976;
typedef struct 
{                                                          /* Bit Access       */
    uint8  BER:1;                                          /* BER              */
    uint8  PBER:1;                                         /* PBER             */
    uint8  FTER:1;                                         /* FTER             */
    uint8  FER:1;                                          /* FER              */
    uint8  :1;                                             /* Reserved Bits    */
    uint8  CSER:1;                                         /* CSER             */
    uint8  :1;                                             /* Reserved Bits    */
    uint8  RPER:1;                                         /* RPER             */
} __type977;
typedef struct 
{                                                          /* Bit Access       */
    uint8  RFDL:4;                                         /* RFDL[3:0]        */
    uint8  RFT:1;                                          /* RFT              */
    uint8  CSM:1;                                          /* CSM              */
    uint8  FSM:1;                                          /* FSM              */
    uint8  LSS:1;                                          /* LSS              */
} __type978;
typedef struct 
{                                                          /* Bit Access       */
    uint8  ID:6;                                           /* ID[5:0]          */
    uint8  IDP0:1;                                         /* IDP0             */
    uint8  IDP1:1;                                         /* IDP1             */
} __type979;
typedef struct 
{                                                          /* Bit Access       */
    uint8  CKSM:8;                                         /* CKSM[7:0]        */
} __type980;
typedef struct 
{                                                          /* Bit Access       */
    uint8  UDB:8;                                          /* UDB[7:0]         */
} __type981;
typedef struct 
{                                                          /* Bit Access       */
    uint8  LDB:8;                                          /* LDB[7:0]         */
} __type982;
typedef struct 
{                                                          /* Bit Access       */
    uint8  UTOE:1;                                         /* UTOE             */
    uint8  UROE:1;                                         /* UROE             */
    uint8  :6;                                             /* Reserved Bits    */
} __type983;
typedef struct 
{                                                          /* Bit Access       */
    uint8  UEBE:1;                                         /* UEBE             */
    uint8  UEBDL:1;                                        /* UEBDL            */
    uint8  UEBDCE:1;                                       /* UEBDCE           */
    uint8  UTIGTS:1;                                       /* UTIGTS           */
    uint8  UECD:1;                                         /* UECD             */
    uint8  :3;                                             /* Reserved Bits    */
} __type984;
typedef struct 
{                                                          /* Bit Access       */
    uint16 UTD:9;                                          /* UTD[8:0]         */
    uint8  :7;                                             /* Reserved Bits    */
} __type985;
typedef struct 
{                                                          /* Bit Access       */
    uint16 URD:9;                                          /* URD[8:0]         */
    uint8  :7;                                             /* Reserved Bits    */
} __type986;
typedef struct 
{                                                          /* Bit Access       */
    uint16 UWTD:9;                                         /* UWTD[8:0]        */
    uint8  :7;                                             /* Reserved Bits    */
} __type987;
typedef struct 
{                                                          /* Bit Access       */
    uint16 BRP:10;                                         /* BRP[9:0]         */
    uint8  :6;                                             /* Reserved Bits    */
    uint8  TSEG1:4;                                        /* TSEG1[19:16]     */
    uint8  TSEG2:3;                                        /* TSEG2[22:20]     */
    uint8  :1;                                             /* Reserved Bits    */
    uint8  SJW:2;                                          /* SJW[25:24]       */
    uint8  :6;                                             /* Reserved Bits    */
} __type988;
typedef struct 
{                                                          /* Bit Access       */
    uint8  CHMDC:2;                                        /* CHMDC[1:0]       */
    uint8  CSLPR:1;                                        /* CSLPR            */
    uint8  RTBO:1;                                         /* RTBO             */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  BEIE:1;                                         /* BEIE             */
    uint8  EWIE:1;                                         /* EWIE             */
    uint8  EPIE:1;                                         /* EPIE             */
    uint8  BOEIE:1;                                        /* BOEIE            */
    uint8  BORIE:1;                                        /* BORIE            */
    uint8  OLIE:1;                                         /* OLIE             */
    uint8  BLIE:1;                                         /* BLIE             */
    uint8  ALIE:1;                                         /* ALIE             */
    uint8  TAIE:1;                                         /* TAIE             */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  BOM:2;                                          /* BOM[22:21]       */
    uint8  ERRD:1;                                         /* ERRD             */
    uint8  CTME:1;                                         /* CTME             */
    uint8  CTMS:2;                                         /* CTMS[26:25]      */
    uint8  :5;                                             /* Reserved Bits    */
} __type989;
typedef struct 
{                                                          /* Bit Access       */
    uint8  CRSTSTS:1;                                      /* CRSTSTS          */
    uint8  CHLTSTS:1;                                      /* CHLTSTS          */
    uint8  CSLPSTS:1;                                      /* CSLPSTS          */
    uint8  EPSTS:1;                                        /* EPSTS            */
    uint8  BOSTS:1;                                        /* BOSTS            */
    uint8  TRMSTS:1;                                       /* TRMSTS           */
    uint8  RECSTS:1;                                       /* RECSTS           */
    uint8  COMSTS:1;                                       /* COMSTS           */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  REC:8;                                          /* REC[23:16]       */
    uint8  TEC:8;                                          /* TEC[31:24]       */
} __type990;
typedef struct 
{                                                          /* Bit Access       */
    uint8  BEF:1;                                          /* BEF              */
    uint8  EWF:1;                                          /* EWF              */
    uint8  EPF:1;                                          /* EPF              */
    uint8  BOEF:1;                                         /* BOEF             */
    uint8  BORF:1;                                         /* BORF             */
    uint8  OVLF:1;                                         /* OVLF             */
    uint8  BLF:1;                                          /* BLF              */
    uint8  ALF:1;                                          /* ALF              */
    uint8  SERR:1;                                         /* SERR             */
    uint8  FERR:1;                                         /* FERR             */
    uint8  AERR:1;                                         /* AERR             */
    uint8  CERR:1;                                         /* CERR             */
    uint8  B1ERR:1;                                        /* B1ERR            */
    uint8  B0ERR:1;                                        /* B0ERR            */
    uint8  ADERR:1;                                        /* ADERR            */
    uint8  :1;                                             /* Reserved Bits    */
    uint16 CRCREG:15;                                      /* CRCREG[30:16]    */
    uint8  :1;                                             /* Reserved Bits    */
} __type991;
typedef struct 
{                                                          /* Bit Access       */
    uint8  TPRI:1;                                         /* TPRI             */
    uint8  DCE:1;                                          /* DCE              */
    uint8  DRE:1;                                          /* DRE              */
    uint8  MME:1;                                          /* MME              */
    uint8  DCS:1;                                          /* DCS              */
    uint8  :3;                                             /* Reserved Bits    */
    uint8  TSP:4;                                          /* TSP[11:8]        */
    uint8  TSSS:1;                                         /* TSSS             */
    uint8  TSBTCS:3;                                       /* TSBTCS[15:13]    */
    uint16 ITRCP:16;                                       /* ITRCP[31:16]     */
} __type992;
typedef struct 
{                                                          /* Bit Access       */
    uint8  GMDC:2;                                         /* GMDC[1:0]        */
    uint8  GSLPR:1;                                        /* GSLPR            */
    uint8  :5;                                             /* Reserved Bits    */
    uint8  DEIE:1;                                         /* DEIE             */
    uint8  MEIE:1;                                         /* MEIE             */
    uint8  THLEIE:1;                                       /* THLEIE           */
    uint8  :5;                                             /* Reserved Bits    */
    uint8  TSRST:1;                                        /* TSRST            */
    uint8  :7;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type993;
typedef struct 
{                                                          /* Bit Access       */
    uint8  GRSTSTS:1;                                      /* GRSTSTS          */
    uint8  GHLTSTS:1;                                      /* GHLTSTS          */
    uint8  GSLPSTS:1;                                      /* GSLPSTS          */
    uint8  GRAMINIT:1;                                     /* GRAMINIT         */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type994;
typedef struct 
{                                                          /* Bit Access       */
    uint8  DEF:1;                                          /* DEF              */
    uint8  MES:1;                                          /* MES              */
    uint8  THLES:1;                                        /* THLES            */
    uint8  :5;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type995;
typedef struct 
{                                                          /* Bit Access       */
    uint16 TS:16;                                          /* TS[15:0]         */
    uint16 :16;                                            /* Reserved Bits    */
} __type996;
typedef struct 
{                                                          /* Bit Access       */
    uint8  AFLPN:5;                                        /* AFLPN[4:0]       */
    uint8  :3;                                             /* Reserved Bits    */
    uint8  AFLDAE:1;                                       /* AFLDAE           */
    uint8  :7;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type997;
typedef struct 
{                                                          /* Bit Access       */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  RNC2:8;                                         /* RNC2[15:8]       */
    uint8  RNC1:8;                                         /* RNC1[23:16]      */
    uint8  RNC0:8;                                         /* RNC0[31:24]      */
} __type998;
typedef struct 
{                                                          /* Bit Access       */
    uint8  NRXMB:8;                                        /* NRXMB[7:0]       */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type999;
typedef struct 
{                                                          /* Bit Access       */
    uint8  RMNS0:1;                                        /* RMNS0            */
    uint8  RMNS1:1;                                        /* RMNS1            */
    uint8  RMNS2:1;                                        /* RMNS2            */
    uint8  RMNS3:1;                                        /* RMNS3            */
    uint8  RMNS4:1;                                        /* RMNS4            */
    uint8  RMNS5:1;                                        /* RMNS5            */
    uint8  RMNS6:1;                                        /* RMNS6            */
    uint8  RMNS7:1;                                        /* RMNS7            */
    uint8  RMNS8:1;                                        /* RMNS8            */
    uint8  RMNS9:1;                                        /* RMNS9            */
    uint8  RMNS10:1;                                       /* RMNS10           */
    uint8  RMNS11:1;                                       /* RMNS11           */
    uint8  RMNS12:1;                                       /* RMNS12           */
    uint8  RMNS13:1;                                       /* RMNS13           */
    uint8  RMNS14:1;                                       /* RMNS14           */
    uint8  RMNS15:1;                                       /* RMNS15           */
    uint8  RMNS16:1;                                       /* RMNS16           */
    uint8  RMNS17:1;                                       /* RMNS17           */
    uint8  RMNS18:1;                                       /* RMNS18           */
    uint8  RMNS19:1;                                       /* RMNS19           */
    uint8  RMNS20:1;                                       /* RMNS20           */
    uint8  RMNS21:1;                                       /* RMNS21           */
    uint8  RMNS22:1;                                       /* RMNS22           */
    uint8  RMNS23:1;                                       /* RMNS23           */
    uint8  RMNS24:1;                                       /* RMNS24           */
    uint8  RMNS25:1;                                       /* RMNS25           */
    uint8  RMNS26:1;                                       /* RMNS26           */
    uint8  RMNS27:1;                                       /* RMNS27           */
    uint8  RMNS28:1;                                       /* RMNS28           */
    uint8  RMNS29:1;                                       /* RMNS29           */
    uint8  RMNS30:1;                                       /* RMNS30           */
    uint8  RMNS31:1;                                       /* RMNS31           */
} __type1000;
typedef struct 
{                                                          /* Bit Access       */
    uint8  RMNS32:1;                                       /* RMNS32           */
    uint8  RMNS33:1;                                       /* RMNS33           */
    uint8  RMNS34:1;                                       /* RMNS34           */
    uint8  RMNS35:1;                                       /* RMNS35           */
    uint8  RMNS36:1;                                       /* RMNS36           */
    uint8  RMNS37:1;                                       /* RMNS37           */
    uint8  RMNS38:1;                                       /* RMNS38           */
    uint8  RMNS39:1;                                       /* RMNS39           */
    uint8  RMNS40:1;                                       /* RMNS40           */
    uint8  RMNS41:1;                                       /* RMNS41           */
    uint8  RMNS42:1;                                       /* RMNS42           */
    uint8  RMNS43:1;                                       /* RMNS43           */
    uint8  RMNS44:1;                                       /* RMNS44           */
    uint8  RMNS45:1;                                       /* RMNS45           */
    uint8  RMNS46:1;                                       /* RMNS46           */
    uint8  RMNS47:1;                                       /* RMNS47           */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type1001;
typedef struct 
{                                                          /* Bit Access       */
    uint8  RFE:1;                                          /* RFE              */
    uint8  RFIE:1;                                         /* RFIE             */
    uint8  :6;                                             /* Reserved Bits    */
    uint8  RFDC:3;                                         /* RFDC[10:8]       */
    uint8  :1;                                             /* Reserved Bits    */
    uint8  RFIM:1;                                         /* RFIM             */
    uint8  RFIGCV:3;                                       /* RFIGCV[15:13]    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type1002;
typedef struct 
{                                                          /* Bit Access       */
    uint8  RFEMP:1;                                        /* RFEMP            */
    uint8  RFFLL:1;                                        /* RFFLL            */
    uint8  RFMLT:1;                                        /* RFMLT            */
    uint8  RFIF:1;                                         /* RFIF             */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFMC:8;                                         /* RFMC[15:8]       */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type1003;
typedef struct 
{                                                          /* Bit Access       */
    uint8  RFPC:8;                                         /* RFPC[7:0]        */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type1004;
typedef struct 
{                                                          /* Bit Access       */
    uint8  CFE:1;                                          /* CFE              */
    uint8  CFRXIE:1;                                       /* CFRXIE           */
    uint8  CFTXIE:1;                                       /* CFTXIE           */
    uint8  :5;                                             /* Reserved Bits    */
    uint8  CFDC:3;                                         /* CFDC[10:8]       */
    uint8  :1;                                             /* Reserved Bits    */
    uint8  CFIM:1;                                         /* CFIM             */
    uint8  CFIGCV:3;                                       /* CFIGCV[15:13]    */
    uint8  CFM:2;                                          /* CFM[17:16]       */
    uint8  CFITSS:1;                                       /* CFITSS           */
    uint8  CFITR:1;                                        /* CFITR            */
    uint8  CFTML:4;                                        /* CFTML[23:20]     */
    uint8  CFITT:8;                                        /* CFITT[31:24]     */
} __type1005;
typedef struct 
{                                                          /* Bit Access       */
    uint8  CFEMP:1;                                        /* CFEMP            */
    uint8  CFFLL:1;                                        /* CFFLL            */
    uint8  CFMLT:1;                                        /* CFMLT            */
    uint8  CFRXIF:1;                                       /* CFRXIF           */
    uint8  CFTXIF:1;                                       /* CFTXIF           */
    uint8  :3;                                             /* Reserved Bits    */
    uint8  CFMC:8;                                         /* CFMC[15:8]       */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type1006;
typedef struct 
{                                                          /* Bit Access       */
    uint8  CFPC:8;                                         /* CFPC[7:0]        */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type1007;
typedef struct 
{                                                          /* Bit Access       */
    uint8  RF0EMP:1;                                       /* RF0EMP           */
    uint8  RF1EMP:1;                                       /* RF1EMP           */
    uint8  RF2EMP:1;                                       /* RF2EMP           */
    uint8  RF3EMP:1;                                       /* RF3EMP           */
    uint8  RF4EMP:1;                                       /* RF4EMP           */
    uint8  RF5EMP:1;                                       /* RF5EMP           */
    uint8  RF6EMP:1;                                       /* RF6EMP           */
    uint8  RF7EMP:1;                                       /* RF7EMP           */
    uint8  CF0EMP:1;                                       /* CF0EMP           */
    uint8  CF1EMP:1;                                       /* CF1EMP           */
    uint8  CF2EMP:1;                                       /* CF2EMP           */
    uint8  CF3EMP:1;                                       /* CF3EMP           */
    uint8  CF4EMP:1;                                       /* CF4EMP           */
    uint8  CF5EMP:1;                                       /* CF5EMP           */
    uint8  CF6EMP:1;                                       /* CF6EMP           */
    uint8  CF7EMP:1;                                       /* CF7EMP           */
    uint8  CF8EMP:1;                                       /* CF8EMP           */
    uint8  :7;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type1008;
typedef struct 
{                                                          /* Bit Access       */
    uint8  RF0FLL:1;                                       /* RF0FLL           */
    uint8  RF1FLL:1;                                       /* RF1FLL           */
    uint8  RF2FLL:1;                                       /* RF2FLL           */
    uint8  RF3FLL:1;                                       /* RF3FLL           */
    uint8  RF4FLL:1;                                       /* RF4FLL           */
    uint8  RF5FLL:1;                                       /* RF5FLL           */
    uint8  RF6FLL:1;                                       /* RF6FLL           */
    uint8  RF7FLL:1;                                       /* RF7FLL           */
    uint8  CF0FLL:1;                                       /* CF0FLL           */
    uint8  CF1FLL:1;                                       /* CF1FLL           */
    uint8  CF2FLL:1;                                       /* CF2FLL           */
    uint8  CF3FLL:1;                                       /* CF3FLL           */
    uint8  CF4FLL:1;                                       /* CF4FLL           */
    uint8  CF5FLL:1;                                       /* CF5FLL           */
    uint8  CF6FLL:1;                                       /* CF6FLL           */
    uint8  CF7FLL:1;                                       /* CF7FLL           */
    uint8  CF8FLL:1;                                       /* CF8FLL           */
    uint8  :7;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type1009;
typedef struct 
{                                                          /* Bit Access       */
    uint8  RF0MLT:1;                                       /* RF0MLT           */
    uint8  RF1MLT:1;                                       /* RF1MLT           */
    uint8  RF2MLT:1;                                       /* RF2MLT           */
    uint8  RF3MLT:1;                                       /* RF3MLT           */
    uint8  RF4MLT:1;                                       /* RF4MLT           */
    uint8  RF5MLT:1;                                       /* RF5MLT           */
    uint8  RF6MLT:1;                                       /* RF6MLT           */
    uint8  RF7MLT:1;                                       /* RF7MLT           */
    uint8  CF0MLT:1;                                       /* CF0MLT           */
    uint8  CF1MLT:1;                                       /* CF1MLT           */
    uint8  CF2MLT:1;                                       /* CF2MLT           */
    uint8  CF3MLT:1;                                       /* CF3MLT           */
    uint8  CF4MLT:1;                                       /* CF4MLT           */
    uint8  CF5MLT:1;                                       /* CF5MLT           */
    uint8  CF6MLT:1;                                       /* CF6MLT           */
    uint8  CF7MLT:1;                                       /* CF7MLT           */
    uint8  CF8MLT:1;                                       /* CF8MLT           */
    uint8  :7;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type1010;
typedef struct 
{                                                          /* Bit Access       */
    uint8  RF0IF:1;                                        /* RF0IF            */
    uint8  RF1IF:1;                                        /* RF1IF            */
    uint8  RF2IF:1;                                        /* RF2IF            */
    uint8  RF3IF:1;                                        /* RF3IF            */
    uint8  RF4IF:1;                                        /* RF4IF            */
    uint8  RF5IF:1;                                        /* RF5IF            */
    uint8  RF6IF:1;                                        /* RF6IF            */
    uint8  RF7IF:1;                                        /* RF7IF            */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type1011;
typedef struct 
{                                                          /* Bit Access       */
    uint8  CF0RXIF:1;                                      /* CF0RXIF          */
    uint8  CF1RXIF:1;                                      /* CF1RXIF          */
    uint8  CF2RXIF:1;                                      /* CF2RXIF          */
    uint8  CF3RXIF:1;                                      /* CF3RXIF          */
    uint8  CF4RXIF:1;                                      /* CF4RXIF          */
    uint8  CF5RXIF:1;                                      /* CF5RXIF          */
    uint8  CF6RXIF:1;                                      /* CF6RXIF          */
    uint8  CF7RXIF:1;                                      /* CF7RXIF          */
    uint8  CF8RXIF:1;                                      /* CF8RXIF          */
    uint8  :7;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type1012;
typedef struct 
{                                                          /* Bit Access       */
    uint8  CF0TXIF:1;                                      /* CF0TXIF          */
    uint8  CF1TXIF:1;                                      /* CF1TXIF          */
    uint8  CF2TXIF:1;                                      /* CF2TXIF          */
    uint8  CF3TXIF:1;                                      /* CF3TXIF          */
    uint8  CF4TXIF:1;                                      /* CF4TXIF          */
    uint8  CF5TXIF:1;                                      /* CF5TXIF          */
    uint8  CF6TXIF:1;                                      /* CF6TXIF          */
    uint8  CF7TXIF:1;                                      /* CF7TXIF          */
    uint8  CF8TXIF:1;                                      /* CF8TXIF          */
    uint8  :7;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type1013;
typedef struct 
{                                                          /* Bit Access       */
    uint8  TMTR:1;                                         /* TMTR             */
    uint8  TMTAR:1;                                        /* TMTAR            */
    uint8  TMOM:1;                                         /* TMOM             */
    uint8  :5;                                             /* Reserved Bits    */
} __type1014;
typedef struct 
{                                                          /* Bit Access       */
    uint8  TMTSTS:1;                                       /* TMTSTS           */
    uint8  TMTRF:2;                                        /* TMTRF[2:1]       */
    uint8  TMTRM:1;                                        /* TMTRM            */
    uint8  TMTARM:1;                                       /* TMTARM           */
    uint8  :3;                                             /* Reserved Bits    */
} __type1015;
typedef struct 
{                                                          /* Bit Access       */
    uint8  TMTRSTS0:1;                                     /* TMTRSTS0         */
    uint8  TMTRSTS1:1;                                     /* TMTRSTS1         */
    uint8  TMTRSTS2:1;                                     /* TMTRSTS2         */
    uint8  TMTRSTS3:1;                                     /* TMTRSTS3         */
    uint8  TMTRSTS4:1;                                     /* TMTRSTS4         */
    uint8  TMTRSTS5:1;                                     /* TMTRSTS5         */
    uint8  TMTRSTS6:1;                                     /* TMTRSTS6         */
    uint8  TMTRSTS7:1;                                     /* TMTRSTS7         */
    uint8  TMTRSTS8:1;                                     /* TMTRSTS8         */
    uint8  TMTRSTS9:1;                                     /* TMTRSTS9         */
    uint8  TMTRSTS10:1;                                    /* TMTRSTS10        */
    uint8  TMTRSTS11:1;                                    /* TMTRSTS11        */
    uint8  TMTRSTS12:1;                                    /* TMTRSTS12        */
    uint8  TMTRSTS13:1;                                    /* TMTRSTS13        */
    uint8  TMTRSTS14:1;                                    /* TMTRSTS14        */
    uint8  TMTRSTS15:1;                                    /* TMTRSTS15        */
    uint8  TMTRSTS16:1;                                    /* TMTRSTS16        */
    uint8  TMTRSTS17:1;                                    /* TMTRSTS17        */
    uint8  TMTRSTS18:1;                                    /* TMTRSTS18        */
    uint8  TMTRSTS19:1;                                    /* TMTRSTS19        */
    uint8  TMTRSTS20:1;                                    /* TMTRSTS20        */
    uint8  TMTRSTS21:1;                                    /* TMTRSTS21        */
    uint8  TMTRSTS22:1;                                    /* TMTRSTS22        */
    uint8  TMTRSTS23:1;                                    /* TMTRSTS23        */
    uint8  TMTRSTS24:1;                                    /* TMTRSTS24        */
    uint8  TMTRSTS25:1;                                    /* TMTRSTS25        */
    uint8  TMTRSTS26:1;                                    /* TMTRSTS26        */
    uint8  TMTRSTS27:1;                                    /* TMTRSTS27        */
    uint8  TMTRSTS28:1;                                    /* TMTRSTS28        */
    uint8  TMTRSTS29:1;                                    /* TMTRSTS29        */
    uint8  TMTRSTS30:1;                                    /* TMTRSTS30        */
    uint8  TMTRSTS31:1;                                    /* TMTRSTS31        */
} __type1016;
typedef struct 
{                                                          /* Bit Access       */
    uint8  TMTRSTS32:1;                                    /* TMTRSTS32        */
    uint8  TMTRSTS33:1;                                    /* TMTRSTS33        */
    uint8  TMTRSTS34:1;                                    /* TMTRSTS34        */
    uint8  TMTRSTS35:1;                                    /* TMTRSTS35        */
    uint8  TMTRSTS36:1;                                    /* TMTRSTS36        */
    uint8  TMTRSTS37:1;                                    /* TMTRSTS37        */
    uint8  TMTRSTS38:1;                                    /* TMTRSTS38        */
    uint8  TMTRSTS39:1;                                    /* TMTRSTS39        */
    uint8  TMTRSTS40:1;                                    /* TMTRSTS40        */
    uint8  TMTRSTS41:1;                                    /* TMTRSTS41        */
    uint8  TMTRSTS42:1;                                    /* TMTRSTS42        */
    uint8  TMTRSTS43:1;                                    /* TMTRSTS43        */
    uint8  TMTRSTS44:1;                                    /* TMTRSTS44        */
    uint8  TMTRSTS45:1;                                    /* TMTRSTS45        */
    uint8  TMTRSTS46:1;                                    /* TMTRSTS46        */
    uint8  TMTRSTS47:1;                                    /* TMTRSTS47        */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type1017;
typedef struct 
{                                                          /* Bit Access       */
    uint8  TMTARSTS0:1;                                    /* TMTARSTS0        */
    uint8  TMTARSTS1:1;                                    /* TMTARSTS1        */
    uint8  TMTARSTS2:1;                                    /* TMTARSTS2        */
    uint8  TMTARSTS3:1;                                    /* TMTARSTS3        */
    uint8  TMTARSTS4:1;                                    /* TMTARSTS4        */
    uint8  TMTARSTS5:1;                                    /* TMTARSTS5        */
    uint8  TMTARSTS6:1;                                    /* TMTARSTS6        */
    uint8  TMTARSTS7:1;                                    /* TMTARSTS7        */
    uint8  TMTARSTS8:1;                                    /* TMTARSTS8        */
    uint8  TMTARSTS9:1;                                    /* TMTARSTS9        */
    uint8  TMTARSTS10:1;                                   /* TMTARSTS10       */
    uint8  TMTARSTS11:1;                                   /* TMTARSTS11       */
    uint8  TMTARSTS12:1;                                   /* TMTARSTS12       */
    uint8  TMTARSTS13:1;                                   /* TMTARSTS13       */
    uint8  TMTARSTS14:1;                                   /* TMTARSTS14       */
    uint8  TMTARSTS15:1;                                   /* TMTARSTS15       */
    uint8  TMTARSTS16:1;                                   /* TMTARSTS16       */
    uint8  TMTARSTS17:1;                                   /* TMTARSTS17       */
    uint8  TMTARSTS18:1;                                   /* TMTARSTS18       */
    uint8  TMTARSTS19:1;                                   /* TMTARSTS19       */
    uint8  TMTARSTS20:1;                                   /* TMTARSTS20       */
    uint8  TMTARSTS21:1;                                   /* TMTARSTS21       */
    uint8  TMTARSTS22:1;                                   /* TMTARSTS22       */
    uint8  TMTARSTS23:1;                                   /* TMTARSTS23       */
    uint8  TMTARSTS24:1;                                   /* TMTARSTS24       */
    uint8  TMTARSTS25:1;                                   /* TMTARSTS25       */
    uint8  TMTARSTS26:1;                                   /* TMTARSTS26       */
    uint8  TMTARSTS27:1;                                   /* TMTARSTS27       */
    uint8  TMTARSTS28:1;                                   /* TMTARSTS28       */
    uint8  TMTARSTS29:1;                                   /* TMTARSTS29       */
    uint8  TMTARSTS30:1;                                   /* TMTARSTS30       */
    uint8  TMTARSTS31:1;                                   /* TMTARSTS31       */
} __type1018;
typedef struct 
{                                                          /* Bit Access       */
    uint8  TMTARSTS32:1;                                   /* TMTARSTS32       */
    uint8  TMTARSTS33:1;                                   /* TMTARSTS33       */
    uint8  TMTARSTS34:1;                                   /* TMTARSTS34       */
    uint8  TMTARSTS35:1;                                   /* TMTARSTS35       */
    uint8  TMTARSTS36:1;                                   /* TMTARSTS36       */
    uint8  TMTARSTS37:1;                                   /* TMTARSTS37       */
    uint8  TMTARSTS38:1;                                   /* TMTARSTS38       */
    uint8  TMTARSTS39:1;                                   /* TMTARSTS39       */
    uint8  TMTARSTS40:1;                                   /* TMTARSTS40       */
    uint8  TMTARSTS41:1;                                   /* TMTARSTS41       */
    uint8  TMTARSTS42:1;                                   /* TMTARSTS42       */
    uint8  TMTARSTS43:1;                                   /* TMTARSTS43       */
    uint8  TMTARSTS44:1;                                   /* TMTARSTS44       */
    uint8  TMTARSTS45:1;                                   /* TMTARSTS45       */
    uint8  TMTARSTS46:1;                                   /* TMTARSTS46       */
    uint8  TMTARSTS47:1;                                   /* TMTARSTS47       */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type1019;
typedef struct 
{                                                          /* Bit Access       */
    uint8  TMTCSTS0:1;                                     /* TMTCSTS0         */
    uint8  TMTCSTS1:1;                                     /* TMTCSTS1         */
    uint8  TMTCSTS2:1;                                     /* TMTCSTS2         */
    uint8  TMTCSTS3:1;                                     /* TMTCSTS3         */
    uint8  TMTCSTS4:1;                                     /* TMTCSTS4         */
    uint8  TMTCSTS5:1;                                     /* TMTCSTS5         */
    uint8  TMTCSTS6:1;                                     /* TMTCSTS6         */
    uint8  TMTCSTS7:1;                                     /* TMTCSTS7         */
    uint8  TMTCSTS8:1;                                     /* TMTCSTS8         */
    uint8  TMTCSTS9:1;                                     /* TMTCSTS9         */
    uint8  TMTCSTS10:1;                                    /* TMTCSTS10        */
    uint8  TMTCSTS11:1;                                    /* TMTCSTS11        */
    uint8  TMTCSTS12:1;                                    /* TMTCSTS12        */
    uint8  TMTCSTS13:1;                                    /* TMTCSTS13        */
    uint8  TMTCSTS14:1;                                    /* TMTCSTS14        */
    uint8  TMTCSTS15:1;                                    /* TMTCSTS15        */
    uint8  TMTCSTS16:1;                                    /* TMTCSTS16        */
    uint8  TMTCSTS17:1;                                    /* TMTCSTS17        */
    uint8  TMTCSTS18:1;                                    /* TMTCSTS18        */
    uint8  TMTCSTS19:1;                                    /* TMTCSTS19        */
    uint8  TMTCSTS20:1;                                    /* TMTCSTS20        */
    uint8  TMTCSTS21:1;                                    /* TMTCSTS21        */
    uint8  TMTCSTS22:1;                                    /* TMTCSTS22        */
    uint8  TMTCSTS23:1;                                    /* TMTCSTS23        */
    uint8  TMTCSTS24:1;                                    /* TMTCSTS24        */
    uint8  TMTCSTS25:1;                                    /* TMTCSTS25        */
    uint8  TMTCSTS26:1;                                    /* TMTCSTS26        */
    uint8  TMTCSTS27:1;                                    /* TMTCSTS27        */
    uint8  TMTCSTS28:1;                                    /* TMTCSTS28        */
    uint8  TMTCSTS29:1;                                    /* TMTCSTS29        */
    uint8  TMTCSTS30:1;                                    /* TMTCSTS30        */
    uint8  TMTCSTS31:1;                                    /* TMTCSTS31        */
} __type1020;
typedef struct 
{                                                          /* Bit Access       */
    uint8  TMTCSTS32:1;                                    /* TMTCSTS32        */
    uint8  TMTCSTS33:1;                                    /* TMTCSTS33        */
    uint8  TMTCSTS34:1;                                    /* TMTCSTS34        */
    uint8  TMTCSTS35:1;                                    /* TMTCSTS35        */
    uint8  TMTCSTS36:1;                                    /* TMTCSTS36        */
    uint8  TMTCSTS37:1;                                    /* TMTCSTS37        */
    uint8  TMTCSTS38:1;                                    /* TMTCSTS38        */
    uint8  TMTCSTS39:1;                                    /* TMTCSTS39        */
    uint8  TMTCSTS40:1;                                    /* TMTCSTS40        */
    uint8  TMTCSTS41:1;                                    /* TMTCSTS41        */
    uint8  TMTCSTS42:1;                                    /* TMTCSTS42        */
    uint8  TMTCSTS43:1;                                    /* TMTCSTS43        */
    uint8  TMTCSTS44:1;                                    /* TMTCSTS44        */
    uint8  TMTCSTS45:1;                                    /* TMTCSTS45        */
    uint8  TMTCSTS46:1;                                    /* TMTCSTS46        */
    uint8  TMTCSTS47:1;                                    /* TMTCSTS47        */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type1021;
typedef struct 
{                                                          /* Bit Access       */
    uint8  TMTASTS0:1;                                     /* TMTASTS0         */
    uint8  TMTASTS1:1;                                     /* TMTASTS1         */
    uint8  TMTASTS2:1;                                     /* TMTASTS2         */
    uint8  TMTASTS3:1;                                     /* TMTASTS3         */
    uint8  TMTASTS4:1;                                     /* TMTASTS4         */
    uint8  TMTASTS5:1;                                     /* TMTASTS5         */
    uint8  TMTASTS6:1;                                     /* TMTASTS6         */
    uint8  TMTASTS7:1;                                     /* TMTASTS7         */
    uint8  TMTASTS8:1;                                     /* TMTASTS8         */
    uint8  TMTASTS9:1;                                     /* TMTASTS9         */
    uint8  TMTASTS10:1;                                    /* TMTASTS10        */
    uint8  TMTASTS11:1;                                    /* TMTASTS11        */
    uint8  TMTASTS12:1;                                    /* TMTASTS12        */
    uint8  TMTASTS13:1;                                    /* TMTASTS13        */
    uint8  TMTASTS14:1;                                    /* TMTASTS14        */
    uint8  TMTASTS15:1;                                    /* TMTASTS15        */
    uint8  TMTASTS16:1;                                    /* TMTASTS16        */
    uint8  TMTASTS17:1;                                    /* TMTASTS17        */
    uint8  TMTASTS18:1;                                    /* TMTASTS18        */
    uint8  TMTASTS19:1;                                    /* TMTASTS19        */
    uint8  TMTASTS20:1;                                    /* TMTASTS20        */
    uint8  TMTASTS21:1;                                    /* TMTASTS21        */
    uint8  TMTASTS22:1;                                    /* TMTASTS22        */
    uint8  TMTASTS23:1;                                    /* TMTASTS23        */
    uint8  TMTASTS24:1;                                    /* TMTASTS24        */
    uint8  TMTASTS25:1;                                    /* TMTASTS25        */
    uint8  TMTASTS26:1;                                    /* TMTASTS26        */
    uint8  TMTASTS27:1;                                    /* TMTASTS27        */
    uint8  TMTASTS28:1;                                    /* TMTASTS28        */
    uint8  TMTASTS29:1;                                    /* TMTASTS29        */
    uint8  TMTASTS30:1;                                    /* TMTASTS30        */
    uint8  TMTASTS31:1;                                    /* TMTASTS31        */
} __type1022;
typedef struct 
{                                                          /* Bit Access       */
    uint8  TMTASTS32:1;                                    /* TMTASTS32        */
    uint8  TMTASTS33:1;                                    /* TMTASTS33        */
    uint8  TMTASTS34:1;                                    /* TMTASTS34        */
    uint8  TMTASTS35:1;                                    /* TMTASTS35        */
    uint8  TMTASTS36:1;                                    /* TMTASTS36        */
    uint8  TMTASTS37:1;                                    /* TMTASTS37        */
    uint8  TMTASTS38:1;                                    /* TMTASTS38        */
    uint8  TMTASTS39:1;                                    /* TMTASTS39        */
    uint8  TMTASTS40:1;                                    /* TMTASTS40        */
    uint8  TMTASTS41:1;                                    /* TMTASTS41        */
    uint8  TMTASTS42:1;                                    /* TMTASTS42        */
    uint8  TMTASTS43:1;                                    /* TMTASTS43        */
    uint8  TMTASTS44:1;                                    /* TMTASTS44        */
    uint8  TMTASTS45:1;                                    /* TMTASTS45        */
    uint8  TMTASTS46:1;                                    /* TMTASTS46        */
    uint8  TMTASTS47:1;                                    /* TMTASTS47        */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type1023;
typedef struct 
{                                                          /* Bit Access       */
    uint8  TMIE0:1;                                        /* TMIE0            */
    uint8  TMIE1:1;                                        /* TMIE1            */
    uint8  TMIE2:1;                                        /* TMIE2            */
    uint8  TMIE3:1;                                        /* TMIE3            */
    uint8  TMIE4:1;                                        /* TMIE4            */
    uint8  TMIE5:1;                                        /* TMIE5            */
    uint8  TMIE6:1;                                        /* TMIE6            */
    uint8  TMIE7:1;                                        /* TMIE7            */
    uint8  TMIE8:1;                                        /* TMIE8            */
    uint8  TMIE9:1;                                        /* TMIE9            */
    uint8  TMIE10:1;                                       /* TMIE10           */
    uint8  TMIE11:1;                                       /* TMIE11           */
    uint8  TMIE12:1;                                       /* TMIE12           */
    uint8  TMIE13:1;                                       /* TMIE13           */
    uint8  TMIE14:1;                                       /* TMIE14           */
    uint8  TMIE15:1;                                       /* TMIE15           */
    uint8  TMIE16:1;                                       /* TMIE16           */
    uint8  TMIE17:1;                                       /* TMIE17           */
    uint8  TMIE18:1;                                       /* TMIE18           */
    uint8  TMIE19:1;                                       /* TMIE19           */
    uint8  TMIE20:1;                                       /* TMIE20           */
    uint8  TMIE21:1;                                       /* TMIE21           */
    uint8  TMIE22:1;                                       /* TMIE22           */
    uint8  TMIE23:1;                                       /* TMIE23           */
    uint8  TMIE24:1;                                       /* TMIE24           */
    uint8  TMIE25:1;                                       /* TMIE25           */
    uint8  TMIE26:1;                                       /* TMIE26           */
    uint8  TMIE27:1;                                       /* TMIE27           */
    uint8  TMIE28:1;                                       /* TMIE28           */
    uint8  TMIE29:1;                                       /* TMIE29           */
    uint8  TMIE30:1;                                       /* TMIE30           */
    uint8  TMIE31:1;                                       /* TMIE31           */
} __type1024;
typedef struct 
{                                                          /* Bit Access       */
    uint8  TMIE32:1;                                       /* TMIE32           */
    uint8  TMIE33:1;                                       /* TMIE33           */
    uint8  TMIE34:1;                                       /* TMIE34           */
    uint8  TMIE35:1;                                       /* TMIE35           */
    uint8  TMIE36:1;                                       /* TMIE36           */
    uint8  TMIE37:1;                                       /* TMIE37           */
    uint8  TMIE38:1;                                       /* TMIE38           */
    uint8  TMIE39:1;                                       /* TMIE39           */
    uint8  TMIE40:1;                                       /* TMIE40           */
    uint8  TMIE41:1;                                       /* TMIE41           */
    uint8  TMIE42:1;                                       /* TMIE42           */
    uint8  TMIE43:1;                                       /* TMIE43           */
    uint8  TMIE44:1;                                       /* TMIE44           */
    uint8  TMIE45:1;                                       /* TMIE45           */
    uint8  TMIE46:1;                                       /* TMIE46           */
    uint8  TMIE47:1;                                       /* TMIE47           */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type1025;
typedef struct 
{                                                          /* Bit Access       */
    uint8  TXQE:1;                                         /* TXQE             */
    uint8  :7;                                             /* Reserved Bits    */
    uint8  TXQDC:4;                                        /* TXQDC[11:8]      */
    uint8  TXQIE:1;                                        /* TXQIE            */
    uint8  TXQIM:1;                                        /* TXQIM            */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type1026;
typedef struct 
{                                                          /* Bit Access       */
    uint8  TXQEMP:1;                                       /* TXQEMP           */
    uint8  TXQFLL:1;                                       /* TXQFLL           */
    uint8  TXQIF:1;                                        /* TXQIF            */
    uint8  :5;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type1027;
typedef struct 
{                                                          /* Bit Access       */
    uint8  TXQPC:8;                                        /* TXQPC[7:0]       */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type1028;
typedef struct 
{                                                          /* Bit Access       */
    uint8  THLE:1;                                         /* THLE             */
    uint8  :7;                                             /* Reserved Bits    */
    uint8  THLIE:1;                                        /* THLIE            */
    uint8  THLIM:1;                                        /* THLIM            */
    uint8  THLDTE:1;                                       /* THLDTE           */
    uint8  :5;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type1029;
typedef struct 
{                                                          /* Bit Access       */
    uint8  THLEMP:1;                                       /* THLEMP           */
    uint8  THLFLL:1;                                       /* THLFLL           */
    uint8  THLELT:1;                                       /* THLELT           */
    uint8  THLIF:1;                                        /* THLIF            */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  THLMC:5;                                        /* THLMC[12:8]      */
    uint8  :3;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type1030;
typedef struct 
{                                                          /* Bit Access       */
    uint8  THLPC:8;                                        /* THLPC[7:0]       */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type1031;
typedef struct 
{                                                          /* Bit Access       */
    uint8  TSIF0:1;                                        /* TSIF0            */
    uint8  TAIF0:1;                                        /* TAIF0            */
    uint8  TQIF0:1;                                        /* TQIF0            */
    uint8  CFTIF0:1;                                       /* CFTIF0           */
    uint8  THIF0:1;                                        /* THIF0            */
    uint8  :3;                                             /* Reserved Bits    */
    uint8  TSIF1:1;                                        /* TSIF1            */
    uint8  TAIF1:1;                                        /* TAIF1            */
    uint8  TQIF1:1;                                        /* TQIF1            */
    uint8  CFTIF1:1;                                       /* CFTIF1           */
    uint8  THIF1:1;                                        /* THIF1            */
    uint8  :3;                                             /* Reserved Bits    */
    uint8  TSIF2:1;                                        /* TSIF2            */
    uint8  TAIF2:1;                                        /* TAIF2            */
    uint8  TQIF2:1;                                        /* TQIF2            */
    uint8  CFTIF2:1;                                       /* CFTIF2           */
    uint8  THIF2:1;                                        /* THIF2            */
    uint8  :3;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type1032;
typedef struct 
{                                                          /* Bit Access       */
    uint8  C0ICBCE:1;                                      /* C0ICBCE          */
    uint8  C1ICBCE:1;                                      /* C1ICBCE          */
    uint8  C2ICBCE:1;                                      /* C2ICBCE          */
    uint8  :5;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  RTMPS:7;                                        /* RTMPS[22:16]     */
    uint8  :1;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type1033;
typedef struct 
{                                                          /* Bit Access       */
    uint8  ICBCTME:1;                                      /* ICBCTME          */
    uint8  :1;                                             /* Reserved Bits    */
    uint8  RTME:1;                                         /* RTME             */
    uint8  :5;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type1034;
typedef struct 
{                                                          /* Bit Access       */
    uint16 LOCK:16;                                        /* LOCK[15:0]       */
    uint16 :16;                                            /* Reserved Bits    */
} __type1035;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAFLID:29;                                      /* GAFLID[28:0]     */
    uint8  GAFLLB:1;                                       /* GAFLLB           */
    uint8  GAFLRTR:1;                                      /* GAFLRTR          */
    uint8  GAFLIDE:1;                                      /* GAFLIDE          */
} __type1036;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAFLIDM:29;                                     /* GAFLIDM[28:0]    */
    uint8  :1;                                             /* Reserved Bits    */
    uint8  GAFLRTRM:1;                                     /* GAFLRTRM         */
    uint8  GAFLIDEM:1;                                     /* GAFLIDEM         */
} __type1037;
typedef struct 
{                                                          /* Bit Access       */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  GAFLRMDP:7;                                     /* GAFLRMDP[14:8]   */
    uint8  GAFLRMV:1;                                      /* GAFLRMV          */
    uint16 GAFLPTR:12;                                     /* GAFLPTR[27:16]   */
    uint8  GAFLDLC:4;                                      /* GAFLDLC[31:28]   */
} __type1038;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GAFLFDP:26;                                     /* GAFLFDP[25:0]    */
    uint8  :6;                                             /* Reserved Bits    */
} __type1039;
typedef struct 
{                                                          /* Bit Access       */
    uint32 RMID:29;                                        /* RMID[28:0]       */
    uint8  :1;                                             /* Reserved Bits    */
    uint8  RMRTR:1;                                        /* RMRTR            */
    uint8  RMIDE:1;                                        /* RMIDE            */
} __type1040;
typedef struct 
{                                                          /* Bit Access       */
    uint16 RMTS:16;                                        /* RMTS[15:0]       */
    uint16 RMPTR:12;                                       /* RMPTR[27:16]     */
    uint8  RMDLC:4;                                        /* RMDLC[31:28]     */
} __type1041;
typedef struct 
{                                                          /* Bit Access       */
    uint8  RMDB0:8;                                        /* RMDB0[7:0]       */
    uint8  RMDB1:8;                                        /* RMDB1[15:8]      */
    uint8  RMDB2:8;                                        /* RMDB2[23:16]     */
    uint8  RMDB3:8;                                        /* RMDB3[31:24]     */
} __type1042;
typedef struct 
{                                                          /* Bit Access       */
    uint8  RMDB4:8;                                        /* RMDB4[7:0]       */
    uint8  RMDB5:8;                                        /* RMDB5[15:8]      */
    uint8  RMDB6:8;                                        /* RMDB6[23:16]     */
    uint8  RMDB7:8;                                        /* RMDB7[31:24]     */
} __type1043;
typedef struct 
{                                                          /* Bit Access       */
    uint32 RFID:29;                                        /* RFID[28:0]       */
    uint8  :1;                                             /* Reserved Bits    */
    uint8  RFRTR:1;                                        /* RFRTR            */
    uint8  RFIDE:1;                                        /* RFIDE            */
} __type1044;
typedef struct 
{                                                          /* Bit Access       */
    uint16 RFTS:16;                                        /* RFTS[15:0]       */
    uint16 RFPTR:12;                                       /* RFPTR[27:16]     */
    uint8  RFDLC:4;                                        /* RFDLC[31:28]     */
} __type1045;
typedef struct 
{                                                          /* Bit Access       */
    uint8  RFDB0:8;                                        /* RFDB0[7:0]       */
    uint8  RFDB1:8;                                        /* RFDB1[15:8]      */
    uint8  RFDB2:8;                                        /* RFDB2[23:16]     */
    uint8  RFDB3:8;                                        /* RFDB3[31:24]     */
} __type1046;
typedef struct 
{                                                          /* Bit Access       */
    uint8  RFDB4:8;                                        /* RFDB4[7:0]       */
    uint8  RFDB5:8;                                        /* RFDB5[15:8]      */
    uint8  RFDB6:8;                                        /* RFDB6[23:16]     */
    uint8  RFDB7:8;                                        /* RFDB7[31:24]     */
} __type1047;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CFID:29;                                        /* CFID[28:0]       */
    uint8  THLEN:1;                                        /* THLEN            */
    uint8  CFRTR:1;                                        /* CFRTR            */
    uint8  CFIDE:1;                                        /* CFIDE            */
} __type1048;
typedef struct 
{                                                          /* Bit Access       */
    uint16 CFTS:16;                                        /* CFTS[15:0]       */
    uint16 CFPTR:12;                                       /* CFPTR[27:16]     */
    uint8  CFDLC:4;                                        /* CFDLC[31:28]     */
} __type1049;
typedef struct 
{                                                          /* Bit Access       */
    uint8  CFDB0:8;                                        /* CFDB0[7:0]       */
    uint8  CFDB1:8;                                        /* CFDB1[15:8]      */
    uint8  CFDB2:8;                                        /* CFDB2[23:16]     */
    uint8  CFDB3:8;                                        /* CFDB3[31:24]     */
} __type1050;
typedef struct 
{                                                          /* Bit Access       */
    uint8  CFDB4:8;                                        /* CFDB4[7:0]       */
    uint8  CFDB5:8;                                        /* CFDB5[15:8]      */
    uint8  CFDB6:8;                                        /* CFDB6[23:16]     */
    uint8  CFDB7:8;                                        /* CFDB7[31:24]     */
} __type1051;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TMID:29;                                        /* TMID[28:0]       */
    uint8  THLEN:1;                                        /* THLEN            */
    uint8  TMRTR:1;                                        /* TMRTR            */
    uint8  TMIDE:1;                                        /* TMIDE            */
} __type1052;
typedef struct 
{                                                          /* Bit Access       */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  TMPTR:8;                                        /* TMPTR[23:16]     */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  TMDLC:4;                                        /* TMDLC[31:28]     */
} __type1053;
typedef struct 
{                                                          /* Bit Access       */
    uint8  TMDB0:8;                                        /* TMDB0[7:0]       */
    uint8  TMDB1:8;                                        /* TMDB1[15:8]      */
    uint8  TMDB2:8;                                        /* TMDB2[23:16]     */
    uint8  TMDB3:8;                                        /* TMDB3[31:24]     */
} __type1054;
typedef struct 
{                                                          /* Bit Access       */
    uint8  TMDB4:8;                                        /* TMDB4[7:0]       */
    uint8  TMDB5:8;                                        /* TMDB5[15:8]      */
    uint8  TMDB6:8;                                        /* TMDB6[23:16]     */
    uint8  TMDB7:8;                                        /* TMDB7[31:24]     */
} __type1055;
typedef struct 
{                                                          /* Bit Access       */
    uint8  BT:3;                                           /* BT[2:0]          */
    uint8  BN:4;                                           /* BN[6:3]          */
    uint8  :1;                                             /* Reserved Bits    */
    uint8  TID:8;                                          /* TID[15:8]        */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type1056;
typedef struct 
{                                                          /* Bit Access       */
    uint32 RDTA:32;                                        /* RDTA[31:0]       */
} __type1057;
typedef struct 
{                                                          /* Bit Access       */
    uint8  :5;                                             /* Reserved Bits    */
    uint8  RXE:1;                                          /* RXE              */
    uint8  TXE:1;                                          /* TXE              */
    uint8  PWR:1;                                          /* PWR              */
} __type1058;
typedef struct 
{                                                          /* Bit Access       */
    uint32 OVE:1;                                          /* OVE              */
    uint32 PE:1;                                           /* PE               */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 DCE:1;                                          /* DCE              */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 TSF:1;                                          /* TSF              */
    uint32 :24;                                            /* Reserved Bits    */
} __type1059;
typedef struct 
{                                                          /* Bit Access       */
    uint16 OVEC:1;                                         /* OVEC             */
    uint16 PEC:1;                                          /* PEC              */
    uint16 :1;                                             /* Reserved Bits    */
    uint16 DCEC:1;                                         /* DCEC             */
    uint16 :12;                                            /* Reserved Bits    */
} __type1060;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SSE:1;                                          /* SSE              */
    uint32 HSE:1;                                          /* HSE              */
    uint32 SIT:1;                                          /* SIT              */
    uint32 LBM:1;                                          /* LBM              */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 DCS:1;                                          /* DCS              */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 EDLE:1;                                         /* EDLE             */
    uint32 :8;                                             /* Reserved Bits    */
    uint32 SLIT:1;                                         /* SLIT             */
    uint32 CKR:1;                                          /* CKR              */
    uint32 :14;                                            /* Reserved Bits    */
} __type1061;
typedef struct 
{                                                          /* Bit Access       */
    uint16 BRS:12;                                         /* BRS[11:0]        */
    uint16 :1;                                             /* Reserved Bits    */
    uint16 PRS:3;                                          /* PRS[15:13]       */
} __type1062;
typedef struct 
{                                                          /* Bit Access       */
    uint8  :7;                                             /* Reserved Bits    */
    uint8  SVSDIS:1;                                       /* SVSDIS           */
} __type1063;
typedef struct 
{                                                          /* Bit Access       */
    uint8  SCE:1;                                          /* SCE              */
    uint8  :7;                                             /* Reserved Bits    */
} __type1064;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TX:16;                                          /* TX[15:0]         */
    uint32 :13;                                            /* Reserved Bits    */
    uint32 EDL:1;                                          /* EDL              */
    uint32 :2;                                             /* Reserved Bits    */
} __type1065;
typedef struct 
{                                                          /* Bit Access       */
    uint16 TX:16;                                          /* TX[15:0]         */
} __type1066;
typedef struct 
{                                                          /* Bit Access       */
    uint16 RX:16;                                          /* RX[15:0]         */
} __type1067;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :16;                                            /* Reserved Bits    */
    uint32 DAP:1;                                          /* DAP              */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 DIR:1;                                          /* DIR              */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 DLS:4;                                          /* DLS[27:24]       */
    uint32 PS:2;                                           /* PS[29:28]        */
    uint32 :2;                                             /* Reserved Bits    */
} __type1068;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SSE:1;                                          /* SSE              */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 SIT:1;                                          /* SIT              */
    uint32 LBM:1;                                          /* LBM              */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 DCS:1;                                          /* DCS              */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 EDLE:1;                                         /* EDLE             */
    uint32 :8;                                             /* Reserved Bits    */
    uint32 SLIT:1;                                         /* SLIT             */
    uint32 CKR:1;                                          /* CKR              */
    uint32 :14;                                            /* Reserved Bits    */
} __type1069;
typedef struct 
{                                                          /* Bit Access       */
    uint8  MBS:1;                                          /* MBS              */
    uint8  JOBE:1;                                         /* JOBE             */
    uint8  :3;                                             /* Reserved Bits    */
    uint8  RXE:1;                                          /* RXE              */
    uint8  TXE:1;                                          /* TXE              */
    uint8  PWR:1;                                          /* PWR              */
} __type1070;
typedef struct 
{                                                          /* Bit Access       */
    uint32 OVE:1;                                          /* OVE              */
    uint32 PE:1;                                           /* PE               */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 DCE:1;                                          /* DCE              */
    uint32 EMF:1;                                          /* EMF              */
    uint32 FLF:1;                                          /* FLF              */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 TSF:1;                                          /* TSF              */
    uint32 HPST:1;                                         /* HPST             */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 OFE:1;                                          /* OFE              */
    uint32 TMOE:1;                                         /* TMOE             */
    uint32 SPF:8;                                          /* SPF[23:16]       */
    uint32 SRP:8;                                          /* SRP[31:24]       */
} __type1071;
typedef struct 
{                                                          /* Bit Access       */
    uint16 OVEC:1;                                         /* OVEC             */
    uint16 PEC:1;                                          /* PEC              */
    uint16 :1;                                             /* Reserved Bits    */
    uint16 DCEC:1;                                         /* DCEC             */
    uint16 :4;                                             /* Reserved Bits    */
    uint16 PCT:1;                                          /* PCT              */
    uint16 :5;                                             /* Reserved Bits    */
    uint16 OFEC:1;                                         /* OFEC             */
    uint16 TMOEC:1;                                        /* TMOEC            */
} __type1072;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SSE:1;                                          /* SSE              */
    uint32 HSE:1;                                          /* HSE              */
    uint32 SIT:1;                                          /* SIT              */
    uint32 LBM:1;                                          /* LBM              */
    uint32 CSRI:1;                                         /* CSRI             */
    uint32 DCS:1;                                          /* DCS              */
    uint32 JE:1;                                           /* JE               */
    uint32 EDLE:1;                                         /* EDLE             */
    uint32 CSL0:1;                                         /* CSL0             */
    uint32 CSL1:1;                                         /* CSL1             */
    uint32 CSL2:1;                                         /* CSL2             */
    uint32 CSL3:1;                                         /* CSL3             */
    uint32 CSL4:1;                                         /* CSL4             */
    uint32 CSL5:1;                                         /* CSL5             */
    uint32 CSL6:1;                                         /* CSL6             */
    uint32 CSL7:1;                                         /* CSL7             */
    uint32 SLIT:1;                                         /* SLIT             */
    uint32 CKR:1;                                          /* CKR              */
    uint32 PHE:1;                                          /* PHE              */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 SLRS:1;                                         /* SLRS             */
    uint32 :7;                                             /* Reserved Bits    */
} __type1073;
typedef struct 
{                                                          /* Bit Access       */
    uint16 :13;                                            /* Reserved Bits    */
    uint16 PRS:3;                                          /* PRS[15:13]       */
} __type1074;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FFS:7;                                          /* FFS[6:0]         */
    uint32 :9;                                             /* Reserved Bits    */
    uint32 FES:7;                                          /* FES[22:16]       */
    uint32 :9;                                             /* Reserved Bits    */
} __type1075;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SOP:7;                                          /* SOP[6:0]         */
    uint32 :9;                                             /* Reserved Bits    */
    uint32 ND:8;                                           /* ND[23:16]        */
    uint32 :7;                                             /* Reserved Bits    */
    uint32 BTST:1;                                         /* BTST             */
} __type1076;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TX:16;                                          /* TX[15:0]         */
    uint32 CS0:1;                                          /* CS0              */
    uint32 CS1:1;                                          /* CS1              */
    uint32 CS2:1;                                          /* CS2              */
    uint32 CS3:1;                                          /* CS3              */
    uint32 CS4:1;                                          /* CS4              */
    uint32 CS5:1;                                          /* CS5              */
    uint32 CS6:1;                                          /* CS6              */
    uint32 CS7:1;                                          /* CS7              */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 EDL:1;                                          /* EDL              */
    uint32 EOJ:1;                                          /* EOJ              */
    uint32 CIRE:1;                                         /* CIRE             */
} __type1077;
typedef struct 
{                                                          /* Bit Access       */
    uint32 RX:16;                                          /* RX[15:0]         */
    uint32 CS0:1;                                          /* CS0              */
    uint32 :7;                                             /* Reserved Bits    */
    uint32 TDCE:1;                                         /* TDCE             */
    uint32 RPE:1;                                          /* RPE              */
    uint32 :6;                                             /* Reserved Bits    */
} __type1078;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TRWA:7;                                         /* TRWA[6:0]        */
    uint32 :9;                                             /* Reserved Bits    */
    uint32 RRA:7;                                          /* RRA[22:16]       */
    uint32 :9;                                             /* Reserved Bits    */
} __type1079;
typedef struct 
{                                                          /* Bit Access       */
    uint16 TO:5;                                           /* TO[4:0]          */
    uint16 :3;                                             /* Reserved Bits    */
    uint16 MMS:2;                                          /* MMS[9:8]         */
    uint16 :6;                                             /* Reserved Bits    */
} __type1080;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SP0:4;                                          /* SP0[3:0]         */
    uint32 IN0:4;                                          /* IN0[7:4]         */
    uint32 HD0:4;                                          /* HD0[11:8]        */
    uint32 ID0:3;                                          /* ID0[14:12]       */
    uint32 IDL0:1;                                         /* IDL0             */
    uint32 DAP0:1;                                         /* DAP0             */
    uint32 CKP0:1;                                         /* CKP0             */
    uint32 DIR0:1;                                         /* DIR0             */
    uint32 RCB0:1;                                         /* RCB0             */
    uint32 :4;                                             /* Reserved Bits    */
    uint32 DLS0:4;                                         /* DLS0[27:24]      */
    uint32 PS0:2;                                          /* PS0[29:28]       */
    uint32 BRSS0:2;                                        /* BRSS0[31:30]     */
} __type1081;
typedef struct 
{                                                          /* Bit Access       */
    uint16 BRS:12;                                         /* BRS[11:0]        */
    uint16 :4;                                             /* Reserved Bits    */
} __type1082;
typedef struct 
{                                                          /* Bit Access       */
    uint32 OVE:1;                                          /* OVE              */
    uint32 PE:1;                                           /* PE               */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 DCE:1;                                          /* DCE              */
    uint32 EMF:1;                                          /* EMF              */
    uint32 FLF:1;                                          /* FLF              */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 TSF:1;                                          /* TSF              */
    uint32 :6;                                             /* Reserved Bits    */
    uint32 OFE:1;                                          /* OFE              */
    uint32 TMOE:1;                                         /* TMOE             */
    uint32 SPF:8;                                          /* SPF[23:16]       */
    uint32 SRP:8;                                          /* SRP[31:24]       */
} __type1083;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SSE:1;                                          /* SSE              */
    uint32 HSE:1;                                          /* HSE              */
    uint32 SIT:1;                                          /* SIT              */
    uint32 LBM:1;                                          /* LBM              */
    uint32 CSRI:1;                                         /* CSRI             */
    uint32 DCS:1;                                          /* DCS              */
    uint32 JE:1;                                           /* JE               */
    uint32 EDLE:1;                                         /* EDLE             */
    uint32 CSL0:1;                                         /* CSL0             */
    uint32 CSL1:1;                                         /* CSL1             */
    uint32 CSL2:1;                                         /* CSL2             */
    uint32 CSL3:1;                                         /* CSL3             */
    uint32 CSL4:1;                                         /* CSL4             */
    uint32 CSL5:1;                                         /* CSL5             */
    uint32 CSL6:1;                                         /* CSL6             */
    uint32 CSL7:1;                                         /* CSL7             */
    uint32 SLIT:1;                                         /* SLIT             */
    uint32 CKR:1;                                          /* CKR              */
    uint32 :14;                                            /* Reserved Bits    */
} __type1084;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SP0:4;                                          /* SP0[3:0]         */
    uint32 IN0:4;                                          /* IN0[7:4]         */
    uint32 HD0:4;                                          /* HD0[11:8]        */
    uint32 ID0:3;                                          /* ID0[14:12]       */
    uint32 IDL0:1;                                         /* IDL0             */
    uint32 DAP0:1;                                         /* DAP0             */
    uint32 CKP0:1;                                         /* CKP0             */
    uint32 DIR0:1;                                         /* DIR0             */
    uint32 RCB0:1;                                         /* RCB0             */
    uint32 :4;                                             /* Reserved Bits    */
    uint32 DLS0:4;                                         /* DLS0[27:24]      */
    uint32 PS0:2;                                          /* PS0[29:28]       */
    uint32 PSCL0:2;                                        /* PSCL0[31:30]     */
} __type1085;
typedef struct 
{                                                          /* Bit Access       */
    uint8  SDAI:1;                                         /* SDAI             */
    uint8  SCLI:1;                                         /* SCLI             */
    uint8  SDAO:1;                                         /* SDAO             */
    uint8  SCLO:1;                                         /* SCLO             */
    uint8  SOWP:1;                                         /* SOWP             */
    uint8  CLO:1;                                          /* CLO              */
    uint8  IICRST:1;                                       /* IICRST           */
    uint8  ICE:1;                                          /* ICE              */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type1086;
typedef struct 
{                                                          /* Bit Access       */
    uint8  :1;                                             /* Reserved Bits    */
    uint8  ST:1;                                           /* ST               */
    uint8  RS:1;                                           /* RS               */
    uint8  SP:1;                                           /* SP               */
    uint8  :1;                                             /* Reserved Bits    */
    uint8  TRS:1;                                          /* TRS              */
    uint8  MST:1;                                          /* MST              */
    uint8  BBSY:1;                                         /* BBSY             */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type1087;
typedef struct 
{                                                          /* Bit Access       */
    uint8  BC:3;                                           /* BC[2:0]          */
    uint8  BCWP:1;                                         /* BCWP             */
    uint8  CKS:3;                                          /* CKS[6:4]         */
    uint8  MTWP:1;                                         /* MTWP             */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type1088;
typedef struct 
{                                                          /* Bit Access       */
    uint8  TMOS:1;                                         /* TMOS             */
    uint8  TMOL:1;                                         /* TMOL             */
    uint8  TMOH:1;                                         /* TMOH             */
    uint8  :1;                                             /* Reserved Bits    */
    uint8  SDDL:3;                                         /* SDDL[6:4]        */
    uint8  DLCS:1;                                         /* DLCS             */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type1089;
typedef struct 
{                                                          /* Bit Access       */
    uint8  NF:2;                                           /* NF[1:0]          */
    uint8  ACKBR:1;                                        /* ACKBR            */
    uint8  ACKBT:1;                                        /* ACKBT            */
    uint8  ACKWP:1;                                        /* ACKWP            */
    uint8  RDRFS:1;                                        /* RDRFS            */
    uint8  WAIT:1;                                         /* WAIT             */
    uint8  :1;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type1090;
typedef struct 
{                                                          /* Bit Access       */
    uint8  TMOE:1;                                         /* TMOE             */
    uint8  MALE:1;                                         /* MALE             */
    uint8  NALE:1;                                         /* NALE             */
    uint8  SALE:1;                                         /* SALE             */
    uint8  NACKE:1;                                        /* NACKE            */
    uint8  NFE:1;                                          /* NFE              */
    uint8  SCLE:1;                                         /* SCLE             */
    uint8  :1;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type1091;
typedef struct 
{                                                          /* Bit Access       */
    uint8  SAR0:1;                                         /* SAR0             */
    uint8  SAR1:1;                                         /* SAR1             */
    uint8  SAR2:1;                                         /* SAR2             */
    uint8  GCE:1;                                          /* GCE              */
    uint8  :1;                                             /* Reserved Bits    */
    uint8  DIDE:1;                                         /* DIDE             */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type1092;
typedef struct 
{                                                          /* Bit Access       */
    uint8  TMOIE:1;                                        /* TMOIE            */
    uint8  ALIE:1;                                         /* ALIE             */
    uint8  STIE:1;                                         /* STIE             */
    uint8  SPIE:1;                                         /* SPIE             */
    uint8  NAKIE:1;                                        /* NAKIE            */
    uint8  RIE:1;                                          /* RIE              */
    uint8  TEIE:1;                                         /* TEIE             */
    uint8  TIE:1;                                          /* TIE              */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type1093;
typedef struct 
{                                                          /* Bit Access       */
    uint8  AAS0:1;                                         /* AAS0             */
    uint8  AAS1:1;                                         /* AAS1             */
    uint8  AAS2:1;                                         /* AAS2             */
    uint8  GCA:1;                                          /* GCA              */
    uint8  :1;                                             /* Reserved Bits    */
    uint8  DID:1;                                          /* DID              */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type1094;
typedef struct 
{                                                          /* Bit Access       */
    uint8  TMOF:1;                                         /* TMOF             */
    uint8  AL:1;                                           /* AL               */
    uint8  START:1;                                        /* START            */
    uint8  STOP:1;                                         /* STOP             */
    uint8  NACKF:1;                                        /* NACKF            */
    uint8  RDRF:1;                                         /* RDRF             */
    uint8  TEND:1;                                         /* TEND             */
    uint8  TDRE:1;                                         /* TDRE             */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type1095;
typedef struct 
{                                                          /* Bit Access       */
    uint8  SVA0:1;                                         /* SVA0             */
    uint16 SVA:9;                                          /* SVA[9:1]         */
    uint8  :5;                                             /* Reserved Bits    */
    uint8  FS0:1;                                          /* FS0              */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type1096;
typedef struct 
{                                                          /* Bit Access       */
    uint8  SVA0:1;                                         /* SVA0             */
    uint16 SVA:9;                                          /* SVA[9:1]         */
    uint8  :5;                                             /* Reserved Bits    */
    uint8  FS1:1;                                          /* FS1              */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type1097;
typedef struct 
{                                                          /* Bit Access       */
    uint8  SVA0:1;                                         /* SVA0             */
    uint16 SVA:9;                                          /* SVA[9:1]         */
    uint8  :5;                                             /* Reserved Bits    */
    uint8  FS2:1;                                          /* FS2              */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type1098;
typedef struct 
{                                                          /* Bit Access       */
    uint8  BRL:5;                                          /* BRL[4:0]         */
    uint8  :3;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type1099;
typedef struct 
{                                                          /* Bit Access       */
    uint8  BRH:5;                                          /* BRH[4:0]         */
    uint8  :3;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type1100;
typedef struct 
{                                                          /* Bit Access       */
    uint8  DRT:8;                                          /* DRT[7:0]         */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type1101;
typedef struct 
{                                                          /* Bit Access       */
    uint8  DRR:8;                                          /* DRR[7:0]         */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type1102;
typedef struct 
{                                                          /* Bit Access       */
    uint8  OPC:2;                                          /* OPC[1:0]         */
    uint8  :6;                                             /* Reserved Bits    */
    uint8  DTSR:1;                                         /* DTSR             */
    uint8  :7;                                             /* Reserved Bits    */
    uint8  CSEL:2;                                         /* CSEL[17:16]      */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  BOC:1;                                          /* BOC              */
    uint8  :3;                                             /* Reserved Bits    */
    uint8  LBME:1;                                         /* LBME             */
    uint8  FCE:1;                                          /* FCE              */
    uint8  :6;                                             /* Reserved Bits    */
} __type1103;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TA:32;                                          /* TA[31:0]         */
} __type1104;
typedef struct 
{                                                          /* Bit Access       */
    uint32 LBA0:1;                                         /* LBA0             */
    uint32 LBA1:1;                                         /* LBA1             */
    uint32 LBA2:1;                                         /* LBA2             */
    uint32 LBA3:1;                                         /* LBA3             */
    uint32 LBA4:1;                                         /* LBA4             */
    uint32 LBA5:1;                                         /* LBA5             */
    uint32 LBA6:1;                                         /* LBA6             */
    uint32 LBA7:1;                                         /* LBA7             */
    uint32 LBA8:1;                                         /* LBA8             */
    uint32 LBA9:1;                                         /* LBA9             */
    uint32 LBA10:1;                                        /* LBA10            */
    uint32 LBA11:1;                                        /* LBA11            */
    uint32 LBA12:1;                                        /* LBA12            */
    uint32 LBA13:1;                                        /* LBA13            */
    uint32 LBA14:1;                                        /* LBA14            */
    uint32 LBA15:1;                                        /* LBA15            */
    uint32 LBA16:1;                                        /* LBA16            */
    uint32 LBA17:1;                                        /* LBA17            */
    uint32 LBA18:1;                                        /* LBA18            */
    uint32 LBA19:1;                                        /* LBA19            */
    uint32 LBA20:1;                                        /* LBA20            */
    uint32 LBA21:1;                                        /* LBA21            */
    uint32 :10;                                            /* Reserved Bits    */
} __type1105;
typedef struct 
{                                                          /* Bit Access       */
    uint32 OPS:4;                                          /* OPS[3:0]         */
    uint32 :4;                                             /* Reserved Bits    */
    uint32 DTS:1;                                          /* DTS              */
    uint32 :7;                                             /* Reserved Bits    */
    uint32 TPO0:1;                                         /* TPO0             */
    uint32 TPO1:1;                                         /* TPO1             */
    uint32 TPO2:1;                                         /* TPO2             */
    uint32 TPO3:1;                                         /* TPO3             */
    uint32 RPO:1;                                          /* RPO              */
    uint32 :11;                                            /* Reserved Bits    */
} __type1106;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CDA:32;                                         /* CDA[31:0]        */
} __type1107;
typedef struct 
{                                                          /* Bit Access       */
    uint32 EQN:5;                                          /* EQN[4:0]         */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 ET:4;                                           /* ET[11:8]         */
    uint32 EIL:1;                                          /* EIL              */
    uint32 :19;                                            /* Reserved Bits    */
} __type1108;
typedef struct 
{                                                          /* Bit Access       */
    uint32 EFFS:1;                                         /* EFFS             */
    uint32 ENCF:1;                                         /* ENCF             */
    uint32 ESF:2;                                          /* ESF[3:2]         */
    uint32 ETS0:1;                                         /* ETS0             */
    uint32 ETS2:1;                                         /* ETS2             */
    uint32 :10;                                            /* Reserved Bits    */
    uint32 RFCL:13;                                        /* RFCL[28:16]      */
    uint32 :3;                                             /* Reserved Bits    */
} __type1109;
typedef struct 
{                                                          /* Bit Access       */
    uint8  RSM0:2;                                         /* RSM0[1:0]        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  UFCC0:2;                                        /* UFCC0[5:4]       */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  RSM1:2;                                         /* RSM1[9:8]        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  UFCC1:2;                                        /* UFCC1[13:12]     */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  RSM2:2;                                         /* RSM2[17:16]      */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  UFCC2:2;                                        /* UFCC2[21:20]     */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  RSM3:2;                                         /* RSM3[25:24]      */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  UFCC3:2;                                        /* UFCC3[29:28]     */
    uint8  :2;                                             /* Reserved Bits    */
} __type1110;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :8;                                             /* Reserved Bits    */
    uint32 PCNT:3;                                         /* PCNT[10:8]       */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 DCNT:8;                                         /* DCNT[23:16]      */
    uint32 :8;                                             /* Reserved Bits    */
} __type1111;
typedef struct 
{                                                          /* Bit Access       */
    uint32 WL0:6;                                          /* WL0[5:0]         */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 WL1:6;                                          /* WL1[13:8]        */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 WL2:6;                                          /* WL2[21:16]       */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 WL3:6;                                          /* WL3[29:24]       */
    uint32 :2;                                             /* Reserved Bits    */
} __type1112;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SL0:6;                                          /* SL0[5:0]         */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 SL1:6;                                          /* SL1[13:8]        */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 SL2:6;                                          /* SL2[21:16]       */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 SL3:6;                                          /* SL3[29:24]       */
    uint32 :2;                                             /* Reserved Bits    */
} __type1113;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CV0:6;                                          /* CV0[5:0]         */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 CV1:6;                                          /* CV1[13:8]        */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 CV2:6;                                          /* CV2[21:16]       */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 CV3:6;                                          /* CV3[29:24]       */
    uint32 :2;                                             /* Reserved Bits    */
} __type1114;
typedef struct 
{                                                          /* Bit Access       */
    uint8  DV0:6;                                          /* DV0[5:0]         */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  DV1:6;                                          /* DV1[13:8]        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  DV2:6;                                          /* DV2[21:16]       */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  DV3:6;                                          /* DV3[29:24]       */
    uint8  :2;                                             /* Reserved Bits    */
} __type1115;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FBP:6;                                          /* FBP[5:0]         */
    uint32 :26;                                            /* Reserved Bits    */
} __type1116;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FP:32;                                          /* FP[31:0]         */
} __type1117;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CFM:32;                                         /* CFM[31:0]        */
} __type1118;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TSM0:1;                                         /* TSM0             */
    uint32 TSM1:1;                                         /* TSM1             */
    uint32 TSM2:1;                                         /* TSM2             */
    uint32 TSM3:1;                                         /* TSM3             */
    uint32 TQP:2;                                          /* TQP[5:4]         */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 TBD0:2;                                         /* TBD0[9:8]        */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 TBD1:2;                                         /* TBD1[13:12]      */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 TBD2:2;                                         /* TBD2[17:16]      */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 TBD3:2;                                         /* TBD3[21:20]      */
    uint32 :10;                                            /* Reserved Bits    */
} __type1119;
typedef struct 
{                                                          /* Bit Access       */
    uint8  TSRQ0:1;                                        /* TSRQ0            */
    uint8  TSRQ1:1;                                        /* TSRQ1            */
    uint8  TSRQ2:1;                                        /* TSRQ2            */
    uint8  TSRQ3:1;                                        /* TSRQ3            */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  TFEN:1;                                         /* TFEN             */
    uint8  TFR:1;                                          /* TFR              */
    uint8  :6;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type1120;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CCS0:2;                                         /* CCS0[1:0]        */
    uint32 CCS1:2;                                         /* CCS1[3:2]        */
    uint32 :4;                                             /* Reserved Bits    */
    uint32 TFFL:3;                                         /* TFFL[10:8]       */
    uint32 :21;                                            /* Reserved Bits    */
} __type1121;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TSV:32;                                         /* TSV[31:0]        */
} __type1122;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TSV:16;                                         /* TSV[15:0]        */
    uint32 TST:10;                                         /* TST[25:16]       */
    uint32 :6;                                             /* Reserved Bits    */
} __type1123;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CIV:32;                                         /* CIV[31:0]        */
} __type1124;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CDV:32;                                         /* CDV[31:0]        */
} __type1125;
typedef struct 
{                                                          /* Bit Access       */
    uint32 ULV:32;                                         /* ULV[31:0]        */
} __type1126;
typedef struct 
{                                                          /* Bit Access       */
    uint32 LLV:32;                                         /* LLV[31:0]        */
} __type1127;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 DPE1:1;                                         /* DPE1             */
    uint32 DPE2:1;                                         /* DPE2             */
    uint32 DPE3:1;                                         /* DPE3             */
    uint32 DPE4:1;                                         /* DPE4             */
    uint32 DPE5:1;                                         /* DPE5             */
    uint32 DPE6:1;                                         /* DPE6             */
    uint32 DPE7:1;                                         /* DPE7             */
    uint32 DPE8:1;                                         /* DPE8             */
    uint32 DPE9:1;                                         /* DPE9             */
    uint32 DPE10:1;                                        /* DPE10            */
    uint32 DPE11:1;                                        /* DPE11            */
    uint32 DPE12:1;                                        /* DPE12            */
    uint32 DPE13:1;                                        /* DPE13            */
    uint32 DPE14:1;                                        /* DPE14            */
    uint32 DPE15:1;                                        /* DPE15            */
    uint32 :16;                                            /* Reserved Bits    */
} __type1128;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 DPF1:1;                                         /* DPF1             */
    uint32 DPF2:1;                                         /* DPF2             */
    uint32 DPF3:1;                                         /* DPF3             */
    uint32 DPF4:1;                                         /* DPF4             */
    uint32 DPF5:1;                                         /* DPF5             */
    uint32 DPF6:1;                                         /* DPF6             */
    uint32 DPF7:1;                                         /* DPF7             */
    uint32 DPF8:1;                                         /* DPF8             */
    uint32 DPF9:1;                                         /* DPF9             */
    uint32 DPF10:1;                                        /* DPF10            */
    uint32 DPF11:1;                                        /* DPF11            */
    uint32 DPF12:1;                                        /* DPF12            */
    uint32 DPF13:1;                                        /* DPF13            */
    uint32 DPF14:1;                                        /* DPF14            */
    uint32 DPF15:1;                                        /* DPF15            */
    uint32 :16;                                            /* Reserved Bits    */
} __type1129;
typedef struct 
{                                                          /* Bit Access       */
    uint32 MREE:1;                                         /* MREE             */
    uint32 MTEE:1;                                         /* MTEE             */
    uint32 QEE:1;                                          /* QEE              */
    uint32 SEE:1;                                          /* SEE              */
    uint32 CLLE0:1;                                        /* CLLE0            */
    uint32 CLLE1:1;                                        /* CLLE1            */
    uint32 CULE0:1;                                        /* CULE0            */
    uint32 CULE1:1;                                        /* CULE1            */
    uint32 TFFE:1;                                         /* TFFE             */
    uint32 :23;                                            /* Reserved Bits    */
} __type1130;
typedef struct 
{                                                          /* Bit Access       */
    uint32 MREF:1;                                         /* MREF             */
    uint32 MTEF:1;                                         /* MTEF             */
    uint32 QEF:1;                                          /* QEF              */
    uint32 SEF:1;                                          /* SEF              */
    uint32 CLLF0:1;                                        /* CLLF0            */
    uint32 CLLF1:1;                                        /* CLLF1            */
    uint32 CULF0:1;                                        /* CULF0            */
    uint32 CULF1:1;                                        /* CULF1            */
    uint32 TFFF:1;                                         /* TFFF             */
    uint32 :7;                                             /* Reserved Bits    */
    uint32 QFS:1;                                          /* QFS              */
    uint32 :15;                                            /* Reserved Bits    */
} __type1131;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FRE0:1;                                         /* FRE0             */
    uint32 FRE1:1;                                         /* FRE1             */
    uint32 FRE2:1;                                         /* FRE2             */
    uint32 FRE3:1;                                         /* FRE3             */
    uint32 FRE4:1;                                         /* FRE4             */
    uint32 FRE5:1;                                         /* FRE5             */
    uint32 FRE6:1;                                         /* FRE6             */
    uint32 FRE7:1;                                         /* FRE7             */
    uint32 FRE8:1;                                         /* FRE8             */
    uint32 FRE9:1;                                         /* FRE9             */
    uint32 FRE10:1;                                        /* FRE10            */
    uint32 FRE11:1;                                        /* FRE11            */
    uint32 FRE12:1;                                        /* FRE12            */
    uint32 FRE13:1;                                        /* FRE13            */
    uint32 FRE14:1;                                        /* FRE14            */
    uint32 FRE15:1;                                        /* FRE15            */
    uint32 FRE16:1;                                        /* FRE16            */
    uint32 FRE17:1;                                        /* FRE17            */
    uint32 :14;                                            /* Reserved Bits    */
} __type1132;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FRF0:1;                                         /* FRF0             */
    uint32 FRF1:1;                                         /* FRF1             */
    uint32 FRF2:1;                                         /* FRF2             */
    uint32 FRF3:1;                                         /* FRF3             */
    uint32 FRF4:1;                                         /* FRF4             */
    uint32 FRF5:1;                                         /* FRF5             */
    uint32 FRF6:1;                                         /* FRF6             */
    uint32 FRF7:1;                                         /* FRF7             */
    uint32 FRF8:1;                                         /* FRF8             */
    uint32 FRF9:1;                                         /* FRF9             */
    uint32 FRF10:1;                                        /* FRF10            */
    uint32 FRF11:1;                                        /* FRF11            */
    uint32 FRF12:1;                                        /* FRF12            */
    uint32 FRF13:1;                                        /* FRF13            */
    uint32 FRF14:1;                                        /* FRF14            */
    uint32 FRF15:1;                                        /* FRF15            */
    uint32 FRF16:1;                                        /* FRF16            */
    uint32 FRF17:1;                                        /* FRF17            */
    uint32 :14;                                            /* Reserved Bits    */
} __type1133;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :31;                                            /* Reserved Bits    */
    uint32 RFWE:1;                                         /* RFWE             */
} __type1134;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :31;                                            /* Reserved Bits    */
    uint32 RFWF:1;                                         /* RFWF             */
} __type1135;
typedef struct 
{                                                          /* Bit Access       */
    uint32 QFE0:1;                                         /* QFE0             */
    uint32 QFE1:1;                                         /* QFE1             */
    uint32 QFE2:1;                                         /* QFE2             */
    uint32 QFE3:1;                                         /* QFE3             */
    uint32 QFE4:1;                                         /* QFE4             */
    uint32 QFE5:1;                                         /* QFE5             */
    uint32 QFE6:1;                                         /* QFE6             */
    uint32 QFE7:1;                                         /* QFE7             */
    uint32 QFE8:1;                                         /* QFE8             */
    uint32 QFE9:1;                                         /* QFE9             */
    uint32 QFE10:1;                                        /* QFE10            */
    uint32 QFE11:1;                                        /* QFE11            */
    uint32 QFE12:1;                                        /* QFE12            */
    uint32 QFE13:1;                                        /* QFE13            */
    uint32 QFE14:1;                                        /* QFE14            */
    uint32 QFE15:1;                                        /* QFE15            */
    uint32 QFE16:1;                                        /* QFE16            */
    uint32 QFE17:1;                                        /* QFE17            */
    uint32 :13;                                            /* Reserved Bits    */
    uint32 RFFE:1;                                         /* RFFE             */
} __type1136;
typedef struct 
{                                                          /* Bit Access       */
    uint32 QFF0:1;                                         /* QFF0             */
    uint32 QFF1:1;                                         /* QFF1             */
    uint32 QFF2:1;                                         /* QFF2             */
    uint32 QFF3:1;                                         /* QFF3             */
    uint32 QFF4:1;                                         /* QFF4             */
    uint32 QFF5:1;                                         /* QFF5             */
    uint32 QFF6:1;                                         /* QFF6             */
    uint32 QFF7:1;                                         /* QFF7             */
    uint32 QFF8:1;                                         /* QFF8             */
    uint32 QFF9:1;                                         /* QFF9             */
    uint32 QFF10:1;                                        /* QFF10            */
    uint32 QFF11:1;                                        /* QFF11            */
    uint32 QFF12:1;                                        /* QFF12            */
    uint32 QFF13:1;                                        /* QFF13            */
    uint32 QFF14:1;                                        /* QFF14            */
    uint32 QFF15:1;                                        /* QFF15            */
    uint32 QFF16:1;                                        /* QFF16            */
    uint32 QFF17:1;                                        /* QFF17            */
    uint32 :13;                                            /* Reserved Bits    */
    uint32 RFFF:1;                                         /* RFFF             */
} __type1137;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :8;                                             /* Reserved Bits    */
    uint32 TFUE:1;                                         /* TFUE             */
    uint32 TFWE:1;                                         /* TFWE             */
    uint32 :22;                                            /* Reserved Bits    */
} __type1138;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :8;                                             /* Reserved Bits    */
    uint32 TFUF:1;                                         /* TFUF             */
    uint32 TFWF:1;                                         /* TFWF             */
    uint32 :22;                                            /* Reserved Bits    */
} __type1139;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :6;                                             /* Reserved Bits    */
    uint32 ES:1;                                           /* ES               */
    uint32 MS:1;                                           /* MS               */
    uint32 TFUS:1;                                         /* TFUS             */
    uint32 TFWS:1;                                         /* TFWS             */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 RFWS:1;                                         /* RFWS             */
    uint32 CGIS:1;                                         /* CGIS             */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 DPS1:1;                                         /* DPS1             */
    uint32 DPS2:1;                                         /* DPS2             */
    uint32 DPS3:1;                                         /* DPS3             */
    uint32 DPS4:1;                                         /* DPS4             */
    uint32 DPS5:1;                                         /* DPS5             */
    uint32 DPS6:1;                                         /* DPS6             */
    uint32 DPS7:1;                                         /* DPS7             */
    uint32 DPS8:1;                                         /* DPS8             */
    uint32 DPS9:1;                                         /* DPS9             */
    uint32 DPS10:1;                                        /* DPS10            */
    uint32 DPS11:1;                                        /* DPS11            */
    uint32 DPS12:1;                                        /* DPS12            */
    uint32 DPS13:1;                                        /* DPS13            */
    uint32 DPS14:1;                                        /* DPS14            */
    uint32 DPS15:1;                                        /* DPS15            */
} __type1140;
typedef struct 
{                                                          /* Bit Access       */
    uint8  TCR:2;                                          /* TCR[1:0]         */
    uint8  LTO:1;                                          /* LTO              */
    uint8  LTI:1;                                          /* LTI              */
    uint8  LPTC:1;                                         /* LPTC             */
    uint8  LMTT:1;                                         /* LMTT             */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TCSS:2;                                         /* TCSS[9:8]        */
    uint8  :6;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type1141;
typedef struct 
{                                                          /* Bit Access       */
    uint32 MTTV:32;                                        /* MTTV[31:0]       */
} __type1142;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PTCV:32;                                        /* PTCV[31:0]       */
} __type1143;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TIV:28;                                         /* TIV[27:0]        */
    uint32 :4;                                             /* Reserved Bits    */
} __type1144;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TOV:32;                                         /* TOV[31:0]        */
} __type1145;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 PTME:1;                                         /* PTME             */
    uint32 :29;                                            /* Reserved Bits    */
} __type1146;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 PTMF:1;                                         /* PTMF             */
    uint32 :29;                                            /* Reserved Bits    */
} __type1147;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CTV:32;                                         /* CTV[31:0]        */
} __type1148;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PRM:1;                                          /* PRM              */
    uint32 DM:1;                                           /* DM               */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 TE:1;                                           /* TE               */
    uint32 RE:1;                                           /* RE               */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 MPDE:1;                                         /* MPDE             */
    uint32 :6;                                             /* Reserved Bits    */
    uint32 TXF:1;                                          /* TXF              */
    uint32 RXF:1;                                          /* RXF              */
    uint32 PFR:1;                                          /* PFR              */
    uint32 ZPF:1;                                          /* ZPF              */
    uint32 RZPF:1;                                         /* RZPF             */
    uint32 DPAD:1;                                         /* DPAD             */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 RCSC:1;                                         /* RCSC             */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 TRCCM:1;                                        /* TRCCM            */
    uint32 :5;                                             /* Reserved Bits    */
} __type1149;
typedef struct 
{                                                          /* Bit Access       */
    uint32 RFL:18;                                         /* RFL[17:0]        */
    uint32 :14;                                            /* Reserved Bits    */
} __type1150;
typedef struct 
{                                                          /* Bit Access       */
    uint32 ICD:1;                                          /* ICD              */
    uint32 MPD:1;                                          /* MPD              */
    uint32 :30;                                            /* Reserved Bits    */
} __type1151;
typedef struct 
{                                                          /* Bit Access       */
    uint32 ICDIP:1;                                        /* ICDIP            */
    uint32 MPDIP:1;                                        /* MPDIP            */
    uint32 :30;                                            /* Reserved Bits    */
} __type1152;
typedef struct 
{                                                          /* Bit Access       */
    uint32 MDC:1;                                          /* MDC              */
    uint32 MMD:1;                                          /* MMD              */
    uint32 MDO:1;                                          /* MDO              */
    uint32 MDI:1;                                          /* MDI              */
    uint32 :28;                                            /* Reserved Bits    */
} __type1153;
typedef struct 
{                                                          /* Bit Access       */
    uint32 APFTP:16;                                       /* APFTP[15:0]      */
    uint32 :16;                                            /* Reserved Bits    */
} __type1154;
typedef struct 
{                                                          /* Bit Access       */
    uint32 MP:16;                                          /* MP[15:0]         */
    uint32 :16;                                            /* Reserved Bits    */
} __type1155;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PFTXC:16;                                       /* PFTXC[15:0]      */
    uint32 :16;                                            /* Reserved Bits    */
} __type1156;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PFRXC:16;                                       /* PFRXC[15:0]      */
    uint32 :16;                                            /* Reserved Bits    */
} __type1157;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SPEED:1;                                        /* SPEED            */
    uint32 :31;                                            /* Reserved Bits    */
} __type1158;
typedef struct 
{                                                          /* Bit Access       */
    uint32 MA:32;                                          /* MA[31:0]         */
} __type1159;
typedef struct 
{                                                          /* Bit Access       */
    uint32 MA:16;                                          /* MA[15:0]         */
    uint32 :16;                                            /* Reserved Bits    */
} __type1160;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TROC:16;                                        /* TROC[15:0]       */
    uint32 :16;                                            /* Reserved Bits    */
} __type1161;
typedef struct 
{                                                          /* Bit Access       */
    uint32 LCC:16;                                         /* LCC[15:0]        */
    uint32 :16;                                            /* Reserved Bits    */
} __type1162;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CEFC:16;                                        /* CEFC[15:0]       */
    uint32 :16;                                            /* Reserved Bits    */
} __type1163;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FREC:16;                                        /* FREC[15:0]       */
    uint32 :16;                                            /* Reserved Bits    */
} __type1164;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TSFRC:16;                                       /* TSFRC[15:0]      */
    uint32 :16;                                            /* Reserved Bits    */
} __type1165;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TLFC:16;                                        /* TLFC[15:0]       */
    uint32 :16;                                            /* Reserved Bits    */
} __type1166;
typedef struct 
{                                                          /* Bit Access       */
    uint32 RFC:16;                                         /* RFC[15:0]        */
    uint32 :16;                                            /* Reserved Bits    */
} __type1167;
typedef struct 
{                                                          /* Bit Access       */
    uint32 MAFC:16;                                        /* MAFC[15:0]       */
    uint32 :16;                                            /* Reserved Bits    */
} __type1168;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CMD_SEQ:6;                                      /* CMD_SEQ[5:0]     */
    uint32 INPUT_SEL:1;                                    /* INPUT_SEL        */
    uint32 DATA_SEL:1;                                     /* DATA_SEL         */
    uint32 CMD_0:8;                                        /* CMD_0[15:8]      */
    uint32 CMD_1:8;                                        /* CMD_1[23:16]     */
    uint32 CMD_2:8;                                        /* CMD_2[31:24]     */
} __type1169;
typedef struct 
{                                                          /* Bit Access       */
    uint32 READ_STATUS_EN:1;                               /* READ_STATUS_EN   */
    uint32 ECC_BLOCK_SIZE:2;                               /* ECC_BLOCK_SIZE[2:1] */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 INT_EN:1;                                       /* INT_EN           */
    uint32 ECC_EN:1;                                       /* ECC_EN           */
    uint32 BLOCK_SIZE:2;                                   /* BLOCK_SIZE[7:6]  */
    uint32 :4;                                             /* Reserved Bits    */
    uint32 IO_WIDTH:1;                                     /* IO_WIDTH         */
    uint32 BBM_EN:1;                                       /* BBM_EN           */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 ADDR0_AUTO_INCR:1;                              /* ADDR0_AUTO_INCR  */
    uint32 ADDR1_AUTO_INCR:1;                              /* ADDR1_AUTO_INCR  */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 SMALL_BLOCK_EN:1;                               /* SMALL_BLOCK_EN   */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 AUTO_READ_STAT_EN:1;                            /* AUTO_READ_STAT_EN */
    uint32 :8;                                             /* Reserved Bits    */
} __type1170;
typedef struct 
{                                                          /* Bit Access       */
    uint32 MEM0_ST:1;                                      /* MEM0_ST          */
    uint32 :7;                                             /* Reserved Bits    */
    uint32 CTRL_STAT:1;                                    /* CTRL_STAT        */
    uint32 DATASIZE_ERROR_ST:1;                            /* DATASIZE_ERROR_ST */
    uint32 DATA_REG_ST:1;                                  /* DATA_REG_ST      */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 CMD_ID:8;                                       /* CMD_ID[23:16]    */
    uint32 :8;                                             /* Reserved Bits    */
} __type1171;
typedef struct 
{                                                          /* Bit Access       */
    uint32 STATE_MASK:8;                                   /* STATE_MASK[7:0]  */
    uint32 ERROR_MASK:8;                                   /* ERROR_MASK[15:8] */
    uint32 :16;                                            /* Reserved Bits    */
} __type1172;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 CMD_END_INT_EN:1;                               /* CMD_END_INT_EN   */
    uint32 DATA_REG_INT_EN:1;                              /* DATA_REG_INT_EN  */
    uint32 DMA_INT_EN:1;                                   /* DMA_INT_EN       */
    uint32 TRANS_ERR_EN:1;                                 /* TRANS_ERR_EN     */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PG_SZ_ERR_INT_EN:1;                             /* PG_SZ_ERR_INT_EN */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 MEM0_RDY_INT_EN:1;                              /* MEM0_RDY_INT_EN  */
    uint32 :7;                                             /* Reserved Bits    */
    uint32 STAT_ERR_INT0_EN:1;                             /* STAT_ERR_INT0_EN */
    uint32 :7;                                             /* Reserved Bits    */
    uint32 ECC_INT0_EN:1;                                  /* ECC_INT0_EN      */
    uint32 :7;                                             /* Reserved Bits    */
} __type1173;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 CMD_END_INT_FL:1;                               /* CMD_END_INT_FL   */
    uint32 DATA_REG_INT_FL:1;                              /* DATA_REG_INT_FL  */
    uint32 DMA_INT_FL:1;                                   /* DMA_INT_FL       */
    uint32 TRANS_ERR_FL:1;                                 /* TRANS_ERR_FL     */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 PG_SZ_ERR_INT_FL:1;                             /* PG_SZ_ERR_INT_FL */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 MEM0_RDY_INT_FL:1;                              /* MEM0_RDY_INT_FL  */
    uint32 :7;                                             /* Reserved Bits    */
    uint32 STAT_ERR_INT0_FL:1;                             /* STAT_ERR_INT0_FL */
    uint32 :7;                                             /* Reserved Bits    */
    uint32 ECC_INT0_FL:1;                                  /* ECC_INT0_FL      */
    uint32 :7;                                             /* Reserved Bits    */
} __type1174;
typedef struct 
{                                                          /* Bit Access       */
    uint32 ECC_CAP:3;                                      /* ECC_CAP[2:0]     */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 ERR_THRESHOLD:6;                                /* ERR_THRESHOLD[13:8] */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 ECC_SEL:2;                                      /* ECC_SEL[17:16]   */
    uint32 :14;                                            /* Reserved Bits    */
} __type1175;
typedef struct 
{                                                          /* Bit Access       */
    uint32 ECC_OFFSET:16;                                  /* ECC_OFFSET[15:0] */
    uint32 :16;                                            /* Reserved Bits    */
} __type1176;
typedef struct 
{                                                          /* Bit Access       */
    uint32 ECC_ERROR_0:1;                                  /* ECC_ERROR_0      */
    uint32 :7;                                             /* Reserved Bits    */
    uint32 ECC_UNC_0:1;                                    /* ECC_UNC_0        */
    uint32 :7;                                             /* Reserved Bits    */
    uint32 ECC_OVER_0:1;                                   /* ECC_OVER_0       */
    uint32 :15;                                            /* Reserved Bits    */
} __type1177;
typedef struct 
{                                                          /* Bit Access       */
    uint32 ADDR0_COL:16;                                   /* ADDR0_COL[15:0]  */
    uint32 :16;                                            /* Reserved Bits    */
} __type1178;
typedef struct 
{                                                          /* Bit Access       */
    uint32 ADDR0_ROW:24;                                   /* ADDR0_ROW[23:0]  */
    uint32 :8;                                             /* Reserved Bits    */
} __type1179;
typedef struct 
{                                                          /* Bit Access       */
    uint32 ADDR1_COL:16;                                   /* ADDR1_COL[15:0]  */
    uint32 :16;                                            /* Reserved Bits    */
} __type1180;
typedef struct 
{                                                          /* Bit Access       */
    uint32 ADDR1_ROW:24;                                   /* ADDR1_ROW[23:0]  */
    uint32 :8;                                             /* Reserved Bits    */
} __type1181;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FIFO_DATA:32;                                   /* FIFO_DATA[31:0]  */
} __type1182;
typedef struct 
{                                                          /* Bit Access       */
    uint32 DATA_REG:32;                                    /* DATA_REG[31:0]   */
} __type1183;
typedef struct 
{                                                          /* Bit Access       */
    uint32 DATA_REG_SIZE:2;                                /* DATA_REG_SIZE[1:0] */
    uint32 :30;                                            /* Reserved Bits    */
} __type1184;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 PTR_ADDR:10;                                    /* PTR_ADDR[11:2]   */
    uint32 :20;                                            /* Reserved Bits    */
} __type1185;
typedef struct 
{                                                          /* Bit Access       */
    uint32 DMA_ADDR_L:32;                                  /* DMA_ADDR_L[31:0] */
} __type1186;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CNT_INIT:32;                                    /* CNT_INIT[31:0]   */
} __type1187;
typedef struct 
{                                                          /* Bit Access       */
    uint32 DMA_READY:1;                                    /* DMA_READY        */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 DMA_BURST:3;                                    /* DMA_BURST[4:2]   */
    uint32 DMA_MODE:1;                                     /* DMA_MODE         */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 DMA_START:1;                                    /* DMA_START        */
    uint32 :24;                                            /* Reserved Bits    */
} __type1188;
typedef struct 
{                                                          /* Bit Access       */
    uint32 RMP_INIT:1;                                     /* RMP_INIT         */
    uint32 :31;                                            /* Reserved Bits    */
} __type1189;
typedef struct 
{                                                          /* Bit Access       */
    uint32 DATA_SIZE:15;                                   /* DATA_SIZE[14:0]  */
    uint32 :17;                                            /* Reserved Bits    */
} __type1190;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TRWP:4;                                         /* TRWP[3:0]        */
    uint32 TRWH:4;                                         /* TRWH[7:4]        */
    uint32 :24;                                            /* Reserved Bits    */
} __type1191;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TCCS:6;                                         /* TCCS[5:0]        */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 TADL:6;                                         /* TADL[13:8]       */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 TRHW:6;                                         /* TRHW[21:16]      */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 TWHR:6;                                         /* TWHR[29:24]      */
    uint32 :2;                                             /* Reserved Bits    */
} __type1192;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TWB:6;                                          /* TWB[5:0]         */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 TRR:6;                                          /* TRR[13:8]        */
    uint32 :18;                                            /* Reserved Bits    */
} __type1193;
typedef struct 
{                                                          /* Bit Access       */
    uint32 T0_D0:6;                                        /* T0_D0[5:0]       */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 T0_D1:6;                                        /* T0_D1[13:8]      */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 T0_D2:6;                                        /* T0_D2[21:16]     */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 T0_D3:6;                                        /* T0_D3[29:24]     */
    uint32 :2;                                             /* Reserved Bits    */
} __type1194;
typedef struct 
{                                                          /* Bit Access       */
    uint32 T0_D4:6;                                        /* T0_D4[5:0]       */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 T0_D5:6;                                        /* T0_D5[13:8]      */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 T0_D6:6;                                        /* T0_D6[21:16]     */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 T0_D7:6;                                        /* T0_D7[29:24]     */
    uint32 :2;                                             /* Reserved Bits    */
} __type1195;
typedef struct 
{                                                          /* Bit Access       */
    uint32 T0_D8:6;                                        /* T0_D8[5:0]       */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 T0_D9:6;                                        /* T0_D9[13:8]      */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 T0_D10:6;                                       /* T0_D10[21:16]    */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 T0_D11:6;                                       /* T0_D11[29:24]    */
    uint32 :2;                                             /* Reserved Bits    */
} __type1196;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FIFO_INIT:1;                                    /* FIFO_INIT        */
    uint32 :31;                                            /* Reserved Bits    */
} __type1197;
typedef struct 
{                                                          /* Bit Access       */
    uint32 DF_R_EMPTY:1;                                   /* DF_R_EMPTY       */
    uint32 DF_W_FULL:1;                                    /* DF_W_FULL        */
    uint32 CF_EMPTY:1;                                     /* CF_EMPTY         */
    uint32 CF_FULL:1;                                      /* CF_FULL          */
    uint32 CF_ACCPT_R:1;                                   /* CF_ACCPT_R       */
    uint32 CF_ACCPT_W:1;                                   /* CF_ACCPT_W       */
    uint32 DF_R_FULL:1;                                    /* DF_R_FULL        */
    uint32 DF_W_EMPTY:1;                                   /* DF_W_EMPTY       */
    uint32 :24;                                            /* Reserved Bits    */
} __type1198;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CMD0_EN:1;                                      /* CMD0_EN          */
    uint32 CMD1_EN:1;                                      /* CMD1_EN          */
    uint32 CMD2_EN:1;                                      /* CMD2_EN          */
    uint32 CMD3_EN:1;                                      /* CMD3_EN          */
    uint32 COL_A0:2;                                       /* COL_A0[5:4]      */
    uint32 COL_A1:2;                                       /* COL_A1[7:6]      */
    uint32 ROW_A0:2;                                       /* ROW_A0[9:8]      */
    uint32 ROW_A1:2;                                       /* ROW_A1[11:10]    */
    uint32 DATA_EN:1;                                      /* DATA_EN          */
    uint32 DELAY_EN:2;                                     /* DELAY_EN[14:13]  */
    uint32 IMD_SEQ:1;                                      /* IMD_SEQ          */
    uint32 CMD3:8;                                         /* CMD3[23:16]      */
    uint32 :8;                                             /* Reserved Bits    */
} __type1199;
typedef struct 
{                                                          /* Bit Access       */
    uint32 DEV_SIZE:12;                                    /* DEV_SIZE[11:0]   */
    uint32 :20;                                            /* Reserved Bits    */
} __type1200;
typedef struct 
{                                                          /* Bit Access       */
    uint32 DMA_TRIG_LVL:8;                                 /* DMA_TRIG_LVL[7:0] */
    uint32 :24;                                            /* Reserved Bits    */
} __type1201;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CMD_ID:8;                                       /* CMD_ID[7:0]      */
    uint32 :24;                                            /* Reserved Bits    */
} __type1202;
typedef struct 
{                                                          /* Bit Access       */
    uint32 MEM0_LUN:8;                                     /* MEM0_LUN[7:0]    */
    uint32 :24;                                            /* Reserved Bits    */
} __type1203;
typedef struct 
{                                                          /* Bit Access       */
    uint32 T0_D12:6;                                       /* T0_D12[5:0]      */
    uint32 :26;                                            /* Reserved Bits    */
} __type1204;
typedef struct 
{                                                          /* Bit Access       */
    uint32 ERR_LVL:6;                                      /* ERR_LVL[5:0]     */
    uint32 :26;                                            /* Reserved Bits    */
} __type1205;
typedef struct 
{                                                          /* Bit Access       */
    uint16 TOL00:1;                                        /* TOL00            */
    uint16 TOL01:1;                                        /* TOL01            */
    uint16 TOL02:1;                                        /* TOL02            */
    uint16 TOL03:1;                                        /* TOL03            */
    uint16 TOL04:1;                                        /* TOL04            */
    uint16 TOL05:1;                                        /* TOL05            */
    uint16 TOL06:1;                                        /* TOL06            */
    uint16 TOL07:1;                                        /* TOL07            */
    uint16 TOL08:1;                                        /* TOL08            */
    uint16 TOL09:1;                                        /* TOL09            */
    uint16 TOL10:1;                                        /* TOL10            */
    uint16 TOL11:1;                                        /* TOL11            */
    uint16 TOL12:1;                                        /* TOL12            */
    uint16 TOL13:1;                                        /* TOL13            */
    uint16 TOL14:1;                                        /* TOL14            */
    uint16 TOL15:1;                                        /* TOL15            */
} __type1206;
typedef struct 
{                                                          /* Bit Access       */
    uint16 RDT00:1;                                        /* RDT00            */
    uint16 RDT01:1;                                        /* RDT01            */
    uint16 RDT02:1;                                        /* RDT02            */
    uint16 RDT03:1;                                        /* RDT03            */
    uint16 RDT04:1;                                        /* RDT04            */
    uint16 RDT05:1;                                        /* RDT05            */
    uint16 RDT06:1;                                        /* RDT06            */
    uint16 RDT07:1;                                        /* RDT07            */
    uint16 RDT08:1;                                        /* RDT08            */
    uint16 RDT09:1;                                        /* RDT09            */
    uint16 RDT10:1;                                        /* RDT10            */
    uint16 RDT11:1;                                        /* RDT11            */
    uint16 RDT12:1;                                        /* RDT12            */
    uint16 RDT13:1;                                        /* RDT13            */
    uint16 RDT14:1;                                        /* RDT14            */
    uint16 RDT15:1;                                        /* RDT15            */
} __type1207;
typedef struct 
{                                                          /* Bit Access       */
    uint16 RSF00:1;                                        /* RSF00            */
    uint16 RSF01:1;                                        /* RSF01            */
    uint16 RSF02:1;                                        /* RSF02            */
    uint16 RSF03:1;                                        /* RSF03            */
    uint16 RSF04:1;                                        /* RSF04            */
    uint16 RSF05:1;                                        /* RSF05            */
    uint16 RSF06:1;                                        /* RSF06            */
    uint16 RSF07:1;                                        /* RSF07            */
    uint16 RSF08:1;                                        /* RSF08            */
    uint16 RSF09:1;                                        /* RSF09            */
    uint16 RSF10:1;                                        /* RSF10            */
    uint16 RSF11:1;                                        /* RSF11            */
    uint16 RSF12:1;                                        /* RSF12            */
    uint16 RSF13:1;                                        /* RSF13            */
    uint16 RSF14:1;                                        /* RSF14            */
    uint16 RSF15:1;                                        /* RSF15            */
} __type1208;
typedef struct 
{                                                          /* Bit Access       */
    uint16 TDL00:1;                                        /* TDL00            */
    uint16 TDL01:1;                                        /* TDL01            */
    uint16 TDL02:1;                                        /* TDL02            */
    uint16 TDL03:1;                                        /* TDL03            */
    uint16 TDL04:1;                                        /* TDL04            */
    uint16 TDL05:1;                                        /* TDL05            */
    uint16 TDL06:1;                                        /* TDL06            */
    uint16 TDL07:1;                                        /* TDL07            */
    uint16 TDL08:1;                                        /* TDL08            */
    uint16 TDL09:1;                                        /* TDL09            */
    uint16 TDL10:1;                                        /* TDL10            */
    uint16 TDL11:1;                                        /* TDL11            */
    uint16 TDL12:1;                                        /* TDL12            */
    uint16 TDL13:1;                                        /* TDL13            */
    uint16 TDL14:1;                                        /* TDL14            */
    uint16 TDL15:1;                                        /* TDL15            */
} __type1209;
typedef struct 
{                                                          /* Bit Access       */
    uint16 TO00:1;                                         /* TO00             */
    uint16 TO01:1;                                         /* TO01             */
    uint16 TO02:1;                                         /* TO02             */
    uint16 TO03:1;                                         /* TO03             */
    uint16 TO04:1;                                         /* TO04             */
    uint16 TO05:1;                                         /* TO05             */
    uint16 TO06:1;                                         /* TO06             */
    uint16 TO07:1;                                         /* TO07             */
    uint16 TO08:1;                                         /* TO08             */
    uint16 TO09:1;                                         /* TO09             */
    uint16 TO10:1;                                         /* TO10             */
    uint16 TO11:1;                                         /* TO11             */
    uint16 TO12:1;                                         /* TO12             */
    uint16 TO13:1;                                         /* TO13             */
    uint16 TO14:1;                                         /* TO14             */
    uint16 TO15:1;                                         /* TO15             */
} __type1210;
typedef struct 
{                                                          /* Bit Access       */
    uint16 TOE00:1;                                        /* TOE00            */
    uint16 TOE01:1;                                        /* TOE01            */
    uint16 TOE02:1;                                        /* TOE02            */
    uint16 TOE03:1;                                        /* TOE03            */
    uint16 TOE04:1;                                        /* TOE04            */
    uint16 TOE05:1;                                        /* TOE05            */
    uint16 TOE06:1;                                        /* TOE06            */
    uint16 TOE07:1;                                        /* TOE07            */
    uint16 TOE08:1;                                        /* TOE08            */
    uint16 TOE09:1;                                        /* TOE09            */
    uint16 TOE10:1;                                        /* TOE10            */
    uint16 TOE11:1;                                        /* TOE11            */
    uint16 TOE12:1;                                        /* TOE12            */
    uint16 TOE13:1;                                        /* TOE13            */
    uint16 TOE14:1;                                        /* TOE14            */
    uint16 TOE15:1;                                        /* TOE15            */
} __type1211;
typedef struct 
{                                                          /* Bit Access       */
    uint8  TIS:2;                                          /* TIS[1:0]         */
    uint8  :6;                                             /* Reserved Bits    */
} __type1212;
typedef struct 
{                                                          /* Bit Access       */
    uint8  OVF:1;                                          /* OVF              */
    uint8  CSF:1;                                          /* CSF              */
    uint8  :6;                                             /* Reserved Bits    */
} __type1213;
typedef struct 
{                                                          /* Bit Access       */
    uint8  CLOV:1;                                         /* CLOV             */
    uint8  :7;                                             /* Reserved Bits    */
} __type1214;
typedef struct 
{                                                          /* Bit Access       */
    uint16 TE00:1;                                         /* TE00             */
    uint16 TE01:1;                                         /* TE01             */
    uint16 TE02:1;                                         /* TE02             */
    uint16 TE03:1;                                         /* TE03             */
    uint16 TE04:1;                                         /* TE04             */
    uint16 TE05:1;                                         /* TE05             */
    uint16 TE06:1;                                         /* TE06             */
    uint16 TE07:1;                                         /* TE07             */
    uint16 TE08:1;                                         /* TE08             */
    uint16 TE09:1;                                         /* TE09             */
    uint16 TE10:1;                                         /* TE10             */
    uint16 TE11:1;                                         /* TE11             */
    uint16 TE12:1;                                         /* TE12             */
    uint16 TE13:1;                                         /* TE13             */
    uint16 TE14:1;                                         /* TE14             */
    uint16 TE15:1;                                         /* TE15             */
} __type1215;
typedef struct 
{                                                          /* Bit Access       */
    uint16 TS00:1;                                         /* TS00             */
    uint16 TS01:1;                                         /* TS01             */
    uint16 TS02:1;                                         /* TS02             */
    uint16 TS03:1;                                         /* TS03             */
    uint16 TS04:1;                                         /* TS04             */
    uint16 TS05:1;                                         /* TS05             */
    uint16 TS06:1;                                         /* TS06             */
    uint16 TS07:1;                                         /* TS07             */
    uint16 TS08:1;                                         /* TS08             */
    uint16 TS09:1;                                         /* TS09             */
    uint16 TS10:1;                                         /* TS10             */
    uint16 TS11:1;                                         /* TS11             */
    uint16 TS12:1;                                         /* TS12             */
    uint16 TS13:1;                                         /* TS13             */
    uint16 TS14:1;                                         /* TS14             */
    uint16 TS15:1;                                         /* TS15             */
} __type1216;
typedef struct 
{                                                          /* Bit Access       */
    uint16 TT00:1;                                         /* TT00             */
    uint16 TT01:1;                                         /* TT01             */
    uint16 TT02:1;                                         /* TT02             */
    uint16 TT03:1;                                         /* TT03             */
    uint16 TT04:1;                                         /* TT04             */
    uint16 TT05:1;                                         /* TT05             */
    uint16 TT06:1;                                         /* TT06             */
    uint16 TT07:1;                                         /* TT07             */
    uint16 TT08:1;                                         /* TT08             */
    uint16 TT09:1;                                         /* TT09             */
    uint16 TT10:1;                                         /* TT10             */
    uint16 TT11:1;                                         /* TT11             */
    uint16 TT12:1;                                         /* TT12             */
    uint16 TT13:1;                                         /* TT13             */
    uint16 TT14:1;                                         /* TT14             */
    uint16 TT15:1;                                         /* TT15             */
} __type1217;
typedef struct 
{                                                          /* Bit Access       */
    uint16 MD:5;                                           /* MD[4:0]          */
    uint16 :1;                                             /* Reserved Bits    */
    uint16 COS:2;                                          /* COS[7:6]         */
    uint16 STS:3;                                          /* STS[10:8]        */
    uint16 MAS:1;                                          /* MAS              */
    uint16 CCS0:1;                                         /* CCS0             */
    uint16 :1;                                             /* Reserved Bits    */
    uint16 CKS:2;                                          /* CKS[15:14]       */
} __type1218;
typedef struct 
{                                                          /* Bit Access       */
    uint16 PRS0:4;                                         /* PRS0[3:0]        */
    uint16 PRS1:4;                                         /* PRS1[7:4]        */
    uint16 PRS2:4;                                         /* PRS2[11:8]       */
    uint16 PRS3:4;                                         /* PRS3[15:12]      */
} __type1219;
typedef struct 
{                                                          /* Bit Access       */
    uint16 TOM00:1;                                        /* TOM00            */
    uint16 TOM01:1;                                        /* TOM01            */
    uint16 TOM02:1;                                        /* TOM02            */
    uint16 TOM03:1;                                        /* TOM03            */
    uint16 TOM04:1;                                        /* TOM04            */
    uint16 TOM05:1;                                        /* TOM05            */
    uint16 TOM06:1;                                        /* TOM06            */
    uint16 TOM07:1;                                        /* TOM07            */
    uint16 TOM08:1;                                        /* TOM08            */
    uint16 TOM09:1;                                        /* TOM09            */
    uint16 TOM10:1;                                        /* TOM10            */
    uint16 TOM11:1;                                        /* TOM11            */
    uint16 TOM12:1;                                        /* TOM12            */
    uint16 TOM13:1;                                        /* TOM13            */
    uint16 TOM14:1;                                        /* TOM14            */
    uint16 TOM15:1;                                        /* TOM15            */
} __type1220;
typedef struct 
{                                                          /* Bit Access       */
    uint16 TOC00:1;                                        /* TOC00            */
    uint16 TOC01:1;                                        /* TOC01            */
    uint16 TOC02:1;                                        /* TOC02            */
    uint16 TOC03:1;                                        /* TOC03            */
    uint16 TOC04:1;                                        /* TOC04            */
    uint16 TOC05:1;                                        /* TOC05            */
    uint16 TOC06:1;                                        /* TOC06            */
    uint16 TOC07:1;                                        /* TOC07            */
    uint16 TOC08:1;                                        /* TOC08            */
    uint16 TOC09:1;                                        /* TOC09            */
    uint16 TOC10:1;                                        /* TOC10            */
    uint16 TOC11:1;                                        /* TOC11            */
    uint16 TOC12:1;                                        /* TOC12            */
    uint16 TOC13:1;                                        /* TOC13            */
    uint16 TOC14:1;                                        /* TOC14            */
    uint16 TOC15:1;                                        /* TOC15            */
} __type1221;
typedef struct 
{                                                          /* Bit Access       */
    uint16 TDE00:1;                                        /* TDE00            */
    uint16 TDE01:1;                                        /* TDE01            */
    uint16 TDE02:1;                                        /* TDE02            */
    uint16 TDE03:1;                                        /* TDE03            */
    uint16 TDE04:1;                                        /* TDE04            */
    uint16 TDE05:1;                                        /* TDE05            */
    uint16 TDE06:1;                                        /* TDE06            */
    uint16 TDE07:1;                                        /* TDE07            */
    uint16 TDE08:1;                                        /* TDE08            */
    uint16 TDE09:1;                                        /* TDE09            */
    uint16 TDE10:1;                                        /* TDE10            */
    uint16 TDE11:1;                                        /* TDE11            */
    uint16 TDE12:1;                                        /* TDE12            */
    uint16 TDE13:1;                                        /* TDE13            */
    uint16 TDE14:1;                                        /* TDE14            */
    uint16 TDE15:1;                                        /* TDE15            */
} __type1222;
typedef struct 
{                                                          /* Bit Access       */
    uint16 RDE00:1;                                        /* RDE00            */
    uint16 RDE01:1;                                        /* RDE01            */
    uint16 RDE02:1;                                        /* RDE02            */
    uint16 RDE03:1;                                        /* RDE03            */
    uint16 RDE04:1;                                        /* RDE04            */
    uint16 RDE05:1;                                        /* RDE05            */
    uint16 RDE06:1;                                        /* RDE06            */
    uint16 RDE07:1;                                        /* RDE07            */
    uint16 RDE08:1;                                        /* RDE08            */
    uint16 RDE09:1;                                        /* RDE09            */
    uint16 RDE10:1;                                        /* RDE10            */
    uint16 RDE11:1;                                        /* RDE11            */
    uint16 RDE12:1;                                        /* RDE12            */
    uint16 RDE13:1;                                        /* RDE13            */
    uint16 RDE14:1;                                        /* RDE14            */
    uint16 RDE15:1;                                        /* RDE15            */
} __type1223;
typedef struct 
{                                                          /* Bit Access       */
    uint16 RDM00:1;                                        /* RDM00            */
    uint16 RDM01:1;                                        /* RDM01            */
    uint16 RDM02:1;                                        /* RDM02            */
    uint16 RDM03:1;                                        /* RDM03            */
    uint16 RDM04:1;                                        /* RDM04            */
    uint16 RDM05:1;                                        /* RDM05            */
    uint16 RDM06:1;                                        /* RDM06            */
    uint16 RDM07:1;                                        /* RDM07            */
    uint16 RDM08:1;                                        /* RDM08            */
    uint16 RDM09:1;                                        /* RDM09            */
    uint16 RDM10:1;                                        /* RDM10            */
    uint16 RDM11:1;                                        /* RDM11            */
    uint16 RDM12:1;                                        /* RDM12            */
    uint16 RDM13:1;                                        /* RDM13            */
    uint16 RDM14:1;                                        /* RDM14            */
    uint16 RDM15:1;                                        /* RDM15            */
} __type1224;
typedef struct 
{                                                          /* Bit Access       */
    uint16 RDS00:1;                                        /* RDS00            */
    uint16 RDS01:1;                                        /* RDS01            */
    uint16 RDS02:1;                                        /* RDS02            */
    uint16 RDS03:1;                                        /* RDS03            */
    uint16 RDS04:1;                                        /* RDS04            */
    uint16 RDS05:1;                                        /* RDS05            */
    uint16 RDS06:1;                                        /* RDS06            */
    uint16 RDS07:1;                                        /* RDS07            */
    uint16 RDS08:1;                                        /* RDS08            */
    uint16 RDS09:1;                                        /* RDS09            */
    uint16 RDS10:1;                                        /* RDS10            */
    uint16 RDS11:1;                                        /* RDS11            */
    uint16 RDS12:1;                                        /* RDS12            */
    uint16 RDS13:1;                                        /* RDS13            */
    uint16 RDS14:1;                                        /* RDS14            */
    uint16 RDS15:1;                                        /* RDS15            */
} __type1225;
typedef struct 
{                                                          /* Bit Access       */
    uint16 RDC00:1;                                        /* RDC00            */
    uint16 RDC01:1;                                        /* RDC01            */
    uint16 RDC02:1;                                        /* RDC02            */
    uint16 RDC03:1;                                        /* RDC03            */
    uint16 RDC04:1;                                        /* RDC04            */
    uint16 RDC05:1;                                        /* RDC05            */
    uint16 RDC06:1;                                        /* RDC06            */
    uint16 RDC07:1;                                        /* RDC07            */
    uint16 RDC08:1;                                        /* RDC08            */
    uint16 RDC09:1;                                        /* RDC09            */
    uint16 RDC10:1;                                        /* RDC10            */
    uint16 RDC11:1;                                        /* RDC11            */
    uint16 RDC12:1;                                        /* RDC12            */
    uint16 RDC13:1;                                        /* RDC13            */
    uint16 RDC14:1;                                        /* RDC14            */
    uint16 RDC15:1;                                        /* RDC15            */
} __type1226;
typedef struct 
{                                                          /* Bit Access       */
    uint16 MD:5;                                           /* MD[4:0]          */
    uint16 :1;                                             /* Reserved Bits    */
    uint16 COS:2;                                          /* COS[7:6]         */
    uint16 STS:3;                                          /* STS[10:8]        */
    uint16 MAS:1;                                          /* MAS              */
    uint16 :2;                                             /* Reserved Bits    */
    uint16 CKS:2;                                          /* CKS[15:14]       */
} __type1227;
typedef struct 
{                                                          /* Bit Access       */
    uint8  OVF:1;                                          /* OVF              */
    uint8  :6;                                             /* Reserved Bits    */
    uint8  RPF:1;                                          /* RPF              */
} __type1228;
typedef struct 
{                                                          /* Bit Access       */
    uint8  :7;                                             /* Reserved Bits    */
    uint8  CLRP:1;                                         /* CLRP             */
} __type1229;
typedef struct 
{                                                          /* Bit Access       */
    uint8  MD:2;                                           /* MD[1:0]          */
    uint8  :1;                                             /* Reserved Bits    */
    uint8  TIS:1;                                          /* TIS              */
    uint8  :3;                                             /* Reserved Bits    */
    uint8  TE:1;                                           /* TE               */
} __type1230;
typedef struct 
{                                                          /* Bit Access       */
    uint8  TOE:1;                                          /* TOE              */
    uint8  :7;                                             /* Reserved Bits    */
} __type1231;
typedef struct 
{                                                          /* Bit Access       */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  SLSB:1;                                         /* SLSB             */
    uint8  AMPM:1;                                         /* AMPM             */
    uint8  CEST:1;                                         /* CEST             */
    uint8  CE:1;                                           /* CE               */
} __type1232;
typedef struct 
{                                                          /* Bit Access       */
    uint8  CT:3;                                           /* CT[2:0]          */
    uint8  EN1S:1;                                         /* EN1S             */
    uint8  ENALM:1;                                        /* ENALM            */
    uint8  EN1HZ:1;                                        /* EN1HZ            */
    uint8  :2;                                             /* Reserved Bits    */
} __type1233;
typedef struct 
{                                                          /* Bit Access       */
    uint8  WAIT:1;                                         /* WAIT             */
    uint8  WST:1;                                          /* WST              */
    uint8  RSUB:1;                                         /* RSUB             */
    uint8  RSST:1;                                         /* RSST             */
    uint8  WSST:1;                                         /* WSST             */
    uint8  WUST:1;                                         /* WUST             */
    uint8  :2;                                             /* Reserved Bits    */
} __type1234;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SUBC:22;                                        /* SUBC[21:0]       */
    uint32 :10;                                            /* Reserved Bits    */
} __type1235;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SRBU:22;                                        /* SRBU[21:0]       */
    uint32 :10;                                            /* Reserved Bits    */
} __type1236;
typedef struct 
{                                                          /* Bit Access       */
    uint8  SEC:7;                                          /* SEC[6:0]         */
    uint8  :1;                                             /* Reserved Bits    */
} __type1237;
typedef struct 
{                                                          /* Bit Access       */
    uint8  MIN:7;                                          /* MIN[6:0]         */
    uint8  :1;                                             /* Reserved Bits    */
} __type1238;
typedef struct 
{                                                          /* Bit Access       */
    uint8  HOUR:6;                                         /* HOUR[5:0]        */
    uint8  :2;                                             /* Reserved Bits    */
} __type1239;
typedef struct 
{                                                          /* Bit Access       */
    uint8  WEEK:3;                                         /* WEEK[2:0]        */
    uint8  :5;                                             /* Reserved Bits    */
} __type1240;
typedef struct 
{                                                          /* Bit Access       */
    uint8  DAY:6;                                          /* DAY[5:0]         */
    uint8  :2;                                             /* Reserved Bits    */
} __type1241;
typedef struct 
{                                                          /* Bit Access       */
    uint8  MONTH:5;                                        /* MONTH[4:0]       */
    uint8  :3;                                             /* Reserved Bits    */
} __type1242;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SEC:7;                                          /* SEC[6:0]         */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 MIN:7;                                          /* MIN[14:8]        */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 HOUR:6;                                         /* HOUR[21:16]      */
    uint32 :10;                                            /* Reserved Bits    */
} __type1243;
typedef struct 
{                                                          /* Bit Access       */
    uint32 WEEK:3;                                         /* WEEK[2:0]        */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 DAY:6;                                          /* DAY[13:8]        */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 MONTH:5;                                        /* MONTH[20:16]     */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 YEAR:8;                                         /* YEAR[31:24]      */
} __type1244;
typedef struct 
{                                                          /* Bit Access       */
    uint8  F:6;                                            /* F[5:0]           */
    uint8  F6:1;                                           /* F6               */
    uint8  DEV:1;                                          /* DEV              */
} __type1245;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SCMP:22;                                        /* SCMP[21:0]       */
    uint32 :10;                                            /* Reserved Bits    */
} __type1246;
typedef struct 
{                                                          /* Bit Access       */
    uint8  ALM:7;                                          /* ALM[6:0]         */
    uint8  :1;                                             /* Reserved Bits    */
} __type1247;
typedef struct 
{                                                          /* Bit Access       */
    uint8  ALH:6;                                          /* ALH[5:0]         */
    uint8  :2;                                             /* Reserved Bits    */
} __type1248;
typedef struct 
{                                                          /* Bit Access       */
    uint8  ALW:7;                                          /* ALW[6:0]         */
    uint8  :1;                                             /* Reserved Bits    */
} __type1249;
typedef struct 
{                                                          /* Bit Access       */
    uint8  SECC:7;                                         /* SECC[6:0]        */
    uint8  :1;                                             /* Reserved Bits    */
} __type1250;
typedef struct 
{                                                          /* Bit Access       */
    uint8  MINC:7;                                         /* MINC[6:0]        */
    uint8  :1;                                             /* Reserved Bits    */
} __type1251;
typedef struct 
{                                                          /* Bit Access       */
    uint8  HOURC:6;                                        /* HOURC[5:0]       */
    uint8  :2;                                             /* Reserved Bits    */
} __type1252;
typedef struct 
{                                                          /* Bit Access       */
    uint8  WEEKC:3;                                        /* WEEKC[2:0]       */
    uint8  :5;                                             /* Reserved Bits    */
} __type1253;
typedef struct 
{                                                          /* Bit Access       */
    uint8  DAYC:6;                                         /* DAYC[5:0]        */
    uint8  :2;                                             /* Reserved Bits    */
} __type1254;
typedef struct 
{                                                          /* Bit Access       */
    uint8  MONC:5;                                         /* MONC[4:0]        */
    uint8  :3;                                             /* Reserved Bits    */
} __type1255;
typedef struct 
{                                                          /* Bit Access       */
    uint32 SECC:7;                                         /* SECC[6:0]        */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 MINC:7;                                         /* MINC[14:8]       */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 HOURC:6;                                        /* HOURC[21:16]     */
    uint32 :10;                                            /* Reserved Bits    */
} __type1256;
typedef struct 
{                                                          /* Bit Access       */
    uint32 WEEKC:3;                                        /* WEEKC[2:0]       */
    uint32 :5;                                             /* Reserved Bits    */
    uint32 DAYC:6;                                         /* DAYC[13:8]       */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 MONC:5;                                         /* MONC[20:16]      */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 YEARC:8;                                        /* YEARC[31:24]     */
} __type1257;
typedef struct 
{                                                          /* Bit Access       */
    uint16 CSDR:12;                                        /* CSDR[11:0]       */
    uint16 :4;                                             /* Reserved Bits    */
} __type1258;
typedef struct 
{                                                          /* Bit Access       */
    uint16 CRDR:13;                                        /* CRDR[12:0]       */
    uint16 :3;                                             /* Reserved Bits    */
} __type1259;
typedef struct 
{                                                          /* Bit Access       */
    uint16 CTDR:12;                                        /* CTDR[11:0]       */
    uint16 :4;                                             /* Reserved Bits    */
} __type1260;
typedef struct 
{                                                          /* Bit Access       */
    uint8  RDT:1;                                          /* RDT              */
    uint8  :7;                                             /* Reserved Bits    */
} __type1261;
typedef struct 
{                                                          /* Bit Access       */
    uint8  RSF:1;                                          /* RSF              */
    uint8  :7;                                             /* Reserved Bits    */
} __type1262;
typedef struct 
{                                                          /* Bit Access       */
    uint16 CNT:12;                                         /* CNT[11:0]        */
    uint16 :4;                                             /* Reserved Bits    */
} __type1263;
typedef struct 
{                                                          /* Bit Access       */
    uint8  CKS:2;                                          /* CKS[1:0]         */
    uint8  :6;                                             /* Reserved Bits    */
} __type1264;
typedef struct 
{                                                          /* Bit Access       */
    uint16 CSBR:12;                                        /* CSBR[11:0]       */
    uint16 :4;                                             /* Reserved Bits    */
} __type1265;
typedef struct 
{                                                          /* Bit Access       */
    uint16 CRBR:13;                                        /* CRBR[12:0]       */
    uint16 :3;                                             /* Reserved Bits    */
} __type1266;
typedef struct 
{                                                          /* Bit Access       */
    uint16 CTBR:12;                                        /* CTBR[11:0]       */
    uint16 :4;                                             /* Reserved Bits    */
} __type1267;
typedef struct 
{                                                          /* Bit Access       */
    uint16 BRS0:11;                                        /* BRS0[10:0]       */
    uint16 :5;                                             /* Reserved Bits    */
} __type1268;
typedef struct 
{                                                          /* Bit Access       */
    uint16 BRS1:11;                                        /* BRS1[10:0]       */
    uint16 :5;                                             /* Reserved Bits    */
} __type1269;
typedef struct 
{                                                          /* Bit Access       */
    uint16 BRS2:11;                                        /* BRS2[10:0]       */
    uint16 :5;                                             /* Reserved Bits    */
} __type1270;
typedef struct 
{                                                          /* Bit Access       */
    uint16 BRS3:11;                                        /* BRS3[10:0]       */
    uint16 :5;                                             /* Reserved Bits    */
} __type1271;
typedef struct 
{                                                          /* Bit Access       */
    uint8  TE0:1;                                          /* TE0              */
    uint8  TE1:1;                                          /* TE1              */
    uint8  TE2:1;                                          /* TE2              */
    uint8  TE3:1;                                          /* TE3              */
    uint8  :4;                                             /* Reserved Bits    */
} __type1272;
typedef struct 
{                                                          /* Bit Access       */
    uint8  TS0:1;                                          /* TS0              */
    uint8  TS1:1;                                          /* TS1              */
    uint8  TS2:1;                                          /* TS2              */
    uint8  TS3:1;                                          /* TS3              */
    uint8  :4;                                             /* Reserved Bits    */
} __type1273;
typedef struct 
{                                                          /* Bit Access       */
    uint8  TT0:1;                                          /* TT0              */
    uint8  TT1:1;                                          /* TT1              */
    uint8  TT2:1;                                          /* TT2              */
    uint8  TT3:1;                                          /* TT3              */
    uint8  :4;                                             /* Reserved Bits    */
} __type1274;
typedef struct 
{                                                          /* Bit Access       */
    uint8  ENBL:1;                                         /* ENBL             */
    uint8  :7;                                             /* Reserved Bits    */
} __type1275;
typedef struct 
{                                                          /* Bit Access       */
    uint8  QNE:1;                                          /* QNE              */
    uint8  QFL:1;                                          /* QFL              */
    uint8  :6;                                             /* Reserved Bits    */
} __type1276;
typedef struct 
{                                                          /* Bit Access       */
    uint8  CLNE:1;                                         /* CLNE             */
    uint8  CLFL:1;                                         /* CLFL             */
    uint8  :6;                                             /* Reserved Bits    */
} __type1277;
typedef struct 
{                                                          /* Bit Access       */
    uint8  SVSDIS:1;                                       /* SVSDIS           */
    uint8  :7;                                             /* Reserved Bits    */
} __type1278;
typedef struct 
{                                                          /* Bit Access       */
    uint8  QUE0:6;                                         /* QUE0[5:0]        */
    uint8  :2;                                             /* Reserved Bits    */
} __type1279;
typedef struct 
{                                                          /* Bit Access       */
    uint8  QUE1:6;                                         /* QUE1[5:0]        */
    uint8  :2;                                             /* Reserved Bits    */
} __type1280;
typedef struct 
{                                                          /* Bit Access       */
    uint8  QUE2:6;                                         /* QUE2[5:0]        */
    uint8  :2;                                             /* Reserved Bits    */
} __type1281;
typedef struct 
{                                                          /* Bit Access       */
    uint8  QUE3:6;                                         /* QUE3[5:0]        */
    uint8  :2;                                             /* Reserved Bits    */
} __type1282;
typedef struct 
{                                                          /* Bit Access       */
    uint8  QUE4:6;                                         /* QUE4[5:0]        */
    uint8  :2;                                             /* Reserved Bits    */
} __type1283;
typedef struct 
{                                                          /* Bit Access       */
    uint8  QUE5:6;                                         /* QUE5[5:0]        */
    uint8  :2;                                             /* Reserved Bits    */
} __type1284;
typedef struct 
{                                                          /* Bit Access       */
    uint8  QUE6:6;                                         /* QUE6[5:0]        */
    uint8  :2;                                             /* Reserved Bits    */
} __type1285;
typedef struct 
{                                                          /* Bit Access       */
    uint8  QUE7:6;                                         /* QUE7[5:0]        */
    uint8  :2;                                             /* Reserved Bits    */
} __type1286;
typedef struct 
{                                                          /* Bit Access       */
    uint32 VRDT00:8;                                       /* VRDT00[7:0]      */
    uint32 :8;                                             /* Reserved Bits    */
    uint32 VRDT01:8;                                       /* VRDT01[23:16]    */
    uint32 :8;                                             /* Reserved Bits    */
} __type1287;
typedef struct 
{                                                          /* Bit Access       */
    uint32 VRDT02:8;                                       /* VRDT02[7:0]      */
    uint32 :8;                                             /* Reserved Bits    */
    uint32 VRDT03:8;                                       /* VRDT03[23:16]    */
    uint32 :8;                                             /* Reserved Bits    */
} __type1288;
typedef struct 
{                                                          /* Bit Access       */
    uint32 VRDT04:8;                                       /* VRDT04[7:0]      */
    uint32 :8;                                             /* Reserved Bits    */
    uint32 VRDT05:8;                                       /* VRDT05[23:16]    */
    uint32 :8;                                             /* Reserved Bits    */
} __type1289;
typedef struct 
{                                                          /* Bit Access       */
    uint32 VRDT06:8;                                       /* VRDT06[7:0]      */
    uint32 :8;                                             /* Reserved Bits    */
    uint32 VRDT07:8;                                       /* VRDT07[23:16]    */
    uint32 :8;                                             /* Reserved Bits    */
} __type1290;
typedef struct 
{                                                          /* Bit Access       */
    uint32 VRDT08:8;                                       /* VRDT08[7:0]      */
    uint32 :8;                                             /* Reserved Bits    */
    uint32 VRDT09:8;                                       /* VRDT09[23:16]    */
    uint32 :8;                                             /* Reserved Bits    */
} __type1291;
typedef struct 
{                                                          /* Bit Access       */
    uint32 VRDT10:8;                                       /* VRDT10[7:0]      */
    uint32 :8;                                             /* Reserved Bits    */
    uint32 VRDT11:8;                                       /* VRDT11[23:16]    */
    uint32 :8;                                             /* Reserved Bits    */
} __type1292;
typedef struct 
{                                                          /* Bit Access       */
    uint8  OVF:1;                                          /* OVF              */
    uint8  :7;                                             /* Reserved Bits    */
} __type1293;
typedef struct 
{                                                          /* Bit Access       */
    uint8  TE00:1;                                         /* TE00             */
    uint8  TE01:1;                                         /* TE01             */
    uint8  TE02:1;                                         /* TE02             */
    uint8  TE03:1;                                         /* TE03             */
    uint8  :4;                                             /* Reserved Bits    */
} __type1294;
typedef struct 
{                                                          /* Bit Access       */
    uint8  TS00:1;                                         /* TS00             */
    uint8  TS01:1;                                         /* TS01             */
    uint8  TS02:1;                                         /* TS02             */
    uint8  TS03:1;                                         /* TS03             */
    uint8  :4;                                             /* Reserved Bits    */
} __type1295;
typedef struct 
{                                                          /* Bit Access       */
    uint8  TT00:1;                                         /* TT00             */
    uint8  TT01:1;                                         /* TT01             */
    uint8  TT02:1;                                         /* TT02             */
    uint8  TT03:1;                                         /* TT03             */
    uint8  :4;                                             /* Reserved Bits    */
} __type1296;
typedef struct 
{                                                          /* Bit Access       */
    uint8  TO00:1;                                         /* TO00             */
    uint8  TO01:1;                                         /* TO01             */
    uint8  TO02:1;                                         /* TO02             */
    uint8  TO03:1;                                         /* TO03             */
    uint8  :4;                                             /* Reserved Bits    */
} __type1297;
typedef struct 
{                                                          /* Bit Access       */
    uint8  TOE00:1;                                        /* TOE00            */
    uint8  TOE01:1;                                        /* TOE01            */
    uint8  TOE02:1;                                        /* TOE02            */
    uint8  TOE03:1;                                        /* TOE03            */
    uint8  :4;                                             /* Reserved Bits    */
} __type1298;
typedef struct 
{                                                          /* Bit Access       */
    uint8  TOL00:1;                                        /* TOL00            */
    uint8  TOL01:1;                                        /* TOL01            */
    uint8  TOL02:1;                                        /* TOL02            */
    uint8  TOL03:1;                                        /* TOL03            */
    uint8  :4;                                             /* Reserved Bits    */
} __type1299;
typedef struct 
{                                                          /* Bit Access       */
    uint8  RDT00:1;                                        /* RDT00            */
    uint8  RDT01:1;                                        /* RDT01            */
    uint8  RDT02:1;                                        /* RDT02            */
    uint8  RDT03:1;                                        /* RDT03            */
    uint8  :4;                                             /* Reserved Bits    */
} __type1300;
typedef struct 
{                                                          /* Bit Access       */
    uint8  RSF00:1;                                        /* RSF00            */
    uint8  RSF01:1;                                        /* RSF01            */
    uint8  RSF02:1;                                        /* RSF02            */
    uint8  RSF03:1;                                        /* RSF03            */
    uint8  :4;                                             /* Reserved Bits    */
} __type1301;
typedef struct 
{                                                          /* Bit Access       */
    uint16 MD:5;                                           /* MD[4:0]          */
    uint16 :1;                                             /* Reserved Bits    */
    uint16 COS:2;                                          /* COS[7:6]         */
    uint16 STS:3;                                          /* STS[10:8]        */
    uint16 MAS:1;                                          /* MAS              */
    uint16 CCS:2;                                          /* CCS[13:12]       */
    uint16 CKS:2;                                          /* CKS[15:14]       */
} __type1302;
typedef struct 
{                                                          /* Bit Access       */
    uint8  TOM00:1;                                        /* TOM00            */
    uint8  TOM01:1;                                        /* TOM01            */
    uint8  TOM02:1;                                        /* TOM02            */
    uint8  TOM03:1;                                        /* TOM03            */
    uint8  :4;                                             /* Reserved Bits    */
} __type1303;
typedef struct 
{                                                          /* Bit Access       */
    uint8  TOC00:1;                                        /* TOC00            */
    uint8  TOC01:1;                                        /* TOC01            */
    uint8  TOC02:1;                                        /* TOC02            */
    uint8  TOC03:1;                                        /* TOC03            */
    uint8  :4;                                             /* Reserved Bits    */
} __type1304;
typedef struct 
{                                                          /* Bit Access       */
    uint8  RDE00:1;                                        /* RDE00            */
    uint8  RDE01:1;                                        /* RDE01            */
    uint8  RDE02:1;                                        /* RDE02            */
    uint8  RDE03:1;                                        /* RDE03            */
    uint8  :4;                                             /* Reserved Bits    */
} __type1305;
typedef struct 
{                                                          /* Bit Access       */
    uint8  RDM00:1;                                        /* RDM00            */
    uint8  RDM01:1;                                        /* RDM01            */
    uint8  RDM02:1;                                        /* RDM02            */
    uint8  RDM03:1;                                        /* RDM03            */
    uint8  :4;                                             /* Reserved Bits    */
} __type1306;
typedef struct 
{                                                          /* Bit Access       */
    uint8  TO:1;                                           /* TO               */
    uint8  :7;                                             /* Reserved Bits    */
} __type1307;
typedef struct 
{                                                          /* Bit Access       */
    uint8  TE:1;                                           /* TE               */
    uint8  :7;                                             /* Reserved Bits    */
} __type1308;
typedef struct 
{                                                          /* Bit Access       */
    uint8  TS:1;                                           /* TS               */
    uint8  :7;                                             /* Reserved Bits    */
} __type1309;
typedef struct 
{                                                          /* Bit Access       */
    uint8  TT:1;                                           /* TT               */
    uint8  :7;                                             /* Reserved Bits    */
} __type1310;
typedef struct 
{                                                          /* Bit Access       */
    uint8  MD0:1;                                          /* MD0              */
    uint8  MD1:1;                                          /* MD1              */
    uint8  :6;                                             /* Reserved Bits    */
} __type1311;
typedef struct 
{                                                          /* Bit Access       */
    uint8  RUN:8;                                          /* RUN[7:0]         */
} __type1312;
typedef struct 
{                                                          /* Bit Access       */
    uint8  WS:2;                                           /* WS[1:0]          */
    uint8  ERM:1;                                          /* ERM              */
    uint8  WIE:1;                                          /* WIE              */
    uint8  OVF:3;                                          /* OVF[6:4]         */
    uint8  :1;                                             /* Reserved Bits    */
} __type1313;
typedef struct 
{                                                          /* Bit Access       */
    uint32 ZPDU:1;                                         /* ZPDU             */
    uint32 :7;                                             /* Reserved Bits    */
    uint32 GGCE:1;                                         /* GGCE             */
    uint32 :7;                                             /* Reserved Bits    */
    uint32 GGEN:1;                                         /* GGEN             */
    uint32 :7;                                             /* Reserved Bits    */
    uint32 GIERE:6;                                        /* GIERE[29:24]     */
    uint32 GIEDO:1;                                        /* GIEDO            */
    uint32 GIEAD:1;                                        /* GIEAD            */
} __type1314;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CCEN:6;                                         /* CCEN[5:0]        */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 GGCB:1;                                         /* GGCB             */
    uint32 :24;                                            /* Reserved Bits    */
} __type1315;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GGUD:8;                                         /* GGUD[7:0]        */
    uint32 :8;                                             /* Reserved Bits    */
    uint32 GGTB:4;                                         /* GGTB[19:16]      */
    uint32 :12;                                            /* Reserved Bits    */
} __type1316;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GGTR:10;                                        /* GGTR[9:0]        */
    uint32 :22;                                            /* Reserved Bits    */
} __type1317;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GGCS:3;                                         /* GGCS[2:0]        */
    uint32 GGZF:4;                                         /* GGZF[6:3]        */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 GGRV1:4;                                        /* GGRV1[11:8]      */
    uint32 GGRV2:4;                                        /* GGRV2[15:12]     */
    uint32 GGFD:4;                                         /* GGFD[19:16]      */
    uint32 GGFL:4;                                         /* GGFL[23:20]      */
    uint32 :6;                                             /* Reserved Bits    */
    uint32 GGZP:1;                                         /* GGZP             */
    uint32 GGZE:1;                                         /* GGZE             */
} __type1318;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GIPSSRE:6;                                      /* GIPSSRE[5:0]     */
    uint32 GIPSSDO:1;                                      /* GIPSSDO          */
    uint32 GIPSSAD:1;                                      /* GIPSSAD          */
    uint32 :24;                                            /* Reserved Bits    */
} __type1319;
typedef struct 
{                                                          /* Bit Access       */
    uint32 GIPCLRE:6;                                      /* GIPCLRE[5:0]     */
    uint32 GIPCLDO:1;                                      /* GIPCLDO          */
    uint32 GIPCLAD:1;                                      /* GIPCLAD          */
    uint32 :24;                                            /* Reserved Bits    */
} __type1320;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CCCT0:3;                                        /* CCCT0[2:0]       */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 CCCP0:1;                                        /* CCCP0            */
    uint32 CCZP0:1;                                        /* CCZP0            */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 CCDH0:4;                                        /* CCDH0[11:8]      */
    uint32 CCDV0:4;                                        /* CCDV0[15:12]     */
    uint32 CCTL0:7;                                        /* CCTL0[22:16]     */
    uint32 :9;                                             /* Reserved Bits    */
} __type1321;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CCCT1:3;                                        /* CCCT1[2:0]       */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 CCCP1:1;                                        /* CCCP1            */
    uint32 CCZP1:1;                                        /* CCZP1            */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 CCDH1:4;                                        /* CCDH1[11:8]      */
    uint32 CCDV1:4;                                        /* CCDV1[15:12]     */
    uint32 CCTL1:7;                                        /* CCTL1[22:16]     */
    uint32 :9;                                             /* Reserved Bits    */
} __type1322;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CCCT2:3;                                        /* CCCT2[2:0]       */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 CCCP2:1;                                        /* CCCP2            */
    uint32 CCZP2:1;                                        /* CCZP2            */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 CCDH2:4;                                        /* CCDH2[11:8]      */
    uint32 CCDV2:4;                                        /* CCDV2[15:12]     */
    uint32 CCTL2:7;                                        /* CCTL2[22:16]     */
    uint32 :9;                                             /* Reserved Bits    */
} __type1323;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CCCT3:3;                                        /* CCCT3[2:0]       */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 CCCP3:1;                                        /* CCCP3            */
    uint32 CCZP3:1;                                        /* CCZP3            */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 CCDH3:4;                                        /* CCDH3[11:8]      */
    uint32 CCDV3:4;                                        /* CCDV3[15:12]     */
    uint32 CCTL3:7;                                        /* CCTL3[22:16]     */
    uint32 :9;                                             /* Reserved Bits    */
} __type1324;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CCCT4:3;                                        /* CCCT4[2:0]       */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 CCCP4:1;                                        /* CCCP4            */
    uint32 CCZP4:1;                                        /* CCZP4            */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 CCDH4:4;                                        /* CCDH4[11:8]      */
    uint32 CCDV4:4;                                        /* CCDV4[15:12]     */
    uint32 CCTL4:7;                                        /* CCTL4[22:16]     */
    uint32 :9;                                             /* Reserved Bits    */
} __type1325;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CCCT5:3;                                        /* CCCT5[2:0]       */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 CCCP5:1;                                        /* CCCP5            */
    uint32 CCZP5:1;                                        /* CCZP5            */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 CCDH5:4;                                        /* CCDH5[11:8]      */
    uint32 CCDV5:4;                                        /* CCDV5[15:12]     */
    uint32 CCTL5:7;                                        /* CCTL5[22:16]     */
    uint32 :9;                                             /* Reserved Bits    */
} __type1326;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CCZC0:7;                                        /* CCZC0[6:0]       */
    uint32 :25;                                            /* Reserved Bits    */
} __type1327;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CCZC1:7;                                        /* CCZC1[6:0]       */
    uint32 :25;                                            /* Reserved Bits    */
} __type1328;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CCZC2:7;                                        /* CCZC2[6:0]       */
    uint32 :25;                                            /* Reserved Bits    */
} __type1329;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CCZC3:7;                                        /* CCZC3[6:0]       */
    uint32 :25;                                            /* Reserved Bits    */
} __type1330;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CCZC4:7;                                        /* CCZC4[6:0]       */
    uint32 :25;                                            /* Reserved Bits    */
} __type1331;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CCZC5:7;                                        /* CCZC5[6:0]       */
    uint32 :25;                                            /* Reserved Bits    */
} __type1332;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CCVP0:10;                                       /* CCVP0[9:0]       */
    uint32 CCHP0:10;                                       /* CCHP0[19:10]     */
    uint32 CCQI0:2;                                        /* CCQI0[21:20]     */
    uint32 :10;                                            /* Reserved Bits    */
} __type1333;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CCVP1:10;                                       /* CCVP1[9:0]       */
    uint32 CCHP1:10;                                       /* CCHP1[19:10]     */
    uint32 CCQI1:2;                                        /* CCQI1[21:20]     */
    uint32 :10;                                            /* Reserved Bits    */
} __type1334;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CCVP2:10;                                       /* CCVP2[9:0]       */
    uint32 CCHP2:10;                                       /* CCHP2[19:10]     */
    uint32 CCQI2:2;                                        /* CCQI2[21:20]     */
    uint32 :10;                                            /* Reserved Bits    */
} __type1335;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CCVP3:10;                                       /* CCVP3[9:0]       */
    uint32 CCHP3:10;                                       /* CCHP3[19:10]     */
    uint32 CCQI3:2;                                        /* CCQI3[21:20]     */
    uint32 :10;                                            /* Reserved Bits    */
} __type1336;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CCVP4:10;                                       /* CCVP4[9:0]       */
    uint32 CCHP4:10;                                       /* CCHP4[19:10]     */
    uint32 CCQI4:2;                                        /* CCQI4[21:20]     */
    uint32 :10;                                            /* Reserved Bits    */
} __type1337;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CCVP5:10;                                       /* CCVP5[9:0]       */
    uint32 CCHP5:10;                                       /* CCHP5[19:10]     */
    uint32 CCQI5:2;                                        /* CCQI5[21:20]     */
    uint32 :10;                                            /* Reserved Bits    */
} __type1338;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CCZD0:5;                                        /* CCZD0[4:0]       */
    uint32 :27;                                            /* Reserved Bits    */
} __type1339;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CCZD1:5;                                        /* CCZD1[4:0]       */
    uint32 :27;                                            /* Reserved Bits    */
} __type1340;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CCZD2:5;                                        /* CCZD2[4:0]       */
    uint32 :27;                                            /* Reserved Bits    */
} __type1341;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CCZD3:5;                                        /* CCZD3[4:0]       */
    uint32 :27;                                            /* Reserved Bits    */
} __type1342;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CCZD4:5;                                        /* CCZD4[4:0]       */
    uint32 :27;                                            /* Reserved Bits    */
} __type1343;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CCZD5:5;                                        /* CCZD5[4:0]       */
    uint32 :27;                                            /* Reserved Bits    */
} __type1344;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CIVD0:4;                                        /* CIVD0[3:0]       */
    uint32 :6;                                             /* Reserved Bits    */
    uint32 CIHD0:4;                                        /* CIHD0[13:10]     */
    uint32 :8;                                             /* Reserved Bits    */
    uint32 CIVR0:1;                                        /* CIVR0            */
    uint32 CIHR0:1;                                        /* CIHR0            */
    uint32 CIVE0:1;                                        /* CIVE0            */
    uint32 CIHE0:1;                                        /* CIHE0            */
    uint32 :6;                                             /* Reserved Bits    */
} __type1345;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CIVD1:4;                                        /* CIVD1[3:0]       */
    uint32 :6;                                             /* Reserved Bits    */
    uint32 CIHD1:4;                                        /* CIHD1[13:10]     */
    uint32 :8;                                             /* Reserved Bits    */
    uint32 CIVR1:1;                                        /* CIVR1            */
    uint32 CIHR1:1;                                        /* CIHR1            */
    uint32 CIVE1:1;                                        /* CIVE1            */
    uint32 CIHE1:1;                                        /* CIHE1            */
    uint32 :6;                                             /* Reserved Bits    */
} __type1346;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CIVD2:4;                                        /* CIVD2[3:0]       */
    uint32 :6;                                             /* Reserved Bits    */
    uint32 CIHD2:4;                                        /* CIHD2[13:10]     */
    uint32 :8;                                             /* Reserved Bits    */
    uint32 CIVR2:1;                                        /* CIVR2            */
    uint32 CIHR2:1;                                        /* CIHR2            */
    uint32 CIVE2:1;                                        /* CIVE2            */
    uint32 CIHE2:1;                                        /* CIHE2            */
    uint32 :6;                                             /* Reserved Bits    */
} __type1347;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CIVD3:4;                                        /* CIVD3[3:0]       */
    uint32 :6;                                             /* Reserved Bits    */
    uint32 CIHD3:4;                                        /* CIHD3[13:10]     */
    uint32 :8;                                             /* Reserved Bits    */
    uint32 CIVR3:1;                                        /* CIVR3            */
    uint32 CIHR3:1;                                        /* CIHR3            */
    uint32 CIVE3:1;                                        /* CIVE3            */
    uint32 CIHE3:1;                                        /* CIHE3            */
    uint32 :6;                                             /* Reserved Bits    */
} __type1348;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CIVD4:4;                                        /* CIVD4[3:0]       */
    uint32 :6;                                             /* Reserved Bits    */
    uint32 CIHD4:4;                                        /* CIHD4[13:10]     */
    uint32 :8;                                             /* Reserved Bits    */
    uint32 CIVR4:1;                                        /* CIVR4            */
    uint32 CIHR4:1;                                        /* CIHR4            */
    uint32 CIVE4:1;                                        /* CIVE4            */
    uint32 CIHE4:1;                                        /* CIHE4            */
    uint32 :6;                                             /* Reserved Bits    */
} __type1349;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CIVD5:4;                                        /* CIVD5[3:0]       */
    uint32 :6;                                             /* Reserved Bits    */
    uint32 CIHD5:4;                                        /* CIHD5[13:10]     */
    uint32 :8;                                             /* Reserved Bits    */
    uint32 CIVR5:1;                                        /* CIVR5            */
    uint32 CIHR5:1;                                        /* CIHR5            */
    uint32 CIVE5:1;                                        /* CIVE5            */
    uint32 CIHE5:1;                                        /* CIHE5            */
    uint32 :6;                                             /* Reserved Bits    */
} __type1350;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CIRS:6;                                         /* CIRS[5:0]        */
    uint32 :26;                                            /* Reserved Bits    */
} __type1351;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CZMT:6;                                         /* CZMT[5:0]        */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 CZIS0:2;                                        /* CZIS0[9:8]       */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 CZIS1:2;                                        /* CZIS1[13:12]     */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 CZIS2:2;                                        /* CZIS2[17:16]     */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 CZIS3:2;                                        /* CZIS3[21:20]     */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 CZIS4:2;                                        /* CZIS4[25:24]     */
    uint32 :2;                                             /* Reserved Bits    */
    uint32 CZIS5:2;                                        /* CZIS5[29:28]     */
    uint32 :2;                                             /* Reserved Bits    */
} __type1352;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CZRS:6;                                         /* CZRS[5:0]        */
    uint32 :26;                                            /* Reserved Bits    */
} __type1353;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CZDR:6;                                         /* CZDR[5:0]        */
    uint32 :26;                                            /* Reserved Bits    */
} __type1354;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CZIP:6;                                         /* CZIP[5:0]        */
    uint32 :26;                                            /* Reserved Bits    */
} __type1355;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CCLZP:6;                                        /* CCLZP[5:0]       */
    uint32 :26;                                            /* Reserved Bits    */
} __type1356;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CZBT0:16;                                       /* CZBT0[15:0]      */
    uint32 :15;                                            /* Reserved Bits    */
    uint32 CZSS0:1;                                        /* CZSS0            */
} __type1357;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CZBT1:16;                                       /* CZBT1[15:0]      */
    uint32 :15;                                            /* Reserved Bits    */
    uint32 CZSS1:1;                                        /* CZSS1            */
} __type1358;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CZBT2:16;                                       /* CZBT2[15:0]      */
    uint32 :15;                                            /* Reserved Bits    */
    uint32 CZSS2:1;                                        /* CZSS2            */
} __type1359;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CZBT3:16;                                       /* CZBT3[15:0]      */
    uint32 :15;                                            /* Reserved Bits    */
    uint32 CZSS3:1;                                        /* CZSS3            */
} __type1360;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CZBT4:16;                                       /* CZBT4[15:0]      */
    uint32 :15;                                            /* Reserved Bits    */
    uint32 CZSS4:1;                                        /* CZSS4            */
} __type1361;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CZBT5:16;                                       /* CZBT5[15:0]      */
    uint32 :15;                                            /* Reserved Bits    */
    uint32 CZSS5:1;                                        /* CZSS5            */
} __type1362;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CZAF0:1;                                        /* CZAF0            */
    uint32 CZAF1:1;                                        /* CZAF1            */
    uint32 CZAF2:1;                                        /* CZAF2            */
    uint32 CZAF3:1;                                        /* CZAF3            */
    uint32 CZAF4:1;                                        /* CZAF4            */
    uint32 CZAF5:1;                                        /* CZAF5            */
    uint32 :26;                                            /* Reserved Bits    */
} __type1363;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPMP0:8;                                        /* FPMP0[7:0]       */
    uint32 IPMP0:16;                                       /* IPMP0[23:8]      */
    uint32 SPMP0:1;                                        /* SPMP0            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1364;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPDF0:3;                                        /* FPDF0[2:0]       */
    uint32 :29;                                            /* Reserved Bits    */
} __type1365;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPAL0:8;                                        /* FPAL0[7:0]       */
    uint32 IPAL0:16;                                       /* IPAL0[23:8]      */
    uint32 SPAL0:1;                                        /* SPAL0            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1366;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPDL0:8;                                        /* FPDL0[7:0]       */
    uint32 IPDL0:16;                                       /* IPDL0[23:8]      */
    uint32 SPDL0:1;                                        /* SPDL0            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1367;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPMS0:8;                                        /* FPMS0[7:0]       */
    uint32 IPMS0:16;                                       /* IPMS0[23:8]      */
    uint32 SPMS0:1;                                        /* SPMS0            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1368;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPHC0:8;                                        /* FPHC0[7:0]       */
    uint32 IPHC0:16;                                       /* IPHC0[23:8]      */
    uint32 SPHC0:1;                                        /* SPHC0            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1369;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPS10:8;                                        /* FPS10[7:0]       */
    uint32 IPS10:16;                                       /* IPS10[23:8]      */
    uint32 SPS10:1;                                        /* SPS10            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1370;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPS20:8;                                        /* FPS20[7:0]       */
    uint32 IPS20:16;                                       /* IPS20[23:8]      */
    uint32 SPS20:1;                                        /* SPS20            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1371;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPS30:8;                                        /* FPS30[7:0]       */
    uint32 IPS30:16;                                       /* IPS30[23:8]      */
    uint32 SPS30:1;                                        /* SPS30            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1372;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPS40:8;                                        /* FPS40[7:0]       */
    uint32 IPS40:16;                                       /* IPS40[23:8]      */
    uint32 SPS40:1;                                        /* SPS40            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1373;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPMP1:8;                                        /* FPMP1[7:0]       */
    uint32 IPMP1:16;                                       /* IPMP1[23:8]      */
    uint32 SPMP1:1;                                        /* SPMP1            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1374;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPDF1:3;                                        /* FPDF1[2:0]       */
    uint32 :29;                                            /* Reserved Bits    */
} __type1375;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPAL1:8;                                        /* FPAL1[7:0]       */
    uint32 IPAL1:16;                                       /* IPAL1[23:8]      */
    uint32 SPAL1:1;                                        /* SPAL1            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1376;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPDL1:8;                                        /* FPDL1[7:0]       */
    uint32 IPDL1:16;                                       /* IPDL1[23:8]      */
    uint32 SPDL1:1;                                        /* SPDL1            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1377;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPMS1:8;                                        /* FPMS1[7:0]       */
    uint32 IPMS1:16;                                       /* IPMS1[23:8]      */
    uint32 SPMS1:1;                                        /* SPMS1            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1378;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPHC1:8;                                        /* FPHC1[7:0]       */
    uint32 IPHC1:16;                                       /* IPHC1[23:8]      */
    uint32 SPHC1:1;                                        /* SPHC1            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1379;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPS11:8;                                        /* FPS11[7:0]       */
    uint32 IPS11:16;                                       /* IPS11[23:8]      */
    uint32 SPS11:1;                                        /* SPS11            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1380;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPS21:8;                                        /* FPS21[7:0]       */
    uint32 IPS21:16;                                       /* IPS21[23:8]      */
    uint32 SPS21:1;                                        /* SPS21            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1381;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPS31:8;                                        /* FPS31[7:0]       */
    uint32 IPS31:16;                                       /* IPS31[23:8]      */
    uint32 SPS31:1;                                        /* SPS31            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1382;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPS41:8;                                        /* FPS41[7:0]       */
    uint32 IPS41:16;                                       /* IPS41[23:8]      */
    uint32 SPS41:1;                                        /* SPS41            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1383;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPMP2:8;                                        /* FPMP2[7:0]       */
    uint32 IPMP2:16;                                       /* IPMP2[23:8]      */
    uint32 SPMP2:1;                                        /* SPMP2            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1384;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPDF2:3;                                        /* FPDF2[2:0]       */
    uint32 :29;                                            /* Reserved Bits    */
} __type1385;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPAL2:8;                                        /* FPAL2[7:0]       */
    uint32 IPAL2:16;                                       /* IPAL2[23:8]      */
    uint32 SPAL2:1;                                        /* SPAL2            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1386;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPDL2:8;                                        /* FPDL2[7:0]       */
    uint32 IPDL2:16;                                       /* IPDL2[23:8]      */
    uint32 SPDL2:1;                                        /* SPDL2            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1387;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPMS2:8;                                        /* FPMS2[7:0]       */
    uint32 IPMS2:16;                                       /* IPMS2[23:8]      */
    uint32 SPMS2:1;                                        /* SPMS2            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1388;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPHC2:8;                                        /* FPHC2[7:0]       */
    uint32 IPHC2:16;                                       /* IPHC2[23:8]      */
    uint32 SPHC2:1;                                        /* SPHC2            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1389;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPS12:8;                                        /* FPS12[7:0]       */
    uint32 IPS12:16;                                       /* IPS12[23:8]      */
    uint32 SPS12:1;                                        /* SPS12            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1390;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPS22:8;                                        /* FPS22[7:0]       */
    uint32 IPS22:16;                                       /* IPS22[23:8]      */
    uint32 SPS22:1;                                        /* SPS22            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1391;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPS32:8;                                        /* FPS32[7:0]       */
    uint32 IPS32:16;                                       /* IPS32[23:8]      */
    uint32 SPS32:1;                                        /* SPS32            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1392;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPS42:8;                                        /* FPS42[7:0]       */
    uint32 IPS42:16;                                       /* IPS42[23:8]      */
    uint32 SPS42:1;                                        /* SPS42            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1393;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPMP3:8;                                        /* FPMP3[7:0]       */
    uint32 IPMP3:16;                                       /* IPMP3[23:8]      */
    uint32 SPMP3:1;                                        /* SPMP3            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1394;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPDF3:3;                                        /* FPDF3[2:0]       */
    uint32 :29;                                            /* Reserved Bits    */
} __type1395;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPAL3:8;                                        /* FPAL3[7:0]       */
    uint32 IPAL3:16;                                       /* IPAL3[23:8]      */
    uint32 SPAL3:1;                                        /* SPAL3            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1396;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPDL3:8;                                        /* FPDL3[7:0]       */
    uint32 IPDL3:16;                                       /* IPDL3[23:8]      */
    uint32 SPDL3:1;                                        /* SPDL3            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1397;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPMS3:8;                                        /* FPMS3[7:0]       */
    uint32 IPMS3:16;                                       /* IPMS3[23:8]      */
    uint32 SPMS3:1;                                        /* SPMS3            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1398;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPHC3:8;                                        /* FPHC3[7:0]       */
    uint32 IPHC3:16;                                       /* IPHC3[23:8]      */
    uint32 SPHC3:1;                                        /* SPHC3            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1399;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPS13:8;                                        /* FPS13[7:0]       */
    uint32 IPS13:16;                                       /* IPS13[23:8]      */
    uint32 SPS13:1;                                        /* SPS13            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1400;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPS23:8;                                        /* FPS23[7:0]       */
    uint32 IPS23:16;                                       /* IPS23[23:8]      */
    uint32 SPS23:1;                                        /* SPS23            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1401;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPS33:8;                                        /* FPS33[7:0]       */
    uint32 IPS33:16;                                       /* IPS33[23:8]      */
    uint32 SPS33:1;                                        /* SPS33            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1402;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPS43:8;                                        /* FPS43[7:0]       */
    uint32 IPS43:16;                                       /* IPS43[23:8]      */
    uint32 SPS43:1;                                        /* SPS43            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1403;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPMP4:8;                                        /* FPMP4[7:0]       */
    uint32 IPMP4:16;                                       /* IPMP4[23:8]      */
    uint32 SPMP4:1;                                        /* SPMP4            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1404;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPDF4:3;                                        /* FPDF4[2:0]       */
    uint32 :29;                                            /* Reserved Bits    */
} __type1405;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPAL4:8;                                        /* FPAL4[7:0]       */
    uint32 IPAL4:16;                                       /* IPAL4[23:8]      */
    uint32 SPAL4:1;                                        /* SPAL4            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1406;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPDL4:8;                                        /* FPDL4[7:0]       */
    uint32 IPDL4:16;                                       /* IPDL4[23:8]      */
    uint32 SPDL4:1;                                        /* SPDL4            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1407;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPMS4:8;                                        /* FPMS4[7:0]       */
    uint32 IPMS4:16;                                       /* IPMS4[23:8]      */
    uint32 SPMS4:1;                                        /* SPMS4            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1408;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPHC4:8;                                        /* FPHC4[7:0]       */
    uint32 IPHC4:16;                                       /* IPHC4[23:8]      */
    uint32 SPHC4:1;                                        /* SPHC4            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1409;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPS14:8;                                        /* FPS14[7:0]       */
    uint32 IPS14:16;                                       /* IPS14[23:8]      */
    uint32 SPS14:1;                                        /* SPS14            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1410;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPS24:8;                                        /* FPS24[7:0]       */
    uint32 IPS24:16;                                       /* IPS24[23:8]      */
    uint32 SPS24:1;                                        /* SPS24            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1411;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPS34:8;                                        /* FPS34[7:0]       */
    uint32 IPS34:16;                                       /* IPS34[23:8]      */
    uint32 SPS34:1;                                        /* SPS34            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1412;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPS44:8;                                        /* FPS44[7:0]       */
    uint32 IPS44:16;                                       /* IPS44[23:8]      */
    uint32 SPS44:1;                                        /* SPS44            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1413;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPMP5:8;                                        /* FPMP5[7:0]       */
    uint32 IPMP5:16;                                       /* IPMP5[23:8]      */
    uint32 SPMP5:1;                                        /* SPMP5            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1414;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPDF5:3;                                        /* FPDF5[2:0]       */
    uint32 :29;                                            /* Reserved Bits    */
} __type1415;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPAL5:8;                                        /* FPAL5[7:0]       */
    uint32 IPAL5:16;                                       /* IPAL5[23:8]      */
    uint32 SPAL5:1;                                        /* SPAL5            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1416;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPDL5:8;                                        /* FPDL5[7:0]       */
    uint32 IPDL5:16;                                       /* IPDL5[23:8]      */
    uint32 SPDL5:1;                                        /* SPDL5            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1417;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPMS5:8;                                        /* FPMS5[7:0]       */
    uint32 IPMS5:16;                                       /* IPMS5[23:8]      */
    uint32 SPMS5:1;                                        /* SPMS5            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1418;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPHC5:8;                                        /* FPHC5[7:0]       */
    uint32 IPHC5:16;                                       /* IPHC5[23:8]      */
    uint32 SPHC5:1;                                        /* SPHC5            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1419;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPS15:8;                                        /* FPS15[7:0]       */
    uint32 IPS15:16;                                       /* IPS15[23:8]      */
    uint32 SPS15:1;                                        /* SPS15            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1420;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPS25:8;                                        /* FPS25[7:0]       */
    uint32 IPS25:16;                                       /* IPS25[23:8]      */
    uint32 SPS25:1;                                        /* SPS25            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1421;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPS35:8;                                        /* FPS35[7:0]       */
    uint32 IPS35:16;                                       /* IPS35[23:8]      */
    uint32 SPS35:1;                                        /* SPS35            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1422;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FPS45:8;                                        /* FPS45[7:0]       */
    uint32 IPS45:16;                                       /* IPS45[23:8]      */
    uint32 SPS45:1;                                        /* SPS45            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1423;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FVAX0:8;                                        /* FVAX0[7:0]       */
    uint32 IVAX0:16;                                       /* IVAX0[23:8]      */
    uint32 SVAX0:1;                                        /* SVAX0            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1424;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FVAS0:8;                                        /* FVAS0[7:0]       */
    uint32 IVAS0:16;                                       /* IVAS0[23:8]      */
    uint32 SVAS0:1;                                        /* SVAS0            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1425;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FVPS0:8;                                        /* FVPS0[7:0]       */
    uint32 IVPS0:16;                                       /* IVPS0[23:8]      */
    uint32 SVPS0:1;                                        /* SVPS0            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1426;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FVPT0:8;                                        /* FVPT0[7:0]       */
    uint32 IVPT0:16;                                       /* IVPT0[23:8]      */
    uint32 SVPT0:1;                                        /* SVPT0            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1427;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FVAP0:8;                                        /* FVAP0[7:0]       */
    uint32 IVAP0:16;                                       /* IVAP0[23:8]      */
    uint32 SVAP0:1;                                        /* SVAP0            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1428;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FVVP0:8;                                        /* FVVP0[7:0]       */
    uint32 IVVP0:16;                                       /* IVVP0[23:8]      */
    uint32 SVVP0:1;                                        /* SVVP0            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1429;
typedef struct 
{                                                          /* Bit Access       */
    uint32 VVSP0:1;                                        /* VVSP0            */
    uint32 VVDR0:1;                                        /* VVDR0            */
    uint32 :30;                                            /* Reserved Bits    */
} __type1430;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FVAX1:8;                                        /* FVAX1[7:0]       */
    uint32 IVAX1:16;                                       /* IVAX1[23:8]      */
    uint32 SVAX1:1;                                        /* SVAX1            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1431;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FVAS1:8;                                        /* FVAS1[7:0]       */
    uint32 IVAS1:16;                                       /* IVAS1[23:8]      */
    uint32 SVAS1:1;                                        /* SVAS1            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1432;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FVPS1:8;                                        /* FVPS1[7:0]       */
    uint32 IVPS1:16;                                       /* IVPS1[23:8]      */
    uint32 SVPS1:1;                                        /* SVPS1            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1433;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FVPT1:8;                                        /* FVPT1[7:0]       */
    uint32 IVPT1:16;                                       /* IVPT1[23:8]      */
    uint32 SVPT1:1;                                        /* SVPT1            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1434;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FVAP1:8;                                        /* FVAP1[7:0]       */
    uint32 IVAP1:16;                                       /* IVAP1[23:8]      */
    uint32 SVAP1:1;                                        /* SVAP1            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1435;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FVVP1:8;                                        /* FVVP1[7:0]       */
    uint32 IVVP1:16;                                       /* IVVP1[23:8]      */
    uint32 SVVP1:1;                                        /* SVVP1            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1436;
typedef struct 
{                                                          /* Bit Access       */
    uint32 VVSP1:1;                                        /* VVSP1            */
    uint32 VVDR1:1;                                        /* VVDR1            */
    uint32 :30;                                            /* Reserved Bits    */
} __type1437;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FVAX2:8;                                        /* FVAX2[7:0]       */
    uint32 IVAX2:16;                                       /* IVAX2[23:8]      */
    uint32 SVAX2:1;                                        /* SVAX2            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1438;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FVAS2:8;                                        /* FVAS2[7:0]       */
    uint32 IVAS2:16;                                       /* IVAS2[23:8]      */
    uint32 SVAS2:1;                                        /* SVAS2            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1439;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FVPS2:8;                                        /* FVPS2[7:0]       */
    uint32 IVPS2:16;                                       /* IVPS2[23:8]      */
    uint32 SVPS2:1;                                        /* SVPS2            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1440;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FVPT2:8;                                        /* FVPT2[7:0]       */
    uint32 IVPT2:16;                                       /* IVPT2[23:8]      */
    uint32 SVPT2:1;                                        /* SVPT2            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1441;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FVAP2:8;                                        /* FVAP2[7:0]       */
    uint32 IVAP2:16;                                       /* IVAP2[23:8]      */
    uint32 SVAP2:1;                                        /* SVAP2            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1442;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FVVP2:8;                                        /* FVVP2[7:0]       */
    uint32 IVVP2:16;                                       /* IVVP2[23:8]      */
    uint32 SVVP2:1;                                        /* SVVP2            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1443;
typedef struct 
{                                                          /* Bit Access       */
    uint32 VVSP2:1;                                        /* VVSP2            */
    uint32 VVDR2:1;                                        /* VVDR2            */
    uint32 :30;                                            /* Reserved Bits    */
} __type1444;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FVAX3:8;                                        /* FVAX3[7:0]       */
    uint32 IVAX3:16;                                       /* IVAX3[23:8]      */
    uint32 SVAX3:1;                                        /* SVAX3            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1445;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FVAS3:8;                                        /* FVAS3[7:0]       */
    uint32 IVAS3:16;                                       /* IVAS3[23:8]      */
    uint32 SVAS3:1;                                        /* SVAS3            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1446;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FVPS3:8;                                        /* FVPS3[7:0]       */
    uint32 IVPS3:16;                                       /* IVPS3[23:8]      */
    uint32 SVPS3:1;                                        /* SVPS3            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1447;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FVPT3:8;                                        /* FVPT3[7:0]       */
    uint32 IVPT3:16;                                       /* IVPT3[23:8]      */
    uint32 SVPT3:1;                                        /* SVPT3            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1448;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FVAP3:8;                                        /* FVAP3[7:0]       */
    uint32 IVAP3:16;                                       /* IVAP3[23:8]      */
    uint32 SVAP3:1;                                        /* SVAP3            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1449;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FVVP3:8;                                        /* FVVP3[7:0]       */
    uint32 IVVP3:16;                                       /* IVVP3[23:8]      */
    uint32 SVVP3:1;                                        /* SVVP3            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1450;
typedef struct 
{                                                          /* Bit Access       */
    uint32 VVSP3:1;                                        /* VVSP3            */
    uint32 VVDR3:1;                                        /* VVDR3            */
    uint32 :30;                                            /* Reserved Bits    */
} __type1451;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FVAX4:8;                                        /* FVAX4[7:0]       */
    uint32 IVAX4:16;                                       /* IVAX4[23:8]      */
    uint32 SVAX4:1;                                        /* SVAX4            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1452;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FVAS4:8;                                        /* FVAS4[7:0]       */
    uint32 IVAS4:16;                                       /* IVAS4[23:8]      */
    uint32 SVAS4:1;                                        /* SVAS4            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1453;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FVPS4:8;                                        /* FVPS4[7:0]       */
    uint32 IVPS4:16;                                       /* IVPS4[23:8]      */
    uint32 SVPS4:1;                                        /* SVPS4            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1454;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FVPT4:8;                                        /* FVPT4[7:0]       */
    uint32 IVPT4:16;                                       /* IVPT4[23:8]      */
    uint32 SVPT4:1;                                        /* SVPT4            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1455;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FVAP4:8;                                        /* FVAP4[7:0]       */
    uint32 IVAP4:16;                                       /* IVAP4[23:8]      */
    uint32 SVAP4:1;                                        /* SVAP4            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1456;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FVVP4:8;                                        /* FVVP4[7:0]       */
    uint32 IVVP4:16;                                       /* IVVP4[23:8]      */
    uint32 SVVP4:1;                                        /* SVVP4            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1457;
typedef struct 
{                                                          /* Bit Access       */
    uint32 VVSP4:1;                                        /* VVSP4            */
    uint32 VVDR4:1;                                        /* VVDR4            */
    uint32 :30;                                            /* Reserved Bits    */
} __type1458;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FVAX5:8;                                        /* FVAX5[7:0]       */
    uint32 IVAX5:16;                                       /* IVAX5[23:8]      */
    uint32 SVAX5:1;                                        /* SVAX5            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1459;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FVAS5:8;                                        /* FVAS5[7:0]       */
    uint32 IVAS5:16;                                       /* IVAS5[23:8]      */
    uint32 SVAS5:1;                                        /* SVAS5            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1460;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FVPS5:8;                                        /* FVPS5[7:0]       */
    uint32 IVPS5:16;                                       /* IVPS5[23:8]      */
    uint32 SVPS5:1;                                        /* SVPS5            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1461;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FVPT5:8;                                        /* FVPT5[7:0]       */
    uint32 IVPT5:16;                                       /* IVPT5[23:8]      */
    uint32 SVPT5:1;                                        /* SVPT5            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1462;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FVAP5:8;                                        /* FVAP5[7:0]       */
    uint32 IVAP5:16;                                       /* IVAP5[23:8]      */
    uint32 SVAP5:1;                                        /* SVAP5            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1463;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FVVP5:8;                                        /* FVVP5[7:0]       */
    uint32 IVVP5:16;                                       /* IVVP5[23:8]      */
    uint32 SVVP5:1;                                        /* SVVP5            */
    uint32 :7;                                             /* Reserved Bits    */
} __type1464;
typedef struct 
{                                                          /* Bit Access       */
    uint32 VVSP5:1;                                        /* VVSP5            */
    uint32 VVDR5:1;                                        /* VVDR5            */
    uint32 :30;                                            /* Reserved Bits    */
} __type1465;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :7;                                             /* Reserved Bits    */
    uint32 SVDIS:1;                                        /* SVDIS            */
    uint32 :24;                                            /* Reserved Bits    */
} __type1466;
typedef struct 
{                                                          /* Bit Access       */
    uint32 ENAB:1;                                         /* ENAB             */
    uint32 MODE:1;                                         /* MODE             */
    uint32 STEREO:1;                                       /* STEREO           */
    uint32 DOM:1;                                          /* DOM              */
    uint32 :28;                                            /* Reserved Bits    */
} __type1467;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TPWM:16;                                        /* TPWM[15:0]       */
    uint32 :16;                                            /* Reserved Bits    */
} __type1468;
typedef struct 
{                                                          /* Bit Access       */
    uint32 INVAP0:1;                                       /* INVAP0           */
    uint32 INVAN0:1;                                       /* INVAN0           */
    uint32 INVBP0:1;                                       /* INVBP0           */
    uint32 INVBN0:1;                                       /* INVBN0           */
    uint32 :4;                                             /* Reserved Bits    */
    uint32 INVAP1:1;                                       /* INVAP1           */
    uint32 INVAN1:1;                                       /* INVAN1           */
    uint32 INVBP1:1;                                       /* INVBP1           */
    uint32 INVBN1:1;                                       /* INVBN1           */
    uint32 :20;                                            /* Reserved Bits    */
} __type1469;
typedef struct 
{                                                          /* Bit Access       */
    uint32 STLVAP0:1;                                      /* STLVAP0          */
    uint32 STLVAN0:1;                                      /* STLVAN0          */
    uint32 STLVBP0:1;                                      /* STLVBP0          */
    uint32 STLVBN0:1;                                      /* STLVBN0          */
    uint32 :4;                                             /* Reserved Bits    */
    uint32 STLVAP1:1;                                      /* STLVAP1          */
    uint32 STLVAN1:1;                                      /* STLVAN1          */
    uint32 STLVBP1:1;                                      /* STLVBP1          */
    uint32 STLVBN1:1;                                      /* STLVBN1          */
    uint32 :20;                                            /* Reserved Bits    */
} __type1470;
typedef struct 
{                                                          /* Bit Access       */
    uint32 STENAP0:1;                                      /* STENAP0          */
    uint32 STENAN0:1;                                      /* STENAN0          */
    uint32 STENBP0:1;                                      /* STENBP0          */
    uint32 STENBN0:1;                                      /* STENBN0          */
    uint32 :4;                                             /* Reserved Bits    */
    uint32 STENAP1:1;                                      /* STENAP1          */
    uint32 STENAN1:1;                                      /* STENAN1          */
    uint32 STENBP1:1;                                      /* STENBP1          */
    uint32 STENBN1:1;                                      /* STENBN1          */
    uint32 :20;                                            /* Reserved Bits    */
} __type1471;
typedef struct 
{                                                          /* Bit Access       */
    uint32 OFFS:16;                                        /* OFFS[15:0]       */
    uint32 :16;                                            /* Reserved Bits    */
} __type1472;
typedef struct 
{                                                          /* Bit Access       */
    uint32 AUSR:16;                                        /* AUSR[15:0]       */
    uint32 AUSL:16;                                        /* AUSL[31:16]      */
} __type1473;
typedef struct 
{                                                          /* Bit Access       */
    uint32 UR:1;                                           /* UR               */
    uint32 OV:1;                                           /* OV               */
    uint32 :12;                                            /* Reserved Bits    */
    uint32 FIFO:2;                                         /* FIFO[15:14]      */
    uint32 :16;                                            /* Reserved Bits    */
} __type1474;
typedef struct 
{                                                          /* Bit Access       */
    uint32 URC:1;                                          /* URC              */
    uint32 OVC:1;                                          /* OVC              */
    uint32 :30;                                            /* Reserved Bits    */
} __type1475;
typedef struct 
{                                                          /* Bit Access       */
    uint32 CKSEL:3;                                        /* CKSEL[2:0]       */
    uint32 :29;                                            /* Reserved Bits    */
} __type1476;
typedef struct 
{                                                          /* Bit Access       */
    uint32 :7;                                             /* Reserved Bits    */
    uint32 SVSDIS:1;                                       /* SVSDIS           */
    uint32 :24;                                            /* Reserved Bits    */
} __type1477;
typedef struct 
{                                                          /* Bit Access       */
    uint32 EN:1;                                           /* EN               */
    uint32 CLKDIV:3;                                       /* CLKDIV[3:1]      */
    uint32 :28;                                            /* Reserved Bits    */
} __type1478;
typedef struct 
{                                                          /* Bit Access       */
    uint32 RUN:1;                                          /* RUN              */
    uint32 :31;                                            /* Reserved Bits    */
} __type1479;
typedef struct 
{                                                          /* Bit Access       */
    uint32 MODE:2;                                         /* MODE[1:0]        */
    uint32 OS:1;                                           /* OS               */
    uint32 BE:1;                                           /* BE               */
    uint32 OSI:1;                                          /* OSI              */
    uint32 :27;                                            /* Reserved Bits    */
} __type1480;
typedef struct 
{                                                          /* Bit Access       */
    uint32 DF:8;                                           /* DF[7:0]          */
    uint32 :24;                                            /* Reserved Bits    */
} __type1481;
typedef struct 
{                                                          /* Bit Access       */
    uint32 ADIL:9;                                         /* ADIL[8:0]        */
    uint32 :23;                                            /* Reserved Bits    */
} __type1482;
typedef struct 
{                                                          /* Bit Access       */
    uint32 ITH:9;                                          /* ITH[8:0]         */
    uint32 :23;                                            /* Reserved Bits    */
} __type1483;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FL:9;                                           /* FL[8:0]          */
    uint32 :23;                                            /* Reserved Bits    */
} __type1484;
typedef struct 
{                                                          /* Bit Access       */
    uint32 FH:9;                                           /* FH[8:0]          */
    uint32 :23;                                            /* Reserved Bits    */
} __type1485;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PWM:9;                                          /* PWM[8:0]         */
    uint32 :23;                                            /* Reserved Bits    */
} __type1486;
typedef struct 
{                                                          /* Bit Access       */
    uint32 REN:1;                                          /* REN              */
    uint32 TEN:1;                                          /* TEN              */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 MUEN:1;                                         /* MUEN             */
    uint32 CKDV:4;                                         /* CKDV[7:4]        */
    uint32 DEL:1;                                          /* DEL              */
    uint32 PDTA:1;                                         /* PDTA             */
    uint32 SDTA:1;                                         /* SDTA             */
    uint32 SPDP:1;                                         /* SPDP             */
    uint32 SWSP:1;                                         /* SWSP             */
    uint32 SCKP:1;                                         /* SCKP             */
    uint32 SWSD:1;                                         /* SWSD             */
    uint32 SCKD:1;                                         /* SCKD             */
    uint32 SWL:3;                                          /* SWL[18:16]       */
    uint32 DWL:3;                                          /* DWL[21:19]       */
    uint32 CHNL:2;                                         /* CHNL[23:22]      */
    uint32 :1;                                             /* Reserved Bits    */
    uint32 IIEN:1;                                         /* IIEN             */
    uint32 ROIEN:1;                                        /* ROIEN            */
    uint32 RUIEN:1;                                        /* RUIEN            */
    uint32 TOIEN:1;                                        /* TOIEN            */
    uint32 TUIEN:1;                                        /* TUIEN            */
    uint32 :2;                                             /* Reserved Bits    */
} __type1487;
typedef struct 
{                                                          /* Bit Access       */
    uint32 IDST:1;                                         /* IDST             */
    uint32 RSWNO:1;                                        /* RSWNO            */
    uint32 RCHNO:2;                                        /* RCHNO[3:2]       */
    uint32 TSWNO:1;                                        /* TSWNO            */
    uint32 TCHNO:2;                                        /* TCHNO[6:5]       */
    uint32 :18;                                            /* Reserved Bits    */
    uint32 IIRQ:1;                                         /* IIRQ             */
    uint32 ROIRQ:1;                                        /* ROIRQ            */
    uint32 RUIRQ:1;                                        /* RUIRQ            */
    uint32 TOIRQ:1;                                        /* TOIRQ            */
    uint32 TUIRQ:1;                                        /* TUIRQ            */
    uint32 :2;                                             /* Reserved Bits    */
} __type1488;
typedef struct 
{                                                          /* Bit Access       */
    uint32 RFRST:1;                                        /* RFRST            */
    uint32 TFRST:1;                                        /* TFRST            */
    uint32 RIE:1;                                          /* RIE              */
    uint32 TIE:1;                                          /* TIE              */
    uint32 RTRG:2;                                         /* RTRG[5:4]        */
    uint32 TTRG:2;                                         /* TTRG[7:6]        */
    uint32 :24;                                            /* Reserved Bits    */
} __type1489;
typedef struct 
{                                                          /* Bit Access       */
    uint32 RDF:1;                                          /* RDF              */
    uint32 :7;                                             /* Reserved Bits    */
    uint32 RDC:4;                                          /* RDC[11:8]        */
    uint32 :4;                                             /* Reserved Bits    */
    uint32 TDE:1;                                          /* TDE              */
    uint32 :7;                                             /* Reserved Bits    */
    uint32 TDC:4;                                          /* TDC[27:24]       */
    uint32 :4;                                             /* Reserved Bits    */
} __type1490;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TDM:1;                                          /* TDM              */
    uint32 :7;                                             /* Reserved Bits    */
    uint32 CONT:1;                                         /* CONT             */
    uint32 :23;                                            /* Reserved Bits    */
} __type1491;
typedef struct 
{                                                          /* Bit Access       */
    uint16 GCTRL:6;                                        /* GCTRL[5:0]       */
    uint16 ULS:2;                                          /* ULS[7:6]         */
    uint16 ADIE:1;                                         /* ADIE             */
    uint16 :7;                                             /* Reserved Bits    */
    uint16 :16;                                            /* Reserved Bits    */
} __type1492;
typedef struct 
{                                                          /* Bit Access       */
    uint8  TSNGCTRL:6;                                     /* TSNGCTRL[5:0]    */
    uint8  TSNULS:2;                                       /* TSNULS[7:6]      */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type1493;
typedef struct 
{                                                          /* Bit Access       */
    uint8  GCTRL:6;                                        /* GCTRL[5:0]       */
    uint8  ULS:2;                                          /* ULS[7:6]         */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type1494;
typedef struct 
{                                                          /* Bit Access       */
    uint16 DR00:16;                                        /* DR00[15:0]       */
    uint16 DR01:16;                                        /* DR01[31:16]      */
} __type1495;
typedef struct 
{                                                          /* Bit Access       */
    uint16 DR02:16;                                        /* DR02[15:0]       */
    uint16 DR03:16;                                        /* DR03[31:16]      */
} __type1496;
typedef struct 
{                                                          /* Bit Access       */
    uint16 DR04:16;                                        /* DR04[15:0]       */
    uint16 DR05:16;                                        /* DR05[31:16]      */
} __type1497;
typedef struct 
{                                                          /* Bit Access       */
    uint16 DR06:16;                                        /* DR06[15:0]       */
    uint16 DR07:16;                                        /* DR07[31:16]      */
} __type1498;
typedef struct 
{                                                          /* Bit Access       */
    uint16 DR08:16;                                        /* DR08[15:0]       */
    uint16 DR09:16;                                        /* DR09[31:16]      */
} __type1499;
typedef struct 
{                                                          /* Bit Access       */
    uint16 DR10:16;                                        /* DR10[15:0]       */
    uint16 DR11:16;                                        /* DR11[31:16]      */
} __type1500;
typedef struct 
{                                                          /* Bit Access       */
    uint16 DR12:16;                                        /* DR12[15:0]       */
    uint16 DR13:16;                                        /* DR13[31:16]      */
} __type1501;
typedef struct 
{                                                          /* Bit Access       */
    uint16 DR14:16;                                        /* DR14[15:0]       */
    uint16 DR15:16;                                        /* DR15[31:16]      */
} __type1502;
typedef struct 
{                                                          /* Bit Access       */
    uint16 DR16:16;                                        /* DR16[15:0]       */
    uint16 DR17:16;                                        /* DR17[31:16]      */
} __type1503;
typedef struct 
{                                                          /* Bit Access       */
    uint16 DR18:16;                                        /* DR18[15:0]       */
    uint16 DR19:16;                                        /* DR19[31:16]      */
} __type1504;
typedef struct 
{                                                          /* Bit Access       */
    uint16 DR20:16;                                        /* DR20[15:0]       */
    uint16 DR21:16;                                        /* DR21[31:16]      */
} __type1505;
typedef struct 
{                                                          /* Bit Access       */
    uint16 TSNDR:16;                                       /* TSNDR[15:0]      */
    uint16 PWDDR:16;                                       /* PWDDR[31:16]     */
} __type1506;
typedef struct 
{                                                          /* Bit Access       */
    uint32 DR:16;                                          /* DR[15:0]         */
    uint32 ID:6;                                           /* ID[21:16]        */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 WFLG:1;                                         /* WFLG             */
    uint32 :6;                                             /* Reserved Bits    */
} __type1507;
typedef struct 
{                                                          /* Bit Access       */
    uint32 TSNDR:16;                                       /* TSNDR[15:0]      */
    uint32 ID:6;                                           /* ID[21:16]        */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 WFLG:1;                                         /* WFLG             */
    uint32 :6;                                             /* Reserved Bits    */
} __type1508;
typedef struct 
{                                                          /* Bit Access       */
    uint32 PWDDR:16;                                       /* PWDDR[15:0]      */
    uint32 ID:6;                                           /* ID[21:16]        */
    uint32 :3;                                             /* Reserved Bits    */
    uint32 WFLG:1;                                         /* WFLG             */
    uint32 :6;                                             /* Reserved Bits    */
} __type1509;
typedef struct 
{                                                          /* Bit Access       */
    uint8  HALT:1;                                         /* HALT             */
    uint8  :7;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type1510;
typedef struct 
{                                                          /* Bit Access       */
    uint8  SUSMTD:2;                                       /* SUSMTD[1:0]      */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  CTYP:1;                                         /* CTYP             */
    uint8  CRAC:1;                                         /* CRAC             */
    uint8  TSNSELFDIAG:1;                                  /* TSNSELFDIAG      */
    uint8  DGON:1;                                         /* DGON             */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type1511;
typedef struct 
{                                                          /* Bit Access       */
    uint16 SEF:5;                                          /* SEF[4:0]         */
    uint16 :3;                                             /* Reserved Bits    */
    uint16 SGACT:6;                                        /* SGACT[13:8]      */
    uint16 :2;                                             /* Reserved Bits    */
    uint16 :16;                                            /* Reserved Bits    */
} __type1512;
typedef struct 
{                                                  