#ifndef _FUELCONFIG_H
#define _FUELCONFIG_H

#include "TYW_stdint.h"

//typedef unsigned short INT16U;
//typedef unsigned char INT8_t;
//typedef unsigned int INT32_t;

#define DISPLAY_BOUNDARY_ES         1500
#define DISPLAY_BOUNDARY_1          1500
#define DISPLAY_BOUNDARY_2          1373
#define DISPLAY_BOUNDARY_3          1191
#define DISPLAY_BOUNDARY_4          1009
#define DISPLAY_BOUNDARY_5          848
#define DISPLAY_BOUNDARY_6          697
#define DISPLAY_BOUNDARY_7          545
#define DISPLAY_BOUNDARY_8          436
#define DISPLAY_BOUNDARY_9          345
#define DISPLAY_BOUNDARY_10         254
#define DISPLAY_BOUNDARY_11         188
#define DISPLAY_BOUNDARY_12         132
#define DISPLAY_BOUNDARY_13         84
#define DISPLAY_BOUNDARY_FS         65

#define BOUNDARY_FUEL_ES            0
#define BOUNDARY_FUEL_1             400
#define BOUNDARY_FUEL_2             720
#define BOUNDARY_FUEL_3             860
#define BOUNDARY_FUEL_4             1040
#define BOUNDARY_FUEL_5             1428
#define BOUNDARY_FUEL_6             2577
#define BOUNDARY_FUEL_7             3750
#define BOUNDARY_FUEL_8             4931
#define BOUNDARY_FUEL_9             5536
#define BOUNDARY_FUEL_10            5724
#define BOUNDARY_FUEL_11            6491
#define BOUNDARY_FUEL_12            6850
#define BOUNDARY_FUEL_13            7199
#define BOUNDARY_FUEL_FS            7600

#define FUEL_R_MIN_VAL 40   // 10 X ohm
#define FUEL_R_MAX_VAL 3000 // 10 X ohm

// Fuel Config
typedef struct _FuelStruct
{
    uint16_t FuelShortCircuitR;
    uint16_t FuelOpenCircuitR;
    uint16_t DisplayZoneBoundary[22];
    uint16_t FuelCapacityBoundary[22];
} FuelStruct;

extern void InitFuelParamter(FuelStruct *para);
extern uint8_t *GetFuelLibVersion(void);

extern void FuelFSM(uint16_t FuelResistance); // unit:ohm,accuracy:0.1

extern void SetMaxFuelBlockNum(uint8_t n); // call after InitFuelParamter(),default 12,max 20

extern void SetFuelSensorRecoverGroupCnt(uint16_t n);      // 1:500ms,2:1000ms,3:1500ms.......,range:5s(10)-30min(3600)
extern void SetFuelSensorOpenCircuitGroupCnt(uint16_t n);  // 1:500ms,2:1000ms,3:1500ms.......,range:5s(10)-30min(3600)
extern void SetFuelSensorShortCircuitGroupCnt(uint16_t n); // 1:500ms,2:1000ms,3:1500ms.......,range:5s(10)-30min(3600)

extern void SetPowerSt(uint8_t n);
extern uint8_t GetFuelSeg(void);  // Segment, range:0~8
extern uint8_t GetFuelStep(void); // Pointer or Mono TFT stepless,range:0,10~((MaxFuelBlockNum + 1) * 10)  0,10:E,   ((MaxFuelBlockNum + 1) * 10):F

extern uint16_t GetFuelCapacityVal(void); // unit:L,accuracy:0.1

enum
{
    FuelSensorNormal,
    FuelSensorShortCircuit,
    FuelSensorOpenCircuit,
    FuelSensorPreFault,
};
extern uint8_t GetFuelSensorState(void);

enum
{
    FUEL_ST_IGN_ON_PROCESS = 1, // 1
    FUEL_ST_POWER_ON_ADD_FUEL,  // 2
    FUEL_ST_VEHICLE_RUN,        // 3
    FUEL_ST_IGN_OFF_PROCESS,    // 4
    FUEL_ST_IGN_OFF,            // 5
};
extern uint8_t GetFuelFSM_St(void);
extern uint16_t GetFuelResistance(void); // unit:ohm,accuracy:0.1

extern void SetPowerDnStep(uint8_t step); // call every ign on  (after InitFuelParamter())
extern uint8_t GetPowerDnStep(void);      // every 10km or ign off or refuel(FUEL_ST_POWER_ON_ADD_FUEL->FUEL_ST_VEHICLE_RUN) record

// AFC & DrivingRange
typedef struct _AFC_INIT
{
    uint8_t CalcAFCMaxNum;  // max 100km,default 50
    uint16_t AFCMin;        // unit:L,accuracy:0.1
    uint16_t AFCMax;        // unit:L,accuracy:0.1
    uint16_t AFCPreinstall; // unit:L,accuracy:0.1
    uint32_t CurODO;        // unit:m,accuracy:1
    uint32_t MaxDRMileage;  // unit:km,accuracy:0.01
} AFC_INIT;
extern void InitAFC(AFC_INIT *data);
extern void ResetAFC(AFC_INIT *data);

typedef struct _AFC_PARA
{
    uint32_t CurODO;      // unit:m,accuracy:1
    uint16_t FuleConsume; // unit:ul,accuracy:1
    uint16_t RPM;         // unit:RPM,accuracy:1
    uint8_t Speed;        // unit:km/h,accuracy:1
} AFC_PARA;
extern void SetAFCPara(AFC_PARA *data);

typedef struct _DAFC_PARA
{
    uint32_t DAFC_FuelConsumeSum; // unit:ul    (ul:m->ml:km->L:1000km)
    uint32_t DAFC_ODO;            // unit:m
} DAFC_PARA;
extern void DAFC_GetPowerDownPara(DAFC_PARA *data); // call every 10km or ign off or reset afc
extern void DAFC_SetPowerDownPara(DAFC_PARA *data); // call every KL30 OFF -> KL30 ON (after InitAFC())

typedef struct _DR_PARA
{
    uint32_t DR_FuelConsumeSum; // unit:ul    (ul:m->ml:km->L:1000km)
    uint32_t DR_Mileage;        // unit:km,accuracy:0.01
} DR_PARA;
extern void DR_GetPowerDownPara(DR_PARA *data); // call every 10km or ign off
extern void DR_SetPowerDownPara(DR_PARA *data); // call every KL30 OFF -> KL30 ON (after InitAFC())

extern void AFCTimerCall(void);   // must per 10ms interrupt
extern uint16_t GetDRMileage(void); // unit:km,accuracy:1
extern uint16_t GetCurAFC(void);    // unit:L,accuracy:0.1

// display afc
extern void DAFC_Reset(AFC_INIT *data);
extern uint16_t DAFC_GetAFC(void); // unit:L,accuracy:0.1
// display afc end

extern void SetIgnOffRefuelThreshold(uint8_t data);

#endif
