
#include <stddef.h>
#include "Popup_List.h"
#include "Popup_Message_List.h"
#include "Sound_List.h"

/******************************************************************************
报警属性表
******************************************************************************/
const Popup_Attribute_t PopupAttributeTable[POPUP_MAX] =
{
    /*===============================================================================================================================================================================================================================================================================
                  报警名称                      |      报警类型          | 优先级 | 副优先级  |  +15 On/Off   |                 报警类                  |            成员列表            |           成员数量       |     文字消息            |     显示模式     |           报警音            |   声音提示模式
    -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/
    {/*00 POPUP1_BRAKE_BLACK  =0x00u        */    POPUP_TYPE_FATAL   ,    0u,     0u,    POPUP_IGN_ON,     POPUP1_BRAKE_BLACK                          , NULL,          1u,           POPUP1_MSG_BRAKE_BLACK                       ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*01 POPUP1_BRAKE_BRAKE                */    POPUP_TYPE_FATAL   ,    0u,     0u,    POPUP_IGN_ON,     POPUP1_BRAKE_BRAKE                          , NULL,          1u,           POPUP1_MSG_BRAKE_BRAKE                       ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*02 POPUP1_BRAKE_SPACING_R            */    POPUP_TYPE_FATAL   ,    0u,     0u,    POPUP_IGN_ON,     POPUP1_BRAKE_SPACING_R                      , NULL,          1u,           POPUP1_MSG_BRAKE_SPACING_R                   ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*03 POPUP1_BRAKE_SPACING_COLLISION    */    POPUP_TYPE_FATAL   ,    0u,     0u,    POPUP_IGN_ON,     POPUP1_BRAKE_SPACING_COLLISION              , NULL,          1u,           POPUP1_MSG_BRAKE_SPACING_COLLISION           ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*04 POPUP1_BRAKE_SPACING_Y            */    POPUP_TYPE_FATAL   ,    0u,     0u,    POPUP_IGN_ON,     POPUP1_BRAKE_SPACING_Y                      , NULL,          1u,           POPUP1_MSG_BRAKE_SPACING_Y                   ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*05 POPUT1_ASR_OPERATE                */    POPUP_TYPE_FATAL   ,    0u,     0u,    POPUP_IGN_ON,     POPUT1_ASR_OPERATE                          , NULL,          1u,           POPUT1_MSG_ASR_OPERATE                       ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*06 POPUT2_PTO                        */    POPUP_TYPE_FATAL   ,    0u,     0u,    POPUP_IGN_ON,     POPUT2_PTO                                  , NULL,          1u,           POPUT2_MSG_PTO                               ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*07 POPUP2_PARKING_BRAKE              */    POPUP_TYPE_FATAL   ,    0u,     1u,    POPUP_IGN_ON,     POPUP2_PARKING_BRAKE                        , NULL,          1u,           POPUP2_MSG_PARKING_BRAKE                     ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*08 POPUP2_AIRMATIC_HIGHT             */    POPUP_TYPE_WARNING ,    0u,     2u,    POPUP_IGN_ON,     POPUP2_AIRMATIC_HIGHT                       , NULL,          1u,           POPUP2_MSG_AIRMATIC_HIGHT                    ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*09 POPUP3_CRUISE                     */    POPUP_TYPE_WARNING ,    1u,     0u,    POPUP_IGN_ON,     POPUP3_CRUISE                               , NULL,          1u,           POPUP3_MSG_CRUISE                            ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*10 POPUP3_VARIABLE_SLD               */    POPUP_TYPE_WARNING ,    1u,     0u,    POPUP_IGN_ON,     POPUP3_VARIABLE_SLD                         , NULL,          1u,           POPUP3_MSG_VARIABLE_SLD                      ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*11 POPUT4_ABNORMAL_CHARGE            */    POPUP_TYPE_WARNING ,    2u,     0u,    POPUP_IGN_ON,     POPUT4_ABNORMAL_CHARGE                      , NULL,          1u,           POPUT4_MSG_ABNORMAL_CHARGE                   ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*12 POPUP4_OIL_PRESSURE               */    POPUP_TYPE_WARNING ,    2u,     1u,    POPUP_IGN_ON,     POPUP4_OIL_PRESSURE                         , NULL,          1u,           POPUP4_MSG_OIL_PRESSURE                      ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*13 POPUP4_AMT_INIT_EXCE              */    POPUP_TYPE_WARNING ,    2u,     2u,    POPUP_IGN_ON,     POPUP4_AMT_INIT_EXCE                        , NULL,          1u,           POPUP4_MSG_AMT_INIT_EXCE                     ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*14 POPUP4_ADBLUE_QUALITY             */    POPUP_TYPE_WARNING ,    2u,     3u,    POPUP_IGN_ON,     POPUP4_ADBLUE_QUALITY                       , NULL,          1u,           POPUP4_MSG_ADBLUE_QUALITY                    ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*15 POPUP4_ADBLUE_SPRAY               */    POPUP_TYPE_WARNING ,    2u,     4u,    POPUP_IGN_ON,     POPUP4_ADBLUE_SPRAY                         , NULL,          1u,           POPUP4_MSG_ADBLUE_SPRAY                      ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*16 POPUP4_ADBLUE_SUPPLY              */    POPUP_TYPE_WARNING ,    2u,     5u,    POPUP_IGN_ON,     POPUP4_ADBLUE_SUPPLY                        , NULL,          1u,           POPUP4_MSG_ADBLUE_SUPPLY                     ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*17 POPUP4_START_ENG                  */    POPUP_TYPE_WARNING ,    2u,     6u,    POPUP_IGN_ON,     POPUP4_START_ENG                            , NULL,          1u,           POPUP4_MSG_START_ENG                         ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*18 POPUP4_DPD_AUTO                   */    POPUP_TYPE_WARNING ,    2u,     7u,    POPUP_IGN_ON,     POPUP4_DPD_AUTO                             , NULL,          1u,           POPUP4_MSG_DPD_AUTO                          ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*19 POPUP5_OVER_HEAT                  */    POPUP_TYPE_WARNING ,    3u,     0u,    POPUP_IGN_ON,     POPUP5_OVER_HEAT                            , NULL,          1u,           POPUP5_MSG_OVER_HEAT                         ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*20 POPUP5_LOW_COOLANT                */    POPUP_TYPE_WARNING ,    3u,     0u,    POPUP_IGN_ON,     POPUP5_LOW_COOLANT                          , NULL,          1u,           POPUP5_MSG_LOW_COOLANT                       ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*21 POPUP5_ENGINE_OIL_PRESSURE        */    POPUP_TYPE_WARNING ,    3u,     0u,    POPUP_IGN_ON,     POPUP5_ENGINE_OIL_PRESSURE                  , NULL,          1u,           POPUP5_MSG_ENGINE_OIL_PRESSURE               ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*22 POPUP5_METER_FAILURE              */    POPUP_TYPE_WARNING ,    3u,     0u,    POPUP_IGN_ON,     POPUP5_METER_FAILURE                        , NULL,          1u,           POPUP5_MSG_METER_FAILURE                     ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*22 POPUP5_CAN_ERROR                  */    POPUP_TYPE_WARNING ,    3u,     0u,    POPUP_IGN_ON,     POPUP5_CAN_ERROR                            , NULL,          1u,           POPUP5_MSG_CAN_ERROR                         ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*24 POPUP5_SPEED_LIMIT                */    POPUP_TYPE_WARNING ,    3u,     0u,    POPUP_IGN_ON,     POPUP5_SPEED_LIMIT                          , NULL,          1u,           POPUP5_MSG_SPEED_LIMIT                       ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*25 POPUP5_TORQUE_REDUCTION           */    POPUP_TYPE_WARNING ,    3u,     0u,    POPUP_IGN_ON,     POPUP5_TORQUE_REDUCTION                     , NULL,          1u,           POPUP5_MSG_TORQUE_REDUCTION                  ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*26 POPUP5_INCORRECT_ADBLUE           */    POPUP_TYPE_WARNING ,    3u,     0u,    POPUP_IGN_ON,     POPUP5_INCORRECT_ADBLUE                     , NULL,          1u,           POPUP5_MSG_INCORRECT_ADBLUE                  ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*27 POPUP5_CRITICAL_EMISSION          */    POPUP_TYPE_WARNING ,    3u,     0u,    POPUP_IGN_ON,     POPUP5_CRITICAL_EMISSION                    , NULL,          1u,           POPUP5_MSG_CRITICAL_EMISSION                 ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*28 POPUP5_AMT_SPANNER_WARNING        */    POPUP_TYPE_WARNING ,    3u,     0u,    POPUP_IGN_ON,     POPUP5_AMT_SPANNER_WARNING                  , NULL,          1u,           POPUP5_MSG_AMT_SPANNER_WARNING               ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*29 POPUP5_AMT_LOW_AIR_WARNING        */    POPUP_TYPE_WARNING ,    3u,     0u,    POPUP_IGN_ON,     POPUP5_AMT_LOW_AIR_WARNING                  , NULL,          1u,           POPUP5_MSG_AMT_LOW_AIR_WARNING               ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*30 POPUP5_LOW_PRESSURE_ALARM         */    POPUP_TYPE_WARNING ,    3u,     0u,    POPUP_IGN_ON,     POPUP5_LOW_PRESSURE_ALARM                   , NULL,          1u,           POPUP5_MSG_LOW_PRESSURE_ALARM                ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*31 POPUP5_APP_ADBLUE                 */    POPUP_TYPE_WARNING ,    3u,     0u,    POPUP_IGN_ON,     POPUP5_APP_ADBLUE                           , NULL,          1u,           POPUP5_MSG_APP_ADBLUE                        ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*32 POPUP5_ADBLUE_LEVEL_LOW           */    POPUP_TYPE_WARNING ,    3u,     0u,    POPUP_IGN_ON,     POPUP5_ADBLUE_LEVEL_LOW                     , NULL,          1u,           POPUP5_MSG_ADBLUE_LEVEL_LOW                  ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*33 POPUP5_LOW_FAILURE                */    POPUP_TYPE_WARNING ,    3u,     0u,    POPUP_IGN_ON,     POPUP5_LOW_FAILURE                          , NULL,          1u,           POPUP5_MSG_LOW_FAILURE                       ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*34 POPUP5_CAMERA_POLLUTION           */    POPUP_TYPE_WARNING ,    3u,     0u,    POPUP_IGN_ON,     POPUP5_CAMERA_POLLUTION                     , NULL,          1u,           POPUP5_MSG_CAMERA_POLLUTION                  ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*35 POPUP5_AdBlue_INJ_SYSTEM          */    POPUP_TYPE_WARNING ,    3u,     0u,    POPUP_IGN_ON,     POPUP5_AdBlue_INJ_SYSTEM                    , NULL,          1u,           POPUP5_MSG_AdBlue_INJ_SYSTEM                 ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*36 POPUP5_AdBlue_DOS_MALFUNC         */    POPUP_TYPE_WARNING ,    3u,     0u,    POPUP_IGN_ON,     POPUP5_AdBlue_DOS_MALFUNC                   , NULL,          1u,           POPUP5_MSG_AdBlue_DOS_MALFUNC                ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*37 POPUP5_TPMS_HIGH_AIR              */    POPUP_TYPE_WARNING ,    3u,     0u,    POPUP_IGN_ON,     POPUP5_TPMS_HIGH_AIR                        , NULL,          1u,           POPUP5_MSG_TPMS_HIGH_AIR                     ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*38 POPUP5_TPMS_HIGH_TEMP             */    POPUP_TYPE_WARNING ,    3u,     0u,    POPUP_IGN_ON,     POPUP5_TPMS_HIGH_TEMP                       , NULL,          1u,           POPUP5_MSG_TPMS_HIGH_TEMP                    ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*39 POPUP5_PUSH_DPD_SWITCH1           */    POPUP_TYPE_WARNING ,    3u,     0u,    POPUP_IGN_ON,     POPUP5_PUSH_DPD_SWITCH1                     , NULL,          1u,           POPUP5_MSG_PUSH_DPD_SWITCH1                  ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*40 POPUP5_PUSH_DPD_SWITCH2           */    POPUP_TYPE_WARNING ,    3u,     0u,    POPUP_IGN_ON,     POPUP5_PUSH_DPD_SWITCH2                     , NULL,          1u,           POPUP5_MSG_PUSH_DPD_SWITCH2                  ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*41 POPUP5_TPMS_FAILURE               */    POPUP_TYPE_WARNING ,    3u,     0u,    POPUP_IGN_ON,     POPUP5_TPMS_FAILURE                         , NULL,          1u,           POPUP5_MSG_TPMS_FAILURE                      ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*42 POPUP5_TPMS_MONITOR_DROP          */    POPUP_TYPE_WARNING ,    3u,     0u,    POPUP_IGN_ON,     POPUP5_TPMS_MONITOR_DROP                    , NULL,          1u,           POPUP5_MSG_TPMS_MONITOR_DROP                 ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*43 POPUP6_HEIGHT_CONTROL             */    POPUP_TYPE_WARNING ,    3u,     0u,    POPUP_IGN_ON,     POPUP6_HEIGHT_CONTROL                       , NULL,          1u,           POPUP6_MSG_HEIGHT_CONTROL                    ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*44 POPUP6_PTO_STOP                   */    POPUP_TYPE_WARNING ,    3u,     0u,    POPUP_IGN_ON,     POPUP6_PTO_STOP                             , NULL,          1u,           POPUP6_MSG_PTO_STOP                          ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*45 POPUP7_CHARGE_ABNORMAL            */    POPUP_TYPE_WARNING ,    3u,     0u,    POPUP_IGN_ON,     POPUP7_CHARGE_ABNORMAL                      , NULL,          1u,           POPUP7_MSG_CHARGE_ABNORMAL                   ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*46 POPUP7_AMT_ERROR                  */    POPUP_TYPE_WARNING ,    3u,     0u,    POPUP_IGN_ON,     POPUP7_AMT_ERROR                            , NULL,          1u,           POPUP7_MSG_AMT_ERROR                         ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*47 POPUP8_REFUEL                     */    POPUP_TYPE_WARNING ,    3u,     0u,    POPUP_IGN_ON,     POPUP8_REFUEL                               , NULL,          1u,           POPUP8_MSG_REFUEL                            ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*48 POPUP8_ATM_CLUCH_OVERHEATING      */    POPUP_TYPE_WARNING ,    3u,     0u,    POPUP_IGN_ON,     POPUP8_ATM_CLUCH_OVERHEATING                , NULL,          1u,           POPUP8_MSG_ATM_CLUCH_OVERHEATING             ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*49 POPUP8_ATM_WORN_OUT               */    POPUP_TYPE_WARNING ,    3u,     0u,    POPUP_IGN_ON,     POPUP8_ATM_WORN_OUT                         , NULL,          1u,           POPUP8_MSG_ATM_WORN_OUT                      ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*50 POPUP8_LOWVOLTAGE                 */    POPUP_TYPE_WARNING ,    3u,     0u,    POPUP_IGN_ON,     POPUP8_LOWVOLTAGE                           , NULL,          1u,           POPUP8_MSG_LOWVOLTAGE                        ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*51 POPUP8_OVERVOLTAGE                */    POPUP_TYPE_WARNING ,    3u,     0u,    POPUP_IGN_ON,     POPUP8_OVERVOLTAGE                          , NULL,          1u,           POPUP8_MSG_OVERVOLTAGE                       ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*52 POPUP8_BRAKE_BLOCKR               */    POPUP_TYPE_WARNING ,    3u,     0u,    POPUP_IGN_ON,     POPUP8_BRAKE_BLOCKR                         , NULL,          1u,           POPUP8_MSG_BRAKE_BLOCKR                      ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*53 POPUP8_BRAKE_BLOCKF               */    POPUP_TYPE_WARNING ,    3u,     0u,    POPUP_IGN_ON,     POPUP8_BRAKE_BLOCKF                         , NULL,          1u,           POPUP8_MSG_BRAKE_BLOCKF                      ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*54 POPUP8_DPD_AUTO                   */    POPUP_TYPE_WARNING ,    3u,     0u,    POPUP_IGN_ON,     POPUP8_DPD_AUTO                             , NULL,          1u,           POPUP8_MSG_DPD_AUTO                          ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*55 POPUP9_AIR_PRESSURE               */    POPUP_TYPE_WARNING ,    3u,     0u,    POPUP_IGN_ON,     POPUP9_AIR_PRESSURE                         , NULL,          1u,           POPUP9_MSG_AIR_PRESSURE                      ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*56 POPUP9_EBS_ERROR                  */    POPUP_TYPE_WARNING ,    3u,     0u,    POPUP_IGN_ON,     POPUP9_EBS_ERROR                            , NULL,          1u,           POPUP9_MSG_EBS_ERROR                         ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*57 POPUP10_RAPID_ACC                 */    POPUP_TYPE_WARNING ,    3u,     0u,    POPUP_IGN_ON,     POPUP10_RAPID_ACC                           , NULL,          1u,           POPUP10_MSG_RAPID_ACC                        ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*58 POPUP10_RAPID_SUB                 */    POPUP_TYPE_WARNING ,    3u,     0u,    POPUP_IGN_ON,     POPUP10_RAPID_SUB                           , NULL,          1u,           POPUP10_MSG_RAPID_SUB                        ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*59 POPUP10_REVAL_ENGINE              */    POPUP_TYPE_WARNING ,    3u,     0u,    POPUP_IGN_ON,     POPUP10_REVAL_ENGINE                        , NULL,          1u,           POPUP10_MSG_REVAL_ENGINE                     ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*60 POPUP10_REVAL_SPEED               */    POPUP_TYPE_WARNING ,    3u,     0u,    POPUP_IGN_ON,     POPUP10_REVAL_SPEED                         , NULL,          1u,           POPUP10_MSG_REVAL_SPEED                      ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*61 POPUP11_ENGINE_OIL_FILTER         */    POPUP_TYPE_WARNING ,    3u,     0u,    POPUP_IGN_ON,     POPUP11_ENGINE_OIL_FILTER                   , NULL,          1u,           POPUP11_MSG_ENGINE_OIL_FILTER                ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*62 POPUP11_FUEL_FILTER               */    POPUP_TYPE_WARNING ,    3u,     0u,    POPUP_IGN_ON,     POPUP11_FUEL_FILTER                         , NULL,          1u,           POPUP11_MSG_FUEL_FILTER                      ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*63 POPUP11_T_MISSION_OIL             */    POPUP_TYPE_WARNING ,    3u,     0u,    POPUP_IGN_ON,     POPUP11_T_MISSION_OIL                       , NULL,          1u,           POPUP11_MSG_T_MISSION_OIL                    ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*64 POPUP11_DIFF_OIL                  */    POPUP_TYPE_WARNING ,    3u,     0u,    POPUP_IGN_ON,     POPUP11_DIFF_OIL                            , NULL,          1u,           POPUP11_MSG_DIFF_OIL                         ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*65 POPUP11_CLUTCH_OIL                */    POPUP_TYPE_WARNING ,    3u,     0u,    POPUP_IGN_ON,     POPUP11_CLUTCH_OIL                          , NULL,          1u,           POPUP11_MSG_CLUTCH_OIL                       ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*66 POPUP11_P_STEERING_FRUID          */    POPUP_TYPE_WARNING ,    3u,     0u,    POPUP_IGN_ON,     POPUP11_P_STEERING_FRUID                    , NULL,          1u,           POPUP11_MSG_P_STEERING_FRUID                 ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},
    {/*67 POPUP11_TIRE_ROTATION             */    POPUP_TYPE_WARNING ,    3u,     0u,    POPUP_IGN_ON,     POPUP11_TIRE_ROTATION                       , NULL,          1u,           POPUP11_MSG_TIRE_ROTATION                    ,  POPUP_MODE_MULTI,    POPUP_NONE      ,  POPUP_MODE_MULTI,},

    /*=============================================================================================================================================================================================================================================================================*/
};