
#include "dr7f701441.dvf.h"
#include "TimerB.h"
#include "r_dev_api.h"
#include "GPIO.h"

/*---------------PWM Start--------------------------------------------*/
#define TIMERB_CHANNEL_INTERVAL 1U
#define TIMERB_CHANNEL_BIT_MUL 3U
#define TIMERB_BASE_ADDRESSES 0xFFE30000U
#define TIMERB_TIMEROUT_MAX 50U

/*----target clock----------*/
#define TIMERB_0_CK0 5000000UL
#define TIMERB_0_CK1 39062UL
#define TIMERB_0_CK2 5000000UL
#define TIMERB_0_CK3 39062UL
#define TIMERB_1_CK0 5000000UL
#define TIMERB_1_CK1 5000000UL
#define TIMERB_1_CK2 5000000UL
#define TIMERB_1_CK3 5000000UL
#define TIMERB_2_CK0 5000000UL
#define TIMERB_2_CK1 5000000UL
#define TIMERB_2_CK2 5000000UL
#define TIMERB_2_CK3 5000000UL

/*-----default clock---------*/
#define TIMERB_PCLK_01 10000000UL
#define TIMERB_PCLK_2 10000000UL
/*-----------------------------------------------------*/
#define TIMERB_0_CK0_DIV (TIMERB_PCLK_01 / TIMERB_0_CK0)
#define TIMERB_0_CK1_DIV (TIMERB_PCLK_01 / TIMERB_0_CK1)
#define TIMERB_0_CK2_DIV (TIMERB_PCLK_01 / TIMERB_0_CK2)
#define TIMERB_0_CK3_DIV (TIMERB_PCLK_01 / TIMERB_0_CK3)
#define TIMERB_1_CK0_DIV (TIMERB_PCLK_01 / TIMERB_1_CK0)
#define TIMERB_1_CK1_DIV (TIMERB_PCLK_01 / TIMERB_1_CK1)
#define TIMERB_1_CK2_DIV (TIMERB_PCLK_01 / TIMERB_1_CK2)
#define TIMERB_1_CK3_DIV (TIMERB_PCLK_01 / TIMERB_1_CK3)
#define TIMERB_2_CK0_DIV (TIMERB_PCLK_2 / TIMERB_2_CK0)
#define TIMERB_2_CK1_DIV (TIMERB_PCLK_2 / TIMERB_2_CK1)
#define TIMERB_2_CK2_DIV (TIMERB_PCLK_2 / TIMERB_2_CK2)
#define TIMERB_2_CK3_DIV (TIMERB_PCLK_2 / TIMERB_2_CK3)

/*-------------------------------------------*/

#if (TIMERB_0_CK0_DIV == 1U)
#define TIMERB_0_CK0_DIV_COE 0U
#elif (TIMERB_0_CK0_DIV == 2U)
#define TIMERB_0_CK0_DIV_COE 1U
#elif (TIMERB_0_CK0_DIV == 4U)
#define TIMERB_0_CK0_DIV_COE 2U
#elif (TIMERB_0_CK0_DIV == 8U)
#define TIMERB_0_CK0_DIV_COE 3U
#elif (TIMERB_0_CK0_DIV == 16U)
#define TIMERB_0_CK0_DIV_COE 4U
#elif (TIMERB_0_CK0_DIV == 32U)
#define TIMERB_0_CK0_DIV_COE 5U
#elif (TIMERB_0_CK0_DIV == 64U)
#define TIMERB_0_CK0_DIV_COE 6U
#elif (TIMERB_0_CK0_DIV == 128U)
#define TIMERB_0_CK0_DIV_COE 7U
#elif (TIMERB_0_CK0_DIV == 256U)
#define TIMERB_0_CK0_DIV_COE 8U
#elif (TIMERB_0_CK0_DIV == 512U)
#define TIMERB_0_CK0_DIV_COE 9U
#elif (TIMERB_0_CK0_DIV == 1024U)
#define TIMERB_0_CK0_DIV_COE 10U
#elif (TIMERB_0_CK0_DIV == 2048U)
#define TIMERB_0_CK0_DIV_COE 11U
#elif (TIMERB_0_CK0_DIV == 4096U)
#define TIMERB_0_CK0_DIV_COE 12U
#elif (TIMERB_0_CK0_DIV == 8192U)
#define TIMERB_0_CK0_DIV_COE 13U
#elif (TIMERB_0_CK0_DIV == 16384U)
#define TIMERB_0_CK0_DIV_COE 14U
#elif (TIMERB_0_CK0_DIV == 32768U)
#define TIMERB_0_CK0_DIV_COE 15U
#else
#error Timer Parameter Error !!!
#endif

#if (TIMERB_0_CK1_DIV == 1U)
#define TIMERB_0_CK1_DIV_COE 0U
#elif (TIMERB_0_CK1_DIV == 2U)
#define TIMERB_0_CK1_DIV_COE 1U
#elif (TIMERB_0_CK1_DIV == 4U)
#define TIMERB_0_CK1_DIV_COE 2U
#elif (TIMERB_0_CK1_DIV == 8U)
#define TIMERB_0_CK1_DIV_COE 3U
#elif (TIMERB_0_CK1_DIV == 16U)
#define TIMERB_0_CK1_DIV_COE 4U
#elif (TIMERB_0_CK1_DIV == 32U)
#define TIMERB_0_CK1_DIV_COE 5U
#elif (TIMERB_0_CK1_DIV == 64U)
#define TIMERB_0_CK1_DIV_COE 6U
#elif (TIMERB_0_CK1_DIV == 128U)
#define TIMERB_0_CK1_DIV_COE 7U
#elif (TIMERB_0_CK1_DIV == 256U)
#define TIMERB_0_CK1_DIV_COE 8U
#elif (TIMERB_0_CK1_DIV == 512U)
#define TIMERB_0_CK1_DIV_COE 9U
#elif (TIMERB_0_CK1_DIV == 1024U)
#define TIMERB_0_CK1_DIV_COE 10U
#elif (TIMERB_0_CK1_DIV == 2048U)
#define TIMERB_0_CK1_DIV_COE 11U
#elif (TIMERB_0_CK1_DIV == 4096U)
#define TIMERB_0_CK1_DIV_COE 12U
#elif (TIMERB_0_CK1_DIV == 8192U)
#define TIMERB_0_CK1_DIV_COE 13U
#elif (TIMERB_0_CK1_DIV == 16384U)
#define TIMERB_0_CK1_DIV_COE 14U
#elif (TIMERB_0_CK1_DIV == 32768U)
#define TIMERB_0_CK1_DIV_COE 15U
#else
#error Timer Parameter Error !!!
#endif

#if (TIMERB_0_CK2_DIV == 1U)
#define TIMERB_0_CK2_DIV_COE 0U
#elif (TIMERB_0_CK2_DIV == 2U)
#define TIMERB_0_CK2_DIV_COE 1U
#elif (TIMERB_0_CK2_DIV == 4U)
#define TIMERB_0_CK2_DIV_COE 2U
#elif (TIMERB_0_CK2_DIV == 8U)
#define TIMERB_0_CK2_DIV_COE 3U
#elif (TIMERB_0_CK2_DIV == 16U)
#define TIMERB_0_CK2_DIV_COE 4U
#elif (TIMERB_0_CK2_DIV == 32U)
#define TIMERB_0_CK2_DIV_COE 5U
#elif (TIMERB_0_CK2_DIV == 64U)
#define TIMERB_0_CK2_DIV_COE 6U
#elif (TIMERB_0_CK2_DIV == 128U)
#define TIMERB_0_CK2_DIV_COE 7U
#elif (TIMERB_0_CK2_DIV == 256U)
#define TIMERB_0_CK2_DIV_COE 8U
#elif (TIMERB_0_CK2_DIV == 512U)
#define TIMERB_0_CK2_DIV_COE 9U
#elif (TIMERB_0_CK2_DIV == 1024U)
#define TIMERB_0_CK2_DIV_COE 10U
#elif (TIMERB_0_CK2_DIV == 2048U)
#define TIMERB_0_CK2_DIV_COE 11U
#elif (TIMERB_0_CK2_DIV == 4096U)
#define TIMERB_0_CK2_DIV_COE 12U
#elif (TIMERB_0_CK2_DIV == 8192U)
#define TIMERB_0_CK2_DIV_COE 13U
#elif (TIMERB_0_CK2_DIV == 16384U)
#define TIMERB_0_CK2_DIV_COE 14U
#elif (TIMERB_0_CK2_DIV == 32768U)
#define TIMERB_0_CK2_DIV_COE 15U
#else
#error Timer Parameter Error !!!
#endif
#if (TIMERB_0_CK3_DIV == 1U)
#define TIMERB_0_CK3_DIV_COE 0U
#elif (TIMERB_0_CK3_DIV == 2U)
#define TIMERB_0_CK3_DIV_COE 1U
#elif (TIMERB_0_CK3_DIV == 4U)
#define TIMERB_0_CK3_DIV_COE 2U
#elif (TIMERB_0_CK3_DIV == 8U)
#define TIMERB_0_CK3_DIV_COE 3U
#elif (TIMERB_0_CK3_DIV == 16U)
#define TIMERB_0_CK3_DIV_COE 4U
#elif (TIMERB_0_CK3_DIV == 32U)
#define TIMERB_0_CK3_DIV_COE 5U
#elif (TIMERB_0_CK3_DIV == 64U)
#define TIMERB_0_CK3_DIV_COE 6U
#elif (TIMERB_0_CK3_DIV == 128U)
#define TIMERB_0_CK3_DIV_COE 7U
#elif (TIMERB_0_CK3_DIV == 256U)
#define TIMERB_0_CK3_DIV_COE 8U
#elif (TIMERB_0_CK3_DIV == 512U)
#define TIMERB_0_CK3_DIV_COE 9U
#elif (TIMERB_0_CK3_DIV == 1024U)
#define TIMERB_0_CK3_DIV_COE 10U
#elif (TIMERB_0_CK3_DIV == 2048U)
#define TIMERB_0_CK3_DIV_COE 11U
#elif (TIMERB_0_CK3_DIV == 4096U)
#define TIMERB_0_CK3_DIV_COE 12U
#elif (TIMERB_0_CK3_DIV == 8192U)
#define TIMERB_0_CK3_DIV_COE 13U
#elif (TIMERB_0_CK3_DIV == 16384U)
#define TIMERB_0_CK3_DIV_COE 14U
#elif (TIMERB_0_CK3_DIV == 32768U)
#define TIMERB_0_CK3_DIV_COE 15U
#else
#error Timer Parameter Error !!!
#endif
#if (TIMERB_1_CK0_DIV == 1U)
#define TIMERB_1_CK0_DIV_COE 0U
#elif (TIMERB_1_CK0_DIV == 2U)
#define TIMERB_1_CK0_DIV_COE 1U
#elif (TIMERB_1_CK0_DIV == 4U)
#define TIMERB_1_CK0_DIV_COE 2U
#elif (TIMERB_1_CK0_DIV == 8U)
#define TIMERB_1_CK0_DIV_COE 3U
#elif (TIMERB_1_CK0_DIV == 16U)
#define TIMERB_1_CK0_DIV_COE 4U
#elif (TIMERB_1_CK0_DIV == 32U)
#define TIMERB_1_CK0_DIV_COE 5U
#elif (TIMERB_1_CK0_DIV == 64U)
#define TIMERB_1_CK0_DIV_COE 6U
#elif (TIMERB_1_CK0_DIV == 128U)
#define TIMERB_1_CK0_DIV_COE 7U
#elif (TIMERB_1_CK0_DIV == 256U)
#define TIMERB_1_CK0_DIV_COE 8U
#elif (TIMERB_1_CK0_DIV == 512U)
#define TIMERB_1_CK0_DIV_COE 9U
#elif (TIMERB_1_CK0_DIV == 1024U)
#define TIMERB_1_CK0_DIV_COE 10U
#elif (TIMERB_1_CK0_DIV == 2048U)
#define TIMERB_1_CK0_DIV_COE 11U
#elif (TIMERB_1_CK0_DIV == 4096U)
#define TIMERB_1_CK0_DIV_COE 12U
#elif (TIMERB_1_CK0_DIV == 8192U)
#define TIMERB_1_CK0_DIV_COE 13U
#elif (TIMERB_1_CK0_DIV == 16384U)
#define TIMERB_1_CK0_DIV_COE 14U
#elif (TIMERB_1_CK0_DIV == 32768U)
#define TIMERB_1_CK0_DIV_COE 15U
#else
#error Timer Parameter Error !!!
#endif
#if (TIMERB_1_CK1_DIV == 1U)
#define TIMERB_1_CK1_DIV_COE 0U
#elif (TIMERB_1_CK1_DIV == 2U)
#define TIMERB_1_CK1_DIV_COE 1U
#elif (TIMERB_1_CK1_DIV == 4U)
#define TIMERB_1_CK1_DIV_COE 2U
#elif (TIMERB_1_CK1_DIV == 8U)
#define TIMERB_1_CK1_DIV_COE 3U
#elif (TIMERB_1_CK1_DIV == 16U)
#define TIMERB_1_CK1_DIV_COE 4U
#elif (TIMERB_1_CK1_DIV == 32U)
#define TIMERB_1_CK1_DIV_COE 5U
#elif (TIMERB_1_CK1_DIV == 64U)
#define TIMERB_1_CK1_DIV_COE 6U
#elif (TIMERB_1_CK1_DIV == 128U)
#define TIMERB_1_CK1_DIV_COE 7U
#elif (TIMERB_1_CK1_DIV == 256U)
#define TIMERB_1_CK1_DIV_COE 8U
#elif (TIMERB_1_CK1_DIV == 512U)
#define TIMERB_1_CK1_DIV_COE 9U
#elif (TIMERB_1_CK1_DIV == 1024U)
#define TIMERB_1_CK1_DIV_COE 10U
#elif (TIMERB_1_CK1_DIV == 2048U)
#define TIMERB_1_CK1_DIV_COE 11U
#elif (TIMERB_1_CK1_DIV == 4096U)
#define TIMERB_1_CK1_DIV_COE 12U
#elif (TIMERB_1_CK1_DIV == 8192U)
#define TIMERB_1_CK1_DIV_COE 13U
#elif (TIMERB_1_CK1_DIV == 16384U)
#define TIMERB_1_CK1_DIV_COE 14U
#elif (TIMERB_1_CK1_DIV == 32768U)
#define TIMERB_1_CK1_DIV_COE 15U
#else
#error Timer Parameter Error !!!
#endif
#if (TIMERB_1_CK2_DIV == 1U)
#define TIMERB_1_CK2_DIV_COE 0U
#elif (TIMERB_1_CK2_DIV == 2U)
#define TIMERB_1_CK2_DIV_COE 1U
#elif (TIMERB_1_CK2_DIV == 4U)
#define TIMERB_1_CK2_DIV_COE 2U
#elif (TIMERB_1_CK2_DIV == 8U)
#define TIMERB_1_CK2_DIV_COE 3U
#elif (TIMERB_1_CK2_DIV == 16U)
#define TIMERB_1_CK2_DIV_COE 4U
#elif (TIMERB_1_CK2_DIV == 32U)
#define TIMERB_1_CK2_DIV_COE 5U
#elif (TIMERB_1_CK2_DIV == 64U)
#define TIMERB_1_CK2_DIV_COE 6U
#elif (TIMERB_1_CK2_DIV == 128U)
#define TIMERB_1_CK2_DIV_COE 7U
#elif (TIMERB_1_CK2_DIV == 256U)
#define TIMERB_1_CK2_DIV_COE 8U
#elif (TIMERB_1_CK2_DIV == 512U)
#define TIMERB_1_CK2_DIV_COE 9U
#elif (TIMERB_1_CK2_DIV == 1024U)
#define TIMERB_1_CK2_DIV_COE 10U
#elif (TIMERB_1_CK2_DIV == 2048U)
#define TIMERB_1_CK2_DIV_COE 11U
#elif (TIMERB_1_CK2_DIV == 4096U)
#define TIMERB_1_CK2_DIV_COE 12U
#elif (TIMERB_1_CK2_DIV == 8192U)
#define TIMERB_1_CK2_DIV_COE 13U
#elif (TIMERB_1_CK2_DIV == 16384U)
#define TIMERB_1_CK2_DIV_COE 14U
#elif (TIMERB_1_CK2_DIV == 32768U)
#define TIMERB_1_CK2_DIV_COE 15U
#else
#error Timer Parameter Error !!!
#endif
#if (TIMERB_1_CK3_DIV == 1U)
#define TIMERB_1_CK3_DIV_COE 0U
#elif (TIMERB_1_CK3_DIV == 2U)
#define TIMERB_1_CK3_DIV_COE 1U
#elif (TIMERB_1_CK3_DIV == 4U)
#define TIMERB_1_CK3_DIV_COE 2U
#elif (TIMERB_1_CK3_DIV == 8U)
#define TIMERB_1_CK3_DIV_COE 3U
#elif (TIMERB_1_CK3_DIV == 16U)
#define TIMERB_1_CK3_DIV_COE 4U
#elif (TIMERB_1_CK3_DIV == 32U)
#define TIMERB_1_CK3_DIV_COE 5U
#elif (TIMERB_1_CK3_DIV == 64U)
#define TIMERB_1_CK3_DIV_COE 6U
#elif (TIMERB_1_CK3_DIV == 128U)
#define TIMERB_1_CK3_DIV_COE 7U
#elif (TIMERB_1_CK3_DIV == 256U)
#define TIMERB_1_CK3_DIV_COE 8U
#elif (TIMERB_1_CK3_DIV == 512U)
#define TIMERB_1_CK3_DIV_COE 9U
#elif (TIMERB_1_CK3_DIV == 1024U)
#define TIMERB_1_CK3_DIV_COE 10U
#elif (TIMERB_1_CK3_DIV == 2048U)
#define TIMERB_1_CK3_DIV_COE 11U
#elif (TIMERB_1_CK3_DIV == 4096U)
#define TIMERB_1_CK3_DIV_COE 12U
#elif (TIMERB_1_CK3_DIV == 8192U)
#define TIMERB_1_CK3_DIV_COE 13U
#elif (TIMERB_1_CK3_DIV == 16384U)
#define TIMERB_1_CK3_DIV_COE 14U
#elif (TIMERB_1_CK3_DIV == 32768U)
#define TIMERB_1_CK3_DIV_COE 15U
#else
#error Timer Parameter Error !!!
#endif
#if (TIMERB_2_CK0_DIV == 1U)
#define TIMERB_2_CK0_DIV_COE 0U
#elif (TIMERB_2_CK0_DIV == 2U)
#define TIMERB_2_CK0_DIV_COE 1U
#elif (TIMERB_2_CK0_DIV == 4U)
#define TIMERB_2_CK0_DIV_COE 2U
#elif (TIMERB_2_CK0_DIV == 8U)
#define TIMERB_2_CK0_DIV_COE 3U
#elif (TIMERB_2_CK0_DIV == 16U)
#define TIMERB_2_CK0_DIV_COE 4U
#elif (TIMERB_2_CK0_DIV == 32U)
#define TIMERB_2_CK0_DIV_COE 5U
#elif (TIMERB_2_CK0_DIV == 64U)
#define TIMERB_2_CK0_DIV_COE 6U
#elif (TIMERB_2_CK0_DIV == 128U)
#define TIMERB_2_CK0_DIV_COE 7U
#elif (TIMERB_2_CK0_DIV == 256U)
#define TIMERB_2_CK0_DIV_COE 8U
#elif (TIMERB_2_CK0_DIV == 512U)
#define TIMERB_2_CK0_DIV_COE 9U
#elif (TIMERB_2_CK0_DIV == 1024U)
#define TIMERB_2_CK0_DIV_COE 10U
#elif (TIMERB_2_CK0_DIV == 2048U)
#define TIMERB_2_CK0_DIV_COE 11U
#elif (TIMERB_2_CK0_DIV == 4096U)
#define TIMERB_2_CK0_DIV_COE 12U
#elif (TIMERB_2_CK0_DIV == 8192U)
#define TIMERB_2_CK0_DIV_COE 13U
#elif (TIMERB_2_CK0_DIV == 16384U)
#define TIMERB_2_CK0_DIV_COE 14U
#elif (TIMERB_2_CK0_DIV == 32768U)
#define TIMERB_2_CK0_DIV_COE 15U
#else
#error Timer Parameter Error !!!
#endif
#if (TIMERB_2_CK1_DIV == 1U)
#define TIMERB_2_CK1_DIV_COE 0U
#elif (TIMERB_2_CK1_DIV == 2U)
#define TIMERB_2_CK1_DIV_COE 1U
#elif (TIMERB_2_CK1_DIV == 4U)
#define TIMERB_2_CK1_DIV_COE 2U
#elif (TIMERB_2_CK1_DIV == 8U)
#define TIMERB_2_CK1_DIV_COE 3U
#elif (TIMERB_2_CK1_DIV == 16U)
#define TIMERB_2_CK1_DIV_COE 4U
#elif (TIMERB_2_CK1_DIV == 32U)
#define TIMERB_2_CK1_DIV_COE 5U
#elif (TIMERB_2_CK1_DIV == 64U)
#define TIMERB_2_CK1_DIV_COE 6U
#elif (TIMERB_2_CK1_DIV == 128U)
#define TIMERB_2_CK1_DIV_COE 7U
#elif (TIMERB_2_CK1_DIV == 256U)
#define TIMERB_2_CK1_DIV_COE 8U
#elif (TIMERB_2_CK1_DIV == 512U)
#define TIMERB_2_CK1_DIV_COE 9U
#elif (TIMERB_2_CK1_DIV == 1024U)
#define TIMERB_2_CK1_DIV_COE 10U
#elif (TIMERB_2_CK1_DIV == 2048U)
#define TIMERB_2_CK1_DIV_COE 11U
#elif (TIMERB_2_CK1_DIV == 4096U)
#define TIMERB_2_CK1_DIV_COE 12U
#elif (TIMERB_2_CK1_DIV == 8192U)
#define TIMERB_2_CK1_DIV_COE 13U
#elif (TIMERB_2_CK1_DIV == 16384U)
#define TIMERB_2_CK1_DIV_COE 14U
#elif (TIMERB_2_CK1_DIV == 32768U)
#define TIMERB_2_CK1_DIV_COE 15U
#else
#error Timer Parameter Error !!!
#endif
#if (TIMERB_2_CK2_DIV == 1U)
#define TIMERB_2_CK2_DIV_COE 0U
#elif (TIMERB_2_CK2_DIV == 2U)
#define TIMERB_2_CK2_DIV_COE 1U
#elif (TIMERB_2_CK2_DIV == 4U)
#define TIMERB_2_CK2_DIV_COE 2U
#elif (TIMERB_2_CK2_DIV == 8U)
#define TIMERB_2_CK2_DIV_COE 3U
#elif (TIMERB_2_CK2_DIV == 16U)
#define TIMERB_2_CK2_DIV_COE 4U
#elif (TIMERB_2_CK2_DIV == 32U)
#define TIMERB_2_CK2_DIV_COE 5U
#elif (TIMERB_2_CK2_DIV == 64U)
#define TIMERB_2_CK2_DIV_COE 6U
#elif (TIMERB_2_CK2_DIV == 128U)
#define TIMERB_2_CK2_DIV_COE 7U
#elif (TIMERB_2_CK2_DIV == 256U)
#define TIMERB_2_CK2_DIV_COE 8U
#elif (TIMERB_2_CK2_DIV == 512U)
#define TIMERB_2_CK2_DIV_COE 9U
#elif (TIMERB_2_CK2_DIV == 1024U)
#define TIMERB_2_CK2_DIV_COE 10U
#elif (TIMERB_2_CK2_DIV == 2048U)
#define TIMERB_2_CK2_DIV_COE 11U
#elif (TIMERB_2_CK2_DIV == 4096U)
#define TIMERB_2_CK2_DIV_COE 12U
#elif (TIMERB_2_CK2_DIV == 8192U)
#define TIMERB_2_CK2_DIV_COE 13U
#elif (TIMERB_2_CK2_DIV == 16384U)
#define TIMERB_2_CK2_DIV_COE 14U
#elif (TIMERB_2_CK2_DIV == 32768U)
#define TIMERB_2_CK2_DIV_COE 15U
#else
#error Timer Parameter Error !!!
#endif
#if (TIMERB_2_CK3_DIV == 1U)
#define TIMERB_2_CK3_DIV_COE 0U
#elif (TIMERB_2_CK3_DIV == 2U)
#define TIMERB_2_CK3_DIV_COE 1U
#elif (TIMERB_2_CK3_DIV == 4U)
#define TIMERB_2_CK3_DIV_COE 2U
#elif (TIMERB_2_CK3_DIV == 8U)
#define TIMERB_2_CK3_DIV_COE 3U
#elif (TIMERB_2_CK3_DIV == 16U)
#define TIMERB_2_CK3_DIV_COE 4U
#elif (TIMERB_2_CK3_DIV == 32U)
#define TIMERB_2_CK3_DIV_COE 5U
#elif (TIMERB_2_CK3_DIV == 64U)
#define TIMERB_2_CK3_DIV_COE 6U
#elif (TIMERB_2_CK3_DIV == 128U)
#define TIMERB_2_CK3_DIV_COE 7U
#elif (TIMERB_2_CK3_DIV == 256U)
#define TIMERB_2_CK3_DIV_COE 8U
#elif (TIMERB_2_CK3_DIV == 512U)
#define TIMERB_2_CK3_DIV_COE 9U
#elif (TIMERB_2_CK3_DIV == 1024U)
#define TIMERB_2_CK3_DIV_COE 10U
#elif (TIMERB_2_CK3_DIV == 2048U)
#define TIMERB_2_CK3_DIV_COE 11U
#elif (TIMERB_2_CK3_DIV == 4096U)
#define TIMERB_2_CK3_DIV_COE 12U
#elif (TIMERB_2_CK3_DIV == 8192U)
#define TIMERB_2_CK3_DIV_COE 13U
#elif (TIMERB_2_CK3_DIV == 16384U)
#define TIMERB_2_CK3_DIV_COE 14U
#elif (TIMERB_2_CK3_DIV == 32768U)
#define TIMERB_2_CK3_DIV_COE 15U
#else
#error Timer Parameter Error !!!
#endif

static const uint32_t u32TimerBClockArray[12U] =
{
    TIMERB_0_CK0,
    TIMERB_0_CK1,
    TIMERB_0_CK2,
    TIMERB_0_CK3,
    TIMERB_1_CK0,
    TIMERB_1_CK1,
    TIMERB_1_CK2,
    TIMERB_1_CK3,
    TIMERB_2_CK0,
    TIMERB_2_CK1,
    TIMERB_2_CK2,
    TIMERB_2_CK3,

};
/*-------------------------------------------------------*/

/*-----------------------------------------*/
void TimerB_PWM_Init(void);
static void TimerB_PWM_Master_Channel_Init(TIMERB_Channel_en_t enTimerBChannel, TIMERB_Clock_en_t enTimerBClock);
static void TimerB_PWM_Slave_Channel_Init(TIMERB_Channel_en_t enTimerBChannel, TIMERB_Clock_en_t enTimerBClock, TIMERB_Polarity_en_t enTimerBPolarity);
uint8_t TimerB_PWM_Channel_Init(TIMERB_Channel_en_t enTimerBChannel, TIMERB_Clock_en_t enTimerBClock, TIMERB_Polarity_en_t enTimerBPolarity);
uint32_t TimerB_PWM_Channel_Fre_Set(TIMERB_Channel_en_t enTimerBChannel, uint16_t u16Fre, uint16_t u16Duty);
void TimerB_PWM_Channel_Duty_Set(TIMERB_Channel_en_t enTimerBChannel, uint16_t u16Duty);
void TimerB_PWM_Channel_Start(TIMERB_Channel_en_t enTimerBChannel);
void TimerB_PWM_Channel_Stop(TIMERB_Channel_en_t enTimerBChannel);
static void TimerB_VehFreOut_Init(void);
static void TimerB_EngFreOut_Init(void);

static void TimerB_BackLight_Demo_Init(void)
{
    //表盘背光
    TimerB_PWM_Channel_Init(TIMERB_0_CH15, TIMERB_CLOCK_0, TIMERB_HIGH);
    TimerB_PWM_Channel_Fre_Set(TIMERB_0_CH15, 3000U, 0u);
    //TimerB_PWM_Channel_Duty_Set(TIMERB_0_CH15, 0u);
    TimerB_PWM_Channel_Start(TIMERB_0_CH15);

    //8867_BL_PWM TFT背光
    TimerB_PWM_Channel_Init(TIMERB_2_CH1 , TIMERB_CLOCK_0 , TIMERB_HIGH );
    TimerB_PWM_Channel_Fre_Set(TIMERB_2_CH1 , 3000U , 0u);
    TimerB_PWM_Channel_Start(TIMERB_2_CH1 );

    //水温白灯
    //TimerB_PWM_Channel_Init(TIMERB_1_CH10, TIMERB_CLOCK_0, TIMERB_HIGH);
    //TimerB_PWM_Channel_Fre_Set(TIMERB_1_CH10, 3000U, 0u);
    //TimerB_PWM_Channel_Start(TIMERB_1_CH10);

    //水温背光白灯
    TimerB_PWM_Channel_Init(TIMERB_2_CH7, TIMERB_CLOCK_0, TIMERB_HIGH);
    TimerB_PWM_Channel_Fre_Set(TIMERB_2_CH7, 3000U, 0u);
    TimerB_PWM_Channel_Start(TIMERB_2_CH7);

    //燃油白灯
    TimerB_PWM_Channel_Init(TIMERB_1_CH15, TIMERB_CLOCK_0, TIMERB_HIGH);
    TimerB_PWM_Channel_Fre_Set(TIMERB_1_CH15, 3000U, 0u);
    TimerB_PWM_Channel_Start(TIMERB_1_CH15);
}
/*车速频率输出PWM初始化*/
static void TimerB_VehFreOut_Init(void)
{
    //车速1
    //TimerB_PWM_Channel_Init(TIMERB_2_CH10 , TIMERB_CLOCK_0 , TIMERB_HIGH );
    //TimerB_PWM_Channel_Fre_Set(TIMERB_2_CH10 , 1U , 0u);
    //TimerB_PWM_Channel_Start(TIMERB_2_CH10 );

    //车速2
    //TimerB_PWM_Channel_Init(TIMERB_2_CH13, TIMERB_CLOCK_0, TIMERB_HIGH);
    //TimerB_PWM_Channel_Fre_Set(TIMERB_2_CH13, 1U, 0u);
    //TimerB_PWM_Channel_Start(TIMERB_2_CH13);

    //车速3
    //TimerB_PWM_Channel_Init(TIMERB_2_CH15, TIMERB_CLOCK_0, TIMERB_HIGH);
    //TimerB_PWM_Channel_Fre_Set(TIMERB_2_CH15, 1U, 0u);
    //TimerB_PWM_Channel_Start(TIMERB_2_CH15);
}
/*转速频率输出PWM初始化*/
static void TimerB_EngFreOut_Init(void)
{
    TimerB_PWM_Channel_Init(TIMERB_0_CH7, TIMERB_CLOCK_3, TIMERB_LOW);
    TimerB_PWM_Channel_Fre_Set(TIMERB_0_CH7, 0u, 0u);
    TimerB_PWM_Channel_Start(TIMERB_0_CH7);
}
/*蜂鸣器PWM初始化*/
void TimerB_Buzzer_Init(void)
{
    TimerB_PWM_Channel_Init(TIMERB_0_CH11, TIMERB_CLOCK_0, TIMERB_HIGH);
    TimerB_PWM_Channel_Fre_Set(TIMERB_0_CH11, 3000U, 0u);
    TimerB_PWM_Channel_Start(TIMERB_0_CH11);
}

/*----------------------------------------------*/
void TimerB_PWM_Init(void)
{
    uint16_t u16TimeCount = 0U;
    /*stop all clk*/
    TAUB0TT = 0xFFFFU;
    TAUB1TT = 0xFFFFU;
    TAUB2TT = 0xFFFFU;

    do
    {
        u16TimeCount++;
    }
    while (((TAUB0TE) || (TAUB1TE) || (TAUB2TE)) && (u16TimeCount < TIMERB_TIMEROUT_MAX));
    if (u16TimeCount < TIMERB_TIMEROUT_MAX)
    {
        /*CLK0~3 =PCLK */
        TAUB0TPS = ((TIMERB_0_CK3_DIV_COE << 12U) | (TIMERB_0_CK2_DIV_COE << 8U) | (TIMERB_0_CK1_DIV_COE << 4U) | (TIMERB_0_CK0_DIV_COE));
        TAUB1TPS = ((TIMERB_1_CK3_DIV_COE << 12U) | (TIMERB_1_CK2_DIV_COE << 8U) | (TIMERB_1_CK1_DIV_COE << 4U) | (TIMERB_1_CK0_DIV_COE));
        TAUB2TPS = ((TIMERB_2_CK3_DIV_COE << 12U) | (TIMERB_2_CK2_DIV_COE << 8U) | (TIMERB_2_CK1_DIV_COE << 4U) | (TIMERB_2_CK0_DIV_COE));
    }

    TimerB_BackLight_Demo_Init();
    TimerB_VehFreOut_Init();
    TimerB_EngFreOut_Init();

    //TimerB_Input_Channel_Init(TIMERB_0_CH2, TIMERB_CLOCK_3, TIMERB_RISING); //车速输入捕获
    //TimerB_Input_Channel_Start(TIMERB_0_CH2);
}
static void TimerB_PWM_Master_Channel_Init(TIMERB_Channel_en_t enTimerBChannel, TIMERB_Clock_en_t enTimerBClock)
{
    uint8_t u8TimerBIndex = enTimerBChannel / 16U;
    uint8_t u8TimerBChannel = enTimerBChannel % 16U;
    uint16_t u16ClockSelectRe = (0x801U | (enTimerBClock << 14U));
    uint16_t u16TimerBbit = (1U << u8TimerBChannel);

    uint32_t u32TimerBRegBaseAddr = TIMERB_BASE_ADDRESSES + (u8TimerBIndex * 0X1000U);
    uint32_t u32TimerBRegAddrChannel = 0U;

    /*control*/
    u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X200U + (4U * u8TimerBChannel);
    *((uint16_t *)u32TimerBRegAddrChannel) = u16ClockSelectRe;
    /*TAUB0CMOR2 = u16ClockSelectRe;*/

    u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0XC0U + (4U * u8TimerBChannel);
    *((uint8_t *)u32TimerBRegAddrChannel) = 0U;
    /*TAUB0CMUR2 = 0U;*/

    /*output mode*/

    /*Simultaneous rewrite */
    u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X260U;
    (*((uint16_t *)u32TimerBRegAddrChannel)) |= u16TimerBbit;
    /*TAUB0RDE |= u16TimerBbit;*/

    u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X268U;
    (*((uint16_t *)u32TimerBRegAddrChannel)) &= (~u16TimerBbit);
    /*TAUB0RDS &= (~u16TimerBbit);*/

    u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X264U;
    (*((uint16_t *)u32TimerBRegAddrChannel)) &= (~u16TimerBbit);
    /*TAUB0RDM &= (~u16TimerBbit);*/

    u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X26CU;
    (*((uint16_t *)u32TimerBRegAddrChannel)) &= (~u16TimerBbit);
    /*TAUB0RDC &= (~u16TimerBbit);*/
}
static void TimerB_PWM_Slave_Channel_Init(TIMERB_Channel_en_t enTimerBChannel, TIMERB_Clock_en_t enTimerBClock, TIMERB_Polarity_en_t enTimerBPolarity)
{
    uint8_t u8TimerBIndex = enTimerBChannel / 16U;
    uint8_t u8TimerBChannel = enTimerBChannel % 16U;
    uint16_t u16ClockSelectRe = (0x409U | (enTimerBClock << 14U));
    uint16_t u16TimerBbit = (1U << u8TimerBChannel);

    uint32_t u32TimerBRegBaseAddr = TIMERB_BASE_ADDRESSES + (u8TimerBIndex * 0X1000U);
    uint32_t u32TimerBRegAddrChannel = 0U;

    u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X200U + (4U * u8TimerBChannel);
    *((uint16_t *)u32TimerBRegAddrChannel) = u16ClockSelectRe;
    /*TAUB0CMOR3 = u16ClockSelectRe;*/

    u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0XC0U + (4U * u8TimerBChannel);
    *((uint8_t *)u32TimerBRegAddrChannel) = 0U;
    /*TAUB0CMUR3 = 0U;*/

    /*output mode*/
    u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X5CU;
    *((uint16_t *)u32TimerBRegAddrChannel) |= u16TimerBbit;
    /*TAUB0TOE |= u16TimerBbit;*/

    u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X248U;
    *((uint16_t *)u32TimerBRegAddrChannel) |= u16TimerBbit;
    /*TAUB0TOM |= u16TimerBbit;*/

    u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X24CU;
    *((uint16_t *)u32TimerBRegAddrChannel) &= (~u16TimerBbit);
    /*TAUB0TOC &= (~u16TimerBbit);*/

    u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X40U;
    if (enTimerBPolarity == TIMERB_HIGH)
    {
        /*TAUB0TOL &= (~u16TimerBbit);*/
        *((uint16_t *)u32TimerBRegAddrChannel) &= (~u16TimerBbit);
    }
    else
    {
        /*TAUB0TOL |= u16TimerBbit;*/
        *((uint16_t *)u32TimerBRegAddrChannel) |= u16TimerBbit;
    }

    u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X250U;
    *((uint16_t *)u32TimerBRegAddrChannel) &= (~u16TimerBbit);
    /*TAUB0TDE &= (~u16TimerBbit);*/

    u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X54U;
    *((uint16_t *)u32TimerBRegAddrChannel) &= (~u16TimerBbit);
    /*TAUB0TDL &= (~u16TimerBbit);*/

    /*Simultaneous rewrite */
    u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X260U;
    (*((uint16_t *)u32TimerBRegAddrChannel)) |= u16TimerBbit;
    /*TAUB0RDE |= u16TimerBbit;*/

    u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X268U;
    (*((uint16_t *)u32TimerBRegAddrChannel)) &= (~u16TimerBbit);
    /*TAUB0RDS &= (~u16TimerBbit);*/

    u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X264U;
    (*((uint16_t *)u32TimerBRegAddrChannel)) &= (~u16TimerBbit);
    /*TAUB0RDM &= (~u16TimerBbit);*/

    u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X26CU;
    (*((uint16_t *)u32TimerBRegAddrChannel)) &= (~u16TimerBbit);
    /*TAUB0RDC &= (~u16TimerBbit);*/
}

/* 返回初始化状态。1：成功。0：失败
    输出要设置的通道，通道选择的时钟源，通道有效时输出的极性*/
uint8_t TimerB_PWM_Channel_Init(TIMERB_Channel_en_t enTimerBChannel, TIMERB_Clock_en_t enTimerBClock, TIMERB_Polarity_en_t enTimerBPolarity)
{

    uint8_t u8TimerBResult = 0U;

    if ((enTimerBChannel % 2U))
    {
        u8TimerBResult = 1U;
        TimerB_PWM_Master_Channel_Init(enTimerBChannel - TIMERB_CHANNEL_INTERVAL, enTimerBClock);
        TimerB_PWM_Slave_Channel_Init(enTimerBChannel, enTimerBClock, enTimerBPolarity);
    }

    return u8TimerBResult;
}

/* 返回实际设置成功的频率，如果返回0表示错误。
频率单位：HZ
占空比精度千分之一*/
uint32_t TimerB_PWM_Channel_Fre_Set(TIMERB_Channel_en_t enTimerBChannel, uint16_t u16Fre, uint16_t u16Duty)
{

    uint8_t u8TimerBIndex = enTimerBChannel / 16U;
    uint8_t u8TimerBChannel = enTimerBChannel % 16U;
    uint16_t u16TimerBbit = (1U << (u8TimerBChannel - TIMERB_CHANNEL_INTERVAL)) * TIMERB_CHANNEL_BIT_MUL;

    uint32_t u32TimerBRegBaseAddr = TIMERB_BASE_ADDRESSES + (u8TimerBIndex * 0X1000U);
    uint32_t u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X200U + (4U * u8TimerBChannel);

    uint8_t u8TimerBClockSel = (uint8_t)(((*((uint16_t *)u32TimerBRegAddrChannel))) >> 14U);
    uint8_t u8TimerBClockIndex = u8TimerBIndex * 4U + u8TimerBClockSel;
    uint32_t u32TimerBClockFre = u32TimerBClockArray[u8TimerBClockIndex];
    uint32_t u32CalBuf = (u32TimerBClockFre / u16Fre);
    uint32_t u32CalFre = 0U;
    uint32_t u32Duty = u16Duty;
    if (enTimerBChannel % 2U)
    {
        u32CalFre = (u32TimerBClockFre / u32CalBuf);

        u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + (4U * (u8TimerBChannel));

        (*((uint16_t *)(u32TimerBRegAddrChannel - 4U * TIMERB_CHANNEL_INTERVAL))) = u32CalBuf - 1U;
        /*TAUB0CDR2 = u32CalBuf - 1U;  // fre*/

        (*((uint16_t *)u32TimerBRegAddrChannel)) = (u32Duty * u32CalBuf / 1000U);
        /*TAUB0CDR3 = (u32Duty * u32CalBuf / 100000U); //  duty*/

        u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X44U;
        (*((uint16_t *)u32TimerBRegAddrChannel)) = u16TimerBbit;
        /*TAUB0RDT = (u16TimerBbit);*/
    }
    return u32CalFre;
}
/*占空比精度千分之一*/
void TimerB_PWM_Channel_Duty_Set(TIMERB_Channel_en_t enTimerBChannel, uint16_t u16Duty)
{
    uint8_t u8TimerBIndex = enTimerBChannel / 16U;
    uint8_t u8TimerBChannel = enTimerBChannel % 16U;
    uint16_t u16TimerBbit = (1U << (u8TimerBChannel - TIMERB_CHANNEL_INTERVAL)) * TIMERB_CHANNEL_BIT_MUL;

    uint32_t u32TimerBRegBaseAddr = TIMERB_BASE_ADDRESSES + (u8TimerBIndex * 0X1000U);
    uint32_t u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + (4U * (u8TimerBChannel - TIMERB_CHANNEL_INTERVAL));

    uint32_t u32CalBuf = (*((uint16_t *)u32TimerBRegAddrChannel)) + 1U;
    /*  uint32_t u32CalBuf = TAUB0CDR2 + 1U;*/
    uint32_t u32Duty = u16Duty;

    if (enTimerBChannel % 2U)
    {
        (*((uint16_t *)(u32TimerBRegAddrChannel + 4U * TIMERB_CHANNEL_INTERVAL))) = (u32CalBuf * u32Duty / 1000U);
        /*TAUB0CDR3 = (u32CalBuf * u32Duty / 100U); */ /*duty*/

        u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X44U;
        (*((uint16_t *)u32TimerBRegAddrChannel)) = u16TimerBbit;
        /*TAUB0RDT = (u16TimerBbit);*/
    }
}

void TimerB_PWM_Channel_Start(TIMERB_Channel_en_t enTimerBChannel)
{
    uint8_t u8TimerBIndex = enTimerBChannel / 16U;
    uint8_t u8TimerBChannel = enTimerBChannel % 16U;
    uint16_t u16TimerBbit = (1U << (u8TimerBChannel - TIMERB_CHANNEL_INTERVAL)) * TIMERB_CHANNEL_BIT_MUL;

    uint32_t u32TimerBRegBaseAddr = TIMERB_BASE_ADDRESSES + (u8TimerBIndex * 0X1000U);
    uint32_t u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X1C4U;

    (*((uint16_t *)u32TimerBRegAddrChannel)) = u16TimerBbit;
    /*  TAUB0TS = (u16TimerBbit);*/
}
/*调用该函数后，仅重新调用开始函数功能即可正常使用*/
void TimerB_PWM_Channel_Stop(TIMERB_Channel_en_t enTimerBChannel)
{
    uint8_t u8TimerBIndex = enTimerBChannel / 16U;
    uint8_t u8TimerBChannel = enTimerBChannel % 16U;
    uint16_t u16TimerBbit = (1U << (u8TimerBChannel - TIMERB_CHANNEL_INTERVAL));

    uint32_t u32TimerBRegBaseAddr = TIMERB_BASE_ADDRESSES + (u8TimerBIndex * 0X1000U);
    uint32_t u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X1C8U;

    (*((uint16_t *)u32TimerBRegAddrChannel)) = u16TimerBbit;
    /*TAUB0TT = (u16TimerBbit);*/
}
/*仅休眠时可调用，调用该函数后需要重新初始化相关通道才可以正常使用。*/
void TimerB_PWM_Channel_Sleep(TIMERB_Channel_en_t enTimerBChannel)
{
    uint8_t u8TimerBIndex = enTimerBChannel / 16U;
    uint8_t u8TimerBChannel = enTimerBChannel % 16U;
    uint16_t u16TimerBbit = (1U << (u8TimerBChannel - TIMERB_CHANNEL_INTERVAL)) * TIMERB_CHANNEL_BIT_MUL;
    uint16_t u16TimerBRegTOL = 0U;
    uint32_t u32TimerBRegBaseAddr = TIMERB_BASE_ADDRESSES + (u8TimerBIndex * 0X1000U);
    uint32_t u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X1C8U;

    (*((uint16_t *)u32TimerBRegAddrChannel)) = u16TimerBbit;
    /*TAUB0TT = (u16TimerBbit);*/

    u16TimerBbit = u16TimerBbit * (TIMERB_CHANNEL_BIT_MUL - 1U) / TIMERB_CHANNEL_BIT_MUL;

    u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X40U;
    u16TimerBRegTOL = (*((uint16_t *)u32TimerBRegAddrChannel));
    /*u16TimerBRegTOL=TAUB0TOL*/
    u16TimerBRegTOL &= u16TimerBbit;

    u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X5CU;
    *((uint16_t *)u32TimerBRegAddrChannel) &= (~u16TimerBbit);
    /*TAUB0TOE &= ~u16TimerBbit;*/

    u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X58U;

    if (u16TimerBRegTOL)
    {
        *((uint16_t *)u32TimerBRegAddrChannel) |= (u16TimerBbit);
        /*TAUB0TO |= u16TimerBbit;*/
    }
    else
    {
        *((uint16_t *)u32TimerBRegAddrChannel) &= (~u16TimerBbit);
        /*TAUB0TO &= ~u16TimerBbit;*/
    }
}

/*------------------------------------------------------------------------------*/
/*------------------------------------------------------------------------------*/
/*------------------------------------------------------------------------------*/
/*------------------------------------------------------------------------------*/
/*------------------------------------------------------------------------------*/
/*------------------------------------------------------------------------------*/

void TimerB_Cal_Fre(TIMERB_Channel_en_t enTimerBChannel, uint32_t u32TimerBClockFre, uint16_t u16TimerBCount);

static void TimerB_Input_Capture_Channel_Init(TIMERB_Channel_en_t enTimerBChannel, TIMERB_Clock_en_t enTimerBClock, TIMERB_Edge_en_t enTimerBEdge)
{
    uint8_t u8TimerBIndex = enTimerBChannel / 16U;
    uint8_t u8TimerBChannel = enTimerBChannel % 16U;
    uint16_t u16ClockSelectRe = (0x156U | (enTimerBClock << 14U));
    uint16_t u16TimerBbit = (1U << u8TimerBChannel);

    uint32_t u32TimerBRegBaseAddr = TIMERB_BASE_ADDRESSES + (u8TimerBIndex * 0X1000U);
    uint32_t u32TimerBRegAddrChannel = 0U;

    /*control*/
    u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X200U + (4U * u8TimerBChannel);
    *((uint16_t *)u32TimerBRegAddrChannel) = u16ClockSelectRe;
    /*TAUB0CMOR10 = u16ClockSelectRe;*/

    u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0XC0U + (4U * u8TimerBChannel);
    *((uint8_t *)u32TimerBRegAddrChannel) = (uint8_t)enTimerBEdge;
    /*TAUB0CMUR10 = enTimerBEdge;*/

    /*output mode*/
    /*Simultaneous rewrite */
}
/**/
static void TimerB_Interval_Timer_Channel_Init(TIMERB_Channel_en_t enTimerBChannel, TIMERB_Clock_en_t enTimerBClock)
{
    uint8_t u8TimerBIndex = enTimerBChannel / 16U;
    uint8_t u8TimerBChannel = enTimerBChannel % 16U;
    uint16_t u16ClockSelectRe = (0x00U | (enTimerBClock << 14U));
    uint16_t u16TimerBbit = (1U << u8TimerBChannel);

    uint32_t u32TimerBRegBaseAddr = TIMERB_BASE_ADDRESSES + (u8TimerBIndex * 0X1000U);
    uint32_t u32TimerBRegAddrChannel = 0U;

    u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X200U + (4U * u8TimerBChannel);
    *((uint16_t *)u32TimerBRegAddrChannel) = u16ClockSelectRe;
    /*TAUB0CMOR3 = u16ClockSelectRe;*/

    u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0XC0U + (4U * u8TimerBChannel);
    *((uint8_t *)u32TimerBRegAddrChannel) = 0U;
    /*TAUB0CMUR3 = 0U;*/

    /*output mode*/
    /*Simultaneous rewrite */

    u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + (4U * u8TimerBChannel);
    *((uint16_t *)u32TimerBRegAddrChannel) = 0xFFFFU;
    /*TAUB0CDR9 = 0xFFFFU;*/
}

void TimerB_Input_Channel_Init(TIMERB_Channel_en_t enTimerBChannel, TIMERB_Clock_en_t enTimerBClock, TIMERB_Edge_en_t enTimerBEdge)
{
    TimerB_Input_Capture_Channel_Init(enTimerBChannel, enTimerBClock, enTimerBEdge);
    TimerB_Interval_Timer_Channel_Init(enTimerBChannel - 1, enTimerBClock);

    /*
    R_DEV_IntEnable(R_DEV_INT_TAUB0I9, 1U);
    R_DEV_IntEnable(R_DEV_INT_TAUB0I10, 1U);
    */
}

void TimerB_Input_Channel_Start(TIMERB_Channel_en_t enTimerBChannel)
{
    uint8_t u8TimerBIndex = enTimerBChannel / 16U;
    uint8_t u8TimerBChannel = enTimerBChannel % 16U;
    uint16_t u16TimerBbit = (1U << (u8TimerBChannel - TIMERB_CHANNEL_INTERVAL)) * TIMERB_CHANNEL_BIT_MUL;

    uint32_t u32TimerBRegBaseAddr = TIMERB_BASE_ADDRESSES + (u8TimerBIndex * 0X1000U);
    uint32_t u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X1C4U;

    (*((uint16_t *)u32TimerBRegAddrChannel)) = u16TimerBbit;
    /*  TAUB0TS = (u16TimerBbit);*/
}
void TimerB_Input_Channel_Stop(TIMERB_Channel_en_t enTimerBChannel)
{
    uint8_t u8TimerBIndex = enTimerBChannel / 16U;
    uint8_t u8TimerBChannel = enTimerBChannel % 16U;
    uint16_t u16TimerBbit = (1U << (u8TimerBChannel - TIMERB_CHANNEL_INTERVAL)) * TIMERB_CHANNEL_BIT_MUL;

    uint32_t u32TimerBRegBaseAddr = TIMERB_BASE_ADDRESSES + (u8TimerBIndex * 0X1000U);
    uint32_t u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X1C8U;

    (*((uint16_t *)u32TimerBRegAddrChannel)) = u16TimerBbit;
    /*TAUB0TT = (u16TimerBbit);*/
}
uint32_t u32YZHDTest4 = 0;
uint32_t u32YZHDTest5 = 0;
/*捕获中断*/
void TimerB_Input_Isr(TIMERB_Channel_en_t enTimerBChannel)
{
    /*----------------------------------------------------------------------------*/
    uint8_t u8TimerBIndex = enTimerBChannel / 16U;
    uint8_t u8TimerBChannel = enTimerBChannel % 16U;

    uint32_t u32TimerBRegBaseAddr = TIMERB_BASE_ADDRESSES + (u8TimerBIndex * 0X1000U);
    uint32_t u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + 0X200U + (4U * u8TimerBChannel);

    uint8_t u8TimerBClockSel = (uint8_t)(((*((uint16_t *)u32TimerBRegAddrChannel))) >> 14U);
    uint8_t u8TimerBClockIndex = u8TimerBIndex * 4U + u8TimerBClockSel;

    uint32_t u32TimerBChannelClock = 0UL;
    uint32_t u32TimerBChannelData = 0UL;

    uint32_t i = 0;

    u32TimerBRegAddrChannel = u32TimerBRegBaseAddr + (4U * (u8TimerBChannel));

    /*通道使用的时钟频率*/
    u32TimerBChannelClock = u32TimerBClockArray[u8TimerBClockIndex];
    /*通道返回的计数值，滚动计数，不清除*/
    u32TimerBChannelData = (*((uint16_t *)u32TimerBRegAddrChannel)) + 1UL;

    /*----------------------------------------------------------------------------*/

    TimerB_Cal_Fre(enTimerBChannel, u32TimerBChannelClock, u32TimerBChannelData);


    R_DEV_IntClearFlag(R_DEV_INT_TAUB0I0 + enTimerBChannel);
    for ( i = 0; i < 600; i++)
    {
        u32YZHDTest4++;
    }


}
/*溢出中断*/
void TimerB_Overflow_Isr(void)
{
}
uint32_t u32TimerBInputDataLast = 0;
uint32_t u32TimerBInputData = 0;
uint32_t u32TimerBInputDataDif = 0;
uint32_t u32TimerBInputFre = 0;
uint32_t u32TimeOut = 0 ;
uint8_t N_Count = 0 ;
uint8_t Fre_Event ;
#define  FRE_VEH_TIMEOUT    500000  // 1hz

/*
形参分别表示，通道号，通道时钟频率，通道计数器的数值。
*/
uint32_t u32YZHDTest = 20;
uint32_t u32YZHDTest1 = 0;
uint32_t u32YZHDTest2 = 0;
uint32_t u32YZHDTest3 = 0;
void TimerB_Cal_Fre(TIMERB_Channel_en_t enTimerBChannel, uint32_t u32TimerBClockFre, uint16_t u16TimerBCount)
{

    u32TimeOut = 0 ;
    if (N_Count < 2)
    {
        N_Count ++ ;
    }
    u32TimerBInputData = u16TimerBCount;
    if (N_Count > 1)
    {
        Fre_Event = 1 ;
        if (u32TimerBInputDataLast < u32TimerBInputData)
        {
            u32TimerBInputDataDif = u32TimerBInputData - u32TimerBInputDataLast;
        }
        else
        {
            u32TimerBInputDataDif = 0xFFFF - u32TimerBInputDataLast + u32TimerBInputData + 1;
        }
    }

    if (u32TimerBInputDataDif < u32YZHDTest)
    {
        u32YZHDTest1++;
    }

    u32TimerBInputDataLast = u32TimerBInputData;
    if (u32TimerBInputDataDif)
    {
        u32TimerBInputFre = u32TimerBClockFre * 100 / u32TimerBInputDataDif;
    }
}

/*-----------------------*/
//TimerB_Input_Channel_Init(TIMERB_0_CH2, TIMERB_CLOCK_3, TIMERB_RISING);
//TimerB_Input_Channel_Start(TIMERB_0_CH2);

void TimerB_Fre_Timeout(uint8_t Time)
{

    if (u32TimeOut  < FRE_VEH_TIMEOUT)
    {
        u32TimeOut += Time ;
    }
    else
    {
        Fre_Event = 1 ;
        u32TimerBInputFre = 0 ;
        u32TimerBInputDataLast = u32TimerBInputData ;
        u32TimerBInputDataDif = 0 ;
        N_Count = 0 ;
    }
}

uint16_t Get_Veh_Fre(void)
{
    uint32_t u32Result = 0;

    u32Result = u32TimerBInputFre ;
    u32Result += 50 ;
    u32Result /= 100 ;

    return (uint16_t)u32Result ;
}

uint8_t Get_Veh_Fre_Event(void)
{
    uint8_t u8Result = 0 ;
    u8Result = Fre_Event ;
    Fre_Event = 0 ;
    return u8Result ;
}