#include "GUI_Interface.h"
#include "jcua.h"
#include "loc_graphics.h"
/******************************************************************************
函数名：GUI_General_Digit_Display
******************************************************************************/
/*数字显示函数
Digit：数值
u16Font:  字号
Len：  长度
Blank：消隐
*px:   X坐标，个位在前
 y:    Y坐标
*/
void GUI_General_Digit_Display(SpriteName_t SpriteID, uint32_t Digit, uint16_t u16Font, uint8_t Len, uint8_t Blank, const uint16_t *px, uint16_t y, uint8_t u8BlendEn)
{
    uint8_t i;
    uint8_t ActLen;
    uint8_t d[10];
    LogicLayerAttr_t LogicLayerAttr = {0};

    ActLen = 0;
    while (Digit)
    {
        d[ActLen] = Digit % 10;
        Digit /= 10;
        ActLen++;
    }

    if (ActLen == 0)
    {
        ActLen = 1;
        d[0] = 0;
    }

    for (i = ActLen; i < Len; i++ )
        d[i] = 0;


    i = (Len - 1);
    while ((d[i] == 0) && (i >= (Len - Blank)))
    {
        d[i] = 0xFF;
        i--;
    }

    loc_memset_LogicLayerAttr(&LogicLayerAttr);
    LogicLayerAttr.u8BlendEn = u8BlendEn;
    for (i = 0; i < Len; i++)
    {
        if (d[i] == 0xFF)
		{
			LogicLayerAttr.u16ImageID = SpriteSize;
            LogicLayerAttr.u16PosX = *(px + i);
            LogicLayerAttr.u16PosY = y;
            loc_RenderTexture_Normal(SpriteID, LogicLayerAttr);
		}
        else
        {
            LogicLayerAttr.u16ImageID = u16Font + d[i];
            LogicLayerAttr.u16PosX = *(px + i);
            LogicLayerAttr.u16PosY = y;
            loc_RenderTexture_Normal(SpriteID, LogicLayerAttr);
        }
    }
}

/*
Function  :                    GUI_Translate_Display
SpriteID  :                    The map's name
Position  :                    posx  posy
坐标自行填写
*/
void GUI_Translate_Display(SpriteName_t SpriteID, uint16_t ImageID, uint16_t Posx, uint16_t Posy, uint8_t u8BlendEn)
{
    LogicLayerAttr_t LogicLayerAttr = {0};

    loc_memset_LogicLayerAttr(&LogicLayerAttr);
    LogicLayerAttr.u16ImageID = ImageID;
    LogicLayerAttr.u16PosX = Posx;
    LogicLayerAttr.u16PosY = Posy;
    LogicLayerAttr.u8BlendEn = u8BlendEn;
    loc_RenderTexture_Normal(SpriteID, LogicLayerAttr);
}
/*
Function  :                    GUI_General_Display
SpriteID  :                    The map's name
坐标自动索引
底图用jpg格式用此函数
*/
void GUI_General_Display(SpriteName_t SpriteID, uint16_t ImageID, uint8_t u8BlendEn)
{
    LogicLayerAttr_t LogicLayerAttr = {0};
    t_PicStruct picStruct = get_Pic_Attribute(ImageID);

    if (picStruct .u16Pic_Format != JPG)
    {
        loc_memset_LogicLayerAttr(&LogicLayerAttr);
        LogicLayerAttr.u16ImageID = ImageID;
        LogicLayerAttr.u16PosX = picStruct.u16Pic_X;
        LogicLayerAttr.u16PosY = picStruct.u16Pic_Y;
        LogicLayerAttr.u8BlendEn = u8BlendEn;
        loc_RenderTexture_Normal(SpriteID, LogicLayerAttr);
    }
    else
    {
        loc_JcuaRun(picStruct .u32Pic_Addr);
    }
}
/*
Function  :                    GUI_Unicode_Display
SpriteID  :                    The map's name
Position  :                    posx  posy
坐标自行填写
*/
void GUI_Unicode_Display(SpriteName_t SpriteID, uint16_t Posx, uint16_t Posy, uint16_t Unicode[], uint8_t Length, uint32_t Color)
{
    LogicLayerAttr_t LogicLayerAttr = {0};

    loc_memset_LogicLayerAttr(&LogicLayerAttr);

    LogicLayerAttr.u16ImageID = 0u;
    LogicLayerAttr.u16PosX = Posx;
    LogicLayerAttr.u16PosY = Posy;
    LogicLayerAttr.u8UnicodeEn = 1u;
    LogicLayerAttr.u32UnicodeColor = Color;

    loc_Unicode_Normal(SpriteID, LogicLayerAttr, Unicode, Length);
}