#include "Data_DrivingSupport.h"
#include "CAN_Communication_Matrix.h"
//-------------------------------------------
//驾驶支援数据处理 wangboyu
//-------------------------------------------
//区域6显示逻辑 
//-------------------------------------------
//344 - 3.3 驾驶支援显示区域 
//-------------------------------------------
static struct
{
	uint8_t Gui_SysRunSta ;
	uint8_t Gui_SetSpeed ;
}DrivSupVariable ;

static void Data_SystemRunningState_2_Gui(void);
static void Data_SetSpeed_2_Gui(void);
/*-------------------------------------------------------------------------
 * Function Name  : ADAS_KL30_Init
 * Description    : 
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void DrivingSupport_KL30_Init(void)
{
	DrivSupVariable.Gui_SysRunSta = 0 ;
	DrivSupVariable.Gui_SetSpeed = 0 ;
}
void DrivingSupport_KL15_ON_Init(void)
{

}
void DrivingSupport_KL15_OFF_Init(void)
{

}
void DrivingSupport_Wakeup_Init(void)
{

}
void DrivingSupport_Sleep_Init(void)
{

}
/*-------------------------------------------------------------------------
 * Function Name  : DrivingSupport_Processing_Service
 * Description    : 
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void DrivingSupport_Processing_Service(void)
{
	Data_SystemRunningState_2_Gui();
	Data_SetSpeed_2_Gui();
}
/*-------------------------------------------------------------------------
 * Function Name  : Data_SystemRunningState_2_Gui
 * Description    : 系统运行状态逻辑处理
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
static void Data_SystemRunningState_2_Gui(void)
{
	uint8_t u8GuiMode = 0 ;
	uint8_t EOL = 0x01 ;
	uint8_t Msg_Cruise_VariableSLD_Disp = 0 ;
	uint8_t Msg_Cruise_VariableSLD_Cont_Staus = 0 ;
	Msg_Cruise_VariableSLD_Disp = Get_ID_18FF4100_Sig_Cruise_VariableSLD_Disp();
	Msg_Cruise_VariableSLD_Cont_Staus = Get_ID_18FF4100_Sig_Cruise_VariableSLD_Cont_Staus();
	
	if(Msg_Cruise_VariableSLD_Disp == 0x01)
	{//定速巡航
		if(EOL != 0x01)
		{
			u8GuiMode = 0 ;
		}
		else
		{
			if(Msg_Cruise_VariableSLD_Cont_Staus == 0x00)
			{
				u8GuiMode = 1 ;
			}
			else if(Msg_Cruise_VariableSLD_Cont_Staus == 0x01)
			{
				u8GuiMode = 2 ;
			}
			else if(Msg_Cruise_VariableSLD_Cont_Staus == 0x02)
			{
				u8GuiMode = 3;
			}
			else if(Msg_Cruise_VariableSLD_Cont_Staus == 0x03)
			{
				u8GuiMode = 4;
			}
			else
			{
				u8GuiMode = 0 ;
			}
		}		
	}
	else if(Msg_Cruise_VariableSLD_Disp == 0x03)
	{//SLD
		if(EOL == 0x00)
		{
			u8GuiMode = 0 ;
		}
		else if(EOL == 0x01)
		{
			if(Msg_Cruise_VariableSLD_Cont_Staus == 0x00)
			{
				u8GuiMode = 5 ;
			}
			else if(Msg_Cruise_VariableSLD_Cont_Staus == 0x01)
			{
				u8GuiMode = 6 ;
			}
			else if(Msg_Cruise_VariableSLD_Cont_Staus == 0x02)
			{
				u8GuiMode = 7 ;
			}
			else if(Msg_Cruise_VariableSLD_Cont_Staus == 0x03)
			{
				u8GuiMode = 8 ;
			}
			else
			{
				u8GuiMode = 0 ;
			}
		}
		else
		{
			u8GuiMode = 0 ;
		}
	}
	else
	{
		u8GuiMode = 0 ;
	}
	
	DrivSupVariable.Gui_SysRunSta = u8GuiMode ;
}
/*-------------------------------------------------------------------------
 * Function Name  : Data_SetSpeed_2_Gui
 * Description    : 设定车速逻辑处理
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
static void Data_SetSpeed_2_Gui(void)
{
	uint8_t u8GuiMode = 0 ;
	uint8_t Msg_Indicate_Lamp_Speed = 0xff ;
	
	Msg_Indicate_Lamp_Speed = Get_ID_18FF4100_Sig_Indicate_Lamp_Speed();
	
	if (CAN_MSG_Status(ID_CanMsg18FF4100_Msg_Count) == CAN_SIG_LOST)
	{
		u8GuiMode = 0xff ;
	}
	else
	{
		if(Msg_Indicate_Lamp_Speed == 0x00)
		{
			u8GuiMode = 0 ;
		}
		else if(Msg_Indicate_Lamp_Speed <= 0xFA)
		{
			u8GuiMode = Msg_Indicate_Lamp_Speed ;
		}
		else
		{
			u8GuiMode = 0xff ;
		}
	}

	DrivSupVariable.Gui_SetSpeed = u8GuiMode ;
	
	
}
/*-------------------------------------------------------------------------
 * Function Name  : Gui_Get_SystemRunningState_DisplayMode
 * Description    : 系统运行状态显示模式
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 刷图时使用
 --------------------------------------------------------------------------*/
uint8_t Gui_Get_SystemRunningState_DisplayMode(void)
{
	uint8_t u8Result = 0 ;
	u8Result = DrivSupVariable.Gui_SysRunSta ;
	return u8Result ;
}
/*-------------------------------------------------------------------------
 * Function Name  : Gui_Get_SetSpeed_DisplayMode
 * Description    : 设定车速显示模式
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 刷图时使用
 --------------------------------------------------------------------------*/
uint8_t Gui_Get_SetSpeed_DisplayMode(void)
{
	uint8_t u8Result = 0 ;
	u8Result = DrivSupVariable.Gui_SetSpeed ;
	return u8Result ;
}



