#include "GUI.h"

#include "r_typedefs.h"
#include "loc_graphics.h"
#include "images.h"
#include "jcua.h"
#include "Watchdog.h"
#include "Menu.h"
#include "GUI_Interface.h"
#include "CAN_Communication_Matrix.h"
#include "Services_Mileage.h"
#include "RTE_ADC.h"
#include "GaugesInterface.h"
#include "Service_TPMS.h"
#include "DisplaySch_user.h"
#include "CD4051.h"
#include "Data_Gear.h"
#include "Maintenance.h"
#include "Data_FuelConsump.h"
#include "Common_Interface.h"
#include "System_Monitor.h"
#include "Flash_synchronizer.h"
#include "GUI_VC66_Include.h"
#include "Popups.h"
#include "Data_Fuel_User.h"

/*-------------------------------------------------------------------------
 * Function Name  : GUI_Display_KL15_ON_Init
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void GUI_Display_KL15_ON_Init(void)
{
    loc_enable_mem(WET_Sprite, Calendar_Sprite);
    GUI_Display_background();
}
/*-------------------------------------------------------------------------
 * Function Name  : GUI_Display_KL15_OFF_Init
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void GUI_Display_KL15_OFF_Init(void)
{
    loc_Del_Sprite(WET_Sprite, Calendar_Sprite);
    loc_free_mem(WET_Sprite, Calendar_Sprite);
}

/*-------------------------------------------------------------------------
 * Function Name  : GUI_Display_background
 * Description    : 显示底图
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void GUI_Display_background(void)
{
    GUI_General_Display(WET_Sprite, ditu, GUI_BLENDMODE_CUSTOM);
}
/*-------------------------------------------------------------------------
 * Function Name  : GUI_Display_OftenShow_Group
 * Description    : 常显界面
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 常显功能界面均放在此处
 --------------------------------------------------------------------------*/
void GUI_Display_OftenShow_Group(void)
{
    Gui_Display_AC_AdBule();
    Gui_Display_AC_TEMP();
    Gui_Display_AC_WET();
    Gui_Display_ADAS();
    Gui_Display_Date();
    Gui_Display_DrivingSupport();
    Gui_Display_Gear();
    Gui_Display_ODO();
    Gui_Display_Time();
    Gui_Display_TRIPA();
}

/*-------------------------------------------------------------------------
 * Function Name  : GUI_Display_UsuallyConv
 * Description    : 通常显示选择
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/