/****************************************************************************
 *  License : All rights reserved for TES Electronic Solutions GmbH
 *            See included /docs/license.txt for details
 *  Project : D/AVE HD
 *  Purpose : Hardware ringbuffer management
 ****************************************************************************
 * Version Control Information :
 *  $Revision: 4436 $
 *  $Date: 2014-12-02 14:27:26 +0100 (Di, 02. Dez 2014) $
 *  $LastChangedBy: florian.zimmermann $
 ****************************************************************************
 * Change History (autogenerated):
 ****************************************************************************/    

#ifndef DAVEHD_KERNEL_RING_H_INCLUDED
#define DAVEHD_KERNEL_RING_H_INCLUDED

#include "davehd_types.h"

/*----------------------------------------------------------------------------------------------------------*/

#define DHD_RINGBUFFER_SIZE         2048     /* number of bytes used as default for device ringbuffer (must be po2)*/
#define DHD_MIN_RINGBUFFER_SIZE      256     /* number of bytes minimum size of ringbuffer (worst case write to ring is 42 words)*/
#define DHD_RINGBUFFER_GUARD_SIZE      4     /* number of bytes used for ringbuffer guard*/

/*----------------------------------------------------------------------------------------------------------*/

dhd_enum_t dhd_gpu_init_ring(dhd_gpu_device_data_t *a_device, dhd_uint32_t a_size);
dhd_enum_t dhd_gpu_write_to_ring(dhd_gpu_device_data_t *a_device, dhd_uint32_t const *a_data, dhd_uint32_t a_words);

/*----------------------------------------------------------------------------------------------------------*/

#endif /*DAVEHD_KERNEL_RING_H_INCLUDED*/
