#ifndef DATA_AIRPRESSURE_H
#define DATA_AIRPRESSURE_H

#include "GaugesInterface.h"
#include "TYW_stdint.h"

extern DataStruct DataStrGas1;
extern DataStruct DataStrGas2;
extern DataStruct DataStrWET;

extern void AirPressure_KL30_Init(void);
extern void AirPressure_KL15_ON_Init(void);
extern void AirPressure_KL15_OFF_Init(void);
extern void AirPressure_Wakeup_Init(void);
extern void AirPressure_Sleep_Init(void);
extern void AirPressure_Processing_Service(void);

void Data_Gas1_Processing_Service(void);
void Data_Gas2_Processing_Service(void);
void Data_WET_Processing_Service(void);

uint8_t Common_Get_Air1_Valid(void);
uint8_t Common_Get_Air2_Valid(void);
uint8_t Common_Get_WET_Valid(void);

uint16_t Common_Get_Air1_Data(void);
uint16_t Common_Get_Air2_Data(void);
uint16_t Common_Get_WET_Data(void);

#endif