#include "Data_CoolantTemperature.h"
#include "CAN_Communication_Matrix.h"
#include "GaugesInterface.h"
#include "GPIO.h"
//-------------------------------------------
//水温数据处理
//-------------------------------------------
//断码显示
//-------------------------------------------
//344 - 3.1.1.  水温计显示
//-------------------------------------------
static struct
{
    uint8_t Value ;
    uint8_t Valid ;
    uint8_t CurSeg ;
} CoolantVariable ;

static uint8_t CalCoolant_CurSeg(uint8_t Valid, uint8_t Temp);
/*-------------------------------------------------------------------------
 * Function Name  : Coolant_KL30_Init
 * Description    : 水温KL30初始化
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Coolant_KL30_Init(void)
{
    CoolantVariable.Valid = 0 ;
    CoolantVariable.Value = 0 ;
    CoolantVariable.CurSeg = 0 ;

}
void Coolant_KL15_ON_Init(void)
{
    CoolantVariable.Valid = 0 ;
    CoolantVariable.Value = 0 ;
    CoolantVariable.CurSeg = 0 ;
}
void Coolant_KL15_OFF_Init(void)
{
    CoolantVariable.Valid = 0 ;
    CoolantVariable.Value = 0 ;
    CoolantVariable.CurSeg = 0 ;
}
void Coolant_Wakeup_Init(void)
{
    CoolantVariable.Valid = 0 ;
    CoolantVariable.Value = 0 ;
    CoolantVariable.CurSeg = 0 ;
}
void Coolant_Sleep_Init(void)
{
    CoolantVariable.Valid = 0 ;
    CoolantVariable.Value = 0 ;
    CoolantVariable.CurSeg = 0 ;
}
/*-------------------------------------------------------------------------
 * Function Name  : Coolant_Processing_Service
 * Description    : 水温
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void Coolant_Processing_Service(void)
{
    static uint8_t Timer2s = 0 ;
    uint8_t TargetSeg = 0 ;
    uint8_t Msg_CoolTemp = 0u ;
    uint8_t CanStatus = 0u;

    CanStatus = CAN_MSG_Status(ID_CanMsg18FEEE00_Msg_Count);

    if (CanStatus == CAN_SIG_LOST)
    {
        CoolantVariable.Valid = 0 ;
        CoolantVariable.Value = 0u;
        Timer2s = 0 ;
    }
    else
    {
        Msg_CoolTemp = Get_ID_18FEEE00_Sig_Engine_Coolant_Temperature();

        if (Msg_CoolTemp > 0xFAu)
        {
            CoolantVariable.Valid = 0u ;
            TargetSeg = 0u;
        }
        else
        {
            Timer2s = 0 ;
            CoolantVariable.Valid = 1u;

            if (Msg_CoolTemp >= 40)
            {
                CoolantVariable.Value = Msg_CoolTemp - 40u;
            }
            else
            {
                CoolantVariable.Value  = 0u;
            }
        }
    }

    CoolantVariable.CurSeg = CalCoolant_CurSeg(CoolantVariable.Valid, CoolantVariable.Value);
}
/*-------------------------------------------------------------------------
 * Function Name  : CalCoolant_CurSeg
 * Description    : 计算当前段
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
static uint8_t CalCoolant_CurSeg(uint8_t Valid, uint8_t Temp)
{
    uint8_t u8Result = 0u;

    if (Valid)
    {
        SetGaugesPara(TempGauges, Temp);
        u8Result = GetGaugesCurrentPos(TempGauges) ;
    }
    else
    {
        //范围外/CAN中断
        u8Result = 0 ;
    }

    return u8Result ;
}
/*-------------------------------------------------------------------------
 * Function Name  : Coolant_Get_ActualValue
 * Description    : 水温值.结果带偏移 - 40
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
uint8_t Coolant_Get_ActualValue(void)
{
    uint8_t u8Result = 0u;
    u8Result = CoolantVariable.Value ;
    return u8Result;
}
/*-------------------------------------------------------------------------
 * Function Name  : Coolant_Get_Valid
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
uint8_t Coolant_Get_Valid(void)
{
    uint8_t u8Result = 0u;
    u8Result = CoolantVariable.Valid ;
    return u8Result;
}
/*-------------------------------------------------------------------------
 * Function Name  : Coolant_Get_CurSeg
 * Description    : 水温当前段
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
uint8_t Coolant_Get_CurSeg(void)
{
    uint8_t u8Result = 0u;
    u8Result = CoolantVariable.CurSeg ;
    return u8Result;
}