#ifndef DATA_GEAR_H
#define DATA_GEAR_H

#include "TYW_stdint.h"

#define   DATA_GEAR_P                          0x0Bu
#define   DATA_GEAR_R                          0x09u
#define   DATA_GEAR_N                          0x0Au
#define   DATA_GEAR_D                          0x01u
#define   DATA_GEAR_N_FLASH                    0x0Cu
#define   DATA_GEAR_P_FLASH                    0x08u

#define   DATA_GEAR_1                       0x01u
#define   DATA_GEAR_2                       0x02u
#define   DATA_GEAR_3                       0x03u
#define   DATA_GEAR_4                       0x04u
#define   DATA_GEAR_5                       0x05u
#define   DATA_GEAR_6                       0x06u
#define   DATA_GEAR_7                       0x07u
#define   DATA_GEAR_8                       0x08u

#define   DATA_GEAR_UP                     0x01u
#define   DATA_GEAR_DOWN                   0x02u
#define   DATA_GEAR_UP_FLASH               0x03u
typedef enum
{
    GEAR_MANUAL_OFF =   0   ,
    GEAR_MANUAL_ON          ,
} en_GEAR_Sta ;

void Gear_KL30_Init(void);
void Gear_KL15_ON_Init(void);
void Gear_KL15_OFF_Init(void);
void Gear_Wakeup_Init(void);
void Gear_Sleep_Init(void);
void Gear_Processing_Service(void);


uint8_t Gui_Get_Gear(void);
en_GEAR_Sta Gui_Get_Gear_MANUAL(void);

typedef enum
{
    DIS_DATA_GEAR_P = 0,
    DIS_DATA_GEAR_R,
    DIS_DATA_GEAR_N,
    DIS_DATA_GEAR_D,
    DIS_DATA_GEAR_M,
    DIS_DATA_GEAR_L,
    DIS_DATA_GEAR_S,
    DIS_DATA_GEAR_E,
    DIS_DATA_GEAR_1,
    DIS_DATA_GEAR_2,
    DIS_DATA_GEAR_3,
    DIS_DATA_GEAR_4,
    DIS_DATA_GEAR_5,
    DIS_DATA_GEAR_6,
    DIS_DATA_GEAR_7,
    DIS_DATA_GEAR_8,
    DIS_DATA_GEAR_N_FLASH,
    DIS_DATA_GEAR_P_FLASH,
    DIS_DATA_GEAR_BLANK,
    DIS_DATA_GEAR_UP,
    DIS_DATA_GEAR_DOWN,
    DIS_DATA_GEAR_UPDOWN,
    DIS_DATA_GEAR_UP_FLASH,
    DIS_DATA_GEAR_DOWN_FLASH,
    DIS_DATA_GEAR_VALID_INVALID,

} DATA_GEAR_VALUE;

void Data_Gear_KL30_Init(void);
void Data_Gear_KL15_Init(void);
//void Data_Service_Gear_Processing(void);
//uint8_t Get_Gear_Mode_Type(void);
//uint8_t Get_Gear_Mode_Number(void);
//uint8_t Get_Gear_Mode_UPDOWN_Number(void);
//uint8_t Get_Gear_Mode_Up_Down(void);
//uint8_t Get_Gear_Mode_Display_Flash(void);
//uint8_t Get_Gear_Mode_M_A_Display(void);
//uint8_t Get_Gear_Mode_P_E_Display(void);
//uint8_t Get_Gear_Mode_L_C_Display(void);

#endif