#include "AvgSpeed.h"


/*** 平均车速 ***/
uint8_t                 DataAvgSpeed;
uint8_t                 DataAvgSpeedValid;
DataAvgSpeedStruct      DataAvgSpeedCalc;

uint16_t RTC_ROLLING_COUNTER = 0U;
uint16_t DATA_MILEAGE_ROLLING_COUNTER = 0U;
/****************************************************************************
 * 函数名：void Data_AvgSpeed_KL30_Init(void)
 * 功能：首次上蓄电池电初始化
 * 参数：无
 * **************************************************************************/
void Data_AvgSpeed_KL30_Init(void)
{
    DataAvgSpeed                      = 0U;
    DataAvgSpeedValid                 = 0U;
    DataAvgSpeedCalc.TimeRoCBackup    = 0U;
    DataAvgSpeedCalc.MileageRoCBackup = 0U;
    DataAvgSpeedCalc.MileageSample    = 0U;
    DataAvgSpeedCalc.TimeSample       = 0U;
    DataAvgSpeedCalc.Ptr              = 0U;
    DataAvgSpeedCalc.Cnt              = 0U;
    DataAvgSpeedCalc.UpdateTimer      = 0U;
    DataAvgSpeedCalc.Running          = 0U;
}

/******************************************************************************
函数名：Data_Avg_Speed_Processing
功  能: 平均车速数据处理 100ms
参  数: 无
返回值：无
******************************************************************************/
void Data_Avg_Speed_Processing(void)
{
    uint8_t  i;
    uint16_t TimeRollingCounter;
    uint16_t MileageRollingCounter;
    uint16_t Mileage;
    uint16_t Time;
    uint32_t MileageSum;
    uint32_t TimeSum;
    uint32_t AvgSpeed;
    uint8_t ActEspeedValid;
    uint8_t ActVspeedValid;
    uint16_t ActEspeed;
    uint16_t ActVspeed;



    RTC_ROLLING_COUNTER = Common_ReadRollingCounter();
    DATA_MILEAGE_ROLLING_COUNTER = Data_Mileage_Read();
    ActEspeedValid = Common_Get_Act_E_Speed_Valid();
    ActVspeedValid = Common_Get_Act_V_Speed_Valid();
    if (Common_Get_IG_Sts() == COMMON_POWER_ON)
    {
        if ((ActEspeedValid == COMMON_Valid) && (ActVspeedValid == COMMON_Valid))
        {
            ActEspeed = Common_Get_Act_E_Speed();
            ActVspeed = Common_Get_Act_V_Speed();
            if (DataAvgSpeedCalc.Running)
            {

                if ((ActEspeed < (uint16_t)DATA_ENGINE_STOP_THRESHOLD) || (ActVspeed < (uint16_t)DATA_VEHICLE_STOP_THRESHOLD))
                {
                    DataAvgSpeedCalc.Running = 0U;
                }
            }
            else
            {
                if ((ActEspeed > (uint16_t)DATA_ENGINE_RUNNING_THRESHOLD) && (ActVspeed > (uint16_t)DATA_VEHICLE_RUNNING_THRESHOLD))
                {
                    DataAvgSpeedCalc.Running = 1U;
                }
            }

            if (DataAvgSpeedCalc.Running)
            {
                TimeRollingCounter    = RTC_ROLLING_COUNTER;
                MileageRollingCounter = DATA_MILEAGE_ROLLING_COUNTER;

                Time    = TimeRollingCounter - DataAvgSpeedCalc.TimeRoCBackup;
                Mileage = MileageRollingCounter - DataAvgSpeedCalc.MileageRoCBackup;

                DataAvgSpeedCalc.TimeRoCBackup = TimeRollingCounter;
                DataAvgSpeedCalc.MileageRoCBackup = MileageRollingCounter;

                DataAvgSpeedCalc.TimeSample += Time;
                DataAvgSpeedCalc.MileageSample += Mileage;

                if (DataAvgSpeedCalc.MileageSample >= 1000U)
                {
                    DataAvgSpeedCalc.Time[DataAvgSpeedCalc.Ptr] = DataAvgSpeedCalc.TimeSample;
                    DataAvgSpeedCalc.Mileage[DataAvgSpeedCalc.Ptr] = DataAvgSpeedCalc.MileageSample;

                    DataAvgSpeedCalc.TimeSample    = 0U;
                    DataAvgSpeedCalc.MileageSample = 0U;

                    DataAvgSpeedCalc.Ptr++;
                    if (DataAvgSpeedCalc.Ptr >= (uint8_t)DATA_AVG_SPEED_TOTAL_KM)
                    {
                        DataAvgSpeedCalc.Ptr = 0U;
                    }
                    if (DataAvgSpeedCalc.Cnt < (uint8_t)DATA_AVG_SPEED_TOTAL_KM)
                    {
                        DataAvgSpeedCalc.Cnt++;
                    }
                    else
                    {
                        DataAvgSpeedCalc.Cnt = (uint8_t)DATA_AVG_SPEED_TOTAL_KM;
                    }
                }
            }
            else
            {
                DataAvgSpeedCalc.TimeRoCBackup    = RTC_ROLLING_COUNTER;
                DataAvgSpeedCalc.MileageRoCBackup = DATA_MILEAGE_ROLLING_COUNTER;
            }

            if (DataAvgSpeedValid)
            {
                DataAvgSpeedCalc.UpdateTimer++;
                if (DataAvgSpeedCalc.UpdateTimer >= 100U)
                {
                    DataAvgSpeedCalc.UpdateTimer = 0U;
                }
            }
            else
            {
                DataAvgSpeedCalc.UpdateTimer = 0U;
            }
            if (DataAvgSpeedCalc.UpdateTimer == 0U)
            {
                TimeSum    = (uint32_t)DataAvgSpeedCalc.TimeSample;
                MileageSum = (uint32_t)DataAvgSpeedCalc.MileageSample;

                for (i = 0U; i < DataAvgSpeedCalc.Cnt; i++)
                {
                    TimeSum    += (uint32_t)(DataAvgSpeedCalc.Time[i]);
                    MileageSum += (uint32_t)(DataAvgSpeedCalc.Mileage[i]);
                }

                if ((MileageSum >= 300U) && (TimeSum > 0U))
                {
                    AvgSpeed  = MileageSum;
                    AvgSpeed *= 371U;
                    AvgSpeed /= TimeSum;
                    AvgSpeed /= 10U;
                    AvgSpeed += 1U;

                    if (AvgSpeed > 240U)
                    {
                        AvgSpeed = 240U;
                    }
                    DataAvgSpeed = (uint8_t)AvgSpeed;
                    DataAvgSpeedValid = 1U;
                }
            }
        }
        else
        {
            DataAvgSpeedValid = 0U;                /*平均车速无效*/
            DataAvgSpeedCalc.TimeRoCBackup    = RTC_ROLLING_COUNTER;
            DataAvgSpeedCalc.MileageRoCBackup = DATA_MILEAGE_ROLLING_COUNTER;
        }
    }
    else
    {
        DataAvgSpeedCalc.TimeRoCBackup    = RTC_ROLLING_COUNTER;
        DataAvgSpeedCalc.MileageRoCBackup = DATA_MILEAGE_ROLLING_COUNTER;
    }
}

/******************************************************************************
函数名：Data_Avg_Speed_Reset
功  能: 平均车速清零
参  数: 无
返回值：无
******************************************************************************/
void Data_Avg_Speed_Reset(void)
{
    DataAvgSpeed                      = 0U;
    DataAvgSpeedValid                 = 0U;
    DataAvgSpeedCalc.TimeRoCBackup    = RTC_ROLLING_COUNTER;
    DataAvgSpeedCalc.MileageRoCBackup = DATA_MILEAGE_ROLLING_COUNTER;
    DataAvgSpeedCalc.MileageSample    = 0U;
    DataAvgSpeedCalc.TimeSample       = 0U;
    DataAvgSpeedCalc.Ptr              = 0U;
    DataAvgSpeedCalc.Cnt              = 0U;
    DataAvgSpeedCalc.UpdateTimer      = 0U;
}
