
#include "Telltales.h"
#include "Common_Interface.h"

#define TelltaleCallBackCycle 50u

typedef struct
{
    uint32_t IG_ON_Timer;
    uint32_t IG_OFF_Timer;
    PowerStatus_t IG_Status;
    Checktatus_t LED_CheckFinish;
    WorkPrease_t LED_CheckPrase;
    uint8_t u8LED_Status[LED_Max];
    LED_Judgment LED_Judgment_Cbk;
    LED_Execution LED_Execution_Cbk;
} LED_Operation_st;

LED_Operation_st LED_Operation;


void Telltales_Wakeup_Init(void)
{
    LED_Operation.IG_ON_Timer = 0U;
    LED_Operation.IG_OFF_Timer = 0U;
    LED_Operation.IG_Status = LED_PWR_OFF;
    LED_Operation.LED_CheckFinish = LED_CheckFinished;
    LED_Operation.LED_CheckPrase = LED_OFF_State;
    LED_Operation.LED_Judgment_Cbk = NULL;
    LED_Operation.LED_Execution_Cbk = NULL;
}

void Telltales_KL30_Init(void)
{
    LED_Operation.IG_ON_Timer = 0U;
    LED_Operation.IG_OFF_Timer = 0U;
    LED_Operation.IG_Status = LED_PWR_OFF;
    LED_Operation.LED_CheckFinish = LED_CheckFinished;
    LED_Operation.LED_CheckPrase = LED_OFF_State;
    LED_Operation.LED_Judgment_Cbk = NULL;
    LED_Operation.LED_Execution_Cbk = NULL;
}

void Telltales_KL15_Init(void)
{
    LED_Operation.LED_CheckFinish = LED_CheckNoFinish;
}


void Telltales_SetPara(ExternalPara_st *Para)
{
    LED_Operation.IG_Status = Para->IG_Status;
    LED_Operation.LED_CheckFinish = Para->LED_CheckFinish;
    LED_Operation.IG_ON_Timer = Para->IG_ON_Timer;
    LED_Operation.IG_OFF_Timer = Para->IG_OFF_Timer;
}


void Telltales_Management(void)
{
    LED_Operation.IG_Status = Common_Get_IG_Sts();
    LED_Operation.IG_ON_Timer = Common_GetIgnOnTime();
    LED_Operation.IG_OFF_Timer = Common_GetIgnOffTime();
    if (LED_Operation.IG_Status == LED_PWR_ON)/* IG ON */
    {
        if (LED_Operation.LED_CheckFinish == LED_CheckFinished)
        {
            LED_Operation.IG_ON_Timer = 0x7FFFFFFFUL;
        }
        LED_Operation.LED_CheckPrase = LED_ON_State;
    }
    else
    {
        LED_Operation.LED_CheckFinish = LED_CheckFinished;
        LED_Operation.IG_ON_Timer = 0u;
        LED_Operation.LED_CheckPrase = LED_OFF_State;  /* IG OFF */
    }

    switch (LED_Operation.LED_CheckPrase)
    {
    case LED_OFF_State:/* IG OFF */
        Telltales_IGOFF_Work();
        break;
    case LED_ON_State:/* IG ON Self Check Finish */
        Telltales_IG_ON_Work();
        break;
    default:
        LED_Operation.LED_CheckPrase = LED_OFF_State;
        break;
    }
}

void Telltales_IG_ON_Work(void)
{
    uint16_t i;
    for (i = 0u; i < LED_Max; i++)
    {
        if ((LED_Attribute[i].WorkSts == LED_IGN_ON) || (LED_Attribute[i].WorkSts == LED_IGN_ON_OFF))
        {
            if ((LED_Operation.IG_ON_Timer < LED_Attribute[i].CheckEnd))
            {
                if (LED_Operation.IG_ON_Timer >= LED_Attribute[i].CheckStart)
                {
                    if (LED_Attribute[i].isSelfCheck == SelfCheck)
                    {
                        if (LED_Attribute[i].isExCheck == NoExterNalCheck)/*According to the Attribute Table*/
                        {
                            LED_Operation.u8LED_Status[i] = LED_ON;
                            LED_Operation.LED_Execution_Cbk = LED_Attribute[i].LED_Execution_Cbk;
                            if (LED_Operation.LED_Execution_Cbk != NULL)
                            {
                                LED_Operation.LED_Execution_Cbk(LED_Operation.u8LED_Status[i]);
                            }
                        }
                        else/*According to the external Signal*/
                        {
                            LED_Operation.LED_Judgment_Cbk = LED_Attribute[i].LED_Judgment_Cbk;
                            if (LED_Operation.LED_Judgment_Cbk != NULL)
                            {
                                LED_Operation.u8LED_Status[i] = LED_Operation.LED_Judgment_Cbk();
                            }
                            else
                            {
                                /*can not reach*/
                                LED_Operation.u8LED_Status[i] = LED_OFF;
                            }

                            LED_Operation.LED_Execution_Cbk = LED_Attribute[i].LED_Execution_Cbk;
                            if (LED_Operation.LED_Execution_Cbk != NULL)
                            {
                                LED_Operation.LED_Execution_Cbk(LED_Operation.u8LED_Status[i]);
                            }
                        }

                    }
                    else
                    {
                        if (LED_Attribute[i].isExCheck == NoExterNalCheck)
                        {
                            LED_Operation.u8LED_Status[i] = LED_OFF;
                            LED_Operation.LED_Execution_Cbk = LED_Attribute[i].LED_Execution_Cbk;
                            if (LED_Operation.LED_Execution_Cbk != NULL)
                            {
                                LED_Operation.LED_Execution_Cbk(LED_Operation.u8LED_Status[i]);
                            }
                        }
                        else/*According to the external Signal*/
                        {
                            LED_Operation.LED_Judgment_Cbk = LED_Attribute[i].LED_Judgment_Cbk;
                            if (LED_Operation.LED_Judgment_Cbk != NULL)
                            {
                                LED_Operation.u8LED_Status[i] = LED_Operation.LED_Judgment_Cbk();
                            }
                            else
                            {
                                /*can not reach*/
                                LED_Operation.u8LED_Status[i] = LED_OFF;
                            }

                            LED_Operation.LED_Execution_Cbk = LED_Attribute[i].LED_Execution_Cbk;
                            if (LED_Operation.LED_Execution_Cbk != NULL)
                            {
                                LED_Operation.LED_Execution_Cbk(LED_Operation.u8LED_Status[i]);
                            }
                        }
                    }
                }
                else
                {
                    LED_Operation.u8LED_Status[i] = LED_OFF;
                    LED_Operation.LED_Execution_Cbk = LED_Attribute[i].LED_Execution_Cbk;
                    if (LED_Operation.LED_Execution_Cbk != NULL)
                    {
                        LED_Operation.LED_Execution_Cbk(LED_Operation.u8LED_Status[i]);
                    }
                }
            }
            else
            {
                LED_Operation.LED_Judgment_Cbk = LED_Attribute[i].LED_Judgment_Cbk;
                if (LED_Operation.LED_Judgment_Cbk != NULL)
                {
                    LED_Operation.u8LED_Status[i] = LED_Operation.LED_Judgment_Cbk();
                }
                else
                {
                    /*can not reach*/
                    LED_Operation.u8LED_Status[i] = LED_OFF;
                }

                LED_Operation.LED_Execution_Cbk = LED_Attribute[i].LED_Execution_Cbk;
                if (LED_Operation.LED_Execution_Cbk != NULL)
                {
                    LED_Operation.LED_Execution_Cbk(LED_Operation.u8LED_Status[i]);
                }
            }
        }
        else
        {
            LED_Operation.u8LED_Status[i] = LED_OFF;
            LED_Operation.LED_Execution_Cbk = LED_Attribute[i].LED_Execution_Cbk;
            if (LED_Operation.LED_Execution_Cbk != NULL)
            {
                LED_Operation.LED_Execution_Cbk(LED_Operation.u8LED_Status[i]);
            }
        }
    }
}

void Telltales_IGOFF_Work(void)
{
    uint16_t    i = 0u;
    for (i = 0u; i < LED_Max; i++)
    {
        if ((LED_Attribute[i].WorkSts == LED_IGN_OFF) || (LED_Attribute[i].WorkSts == LED_IGN_ON_OFF))
        {
            LED_Operation.LED_Judgment_Cbk = LED_Attribute[i].LED_Judgment_Cbk;
            if (LED_Operation.LED_Judgment_Cbk != NULL)
            {
                LED_Operation.u8LED_Status[i] = LED_Operation.LED_Judgment_Cbk();
            }
            else
            {
                /*can not reach*/
                LED_Operation.u8LED_Status[i] = LED_OFF;
            }

            LED_Operation.LED_Execution_Cbk = LED_Attribute[i].LED_Execution_Cbk;
            if (LED_Operation.LED_Execution_Cbk != NULL)
            {
                LED_Operation.LED_Execution_Cbk(LED_Operation.u8LED_Status[i]);
            }
        }
        else    /* ON ������ OFF��ҪϨ��  */
        {
            LED_Operation.u8LED_Status[i] = LED_OFF;
            LED_Operation.LED_Execution_Cbk = LED_Attribute[i].LED_Execution_Cbk;
            if (LED_Operation.LED_Execution_Cbk != NULL)
            {
                LED_Operation.LED_Execution_Cbk(LED_Operation.u8LED_Status[i]);
            }
        }
    }
}

