#include "CAN_Communication_Matrix.h"
#include "Common_Interface.h"
#include "TYW_stdint.h"
uint8_t  GetSignSts_Dr;
uint8_t  GetSignSts_Pss;
uint8_t  GetSignSts_RR;
uint8_t  GetSignSts_RL;
uint8_t  GetSignSts_Hood;
uint8_t  GetSignSts_Trunk;
uint16_t GetDisVspeed(void);
uint16_t GetDisVspeed(void)
{
    uint16_t v2 = 0u;
    if ( Common_Get_Disp_V_Speed_Valid( ) )
    {
        v2 = Common_Get_Disp_V_Speed( );
    }
    return v2;
}
uint8_t GetVoiceCFG(void);
uint8_t GetVoiceCFG(void)
{
    uint8_t VoiceSts = 0u;
    return VoiceSts;
}

typedef struct
{
    uint8_t  Sts_FL;     /*0 =close 1 =oppen */
    uint8_t  Sts_FR;     /*0 =close 1 =oppen */
    uint8_t  Sts_RL;     /*0 =close 1 =oppen */
    uint8_t  Sts_RR;     /*0 =close 1 =oppen */
    uint8_t  Sts_Trunk;  /*0 =close 1 =oppen */
    uint8_t  Sts_Hood;   /*0 =close 1 =oppen */
    uint8_t  ImageMode;  /*0 =Noon 1 =Small 2 =Big*/
    uint8_t  SndWarning; /*0 =None 1 =Voice 2 =Buzzer*/
    uint16_t Time;
    uint16_t Vspeed;
    uint8_t  LampSts; /*0 =Close 1 =Light 2 =Flash*/
    uint8_t  KL15Sts;

} DoorStructstructure;

DoorStructstructure Door;
void                Door_WakeUpInit(void);
void                Door_WakeUpInit(void)
{
    Door.Sts_FL    = 0u;
    Door.Sts_FR    = 0u;
    Door.Sts_RL    = 0u;
    Door.Sts_RR    = 0u;
    Door.Sts_Trunk = 0u;
    Door.Sts_Hood  = 0u;
    Door.ImageMode = 0u;
    Door.Time      = 0u;
    Door.Vspeed    = 0u;
    Door.LampSts   = 0u;
}
void DoorProcess(void);
void DoorProcess(void)
{
    Door.Sts_FL    = 0u; /*Get_Sig_BCM_DoorAjarSts_FR() ? 1u : 0u; */
    Door.Sts_FR    = 0u; /*Get_Sig_BCM_DoorAjarSts_FL() ? 1u : 0u; */
    Door.Sts_RL    = 0u; /*Get_Sig_BCM_DoorAjarSts_RL() ? 1u : 0u; */
    Door.Sts_RR    = 0u; /*Get_Sig_BCM_DoorAjarSts_RR() ? 1u : 0u; */
    Door.Sts_Trunk = 0u; /*Get_Sig_BCM_TrunkAjarSts() ? 1u : 0u; */
    Door.Sts_Hood  = 0u; /*Get_Sig_BCM_Reserved()?1u:0u;*/
    Door.Vspeed    = GetDisVspeed( );

    if ( (Door.Sts_FL) || (Door.Sts_FR) || (Door.Sts_RL) || (Door.Sts_RR) || (Door.Sts_Trunk)
         || (Door.Sts_Hood) )
    {
        if ( Door.Vspeed < 30u )
        {
            Door.LampSts    = 1u; /*always Light*/
            Door.SndWarning = 0u; /*sound warming*/
        }
        else
        {
            Door.LampSts = 2u; /*Flash*/
            if ( GetVoiceCFG( ) == 0u )
            {
                Door.SndWarning = 1u; /*Voice reminder*/
            }
            else
            {
                Door.SndWarning = 2u; /*Buzzer reminder*/
            }
        }

        if ( Door.Time < 5000u )
        {
            Door.Time++;
            Door.ImageMode = 2u; /*Big Image*/
        }
        else
        {
            Door.ImageMode = 1u; /*Small Image*/
        }
    }
    else
    {
        Door.LampSts    = 0u;
        Door.SndWarning = 0u;
        Door.ImageMode  = 0u;
        Door.Time       = 0u;
    }
}

/*return value: 0 close, 1 open */
uint8_t Get_Door_Sts_FL(void);
uint8_t Get_Door_Sts_FL(void)
{
    uint8_t Sts = 0u;
    Sts         = Door.Sts_FL;
    return Sts;
}
/*return value: 0 close, 1 open */
uint8_t Get_Door_Sts_FR(void);
uint8_t Get_Door_Sts_FR(void)
{
    uint8_t Sts = 0u;
    Sts         = Door.Sts_FR;
    return Sts;
}
/*return value: 0 close, 1 open */
uint8_t Get_Door_Sts_RL(void);
uint8_t Get_Door_Sts_RL(void)
{
    uint8_t Sts = 0u;
    Sts         = Door.Sts_RL;
    return Sts;
}
/*return value: 0 close, 1 open */
uint8_t Get_Door_Sts_RR(void);
uint8_t Get_Door_Sts_RR(void)
{
    uint8_t Sts = 0u;
    Sts         = Door.Sts_RR;
    return Sts;
}
/*return value: 0 close, 1 open */
uint8_t Get_Door_Sts_Trunk(void);
uint8_t Get_Door_Sts_Trunk(void)
{
    uint8_t Sts = 0u;
    Sts         = Door.Sts_Trunk;
    return Sts;
}
/*return value: 0 close, 1 open */
uint8_t Get_Door_Sts_Hood(void);
uint8_t Get_Door_Sts_Hood(void)
{
    uint8_t Sts = 0u;
    Sts         = Door.Sts_Hood;
    return Sts;
}
/*return value: 0 close, 1 Light, 2 Flash */
uint8_t Get_Door_LampSts(void);
uint8_t Get_Door_LampSts(void)
{
    uint8_t Sts = 0u;
    Sts         = Door.LampSts;
    return Sts;
}
/*return value: 0 close, 1 Voice, 2.Buzzer */
uint8_t Get_Door_SndWarning(void);
uint8_t Get_Door_SndWarning(void)
{
    uint8_t Sts = 0u;
    Sts         = Door.SndWarning;
    return Sts;
}
/*return value: 0 =Noon 1 =Small 2 =Big*/
uint8_t Get_Door_ImageMode(void);
uint8_t Get_Door_ImageMode(void)
{
    uint8_t Sts = 0u;
    Sts         = Door.ImageMode;
    return Sts;
}
