#include "UDS_27Service_Main.h"
#include "UDS_Common.h"
#include "libhello.h"
const uint8_t XorArray[4]= {0x31,0x23,0x56,0x71};
static void Ser27_CalculateKeyLV1(uint8_t Seed[],uint8_t Key[])  ;

void UDS_Service_27_Indication(uint32_t A_TA_type, uint16_t A_Length, uint8_t A_Data[])
{
    uint8_t NRC = positiveResponse;
    setDiagMSG(A_TA_type, A_Length, A_Data);
    if(NRC == positiveResponse)
    {
        NRC = UDS_27Service_NRC11();                                            /*27服务是否支持功能寻址*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_27Service_NRC7F();                                            /*27服务会话是否支持验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_27Service_Sub_NRC12();                                        /*27服务子功能是否支持验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_27Service_Sub_NRC7E();                                        /*27服务子功能会话是否支持验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_27Service_Sub_NRC13_TotalLengthCheck();                       /*27服务子功能总长度长度验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_27Service_NRC33();                                            /*27服务解锁等级验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_27Service_NRC22();                                            /*27服务条件验证*/
    }
    if(NRC == positiveResponse)
    {
        UDS_27Service_Sub();                                                    /*27服务子功能*/
    }
    clearDiagMSG();                                                             /*清除诊断信息*/
}

/**
  *10服务子功能
  */
void UDS_27Service_Sub(void)
{
    uint8_t NRC = positiveResponse;
    /*if(NRC == positiveResponse)
    {
        NRC = UDS_27Service_Sub_NRC13_MinLengthCheck();                         /*27服务子功能最小长度验证*/
    /*}
    if(NRC == positiveResponse)
    {
        NRC = UDS_27Service_Sub_NRC12();                                        /*27服务子功能是否支持验证*/
    /*}
    if(NRC == positiveResponse)
    {
        NRC = UDS_27Service_Sub_NRC7E();                                        /*27服务子功能会话是否支持验证*/
    /*}*/
    
    /*f(NRC == positiveResponse)
    {
        NRC = UDS_27Service_Sub_NRC13_TotalLengthCheck();                       /*27服务子功能总长度长度验证*/
    /*}*/
    if(NRC == positiveResponse)
    {
        NRC = UDS_27Service_Sub_NRC24();                                        /*27服务子功能请求顺序验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_27Service_Sub_NRC31();                                        /*27服务子功能超出请求范围验证*/
    }
    /*if(NRC == positiveResponse)
    {
        NRC = UDS_27Service_Sub_NRC22();                                        /*27服务子功能条件验证*/
    /*}*/
     if(NRC == positiveResponse)
    {
        NRC = UDS_27Service_Sub_NRC37();                                        /*27延时验证*/
    }

    if(NRC == positiveResponse)
    {
        switch(DiagMSG.msgData.SidDetail.SubID)                                 /*子服务判断*/
        {
        case requestSeed_LV1:
            UDS_27Service_Sub01();                                              /*27服务01子功能*/
            break;
        case requestSeed_LV3:
           UDS_27Service_Sub03();                                              /*27服务03子功能*/
            break;
        case sendKey_LV1:
            UDS_27Service_Sub02();                                              /*27服务02子功能*/
            break;
        case sendKey_LV3:
            UDS_27Service_Sub04();                                              /*27服务04子功能*/
            break;
        default:
            break;
        }
    }
}

 /**
  *27服务01子功能
  */
void UDS_27Service_Sub01(void)
{
    uint8_t randomseed[2];
    uint8_t iKeySize = 2;
    if(Ser27_FlowCtrl.LV1SafetyStatus != NormalKeyUnlock )
    {
        if(Ser27_FlowCtrl.LV1Ctrl != SER27_REQ_SEEDED)
        {
            Ser27_CreateRandomSeed();
            Ser27_FlowCtrl.LV1Seed[0] = ((uint8_t)(Ser27_SeedRandomNumber) ^ 0x31u)+16u ;
            Ser27_FlowCtrl.LV1Seed[1] = ((uint8_t)(Ser27_SeedRandomNumber>>8) ^ 0x56u)+9u ;
            Ser27_FlowCtrl.LV1Seed[0] = 0x49u;
            Ser27_FlowCtrl.LV1Seed[1] = 0xB4u;
        }
        else
        {
            /*Ser27_FlowCtrlCnt.LV1ReqSeedCnt +=1u;*/
        }
        /*
        将FailCnt存入D-Flash
        Ser27_WriteCtrlInfoToDFlash();*/
        Ser27_FlowCtrl.LV1Ctrl = SER27_REQ_SEEDED;
        /*if( Ser27_FlowCtrlCnt.LV1ReqSeedCnt >= SER27_MAX_REQ_SEED_NUM )
        {
            Ser27_EnDelayTimer();
            Ser27_FlowCtrl.LV1Ctrl = SER27_CLEAR_REQ_SEEDED;
        }*/
    }
    else
    {
        Ser27_FlowCtrl.LV1Seed[0] = 0u;
        Ser27_FlowCtrl.LV1Seed[1] = 0u;
    }
    DiagMSG.msgData.SidDetail.Data[0] = Ser27_FlowCtrl.LV1Seed[0]; 		  
    DiagMSG.msgData.SidDetail.Data[1] = Ser27_FlowCtrl.LV1Seed[1];		         
    randomseed[0] = Ser27_FlowCtrl.LV1Seed[0];
    randomseed[1] = Ser27_FlowCtrl.LV1Seed[1]; 

    if((randomseed[0] ==0x00u) && (randomseed[1] ==0x00u))
    {

    }
    else
    {
        GenerateKeyEx(randomseed,2,requestSeed_LV1,Ser27_FlowCtrl.LV1Key,(uint8_t*)&iKeySize);
    }
    if(DiagMSG.msgData.SidDetail.PositiveSuppression == 0u)
    {
        UDS_Service_Response(0x27u, POSITIVE_RSP, DIAG_ID_Tx, 3u, DiagMSG.msgData.Data);
    }
}

/**
  *27服务03子功能
  */
void UDS_27Service_Sub03(void)
{
    uint8_t randomseed[2];
    uint8_t iKeySize = 2;
    if(Ser27_FlowCtrl.LV3SafetyStatus != NormalKeyUnlock )
    {
        if(Ser27_FlowCtrl.LV3Ctrl != SER27_REQ_SEEDED)
        {
            Ser27_CreateRandomSeed();
            Ser27_FlowCtrl.LV3Seed[0] = ((uint8_t)(Ser27_SeedRandomNumber) ^ 0x31u)+16u ;
            Ser27_FlowCtrl.LV3Seed[1] = ((uint8_t)(Ser27_SeedRandomNumber>>8) ^ 0x56u)+9u ;
            Ser27_FlowCtrl.LV3Seed[0] = 0x49u;
            Ser27_FlowCtrl.LV3Seed[1] = 0xB4u;

        }
        else
        {
            //Ser27_FlowCtrlCnt.LV3ReqSeedCnt +=1u;
        }
        /*
        将FailCnt存入D-Flash
        Ser27_WriteCtrlInfoToDFlash();*/
        Ser27_FlowCtrl.LV3Ctrl = SER27_REQ_SEEDED;
        /*if( Ser27_FlowCtrlCnt.LV3ReqSeedCnt >= SER27_MAX_REQ_SEED_NUM )
        {
            Ser27_EnDelayTimer();
            Ser27_FlowCtrl.LV3Ctrl = SER27_CLEAR_REQ_SEEDED;
        }*/
    }
    else
    {
        Ser27_FlowCtrl.LV3Seed[0] = 0u;
        Ser27_FlowCtrl.LV3Seed[1] = 0u;
    }
    DiagMSG.msgData.SidDetail.Data[0] = Ser27_FlowCtrl.LV3Seed[0]; 		  
    DiagMSG.msgData.SidDetail.Data[1] = Ser27_FlowCtrl.LV3Seed[1];	      
    randomseed[0] = Ser27_FlowCtrl.LV3Seed[0];
    randomseed[1] = Ser27_FlowCtrl.LV3Seed[1]; 


    if((randomseed[0] ==0x00u) &&(randomseed[1] ==0x00u))
    {

    }
    else
    {
        GenerateKeyEx(randomseed,2,requestSeed_LV1,Ser27_FlowCtrl.LV3Key,(uint8_t*)&iKeySize);
    }
    if(DiagMSG.msgData.SidDetail.PositiveSuppression == 0u)
    {
        UDS_Service_Response(0x27u, POSITIVE_RSP, DIAG_ID_Tx, 3u, DiagMSG.msgData.Data);
    }
}

 /**
  *27服务02子功能
  */
void UDS_27Service_Sub02(void)
{
    uint16_t KeyReceive;
    uint16_t KeyCalcValue;

    KeyReceive =(uint16_t)DiagMSG.msgData.SidDetail.Data[0];
    KeyReceive =(KeyReceive<<8u) | ((uint16_t)DiagMSG.msgData.SidDetail.Data[1]);

    KeyCalcValue =(uint16_t)Ser27_FlowCtrl.LV1Key[0];
    KeyCalcValue =(KeyCalcValue<<8u) | ((uint16_t)Ser27_FlowCtrl.LV1Key[1]);
    if(KeyReceive == KeyCalcValue)
    {
        Ser27_FlowCtrl.LV1SafetyStatus = NormalKeyUnlock; 
        Ser27_FlowCtrl.LV1Ctrl = SER27_CLEAR_REQ_SEEDED;
        Ser27_FlowCtrlCnt.LV1InvaidKyeCnt = 0u;
        Ser27_FlowCtrlCnt.LV1ReqSeedCnt = 0u; 
        DiagMSG.msgData.Data[0]=sendKey_LV1;
        /*调用向flash写如函数*/
        Ser27_WriteCtrlInfoToDFlash();
           
        if(DiagMSG.msgData.SidDetail.PositiveSuppression == 0u)
        {
            UDS_Service_Response(0x27u, POSITIVE_RSP, DIAG_ID_Tx, 1u, DiagMSG.msgData.Data);
        }
    }
    else
    {
        Ser27_FlowCtrlCnt.LV1ReqSeedCnt +=1u;
        /*调用向flash写如函数*/
        Ser27_WriteCtrlInfoToDFlash();
        if(Ser27_FlowCtrlCnt.LV1ReqSeedCnt >= SER27_MAX_REQ_SEED_NUM  )
        {
            Ser27_EnDelayTimer(BothDelay);
            UDS_27Service_Sub_NRC36();  
        }
        else
        {
            UDS_27Service_Sub_NRC35();
        }
         Ser27_FlowCtrl.LV1Ctrl = SER27_CLEAR_REQ_SEEDED;  
    }
}

 /**
  *27服务04子功能
  */
void UDS_27Service_Sub04(void)
{
    uint16_t KeyReceive;
    uint16_t KeyCalcValue;

    KeyReceive =(uint16_t)DiagMSG.msgData.SidDetail.Data[0];
    KeyReceive =(KeyReceive<<8u) | ((uint16_t)DiagMSG.msgData.SidDetail.Data[1]);

    KeyCalcValue =(uint16_t)Ser27_FlowCtrl.LV3Key[0];
    KeyCalcValue =(KeyCalcValue<<8u) | ((uint16_t)Ser27_FlowCtrl.LV1Key[1]);

    if(KeyReceive == KeyCalcValue)
    {
        Ser27_FlowCtrl.LV3SafetyStatus = NormalKeyUnlock; 
        Ser27_FlowCtrl.LV3Ctrl = SER27_CLEAR_REQ_SEEDED;
        Ser27_FlowCtrlCnt.LV3InvaidKyeCnt = 0u;
        Ser27_FlowCtrlCnt.LV3ReqSeedCnt = 0u; 
        DiagMSG.msgData.Data[0]=sendKey_LV3;
        /*调用向flash写如函数*/
        Ser27_WriteCtrlInfoToDFlash();
           
        if(DiagMSG.msgData.SidDetail.PositiveSuppression == 0u)
        {
            UDS_Service_Response(0x27u, POSITIVE_RSP, DIAG_ID_Tx, 1u, DiagMSG.msgData.Data);
        }
    }
    else
    {
        Ser27_FlowCtrlCnt.LV3ReqSeedCnt +=1u;
        /*调用向flash写如函数*/
        Ser27_WriteCtrlInfoToDFlash();
        if(Ser27_FlowCtrlCnt.LV3ReqSeedCnt >= SER27_MAX_REQ_SEED_NUM  )
        {
            Ser27_EnDelayTimer(BothDelay);
            UDS_27Service_Sub_NRC36();  
        }
        else
        {
            UDS_27Service_Sub_NRC35();
        }
         Ser27_FlowCtrl.LV3Ctrl = SER27_CLEAR_REQ_SEEDED;  
    }
}



