/*****************************************************************************
* DISCLAIMER
* This software is supplied by Renesas Electronics Corporation and is only
* intended for use with Renesas products. No other uses are authorized. This
* software is owned by Renesas Electronics Corporation and is protected under
* all applicable laws, including copyright laws.
* THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES REGARDING
* THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING BUT NOT
* LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
* AND NON-INFRINGEMENT. ALL SUCH WARRANTIES ARE EXPRESSLY DISCLAIMED.
* TO THE MAXIMUM EXTENT PERMITTED NOT PROHIBITED BY LAW, NEITHER RENESAS
* ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES SHALL BE LIABLE
* FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES FOR
* ANY REASON RELATED TO THIS SOFTWARE, EVEN IF RENESAS OR ITS AFFILIATES HAVE
* BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
* Renesas reserves the right, without notice, to make changes to this software
* and to discontinue the availability of this software. By using this software,
* you agree to the additional terms and conditions found by accessing the
* following link:
* http://www.renesas.com/disclaimer
*
* Copyright (C) 2016 Renesas Electronics Corporation. All rights reserved.
*****************************************************************************/
/*******************************************************************************
* File Name : port.h
* Description : This file is for port define.
*************************************************************************z*****/

#ifndef _RSCAN_H_
#define _RSCAN_H_
#include "r_typedefs.h"
/******************************************************************************
Macro definitions
******************************************************************************/
#define RSCAN_BUS_OFF       0x10UL
#define RSCAN_ERR_PASSIVE   0x8UL

#define CAN_GRAMINIT_ON     (0x8UL)
#define CAN_GSLPSTS_ON      (0x4UL)
#define CAN_GRSTSTS_ON      (0x1UL)
#define CAN_CSLPSTS_ON      (0x4UL)
#define CAN_CHLTSTS_ON      (0x2UL)
#define CAN_CRSTSTS_ON      (0x1UL)
#define CAN_TMTRM_ON        (0x8U)
#define CAN_TMTR_ON         (0x1U)
#define CAN_AFLDAE_ON       (0x100UL)
#define CAN_GSLPR_MASK      (0x4UL)
#define CAN_GMDC_MASK       (0x3UL)
#define CAN_CSLPR_MASK      (0x4UL)
#define CAN_CHMDC_MASK      (0x3UL)
#define CAN_RFE_MASK        (0x1UL)
#define CAN_CFE_MASK        (0x1UL)
#define CAN_RFE_ON          (0x1UL)
#define CAN_CFE_ON          (0x1UL)

/******************************************************************************

                                Baud rate setting

The bit time can be divided into four segments according to the CAN
specifications, the synchronization segment (Sync_Seg), the propagation time
segment (Prop_Seg), the phase buffer segment 1 (Phase_Seg1), and the phase
buffer segment 2 (Phase_Seg2). The sample point, the point of time at which the
bus level is read and interpreted as the value of that respective bit, is
located at the end of Phase_Seg1.

  |<-----------------------------  A bit time  ---------------------------->|
  ---------------------------------------------------------------------------
  | Sync_Seg |    Prop_Seg    |      Phase_Seg1      |      Phase_Seg2      |
  ---------------------------------------------------------------------------
                                             |<-SJW->|              |<-SJW->|
  |<- 1 Tq ->|<--------------  T_SEG1  ------------->|<-----  T_SEG2  ----->|
                                                     ^
                                                     |
                                               Sampling point

Each segment consists of a programmable number of time quanta(Tq), which is a
multiple of the time quantum that is defined by source clock and a prescaler.

SS = 1 Tq fixed
Set TSEG1 to a range of 4 Tq to 16 Tq
Set TSEG2 to a range of 2 Tq to 8 Tq
Set SJW to a range of 1 Tq to 4 Tq
Set SS + TSEG1 + TSEG2 to a range of 8 Tq to 25 Tq
TSEG1 > TSEG2 >= SJW

The time quantum is configured as
                   Tq = 1 / (Source Clock Freq / PRESCALER)

-------------------------------------------------------------------------------
  Parameter  | Description
-------------+-----------------------------------------------------------------
 Sync_Seg    |The SS is a segment that performs synchronization by monitoring
             |the edge from recessive to dominant bits in the Interframe Space.
             |Interframe Space consists of Intermission, Suspend Transmission,
         |and Bus Idle. All nodes can start transmission during Bus Idle.
-------------+-----------------------------------------------------------------
             |Prop_Seg is the part of the bit time that is used to compensate
             |for the physical delay times within the network.
 Prop_Seg    |
     &       |Phase_Seg1 is used to compensate for edge phase errors before the
 Phase_Seg1  |sampling point. Can be lengthened by the resynchronization jump
             |width.
             |
             |T_SEG1 = Prop_Seg + Phase_Seg1
-------------+-----------------------------------------------------------------
             |Phase_Seg2 is used to compensate for edge phase errors after the
             |sampling point. Can be shortened by the resynchronization jump
 Phase_Seg2  |width.
             |
             |T_SEG2 = Phase_Seg2
-------------+-----------------------------------------------------------------
             |The SJW is a length to extend or reduce the time segment to
 SJW         |compensate for an error in phase due to phase error.
-------------------------------------------------------------------------------

Baud rate = 1 / [(Sync_Seg + Prop_Seg + Phase_Seg1 + Phase_Seg2)   Tq)]
          = Source Clock Freq / [PRESCALER * (1 + T_SEG1 + T_SEG2)]

******************************************************************************/
#define DIM(X) (sizeof(X) / sizeof((X)[0]))
typedef void (*CAN_Data_Ind_Func)(uint32_t Identifier, uint8_t DLC, uint8_t Data[]);
typedef void (*CAN_Data_Confirm_Func)(uint32_t Identifier, uint8_t TransferStatus);
typedef enum
{
    CAN_Set_Complete = 0,
    CAN_Set_ERROR_BUSOFF,
    CAN_Set_ERROR_OverMaxLen,
    CAN_Set_ERROR_MsgFull,
} CAN_SetState;

typedef enum
{
    CANFD_FILTER_N_A = 0,
    CANFD_FILTER_ID_LIST,
    CANFD_FILTER_ID_RANGE,
} CANFD_Filter_Cfg_Type_en_t;

typedef struct
{
    CANFD_Filter_Cfg_Type_en_t CfgType;
    uint16_t IDNum;
    uint32_t *pIDs;
} CANFD_Filter_Cfg_st_t;

typedef struct
{
    uint8_t CH0_Enable;
    uint8_t CH0_Std_Ext;

    uint8_t CH1_Enable;
    uint8_t CH1_Std_Ext;
    
    uint8_t CH2_Enable;
    uint8_t CH2_Std_Ext;

    CAN_Data_Ind_Func pfCAN0DataIndCb;
    CAN_Data_Ind_Func pfCAN1DataIndCb;
    CAN_Data_Ind_Func pfCAN2DataIndCb;

    CAN_Data_Confirm_Func pfCAN0DataConfirmCb;
    CAN_Data_Confirm_Func pfCAN1DataConfirmCb;
    CAN_Data_Confirm_Func pfCAN2DataConfirmCb;

} CANFD_Filter_Init_st_t;

//CAN_Data_Ind_Func pfCANDataIndCb;

typedef struct
{
    volatile uint32_t   ID        : 29;   /*!< Identifier */
        uint32_t   RSVD1     :  1;   /*!< Reserved bits */
        volatile uint32_t   RTR       :  1;   /*!< Remote/Data frame */
        volatile uint32_t   XTD       :  1;   /*!< Extended/Standard Identifier */
    } CANFD_Rx_Buffer_R0_st_t;

    typedef struct
{
    volatile uint32_t   RXTS      : 16;   /*!< Rx Timestamp */
        uint32_t   RSVD1     : 12;   /*!< Reserved bits */
        volatile uint32_t   CFDLC     :  4;   /*!< Data length */
    } CANFD_Rx_Buffer_R1_st_t;

    typedef struct stc_canfd_rx_buffer
{
    CANFD_Rx_Buffer_R0_st_t   R0_f;       /*!< Rx buffer element for R0. See #stc_canfd_r0_t. */
    CANFD_Rx_Buffer_R1_st_t   R1_f;       /*!< Rx buffer element for R1. See #stc_canfd_r1_t. */
    uint8_t                  Data[8];       /*!< Rx buffer element for Rn */
} CANFD_Rx_Buffer_st_t;


/*CAN�˲�����*/
typedef struct
{
    volatile uint32_t GAFLID      : 29;   /*!< Filter ID */
        volatile uint32_t GAFLLB      : 1;    /*!< Receive Rule Target Message Select */
        volatile uint32_t GAFLRTR     : 1;    /*!< RTR Select */
        volatile uint32_t GAFLIDE     : 1;    /*!< IDE Select */
    } CANFD_ID_F0_st_t;

    typedef struct
{
    volatile uint32_t GAFLIDM     : 29;   /*!< ID Mask */
        uint32_t RESERVED    :  1;   /*!< Reserved bits */
        volatile uint32_t GAFLRTRM    :  1;   /*!< RTR Mask */
        volatile uint32_t GAFLIDEM    :  1;   /*!< IDE Mask */
    } CANFD_ID_F1_st_t;

    typedef struct
{
    uint32_t Reserved    :  8;   /*!< Reserved bits */
    volatile uint32_t GAFLRMDP    :  7;   /*!< Receive Buffer Number Select */
        volatile uint32_t GAFLRMV     :  1;   /*!< Receive Buffer Enable */
        volatile uint32_t GAFLPTR     : 12;   /*!< Receive Rule Label */
        volatile uint32_t GAFLDLC     :  4;   /*!< Receive Rule DLC */
    } CANFD_ID_F2_st_t;

    typedef struct
{
    volatile uint32_t GAFLFDP1    :  8;   /*!< Receive FIFO Buffer x Select */
        volatile uint32_t GAFLFDP2    : 18;   /*!< Transmit/Receive FIFO Buffer k Select */
        volatile uint32_t Reserved    :  6;   /*!< Reserved bits */
    } CANFD_ID_F3_st_t;

typedef union
{
    uint32_t Msg;
    CANFD_ID_F0_st_t st;
} CANFD_ID_F0_st_tt;

typedef union
{
    uint32_t Msg;
    CANFD_ID_F1_st_t st;
} CANFD_ID_F1_st_tt;

typedef union
{
    uint32_t Msg;
    CANFD_ID_F2_st_t st;
} CANFD_ID_F2_st_tt;

typedef union
{
    uint32_t Msg;
    CANFD_ID_F3_st_t st;
} CANFD_ID_F3_st_tt;

typedef struct stc_extid_filter
{
    CANFD_ID_F0_st_tt F0_f; /*!< Message ID Filter Element for F0. See #stc_canfd_f0_t. */
    CANFD_ID_F1_st_tt F1_f; /*!< Message ID Filter Element for F1. See #stc_canfd_f1_t. */
    CANFD_ID_F2_st_tt F2_f; /*!< Message ID Filter Element for F2. See #stc_canfd_f2_t. */
    CANFD_ID_F3_st_tt F3_f; /*!< Message ID Filter Element for F3. See #stc_canfd_f3_t. */
} CANFD_ID_Filter_st_t;

#define   CANFD_CH0_MSG_RAM_ADDR    ((uint32_t)(&RSCAN0) + 0x00000500UL)

typedef struct
{
    uint16_t : 1;
    uint16_t ADERR  : 1;
    uint16_t B0ERR  : 1;
    uint16_t B1ERR  : 1;
    uint16_t CERR   : 1;
    uint16_t AERR   : 1;
    uint16_t FERR   : 1;
    uint16_t SERR   : 1;
    uint16_t ALF    : 1;
    uint16_t BLF    : 1;
    uint16_t OVLF   : 1;
    uint16_t BORF   : 1;
    uint16_t BOEF   : 1;
    uint16_t EPF    : 1;
    uint16_t EWF    : 1;
    uint16_t BEF    : 1;
} ErrorStatus;

#define Standard_ID  0
#define Extended_ID  1
#define Data_frame   0
#define Remote_frame 1

typedef struct
{
    uint32_t MsgID;
    uint8_t  MsgStd;
    uint8_t  MsgRTR;
    uint8_t  MsgDLC;
    uint8_t  Msg[8];
} CAN_Msg_t;

/******************************************************************************
Exported global variables and functions (to be accessed by other files)
******************************************************************************/
void CANFD_SetTX_Abort(void);
uint8_t RSCAN0_SendCH0_TxBuf0(uint32_t can_id, uint8_t dlc, uint8_t ide, uint8_t msg[8]);
uint8_t RSCAN0_SendCH0_TxBuf1(uint32_t can_id, uint8_t dlc, uint8_t ide, uint8_t msg[8]);
uint8_t RSCAN0_SendCH0_TxBuf2(uint32_t can_id, uint8_t dlc, uint8_t ide, uint8_t msg[8]);
uint8_t RSCAN0_SendCH0_TxBuf3(uint32_t can_id, uint8_t dlc, uint8_t ide, uint8_t msg[8]);
uint8_t RSCAN0_SendCH0_TxBuf4(uint32_t can_id, uint8_t dlc, uint8_t ide, uint8_t msg[8]);
uint8_t RSCAN0_SendCH0_TxBuf5(uint32_t can_id, uint8_t dlc, uint8_t ide, uint8_t msg[8]);
uint8_t RSCAN0_SendCH0_TxBuf6(uint32_t can_id, uint8_t dlc, uint8_t ide, uint8_t msg[8]);
uint8_t RSCAN0_SendCH0_TxBuf7(uint32_t can_id, uint8_t dlc, uint8_t ide, uint8_t msg[8]);
uint8_t RSCAN0_SendCH0_TxBuf8(uint32_t can_id, uint8_t dlc, uint8_t ide, uint8_t msg[8]);
uint8_t RSCAN0_SendCH0_TxBuf9(uint32_t can_id, uint8_t dlc, uint8_t ide, uint8_t msg[8]);
uint8_t RSCAN0_SendCH0_TxBuf10(uint32_t can_id, uint8_t dlc, uint8_t ide, uint8_t msg[8]);
uint8_t RSCAN0_SendCH0_TxBuf11(uint32_t can_id, uint8_t dlc, uint8_t ide, uint8_t msg[8]);
uint8_t RSCAN0_SendCH0_TxBuf12(uint32_t can_id, uint8_t dlc, uint8_t ide, uint8_t msg[8]);
uint8_t RSCAN0_SendCH0_TxBuf13(uint32_t can_id, uint8_t dlc, uint8_t ide, uint8_t msg[8]);
uint8_t RSCAN0_SendCH0_TxBuf14(uint32_t can_id, uint8_t dlc, uint8_t ide, uint8_t msg[8]);
uint8_t RSCAN0_SendCH0_TxBuf15(uint32_t can_id, uint8_t dlc, uint8_t ide, uint8_t msg[8]);

uint32_t Get_CAN0_Status(void);
uint8_t Get_CAN0_TxBuf1_Status(void);
void CAN0_Channel0_To_StopMode(void);
extern void RSCAN0_Init(void);
void RSCAN0_CH_Init(CANFD_Filter_Init_st_t *pFilterInit, uint32_t IDFilterNum);
extern void RSCan0_CH0_Write(CAN_Msg_t *Msg);
extern uint8_t Get_CH0_ErrPassiveStatus(void);
extern void RSCAN0_FIFO_Rx_ISR(void);
CAN_SetState CAN_CH0_Data_Request( uint32_t Identifier, uint8_t MsgStd, uint8_t MsgRTR, uint8_t DLC, uint8_t *Data );

extern void RSCAN0_CH0_Tx_ISR(void);
extern void RSCAN0_CH0_Rx_ISR(void);
extern void RSCAN0_CH0_Err_ISR(void);

extern void CH0_BusOff_Recovery(void);
extern uint8_t Get_CH0_BusOffStatus(void);

extern void RSCAN0_CH1_Tx_ISR(void);
extern void RSCAN0_CH1_Rx_ISR(void);
extern void RSCAN0_CH1_Err_ISR(void);

extern void RSCAN0_CH2_Tx_ISR(void);
extern void RSCAN0_CH2_Rx_ISR(void);
extern void RSCAN0_CH2_Err_ISR(void);

uint8_t Get_CH0_RecStatus(void);

uint8_t Rscan_TEC_Counter(void);
uint8_t Rscan_REC_Counter(void);
void CAN0_Global_To_StopMode(void);
void CAN0_Channel0_To_StopMode(void);
void CAN0_Channel0_To_CommunicationMode(void);
void CAN0_Global_To_NORMAL(void);

#endif
