#include "stdlib.h"
#include "string.h"
#include "r_typedefs.h"
#include "r_config_d1x.h"
#include "r_dev_api.h"
#include "r_ddb_api.h"
#include "r_cdi_api.h"
#include "r_wm_api.h"

#include "davehd_kernel_driver.h"
#include "davehd_kernel_bridge.h"
#include "davehd_os_libc.h"
#include "r_sys_davehd.h"


//#include "wm.h"

#include "dr7f701441.dvf.h"
//#include "r_bsp_stdio_api.h"

#include "GPIO.h"
#include "SDRAM.h"
#include "Graphic.h"

// #include "jcua.h"
#include "loc_graphics.h"
#include "loc_graphics_data.h"

/* video selection registers */
#define   GFX_REG_VDCECTL                   (0xFFC0601CUL)

/* RSDS and other video output control register */
#define   GFX_REG_RSDSCFG                   (0xFFC06020UL)

/* OpenLDI interface */
#define   GFX_REG_OLDI0CR0                  (0xF2002000UL)
#define   GFX_REG_OLDI0CR1                  (0xF2002004UL)
#define   GFX_REG_OLDI0CTRCR                (0xF200200CUL)
#define   GFX_REG_OLDI0CHCR                 (0xF2002010UL)
#define   GFX_REG_OLDI0SKEWCTR              (0xF2002070UL)








static const r_dev_PinConfig_t g_stGfxVoPinCfgRGB888[] = 
/*  Port Pin Func      Dir      Feedback     Pull        OpenDrain   HiCurr   HiSpeed  InputType */
{
    /* VDCE0 Output 24bit parallel, HSync+VSync+DE */
    {44, 0,  1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1}, /* VDCE0 Out Data 23 */
    {44, 1,  1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1},
    {44, 2,  1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1},
    {44, 3,  1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1},
    {44, 4,  1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1},
    {44, 5,  1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1},
    {44, 6,  1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1},
    {44, 7,  1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1},
    {44, 8,  1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1},
    {44, 9,  1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1},
    {44, 10, 1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1},
    {44, 11, 1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1}, /* VDCE0 Out Data 12 */
    {45, 0,  1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1}, /* VDCE0 Out CLKP */
    {45, 1,  4u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1}, /* VDCE0 Out Tcon3 DE */
    {45, 2,  1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1}, /* VDCE0 Out Data 11 */
    {45, 3,  1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1},
    {45, 4,  1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1},
    {45, 5,  1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1},
    {45, 6,  1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1},
    {45, 7,  1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1},
    {45, 8,  1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1},
    {45, 9,  1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1},
    {45, 10, 1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1},
    {45, 11, 1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1},
    {45, 12, 1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1},
    {45, 13, 1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1}, /* VDCE0 Out Data 0 */
    {43, 0,  1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1}, /* VDCE0 Out TCON2 HS */
/*   43, 0,  2u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1,  VDCE0 Out Tcon3 DE (shared on same pin as TCON2 HS) */
    {43, 1,  1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1}, /* VDCE0 Out TCON0 VS */
    
    /* delimiter - do not remove */
    {0u, R_DEV_PIN_LAST,0u,R_DEV_PIN_OUT,0u,R_DEV_PIN_PULLNO,   0u, 0u, 0u, R_DEV_PIN_CMOS1} 
};

static const r_dev_PinConfig_t g_stGfxVoPinCfgRGB666[] = 
/*  Port Pin Func      Dir      Feedback     Pull        OpenDrain   HiCurr   HiSpeed  InputType */
{
    /* VDCE0 Output 18bit parallel, HSync+VSync+DE */
    {44, 6,  1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1}, /* VDCE0 Out Data 17 */
    {44, 7,  1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1},
    {44, 8,  1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1},
    {44, 9,  1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1},
    {44, 10, 1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1},
    {44, 11, 1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1}, /* VDCE0 Out Data 12 */
    {45, 0,  1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1}, /* VDCE0 Out CLKP */
    {45, 1,  4u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1}, /* VDCE0 Out Tcon3 DE */
    {45, 2,  1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1}, /* VDCE0 Out Data 11 */
    {45, 3,  1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1},
    {45, 4,  1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1},
    {45, 5,  1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1},
    {45, 6,  1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1},
    {45, 7,  1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1},
    {45, 8,  1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1},
    {45, 9,  1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1},
    {45, 10, 1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1},
    {45, 11, 1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1},
    {45, 12, 1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1},
    {45, 13, 1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1}, /* VDCE0 Out Data 0 */
    {43, 0,  1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1}, /* VDCE0 Out TCON2 HS */
/*   43, 0,  2u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1,  VDCE0 Out Tcon3 DE (shared on same pin as TCON2 HS) */
    {43, 1,  1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1}, /* VDCE0 Out TCON0 VS */
    
    /* delimiter - do not remove */
    {0u, R_DEV_PIN_LAST,0u,R_DEV_PIN_OUT,0u,R_DEV_PIN_PULLNO,   0u, 0u, 0u, R_DEV_PIN_CMOS1} 
};

static const r_dev_PinConfig_t g_stGfxVoPinCfgOpenLDI[] = 
/*  Port Pin Func      Dir      Feedback     Pull        OpenDrain   HiCurr   HiSpeed  InputType */
{
    /* VDCE0 Output 24bit OpenLDI */
    {45, 0,  1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1}, /* VDCE0 OpenLDI ch0_p (clk_p) */
    {45, 1,  1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1}, /* VDCE0 OpenLDI ch0_n (clk_n) */
    {45, 2,  1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1}, /* VDCE0 OpenLDI ch1_p */
    {45, 3,  1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1}, /* VDCE0 OpenLDI ch1_n */
    {45, 4,  1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1}, /* VDCE0 OpenLDI ch2_p */
    {45, 5,  1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1}, /* VDCE0 OpenLDI ch2_n */
    {45, 6,  1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1}, /* VDCE0 OpenLDI ch3_p */
    {45, 7,  1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1}, /* VDCE0 OpenLDI ch3_n */
    {45, 8,  1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1}, /* VDCE0 OpenLDI ch4_p */
    {45, 9,  1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 1u, R_DEV_PIN_CMOS1}, /* VDCE0 OpenLDI ch4_n */

    /* delimiter - do not remove */
    {0u, R_DEV_PIN_LAST,0u,R_DEV_PIN_OUT,0u,R_DEV_PIN_PULLNO,   0u, 0u, 0u, R_DEV_PIN_CMOS1} 
};

static const r_dev_PinConfig_t g_stGfxViPinCfgITU656[] = 
/*  Port Pin Func      Dir      Feedback     Pull        OpenDrain   HiCurr   HiSpeed  InputType */
{
    /* VDCE0 Input ITU on P42_[10:0] AF2_In; BT656 from CVBS source via SAA71xx video converter */
    {42, 0,  2u, R_DEV_PIN_IN,  0u, R_DEV_PIN_PULLNO, 0u, 0u, 0u, R_DEV_PIN_CMOS1}, /* VDCE1 In ITU DATA7 */
    {42, 1,  2u, R_DEV_PIN_IN,  0u, R_DEV_PIN_PULLNO, 0u, 0u, 0u, R_DEV_PIN_CMOS1},
    {42, 2,  2u, R_DEV_PIN_IN,  0u, R_DEV_PIN_PULLNO, 0u, 0u, 0u, R_DEV_PIN_CMOS1},
    {42, 3,  2u, R_DEV_PIN_IN,  0u, R_DEV_PIN_PULLNO, 0u, 0u, 0u, R_DEV_PIN_CMOS1},
    {42, 4,  2u, R_DEV_PIN_IN,  0u, R_DEV_PIN_PULLNO, 0u, 0u, 0u, R_DEV_PIN_CMOS1},
    {42, 5,  2u, R_DEV_PIN_IN,  0u, R_DEV_PIN_PULLNO, 0u, 0u, 0u, R_DEV_PIN_CMOS1},
    {42, 6,  2u, R_DEV_PIN_IN,  0u, R_DEV_PIN_PULLNO, 0u, 0u, 0u, R_DEV_PIN_CMOS1},
    {42, 7,  2u, R_DEV_PIN_IN,  0u, R_DEV_PIN_PULLNO, 0u, 0u, 0u, R_DEV_PIN_CMOS1}, /* VDCE1 In ITU DATA0 */
    {42, 8,  2u, R_DEV_PIN_IN,  0u, R_DEV_PIN_PULLNO, 0u, 0u, 0u, R_DEV_PIN_CMOS1}, /* VDCE1 In ITU CLK */
    {42, 9,  2u, R_DEV_PIN_IN,  0u, R_DEV_PIN_PULLNO, 0u, 0u, 0u, R_DEV_PIN_CMOS1}, /* VDCE1 In ITU HSYNC */
    {42, 10, 2u, R_DEV_PIN_IN,  0u, R_DEV_PIN_PULLNO, 0u, 0u, 0u, R_DEV_PIN_CMOS1}, /* VDCE1 In ITU VSYNC */
    
    /* delimiter - do not remove */
    {0u, R_DEV_PIN_LAST,0u,R_DEV_PIN_OUT,0u,R_DEV_PIN_PULLNO,   0u, 0u, 0u, R_DEV_PIN_CMOS1} 
};




static const r_dev_PinConfig_t* g_pstGfxVoPinCfg[] = 
{
    /* GFX_VO_NONE           */ NULL,
    /* GFX_VO_SINGLE_RGB888  */ g_stGfxVoPinCfgRGB888,
    /* GFX_VO_SINGLE_RGB666  */ g_stGfxVoPinCfgRGB666,
    /* GFX_VO_SINGLE_OPENLDI */ g_stGfxVoPinCfgOpenLDI,
};
#define   GFX_VO_PIN_CFG_NUM                (sizeof(g_pstGfxVoPinCfg) / sizeof(r_dev_PinConfig_t*))

static const r_dev_PinConfig_t* g_pstGfxViPinCfg[] = 
{
    /* GFX_VI_NONE           */ NULL,
    /* GFX_VI_ITU656         */ g_stGfxViPinCfgITU656,
};
#define   GFX_VI_PIN_CFG_NUM                (sizeof(g_pstGfxViPinCfg) / sizeof(r_dev_PinConfig_t*))






/*r_cdi_Heap_t       g_stGfxVRAMheap;
r_cdi_Heap_t       g_stGfxlRAMheap;

#pragma alignvar(8) 
uint8_t            g_u8GfxlRAMheapMem[GFX_CPU_HP_BLOCK_NB * GFX_CPU_HP_BLOCK_SIZE];

r_cdi_HpBlkIndex_t g_u16GfxlRAMheapIdxList[GFX_CPU_HP_BLOCK_NB];


uint32_t g_u32GfxVRAM0Addr;
uint32_t g_u32GfxVRAM0Size;

uint32_t g_u32VOWEImageBufferAddr;
uint32_t g_u32VOWEDisplayListAddr;
uint32_t g_u32GPUMemoryAddr;

static r_wm_Msg_t g_stGfxWMMsgQueue[GFX_WM_MSG_QUEUE_LEN];*/


uint32_t g_u32GfxVRAM0Addr;
uint32_t g_u32GfxVRAM0Size;

uint32_t g_u32VOWEImageBufferAddr;
uint32_t g_u32VOWEDisplayListAddr;
uint32_t g_u32GPUMemoryAddr;

static r_wm_Msg_t g_stGfxWMMsgQueue[GFX_WM_MSG_QUEUE_LEN];

r_cdi_Heap_t       g_stGfxIRAMheap;
r_cdi_Heap_t       g_stGfxVRAMheap;
r_cdi_Heap_t       g_stGfxSDRAMheap;

#pragma alignvar(128)
uint32_t g_u32GfxIRAMheapMem[GFX_HEAP_SIZE >> 2];

r_cdi_HpBlkIndex_t g_u16GfxVRAMheapIdxList[GFX_VID_HP_BLOCK_NB];


void Gfx_Init(uint8_t u8Mode)
{
    uint8_t  u8VoIndex;
    uint8_t  u8ViIndex;
    uint32_t u32RegVal;

    r_dev_ClkSelConfig_t stClkSelCfg;
    const r_dev_PinConfig_t*   pstGfxPinCfg;

    g_u32GfxVRAM0Addr = 0UL;
    g_u32GfxVRAM0Size = 0UL;

    g_u32VOWEImageBufferAddr = 0UL;
    g_u32VOWEDisplayListAddr = 0UL;
    g_u32GPUMemoryAddr = 0UL;

    u8VoIndex = u8Mode & 0x0FU;
    u8ViIndex = (u8Mode >> 4U) & 0x0FU;
    if ((u8VoIndex < GFX_VO_PIN_CFG_NUM) && (u8ViIndex < GFX_VI_PIN_CFG_NUM))
    {
        /* Disable the video output pixel clock */
        stClkSelCfg.Cks       = R_DEV_CKS_VDCE0CK;
        stClkSelCfg.SrcId     = R_DEV_CKS_SRC_DISABLED;
        stClkSelCfg.Div       = 0U;
        stClkSelCfg.StpReqMsk = 0U;
        R_DEV_ClkIdSet(&stClkSelCfg);

        stClkSelCfg.Cks       = R_DEV_CKS_VDCE1CK;
        R_DEV_ClkIdSet(&stClkSelCfg);

        u32RegVal = 0x00010000UL;

        /* Video output configuration */
        switch (u8Mode & 0x0FU)
        {
        case GFX_VO_SINGLE_RGB888 :
            R_DEV_WRITE_REG(32, GFX_REG_RSDSCFG, 0x00000000UL);       /* LVTTL output enabled */
            break;

        case GFX_VO_SINGLE_RGB666 :
            R_DEV_WRITE_REG(32, GFX_REG_RSDSCFG, 0x00000000UL);       /* LVTTL output enabled */
            break;

        case GFX_VO_SINGLE_OPENLDI :
            R_DEV_WRITE_REG(32, GFX_REG_RSDSCFG,      0x00000020UL);  /* Open LDI output enabled */
            R_DEV_WRITE_REG(32, GFX_REG_OLDI0CR1,     0x000003FFUL);  /* Set all channels to operating mode */
            R_DEV_WRITE_REG(32, GFX_REG_OLDI0CTRCR,   0x00000000UL);  /* Set CTRL0 to HSYNC, CTRL1 to VSYNC, CTRL2 to DE */
            R_DEV_WRITE_REG(32, GFX_REG_OLDI0CHCR,    0x00000000UL);  /* Set CH0 to output CH0, CH1 to CH1, CH2 to CH2, CH3 to CH3 */
            R_DEV_WRITE_REG(32, GFX_REG_OLDI0SKEWCTR, 0x00000000UL);  /* Set SKEW of all channels to 0ps */
            R_DEV_WRITE_REG(32, GFX_REG_OLDI0CR0,     0x00000403UL);  /* Activate outputs, Start Operation, Select Mode 4 */
            break;

        default :
            break;
        }

        /* Video input configuration */
        switch (u8Mode & 0xF0U)
        {
        case GFX_VI_ITU656 :
            break;

        default :
            break;
        }

        R_DEV_WRITE_REG(32, GFX_REG_VDCECTL, u32RegVal);

        /* Port pins configuration */
        pstGfxPinCfg = g_pstGfxVoPinCfg[u8VoIndex];
        if (pstGfxPinCfg != NULL)
        {
            R_DEV_PinInit(pstGfxPinCfg);
        }
    }
}

    

void Gfx_Sys_Start(void)
{
    uint32_t x;
    dhd_gpu_config_t stGpuConfig;
    dhd_gpu_call_data_t stGpuCall;
    dhd_uint32_t u32Ret;

    uint32_t u32Delay;

    /* Memory setup */
    #if GFX_USE_INTERNAL_VRAM
        g_u32GfxVRAM0Addr = D1M1A_VRAM0;
        g_u32GfxVRAM0Size = D1M1A_VRAM0_SIZE + D1M1A_VRAM1_SIZE;
    #else
        uint32_t u32SDRAMSize;    
    
        u32SDRAMSize = Mem_SDRAM_Size();
        if (u32SDRAMSize <= GFX_VRAM_SIZE_IN_SDRAM)
        {
            g_u32GfxVRAM0Addr = D1M1A_SDRAM_BASE;
            g_u32GfxVRAM0Size = u32SDRAMSize;
        }
        else
        {
            g_u32GfxVRAM0Addr = D1M1A_SDRAM_BASE;
            g_u32GfxVRAM0Size = GFX_VRAM_SIZE_IN_SDRAM;
        }
    #endif

  #if GFX_USE_VOWE
    /* 1st is VOWE display list. We reserve space for two display lists. */
    /* Size is set to multiple of 1024 byte because VOWE image buffer has the alignment restriction. */
    if ( g_u32GfxVRAM0Size > (GFX_VOWE_DL_BUF_SIZE * 2u) )
    {
        g_u32VOWEImageBufferAddr = (g_u32GfxVRAM0Addr + g_u32GfxVRAM0Size) - (GFX_VOWE_DL_BUF_SIZE * 2u);
        g_u32GfxVRAM0Size -= GFX_VOWE_DL_BUF_SIZE * 2u;
        //R_BSP_STDIO_Printf("VOWE DL:  0x%08X / size %d\n", g_u32VOWEImageBufferAddr, GFX_VOWE_DL_BUF_SIZE * 2u);
    }
    else
    {
        //R_BSP_STDIO_Printf("Not enough memory space for VOWE display list! "
        //     "Please consider changing to Ringbuffer mode, to reduce the ringbuffer size or to reduce display resolution.\n");
        while (1U)
        {
            
        }
    }

    /* 2nd is VOWE image buffer. 
       Start address must be multiple of 1024 byte in case of ring buffer mode.
       Size should be 2^n. */
    if ( g_u32GfxVRAM0Size > GFX_VOWE_WORK_BUFF_SIZE)
    {
        g_u32VOWEImageBufferAddr = (g_u32GfxVRAM0Addr + g_u32GfxVRAM0Size) - GFX_VOWE_WORK_BUFF_SIZE;
        g_u32GfxVRAM0Size -= GFX_VOWE_WORK_BUFF_SIZE;
        //R_BSP_STDIO_Printf("VOWE Buf: 0x%08X / size %d\n", g_u32VOWEImageBufferAddr, GFX_VOWE_WORK_BUFF_SIZE);
    }
    else
    {
        //R_BSP_STDIO_Printf("Not enough memory space for VOWE buffer! "
        //     "Please consider changing to Ringbuffer mode, to reduce the ringbuffer size or to reduce display resolution.\n");
        
        while (1U)
        {
            
        }
    }
  #endif /* LOC_VOWE_ENABLE */
    
    /* 3rd is GPU2D. GPU is happy with almost any alignment, so it comes last.*/
    if ( g_u32GfxVRAM0Size > GFX_DHD_MEMORY_SIZE)
    {
        g_u32GPUMemoryAddr = (g_u32GfxVRAM0Addr + g_u32GfxVRAM0Size) - GFX_DHD_MEMORY_SIZE;
        g_u32GfxVRAM0Size -= GFX_DHD_MEMORY_SIZE;
        //R_BSP_STDIO_Printf("GPU2D:    0x%08X / size %d\n", g_u32GPUMemoryAddr, GFX_DHD_MEMORY_SIZE);
    }
    else
    {
        //R_BSP_STDIO_Printf("Not enough space for GPU memory! "
        //     "Please consider changing VOWE to Ringbuffer mode, to reduce the ringbuffer size or to reduce display resolution.\n");
        while (1U)
        {
            
        }
    }
    
/*    x = R_CDI_InitHeapManager((uint32_t)g_u8GfxlRAMheapMem,
                              &g_stGfxlRAMheap,
                              g_u16GfxlRAMheapIdxList,
                              GFX_CPU_HP_BLOCK_NB,
                              GFX_CPU_HP_BLOCK_SIZE);
    if (x == 1)
    {
        while (1U)
        {
            
        }
    }

    x = R_CDI_InitHeapManager(g_u32GfxVRAM0Addr,
                              &g_stGfxVRAMheap,
                              0,                    
                              g_u32GfxVRAM0Size / GFX_VID_HP_BLOCK_SIZE,
                              GFX_VID_HP_BLOCK_SIZE);
    if (x == 1)
    {
        while (1U)
        {
            
        }
    }*/
    //R_BSP_STDIO_Printf("VRAM CDI: 0x%08X / size %d\n", g_u32GfxVRAM0Addr, g_u32GfxVRAM0Size);

    x = R_CDI_InitHeapManager((uint32_t)g_u32GfxIRAMheapMem,
                              &g_stGfxIRAMheap,
                              0,
                              GFX_CPU_HP_BLOCK_NB,
                              GFX_CPU_HP_BLOCK_SIZE);
    if (x == 1)
    {
        while (1U)
        {

        }
    }

    x = R_CDI_InitHeapManager((uint32_t)GFX_VID_FB_BASE,
                              &g_stGfxVRAMheap,
                              g_u16GfxVRAMheapIdxList, /* Example: Here we don't use the optional parameter HeapIdxList */
                              GFX_VID_HP_BLOCK_NB,
                              GFX_VID_HP_BLOCK_SIZE);
    if (x == 1)
    {
        while (1U)
        {

        }
    }

    x = R_CDI_InitHeapManager((uint32_t)GFX_SDRAM_FB_BASE,
                              &g_stGfxSDRAMheap,
                              0,                    /* Example: Here we don't use the optional parameter HeapIdxList */
                              GFX_SDRAM_HP_BLOCK_NB,
                              GFX_SDRAM_HP_BLOCK_SIZE);
    if (x == 1)
    {
        while (1U)
        {

        }
    }


    R_WM_DevInit(GFX_WM_UNIT, g_stGfxWMMsgQueue, GFX_WM_MSG_QUEUE_LEN, 0, &g_stGfxIRAMheap, &g_stGfxSDRAMheap);

    MCU_STBYB_LCD_OUT = 1U ;
    MCU_RSTB_LCD_OUT = 1U ;
    
    R_WM_ScreenTimingSetByName(GFX_WM_UNIT, (const int8_t*)GFX_DISPLAY_NAME);
    R_WM_ScreenColorFormatSet(GFX_WM_UNIT, (R_WM_OUTCOLORFMT_RGB888 | R_WM_OUTCOLORFMT_FLAG_SWAP_BR | R_WM_OUTCOLORFMT_FLAG_ENDIAN));
    R_WM_ScreenEnable(GFX_WM_UNIT);
    R_WM_ScreenBgColorSet(GFX_WM_UNIT, 0, 0, 0);
    R_WM_FrameEndMark(GFX_WM_UNIT, 0);
    R_WM_FrameWait(GFX_WM_UNIT, 0);

    R_SYS_DHD_IntCInit(GFX_DHD_UNIT);
    
    dhd_gpu_bridge_init_server();
    dhd_set_cpu_heap(&g_stGfxIRAMheap);
    
    memset(&stGpuConfig, 0, sizeof(stGpuConfig));
    
    stGpuConfig.m_sizeof                = sizeof(stGpuConfig);
    stGpuConfig.m_register_base_address = (void*)R_SYS_DHD_GetBaseAddr(0);
    stGpuConfig.m_vidmem_base_address   = GFX_DHD_BASE;
    stGpuConfig.m_vidmem_size           = GFX_DHD_MEMORY_SIZE;

    /* init device description */
    stGpuConfig.m_default_jobsize       = GFX_DHD_JOB_SIZE;
    stGpuConfig.m_default_jobcount      = GFX_DHD_JOB_COUNT;
    stGpuConfig.m_default_ringsize      = GFX_DHD_RING_SIZE;
    stGpuConfig.m_force_synchronous     = 1U;
    
    stGpuCall.m_init.m_instance         = dhd_gpu_prepare_instance(0);
    stGpuCall.m_init.m_config           = &stGpuConfig;
    u32Ret = dhd_gpu_call(0, E_DHD_CALL_INIT, &stGpuCall);
    
    while (u32Ret != E_DHD_OK)
    {
        
    }
    
    for (u32Delay = 0UL; u32Delay < 1000000UL; u32Delay++)
    {

    }

    D1530_EN_MCU_OUT = 1U ;  /* 1530EN = 1 */

    for (u32Delay = 0UL; u32Delay < 250000UL; u32Delay++)
    {

    }

    

    //stPinCfg.enGPIOPort = GPIO_PORT_GROUP_16;
    //stPinCfg.enGPIOPIN  = GPIO_PIN_8;
    //GPIO_Config(&stPinCfg);   /* BL PWM = 100% */



    loc_App((void *)SpriteHandler, (void *)&ScreenAttr);

}

#if 0    
void Gfx_Sys_Start(void)
{
    uint32_t x;
    dhd_gpu_config_t stGpuConfig;
    dhd_gpu_call_data_t stGpuCall;
    dhd_uint32_t u32Ret;

    uint32_t u32Delay;





    

//LCD_BIAS_EN = 1U;
//LCD_RSTB = 1U;
//LCD_STDBYB = 1U;
/*
    GPIO_Config_st_t stPinCfg;
    stPinCfg.enGPIOPort = GPIO_PORT_GROUP_42;
    stPinCfg.enGPIOPIN  = GPIO_PIN_11;
    stPinCfg.enGPIODrive = GPIO_Drive_Fast;
    stPinCfg.enGPIOCharacter = GPIO_Char_CMOS1;
    stPinCfg.enGPIOPull = GPIO_PULL_NONE;
    stPinCfg.enGPIOOutputValue = GPIO_Level_High;
    stPinCfg.enGPIOMode = GPIO_MODE_PORT;
    stPinCfg.enGPIODir = GPIO_DIR_OUT;
    stPinCfg.enGPIOAltFun = GPIO_ALTER_FUN_1;
    GPIO_Config(&stPinCfg);
    */

    

    /* Memory setup */
#if GFX_USE_INTERNAL_VRAM
    g_u32GfxVRAM0Addr = D1M1A_VRAM0;
    g_u32GfxVRAM0Size = D1M1A_VRAM0_SIZE + D1M1A_VRAM1_SIZE;
#else
    uint32_t u32SDRAMSize;

    u32SDRAMSize = Mem_SDRAM_Size();
    if (u32SDRAMSize <= GFX_VRAM_SIZE_IN_SDRAM)
    {
        g_u32GfxVRAM0Addr = D1M1A_SDRAM_BASE;
        g_u32GfxVRAM0Size = u32SDRAMSize;
    }
    else
    {
        g_u32GfxVRAM0Addr = D1M1A_SDRAM_BASE;
        g_u32GfxVRAM0Size = GFX_VRAM_SIZE_IN_SDRAM;
    }
#endif

#if GFX_USE_VOWE
    /* 1st is VOWE display list. We reserve space for two display lists. */
    /* Size is set to multiple of 1024 byte because VOWE image buffer has the alignment restriction. */
    if ( g_u32GfxVRAM0Size > (GFX_VOWE_DL_BUF_SIZE * 2u) )
    {
        g_u32VOWEImageBufferAddr = (g_u32GfxVRAM0Addr + g_u32GfxVRAM0Size) - (GFX_VOWE_DL_BUF_SIZE * 2u);
        g_u32GfxVRAM0Size -= GFX_VOWE_DL_BUF_SIZE * 2u;
        //R_BSP_STDIO_Printf("VOWE DL:  0x%08X / size %d\n", g_u32VOWEImageBufferAddr, GFX_VOWE_DL_BUF_SIZE * 2u);
    }
    else
    {
        //R_BSP_STDIO_Printf("Not enough memory space for VOWE display list! "
        //     "Please consider changing to Ringbuffer mode, to reduce the ringbuffer size or to reduce display resolution.\n");
        while (1U)
        {

        }
    }

    /* 2nd is VOWE image buffer.
       Start address must be multiple of 1024 byte in case of ring buffer mode.
       Size should be 2^n. */
    if ( g_u32GfxVRAM0Size > GFX_VOWE_WORK_BUFF_SIZE)
    {
        g_u32VOWEImageBufferAddr = (g_u32GfxVRAM0Addr + g_u32GfxVRAM0Size) - GFX_VOWE_WORK_BUFF_SIZE;
        g_u32GfxVRAM0Size -= GFX_VOWE_WORK_BUFF_SIZE;
        //R_BSP_STDIO_Printf("VOWE Buf: 0x%08X / size %d\n", g_u32VOWEImageBufferAddr, GFX_VOWE_WORK_BUFF_SIZE);
    }
    else
    {
        //R_BSP_STDIO_Printf("Not enough memory space for VOWE buffer! "
        //     "Please consider changing to Ringbuffer mode, to reduce the ringbuffer size or to reduce display resolution.\n");

        while (1U)
        {

        }
    }
#endif /* LOC_VOWE_ENABLE */

    /* 3rd is GPU2D. GPU is happy with almost any alignment, so it comes last.*/
    if ( g_u32GfxVRAM0Size > GFX_DHD_MEMORY_SIZE)
    {
        g_u32GPUMemoryAddr = (g_u32GfxVRAM0Addr + g_u32GfxVRAM0Size) - GFX_DHD_MEMORY_SIZE;
        g_u32GfxVRAM0Size -= GFX_DHD_MEMORY_SIZE;
        //R_BSP_STDIO_Printf("GPU2D:    0x%08X / size %d\n", g_u32GPUMemoryAddr, GFX_DHD_MEMORY_SIZE);
    }
    else
    {
        //R_BSP_STDIO_Printf("Not enough space for GPU memory! "
        //     "Please consider changing VOWE to Ringbuffer mode, to reduce the ringbuffer size or to reduce display resolution.\n");
        while (1U)
        {

        }
    }

    x = R_CDI_InitHeapManager((uint32_t)g_u32GfxIRAMheapMem,
                              &g_stGfxIRAMheap,
                              0,
                              GFX_CPU_HP_BLOCK_NB,
                              GFX_CPU_HP_BLOCK_SIZE);
    if (x == 1)
    {
        while (1U)
        {

        }
    }

    x = R_CDI_InitHeapManager((uint32_t)GFX_VID_FB_BASE,
                              &g_stGfxVRAMheap,
                              g_u16GfxVRAMheapIdxList, /* Example: Here we don't use the optional parameter HeapIdxList */
                              GFX_VID_HP_BLOCK_NB,
                              GFX_VID_HP_BLOCK_SIZE);
    if (x == 1)
    {
        while (1U)
        {

        }
    }

    x = R_CDI_InitHeapManager((uint32_t)GFX_SDRAM_FB_BASE,
                              &g_stGfxSDRAMheap,
                              0,                    /* Example: Here we don't use the optional parameter HeapIdxList */
                              GFX_SDRAM_HP_BLOCK_NB,
                              GFX_SDRAM_HP_BLOCK_SIZE);
    if (x == 1)
    {
        while (1U)
        {

        }
    }
    //R_BSP_STDIO_Printf("VRAM CDI: 0x%08X / size %d\n", g_u32GfxVRAM0Addr, g_u32GfxVRAM0Size);

    R_SYS_DHD_IntCInit(GFX_DHD_UNIT);

    dhd_gpu_bridge_init_server();
    dhd_set_cpu_heap(&g_stGfxIRAMheap);

    memset(&stGpuConfig, 0, sizeof(stGpuConfig));

    stGpuConfig.m_sizeof                = sizeof(stGpuConfig);
    stGpuConfig.m_register_base_address = (void*)R_SYS_DHD_GetBaseAddr(0);
    stGpuConfig.m_vidmem_base_address   = GFX_DHD_BASE;
    stGpuConfig.m_vidmem_size           = GFX_DHD_MEMORY_SIZE;

    /* init device description */
    stGpuConfig.m_default_jobsize       = GFX_DHD_JOB_SIZE;
    stGpuConfig.m_default_jobcount      = GFX_DHD_JOB_COUNT;
    stGpuConfig.m_default_ringsize      = GFX_DHD_RING_SIZE;
    stGpuConfig.m_force_synchronous     = 1U;

    stGpuCall.m_init.m_instance         = dhd_gpu_prepare_instance(0);
    stGpuCall.m_init.m_config           = &stGpuConfig;
    u32Ret = dhd_gpu_call(0, E_DHD_CALL_INIT, &stGpuCall);

    while (u32Ret != E_DHD_OK)
    {

    }

    for (u32Delay = 0UL; u32Delay < 250000UL; u32Delay++)
    {

    }

    

    R_WM_DevInit(GFX_WM_UNIT, g_stGfxWMMsgQueue, GFX_WM_MSG_QUEUE_LEN, 0, &g_stGfxIRAMheap, &g_stGfxVRAMheap);

    R_WM_ScreenTimingSetByName(GFX_WM_UNIT, (const int8_t*)GFX_DISPLAY_NAME);
    R_WM_ScreenColorFormatSet(GFX_WM_UNIT, (R_WM_OUTCOLORFMT_RGB888 | R_WM_OUTCOLORFMT_FLAG_SWAP_BR));
    R_WM_ScreenEnable(GFX_WM_UNIT);
    R_WM_ScreenBgColorSet(GFX_WM_UNIT, 0, 0, 0);
    R_WM_FrameEndMark(GFX_WM_UNIT, 0);
    R_WM_FrameWait(GFX_WM_UNIT, 0);

    loc_App((void *)SpriteHandler, (void *)&ScreenAttr);
}
#endif
void Gfx_Sys_Stop(void)
{

}

r_wm_WinBuffer_t MainScreenBuffer[2];

void Gfx_Create_Window(r_wm_WinMode_t      enMode,
                       uint32_t            u32PosX,
                       uint32_t            u32PosY,
                       uint32_t            u32PosZ,
                       uint32_t            u32Width,
                       uint32_t            u32Height,
                       uint32_t            u32Pitch,
                       uint32_t            u32Bnumber,
                       r_wm_WinColorFmt_t  enColorFmt,
                       r_wm_Window_t*      pstWindow)
{
    uint8_t i = 0;

    memset(pstWindow, 0, sizeof(r_wm_Window_t));

    pstWindow->Mode      = enMode;
    pstWindow->Status    = R_WM_WINSTATUS_NOT_INITIALIZED;
    pstWindow->ColorFmt  = enColorFmt;
    pstWindow->Alpha     = 0xff;
    pstWindow->PosX      = u32PosX;
    pstWindow->PosY      = u32PosY;
    pstWindow->PosZ      = u32PosZ;
    pstWindow->Width     = u32Width;
    pstWindow->Height    = u32Height;
    pstWindow->Pitch     = u32Pitch;

    if (enMode == R_WM_WINMODE_FB)
    {
        pstWindow->Surface.Fb.BufNum    = u32Bnumber;
        pstWindow->Surface.Fb.Buffer    = MainScreenBuffer;
        pstWindow->Surface.Fb.BufMode   = R_WM_WINBUF_ALLOC_EXTERNAL;
        for(i = 0; i < u32Bnumber; i++)
        {
            //MainScreenBuffer[i].Data = R_CDI_Alloc(&g_stGfxSDRAMheap, u32Height * u32Pitch * 4);
            MainScreenBuffer[i].Data = R_CDI_Alloc(&g_stGfxVRAMheap, u32Height * u32Pitch * 4);
            MainScreenBuffer[i].Status = R_WM_WINBUF_FREE;
        }
    }

    R_WM_WindowCreate(GFX_WM_UNIT, pstWindow);
    R_WM_WindowEnable(GFX_WM_UNIT, pstWindow);
}







