/**
  ********************************************************************************************************
  * @file    sflash.c
  * @author  LJX
  * @version V1.0.0
  * @date    2016.11.28
  * @brief   c source file
  ********************************************************************************************************
  * @attention
  *
  * Any copying, transferring or any other usage is prohibited.
  * 
  * All copyrights reserved by Jiangsu New-Vision Automotive Electronics Technology Co., Ltd.
  ********************************************************************************************************
*/ 
//********************************************************************************************************
// @Project Includes
//********************************************************************************************************

#include "r_typedefs.h"        /* Renesas basic types, e.g. uint32_t */
#include "sflash.h"
#include "r_dev_api.h"
#include "TYW_FLASH.h"

//********************************************************************************************************
// @Global variables
//********************************************************************************************************

//********************************************************************************************************
// @Local variables
//********************************************************************************************************
//********************************************************************************************************
// @Constants and macros
//********************************************************************************************************

//********************************************************************************************************
// @Local function prototypes
//********************************************************************************************************

//********************************************************************************************************
// @Define
//********************************************************************************************************

static const r_dev_PinConfig_t loc_D1Mx_SfmaDefaultPinConfig[] = 
/*  Port Pin Func      Dir      Feedback     Pull        OpenDrain   HiCurr   HiSpeed  InputType */
{
    /* SFMA - serial Flash memory pins */
    {21, 0,  1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 0u, R_DEV_PIN_CMOS1}, /* O:  SFMA0CLK */
    {21, 1,  1u, R_DEV_PIN_OUT, 0u, R_DEV_PIN_PULLNO, 0u, 0u, 0u, R_DEV_PIN_CMOS1}, /* O:  SFMA0SSL */
    {21, 2,  1u, R_DEV_PIN_DIRECT, 1u, R_DEV_PIN_PULLNO, 0u, 0u, 0u, R_DEV_PIN_CMOS1}, /* IO: SFMA0IO[0..]0 */
    {21, 3,  1u, R_DEV_PIN_DIRECT, 1u, R_DEV_PIN_PULLNO, 0u, 0u, 0u, R_DEV_PIN_CMOS1},
    {21, 4,  1u, R_DEV_PIN_DIRECT, 1u, R_DEV_PIN_PULLNO, 0u, 0u, 0u, R_DEV_PIN_CMOS1},
    {21, 5,  1u, R_DEV_PIN_DIRECT, 1u, R_DEV_PIN_PULLNO, 0u, 0u, 0u, R_DEV_PIN_CMOS1}, /* IO: SFMA0IO[..3]0 */
    {21, 6,  1u, R_DEV_PIN_DIRECT, 1u, R_DEV_PIN_PULLNO, 0u, 0u, 0u, R_DEV_PIN_CMOS1}, /* IO: SFMA0IO[0..]1 */
    {21, 7,  1u, R_DEV_PIN_DIRECT, 1u, R_DEV_PIN_PULLNO, 0u, 0u, 0u, R_DEV_PIN_CMOS1},
    {21, 8,  1u, R_DEV_PIN_DIRECT, 1u, R_DEV_PIN_PULLNO, 0u, 0u, 0u, R_DEV_PIN_CMOS1},
    {21, 9,  1u, R_DEV_PIN_DIRECT, 1u, R_DEV_PIN_PULLNO, 0u, 0u, 0u, R_DEV_PIN_CMOS1}, /* IO: SFMA0IO[..3]1 */
    /* delimiter - do not remove */
    {0u, R_DEV_PIN_LAST,0u,R_DEV_PIN_OUT,0u,R_DEV_PIN_PULLNO,   0u, 0u, 0u, R_DEV_PIN_CMOS1} 
};

//********************************************************************************************************
// @Global Functions
//********************************************************************************************************
/*********************************************************************************************************
** Function name :          InitSeriFlashExternReadMode
** Function Description :   InitSeriFlashExternReadMode
** Parameters:              None
** Return:                  None
** Note:                    None
*********************************************************************************************************/
void InitSeriFlashExternReadMode(void)
{
    volatile uint8_t io_state;

    io_state = R_DEV_PinOutStateGet();             /* Store original IO state (enabled or disabled) */
    R_DEV_PinInit(loc_D1Mx_SfmaDefaultPinConfig);
    R_DEV_PinOutStateSet(io_state);                 /* restore previous IO state */

    TYW_FLASH_Init();
}
/*********************************************************************************************************
  End Of File
*********************************************************************************************************/

