
#include "r_typedefs.h"
#include "r_xbus_api.h"
#include "cpu.h"

static const r_xbus_Cfg_t g_stCPUXBusCfg = 
{
    0,
    0,
    {{R_XBUS_AM_CACHE,0x1u,0x98000000u, 0x07F00000u}, /* Cached SDRAM (original addr: 0x58000000) mirror 128MB  */
    {R_XBUS_AM_CACHE, 0x1u,0xa0000000u, 0x1FF00000u},  /* Cached SFMA mirror (0xa000_0000 - 0xBFff_ffff)*/
    {R_XBUS_AM_DIRECT,0x1u,0x40000000u, 0x3FF00000u}, /* (disabled) buffered SDRAM + HYPB/OCTA (0x4000_0000 - 0x7FFF_FFFF) */
    {R_XBUS_AM_DIRECT,0x1u,0x3FCE8000u, 0x00300000u}}  /* (disabled) buffered VRAM */
};



void CPU_Init(void)
{
    /* Init XC cache */
    if (R_XBUS_ERR_OK == R_XBUS_Init(0)) 
    {
        R_XBUS_Config(0u, (r_xbus_Cfg_t *)&g_stCPUXBusCfg);
    }
}