
#include "r_typedefs.h"

#pragma ghs startnomisra
#include "v800_ghs.h"
#pragma ghs endnomisra

#include "r_dev_api.h"
#include "rh850_macros.h"



/* Software reset control register */
#define   SYS_REG_SWRESA                    (0xFFF80A04UL)
#define   SYS_REG_PROTCMD0                  (0xFFF80000UL)
#define   SYS_REG_PROTS0                    (0xFFF80004UL)

/* Module reset control register */
#define   SYS_REG_MRSTC                     (0xFFF8F400UL)
#define   SYS_REG_PROTSMRST                 (0xFFF8F484UL)
#define   SYS_REG_PROTCMDMRST               (0xFFF8F480UL)

/* Preload buffer control register */
#define   SYS_REG_PRL0REG                   (0xF200A000UL)
#define   SYS_REG_PRL1REG                   (0xF200A004UL)
#define   SYS_REG_PRL2REG                   (0xF200A008UL)
#define   SYS_REG_PRL3REG                   (0xF200A00CUL)

void nop(void)
{
    __NOP();
}

void enable_interrupt(void)
{
    __EI();
}

void disable_interrupt(void)
{
    __DI();
}

void software_reset(void)
{

}

void hardware_reset(void)
{
    R_DEV_WRITE_PROT_REG(SYS_REG_PROTCMD0, SYS_REG_SWRESA, 0x00000001UL);
    while ( 0UL != R_DEV_READ_REG(32, SYS_REG_PROTS0))  /* Read PROTSMRST */
    {
    }
}

void Sys_Peripheral_Reset(uint32_t u32Peri)
{
    u32Peri &= SYS_PERI_RESETTABLE;
    u32Peri |= R_DEV_READ_REG(32, SYS_REG_MRSTC);
    R_DEV_WRITE_PROT_REG(SYS_REG_PROTCMDMRST, SYS_REG_MRSTC, u32Peri);
    while ( 0UL != R_DEV_READ_REG(32, SYS_REG_PROTSMRST))  /* Read PROTSMRST */
    {
    }
}

void Sys_Enable_Preload_Buffer(void)
{
    R_DEV_WRITE_REG(32, SYS_REG_PRL0REG, 0x0002F101UL);
    R_DEV_WRITE_REG(32, SYS_REG_PRL1REG, 0x00022101UL);
    R_DEV_WRITE_REG(32, SYS_REG_PRL2REG, 0x0002F101UL);
    R_DEV_WRITE_REG(32, SYS_REG_PRL3REG, 0x0002F101UL);
}

