/****************************************************************************
 *  License : All rights reserved for TES Electronic Solutions GmbH
 *            See included /docs/license.txt for details
 *  Project : D/AVE HD
 *  Purpose : Loop guards, debug implementation
 ****************************************************************************
 * Version Control Information :
 *  $Revision: 11006 $
 *  $Date: 2016-11-07 17:32:44 +0100 (Mo, 07. Nov 2016) $
 *  $LastChangedBy: michael.golczewski $
 ****************************************************************************
 * Change History (autogenerated):
 ****************************************************************************/

/*
 * This file should only be included when debugging loop guards! This is
 * currently done in davehd_guards.h.
 * Instead of using the GUARD constants for runtime tests, the loop guards
 * will use variables that can be set in test cases before calling driver
 * functions.
 * The referenced variable's implementation in "user/src/davehd_debug.c" must
 * also be compiled and linked when including this file. The debug mode is
 * therefore only available for the user driver.
 */

#ifndef DAVEHD_GUARDS_DEBUG_H_INCLUDED
#define DAVEHD_GUARDS_DEBUG_INCLUDED

/******************************************************************************
 * Platform/application specific settings
 */

extern dhd_uint32_t _DHD_GUARD_VIDMEM_SIZE;
extern dhd_uint32_t _DHD_GUARD_ALLOCATOR_BLOCK_SIZE;
extern dhd_uint32_t _DHD_GUARD_RING_SIZE;
extern dhd_uint32_t _DHD_GUARD_RING_JOB_ENTRY_SIZE;


/******************************************************************************
 * Guard values for loop time outs
 */

extern dhd_uint32_t _DHD_GUARD_MAX_CLIENTS;
extern dhd_uint32_t _DHD_GUARD_MAX_JOBS;
extern dhd_uint32_t _DHD_GUARD_MAX_ACTIVE_JOBS;
extern dhd_uint32_t _DHD_GUARD_MAX_CMDLIST_JOBS;
extern dhd_uint32_t _DHD_GUARD_ALLOCATOR_MAX_BLOCKS;
extern dhd_uint32_t _DHD_GUARD_MAX_TRANSFER_SIZE;
extern dhd_uint32_t _DHD_GUARD_WAIT_FOR_REG_WRITE;
extern dhd_uint32_t _DHD_GUARD_WAIT_FOR_JOBS;
extern dhd_uint32_t _DHD_GUARD_WAIT_FOR_JOB;
extern dhd_uint32_t _DHD_GUARD_WAIT_FOR_GPU_HALT;


#endif /* DAVEHD_GUARDS_DEBUG_H_INCLUDED */
