/****************************************************************************
 *  License : All rights reserved for TES Electronic Solutions GmbH
 *            See included /docs/license.txt for details
 *  Project : D/AVE HD
 *  Purpose : Loop guards, specifics for Renesas (D1x) platform
 ****************************************************************************
 * Version Control Information :
 *  $Revision: 11006 $
 *  $Date: 2016-11-07 17:32:44 +0100 (Mo, 07. Nov 2016) $
 *  $LastChangedBy: michael.golczewski $
 ****************************************************************************
 * Change History (autogenerated):
 ****************************************************************************/

#ifndef DAVEHD_GUARDS_D1X_H_INCLUDED
#define DAVEHD_GUARDS_D1X_H_INCLUDED

#include "davehd_kernel_client.h"

/******************************************************************************
 * Platform/application specific settings
 */

/* Size of the video memory, managed by the allocator, in bytes */
#define DHD_GUARD_VIDMEM_SIZE               (100*1024*1024)

/* Minimum size of a memory block (i.e. minimum size of actual allocated memory chunk) */
#define DHD_GUARD_ALLOCATOR_BLOCK_SIZE      1

/* Ring size in bytes */
#define DHD_GUARD_RING_SIZE                 4192

/*** Bytes per job entry in ring *_/ */
#define DHD_GUARD_RING_JOB_ENTRY_SIZE       (7 + DHD_GPU_RESTORE_SIZE + DHD_GPU_STORE_SIZE)


/******************************************************************************
 * Guard values for loop time outs
 */

#define DHD_GUARD_MAX_CLIENTS               64    /* Maximum number of clients per device */
#define DHD_GUARD_MAX_JOBS                  256   /* Maximum number of jobs per client */

/* Maximum number of active jobs (jobs in device->m_active_jobs) */
#define DHD_GUARD_MAX_ACTIVE_JOBS           (DHD_GUARD_RING_SIZE/DHD_GUARD_RING_JOB_ENTRY_SIZE)

/* Maximum number of jobs in a cmdlist */
#define DHD_GUARD_MAX_CMDLIST_JOBS          1024

/* Maximum number of vidmem_blocks in the vidmem allocator */
#define DHD_GUARD_ALLOCATOR_MAX_BLOCKS      (DHD_GUARD_VIDMEM_SIZE/DHD_GUARD_ALLOCATOR_BLOCK_SIZE)

/* Maximum number of bytes transfered in an upload to or download from video memory */
#define DHD_GUARD_MAX_TRANSFER_SIZE         (1920*1080*4)

#define DHD_GUARD_WAIT_FOR_REG_WRITE        1024    /* Maximum cycles to wait until register file write is finished */
#define DHD_GUARD_WAIT_FOR_JOBS             2097152 /* Maximum cycles to wait until all jobs in the system are finished */
#define DHD_GUARD_WAIT_FOR_JOB              131072  /* Maximum cycles to wait until one job is finished */
#define DHD_GUARD_WAIT_FOR_GPU_HALT         1024    /* Maximum cycles to wait until GPU has fully stopped (STC non-busy) */


#endif /* DAVEHD_GUARDS_D1X_H_INCLUDED */
