/****************************************************************************
 *  License : All rights reserved for TES Electronic Solutions GmbH
 *            See included /docs/license.txt for details
 *  Project : D/AVE HD
 *  Purpose : Loop guards, default values
 ****************************************************************************
 * Version Control Information :
 *  $Revision: 11006 $
 *  $Date: 2016-11-07 17:32:44 +0100 (Mo, 07. Nov 2016) $
 *  $LastChangedBy: michael.golczewski $
 ****************************************************************************
 * Change History (autogenerated):
 ****************************************************************************/

#ifndef DAVEHD_GUARDS_DEFAULT_H_INCLUDED
#define DAVEHD_GUARDS_DEFAULT_H_INCLUDED

#include "davehd_kernel_client.h"

#define DHD_GUARD_MAX_VALUE (4294967295uL)

/******************************************************************************
 * Platform/application specific settings
 */

/* Size of the video memory, managed by the allocator, in bytes */
#define DHD_GUARD_VIDMEM_SIZE               DHD_GUARD_MAX_VALUE

/* Minimum size of a memory block (i.e. minimum size of actual allocated memory chunk) */
#define DHD_GUARD_ALLOCATOR_BLOCK_SIZE      DHD_GUARD_MAX_VALUE

/* Ring size in bytes */
#define DHD_GUARD_RING_SIZE                 DHD_GUARD_MAX_VALUE

/*** Bytes per job entry in ring *_/ */
#define DHD_GUARD_RING_JOB_ENTRY_SIZE       DHD_GUARD_MAX_VALUE


/******************************************************************************
 * Guard values for loop time outs
 */

#define DHD_GUARD_MAX_CLIENTS               (65535uL)
#define DHD_GUARD_MAX_JOBS                  (65535uL)

/* Maximum number of active jobs (jobs in device->m_active_jobs) */
#define DHD_GUARD_MAX_ACTIVE_JOBS           DHD_GUARD_MAX_VALUE

/* Maximum number of jobs in a cmdlist */
#define DHD_GUARD_MAX_CMDLIST_JOBS          DHD_GUARD_MAX_VALUE

/* Maximum number of vidmem_blocks in the vidmem allocator */
#define DHD_GUARD_ALLOCATOR_MAX_BLOCKS      DHD_GUARD_MAX_VALUE

/* Maximum number of bytes transfered in an upload to or download from video memory */
#define DHD_GUARD_MAX_TRANSFER_SIZE         DHD_GUARD_MAX_VALUE

#define DHD_GUARD_WAIT_FOR_REG_WRITE        DHD_GUARD_MAX_VALUE   /* Maximum cycles to wait until register file write is finished */
#define DHD_GUARD_WAIT_FOR_JOBS             DHD_GUARD_MAX_VALUE 	/* Maximum cycles to wait until all jobs in the system are finished */
#define DHD_GUARD_WAIT_FOR_JOB              DHD_GUARD_MAX_VALUE  	/* Maximum cycles to wait until one job is finished */
#define DHD_GUARD_WAIT_FOR_GPU_HALT         DHD_GUARD_MAX_VALUE   /* Maximum cycles to wait until GPU has fully stopped (STC non-busy) */


#endif /* DAVEHD_GUARDS_DEFAULT_H_INCLUDED */
