/****************************************************************************
 *  License : All rights reserved for TES Electronic Solutions GmbH
 *            See included /docs/license.txt for details
 *  Project : D/AVE HD
 *  Purpose : Utilites for edge equation setup.
 ****************************************************************************
 * Version Control Information :
 *  $Revision: 4771 $
 *  $Date: 2015-02-10 12:01:30 +0100 (Di, 10. Feb 2015) $
 *  $LastChangedBy: florian.zimmermann $
 ****************************************************************************
 * Change History (autogenerated):
 ****************************************************************************/    

#ifndef DAVEHD_UTIL_H_INCLUDED
#define DAVEHD_UTIL_H_INCLUDED

#include "davehd_types.h"

#ifdef __cplusplus
extern "C" {
#endif

/*----------------------------------------------------------------------------------------------------------*/
/* Flags for bezier features inside edgecontrol word. */
/**/
typedef enum tagdhd_util_blendmode {  
  E_DHD_UTIL_REPLACE,            /* Disable blending. Simply replace dst with src.*/
  E_DHD_UTIL_BLEND               /* Standard alphablending. Src * Alpha + Dst * (1-Alpha).*/
} dhd_util_blendmode_t;

/*----------------------------------------------------------------------------------------------------------*/
/* Flags for utility clipping functions. */
/**/
typedef enum tagdhd_util_clipmode {  
  E_DHD_CLIP_NONE = 0,           /* Do not apply clipping*/
  E_DHD_CLIP_FRAMEBUFFER = 1,    /* Clip to the active framebuffer bounding box (set by dhd_set_framebuffer_size)*/
  E_DHD_CLIP_UTILRECT = 2        /* Clip to the utility cliprect (set by dhd_set_util_cliprect) and the framebuffer*/
} dhd_util_clipmode_t;

/*----------------------------------------------------------------------------------------------------------*/
/* Vertex definition for utility setup functions.*/
/**/
typedef struct tagdhd_util_vertex {  
  dhd_fx28_4_t    m_x;                                        /* screenspace X position with 4 bit subpixel precision*/
  dhd_fx28_4_t    m_y;                                        /* screenspace X position with 4 bit subpixel precision*/
  dhd_float32_t   m_u;                                        /* texture U coordinate (optional)*/
  dhd_float32_t   m_v;                                        /* texture V coordinate (optional)*/
  dhd_float32_t   m_rhw;                                      /* reciprocal homogenous w (optional)*/
  dhd_float32_t   m_z;                                        /* normalized depth (optional)*/
} dhd_util_vertex_t;

/*----------------------------------------------------------------------------------------------------------*/
/**/
void dhd_util_blend(dhd_handle_t a_device, dhd_util_blendmode_t a_blendmode);
void dhd_util_color_replace(dhd_handle_t a_device, dhd_col_input_t a_source);
void dhd_util_color_add(dhd_handle_t a_device, dhd_col_input_t a_source1, dhd_col_input_t a_source2);
void dhd_util_color_multiply(dhd_handle_t a_device, dhd_col_input_t a_source1, dhd_col_input_t a_source2);
void dhd_util_color_muladd(dhd_handle_t a_device, dhd_col_input_t a_source1, dhd_col_input_t a_source2, dhd_col_input_t a_source3);
void dhd_util_color_lerp(dhd_handle_t a_device, dhd_col_input_t a_source1, dhd_col_input_t a_source2, dhd_col_input_t a_factor);

/*----------------------------------------------------------------------------------------------------------*/
/**/
DHD_API_INLINE void dhd_setup_edge_aa(dhd_edge_data_t *a_dst, dhd_fx28_4_t a_x1, dhd_fx28_4_t a_y1, dhd_fx28_4_t a_x2, dhd_fx28_4_t a_y2, dhd_fx28_4_t a_xo, dhd_fx28_4_t a_yo, dhd_float32_t a_blur);
DHD_API_INLINE void dhd_setup_edge_aa2(dhd_edge_data_t *a_dst, dhd_fx28_4_t a_x1, dhd_fx28_4_t a_y1, dhd_fx28_4_t a_x2, dhd_fx28_4_t a_y2, dhd_fx28_4_t a_xo, dhd_fx28_4_t a_yo, dhd_float32_t a_blur);
DHD_API_INLINE void dhd_setup_edge_noaa(dhd_edge_data_t *a_dst, dhd_fx28_4_t a_x1, dhd_fx28_4_t a_y1, dhd_fx28_4_t a_x2, dhd_fx28_4_t a_y2, dhd_fx28_4_t a_xo, dhd_fx28_4_t a_yo);
DHD_API_INLINE void dhd_setup_edge_noaa_notie(dhd_edge_data_t *a_dst, dhd_fx28_4_t a_x1, dhd_fx28_4_t a_y1, dhd_fx28_4_t a_x2, dhd_fx28_4_t a_y2, dhd_fx28_4_t a_xo, dhd_fx28_4_t a_yo);
DHD_API_INLINE void dhd_bound_tri(dhd_prim_data_t *a_dst, dhd_fx28_4_t x1, dhd_fx28_4_t y1, dhd_fx28_4_t x2, dhd_fx28_4_t y2, dhd_fx28_4_t x3, dhd_fx28_4_t y3);
DHD_API_INLINE void dhd_bound_quad(dhd_prim_data_t *a_dst, dhd_fx28_4_t x1, dhd_fx28_4_t y1, dhd_fx28_4_t x2, dhd_fx28_4_t y2, dhd_fx28_4_t x3, dhd_fx28_4_t y3, dhd_fx28_4_t x4, dhd_fx28_4_t y4);
DHD_API_INLINE void dhd_bound_aab(dhd_prim_data_t *a_dst, dhd_fx28_4_t x1,dhd_fx28_4_t y1, dhd_fx28_4_t x2, dhd_fx28_4_t y2);
DHD_API_INLINE dhd_bool_t dhd_clip_bbox(dhd_handle_t a_device, dhd_prim_data_t *a_prim, dhd_util_clipmode_t a_mode);

void dhd_set_util_cliprect(dhd_handle_t a_device, dhd_uint16_t a_xmin, dhd_uint16_t a_ymin, dhd_uint16_t a_xmax, dhd_uint16_t a_ymax);
dhd_bool_t dhd_setup_tri_attributes(dhd_handle_t a_device, const dhd_util_vertex_t *a_v0, const dhd_util_vertex_t *a_v1, const dhd_util_vertex_t *a_v2,
                                    dhd_prim_data_t *a_pout, dhd_edge_data_t *a_eout, dhd_uv_data_t *a_uvout, dhd_rhw_data_t *a_rhwout, dhd_depth_data_t *a_depthout, dhd_util_clipmode_t a_clipmode);
dhd_bool_t dhd_setup_tri_noaa(dhd_handle_t a_device, const dhd_util_vertex_t *a_v0, const dhd_util_vertex_t *a_v1, const dhd_util_vertex_t *a_v2,
                              dhd_prim_data_t *a_pout, dhd_edge_data_t *a_eout, dhd_enum_t a_edgeflags, dhd_util_clipmode_t a_clipmode);
dhd_bool_t dhd_setup_tri_aa(dhd_handle_t a_device, const dhd_util_vertex_t *a_v0, const dhd_util_vertex_t *a_v1, const dhd_util_vertex_t *a_v2,
                            dhd_prim_data_t *a_pout, dhd_edge_data_t *a_eout, dhd_enum_t a_edgeflags, dhd_util_clipmode_t a_clipmode);
dhd_bool_t dhd_setup_box_noaa(dhd_handle_t a_device, dhd_fx28_4_t a_xmin, dhd_fx28_4_t a_ymin, dhd_fx28_4_t a_xmax, dhd_fx28_4_t a_ymax,
                              dhd_prim_data_t *a_pout, dhd_edge_data_t *a_eout, dhd_util_clipmode_t a_clipmode);
dhd_bool_t dhd_setup_box_aa(dhd_handle_t a_device, dhd_fx28_4_t a_xmin, dhd_fx28_4_t a_ymin, dhd_fx28_4_t a_xmax, dhd_fx28_4_t a_ymax, 
                            dhd_prim_data_t *a_pout, dhd_edge_data_t *a_eout, dhd_util_clipmode_t a_clipmode);
dhd_bool_t dhd_setup_line_noaa(dhd_handle_t a_device, dhd_fx28_4_t a_x1, dhd_fx28_4_t a_y1, dhd_fx28_4_t a_x2, dhd_fx28_4_t a_y2,
                               dhd_prim_data_t *a_pout, dhd_edge_data_t *a_eout, dhd_util_clipmode_t a_clipmode);
dhd_bool_t dhd_setup_line_aa(dhd_handle_t a_device, dhd_fx28_4_t a_x1, dhd_fx28_4_t a_y1, dhd_fx28_4_t a_x2, dhd_fx28_4_t a_y2, dhd_uint32_t a_width,
                             dhd_prim_data_t *a_pout, dhd_edge_data_t *a_eout, dhd_util_clipmode_t a_clipmode);

/*----------------------------------------------------------------------------------------------------------*/
/**/
dhd_uint32_t dhd_get_texel_bpp(dhd_texel_org_t a_format);
dhd_uint32_t dhd_get_pixel_bpp(dhd_pixel_org_t a_format);
dhd_uint32_t dhd_get_depth_bpp(dhd_depth_org_t a_format);
dhd_uint32_t dhd_get_bpp(dhd_enum_t a_format);
dhd_uint32_t dhd_get_texel_byte_per_pixel(dhd_texel_org_t a_format);
dhd_uint32_t dhd_get_pixel_byte_per_pixel(dhd_pixel_org_t a_format);
dhd_uint32_t dhd_get_depth_byte_per_pixel(dhd_depth_org_t a_format);
dhd_uint32_t dhd_get_byte_per_pixel(dhd_enum_t a_format);
dhd_uint32_t dhd_get_texel_bits_per_pixel(dhd_texel_org_t a_format);
dhd_uint32_t dhd_get_pixel_bits_per_pixel(dhd_pixel_org_t a_format);
dhd_uint32_t dhd_get_depth_bits_per_pixel(dhd_depth_org_t a_format);
dhd_uint32_t dhd_get_bits_per_pixel(dhd_enum_t a_format);
dhd_uint32_t dhd_convert_argb2texel(dhd_texel_org_t a_format, dhd_uint32_t a_color);
dhd_uint32_t dhd_convert_argb2pixel(dhd_pixel_org_t a_format, dhd_uint32_t a_color);
dhd_enum_t dhd_convert_buffer(dhd_handle_t a_device, const dhd_buffer_t *a_input, dhd_buffer_t *a_output, dhd_address_mode_t a_mode);
dhd_enum_t dhd_swizzle_texture(dhd_handle_t a_device, dhd_gpu_ptr_t a_src_address, dhd_uint32_t a_src_width, dhd_uint32_t a_src_height, dhd_uint32_t a_src_pitch, dhd_texel_org_t a_src_format,
                               dhd_gpu_ptr_t a_dst_address, dhd_uint32_t a_dst_height, dhd_uint32_t a_dst_pitch, dhd_texel_org_t a_dst_format, dhd_address_mode_t a_dst_address_mode);
dhd_enum_t dhd_decompress_texture(dhd_handle_t a_device, const void *a_input, dhd_buffer_t *a_output);

/*----------------------------------------------------------------------------------------------------------*/
/**/
dhd_enum_t dhd_set_buffer_as_texture(dhd_handle_t a_device, dhd_buffer_t *a_buffer);
dhd_enum_t dhd_set_buffer_as_framebuffer(dhd_handle_t a_device, dhd_buffer_t *a_buffer);


/*----------------------------------------------------------------------------------------------------------*/
/**/
dhd_enum_t dhd_set_psu_stripes_optimized(dhd_handle_t a_device, dhd_uint32_t a_tex_bpp, dhd_uint32_t a_fb_bpp, dhd_address_mode_t a_address_mode, dhd_uint16_t a_bbox_x, dhd_float32_t a_tex_scale);

/*----------------------------------------------------------------------------------------------------------*/

#ifdef __cplusplus
}
#endif 

#endif /*DAVEHD_UTIL_H_INCLUDED*/
