#include "UDS_27Service_Internal.h"

uint32_t Ser27_SeedRandomNumber = 0x727u;

void Ser27_CreateRandomSeed(void)
{
    Ser27_SeedRandomNumber = Ser27_SeedRandomNumber * 1103515245ul+12345u;
}

void Ser27_ErrDelayTimerCtrlInit(void)
{
    /*调用读出函数*/
    Ser27_ReadCtrlInfoFromDFlash();
    Ser27_SeedRandomNumber = Ser27_FlowCtrlCnt.RandNum;
    if((Ser27_FlowCtrlCnt.LV1ReqSeedCnt >= SER27_MAX_REQ_SEED_NUM) || ( Ser27_FlowCtrlCnt.LV3ReqSeedCnt >= SER27_MAX_REQ_SEED_NUM ) )
    {
        Ser27_EnDelayTimer(BothDelay);
    }  
}

void Ser27_EnDelayTimer(Ser27_DelayLevel delayLevel)
{
    if(delayLevel == DelayLv1)
    {
        Ser27_FlowCtrl.LV1DelayCtrl = SER27_ERR_DELAY_TIMER_EN;
    }
    else if(delayLevel == DelayLv3){
        Ser27_FlowCtrl.LV3DelayCtrl = SER27_ERR_DELAY_TIMER_EN;
    }
    else{
        Ser27_FlowCtrl.LV1DelayCtrl = SER27_ERR_DELAY_TIMER_EN;
        Ser27_FlowCtrl.LV3DelayCtrl = SER27_ERR_DELAY_TIMER_EN;
    }
    
}

void Ser27_WriteCtrlInfoToDFlash(void)
{
    WriteDFlashData(EEPROM_BLOCK_UDS_S27, (uint32_t *)&Ser27_FlowCtrlCnt.Flag, sizeof(Ser27_FlowCtrlCnt) / 4u, NeedWait);
}

void Ser27_ReadCtrlInfoFromDFlash(void)
{
    ReadDFlashData(EEPROM_BLOCK_UDS_S27, (uint32_t *)&Ser27_FlowCtrlCnt.Flag, sizeof(Ser27_FlowCtrlCnt) / 4u, Ser27ToDFlashInfoInit);
}
