/******************************************************************************
  文件名：CD4051B.C
  功能：实现4051通道切换
  编写时间：2021/3/25
 ******************************************************************************/
#include "CD4051.h"
#include "GPIO.h"
#include "dr7f701441.dvf.h"

CD4051BChannel CD4051B_CurrentChannel;

CD4051CtrStruct CD4051CtrStr[COMTotal][MaxChannel];
uint16_t CD4051B_GeneralCOM_Cache[COMTotal][MaxChannel];
uint16_t CD4051B_GeneralCOM_Value[COMTotal][MaxChannel];

void CD4051B_KL15Init(void)
{
    uint8_t i, j;
    i = 0u;
    j = 0u;
    // VCCA_EN = 1u;
    for (i = 0u; i < COMTotal; i++)
    {
        for (j = 0u; j < MaxChannel; j++)
        {
            CD4051CtrStr[i][j].time = 0u;
            CD4051CtrStr[i][j].Last = 0u;
            CD4051B_GeneralCOM_Cache[i][j] = 0u;
            CD4051B_GeneralCOM_Value[i][j] = 0u;
        }
    }

    CD4051B_GeneralCOM_Value[COM1][Channel2] = 1u;
    CD4051B_GeneralCOM_Value[COM1][Channel3] = 1u;
    CD4051B_GeneralCOM_Value[COM1][Channel4] = 1u;
    CD4051B_GeneralCOM_Value[COM1][Channel6] = 1u;
    CD4051B_GeneralCOM_Value[COM1][Channel7] = 1u;
    CD4051B_GeneralCOM_Value[COM2][Channel0] = 1u;
    CD4051B_GeneralCOM_Value[COM2][Channel1] = 1u;
    CD4051B_GeneralCOM_Value[COM2][Channel2] = 1u;
    CD4051B_GeneralCOM_Value[COM2][Channel3] = 1u;
    CD4051B_GeneralCOM_Value[COM2][Channel7] = 1u;
    CD4051B_GeneralCOM_Value[COM3][Channel4] = 1u;
    CD4051B_GeneralCOM_Value[COM3][Channel5] = 1u;   /*A20*/
    CD4051B_GeneralCOM_Value[COM4][Channel2] = 1u;
    CD4051B_GeneralCOM_Value[COM4][Channel6] = 1u;
    CD4051B_GeneralCOM_Value[COM4][Channel7] = 1u;
    CD4051B_GeneralCOM_Value[COM5][Channel4] = 1u;
    CD4051B_GeneralCOM_Value[COM5][Channel6] = 1u;
    CD4051B_GeneralCOM_Value[COM6][Channel0] = 1u;
    CD4051B_GeneralCOM_Value[COM6][Channel3] = 1u;
    CD4051B_GeneralCOM_Value[COM6][Channel7] = 1u;
    CD4051B_GeneralCOM_Value[COM7][Channel0] = 1u;

    CD4051B_C_MCU = 0u;
    CD4051B_B_MCU = 0u;
    CD4051B_A_MCU = 0u;

    CD4051B_CurrentChannel = 0u;
}

/****************************************************************************
CD4051B_ChannelSet
CD4051B_C_MCU       CD4051B_B_MCU       CD4051B_A_MCU            Channel ON
      0                   0                   0                       0
      0                   0                   1                       1
      0                   1                   0                       2
      0                   1                   1                       3
      1                   0                   0                       4
      1                   0                   1                       5
      1                   1                   0                       6
      1                   1                   1                       7
******************************************************************************/
void CD4051B_ChannelSet(CD4051BChannel Ch)
{
    if (Ch < MaxChannel)
    {
        CD4051B_CurrentChannel = Ch;
        CD4051B_C_MCU = (Ch & 0x04u) >> 2u;
        CD4051B_B_MCU = (Ch & 0x02u) >> 1u;
        CD4051B_A_MCU = Ch & 0x01u;
    }
    else
    {
        ;
    }
}

/****************************************************************************
函数名：CD4051B_ChannelGet
形参：无
返回值：CD4051BChannel  当前通道数
功能：获取当前通道数
******************************************************************************/
CD4051BChannel CD4051B_ChannelGet(void)
{
    return CD4051B_CurrentChannel;
}

/****************************************************************************
CD4051B_ReadSignal_Serviece


******************************************************************************/
void CD4051B_ReadSignal_Serviece(void)
{
    uint8_t channel = 0u;

    channel = CD4051B_ChannelGet();

    CD4051B_GeneralCOM_Cache[COM1][channel] = CD4051B_InputGOIO_Com1;
    CD4051B_GeneralCOM_Cache[COM2][channel] = CD4051B_InputGOIO_Com2;
    CD4051B_GeneralCOM_Cache[COM3][channel] = CD4051B_InputGOIO_Com3;
    CD4051B_GeneralCOM_Cache[COM4][channel] = CD4051B_InputGOIO_Com4;
    CD4051B_GeneralCOM_Cache[COM5][channel] = CD4051B_InputGOIO_Com5;
    CD4051B_GeneralCOM_Cache[COM6][channel] = CD4051B_InputGOIO_Com6;
    CD4051B_GeneralCOM_Cache[COM7][channel] = CD4051B_InputGOIO_Com7;

    if (channel < (MaxChannel - 1u))
    {
        channel++;
    }
    else
    {
        channel = Channel0;
    }

    CD4051B_ChannelSet(channel);
}

/****************************************************************************
CD4051B_Debounce_Service

******************************************************************************/
void CD4051B_Debounce_Service(void)
{
    uint8_t comcnt;
    uint8_t chcnt;
    comcnt = 0u;
    chcnt = 0u;
    for (comcnt = 0u; comcnt < COMTotal; comcnt++)
    {
        for (chcnt = 0u; chcnt < MaxChannel; chcnt++)
        {
            if (CD4051B_GeneralCOM_Cache[comcnt][chcnt] == CD4051CtrStr[comcnt][chcnt].Last)
            {
                CD4051CtrStr[comcnt][chcnt].time++;
                if (CD4051B_GeneralCOM_Cache[comcnt][chcnt] == 1u)
                {
                    if (CD4051CtrStr[comcnt][chcnt].time >= CD4051B_DEBOUNCE_High_CNT)
                    {

                        CD4051CtrStr[comcnt][chcnt].time = 0u;
                        CD4051B_GeneralCOM_Value[comcnt][chcnt] = 1u;
                    }
                    else
                    {
                        ;
                    }
                }
                else
                {
                    if (CD4051CtrStr[comcnt][chcnt].time >= CD4051B_DEBOUNCE_Low_CNT)
                    {
                        CD4051CtrStr[comcnt][chcnt].time = 0u;
                        CD4051B_GeneralCOM_Value[comcnt][chcnt] = 0u;
                    }
                    else
                    {
                        ;
                    }
                }
            }
            else
            {
                CD4051CtrStr[comcnt][chcnt].time = 0u;
                CD4051CtrStr[comcnt][chcnt].Last = CD4051B_GeneralCOM_Cache[comcnt][chcnt];
            }
        }
    }
}

/****************************************************************************
CD4051B_GetComValue

******************************************************************************/
uint16_t CD4051B_GetComValue(uint8_t num, uint8_t ch)
{
    return CD4051B_GeneralCOM_Value[num][ch];
}