#ifndef CAN_COMMUNICATION_MATRIX_H_
#define CAN_COMMUNICATION_MATRIX_H_

#include "TYW_stdint.h"
#include "CAN_Lib.h"

typedef enum
{
    /* 0*/ID_CanMsg18FF5510_Msg_Count,
    /* 1*/ID_CanMsg18FF2300_Msg_Count,
    /* 2*/ID_CanMsg18FED900_Msg_Count,
    /* 3*/ID_CanMsg18FE5BE8_Msg_Count,
    /* 4*/ID_CanMsg18FECA0B_Msg_Count,
    /* 5*/ID_CanMsg18011733_Msg_Count,
    /* 6*/ID_CanMsg18FE4F0B_Msg_Count,
    /* 7*/ID_CanMsg18F0010B_Msg_Count,
    /* 8*/ID_CanMsg0CF02F2A_Msg_Count,
    /* 9*/ID_CanMsg0CF02FA1_Msg_Count,
    /*10*/ID_CanMsg0CF02FA0_Msg_Count,
    /*11*/ID_CanMsg18EBFF03_Msg_Count,
    /*12*/ID_CanMsg18ECFF03_Msg_Count,
    /*13*/ID_CanMsg18FECA03_Msg_Count,
    /*14*/ID_CanMsg0CF00400_Msg_Count,
    /*15*/ID_CanMsg18FEEE00_Msg_Count,
    /*16*/ID_CanMsg0C0320C8_Msg_Count,
    /*17*/ID_CanMsg0C0320C0_Msg_Count,
    /*18*/ID_CanMsg0C0320B8_Msg_Count,
    /*19*/ID_CanMsg0C0320B0_Msg_Count,
    /*20*/ID_CanMsg0C0320A8_Msg_Count,
    /*21*/ID_CanMsg0CFF0F15_Msg_Count,
    /*22*/ID_CanMsg18FF4925_Msg_Count,
    /*23*/ID_CanMsg18F00503_Msg_Count,
    /*24*/ID_CanMsg18FF8503_Msg_Count,
    /*25*/ID_CanMsg18FE4A03_Msg_Count,
    /*26*/ID_CanMsg18FF4100_Msg_Count,
    /*27*/ID_CanMsg10F007E8_Msg_Count,
    /*28*/ID_CanMsg18EF1718_Msg_Count,
    /*29*/ID_CanMsg18FEE518_Msg_Count,
    /*30*/ID_CanMsg18FF3018_Msg_Count,
    /*31*/ID_CanMsg18FF1211_Msg_Count,
    /*32*/ID_CanMsg10FF462D_Msg_Count,
    /*33*/ID_CanMsg10FF477E_Msg_Count,
    /*34*/ID_CanMsg18FF5612_Msg_Count,
    /*35*/ID_CanMsg18FD7C00_Msg_Count,
    /*36*/ID_CanMsg18FECAE8_Msg_Count,
    /*37*/ID_CanMsg18FEED00_Msg_Count,
    /*38*///ID_CanMsg18FF3018_Msg_Count,
    /*39*/ID_CanMsg18021733_Msg_Count,
    /*40*/ID_CanMsg0C010305_Msg_Count,
    /*41*/ID_CanMsg18FECA2A_Msg_Count,
    /*42*/ID_CanMsg18FECAA1_Msg_Count,
    /*43*/ID_CanMsg18FECAA0_Msg_Count,

    ID_CanMsg18FECA00_Msg_Count,
    ID_CanMsg18FECA10_Msg_Count,

    ID_CanMsg18ECFF00_Msg_Count,
    ID_CanMsg18EBFF00_Msg_Count,
    ID_CanMsg18ECFF0B_Msg_Count,
    ID_CanMsg18EBFF0B_Msg_Count,
    ID_CanMsg18ECFF10_Msg_Count,
    ID_CanMsg18EBFF10_Msg_Count,
    ID_CanMsg18ECFFA0_Msg_Count,
    ID_CanMsg18EBFFA0_Msg_Count,
    ID_CanMsg18ECFFE8_Msg_Count,
    ID_CanMsg18EBFFE8_Msg_Count,

    ID_TOTAL_MAX,
} CAN_MSG_ID_t;

typedef enum
{
    MSGID_18FEAE17,
    MSGID_18FF3E17,
    MSGID_18FED917,
    MSGID_18FEE617,
    MSGID_18EF1817,
    MSGID_18FEE017,
    MSGID_18FEFC17,
    MSGID_18FF2517,
    MSGID_18FF2A17,
    MSGID_18FF9D17,
    MSGID_18FFE517,
    //MSGID_18EF2D17,
    MSGID_18033317,
    MSGID_180433A2,
    MSGID_18EA0017,

    ID_SEND_TOTAL,
} CAN_MSG_SEND_ID_t;

extern const st_CANMsgAttribute CAN_MSG_CONST_ARRAY[ID_TOTAL_MAX] ;
extern const st_CAN_SendAttribute    st_CANSendAttr[ID_SEND_TOTAL] ;

#define  ID_CanMsg18FF5510_Msg    0x18FF5510u
#define  ID_CanMsg18FF2300_Msg    0x18FF2300u
#define  ID_CanMsg18FED900_Msg    0x18FED900u
#define  ID_CanMsg18FE5BE8_Msg    0x18FE5BE8u
#define  ID_CanMsg18FECA0B_Msg    0x18FECA0Bu
#define  ID_CanMsg18011733_Msg    0x18011733u
#define  ID_CanMsg18FE4F0B_Msg    0x18FE4F0Bu
#define  ID_CanMsg18F0010B_Msg    0x18F0010Bu
#define  ID_CanMsg0CF02F2A_Msg    0x0CF02F2Au
#define  ID_CanMsg0CF02FA1_Msg    0x0CF02FA1u
#define  ID_CanMsg0CF02FA0_Msg    0x0CF02FA0u
#define  ID_CanMsg18EBFF03_Msg    0x18EBFF03u
#define  ID_CanMsg18ECFF03_Msg    0x18ECFF03u
#define  ID_CanMsg18FECA03_Msg    0x18FECA03u
#define  ID_CanMsg0CF00400_Msg    0x0CF00400u
#define  ID_CanMsg18FEEE00_Msg    0x18FEEE00u
#define  ID_CanMsg0C0320C8_Msg    0x0C0320C8u
#define  ID_CanMsg0C0320C0_Msg    0x0C0320C0u
#define  ID_CanMsg0C0320B8_Msg    0x0C0320B8u
#define  ID_CanMsg0C0320B0_Msg    0x0C0320B0u
#define  ID_CanMsg0C0320A8_Msg    0x0C0320A8u
#define  ID_CanMsg0CFF0F15_Msg    0x0CFF0F15u
#define  ID_CanMsg18FF4925_Msg    0x18FF4925u
#define  ID_CanMsg18F00503_Msg    0x18F00503u
#define  ID_CanMsg18FF8503_Msg    0x18FF8503u
#define  ID_CanMsg18FE4A03_Msg    0x18FE4A03u
#define  ID_CanMsg18FF4100_Msg    0x18FF4100u
#define  ID_CanMsg10F007E8_Msg    0x10F007E8u
#define  ID_CanMsg18EF1718_Msg    0x18EF1718u
#define  ID_CanMsg18FEE518_Msg    0x18FEE518u
#define  ID_CanMsg18FF3018_Msg    0x18FF3018u
#define  ID_CanMsg18FF1211_Msg    0x18FF1211u
#define  ID_CanMsg10FF462D_Msg    0x10FF462Du
#define  ID_CanMsg10FF477E_Msg    0x10FF477Eu
#define  ID_CanMsg18FF5612_Msg    0x18FF5612u
#define  ID_CanMsg18FD7C00_Msg    0x18FD7C00u
#define  ID_CanMsg18FECAE8_Msg    0x18FECAE8u
#define  ID_CanMsg18FEED00_Msg    0x18FEED00u
//#define  ID_CanMsg18FF3018_Msg    0x18FF3018u
#define  ID_CanMsg18021733_Msg    0x18021733u
#define  ID_CanMsg0C010305_Msg    0x0C010305u
#define  ID_CanMsg18FECA2A_Msg    0x18FECA2Au
#define  ID_CanMsg18FECAA1_Msg    0x18FECAA1u
#define  ID_CanMsg18FECAA0_Msg    0x18FECAA0u

#define  ID_CanMsg18FECA00_Msg    0x18FECA00u
#define  ID_CanMsg18FECA10_Msg    0x18FECA10u

#define  ID_CanMsg18ECFF00_Msg    0x18ECFF00u
#define  ID_CanMsg18EBFF00_Msg    0x18EBFF00u
#define  ID_CanMsg18ECFF0B_Msg    0x18ECFF0Bu
#define  ID_CanMsg18EBFF0B_Msg    0x18EBFF0Bu
#define  ID_CanMsg18ECFF10_Msg    0x18ECFF10u
#define  ID_CanMsg18EBFF10_Msg    0x18EBFF10u
#define  ID_CanMsg18ECFFA0_Msg    0x18ECFFA0u
#define  ID_CanMsg18EBFFA0_Msg    0x18EBFFA0u
#define  ID_CanMsg18ECFFE8_Msg    0x18ECFFE8u
#define  ID_CanMsg18EBFFE8_Msg    0x18EBFFE8u

extern uint8_t  Get_ID_18FF5510_Sig_Intarder_Pilot_Lamp_State(void);
extern uint8_t  Get_ID_18FF2300_Sig_EXH_System(void);
extern uint8_t  Get_ID_18FF2300_Sig_Engine_Derate(void);
extern uint8_t  Get_ID_18FF2300_Sig_Amber3(void);
extern uint8_t  Get_ID_18FF2300_Sig_Amber2(void);
extern uint8_t  Get_ID_18FF2300_Sig_Amber1(void);
extern uint8_t  Get_ID_18FF2300_Sig_Level_blinking(void);
extern uint8_t  Get_ID_18FF2300_Sig_Tank_Level(void);
extern uint8_t  Get_ID_18FF2300_Sig_Glow_Lamp(void);
extern uint8_t  Get_ID_18FF2300_Sig_Exh_Lamp(void);
extern uint8_t  Get_ID_18FED900_Sig_PTO_SW(void);
extern uint8_t  Get_ID_18FED900_Sig_DPF_Regeneration_Status(void);
extern uint8_t  Get_ID_18FED900_Sig_DPF_storage(void);
extern uint8_t  Get_ID_18FED900_Sig_SVS_Lamp_Status(void);
extern uint8_t  Get_ID_18FE5BE8_Sig_Camera_Status(void);
extern uint8_t  Get_ID_18FE5BE8_Sig_Lane_Tracking_Status_Right_Side(void);
extern uint8_t  Get_ID_18FE5BE8_Sig_Lane_Tracking_Status_Left_Side(void);
extern uint8_t  Get_ID_18FE5BE8_Sig_Lane_Departure_Warning_Sys_Sta(void);
extern uint8_t  Get_ID_18FECA0B_Sig_Amber_Warning_Lamp_Status(void);
extern uint8_t  Get_ID_18011733_Sig_Data_invalid(void);
extern uint8_t  Get_ID_18011733_Sig_Data_updating(void);
extern uint8_t  Get_ID_18011733_Sig_Tire_Temperature(void);
extern uint8_t  Get_ID_18011733_Sig_Tire_Temperature_Sign(void);
extern uint16_t Get_ID_18011733_Sig_Tire_Pressure(void);
extern uint8_t  Get_ID_18011733_Sig_Tire_Index(void);
extern uint8_t  Get_ID_18011733_Sig_Fast_air_leakage_alarm(void);
extern uint8_t  Get_ID_18011733_Sig_Low_Voltage_Alarm(void);
extern uint8_t  Get_ID_18011733_Sig_Sensor_fault_information(void);
extern uint8_t  Get_ID_18011733_Sig_No_signal_Alarm(void);
extern uint8_t  Get_ID_18011733_Sig_High_Temperature_Alarm(void);
extern uint8_t  Get_ID_18011733_Sig_High_Presure_Alarm(void);
extern uint8_t  Get_ID_18011733_Sig_Low_Presure_Alarm(void);
extern uint8_t  Get_ID_18FE4F0B_Sig_ROP_Engine_Control_Active(void);
extern uint8_t  Get_ID_18FE4F0B_Sig_YC_Engine_Control_Active(void);
extern uint8_t  Get_ID_18FE4F0B_Sig_YC_Brake_Control_Active(void);
extern uint8_t  Get_ID_18FE4F0B_Sig_ROP_Brake_Control_Active(void);
extern uint8_t  Get_ID_18FE4F0B_Sig_VDC_Lamp_State(void);
extern uint8_t  Get_ID_18FE4F0B_Sig_VDC_Fully_operational(void);
extern uint8_t  Get_ID_18F0010B_Sig_ATC_or_ASR_Lamp_State(void);
extern uint8_t  Get_ID_18F0010B_Sig_EBS_Amber_Warning_State(void);
extern uint8_t  Get_ID_18F0010B_Sig_ASR_Brake_Control_Active(void);
extern uint8_t  Get_ID_18F0010B_Sig_EBS_Red_Warning_Lamp_State(void);
extern uint8_t  Get_ID_18F0010B_Sig_ABS_Fully_Operational(void);
extern uint8_t  Get_ID_18F0010B_Sig_ASR_Offroad_Switch(void);
extern uint8_t  Get_ID_CF02F2A_Sig_Relevant_objected_for_AEBS(void);
extern uint8_t  Get_ID_CF02F2A_Sig_Advanced_Emerg_Braking_Sys_Sta(void);
extern uint8_t  Get_ID_CF02FA1_Sig_Relevant_objected_for_AEBS(void);
extern uint8_t  Get_ID_CF02FA1_Sig_Advanced_Emerg_Braking_Sys_Sta(void);
extern uint8_t  Get_ID_CF02FA0_Sig_Relevant_objected_for_AEBS(void);
extern uint8_t  Get_ID_CF02FA0_Sig_Advanced_Emerg_Braking_Sys_Sta(void);
extern uint8_t  Get_ID_18EBFF03_Sig_Malfunction_indicator_Lamp(void);
extern uint8_t  Get_ID_18EBFF03_Sig_Amber_Warning_Lamp_Status(void);
extern uint8_t  Get_ID_18ECFF03_Sig_Malfunction_indicator_Lamp(void);
extern uint8_t  Get_ID_18ECFF03_Sig_Amber_Warning_Lamp_Status(void);
extern uint8_t  Get_ID_18FECA03_Sig_Malfunction_indicator_Lamp(void);
extern uint8_t  Get_ID_18FECA03_Sig_Amber_Warning_Lamp_Status(void);
extern uint8_t  Get_ID_CF00400_Sig_Speed_Limiter_Control_Mode(void);
extern uint16_t Get_ID_CF00400_Sig_Engine_speed(void);
extern uint8_t  Get_ID_18FEEE00_Sig_Engine_Coolant_Temperature(void);
extern uint8_t  Get_ID_C0320C8_Sig_ID0C0320C8_byte2_bit1_2(void);
extern uint8_t  Get_ID_C0320C0_Sig_ID0C0320C0_byte2_bit1_2(void);
extern uint8_t  Get_ID_C0320B8_Sig_ID0C0320B8_byte2_bit1_2(void);
extern uint8_t  Get_ID_C0320B0_Sig_ID0C0320B0_byte2_bit1_2(void);
extern uint8_t  Get_ID_C0320A8_Sig_ID0C0320A8_byte2_bit1_2(void);
extern uint8_t  Get_ID_CFF0F15_Sig_ID0CFF0F15_byte2_bit1_8(void);
extern uint8_t  Get_ID_CFF0F15_Sig_ID0CFF0F15_byte1_bit4_5(void);
extern uint8_t  Get_ID_18FF4925_Sig_ID18FF4925_byte3_bit1_2(void);
extern uint8_t  Get_ID_18FF4925_Sig_ID18FF4925_byte3_bit3_4(void);
extern uint8_t  Get_ID_18F00503_Sig_ID18F00503_byte5(void);
extern uint8_t  Get_ID_18F00503_Sig_Current_Gear(void);
extern uint8_t  Get_ID_18FF8503_Sig_Low_air_warning(void);
extern uint8_t  Get_ID_18FF8503_Sig_Clutch_Overload_warning(void);
extern uint8_t  Get_ID_18FF8503_Sig_Clutch_Wear_warning(void);
extern uint8_t  Get_ID_18FF8503_Sig_Spanner_Warning(void);
extern uint8_t  Get_ID_18FF8503_Sig_Stop_Warning(void);
extern uint8_t  Get_ID_18FF8503_Sig_Automatic_or_Manual_Mode(void);
extern uint8_t  Get_ID_18FF8503_Sig_Manouvering_mode(void);
extern uint8_t  Get_ID_18FE4A03_Sig_TransmissionSiftMode1_Indicator(void);
extern uint8_t  Get_ID_18FF4100_Sig_Cruise_VariableSLD_Cont_Staus(void);
extern uint8_t  Get_ID_18FF4100_Sig_Indicate_Lamp_Speed(void);
extern uint8_t  Get_ID_18FF4100_Sig_Cruise_VariableSLD_Disp(void);
extern uint8_t  Get_ID_10F007E8_Sig_Lane_Departure_Imminent_Right(void);
extern uint8_t  Get_ID_10F007E8_Sig_Lane_Departure_Imminent_Left(void);
extern uint8_t  Get_ID_18EF1718_Sig_Door_SW(void);
extern uint32_t Get_ID_18EF1718_Sig_Date(void);
extern uint8_t  Get_ID_18EF1718_Sig_Data_Type(void);
extern uint8_t  Get_ID_18EF1718_Sig_Response_Code(void);
extern uint32_t Get_ID_18FEE518_Sig_Total_Engine_Hours(void);
extern uint8_t  Get_ID_18FF3018_Sig_Current_Gear(void);
extern uint8_t  Get_ID_18FF3018_Sig_ECO_Data(void);
extern uint8_t  Get_ID_18FF3018_Sig_TM_OH_Warnning(void);
extern uint8_t  Get_ID_18FF3018_Sig_Exh_Valve_OH_Warnning(void);
extern uint8_t  Get_ID_18FF3018_Sig_ACG_OH_Warnning(void);
extern uint8_t  Get_ID_18FF3018_Sig_Starter_OH_Warnning(void);
extern uint8_t  Get_ID_18FF3018_Sig_Engine_Oil_Warnning(void);
extern uint8_t  Get_ID_18FF1211_Sig_ID18FF1211_byte3_bit1_8(void);
extern uint8_t  Get_ID_10FF462D_Sig_ID10FF462D_byte5(void);
extern uint8_t  Get_ID_10FF462D_Sig_ID10FF462D_byte2_bit1_8(void);
extern uint8_t  Get_ID_10FF477E_Sig_ID10FF477E_byte2_bit1_8(void);
extern uint8_t  Get_ID_18FF5612_Sig_ID18FF5612_byte3_bit1_8(void);
extern uint8_t  Get_ID_18FD7C00_Sig_DPF_Lamp_Status_Amber(void);
extern uint8_t  Get_ID_18FECAE8_Sig_Amber_Warning_Lamp_Status(void);
extern uint8_t  Get_ID_18FEED00_Sig_Maximum_Vehicle_Speed_Limit(void);
//extern uint32_t Get_ID_18EA0021_Sig_CruiseControl_VehicleSpeedSetup(void);
extern uint8_t  Get_ID_0C010305_Sig_Auto_EcoPow(void);
extern uint32_t Get_ID_18FECA03_Sig_SPN(void);
extern uint8_t  Get_ID_18FECA03_Sig_FMI(void);
extern uint8_t  Get_ID_18FECA2A_Sig_AebsOff(void);
extern uint8_t  Get_ID_18FECAA1_Sig_AebsOff(void);
extern uint8_t  Get_ID_18FECAA0_Sig_AebsOff(void);

extern uint16_t Get_ID_18FECA00_Sig_DM1(void);
extern uint8_t  Get_ID_18ECFF00_Sig_PRIO(void);
extern uint8_t  Get_ID_18ECFF00_Sig_DATA_NUM(void);
extern uint8_t  Get_ID_18ECFF00_Sig_FRAME_NUM(void);
extern uint8_t  Get_ID_18ECFF00_Sig_PS(void);
extern uint16_t Get_ID_18ECFF00_Sig_PGN(void);
extern uint8_t  Get_ID_18ECFF00_Sig_SA(void);
extern uint8_t  Get_ID_18EBFF00_Sig_DATA(uint8_t Data_Buff);

extern uint16_t Get_ID_18FECA03_Sig_DM1(void);
extern uint8_t  Get_ID_18ECFF03_Sig_PRIO(void);
extern uint8_t  Get_ID_18ECFF03_Sig_DATA_NUM(void);
extern uint8_t  Get_ID_18ECFF03_Sig_FRAME_NUM(void);
extern uint8_t  Get_ID_18ECFF03_Sig_PS(void);
extern uint16_t Get_ID_18ECFF03_Sig_PGN(void);
extern uint8_t  Get_ID_18ECFF03_Sig_SA(void);
extern uint8_t  Get_ID_18EBFF03_Sig_DATA(uint8_t Data_Buff);

extern uint16_t Get_ID_18FECA0B_Sig_DM1(void);
extern uint8_t  Get_ID_18ECFF0B_Sig_PRIO(void);
extern uint8_t  Get_ID_18ECFF0B_Sig_DATA_NUM(void);
extern uint8_t  Get_ID_18ECFF0B_Sig_FRAME_NUM(void);
extern uint8_t  Get_ID_18ECFF0B_Sig_PS(void);
extern uint16_t Get_ID_18ECFF0B_Sig_PGN(void);
extern uint8_t  Get_ID_18ECFF0B_Sig_SA(void);
extern uint8_t  Get_ID_18EBFF0B_Sig_DATA(uint8_t Data_Buff);

extern uint16_t Get_ID_18FECA10_Sig_DM1(void);
extern uint8_t  Get_ID_18ECFF10_Sig_PRIO(void);
extern uint8_t  Get_ID_18ECFF10_Sig_DATA_NUM(void);
extern uint8_t  Get_ID_18ECFF10_Sig_FRAME_NUM(void);
extern uint8_t  Get_ID_18ECFF10_Sig_PS(void);
extern uint16_t Get_ID_18ECFF10_Sig_PGN(void);
extern uint8_t  Get_ID_18ECFF10_Sig_SA(void);
extern uint8_t  Get_ID_18EBFF10_Sig_DATA(uint8_t Data_Buff);

extern uint16_t Get_ID_18FECAA0_Sig_DM1(void);
extern uint8_t  Get_ID_18ECFFA0_Sig_PRIO(void);
extern uint8_t  Get_ID_18ECFFA0_Sig_DATA_NUM(void);
extern uint8_t  Get_ID_18ECFFA0_Sig_FRAME_NUM(void);
extern uint8_t  Get_ID_18ECFFA0_Sig_PS(void);
extern uint16_t Get_ID_18ECFFA0_Sig_PGN(void);
extern uint8_t  Get_ID_18ECFFA0_Sig_SA(void);
extern uint8_t  Get_ID_18EBFFA0_Sig_DATA(uint8_t Data_Buff);

extern uint16_t Get_ID_18FECAE8_Sig_DM1(void);
extern uint8_t  Get_ID_18ECFFE8_Sig_PRIO(void);
extern uint8_t  Get_ID_18ECFFE8_Sig_DATA_NUM(void);
extern uint8_t  Get_ID_18ECFFE8_Sig_FRAME_NUM(void);
extern uint8_t  Get_ID_18ECFFE8_Sig_PS(void);
extern uint16_t Get_ID_18ECFFE8_Sig_PGN(void);
extern uint8_t  Get_ID_18ECFFE8_Sig_SA(void);
extern uint8_t  Get_ID_18EBFFE8_Sig_DATA(uint8_t Data_Buff);

extern uint8_t  Co_Can_ConvertSubID(uint32_t MsgID);

#endif
