#include "GUI.h"
#include "r_wm_api.h"

#include "r_typedefs.h"
#include "loc_graphics.h"
#include "images.h"
#include "jcua.h"
#include "Watchdog.h"
#include "Menu.h"
#include "GUI_Interface.h"
#include "CAN_Communication_Matrix.h"
#include "Services_Mileage.h"
#include "RTE_ADC.h"
#include "GaugesInterface.h"
#include "Service_TPMS.h"
#include "DisplaySch_user.h"
#include "CD4051.h"
#include "Data_Gear.h"
#include "Maintenance.h"
#include "Data_FuelConsump.h"
#include "Common_Interface.h"
#include "System_Monitor.h"
#include "Flash_synchronizer.h"
#include "Popups.h"
#include "Data_Fuel_User.h"
#include "CAN_FUNC.h"
#include "key.h"
#include "Data_Voltmeter.h"
#include "Data_AirPressure.h"
#include "Popup_Message_List.h"
#include "Popup_Scheduler.h"
#include "Popups.h"
#include "kwp2000_service.h"
#include "CAN_FUNC.h"

#pragma alignvar(8)
Display_Modular_St Display_DTC[DTCNumeber + 1u];
#pragma alignvar(8)
uint32_t EolNUM[10u][8u];

uint8_t DTCNumTime = 0u;
static uint8_t GUIDTCNumDis = 0u;
uint8_t DTCDispNum;
uint32_t DTNum = 0u;
uint8_t DPD_Display_Time;

_Display_State_Flag     State_Flag; /*0-常态 1-小于0 2-小于1000 3-无此功能*/
_TPMS                   TPMS_Matching;
_UserSet                User_set_Num;
_UserSet                User_App;

/*-------------------------------------------------------------------------
 * Function Name  : GUI_Display_KL15_ON_Init
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void GUI_Display_KL15_ON_Init(void)
{
    loc_enable_mem(WET_Sprite, Calendar_Sprite);
    GUI_Display_Value_Init();
    //GUI_Display_background();
}

/*-------------------------------------------------------------------------
 * Function Name  : GUI_Display_KL15_OFF_Init
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void GUI_Display_KL15_OFF_Init(void)
{
    loc_Del_Sprite(WET_Sprite, Calendar_Sprite);
    loc_free_mem(WET_Sprite, Calendar_Sprite);
}

/*-------------------------------------------------------------------------
 * Function Name  : GUI_Display_background
 * Description    : 显示底图
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : None
 --------------------------------------------------------------------------*/
void GUI_Display_background(void)
{
    GUI_General_Display(WET_Sprite, ditu_2, GUI_BLENDMODE_CUSTOM);
}
void GUI_Display_backgroundOFF(void)
{
    GUI_General_Display(WET_Sprite          , quanping_black, GUI_BLENDMODE_CUSTOM);

    GUI_General_Display(WET_Sprite          , SpriteSize,     GUI_BLENDMODE_CUSTOM);
    GUI_General_Display(AdBlue_Sprite       , SpriteSize,     GUI_BLENDMODE_CUSTOM);
    GUI_General_Display(TRIP_Sprite         , SpriteSize,     GUI_BLENDMODE_CUSTOM);
    GUI_General_Display(ODO_Sprite          , SpriteSize,     GUI_BLENDMODE_CUSTOM);
    GUI_General_Display(WarningLight_Sprite , SpriteSize,     GUI_BLENDMODE_CUSTOM);
    GUI_General_Display(ADAS_Sprite         , SpriteSize,     GUI_BLENDMODE_CUSTOM);
    GUI_General_Display(MultiPurpose_Sprite , SpriteSize,     GUI_BLENDMODE_CUSTOM);
    GUI_General_Display(Cruise_Sprite       , SpriteSize,     GUI_BLENDMODE_CUSTOM);
    GUI_General_Display(Gear_Sprite         , SpriteSize,     GUI_BLENDMODE_CUSTOM);
    GUI_General_Display(Temp_Sprite         , SpriteSize,     GUI_BLENDMODE_CUSTOM);
    GUI_General_Display(Time_Sprite         , SpriteSize,     GUI_BLENDMODE_CUSTOM);
    GUI_General_Display(Calendar_Sprite     , SpriteSize,     GUI_BLENDMODE_CUSTOM);
}
/*开机动画*/
void GUI_Display_Animation_Frame(uint16_t frame)
{
    if (frame >= 112u)
    {
        frame = 112u;
    }

    GUI_General_Display(WET_Sprite, ISUZU_000 + frame, GUI_BLENDMODE_SRC_OVER);
}
void GUI_Display_Value_Init(void)
{
    /*菜单状态初始化*/
    State_Flag.FState_GZM     = 1u ;
    State_Flag.FState_WXTZ    = 2u ;
    State_Flag.FState_WXSD    = 2u ;
    State_Flag.FState_YHSD    = 2u ;
    State_Flag.FState_SYSYS   = 2u ;
    State_Flag.FState_TPMS    = 2u ;
    State_Flag.FState_ECO     = 1u ;

    State_Flag.WXTZ_FDJY      = 2u ;
    State_Flag.WXTZ_RYLQY     = 2u ;
    State_Flag.WXTZ_BSXY      = 2u ;
    State_Flag.WXTZ_CSQY      = 2u ;
    State_Flag.WXTZ_LHQY      = 1u ;
    State_Flag.WXTZ_KQGZJ     = 2u ;
    State_Flag.WXTZ_DLZXY     = 2u ;
    State_Flag.WXTZ_LT        = 2u ;
    State_Flag.WXTZ_QDJ       = 2u ;

    State_Flag.WXSD_FDJY      = 2u ;
    State_Flag.WXSD_RYLQY     = 2u ;
    State_Flag.WXSD_BSXY      = 2u ;
    State_Flag.WXSD_CSQY      = 2u ;
    State_Flag.WXSD_LHQY      = 1u ;
    State_Flag.WXSD_KQGZJ     = 2u ;
    State_Flag.WXSD_DLZXY     = 2u ;
    State_Flag.WXSD_LT        = 2u ;
    State_Flag.WXSD_QDJ       = 2u ;

    State_Flag.USER_DATE      = 2u ;
    State_Flag.USER_TIME      = 2u ;
    State_Flag.USER_DISPLAY   = 2u ;
    State_Flag.USER_PROPOSAL  = 2u ;
    State_Flag.USER_HSA       = 1u ;
    State_Flag.USER_VOLUEM    = 1u ;
    State_Flag.USER_LANGUAGE  = 2u ;
    State_Flag.USER_COMPANY   = 2u ;
    State_Flag.USER_LIGHT     = 2u ;
    State_Flag.FState_TPMSSET = 2u ;

    State_Flag.DEMO_LDWS      = 2u ;
    State_Flag.DEMO_AEBS1     = 2u ;
    State_Flag.DEMO_AEBS2     = 2u ;
    State_Flag.DEMO_AEBS3     = 2u ;

    State_Flag.FState_ClearOilTx = 0u;
    State_Flag.FState_ClearOilRx = 1u;
    State_Flag.FState_COilTimeOut = FState_COilTimeOutNum;

    /*应用*/
    User_App.User_Language        = 1u ;
    User_App.User_Company         = 1u ;
    User_App.User_Light1          = K_Line_Set.User_Light1 ;
    User_App.User_Light2          = K_Line_Set.User_Light2 ;
    User_App.Trip_Type            = 1u;

    /*保养状态标识*/
    if (K_Line_Set.K_Line_LID4F)
    {
        State_Flag.User_FDJYLQQ_FLAG = 0u;
    }
    else
    {
        State_Flag.User_FDJYLQQ_FLAG = 3u;
    }

    if (K_Line_User_RYLQQ)
    {
        State_Flag.User_RYLQQ_FLAG  = 0u;
    }
    else
    {
        State_Flag.User_RYLQQ_FLAG  = 3u;
    }

    if (K_Line_Set.K_Line_LID4A)
    {
        State_Flag.User_BSXY_FLAG   = 0u;
    }
    else
    {
        State_Flag.User_BSXY_FLAG   = 3u;
    }

    if (K_Line_Set.K_Line_LID4B)
    {
        State_Flag.User_CSQY_FLAG   = 0u;
    }
    else
    {
        State_Flag.User_CSQY_FLAG   = 3u;
    }

    if (K_Line_User_KQGZJ)
    {
        State_Flag.User_KQGZJ_FLAG  = 0u;
    }
    else
    {
        State_Flag.User_KQGZJ_FLAG  = 3u;
    }

    if (K_Line_Set.K_Line_LID4D)
    {
        State_Flag.User_DLZXY_FLAG  = 0u;
    }
    else
    {
        State_Flag.User_DLZXY_FLAG  = 3u;
    }

    if (K_Line_Set.K_Line_LID4E)
    {
        State_Flag.User_LT_FLAG     = 0u;
    }
    else
    {
        State_Flag.User_LT_FLAG     = 3u;
    }

    User_App.User_FDJYLQQ         = (uint32_t)K_Line_Set.K_Line_LID4F * 1000u ;  /*发动机油*/
    User_App.User_RYLQQ           = (uint32_t)K_Line_User_RYLQQ * 1000u       ;  /*燃油滤清器*/
    User_App.User_BSXY            = (uint32_t)K_Line_Set.K_Line_LID4A * 1000u ;  /*变速箱油*/
    User_App.User_CSQY            = (uint32_t)K_Line_Set.K_Line_LID4B * 1000u ;  /*差速器油*/
    User_App.User_KQGZJ           = (uint32_t)K_Line_User_KQGZJ * 1000u       ;  /*空气干燥剂*/
    User_App.User_DLZXY           = (uint32_t)K_Line_Set.K_Line_LID4D * 1000u ;  /*动力转向油*/
    User_App.User_LT              = (uint32_t)K_Line_Set.K_Line_LID4E * 1000u ;  /*轮胎*/

    User_set_Num.User_FDJYLQQ     =  User_App.User_FDJYLQQ ;
    User_set_Num.User_RYLQQ       =  User_App.User_RYLQQ   ;
    User_set_Num.User_BSXY        =  User_App.User_BSXY    ;
    User_set_Num.User_CSQY        =  User_App.User_CSQY    ;
    User_set_Num.User_KQGZJ       =  User_App.User_KQGZJ   ;
    User_set_Num.User_DLZXY       =  User_App.User_DLZXY   ;
    User_set_Num.User_LT          =  User_App.User_LT      ;

    User_set_Num.User_Tpms        =  0u;

    /*用户设定*/
    User_set_Num.User_Language    =  User_App.User_Language;
    User_set_Num.User_Company     =  User_App.User_Company ;
    User_set_Num.User_Light1      =  User_App.User_Light1  ;
    User_set_Num.User_Light2      =  User_App.User_Light2  ;
    User_set_Num.Trip_Type        =  User_App.Trip_Type    ;

    User_App.User_Gsl             = 0xFFu;
    User_App.User_Ybl             = 0xFFu;
    User_App.User_Speed           = K_Line_Set.K_Line_LID45;   /*发动机转速*/
    User_App.User_JADD            = K_Line_Set.K_Line_LID46;   /*急加速*/
    User_App.User_JSUB            = K_Line_Set.K_Line_LID47;   /*急减速*/
    User_App.User_IDLING          = K_Line_Set.K_Line_LID48;   /*长时间怠速*/
    User_App.User_Parking         = K_Line_Set.K_Line_LID49;   /*辅助驻车*/

    User_set_Num.User_Gsl         = User_App.User_Gsl      ;
    User_set_Num.User_Ybl         = User_App.User_Ybl      ;
    User_set_Num.User_Speed       = User_App.User_Speed    ;
    User_set_Num.User_JADD        = User_App.User_JADD     ;
    User_set_Num.User_JSUB        = User_App.User_JSUB     ;
    User_set_Num.User_IDLING      = User_App.User_IDLING   ;
    User_set_Num.User_Parking     = User_App.User_Parking  ;

    MenuFlag.Menu_Flag            = 0u; /*菜单初始化位置*/
    MenuFlag.Meun_Test_Dealer     = 0u;
    MenuFlag.Menu_StaFlag         = 1u; /*默认在通常模式*/
    K_Line_Set.K_Line_LID51       = 0x01u;

    DTCNumTime                    = 0u; /*故障码显示时间*/
    GUIDTCNumDis                  = 0u; /*当前显示的故障码*/

    Display_DTC[0u].Disp_Mod_Menu_Cbk = GUI_BG_DTCEngine_Display;      /*发动机故障*/
    Display_DTC[1u].Disp_Mod_Menu_Cbk = GUI_BG_DTCBrake_Display;       /*刹车故障*/
    Display_DTC[2u].Disp_Mod_Menu_Cbk = GUI_BG_DTCAMT_Display;         /*变速箱故障*/
    Display_DTC[3u].Disp_Mod_Menu_Cbk = GUI_BG_DTCRadar_Display;       /*雷达故障码*/
    Display_DTC[4u].Disp_Mod_Menu_Cbk = GUI_BG_DTCCamera_Display;      /*摄像头故障码*/
    Display_DTC[5u].Disp_Mod_Menu_Cbk = GUI_BG_DTCIntarder_Display;    /*液力缓速器故障码*/
    Display_DTC[6u].Disp_Mod_Menu_Cbk = GUI_Display_NULL;              /*无故障*/

    DPD_Display_Time = 0u;
}

/*-------------------------------------------------------------------------
 * Function Name  : GUI_Display_OftenShow_Group
 * Description    : 常显界面
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 常显功能界面均放在此处 此处显示区域 1 2 3 8
 --------------------------------------------------------------------------*/
void GUI_OftenShow_Display(void)
{
    uint8_t Trip_Type = 0u;

    Trip_Type = User_set_Num.Trip_Type;

    GUI_AC_Temp_Dispaly(GUI_DISP_MODE_BLANK);
    GUI_Time_Dispaly(GUI_DISP_MODE_NORMAL);
    GUI_Data_Dispaly(GUI_DISP_MODE_NORMAL);
    GUI_TFTTelltales_Display(GUI_DISP_MODE_NORMAL);
    GUI_WetGas_Dispaly(GUI_DISP_MODE_NORMAL);
    GUI_AdBlue_Dispaly(GUI_DISP_MODE_NORMAL);
    Gui_ODO_Display(GUI_DISP_MODE_NORMAL);

    if (Trip_Type == TRAPA)
    {
        Gui_TRIPA_Display(GUI_DISP_MODE_NORMAL);
    }
    else
    {
        Gui_TRIPB_Display(GUI_DISP_MODE_NORMAL);
    }
}

void GUI_OftenShowOFF_Display(void)
{
    uint8_t Trip_Type = 0u;

    Trip_Type = User_set_Num.Trip_Type;

    GUI_AC_Temp_Dispaly(GUI_DISP_MODE_BLANK);
    GUI_Time_Dispaly(GUI_DISP_MODE_BLANK);
    GUI_Data_Dispaly(GUI_DISP_MODE_BLANK);
    GUI_TFTTelltales_Display(GUI_DISP_MODE_BLANK);
    GUI_WetGas_Dispaly(GUI_DISP_MODE_BLANK);
    GUI_AdBlue_Dispaly(GUI_DISP_MODE_BLANK);
    Gui_ODO_Display(GUI_DISP_MODE_BLANK);

    if (Trip_Type == TRAPA)
    {
        Gui_TRIPA_Display(GUI_DISP_MODE_BLANK);
    }
    else
    {
        Gui_TRIPB_Display(GUI_DISP_MODE_BLANK);
    }
}

/*-------------------------------------------------------------------------
 * Function Name  : GUI_Dynamic_DIsplay
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
void GUI_Dynamic_DIsplay(void)
{
    Gui_ADAS_Display(GUI_DISP_MODE_NORMAL);
    Gui_DrivingSupport_Display(GUI_DISP_MODE_NORMAL);
    Gui_Gear_Display(GUI_DISP_MODE_NORMAL);
}

/*-------------------------------------------------------------------------
 * Function Name  : GUI_AC_Temp_Dispaly
 * Description    : 室外温度显示
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域 8 Temp_Sprite
 --------------------------------------------------------------------------*/
void GUI_AC_Temp_Dispaly(uint8_t Mode)
{
    uint8_t AC_TEMP_value = 0u;

    AC_TEMP_value = 17u;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_General_Display(Temp_Sprite, CN_xiaotianqi, GUI_BLENDMODE_SRC_OVER);  /*天气图标*/
        GUI_General_Display(Temp_Sprite, CN_shiwaiwendu, GUI_BLENDMODE_SRC_OVER); /*显示文字 “ 室外温度 ”*/

        if (1u)
        {
            GUI_Translate_Display(Temp_Sprite, Nb_12_heng, 207u, 58u, GUI_BLENDMODE_SRC_OVER); /*显示 负号*/
        }
        else
        {
            GUI_Translate_Display(Temp_Sprite, SpriteSize, 207u, 58u, GUI_BLENDMODE_SRC_OVER);
        }

        /*显示 外温 的数值*/
        GUI_General_Digit_Display(Temp_Sprite, AC_TEMP_value, Nb_12_0, 2u, 1u, GUI_DISP_AC_TEMP, 48u, GUI_BLENDMODE_SRC_OVER);

        GUI_General_Display(Temp_Sprite, CN_wendudanwei, GUI_BLENDMODE_SRC_OVER); /*显示 温度单位*/
    }
    else
    {
        GUI_General_Display(Temp_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*-------------------------------------------------------------------------
 * Function Name  : GUI_Time_Dispaly
 * Description    : 时间显示
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域 8 Time_Sprite
 --------------------------------------------------------------------------*/
void GUI_Time_Dispaly(uint8_t Mode)
{
    uint8_t Time_Hours = 0u;
    uint8_t Time_Minutes = 0u;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        /*时*/
        Time_Hours = Get_RTC_HOUR();

        if (0u) /*12小时*/
        {
            if (Time_Hours == 0)
            {
                GUI_General_Digit_Display(Time_Sprite, (Time_Hours + 12u), CN_RC_Nb_21_0, 2u, 1u, GUI_DISP_Hours, 37, GUI_BLENDMODE_SRC_OVER);
            }
            else if (Time_Hours > 12u)
            {
                GUI_General_Digit_Display(Time_Sprite, (Time_Hours - 12u), CN_RC_Nb_21_0, 2u, 1u, GUI_DISP_Hours, 37, GUI_BLENDMODE_SRC_OVER); /* PM */
            }
            else
            {
                GUI_General_Digit_Display(Time_Sprite, Time_Hours, CN_RC_Nb_21_0, 2u, 1u, GUI_DISP_Hours, 37, GUI_BLENDMODE_SRC_OVER); /* AM */
            }
        }
        else
        {
            GUI_General_Digit_Display(Time_Sprite, Time_Hours, CN_RC_Nb_21_0, 2u, 0u, GUI_DISP_Hours, 37, GUI_BLENDMODE_SRC_OVER); /*显示小时*/
        }

        /*分钟*/
        if (FLASH_SYNC_1Hz)
        {
            GUI_Translate_Display(Time_Sprite, Nb_21_maohao, 396u, 45u, GUI_BLENDMODE_SRC_OVER); /*显示冒号*/
        }
        else
        {
            GUI_General_Display(Time_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
        }

        Time_Minutes = Get_RTC_MINUTE();

        GUI_General_Digit_Display(Time_Sprite, Time_Minutes, CN_RC_Nb_21_0, 2u, 0u, GUI_DISP_Minutes, 37, GUI_BLENDMODE_SRC_OVER); /*显示分钟*/

    }
    else
    {
        GUI_General_Display(Time_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*-------------------------------------------------------------------------
 * Function Name  : GUI_Data_Dispaly
 * Description    : 日历显示
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域 8 Calendar_Sprite
 --------------------------------------------------------------------------*/
void GUI_Data_Dispaly(uint8_t Mode)
{
    uint16_t Year = 0u; /*年*/
    uint8_t Month = 0u; /*月*/
    uint8_t Date = 0u;  /*日*/
    uint8_t Week = 0u;  /*星期*/

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        Year = 2000 + Get_RTC_YEAR();
        Month = Get_RTC_MONTH();
        Date = Get_RTC_DATE();
        Week = Get_RTC_WEEK();

        GUI_Translate_Display(Calendar_Sprite, Nb_14_dian, 591u, 64u, GUI_BLENDMODE_SRC_OVER); /*显示年份后面的 “ . ”   */
        GUI_Translate_Display(Calendar_Sprite, Nb_14_dian, 642u, 64u, GUI_BLENDMODE_SRC_OVER); /*显示月份后面的 “ . ”   */

        GUI_General_Digit_Display(Calendar_Sprite, Year, CN_RC_Nb_14_0, 4u, 0u, GUI_DISP_Year, 48, GUI_BLENDMODE_SRC_OVER);   /*显示年*/
        GUI_General_Digit_Display(Calendar_Sprite, Month, CN_RC_Nb_14_0, 2u, 0u, GUI_DISP_Month, 48, GUI_BLENDMODE_SRC_OVER); /*显示月*/
        GUI_General_Digit_Display(Calendar_Sprite, Date, CN_RC_Nb_14_0, 2u, 0u, GUI_DISP_Date, 48, GUI_BLENDMODE_SRC_OVER);   /*显示日*/

        GUI_General_Display(Calendar_Sprite, GUIWedk[Week], GUI_BLENDMODE_SRC_OVER); /*星期 */
    }
    else
    {
        GUI_General_Display(Calendar_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*-------------------------------------------------------------------------
 * Function Name  : GUI_TFTTelltales_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_TFTTelltales_Display(uint8_t Mode)
{
    uint32_t Veh_SpeedLim = 0u;
    uint32_t Veh_Speed = 0u;
    uint8_t CanStatus1 = 0u;

    uint8_t CanStatus2 = 0u;
    uint8_t EBSLamp_State = 0u;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        /*超速报警指示灯*/
        Veh_Speed = Common_Get_Disp_V_Speed();
        Veh_Speed = Veh_Speed / 10u;

        Veh_SpeedLim = (uint32_t)Get_ID_18FEED00_Sig_Maximum_Vehicle_Speed_Limit();
        CanStatus1 = CAN_MSG_Status(ID_CanMsg18FEED00_Msg_Count);

        if ((Veh_Speed >= Veh_SpeedLim) && (CanStatus1 != CAN_SIG_LOST))
        {
            GUI_Translate_Display(WarningLight_Sprite, CN_Alarm_01_1, 21u, GUI_DISP_LEMPY[0u], GUI_BLENDMODE_SRC_OVER);
        }

        /*EBS指示灯*/
        EBSLamp_State = Get_ID_18F0010B_Sig_EBS_Red_Warning_Lamp_State();
        CanStatus2 = CAN_MSG_Status(ID_CanMsg18F0010B_Msg_Count);

        if (((EBSLamp_State == 0x01u) || (CanStatus2 == CAN_SIG_LOST)) && (K_Line_Set.K_Line_LID21 == 0x01u))
        {
            GUI_Translate_Display(WarningLight_Sprite, CN_Alarm_02_1, 21u, GUI_DISP_LEMPY[1u], GUI_BLENDMODE_SRC_OVER);
        }
        else
        {
            GUI_General_Display(WarningLight_Sprite, SpriteSize, GUI_BLENDMODE_CUSTOM );
        }
    }
    else
    {
        GUI_General_Display(WarningLight_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*-------------------------------------------------------------------------
 * Function Name  : GUI_WetGas_Dispaly
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_WetGas_Dispaly(uint8_t Mode)
{
    uint8_t current_value = 0u;
    uint8_t current_Flag = 1u; /*有效性*/

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        current_value = GetGaugesCurrentPos(WETGasGauges);
        current_Flag = Common_Get_WET_Valid();  /*有效性判断用*/

        if ((current_value <= 17u) && (current_Flag == 1u))
        {
            switch (current_value)
            {
            case 0x14u: /*20*/
                GUI_Translate_Display(WET_Sprite, CN_qiyazouge_01, (145u + 8u * 0x13), 405u, GUI_BLENDMODE_SRC_OVER);
            case 0x13u:
                GUI_Translate_Display(WET_Sprite, CN_qiyazouge_01, (145u + 8u * 0x12), 405u, GUI_BLENDMODE_SRC_OVER);
            case 0x12u:
                GUI_Translate_Display(WET_Sprite, CN_qiyazouge_01, (145u + 8u * 0x11), 405u, GUI_BLENDMODE_SRC_OVER);
            case 0x11u: /*17*/
                GUI_Translate_Display(WET_Sprite, CN_qiyazouge_01, (145u + 8u * 0x10), 405u, GUI_BLENDMODE_SRC_OVER);
            case 0x10u:
                GUI_Translate_Display(WET_Sprite, CN_qiyazouge_01, (145u + 8u * 0x0F), 405u, GUI_BLENDMODE_SRC_OVER);
            case 0x0Fu:
                GUI_Translate_Display(WET_Sprite, CN_qiyazouge_01, (145u + 8u * 0x0E), 405u, GUI_BLENDMODE_SRC_OVER);
            case 0x0Eu:
                GUI_Translate_Display(WET_Sprite, CN_qiyazouge_01, (145u + 8u * 0x0D), 405u, GUI_BLENDMODE_SRC_OVER);
            case 0x0Du:
                GUI_Translate_Display(WET_Sprite, CN_qiyazouge_01, (145u + 8u * 0x0C), 405u, GUI_BLENDMODE_SRC_OVER);
            case 0x0Cu:
                GUI_Translate_Display(WET_Sprite, CN_qiyazouge_01, (145u + 8u * 0x0B), 405u, GUI_BLENDMODE_SRC_OVER);
            case 0x0Bu:
                GUI_Translate_Display(WET_Sprite, CN_qiyazouge_01, (145u + 8u * 0x0A), 405u, GUI_BLENDMODE_SRC_OVER);
            case 0x0Au:
                GUI_Translate_Display(WET_Sprite, CN_qiyazouge_01, (145u + 8u * 0x09), 405u, GUI_BLENDMODE_SRC_OVER);
            case 0x09u:
                GUI_Translate_Display(WET_Sprite, CN_qiyazouge_01, (145u + 8u * 0x08), 405u, GUI_BLENDMODE_SRC_OVER);
            case 0x08u:
                GUI_Translate_Display(WET_Sprite, CN_qiyazouge_01, (145u + 8u * 0x07), 405u, GUI_BLENDMODE_SRC_OVER);
            case 0x07u:
                GUI_Translate_Display(WET_Sprite, CN_qiyazouge_01, (145u + 8u * 0x06), 405u, GUI_BLENDMODE_SRC_OVER);
            case 0x06u:
                GUI_Translate_Display(WET_Sprite, CN_qiyazouge_01, (145u + 8u * 0x05), 405u, GUI_BLENDMODE_SRC_OVER);
            case 0x05u:
                GUI_Translate_Display(WET_Sprite, CN_qiyazouge_01, (145u + 8u * 0x04), 405u, GUI_BLENDMODE_SRC_OVER);
            case 0x04u:
                GUI_Translate_Display(WET_Sprite, CN_qiyazouge_01, (145u + 8u * 0x03), 405u, GUI_BLENDMODE_SRC_OVER);
            case 0x03u:
                GUI_Translate_Display(WET_Sprite, CN_qiyazouge_01, (145u + 8u * 0x02), 405u, GUI_BLENDMODE_SRC_OVER);
            case 0x02u:
                GUI_Translate_Display(WET_Sprite, CN_qiyazouge_01, (145u + 8u * 0x01), 405u, GUI_BLENDMODE_SRC_OVER);
            case 0x01u:
                GUI_Translate_Display(WET_Sprite, CN_qiyazouge_01, (145u + 8u * 0x00), 405u, GUI_BLENDMODE_SRC_OVER);
                break;
            default:
                GUI_General_Display(WET_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
                break;
            }

            GUI_General_Display(WET_Sprite, CN_qiyafuhaodeng, GUI_BLENDMODE_SRC_OVER); /*气压符号灯。*/
            GUI_General_Display(WET_Sprite, CN_qiya, GUI_BLENDMODE_SRC_OVER); /*刷长条的气压表框。*/
        }
        else
        {
            GUI_General_Display(WET_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
        }

    }
    else
    {
        GUI_General_Display(WET_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_AdBlue_Dispaly
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_AdBlue_Dispaly(uint8_t Mode)
{
    uint8_t Tank_value = 0u;
    uint8_t CanStatus = 0u;
    uint8_t Level_blinking = 0u;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        if ((K_Line_Set.K_Line_LID33 == 1u) || (K_Line_Set.K_Line_LID33 == 3u))
        {
            CanStatus = CAN_MSG_Status(ID_CanMsg18FF2300_Msg_Count);

            if (CanStatus == CAN_SIG_LOST)
            {
                GUI_General_Display(AdBlue_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
            }
            else
            {
                /*指示灯*/
                Level_blinking = Get_ID_18FF2300_Sig_Level_blinking();

                if ((Level_blinking == 0xFFu) || (Level_blinking == 0x00u))
                {
                    GUI_General_Display(AdBlue_Sprite, CN_tianlanyefuhaodeng, GUI_BLENDMODE_SRC_OVER); /*AdBlue*/
                }
                else if (Level_blinking == 0x03u)
                {
                    if (FLASH_SYNC_2_5_Hz == 1u)
                    {
                        GUI_General_Display(AdBlue_Sprite, CN_tianlanyefuhaodeng, GUI_BLENDMODE_SRC_OVER); /*AdBlue*/
                    }
                    else
                    {
                        GUI_General_Display(AdBlue_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
                    }
                }
                else if (Level_blinking == 0x01u)
                {
                    if (FLASH_SYNC_1Hz == 1u)
                    {
                        GUI_General_Display(AdBlue_Sprite, CN_tianlanyefuhaodeng, GUI_BLENDMODE_SRC_OVER); /*AdBlue*/
                    }
                    else
                    {
                        GUI_General_Display(AdBlue_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
                    }
                }
            }

            /*段*/
            Tank_value = Get_ID_18FF2300_Sig_Tank_Level();

            switch (Tank_value)
            {
            case 0x3Cu:
                GUI_Translate_Display(AdBlue_Sprite, CN_tianlanyezouge_01, (152u + 31u * 0x04u), 450u, GUI_BLENDMODE_SRC_OVER);

            case 0x1Cu:
                GUI_Translate_Display(AdBlue_Sprite, CN_tianlanyezouge_01, (152u + 31u * 0x03u), 450u, GUI_BLENDMODE_SRC_OVER);

            case 0x0Cu:
                GUI_Translate_Display(AdBlue_Sprite, CN_tianlanyezouge_01, (152u + 31u * 0x02u), 450u, GUI_BLENDMODE_SRC_OVER);

            case 0x04u:
                GUI_Translate_Display(AdBlue_Sprite, CN_tianlanyezouge_01, (152u + 31u * 0x01u), 450u, GUI_BLENDMODE_SRC_OVER);

            case 0x02u:
                GUI_General_Display(AdBlue_Sprite, CN_tianlanye, GUI_BLENDMODE_SRC_OVER); /*框*/
                GUI_Translate_Display(AdBlue_Sprite, CN_tianlanyezouge_01, (152u + 31u * 0x00u), 450u, GUI_BLENDMODE_SRC_OVER);
                break;

            case 0x01u:
                GUI_General_Display(AdBlue_Sprite, CN_tianlanye, GUI_BLENDMODE_SRC_OVER); /*框*/
                GUI_General_Display(AdBlue_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
                break;

            default:
                GUI_General_Display(AdBlue_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
                break;
            }
        }
        else
        {
            GUI_General_Display(AdBlue_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
        }
    }
    else
    {
        GUI_General_Display(AdBlue_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : Gui_TRIPA_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void Gui_TRIPA_Display(uint8_t Mode)
{
    uint32_t TRIPA_value = 0u;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        TRIPA_value = Data_Read_Trip(EM_TRIP_A); /*此处TRIPA_value的值应为仪表显示的值的10倍。*/

        GUI_General_Display(TRIP_Sprite, CN_TRIP, GUI_BLENDMODE_SRC_OVER);   /*显示文字 “ TRIP ”*/
        GUI_General_Display(TRIP_Sprite, CN_TRIP_A, GUI_BLENDMODE_SRC_OVER); /*显示文字 “ A ”*/

        GUI_Translate_Display(TRIP_Sprite, Nb_19_dian, 668u, 410u, GUI_BLENDMODE_SRC_OVER); /*显示 小数点*/

        /*显示 TRIP A 的数值*/
        GUI_General_Digit_Display(TRIP_Sprite, TRIPA_value, CN_RC_Nb_19_0, 7u, 5u, GUI_DISP_TRIPA, 389, GUI_BLENDMODE_SRC_OVER);

        GUI_Translate_Display(TRIP_Sprite, CN_ODO_danwei, 699u, 400u, GUI_BLENDMODE_SRC_OVER); /*显示文字 “ km ”*/
    }
    else
    {
        GUI_General_Display(TRIP_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

void Gui_TRIPB_Display(uint8_t Mode)
{
    uint32_t TRIPB_value = 0u;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        TRIPB_value = Data_Read_Trip(EM_TRIP_B); /*此处TRIPA_value的值应为仪表显示的值的10倍。*/

        GUI_General_Display(TRIP_Sprite, CN_TRIP, GUI_BLENDMODE_SRC_OVER);   /*显示文字 “ TRIP ”*/
        GUI_General_Display(TRIP_Sprite, CN_TRIP_B, GUI_BLENDMODE_SRC_OVER); /*显示文字 “ B ”*/

        GUI_Translate_Display(TRIP_Sprite, Nb_19_dian, 668u, 410u, GUI_BLENDMODE_SRC_OVER); /*显示 小数点*/

        /*显示 TRIP B 的数值*/
        GUI_General_Digit_Display(TRIP_Sprite, TRIPB_value, CN_RC_Nb_19_0, 7u, 5u, GUI_DISP_TRIPA, 389, GUI_BLENDMODE_SRC_OVER);

        GUI_Translate_Display(TRIP_Sprite, CN_ODO_danwei, 699u, 400u, GUI_BLENDMODE_SRC_OVER); /*显示文字 “ km ”*/
    }
    else
    {
        GUI_General_Display(TRIP_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : Gui_ODO_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void Gui_ODO_Display(uint8_t Mode)
{
    uint32_t ODO_value = 0u;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        ODO_value = (Data_ODO_Read() / 10u); /*此处需将ODO函数返回值赋给变量，ODO函数在其他文件中实现。*/

        GUI_General_Display(ODO_Sprite, CN_ODO, GUI_BLENDMODE_SRC_OVER);                                              /*显示文/*字 “ ODO ”*/
        GUI_Translate_Display(ODO_Sprite, CN_ODO_danwei, 699u, 436u, GUI_BLENDMODE_SRC_OVER);                         /*显示文字 “ km ”*/
        GUI_General_Digit_Display(ODO_Sprite, ODO_value, CN_RC_Nb_19_0, 7u, 6u, GUI_DISP_ODO, 425u, GUI_BLENDMODE_SRC_OVER); /*显示ODO的数值*/
    }
    else
    {
        GUI_General_Display(ODO_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : Gui_ADAS_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void Gui_ADAS_Display(uint8_t Mode)
{
    uint8_t ADAS_Value = 0u;

    uint8_t CanStatusA1 = 0u;
    uint8_t CanStatus2A = 0u;
    uint8_t CanStatusA0 = 0u;

    uint8_t Sys_Sta_A1 = 0u;
    uint8_t Sys_Sta_2A = 0u;
    uint8_t Sys_Sta_A0 = 0u;

    uint8_t AEBS_Sta_A1 = 0u;
    uint8_t AEBS_Sta_2A = 0u;
    uint8_t AEBS_Sta_A0 = 0u;

    uint8_t LDW_Sys_Sta = 0u;

    uint8_t RLDW_Sta = 0u;
    uint8_t LLDW_Sta = 0u;

    uint8_t RLDI_Sta = 0u;
    uint8_t LLDI_Sta = 0u;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        if (K_Line_Set.K_Line_LID28 == 0x01)
        {
            CanStatusA1 = CAN_MSG_Status(ID_CanMsg0CF02FA1_Msg_Count);
            CanStatus2A = CAN_MSG_Status(ID_CanMsg0CF02F2A_Msg_Count);
            CanStatusA0 = CAN_MSG_Status(ID_CanMsg0CF02FA0_Msg_Count);

            if ((CanStatusA1 == CAN_SIG_LOST) && (CanStatus2A == CAN_SIG_LOST) && (CanStatusA0 == CAN_SIG_LOST))
            {
                GUI_General_Display(ADAS_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
            }
            else
            {
                Sys_Sta_A1 = Get_ID_CF02FA1_Sig_Advanced_Emerg_Braking_Sys_Sta();
                Sys_Sta_2A = Get_ID_CF02F2A_Sig_Advanced_Emerg_Braking_Sys_Sta();
                Sys_Sta_A0 = Get_ID_CF02FA0_Sig_Advanced_Emerg_Braking_Sys_Sta();

                AEBS_Sta_A1 = Get_ID_CF02FA1_Sig_Relevant_objected_for_AEBS();
                AEBS_Sta_2A = Get_ID_CF02F2A_Sig_Relevant_objected_for_AEBS();
                AEBS_Sta_A0 = Get_ID_CF02FA0_Sig_Relevant_objected_for_AEBS();

                /*刷文字“ADAS”：*/
                GUI_General_Display(ADAS_Sprite, CN_ADAS_wenzi, GUI_BLENDMODE_SRC_OVER);
                /*刷4个绿色的边框框角：*/
                GUI_General_Display(ADAS_Sprite, CN_jiao1, GUI_BLENDMODE_SRC_OVER);
                GUI_General_Display(ADAS_Sprite, CN_jiao2, GUI_BLENDMODE_SRC_OVER);
                GUI_General_Display(ADAS_Sprite, CN_jiao3, GUI_BLENDMODE_SRC_OVER);
                GUI_General_Display(ADAS_Sprite, CN_jiao4, GUI_BLENDMODE_SRC_OVER);

                if ((((Sys_Sta_A1 == 0u) || (Sys_Sta_A1 == 4u)) && (CanStatusA1 == CAN_SIG_NORMAL)) ||
                        (((Sys_Sta_2A == 0u) || (Sys_Sta_2A == 4u)) && (CanStatus2A == CAN_SIG_NORMAL)) ||
                        (((Sys_Sta_A0 == 0u) || (Sys_Sta_A0 == 4u)) && (CanStatusA0 == CAN_SIG_NORMAL)))
                {
                    if (FLASH_SYNC_1Hz)
                    {
                        /*车*/
                        GUI_General_Display(ADAS_Sprite, CN_che_yinying_1, GUI_BLENDMODE_CUSTOM);
                        /*道*/
                        GUI_General_Display(ADAS_Sprite, CN_Road1_yinying_1, GUI_BLENDMODE_SRC_OVER);
                        GUI_General_Display(ADAS_Sprite, CN_Road2_yinying_1, GUI_BLENDMODE_SRC_OVER);
                        GUI_General_Display(ADAS_Sprite, CN_Road3_yinying_1, GUI_BLENDMODE_SRC_OVER);
                    }
                    else
                    {
                        GUI_General_Display(ADAS_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
                    }
                }
                else if (((Sys_Sta_A1 == 3u) && ((AEBS_Sta_A1 == 0u) || (AEBS_Sta_A1 == 2u))) ||
                         ((Sys_Sta_2A == 3u) && ((AEBS_Sta_2A == 0u) || (AEBS_Sta_2A == 2u))) ||
                         ((Sys_Sta_A0 == 3u) && ((AEBS_Sta_A0 == 0u) || (AEBS_Sta_A0 == 2u))))
                {
                    /*车*/
                    GUI_General_Display(ADAS_Sprite, CN_che_yinying_1, GUI_BLENDMODE_CUSTOM);

                    /*道*/
                    ADAS_Value = 3u;
                    switch (ADAS_Value)
                    {
                    case 3u:
                        GUI_General_Display(ADAS_Sprite, CN_Road1, GUI_BLENDMODE_SRC_OVER);
                    case 2u:
                        GUI_General_Display(ADAS_Sprite, CN_Road2, GUI_BLENDMODE_SRC_OVER);
                    case 1u:
                        GUI_General_Display(ADAS_Sprite, CN_Road3, GUI_BLENDMODE_SRC_OVER);
                        break;
                    default:
                        GUI_General_Display(ADAS_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
                        break;
                    }
                }
                else if (((Sys_Sta_A1 == 3u) && (AEBS_Sta_A1 == 1u)) ||
                         ((Sys_Sta_2A == 3u) && (AEBS_Sta_2A == 1u)) ||
                         ((Sys_Sta_A0 == 3u) && (AEBS_Sta_A0 == 1u)))
                {
                    /*车*/
                    GUI_General_Display(ADAS_Sprite, CN_che, GUI_BLENDMODE_CUSTOM);

                    /*道*/
                    ADAS_Value = 3u;
                    switch (ADAS_Value)
                    {
                    case 3u:
                        GUI_General_Display(ADAS_Sprite, CN_Road1, GUI_BLENDMODE_SRC_OVER);
                    case 2u:
                        GUI_General_Display(ADAS_Sprite, CN_Road2, GUI_BLENDMODE_SRC_OVER);
                    case 1u:
                        GUI_General_Display(ADAS_Sprite, CN_Road3, GUI_BLENDMODE_SRC_OVER);
                        break;
                    default:
                        GUI_General_Display(ADAS_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
                        break;
                    }
                }
                else
                {
                    GUI_General_Display(ADAS_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
                }
            }
        }
        else
        {
            GUI_General_Display(ADAS_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
        }

        if (K_Line_Set.K_Line_LID27 == 0x01u)
        {
            LDW_Sys_Sta = Get_ID_18FE5BE8_Sig_Lane_Departure_Warning_Sys_Sta();

            RLDW_Sta = Get_ID_18FE5BE8_Sig_Lane_Tracking_Status_Right_Side();
            LLDW_Sta = Get_ID_18FE5BE8_Sig_Lane_Tracking_Status_Left_Side();

            LLDI_Sta = Get_ID_10F007E8_Sig_Lane_Departure_Imminent_Left();
            RLDI_Sta = Get_ID_10F007E8_Sig_Lane_Departure_Imminent_Right();

            if (LDW_Sys_Sta == 0u)
            {
                /*左车道线*/
                if (FLASH_SYNC_1Hz == 1u)
                {
                    GUI_General_Display(ADAS_Sprite, CN_LeftRoad_yinying_1, GUI_BLENDMODE_CUSTOM); /*虚*/
                }
                else
                {
                    GUI_General_Display(ADAS_Sprite, SpriteSize, GUI_BLENDMODE_CUSTOM);
                }

                /*右车道线*/
                if (FLASH_SYNC_1Hz == 1u)
                {
                    GUI_General_Display(ADAS_Sprite, CN_RightRoad_yiying_1, GUI_BLENDMODE_CUSTOM); /*虚*/
                }
                else
                {
                    GUI_General_Display(ADAS_Sprite, SpriteSize, GUI_BLENDMODE_CUSTOM);
                }
            }
            else
            {
                /*左车道线*/
                if ((LDW_Sys_Sta == 3u) && (LLDW_Sta == 0u))
                {
                    GUI_General_Display(ADAS_Sprite, CN_LeftRoad_yinying_1, GUI_BLENDMODE_CUSTOM); /*虚*/
                }
                else if ((LDW_Sys_Sta == 3u) && (LLDW_Sta == 1u))
                {
                    GUI_General_Display(ADAS_Sprite, CN_LeftRoad, GUI_BLENDMODE_CUSTOM); /*绿*/
                }
                else if ((LDW_Sys_Sta == 5u) && (LLDI_Sta == 1u))
                {
                    GUI_General_Display(ADAS_Sprite, CN_LeftRoad_1, GUI_BLENDMODE_CUSTOM); /*黄*/

                    if (FLASH_SYNC_2_5_Hz == 1u)
                    {
                        GUI_Translate_Display(ADAS_Sprite, CN_tanhao1, 125u, 257u, GUI_BLENDMODE_CUSTOM); /*左叹号*/
                    }
                    else
                    {
                        GUI_General_Display(ADAS_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
                    }
                }
                else
                {
                    GUI_General_Display(ADAS_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
                }

                /*右车道线*/
                if ((LDW_Sys_Sta == 3u) && (RLDW_Sta == 0u))
                {
                    GUI_General_Display(ADAS_Sprite, CN_RightRoad_yiying_1, GUI_BLENDMODE_CUSTOM); /*虚*/
                }
                else if ((LDW_Sys_Sta == 3u) && (RLDW_Sta == 1u))
                {
                    GUI_General_Display(ADAS_Sprite, CN_RightRoad, GUI_BLENDMODE_CUSTOM); /*绿*/
                }
                else if ((LDW_Sys_Sta == 5u) && (RLDI_Sta == 1u))
                {
                    GUI_General_Display(ADAS_Sprite, CN_RightRoad_1, GUI_BLENDMODE_CUSTOM); /*黄*/

                    if (FLASH_SYNC_2_5_Hz == 1u)
                    {
                        GUI_Translate_Display(ADAS_Sprite, CN_tanhao1, 339u, 257u, GUI_BLENDMODE_CUSTOM); /*右叹号*/
                    }
                    else
                    {
                        GUI_General_Display(ADAS_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
                    }
                }
                else
                {
                    GUI_General_Display(ADAS_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
                }
            }
        }
        else
        {
            GUI_General_Display(ADAS_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
        }
    }
    else
    {
        GUI_General_Display(ADAS_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : Gui_ADAS_Test_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域 4
 --------------------------------------------------------------------------*/
void  Gui_ADAS_Test_Display(uint8_t Mode)
{
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        /*刷文字“ADAS”：*/
        GUI_General_Display(ADAS_Sprite, CN_ADAS_wenzi, GUI_BLENDMODE_SRC_OVER);
        /*刷4个绿色的边框框角：*/
        GUI_General_Display(ADAS_Sprite, CN_jiao1, GUI_BLENDMODE_SRC_OVER);
        GUI_General_Display(ADAS_Sprite, CN_jiao2, GUI_BLENDMODE_SRC_OVER);
        GUI_General_Display(ADAS_Sprite, CN_jiao3, GUI_BLENDMODE_SRC_OVER);
        GUI_General_Display(ADAS_Sprite, CN_jiao4, GUI_BLENDMODE_SRC_OVER);
        /*车*/
        GUI_General_Display(ADAS_Sprite, CN_che, GUI_BLENDMODE_CUSTOM);
        /*道*/
        GUI_General_Display(ADAS_Sprite, CN_Road1, GUI_BLENDMODE_SRC_OVER);
        GUI_General_Display(ADAS_Sprite, CN_Road2, GUI_BLENDMODE_SRC_OVER);
        GUI_General_Display(ADAS_Sprite, CN_Road3, GUI_BLENDMODE_SRC_OVER);

        GUI_General_Display(ADAS_Sprite, CN_LeftRoad, GUI_BLENDMODE_CUSTOM); /*绿*/
        GUI_General_Display(ADAS_Sprite, CN_RightRoad, GUI_BLENDMODE_CUSTOM); /*绿*/

        GUI_Translate_Display(ADAS_Sprite, CN_tanhao1, 125u, 257u, GUI_BLENDMODE_CUSTOM); /*左叹号*/
        GUI_Translate_Display(ADAS_Sprite, CN_tanhao1, 339u, 257u, GUI_BLENDMODE_CUSTOM); /*右叹号*/
    }
    else
    {
        GUI_General_Display(ADAS_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : Gui_DrivingSupport_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void Gui_DrivingSupport_Display(uint8_t Mode)
{
    uint8_t VariableSLD_Disp = 0u;
    uint8_t VariableSLD_Status = 0u;
    uint8_t Var_SpeedValue = 0u;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        /*定速巡航图标*/
        VariableSLD_Status = Get_ID_18FF4100_Sig_Cruise_VariableSLD_Cont_Staus(); /*3-5*/
        VariableSLD_Disp = Get_ID_18FF4100_Sig_Cruise_VariableSLD_Disp();         /*6-8*/

        if ((VariableSLD_Disp == 1u) && (K_Line_Set.K_Line_LID29 == 0x01))
        {
            if (VariableSLD_Status == 0u)
            {
                GUI_General_Display(Cruise_Sprite, CN_dingsuxunhang, GUI_BLENDMODE_SRC_OVER);
            }
            else if (VariableSLD_Status == 2u)
            {
                GUI_General_Display(Cruise_Sprite, CN_dingsuxunhang, GUI_BLENDMODE_SRC_OVER);
                GUI_General_Display(Cruise_Sprite, CN_dingsuxunhang_SET, GUI_BLENDMODE_SRC_OVER);
            }
            else if (VariableSLD_Status == 3u)
            {
                if (FLASH_SYNC_1Hz)
                {
                    GUI_General_Display(Cruise_Sprite, CN_dingsuxunhang_SET, GUI_BLENDMODE_SRC_OVER);
                }
                else
                {
                    GUI_General_Display(Cruise_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
                }

                GUI_General_Display(Cruise_Sprite, CN_dingsuxunhang, GUI_BLENDMODE_SRC_OVER);
            }
            else
            {
                GUI_General_Display(Cruise_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
            }
        }
        else if ((VariableSLD_Disp == 3u) && (K_Line_Set.K_Line_LID29 == 0x01) && (K_Line_Set.K_Line_LID39 == 0x01))
        {
            if (VariableSLD_Status == 0u)
            {
                GUI_General_Display(Cruise_Sprite, CN_dingsuxunhang_1, GUI_BLENDMODE_SRC_OVER);
            }
            else if (VariableSLD_Status == 1u)
            {
                GUI_General_Display(Cruise_Sprite, CN_dingsuxunhang_1, GUI_BLENDMODE_SRC_OVER);
                GUI_General_Display(Cruise_Sprite, CN_dingsuxunhang_STANDBY, GUI_BLENDMODE_SRC_OVER);
            }
            else if (VariableSLD_Status == 2u)
            {
                GUI_General_Display(Cruise_Sprite, CN_dingsuxunhang_1, GUI_BLENDMODE_SRC_OVER);
                GUI_General_Display(Cruise_Sprite, CN_dingsuxunhang_SET, GUI_BLENDMODE_SRC_OVER);
            }
            else if (VariableSLD_Status == 3u)
            {
                if (FLASH_SYNC_1Hz)
                {
                    GUI_General_Display(Cruise_Sprite, CN_dingsuxunhang_SET, GUI_BLENDMODE_SRC_OVER);
                }
                else
                {
                    GUI_General_Display(Cruise_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
                }

                GUI_General_Display(Cruise_Sprite, CN_dingsuxunhang_1, GUI_BLENDMODE_SRC_OVER);
            }
            else
            {
                GUI_General_Display(Cruise_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
            }
        }
        else
        {
            GUI_General_Display(Cruise_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
        }

        /*显示km/h，显示设定车速:*/
        Var_SpeedValue = Get_ID_18FF4100_Sig_Indicate_Lamp_Speed();

        if ((K_Line_Set.K_Line_LID29 == 0x01) || (K_Line_Set.K_Line_LID39 == 0x01))
        {
            if (Var_SpeedValue == 0u)
            {
                GUI_Translate_Display(Cruise_Sprite, Nb_21_hengxian, 429u, 104u, GUI_BLENDMODE_SRC_OVER);
                GUI_Translate_Display(Cruise_Sprite, Nb_21_hengxian, 450u, 104u, GUI_BLENDMODE_SRC_OVER);
                GUI_Translate_Display(Cruise_Sprite, Nb_21_hengxian, 471u, 104u, GUI_BLENDMODE_SRC_OVER);

                GUI_General_Display(Cruise_Sprite, CN_dingsuxunhangdanwei, GUI_BLENDMODE_SRC_OVER);
            }
            else if (Var_SpeedValue <= 250u)
            {
                /*显示文字 “ km/h ”*/
                GUI_General_Digit_Display(Cruise_Sprite, Var_SpeedValue, CN_RC_Nb_21_0, 3u, 2u, GUI_DISP_DrivingSupport, 104u, GUI_BLENDMODE_SRC_OVER); /*显示 定速巡航设定车速 的数值*/
                GUI_General_Display(Cruise_Sprite, CN_dingsuxunhangdanwei, GUI_BLENDMODE_SRC_OVER);
            }
            else
            {
                GUI_General_Display(Cruise_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
            }
        }
        else
        {
            GUI_General_Display(Cruise_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
        }
    }
    else
    {
        GUI_General_Display(Cruise_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : Gui_Gear_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void Gui_Gear_Display(uint8_t Mode)
{
    uint8_t Gear_Value = 0u;
    uint8_t Manouvering_Mode = 0u;
    uint8_t Transmission_Sift_Mode = 0u;
    uint8_t Current_Gear = 0u;
    uint8_t Temp = 0u;
    uint8_t Automatic_or_Manual_Mode = 0u;
    uint8_t CanStatus1 = 0u;
    uint8_t CanStatus2 = 0u;
    uint8_t Auto_EcoPow  = 0u;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        /*G1 自动挡 EOL设定为ZF变速器*/
        if (K_Line_Set.K_Line_LID41 == 0x13u)
        {
            Manouvering_Mode = Get_ID_18FF8503_Sig_Manouvering_mode();
            Transmission_Sift_Mode = Get_ID_18FE4A03_Sig_TransmissionSiftMode1_Indicator();
            Current_Gear = Get_ID_18F00503_Sig_Current_Gear();

            Temp = Current_Gear - 0x7Eu;

            CanStatus1 = CAN_MSG_Status(ID_CanMsg18F00503_Msg_Count);

            if (CanStatus1 == CAN_SIG_LOST)
            {
                GUI_General_Display(Gear_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER); /*不显示*/
            }
            else if ((Current_Gear >= 0x7Eu) && (Current_Gear <= 0x89u))
            {
                if ((Current_Gear == 0x7Eu) && (Manouvering_Mode == 0x01u))
                {
                    GUI_General_Display(Gear_Sprite, CN_dangwei_DM, GUI_BLENDMODE_SRC_OVER);
                }
                else
                {
                    GUI_General_Display(Gear_Sprite, GUIGear[Temp], GUI_BLENDMODE_SRC_OVER); /*1-12*/
                }
            }
            else if (Current_Gear == 0x7Bu)
            {
                GUI_General_Display(Gear_Sprite, CN_dangwei_R2, GUI_BLENDMODE_SRC_OVER); /*R2*/
            }
            else if (Current_Gear == 0x7Cu)
            {
                if (Manouvering_Mode == 0x01u)
                {
                    GUI_General_Display(Gear_Sprite, CN_dangwei_RM, GUI_BLENDMODE_SRC_OVER); /*RM*/
                }
                else
                {
                    GUI_General_Display(Gear_Sprite, CN_dangwei_R1, GUI_BLENDMODE_SRC_OVER); /*R1*/
                }
            }
            else if (Current_Gear == 0x7Du)
            {
                if (Transmission_Sift_Mode == 0x01u)
                {
                    GUI_General_Display(Gear_Sprite, CN_dangwei_NE, GUI_BLENDMODE_SRC_OVER); /*NE*/
                }
                else
                {
                    GUI_General_Display(Gear_Sprite, CN_dangwei_N, GUI_BLENDMODE_SRC_OVER); /*N*/
                }
            }
            else
            {
                GUI_General_Display(Gear_Sprite, CN_dangwei_buming, GUI_BLENDMODE_SRC_OVER); /*-*/
            }
        }
        else
        {
            GUI_General_Display(Gear_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER); /*K未配*/
        }

        /*G2*/
        Automatic_or_Manual_Mode = Get_ID_18FF8503_Sig_Automatic_or_Manual_Mode();

        Auto_EcoPow = Get_ID_0C010305_Sig_Auto_EcoPow();
        CanStatus2 = CAN_MSG_Status(ID_CanMsg0C010305_Msg_Count);
        CanStatus1 = CAN_MSG_Status(ID_CanMsg18FF8503_Msg_Count);

        if ((CanStatus1 == CAN_SIG_LOST) && (CanStatus2 == CAN_SIG_LOST))
        {
            GUI_General_Display(Gear_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER); /*不显示*/
        }
        else if ((Automatic_or_Manual_Mode == 0x00u) && (CanStatus1 == CAN_SIG_NORMAL))
        {
            GUI_General_Display(Gear_Sprite, CN_MANUAL, GUI_BLENDMODE_SRC_OVER); /*显示MAUNAL*/
        }
        //else if (Automatic_or_Manual_Mode == 0x01u) && (CanStatus1 == CAN_SIG_NORMAL))
        //{
        //    GUI_General_Display(Gear_Sprite, CN_MANUAL, GUI_BLENDMODE_SRC_OVER); /*显示AUTO 无图*/
        //}
        else if ((Auto_EcoPow == 0x01u) && (CanStatus2 == CAN_SIG_NORMAL))
        {
            GUI_General_Display(Gear_Sprite, CN_A_ECO, GUI_BLENDMODE_SRC_OVER); /*显示A-ECO*/
        }
        else if ((Auto_EcoPow == 0x00u) && (CanStatus2 == CAN_SIG_NORMAL))
        {
            GUI_General_Display(Gear_Sprite, CN_A_POWER, GUI_BLENDMODE_SRC_OVER); /*显示A-POWER*/
        }
        else
        {
            GUI_General_Display(Gear_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER); /*不显示*/
        }
    }
    else
    {
        GUI_General_Display(Gear_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_AVG_FuelSpeed_Display
 * Description    : 平均车速，平局油耗
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_AVG_FuelSpeed_Display(uint8_t Mode)
{
    uint8_t Trip_Type = 0u;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        Trip_Type = User_set_Num.Trip_Type;

        GUI_General_Display(MultiPurpose_Sprite, CN_TRIPAB, GUI_BLENDMODE_SRC_OVER);
        GUI_General_Display(MultiPurpose_Sprite, CN_PJyouhao, GUI_BLENDMODE_SRC_OVER);
        GUI_General_Display(MultiPurpose_Sprite, CN_PJchesu, GUI_BLENDMODE_SRC_OVER);

        switch (Trip_Type)
        {
        case TRAPA:
            GUI_General_Display(MultiPurpose_Sprite, CN_TRIPAB_A, GUI_BLENDMODE_SRC_OVER);

            GUI_Drive_Info_Avg_Speed_Display(TRAPA);
            GUI_Drive_Info_Avg_Fuel_Display(TRAPA);
            break;

        case TRAPB:
            GUI_General_Display(MultiPurpose_Sprite, CN_TRIPAB_B, GUI_BLENDMODE_SRC_OVER);

            GUI_Drive_Info_Avg_Speed_Display(TRAPB);
            GUI_Drive_Info_Avg_Fuel_Display(TRAPB);
            break;

        default:
            break;
        }
    }
    else if (Mode == GUI_DISP_MODE_BLANK)
    {
        ;/*Do Nothing !*/
    }
    else
    {
        GUI_General_Display(MultiPurpose_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_Drive_Info_Avg_Speed_Display
 * Description    : 平均车速
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_Drive_Info_Avg_Speed_Display(uint16_t Speed)
{
    uint8_t CanStatus1 = 0u;
    uint32_t Average_Speed = 0;

    CanStatus1 = CAN_MSG_Status(ID_CanMsg18EF1718_Msg_Count);

    if (CanStatus1 == CAN_SIG_LOST)
    {
        GUI_General_Display(MultiPurpose_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        /*单位切换*/
        if (1u)
        {
            GUI_General_Display(MultiPurpose_Sprite, CN_PJchesu_kmh, GUI_BLENDMODE_SRC_OVER); /*km/H*/
        }
        else
        {
            if (Speed == TRAPB) /*Trip B*/
            {
                GUI_General_Display(MultiPurpose_Sprite, CN_PJchesu_kmh, GUI_BLENDMODE_SRC_OVER); /*MPH*/
            }
            else /*Trip A ODO*/
            {
                GUI_General_Display(MultiPurpose_Sprite, CN_PJchesu_kmh, GUI_BLENDMODE_SRC_OVER); /*MPH*/
            }
        }

        /*单位切换*/
        if (1u)
        {
            if (Speed == TRAPB) /*Trip B*/
            {
                Average_Speed = Common_Data_Get_TripB_Average_Speed();

                if (Average_Speed < 1000u)
                {
                    GUI_General_Digit_Display(MultiPurpose_Sprite, (Average_Speed / 10u), CN_RC_Nb_21_0, 4u, 3u, GUIBGAVGSpeedPosX, 305u, GUI_BLENDMODE_SRC_OVER);
                }
                else
                {
                    GUI_Translate_Display(MultiPurpose_Sprite, Nb_21_hengxian, 667u, 305u, GUI_BLENDMODE_CUSTOM);
                    GUI_Translate_Display(MultiPurpose_Sprite, Nb_21_hengxian, 642u, 305u, GUI_BLENDMODE_CUSTOM);
                }
            }
            else
            {
                Average_Speed = Common_Data_Get_TripA_Average_Speed();

                if (Average_Speed < 1000u)
                {
                    GUI_General_Digit_Display(MultiPurpose_Sprite, (Average_Speed / 10u), CN_RC_Nb_21_0, 4u, 3u, GUIBGAVGSpeedPosX, 305u, GUI_BLENDMODE_SRC_OVER);
                }
                else
                {
                    GUI_Translate_Display(MultiPurpose_Sprite, Nb_21_hengxian, 667u, 305u, GUI_BLENDMODE_CUSTOM);
                    GUI_Translate_Display(MultiPurpose_Sprite, Nb_21_hengxian, 642u, 305u, GUI_BLENDMODE_CUSTOM);
                }
            }
        }
        else
        {
            ;
        }
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_Drive_Info_Avg_Fuel_Display
 * Description    : 平均油耗
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_Drive_Info_Avg_Fuel_Display(uint16_t Fuel)
{
    uint8_t CanStatus1 = 0u;
    uint32_t AVGFuel = 0u;

    CanStatus1 = CAN_MSG_Status(ID_CanMsg18EF1718_Msg_Count);

    if (CanStatus1 == CAN_SIG_LOST)
    {
        GUI_General_Display(MultiPurpose_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        /*单位切换*/
        if (1u)
        {
            GUI_General_Display(MultiPurpose_Sprite, CN_PJyouhao_L100km, GUI_BLENDMODE_SRC_OVER); /*L/km*/
        }
        else
        {
            if (Fuel == TRAPB) /*Trip B*/
            {
                GUI_General_Display(MultiPurpose_Sprite, CN_PJyouhao_L100km, GUI_BLENDMODE_SRC_OVER); /*MPG*/
            }
            else /*Trip A ODO*/
            {
                GUI_General_Display(MultiPurpose_Sprite, CN_PJyouhao_L100km, GUI_BLENDMODE_SRC_OVER); /*L/m*/
            }
        }

        GUI_Translate_Display(MultiPurpose_Sprite, Nb_21_dian, 656u, 285u, GUI_BLENDMODE_CUSTOM); /*top*/

        if (1u)
        {
            if (Fuel == TRAPB) /*Trip B*/
            {
                AVGFuel = Common_Data_Get_TripB_Fuel();

                if (AVGFuel > 1000u)
                {
                    GUI_General_Digit_Display(MultiPurpose_Sprite, (1000000u / AVGFuel), CN_RC_Nb_21_0, 4u, 2u, GUIBGAVGFuelPosX, 262u, GUI_BLENDMODE_SRC_OVER);
                }
                else
                {
                    GUI_Translate_Display(MultiPurpose_Sprite, Nb_21_hengxian, 603u, 262u, GUI_BLENDMODE_CUSTOM);
                    GUI_Translate_Display(MultiPurpose_Sprite, Nb_21_hengxian, 628u, 262u, GUI_BLENDMODE_CUSTOM);
                    GUI_Translate_Display(MultiPurpose_Sprite, Nb_21_hengxian, 667u, 262u, GUI_BLENDMODE_CUSTOM);
                }
            }
            else
            {
                AVGFuel = Common_Data_Get_TripA_Fuel();

                if (AVGFuel > 1000u)
                {
                    GUI_General_Digit_Display(MultiPurpose_Sprite, (1000000u / AVGFuel), CN_RC_Nb_21_0, 4u, 2u, GUIBGAVGFuelPosX, 262u, GUI_BLENDMODE_SRC_OVER);
                }
                else
                {
                    GUI_Translate_Display(MultiPurpose_Sprite, Nb_21_hengxian, 603u, 262u, GUI_BLENDMODE_CUSTOM);
                    GUI_Translate_Display(MultiPurpose_Sprite, Nb_21_hengxian, 628u, 262u, GUI_BLENDMODE_CUSTOM);
                    GUI_Translate_Display(MultiPurpose_Sprite, Nb_21_hengxian, 667u, 262u, GUI_BLENDMODE_CUSTOM);
                }
            }
        }
        else
        {
            if (Fuel == TRAPB) /*Trip B   系数1.069*/
            {
                AVGFuel = Common_Data_Get_TripB_Fuel();

                if (AVGFuel > 1000u)
                {
                    GUI_General_Digit_Display(MultiPurpose_Sprite, ((1000000u / AVGFuel) * 1069u / 1000u), CN_RC_Nb_21_0, 4u, 2u, GUIBGAVGFuelPosX, 262u, GUI_BLENDMODE_SRC_OVER);
                }
                else
                {
                    GUI_Translate_Display(MultiPurpose_Sprite, Nb_21_hengxian, 603u, 262u, GUI_BLENDMODE_CUSTOM);
                    GUI_Translate_Display(MultiPurpose_Sprite, Nb_21_hengxian, 628u, 262u, GUI_BLENDMODE_CUSTOM);
                    GUI_Translate_Display(MultiPurpose_Sprite, Nb_21_hengxian, 667u, 262u, GUI_BLENDMODE_CUSTOM);
                }
            }
            else /*Trip A ODO */
            {
                AVGFuel = Common_Data_Get_TripA_Fuel();

                if (AVGFuel > 1000u)
                {
                    GUI_General_Digit_Display(MultiPurpose_Sprite, (10u / AVGFuel), CN_RC_Nb_21_0, 4u, 2u, GUIBGAVGFuelPosX, 262u, GUI_BLENDMODE_SRC_OVER);
                }
                else
                {
                    GUI_Translate_Display(MultiPurpose_Sprite, Nb_21_hengxian, 603u, 262u, GUI_BLENDMODE_CUSTOM);
                    GUI_Translate_Display(MultiPurpose_Sprite, Nb_21_hengxian, 628u, 262u, GUI_BLENDMODE_CUSTOM);
                    GUI_Translate_Display(MultiPurpose_Sprite, Nb_21_hengxian, 667u, 262u, GUI_BLENDMODE_CUSTOM);
                }
            }
        }
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_Battery_Display_Display
 * Description    : 电池电量
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_Battery_Display_Display(uint8_t Mode)
{
    uint8_t current_value = 0u;
    uint8_t current_Flag = 0u;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_General_Display(MultiPurpose_Sprite, CN_dianyaji_tubiao, GUI_BLENDMODE_SRC_OVER); /*电池*/
        GUI_General_Display(MultiPurpose_Sprite, CN_dianyaji_kedu, GUI_BLENDMODE_SRC_OVER);   /*标尺*/

        current_value = Gui_Get_Voltmeter_DisplayMode();

        if ((current_value > 4u) && (current_value <= 12u))
        {
            current_Flag = 1u; /*白*/
        }
        else
        {
            current_Flag = 0u;/*红*/
        }

        switch (current_value)
        {
        case 0x0Du:
            if (current_Flag == 1u)
            {
                GUI_Translate_Display(MultiPurpose_Sprite, CN_dianyaji_zouge_white, (536 + 17u * 0x0Cu), 276u, GUI_BLENDMODE_CUSTOM);
            }
            else
            {
                GUI_Translate_Display(MultiPurpose_Sprite, CN_dianyaji_zouge_red, (536 + 17u * 0x0Cu), 276u, GUI_BLENDMODE_CUSTOM);
            }
        case 0x0Cu:
            if (current_Flag == 1u)
            {
                GUI_Translate_Display(MultiPurpose_Sprite, CN_dianyaji_zouge_white, (536 + 17u * 0x0Bu), 276u, GUI_BLENDMODE_CUSTOM);
            }
            else
            {
                GUI_Translate_Display(MultiPurpose_Sprite, CN_dianyaji_zouge_red, (536 + 17u * 0x0Bu), 276u, GUI_BLENDMODE_CUSTOM);
            }
        case 0x0Bu:
            if (current_Flag == 1u)
            {
                GUI_Translate_Display(MultiPurpose_Sprite, CN_dianyaji_zouge_white, (536 + 17u * 0x0Au), 276u, GUI_BLENDMODE_CUSTOM);
            }
            else
            {
                GUI_Translate_Display(MultiPurpose_Sprite, CN_dianyaji_zouge_red, (536 + 17u * 0x0Au), 276u, GUI_BLENDMODE_CUSTOM);
            }
        case 0x0Au:
            if (current_Flag == 1u)
            {
                GUI_Translate_Display(MultiPurpose_Sprite, CN_dianyaji_zouge_white, (536 + 17u * 0x09u), 276u, GUI_BLENDMODE_CUSTOM);
            }
            else
            {
                GUI_Translate_Display(MultiPurpose_Sprite, CN_dianyaji_zouge_red, (536 + 17u * 0x09u), 276u, GUI_BLENDMODE_CUSTOM);
            }
        case 0x09u:
            if (current_Flag == 1u)
            {
                GUI_Translate_Display(MultiPurpose_Sprite, CN_dianyaji_zouge_white, (536 + 17u * 0x08u), 276u, GUI_BLENDMODE_CUSTOM);
            }
            else
            {
                GUI_Translate_Display(MultiPurpose_Sprite, CN_dianyaji_zouge_red, (536 + 17u * 0x08u), 276u, GUI_BLENDMODE_CUSTOM);
            }
        case 0x08u:
            if (current_Flag == 1u)
            {
                GUI_Translate_Display(MultiPurpose_Sprite, CN_dianyaji_zouge_white, (536 + 17u * 0x07u), 276u, GUI_BLENDMODE_CUSTOM);
            }
            else
            {
                GUI_Translate_Display(MultiPurpose_Sprite, CN_dianyaji_zouge_red, (536 + 17u * 0x07u), 276u, GUI_BLENDMODE_CUSTOM);
            }
        case 0x07u:
            if (current_Flag == 1u)
            {
                GUI_Translate_Display(MultiPurpose_Sprite, CN_dianyaji_zouge_white, (536 + 17u * 0x06u), 276u, GUI_BLENDMODE_CUSTOM);
            }
            else
            {
                GUI_Translate_Display(MultiPurpose_Sprite, CN_dianyaji_zouge_red, (536 + 17u * 0x06u), 276u, GUI_BLENDMODE_CUSTOM);
            }
        case 0x06u:
            if (current_Flag == 1u)
            {
                GUI_Translate_Display(MultiPurpose_Sprite, CN_dianyaji_zouge_white, (536 + 17u * 0x05u), 276u, GUI_BLENDMODE_CUSTOM);
            }
            else
            {
                GUI_Translate_Display(MultiPurpose_Sprite, CN_dianyaji_zouge_red, (536 + 17u * 0x05u), 276u, GUI_BLENDMODE_CUSTOM);
            }
        case 0x05u:
            if (current_Flag == 1u)
            {
                GUI_Translate_Display(MultiPurpose_Sprite, CN_dianyaji_zouge_white, (536 + 17u * 0x04u), 276u, GUI_BLENDMODE_CUSTOM);
            }
            else
            {
                GUI_Translate_Display(MultiPurpose_Sprite, CN_dianyaji_zouge_red, (536 + 17u * 0x04u), 276u, GUI_BLENDMODE_CUSTOM);
            }
        case 0x04u:
            if (current_Flag == 1u)
            {
                GUI_Translate_Display(MultiPurpose_Sprite, CN_dianyaji_zouge_white, (536 + 17u * 0x03u), 276u, GUI_BLENDMODE_CUSTOM);
            }
            else
            {
                GUI_Translate_Display(MultiPurpose_Sprite, CN_dianyaji_zouge_red, (536 + 17u * 0x03u), 276u, GUI_BLENDMODE_CUSTOM);
            }
        case 0x03u:
            if (current_Flag == 1u)
            {
                GUI_Translate_Display(MultiPurpose_Sprite, CN_dianyaji_zouge_white, (536 + 17u * 0x02u), 276u, GUI_BLENDMODE_CUSTOM);
            }
            else
            {
                GUI_Translate_Display(MultiPurpose_Sprite, CN_dianyaji_zouge_red, (536 + 17u * 0x02u), 276u, GUI_BLENDMODE_CUSTOM);
            }
        case 0x02u:
            if (current_Flag == 1u)
            {
                GUI_Translate_Display(MultiPurpose_Sprite, CN_dianyaji_zouge_white, (536 + 17u * 0x01u), 276u, GUI_BLENDMODE_CUSTOM);
            }
            else
            {
                GUI_Translate_Display(MultiPurpose_Sprite, CN_dianyaji_zouge_red, (536 + 17u * 0x01u), 276u, GUI_BLENDMODE_CUSTOM);
            }
        case 0x01u:
            if (current_Flag == 1u)
            {
                GUI_Translate_Display(MultiPurpose_Sprite, CN_dianyaji_zouge_white, (536 + 17u * 0x00u), 276u, GUI_BLENDMODE_CUSTOM);
            }
            else
            {
                GUI_Translate_Display(MultiPurpose_Sprite, CN_dianyaji_zouge_red, (536 + 17u * 0x00u), 276u, GUI_BLENDMODE_CUSTOM);
            }
            break;
        default:
            GUI_General_Display(MultiPurpose_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
            break;
        }

        GUI_General_Display(MultiPurpose_Sprite, CN_dianyaji_L, GUI_BLENDMODE_SRC_OVER);      /*L*/
        GUI_General_Display(MultiPurpose_Sprite, CN_dianyaji_H, GUI_BLENDMODE_SRC_OVER);      /*H*/
    }
    else
    {
        GUI_General_Display(MultiPurpose_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_DPD_Display_Display
 * Description    : DPD
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_DPD_Display_Display(uint8_t Mode)
{
    uint16_t value = 0u;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        if ((K_Line_Set.K_Line_LID33 == 0x00u) || (K_Line_Set.K_Line_LID33 == 0x01u))
        {
            value = Get_ID_18FED900_Sig_DPF_storage();
            value = value * 20u / 5u;
            // Get_ID_18FED900_Sig_DPF_Regeneration_Status();/*8 4-5*/

            if (value > 1000u)
            {
                if (DPD_Display_Time < 200)
                {
                    DPD_Display_Time ++;
                }
                if (DPD_Display_Time <= 20u)
                {
                    return ;
                }
            }

            if (1)
            {
                GUI_General_Display(MultiPurpose_Sprite, CN_DPD_duijiliang, GUI_BLENDMODE_SRC_OVER); /*DPD堆积绿*/
            }
            else
            {
                GUI_General_Display(MultiPurpose_Sprite, CN_DPD_zaishengjindu, GUI_BLENDMODE_SRC_OVER); /*DPD再生黄*/
            }

            if (value <= 165u)
            {
                DPD_Display_Time = 0;
                GUI_General_Display(MultiPurpose_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
            }
            else if ((value >= 166u) && (value <= 333u))
            {
                DPD_Display_Time = 0;
                GUI_General_Display(MultiPurpose_Sprite, CN_DPD_zouge1, GUI_BLENDMODE_SRC_OVER);
            }
            else if ((value >= 334u) && (value <= 499u))
            {
                DPD_Display_Time = 0;
                GUI_General_Display(MultiPurpose_Sprite, CN_DPD_zouge1, GUI_BLENDMODE_SRC_OVER);
                GUI_General_Display(MultiPurpose_Sprite, CN_DPD_zouge2, GUI_BLENDMODE_SRC_OVER);
            }
            else if ((value >= 500u) && (value <= 666u))
            {
                DPD_Display_Time = 0;
                GUI_General_Display(MultiPurpose_Sprite, CN_DPD_zouge1, GUI_BLENDMODE_SRC_OVER);
                GUI_General_Display(MultiPurpose_Sprite, CN_DPD_zouge2, GUI_BLENDMODE_SRC_OVER);
                GUI_General_Display(MultiPurpose_Sprite, CN_DPD_zouge3, GUI_BLENDMODE_SRC_OVER);
            }
            else if ((value >= 667u) && (value <= 833u))
            {
                DPD_Display_Time = 0;
                GUI_General_Display(MultiPurpose_Sprite, CN_DPD_zouge1, GUI_BLENDMODE_SRC_OVER);
                GUI_General_Display(MultiPurpose_Sprite, CN_DPD_zouge2, GUI_BLENDMODE_SRC_OVER);
                GUI_General_Display(MultiPurpose_Sprite, CN_DPD_zouge3, GUI_BLENDMODE_SRC_OVER);
                GUI_General_Display(MultiPurpose_Sprite, CN_DPD_zouge4, GUI_BLENDMODE_SRC_OVER);
            }
            else if ((value >= 834u) && (value <= 1000u))
            {
                DPD_Display_Time = 0;
                GUI_General_Display(MultiPurpose_Sprite, CN_DPD_zouge1, GUI_BLENDMODE_SRC_OVER);
                GUI_General_Display(MultiPurpose_Sprite, CN_DPD_zouge2, GUI_BLENDMODE_SRC_OVER);
                GUI_General_Display(MultiPurpose_Sprite, CN_DPD_zouge3, GUI_BLENDMODE_SRC_OVER);
                GUI_General_Display(MultiPurpose_Sprite, CN_DPD_zouge4, GUI_BLENDMODE_SRC_OVER);
                GUI_General_Display(MultiPurpose_Sprite, CN_DPD_zouge5, GUI_BLENDMODE_SRC_OVER);
            }
            else
            {
                GUI_General_Display(MultiPurpose_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
            }

            GUI_General_Display(MultiPurpose_Sprite, CN_DPD_L, GUI_BLENDMODE_SRC_OVER); /*L*/
            GUI_General_Display(MultiPurpose_Sprite, CN_DPD_H, GUI_BLENDMODE_SRC_OVER); /*H*/
        }
    }
    else
    {
        GUI_General_Display(MultiPurpose_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_Time_OilTemp_Display
 * Description    : 发动机转速时间-油温
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_Time_OilTemp_Display(uint8_t Mode)
{
    uint32_t Temp = 0;
    uint8_t CanStatus1 = 0u;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        Temp = Get_ID_18FEE518_Sig_Total_Engine_Hours();
        CanStatus1 = CAN_MSG_Status(ID_CanMsg18FEE518_Msg_Count);

        /*时间*/
        GUI_General_Display(MultiPurpose_Sprite, CN_Time_wenzi, GUI_BLENDMODE_SRC_OVER);  /*时间*/
        GUI_General_Display(MultiPurpose_Sprite, CN_Time_danwei, GUI_BLENDMODE_SRC_OVER); /*H*/

        if (CanStatus1 == CAN_SIG_LOST)
        {
            GUI_General_Display(MultiPurpose_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
        }
        else if (Temp <= 0xFAFFFFFF)
        {
            Temp = Temp / 20u;

            if (Temp >= 9999999)
            {
                GUI_General_Digit_Display(MultiPurpose_Sprite, 9999999, Nb_20_0, 7u, 5u, GUI_DISP_OILTEMP, 221u, GUI_BLENDMODE_SRC_OVER); /*显示ODO的数值*/
            }
            else
            {
                GUI_General_Digit_Display(MultiPurpose_Sprite, Temp, Nb_20_0, 7u, 5u, GUI_DISP_OILTEMP, 221u, GUI_BLENDMODE_SRC_OVER); /*显示ODO的数值*/
            }

            GUI_Translate_Display(MultiPurpose_Sprite, Nb_20_dian, 719u, 241u, GUI_BLENDMODE_CUSTOM); /*点*/
        }
        else
        {
            GUI_Translate_Display(MultiPurpose_Sprite, Nb_20_heng, 592u, 232u, GUI_BLENDMODE_CUSTOM);
            GUI_Translate_Display(MultiPurpose_Sprite, Nb_20_heng, 613u, 232u, GUI_BLENDMODE_CUSTOM);
            GUI_Translate_Display(MultiPurpose_Sprite, Nb_20_heng, 634u, 232u, GUI_BLENDMODE_CUSTOM);
            GUI_Translate_Display(MultiPurpose_Sprite, Nb_20_heng, 655u, 232u, GUI_BLENDMODE_CUSTOM);
            GUI_Translate_Display(MultiPurpose_Sprite, Nb_20_heng, 676u, 232u, GUI_BLENDMODE_CUSTOM);
            GUI_Translate_Display(MultiPurpose_Sprite, Nb_20_heng, 697u, 232u, GUI_BLENDMODE_CUSTOM);
            GUI_Translate_Display(MultiPurpose_Sprite, Nb_20_heng, 729u, 232u, GUI_BLENDMODE_CUSTOM);
            GUI_Translate_Display(MultiPurpose_Sprite, Nb_20_dian, 719u, 241u, GUI_BLENDMODE_CUSTOM); /*点*/
        }
    }
    else
    {
        GUI_General_Display(MultiPurpose_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_Time_OilTemp_OFF_Display
 * Description    : OFF-发动机转速时间显示
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_Time_OilTemp_OFF_Display(uint8_t Mode)
{
    uint32_t Temp = 0u;
    uint32_t Get_Menu_Off_Time = 0u;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        Temp = Get_ID_18FEE518_Sig_Total_Engine_Hours();

        Get_Menu_Off_Time = Coom_Get_Menu_Off_Time();

        if ((State_Flag.Menu_Key_Static == 1u) && (Get_Menu_Off_Time < 150000))
        {
            /*时间*/
            GUI_General_Display(MENU_Sprite, CN_Time_wenzi, GUI_BLENDMODE_SRC_OVER);  /*时间*/
            GUI_General_Display(MENU_Sprite, CN_Time_danwei, GUI_BLENDMODE_SRC_OVER); /*H*/

            if (Temp <= 0xFAFFFFFF)
            {
                Temp = Temp / 20u;

                if (Temp >= 9999999)
                {
                    GUI_General_Digit_Display(MENU_Sprite, 9999999, Nb_20_0, 7u, 5u, GUI_DISP_OILTEMP, 221u, GUI_BLENDMODE_SRC_OVER);
                }
                else
                {
                    GUI_General_Digit_Display(MENU_Sprite, Temp, Nb_20_0, 7u, 5u, GUI_DISP_OILTEMP, 221u, GUI_BLENDMODE_SRC_OVER);
                }

                GUI_Translate_Display(MENU_Sprite, Nb_20_dian, 719u, 241u, GUI_BLENDMODE_CUSTOM); /*点*/
            }
            else
            {
                GUI_General_Digit_Display(MENU_Sprite, 9999999, Nb_20_0, 7u, 5u, GUI_DISP_OILTEMP, 221u, GUI_BLENDMODE_SRC_OVER);
                GUI_Translate_Display(MENU_Sprite, Nb_20_dian, 719u, 241u, GUI_BLENDMODE_CUSTOM); /*点*/
            }
        }
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_Test_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_Test_Display(uint8_t Mode)
{
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_General_Display(MENU_Sprite, CN_Menu_HV, GUI_BLENDMODE_SRC_OVER);
        GUI_General_Display(MENU_Sprite, CN_Menu_SV, GUI_BLENDMODE_SRC_OVER);
        GUI_General_Display(MENU_Sprite, CN_Menu_FV, GUI_BLENDMODE_SRC_OVER);

        GUI_Translate_Display(MENU_Sprite, CN_Nb_28_dian, 446u, 137u, GUI_BLENDMODE_CUSTOM); /*点*/
        GUI_Translate_Display(MENU_Sprite, CN_Nb_28_dian, 518u, 137u, GUI_BLENDMODE_CUSTOM); /*点*/
        GUI_Translate_Display(MENU_Sprite, CN_Nb_28_dian, 446u, 200u, GUI_BLENDMODE_CUSTOM); /*点*/
        GUI_Translate_Display(MENU_Sprite, CN_Nb_28_dian, 518u, 200u, GUI_BLENDMODE_CUSTOM); /*点*/
        GUI_Translate_Display(MENU_Sprite, CN_Nb_28_dian, 518u, 264u, GUI_BLENDMODE_CUSTOM); /*点*/

        GUI_General_Digit_Display(MENU_Sprite, SystemSupplierECUHardwareVersionNumberApp, CN_Nb_28_0, 6u, 0u, GUIBGTestPosX, 137u, GUI_BLENDMODE_SRC_OVER);
        GUI_General_Digit_Display(MENU_Sprite, SystemSupplierECUSoftwareInformationApp, CN_Nb_28_0, 6u, 0u, GUIBGTestPosX, 200u, GUI_BLENDMODE_SRC_OVER);
        GUI_General_Digit_Display(MENU_Sprite, systemSupplierECUFlashInformationApp, CN_Nb_28_0, 6u, 2u, GUIBGTestPosX, 264u, GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_Year_Month_Data_Display
 * Description    : 年月日显示
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_Year_Month_Data_Display(uint8_t Mode)
{
    uint8_t Time_Hours = 0u;
    uint8_t Time_Minutes = 0u;
    uint8_t Month = 0u; /*月*/
    uint8_t Date = 0u;  /*日*/
    uint8_t Week = 0u;  /*星期*/
    uint16_t Year = 0u; /*年*/

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        Year = 2000 + Get_RTC_YEAR();
        Month = Get_RTC_MONTH();
        Date = Get_RTC_DATE();
        /*年月日*/
        if (1u)
        {
            GUI_General_Display(MultiPurpose_Sprite, CN_nian, GUI_BLENDMODE_SRC_OVER); /*年*/
            GUI_General_Display(MultiPurpose_Sprite, CN_yue, GUI_BLENDMODE_SRC_OVER);  /*月*/
            GUI_General_Display(MultiPurpose_Sprite, CN_ri, GUI_BLENDMODE_SRC_OVER);   /*日*/

            GUI_General_Digit_Display(MultiPurpose_Sprite, Year, Nb_17_0, 4u, 0u, GUI_DISP_MENUYear, 243u, GUI_BLENDMODE_SRC_OVER);
            GUI_General_Digit_Display(MultiPurpose_Sprite, Month, Nb_17_0, 2u, 1u, GUI_DISP_MENUMonth, 243u, GUI_BLENDMODE_SRC_OVER);
            GUI_General_Digit_Display(MultiPurpose_Sprite, Date, Nb_17_0, 2u, 1u, GUI_DISP_MENUDate, 243u, GUI_BLENDMODE_SRC_OVER);
        }
        /*月日年*/
        else if (0)
        {
            GUI_General_Display(MultiPurpose_Sprite, CN_nian, GUI_BLENDMODE_SRC_OVER); /*年*/
            GUI_General_Display(MultiPurpose_Sprite, CN_yue, GUI_BLENDMODE_SRC_OVER);  /*月*/
            GUI_General_Display(MultiPurpose_Sprite, CN_ri, GUI_BLENDMODE_SRC_OVER);   /*日*/
            GUI_General_Digit_Display(MultiPurpose_Sprite, Year, Nb_17_0, 4u, 1u, GUI_DISP_MENUYear1, 243u, GUI_BLENDMODE_SRC_OVER);
            GUI_General_Digit_Display(MultiPurpose_Sprite, Month, Nb_17_0, 2u, 1u, GUI_DISP_MENUMonth1, 243u, GUI_BLENDMODE_SRC_OVER);
            GUI_General_Digit_Display(MultiPurpose_Sprite, Date, Nb_17_0, 2u, 1u, GUI_DISP_MENUDate1, 243u, GUI_BLENDMODE_SRC_OVER);
        }
        /*日月年*/
        else
        {
            GUI_General_Display(MultiPurpose_Sprite, CN_nian, GUI_BLENDMODE_SRC_OVER); /*年*/
            GUI_General_Display(MultiPurpose_Sprite, CN_yue, GUI_BLENDMODE_SRC_OVER);  /*月*/
            GUI_General_Display(MultiPurpose_Sprite, CN_ri, GUI_BLENDMODE_SRC_OVER);   /*日*/
            GUI_General_Digit_Display(MultiPurpose_Sprite, Year, Nb_17_0, 4u, 1u, GUI_DISP_MENUYear1, 243u, GUI_BLENDMODE_SRC_OVER);
            GUI_General_Digit_Display(MultiPurpose_Sprite, Month, Nb_17_0, 2u, 1u, GUI_DISP_MENUDate1, 243u, GUI_BLENDMODE_SRC_OVER);
            GUI_General_Digit_Display(MultiPurpose_Sprite, Date, Nb_17_0, 2u, 1u, GUI_DISP_MENUMonth1, 243u, GUI_BLENDMODE_SRC_OVER);
        }
        /*星期 */
        Week = Get_RTC_WEEK();
        GUI_General_Display(MultiPurpose_Sprite, CN_kuohao, GUI_BLENDMODE_SRC_OVER); /*括号*/
        GUI_General_Display(MultiPurpose_Sprite, GUIMenuWedk[Week], GUI_BLENDMODE_CUSTOM);

        Time_Hours = Get_RTC_HOUR();
        /*时间*/
        if (0u)
        {
            if (Time_Hours < 12)
            {
                GUI_General_Display(MultiPurpose_Sprite, CN_AM, GUI_BLENDMODE_SRC_OVER); /*AM*/
            }
            else
            {
                GUI_General_Display(MultiPurpose_Sprite, CN_PM, GUI_BLENDMODE_SRC_OVER); /*PM*/
            }

            if (Time_Hours == 0)
            {
                GUI_General_Digit_Display(MultiPurpose_Sprite, (Time_Hours + 12u), Nb_17_0, 2u, 1u, GUI_DISP_MENUHours, 279u, GUI_BLENDMODE_SRC_OVER);
            }
            else if (Time_Hours > 12)
            {
                GUI_General_Digit_Display(MultiPurpose_Sprite, (Time_Hours - 12u), Nb_17_0, 2u, 1u, GUI_DISP_MENUHours, 279u, GUI_BLENDMODE_SRC_OVER); /*PM*/
            }
            else
            {
                GUI_General_Digit_Display(MultiPurpose_Sprite, Time_Hours, Nb_17_0, 2u, 1u, GUI_DISP_MENUHours, 279u, GUI_BLENDMODE_SRC_OVER); /*AM*/
            }
        }
        else
        {
            GUI_General_Digit_Display(MultiPurpose_Sprite, Time_Hours, Nb_17_0, 2u, 0u, GUI_DISP_MENUHours, 279u, GUI_BLENDMODE_SRC_OVER);
        }

        Time_Minutes = Get_RTC_MINUTE();
        GUI_General_Digit_Display(MultiPurpose_Sprite, Time_Minutes, Nb_17_0, 2u, 0u, GUI_DISP_MENUMinutes, 279u, GUI_BLENDMODE_SRC_OVER); /*分钟*/

        GUI_Translate_Display(MultiPurpose_Sprite, Nb_17_maohao, 592u, 282u, GUI_BLENDMODE_CUSTOM); /*冒号*/
    }
    else
    {
        GUI_General_Display(MultiPurpose_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_block_NULL_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_block_NULL_Display(uint8_t Mode)
{
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        // GUI_Translate_Display(MultiPurpose_Sprite, Nb_12_dian, 801u, 481u, GUI_BLENDMODE_CUSTOM);
        GUI_General_Display(MultiPurpose_Sprite, SpriteSize, GUI_BLENDMODE_CUSTOM);
    }
    else
    {
        GUI_General_Display(MultiPurpose_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_AEBS_Test1_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_AEBS_Test1_Display(uint8_t Mode)
{
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_General_Display(MultiPurpose_Sprite, CN_Alarm_01_imageblack, GUI_BLENDMODE_CUSTOM);
        GUI_General_Display(MultiPurpose_Sprite, CN_Alarm_01_wenzi3, GUI_BLENDMODE_CUSTOM);
    }
    else
    {
        GUI_General_Display(MultiPurpose_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_AEBS_Test2_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_AEBS_Test2_Display(uint8_t Mode)
{
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_General_Display(MultiPurpose_Sprite, CN_Alarm_01_imageblack, GUI_BLENDMODE_CUSTOM);
        GUI_General_Display(MultiPurpose_Sprite, CN_Alarm_01_wenzi5, GUI_BLENDMODE_CUSTOM);
    }
    else
    {
        GUI_General_Display(MultiPurpose_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_AEBS_Test3_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_AEBS_Test3_Display(uint8_t Mode)
{
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_General_Display(MultiPurpose_Sprite, CN_Alarm_01_image, GUI_BLENDMODE_CUSTOM);
        GUI_General_Display(MultiPurpose_Sprite, CN_Alarm_01_wenzi4, GUI_BLENDMODE_CUSTOM);
    }
    else
    {
        GUI_General_Display(MultiPurpose_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_Menu_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_Menu_Display(uint8_t Mode)
{
    uint8_t CanStatus1 = 0u;

    //CanStatus1 = CAN_MSG_Status(ID_CanMsg0CF00400_Msg_Count);

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        /*显示*/
        GUI_General_Display(MENU_Sprite, CN_User_Menu1_wenzi, GUI_BLENDMODE_SRC_OVER); /*menu*/
        GUI_General_Display(MENU_Sprite, CN_fengexian, GUI_BLENDMODE_SRC_OVER);        /*line*/
        GUI_General_Display(MENU_Sprite, CN_gundongtiao, GUI_BLENDMODE_SRC_OVER);      /*长度条*/

        if ((bCurMenuIDX >= _MN_DSP_LEVEL2MENU_1) && (bCurMenuIDX <= _MN_DSP_LEVEL2MENU_4))
        {
            if (bCurMenuIDX != _MN_DSP_LEVEL2MENU_1)
            {
                //if (CanStatus1 == CAN_SIG_LOST) /*有故障码*/
                //{
                //    GUI_General_Display(MENU_Sprite, CN_User_Menu1_01white, GUI_BLENDMODE_SRC_OVER);
                //}
                //else
                //{
                //    GUI_General_Display(MENU_Sprite, CN_User_Menu1_01grey, GUI_BLENDMODE_SRC_OVER);
                //}
                GUI_General_Display(MENU_Sprite, CN_User_Menu1_01white, GUI_BLENDMODE_SRC_OVER);
            }
            if (bCurMenuIDX != _MN_DSP_LEVEL2MENU_2)
            {
                GUI_Translate_Display(MENU_Sprite, (CN_User_Menu1_02black + State_Flag.FState_WXTZ), 225u, GUI_DISP_MENU_Y[1u], GUI_BLENDMODE_SRC_OVER);
            }
            if (bCurMenuIDX != _MN_DSP_LEVEL2MENU_3)
            {
                GUI_Translate_Display(MENU_Sprite, (CN_User_Menu1_03black + State_Flag.FState_WXSD), 225u, GUI_DISP_MENU_Y[2u], GUI_BLENDMODE_SRC_OVER);
            }
            if (bCurMenuIDX != _MN_DSP_LEVEL2MENU_4)
            {
                GUI_Translate_Display(MENU_Sprite, (CN_User_Menu1_04black + State_Flag.FState_YHSD), 225u, GUI_DISP_MENU_Y[3u], GUI_BLENDMODE_SRC_OVER);
            }
        }
        else if (bCurMenuIDX == _MN_DSP_LEVEL2MENU_5)
        {
            if (bCurMenuIDX != _MN_DSP_LEVEL2MENU_2)
            {
                GUI_Translate_Display(MENU_Sprite, (CN_User_Menu1_02black + State_Flag.FState_WXTZ), 225u, GUI_DISP_MENU_Y[0u], GUI_BLENDMODE_SRC_OVER);
            }
            if (bCurMenuIDX != _MN_DSP_LEVEL2MENU_3)
            {
                GUI_Translate_Display(MENU_Sprite, (CN_User_Menu1_03black + State_Flag.FState_WXSD), 225u, GUI_DISP_MENU_Y[1u], GUI_BLENDMODE_SRC_OVER);
            }
            if (bCurMenuIDX != _MN_DSP_LEVEL2MENU_4)
            {
                GUI_Translate_Display(MENU_Sprite, (CN_User_Menu1_04black + State_Flag.FState_YHSD), 225u, GUI_DISP_MENU_Y[2u], GUI_BLENDMODE_SRC_OVER);
            }
            if (bCurMenuIDX != _MN_DSP_LEVEL2MENU_5)
            {
                GUI_Translate_Display(MENU_Sprite, (CN_User_Menu1_05black + State_Flag.FState_SYSYS), 225u, GUI_DISP_MENU_Y[3u], GUI_BLENDMODE_SRC_OVER);
            }
        }
        else if (bCurMenuIDX == _MN_DSP_LEVEL2MENU_6)
        {
            if (bCurMenuIDX != _MN_DSP_LEVEL2MENU_3)
            {
                GUI_Translate_Display(MENU_Sprite, (CN_User_Menu1_03black + State_Flag.FState_WXSD), 225u, GUI_DISP_MENU_Y[0u], GUI_BLENDMODE_SRC_OVER);
            }
            if (bCurMenuIDX != _MN_DSP_LEVEL2MENU_4)
            {
                GUI_Translate_Display(MENU_Sprite, (CN_User_Menu1_04black + State_Flag.FState_YHSD), 225u, GUI_DISP_MENU_Y[1u], GUI_BLENDMODE_SRC_OVER);
            }
            if (bCurMenuIDX != _MN_DSP_LEVEL2MENU_5)
            {
                if ((K_Line_Set.K_Line_LID27 != 0x01u) && (K_Line_Set.K_Line_LID28 != 0x01u))
                {
                    GUI_Translate_Display(MENU_Sprite, (CN_User_Menu1_05black + 1u), 225u, GUI_DISP_MENU_Y[2u], GUI_BLENDMODE_SRC_OVER);
                }
                else
                {
                    GUI_Translate_Display(MENU_Sprite, (CN_User_Menu1_05black + State_Flag.FState_SYSYS), 225u, GUI_DISP_MENU_Y[2u], GUI_BLENDMODE_SRC_OVER);
                }
            }
            if (bCurMenuIDX != _MN_DSP_LEVEL2MENU_6)
            {
                GUI_Translate_Display(MENU_Sprite, (CN_User_Menu1_06black + State_Flag.FState_TPMS), 225u, GUI_DISP_MENU_Y[3u], GUI_BLENDMODE_SRC_OVER);
            }
        }
        else
        {
            ;/*Do Nothing!*/
        }
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_Menu1_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_Menu1_Display(uint8_t Mode)
{
    uint8_t Flag = 0;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_Translate_Display(MENU_Sprite, (CN_User_Menu1_01black + Flag), 225u, GUI_DISP_MENU_Y[0u], GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_Menu2_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_Menu2_Display(uint8_t Mode)
{
    uint8_t Flag = 0;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_Translate_Display(MENU_Sprite, (CN_User_Menu1_02black + Flag), 225u, GUI_DISP_MENU_Y[1u], GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_Menu3_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_Menu3_Display(uint8_t Mode)
{
    uint8_t Flag = 0;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_Translate_Display(MENU_Sprite, (CN_User_Menu1_03black + Flag), 225u, GUI_DISP_MENU_Y[2u], GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_Menu4_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_Menu4_Display(uint8_t Mode)
{
    uint8_t Flag = 0;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_Translate_Display(MENU_Sprite, (CN_User_Menu1_04black + Flag), 225u, GUI_DISP_MENU_Y[3u], GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_Menu5_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_Menu5_Display(uint8_t Mode)
{
    uint8_t Flag = 0;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_Translate_Display(MENU_Sprite, (CN_User_Menu1_05black + Flag), 225u, GUI_DISP_MENU_Y[3u], GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_Menu6_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_Menu6_Display(uint8_t Mode)
{
    uint8_t Flag = 0;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_Translate_Display(MENU_Sprite, (CN_User_Menu1_06black + Flag), 225u, GUI_DISP_MENU_Y[3u], GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_Rep_Menu_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_Rep_Menu_Display(uint8_t Mode)
{
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        /*显示*/
        GUI_General_Display(MENU_Sprite, CN_User_Menu2_02_wenzi, GUI_BLENDMODE_SRC_OVER); /*menu*/
        GUI_General_Display(MENU_Sprite, CN_fengexian, GUI_BLENDMODE_SRC_OVER);           /*line*/
        GUI_General_Display(MENU_Sprite, CN_gundongtiao, GUI_BLENDMODE_SRC_OVER);         /*长度条*/

        if (bCurMenuIDX <= _MN_DSP_LEVEL2_2_MENU_4)
        {
            if (bCurMenuIDX != _MN_DSP_LEVEL2_2_MENU_1)
            {
                GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_02_1black + State_Flag.WXTZ_FDJY), 225u, GUI_DISP_MENU_Y[0u], GUI_BLENDMODE_SRC_OVER);
            }
            if (bCurMenuIDX != _MN_DSP_LEVEL2_2_MENU_2)
            {
                GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_02_2black + State_Flag.WXTZ_RYLQY), 225u, GUI_DISP_MENU_Y[1u], GUI_BLENDMODE_SRC_OVER);
            }
            if (bCurMenuIDX != _MN_DSP_LEVEL2_2_MENU_3)
            {
                GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_02_3black + State_Flag.WXTZ_BSXY), 225u, GUI_DISP_MENU_Y[2u], GUI_BLENDMODE_SRC_OVER);
            }
            if (bCurMenuIDX != _MN_DSP_LEVEL2_2_MENU_4)
            {
                GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_02_4black + State_Flag.WXTZ_CSQY), 225u, GUI_DISP_MENU_Y[3u], GUI_BLENDMODE_SRC_OVER);
            }
        }
        else if (bCurMenuIDX == _MN_DSP_LEVEL2_2_MENU_7)
        {
            GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_02_2black + State_Flag.WXTZ_RYLQY), 225u, GUI_DISP_MENU_Y[0u], GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_02_3black + State_Flag.WXTZ_BSXY), 225u, GUI_DISP_MENU_Y[1u], GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_02_4black + State_Flag.WXTZ_CSQY), 225u, GUI_DISP_MENU_Y[2u], GUI_BLENDMODE_SRC_OVER);
        }
        else
        {
            GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_02_3black + State_Flag.WXTZ_CSQY), 225u, GUI_DISP_MENU_Y[0u], GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_02_4black + State_Flag.WXTZ_KQGZJ), 225u, GUI_DISP_MENU_Y[1u], GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_02_6black + State_Flag.WXTZ_DLZXY), 225u, GUI_DISP_MENU_Y[2u], GUI_BLENDMODE_SRC_OVER);
        }
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_RepMenu1_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_RepMenu1_Display(uint8_t Mode)
{
    uint8_t Flag = 0;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_02_1black + Flag), 225u, GUI_DISP_MENU_Y[0u], GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_RepMenu2_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_RepMenu2_Display(uint8_t Mode)
{
    uint8_t Flag = 0;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_02_2black + Flag), 225u, GUI_DISP_MENU_Y[1u], GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_RepMenu3_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_RepMenu3_Display(uint8_t Mode)
{
    uint8_t Flag = 0;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_02_3black + Flag), 225u, GUI_DISP_MENU_Y[2u], GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_RepMenu4_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_RepMenu4_Display(uint8_t Mode)
{
    uint8_t Flag = 0;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_02_4black + Flag), 225u, GUI_DISP_MENU_Y[3u], GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_RepMenu5_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_RepMenu5_Display(uint8_t Mode)
{
    uint8_t Flag = 0;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_RepMenu6_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_RepMenu6_Display(uint8_t Mode)
{
    uint8_t Flag = 0;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_02_5black + Flag), 225u, GUI_DISP_MENU_Y[3u], GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_RepMenu7_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_RepMenu7_Display(uint8_t Mode)
{
    uint8_t Flag = 0;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_02_6black + Flag), 225u, GUI_DISP_MENU_Y[3u], GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_RepMenu8_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_RepMenu8_Display(uint8_t Mode)
{
    uint8_t Flag = 0;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_02_7black + Flag), 225u, GUI_DISP_MENU_Y[3u], GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_RepMenu9_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_RepMenu9_Display(uint8_t Mode)
{
    uint8_t Flag = 0;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_02_8black + Flag), 225u, GUI_DISP_MENU_Y[3u], GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_RepSet_Menu_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_RepSet_Menu_Display(uint8_t Mode)
{
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        /*显示*/
        GUI_General_Display(MENU_Sprite, CN_User_Menu2_03_wenzi, GUI_BLENDMODE_SRC_OVER); /*menu*/
        GUI_General_Display(MENU_Sprite, CN_fengexian, GUI_BLENDMODE_SRC_OVER);           /*line*/
        GUI_General_Display(MENU_Sprite, CN_gundongtiao, GUI_BLENDMODE_SRC_OVER);         /*长度条*/

        if (bCurMenuIDX <= _MN_DSP_LEVEL2_3_MENU_4)
        {
            if (bCurMenuIDX != _MN_DSP_LEVEL2_3_MENU_1)
            {
                GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_03_01black + State_Flag.WXSD_FDJY), 225u, GUI_DISP_MENU_Y[0u], GUI_BLENDMODE_SRC_OVER);
            }
            if (bCurMenuIDX != _MN_DSP_LEVEL2_3_MENU_2)
            {
                GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_03_02black + State_Flag.WXSD_RYLQY), 225u, GUI_DISP_MENU_Y[1u], GUI_BLENDMODE_SRC_OVER);
            }
            if (bCurMenuIDX != _MN_DSP_LEVEL2_3_MENU_3)
            {
                GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_03_03black + State_Flag.WXSD_BSXY), 225u, GUI_DISP_MENU_Y[2u], GUI_BLENDMODE_SRC_OVER);
            }
            if (bCurMenuIDX != _MN_DSP_LEVEL2_3_MENU_4)
            {
                GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_03_04black + State_Flag.WXSD_CSQY), 225u, GUI_DISP_MENU_Y[3u], GUI_BLENDMODE_SRC_OVER);
            }
        }
        else if (bCurMenuIDX == _MN_DSP_LEVEL2_3_MENU_6)
        {
            GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_03_02black + State_Flag.WXSD_RYLQY), 225u, GUI_DISP_MENU_Y[0u], GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_03_03black + State_Flag.WXSD_BSXY), 225u, GUI_DISP_MENU_Y[1u], GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_03_04black + State_Flag.WXSD_CSQY), 225u, GUI_DISP_MENU_Y[2u], GUI_BLENDMODE_SRC_OVER);
        }
        else if (bCurMenuIDX == _MN_DSP_LEVEL2_3_MENU_7)
        {
            GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_03_03black + State_Flag.WXSD_BSXY), 225u, GUI_DISP_MENU_Y[0u], GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_03_04black + State_Flag.WXSD_CSQY), 225u, GUI_DISP_MENU_Y[1u], GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_03_06black + State_Flag.WXSD_DLZXY), 225u, GUI_DISP_MENU_Y[2u], GUI_BLENDMODE_SRC_OVER);
        }
        else
        {
            ;/*Do Nothing*/
        }
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_RepSetMenu1_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_RepSetMenu1_Display(uint8_t Mode)
{
    uint8_t Flag = 0;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_03_01black + Flag), 225u, GUI_DISP_MENU_Y[0u], GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_RepSetMenu2_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_RepSetMenu2_Display(uint8_t Mode)
{
    uint8_t Flag = 0;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_03_02black + Flag), 225u, GUI_DISP_MENU_Y[1u], GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_RepSetMenu3_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_RepSetMenu3_Display(uint8_t Mode)
{
    uint8_t Flag = 0;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_03_03black + Flag), 225u, GUI_DISP_MENU_Y[2u], GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_RepSetMenu4_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_RepSetMenu4_Display(uint8_t Mode)
{
    uint8_t Flag = 0;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_03_04black + Flag), 225u, GUI_DISP_MENU_Y[3u], GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_RepSetMenu5_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_RepSetMenu5_Display(uint8_t Mode)
{
    uint8_t Flag = 0;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_03_04black + Flag), 225u, GUI_DISP_MENU_Y[3u], GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_RepSetMenu6_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_RepSetMenu6_Display(uint8_t Mode)
{
    uint8_t Flag = 0;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_03_06black + Flag), 225u, GUI_DISP_MENU_Y[3u], GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_RepSetMenu7_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_RepSetMenu7_Display(uint8_t Mode)
{
    uint8_t Flag = 0;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_03_07black + Flag), 225u, GUI_DISP_MENU_Y[3u], GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_RepSetMenu8_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_RepSetMenu8_Display(uint8_t Mode)
{
    uint8_t Flag = 0;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_03_08black + Flag), 225u, GUI_DISP_MENU_Y[3u], GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_UserSet_Menu_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_UserSet_Menu_Display(uint8_t Mode)
{
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        /*显示*/
        GUI_General_Display(MENU_Sprite, CN_User_Menu2_04_wenzi, GUI_BLENDMODE_SRC_OVER); /*menu*/
        GUI_General_Display(MENU_Sprite, CN_fengexian, GUI_BLENDMODE_SRC_OVER);           /*line*/
        GUI_General_Display(MENU_Sprite, CN_gundongtiao, GUI_BLENDMODE_SRC_OVER);         /*长度条*/

        if (bCurMenuIDX <= _MN_DSP_LEVEL2_4_MENU_3)
        {
            if (bCurMenuIDX != _MN_DSP_LEVEL2_4_MENU_1)
            {
                GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_04_1black + State_Flag.USER_DATE), 225u, GUI_DISP_MENU_Y[0u], GUI_BLENDMODE_SRC_OVER);
            }
            if (bCurMenuIDX != _MN_DSP_LEVEL2_4_MENU_2)
            {
                GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_04_2black + State_Flag.USER_TIME), 225u, GUI_DISP_MENU_Y[1u], GUI_BLENDMODE_SRC_OVER);
            }
            if (bCurMenuIDX != _MN_DSP_LEVEL2_4_MENU_7)
            {
                GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_04_9black + State_Flag.USER_LIGHT), 225u, GUI_DISP_MENU_Y[2u], GUI_BLENDMODE_SRC_OVER);
            }
            if (bCurMenuIDX != _MN_DSP_LEVEL2_4_MENU_3)
            {
                GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_04_7black + State_Flag.USER_LANGUAGE), 225u, GUI_DISP_MENU_Y[3u], GUI_BLENDMODE_SRC_OVER);
            }
        }
        else if (bCurMenuIDX == _MN_DSP_LEVEL2_4_MENU_4)
        {
            GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_04_2black + State_Flag.USER_TIME), 225u, GUI_DISP_MENU_Y[0u], GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_04_9black + State_Flag.USER_LIGHT), 225u, GUI_DISP_MENU_Y[1u], GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_04_7black + State_Flag.USER_LANGUAGE), 225u, GUI_DISP_MENU_Y[2u], GUI_BLENDMODE_SRC_OVER);
        }
        else if (bCurMenuIDX == _MN_DSP_LEVEL2_4_MENU_5)
        {
            GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_04_9black + State_Flag.USER_LIGHT), 225u, GUI_DISP_MENU_Y[0u], GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_04_7black + State_Flag.USER_LANGUAGE), 225u, GUI_DISP_MENU_Y[1u], GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_04_4black + State_Flag.USER_PROPOSAL), 225u, GUI_DISP_MENU_Y[2u], GUI_BLENDMODE_SRC_OVER);
        }
        else
        {
            GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_04_7black + State_Flag.USER_LANGUAGE), 225u, GUI_DISP_MENU_Y[0u], GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_04_4black + State_Flag.USER_PROPOSAL), 225u, GUI_DISP_MENU_Y[1u], GUI_BLENDMODE_SRC_OVER);
            if (K_Line_Set.K_Line_LID3E != 0x01u)
            {
                GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_04_10black + 1u), 225u, GUI_DISP_MENU_Y[2u], GUI_BLENDMODE_SRC_OVER);
            }
            else
            {
                GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_04_10black + State_Flag.FState_TPMSSET), 225u, GUI_DISP_MENU_Y[2u], GUI_BLENDMODE_SRC_OVER);
            }
        }
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_UserSetMenu1_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_UserSetMenu1_Display(uint8_t Mode)
{
    uint8_t Flag = 0;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_04_1black + Flag), 225u, GUI_DISP_MENU_Y[0u], GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_UserSetMenu2_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_UserSetMenu2_Display(uint8_t Mode)
{
    uint8_t Flag = 0;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_04_2black + Flag), 225u, GUI_DISP_MENU_Y[1u], GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_UserSetMenu3_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_UserSetMenu3_Display(uint8_t Mode)
{
    uint8_t Flag = 0;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_04_7black + Flag), 225u, GUI_DISP_MENU_Y[3u], GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_UserSetMenu8_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_UserSetMenu8_Display(uint8_t Mode)
{
    uint8_t Flag = 0;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_04_9black + Flag), 225u, GUI_DISP_MENU_Y[2u], GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_UserSetMenu4_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_UserSetMenu4_Display(uint8_t Mode)
{
    uint8_t Flag = 0;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_04_4black + Flag), 225u, GUI_DISP_MENU_Y[3u], GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_UserSetMenu5_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_UserSetMenu5_Display(uint8_t Mode)
{
    uint8_t Flag = 0;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_04_10black + Flag), 225u, GUI_DISP_MENU_Y[3u], GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_UserSetMenu6_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_UserSetMenu6_Display(uint8_t Mode)
{
    uint8_t Flag = 0;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_04_3black + Flag), 225u, GUI_DISP_MENU_Y[3u], GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_UserSetMenu7_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_UserSetMenu7_Display(uint8_t Mode)
{
    uint8_t Flag = 0;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_04_7black + Flag), 225u, GUI_DISP_MENU_Y[3u], GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_Demo_Menu_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_Demo_Menu_Display(uint8_t Mode)
{
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        /*显示*/
        GUI_General_Display(MENU_Sprite, CN_User_Menu2_05_wenzi, GUI_BLENDMODE_SRC_OVER); /*menu*/
        GUI_General_Display(MENU_Sprite, CN_fengexian, GUI_BLENDMODE_SRC_OVER);           /*line*/
        GUI_General_Display(MENU_Sprite, CN_gundongtiao, GUI_BLENDMODE_SRC_OVER);         /*长度条*/

        if (bCurMenuIDX != _MN_DSP_LEVEL2_5_MENU_1)
        {
            if (K_Line_Set.K_Line_LID27 == 0x01u)
            {
                GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_05_1black + State_Flag.DEMO_LDWS), 225u, GUI_DISP_MENU_Y[0u], GUI_BLENDMODE_SRC_OVER);
            }
            else
            {
                GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_05_1black + 1u), 225u, GUI_DISP_MENU_Y[0u], GUI_BLENDMODE_SRC_OVER);
            }
        }
        if (bCurMenuIDX != _MN_DSP_LEVEL2_5_MENU_2)
        {
            if (K_Line_Set.K_Line_LID28 == 0x01u)
            {
                GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_05_2black + State_Flag.DEMO_AEBS1), 225u, GUI_DISP_MENU_Y[1u], GUI_BLENDMODE_SRC_OVER);
            }
            else
            {
                GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_05_2black + 1u), 225u, GUI_DISP_MENU_Y[1u], GUI_BLENDMODE_SRC_OVER);
            }
        }
        if (bCurMenuIDX != _MN_DSP_LEVEL2_5_MENU_3)
        {
            if (K_Line_Set.K_Line_LID28 == 0x01u)
            {
                GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_05_3black + State_Flag.DEMO_AEBS2), 225u, GUI_DISP_MENU_Y[2u], GUI_BLENDMODE_SRC_OVER);
            }
            else
            {
                GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_05_3black + 1u), 225u, GUI_DISP_MENU_Y[2u], GUI_BLENDMODE_SRC_OVER);
            }
        }
        if (bCurMenuIDX != _MN_DSP_LEVEL2_5_MENU_4)
        {
            if (K_Line_Set.K_Line_LID28 == 0x01u)
            {
                GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_05_4black + State_Flag.DEMO_AEBS3), 225u, GUI_DISP_MENU_Y[3u], GUI_BLENDMODE_SRC_OVER);
            }
            else
            {
                GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_05_4black + 1u), 225u, GUI_DISP_MENU_Y[3u], GUI_BLENDMODE_SRC_OVER);
            }
        }
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_DemoMenu1_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_DemoMenu1_Display(uint8_t Mode)
{
    uint8_t Flag = 0;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_05_1black + Flag), 225u, GUI_DISP_MENU_Y[0u], GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_DemoMenu2_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_DemoMenu2_Display(uint8_t Mode)
{
    uint8_t Flag = 0;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_05_2black + Flag), 225u, GUI_DISP_MENU_Y[1u], GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_DemoMenu3_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_DemoMenu3_Display(uint8_t Mode)
{
    uint8_t Flag = 0;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_05_3black + Flag), 225u, GUI_DISP_MENU_Y[2u], GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_DemoMenu4_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_DemoMenu4_Display(uint8_t Mode)
{
    uint8_t Flag = 0;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_Translate_Display(MENU_Sprite, (CN_User_Menu2_05_4black + Flag), 225u, GUI_DISP_MENU_Y[3u], GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_DTCReading_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_DTCReading_Display(uint8_t Mode)
{
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        /*显示*/
        GUI_General_Display(MENU_Sprite, CN_User_Menu2_01_wenzi, GUI_BLENDMODE_SRC_OVER); /*menu*/
        GUI_General_Display(MENU_Sprite, CN_fengexian, GUI_BLENDMODE_SRC_OVER);           /*line*/
        GUI_General_Display(MENU_Sprite, CN_gundongtiao, GUI_BLENDMODE_SRC_OVER);         /*长度条*/

        GUI_Translate_Display(MENU_Sprite, CN_User_Menu2_01_1white, 225u, GUI_DISP_MENU_Y[1u], GUI_BLENDMODE_SRC_OVER);/*故障码读取中*/
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_TPMS_GasPIC_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域   K_Line_Set.K_Line_LID3E
 --------------------------------------------------------------------------*/
void GUI_BG_TPMS_GasPIC_Display(uint8_t Mode)
{
    uint8_t User_Tpms12 = 0u;
    uint8_t User_Tpms13 = 0u;
    uint8_t User_Tpms22 = 0u;
    uint8_t User_Tpms23 = 0u;
    uint8_t User_Tpms31 = 0u;
    uint8_t User_Tpms32 = 0u;
    uint8_t User_Tpms33 = 0u;
    uint8_t User_Tpms34 = 0u;
    uint8_t User_Tpms41 = 0u;
    uint8_t User_Tpms42 = 0u;
    uint8_t User_Tpms43 = 0u;
    uint8_t User_Tpms44 = 0u;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        /*低气压-高气压-快速漏气*/
        User_Tpms12 = Get_TPMSPresure_Alarm(FirstLOut);
        User_Tpms13 = Get_TPMSPresure_Alarm(FirstROut);
        User_Tpms22 = Get_TPMSPresure_Alarm(SecondLIn);
        User_Tpms23 = Get_TPMSPresure_Alarm(SecondRIn);
        User_Tpms31 = Get_TPMSPresure_Alarm(ThirdLOut);
        User_Tpms32 = Get_TPMSPresure_Alarm(ThirdLIn);
        User_Tpms33 = Get_TPMSPresure_Alarm(ThirdRIn);
        User_Tpms34 = Get_TPMSPresure_Alarm(ThirdROut);
        User_Tpms41 = Get_TPMSPresure_Alarm(FourthLOut);
        User_Tpms42 = Get_TPMSPresure_Alarm(FourthLIn);
        User_Tpms43 = Get_TPMSPresure_Alarm(FourthRIn);
        User_Tpms44 = Get_TPMSPresure_Alarm(FourthROut);

        /*显示*/
        GUI_General_Display(MENU_Sprite, CN_User_Menu3_04_che, GUI_BLENDMODE_SRC_OVER); /*车*/

        GUI_General_Display(MENU_Sprite, CN_User_Menu3_04_kpa, GUI_BLENDMODE_SRC_OVER);      /*KPA*/
        GUI_General_Display(MENU_Sprite, CN_User_Menu3_04_qiya1, GUI_BLENDMODE_SRC_OVER);    /*气压*/
        GUI_General_Display(MENU_Sprite, CN_User_Menu3_04_wendu2, GUI_BLENDMODE_SRC_OVER);   /*胎温*/
        GUI_General_Display(MENU_Sprite, CN_User_Menu3_04_jiantou1, GUI_BLENDMODE_SRC_OVER); /*箭头*/
        GUI_General_Display(MENU_Sprite, CN_User_Menu3_04_jiantou2, GUI_BLENDMODE_SRC_OVER); /*箭头*/

        /*0x12*/
        if (User_Tpms12 == 1u)
        {
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_04_luntai2, GUI_TPMS_PIC_X[0U], GUI_TPMS_PIC_Y[3u], GUI_BLENDMODE_CUSTOM);
        }
        else
        {
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_04_luntai, GUI_TPMS_PIC_X[0u], GUI_TPMS_PIC_Y[3u], GUI_BLENDMODE_CUSTOM);
        }

        /*0x13*/
        if (User_Tpms13 == 1u)
        {
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_04_luntai2, GUI_TPMS_PIC_X[0u], GUI_TPMS_PIC_Y[0u], GUI_BLENDMODE_CUSTOM);
        }
        else
        {
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_04_luntai, GUI_TPMS_PIC_X[0u], GUI_TPMS_PIC_Y[0u], GUI_BLENDMODE_CUSTOM);
        }

        /*0x22*/
        if (User_Tpms22 == 1u)
        {
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_04_luntai2, GUI_TPMS_PIC_X[1u], GUI_TPMS_PIC_Y[3u], GUI_BLENDMODE_CUSTOM);
        }
        else
        {
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_04_luntai, GUI_TPMS_PIC_X[1u], GUI_TPMS_PIC_Y[3u], GUI_BLENDMODE_CUSTOM);
        }

        /*0x23*/
        if (User_Tpms23 == 1u)
        {
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_04_luntai2, GUI_TPMS_PIC_X[1u], GUI_TPMS_PIC_Y[0u], GUI_BLENDMODE_CUSTOM);
        }
        else
        {
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_04_luntai, GUI_TPMS_PIC_X[1u], GUI_TPMS_PIC_Y[0u], GUI_BLENDMODE_CUSTOM);
        }

        /*0x31*/
        if (User_Tpms31 == 1u)
        {
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_04_luntai2, GUI_TPMS_PIC_X[2U], GUI_TPMS_PIC_Y[3u], GUI_BLENDMODE_CUSTOM);
        }
        else
        {
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_04_luntai, GUI_TPMS_PIC_X[2u], GUI_TPMS_PIC_Y[3u], GUI_BLENDMODE_CUSTOM);
        }

        /*0x32*/
        if (User_Tpms32 == 1u)
        {
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_04_luntai2, GUI_TPMS_PIC_X[2U], GUI_TPMS_PIC_Y[2u], GUI_BLENDMODE_CUSTOM);
        }
        else
        {
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_04_luntai, GUI_TPMS_PIC_X[2u], GUI_TPMS_PIC_Y[2u], GUI_BLENDMODE_CUSTOM);
        }

        /*0x33*/
        if (User_Tpms33 == 1u)
        {
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_04_luntai2, GUI_TPMS_PIC_X[2U], GUI_TPMS_PIC_Y[1u], GUI_BLENDMODE_CUSTOM);
        }
        else
        {
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_04_luntai, GUI_TPMS_PIC_X[2u], GUI_TPMS_PIC_Y[1u], GUI_BLENDMODE_CUSTOM);
        }

        /*0x34*/
        if (User_Tpms34 == 1u)
        {
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_04_luntai2, GUI_TPMS_PIC_X[2U], GUI_TPMS_PIC_Y[0u], GUI_BLENDMODE_CUSTOM);
        }
        else
        {
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_04_luntai, GUI_TPMS_PIC_X[2u], GUI_TPMS_PIC_Y[0u], GUI_BLENDMODE_CUSTOM);
        }

        /*0x41*/
        if (User_Tpms41 == 1u)
        {
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_04_luntai2, GUI_TPMS_PIC_X[3u], GUI_TPMS_PIC_Y[3u], GUI_BLENDMODE_CUSTOM);
        }
        else
        {
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_04_luntai, GUI_TPMS_PIC_X[3u], GUI_TPMS_PIC_Y[3u], GUI_BLENDMODE_CUSTOM);
        }

        /*0x42*/
        if (User_Tpms42 == 1u)
        {
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_04_luntai2, GUI_TPMS_PIC_X[3u], GUI_TPMS_PIC_Y[2u], GUI_BLENDMODE_CUSTOM);
        }
        else
        {
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_04_luntai, GUI_TPMS_PIC_X[3u], GUI_TPMS_PIC_Y[2u], GUI_BLENDMODE_CUSTOM);
        }

        /*0x43*/
        if (User_Tpms43 == 1u)
        {
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_04_luntai2, GUI_TPMS_PIC_X[3u], GUI_TPMS_PIC_Y[1u], GUI_BLENDMODE_CUSTOM);
        }
        else
        {
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_04_luntai, GUI_TPMS_PIC_X[3u], GUI_TPMS_PIC_Y[1u], GUI_BLENDMODE_CUSTOM);
        }

        /*0x44*/
        if (User_Tpms44 == 1u)
        {
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_04_luntai2, GUI_TPMS_PIC_X[3u], GUI_TPMS_PIC_Y[0u], GUI_BLENDMODE_CUSTOM);
        }
        else
        {
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_04_luntai, GUI_TPMS_PIC_X[3u], GUI_TPMS_PIC_Y[0u], GUI_BLENDMODE_CUSTOM);
        }
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_TPMS_TempPIC_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域   K_Line_Set.K_Line_LID3E
 --------------------------------------------------------------------------*/
void GUI_BG_TPMS_TempPIC_Display(uint8_t Mode)
{
    uint8_t User_Tpms12 = 0u;
    uint8_t User_Tpms13 = 0u;
    uint8_t User_Tpms22 = 0u;
    uint8_t User_Tpms23 = 0u;
    uint8_t User_Tpms31 = 0u;
    uint8_t User_Tpms32 = 0u;
    uint8_t User_Tpms33 = 0u;
    uint8_t User_Tpms34 = 0u;
    uint8_t User_Tpms41 = 0u;
    uint8_t User_Tpms42 = 0u;
    uint8_t User_Tpms43 = 0u;
    uint8_t User_Tpms44 = 0u;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        /*高温报警*/
        User_Tpms12 = Get_TPMSHigTemp_Sta(FirstLOut);
        User_Tpms13 = Get_TPMSHigTemp_Sta(FirstROut);
        User_Tpms22 = Get_TPMSHigTemp_Sta(SecondLIn);
        User_Tpms23 = Get_TPMSHigTemp_Sta(SecondRIn);
        User_Tpms31 = Get_TPMSHigTemp_Sta(ThirdLOut);
        User_Tpms32 = Get_TPMSHigTemp_Sta(ThirdLIn);
        User_Tpms33 = Get_TPMSHigTemp_Sta(ThirdRIn);
        User_Tpms34 = Get_TPMSHigTemp_Sta(ThirdROut);
        User_Tpms41 = Get_TPMSHigTemp_Sta(FourthLOut);
        User_Tpms42 = Get_TPMSHigTemp_Sta(FourthLIn);
        User_Tpms43 = Get_TPMSHigTemp_Sta(FourthRIn);
        User_Tpms44 = Get_TPMSHigTemp_Sta(FourthROut);

        /*显示*/
        GUI_General_Display(MENU_Sprite, CN_User_Menu3_04_che, GUI_BLENDMODE_SRC_OVER); /*车*/

        GUI_General_Display(MENU_Sprite, CN_User_Menu3_04_wendu, GUI_BLENDMODE_SRC_OVER);    /*摄氏度*/
        GUI_General_Display(MENU_Sprite, CN_User_Menu3_04_qiya2, GUI_BLENDMODE_SRC_OVER);    /*气压*/
        GUI_General_Display(MENU_Sprite, CN_User_Menu3_04_wendu1, GUI_BLENDMODE_SRC_OVER);   /*胎温*/
        GUI_General_Display(MENU_Sprite, CN_User_Menu3_04_jiantou1, GUI_BLENDMODE_SRC_OVER); /*箭头*/
        GUI_General_Display(MENU_Sprite, CN_User_Menu3_04_jiantou2, GUI_BLENDMODE_SRC_OVER); /*箭头*/

        /*0x12*/
        if (User_Tpms12 == 1u)
        {
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_04_luntai2, GUI_TPMS_PIC_X[0u], GUI_TPMS_PIC_Y[3u], GUI_BLENDMODE_CUSTOM);
        }
        else
        {
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_04_luntai, GUI_TPMS_PIC_X[0u], GUI_TPMS_PIC_Y[3u], GUI_BLENDMODE_CUSTOM);
        }

        /*0x13*/
        if (User_Tpms13 == 1u)
        {
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_04_luntai2, GUI_TPMS_PIC_X[0u], GUI_TPMS_PIC_Y[0u], GUI_BLENDMODE_CUSTOM);
        }
        else
        {
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_04_luntai, GUI_TPMS_PIC_X[0u], GUI_TPMS_PIC_Y[0u], GUI_BLENDMODE_CUSTOM);
        }

        /*0x22*/
        if (User_Tpms22 == 1u)
        {
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_04_luntai2, GUI_TPMS_PIC_X[1u], GUI_TPMS_PIC_Y[3u], GUI_BLENDMODE_CUSTOM);
        }
        else
        {
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_04_luntai, GUI_TPMS_PIC_X[1u], GUI_TPMS_PIC_Y[3u], GUI_BLENDMODE_CUSTOM);
        }

        /*0x23*/
        if (User_Tpms23 == 1u)
        {
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_04_luntai2, GUI_TPMS_PIC_X[1u], GUI_TPMS_PIC_Y[0u], GUI_BLENDMODE_CUSTOM);
        }
        else
        {
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_04_luntai, GUI_TPMS_PIC_X[1u], GUI_TPMS_PIC_Y[0u], GUI_BLENDMODE_CUSTOM);
        }

        /*0x31*/
        if (User_Tpms31 == 1u)
        {
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_04_luntai2, GUI_TPMS_PIC_X[2u], GUI_TPMS_PIC_Y[3u], GUI_BLENDMODE_CUSTOM);
        }
        else
        {
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_04_luntai, GUI_TPMS_PIC_X[2u], GUI_TPMS_PIC_Y[3u], GUI_BLENDMODE_CUSTOM);
        }

        /*0x32*/
        if (User_Tpms32 == 1u)
        {
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_04_luntai2, GUI_TPMS_PIC_X[2u], GUI_TPMS_PIC_Y[2u], GUI_BLENDMODE_CUSTOM);
        }
        else
        {
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_04_luntai, GUI_TPMS_PIC_X[2], GUI_TPMS_PIC_Y[2u], GUI_BLENDMODE_CUSTOM);
        }

        /*0x33*/
        if (User_Tpms33 == 1u)
        {
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_04_luntai2, GUI_TPMS_PIC_X[2u], GUI_TPMS_PIC_Y[1u], GUI_BLENDMODE_CUSTOM);
        }
        else
        {
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_04_luntai, GUI_TPMS_PIC_X[2u], GUI_TPMS_PIC_Y[1u], GUI_BLENDMODE_CUSTOM);
        }

        /*0x34*/
        if (User_Tpms34 == 1u)
        {
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_04_luntai2, GUI_TPMS_PIC_X[2u], GUI_TPMS_PIC_Y[0u], GUI_BLENDMODE_CUSTOM);
        }
        else
        {
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_04_luntai, GUI_TPMS_PIC_X[2u], GUI_TPMS_PIC_Y[0u], GUI_BLENDMODE_CUSTOM);
        }

        /*0x41*/
        if (User_Tpms41 == 1u)
        {
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_04_luntai2, GUI_TPMS_PIC_X[3u], GUI_TPMS_PIC_Y[3u], GUI_BLENDMODE_CUSTOM);
        }
        else
        {
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_04_luntai, GUI_TPMS_PIC_X[3u], GUI_TPMS_PIC_Y[3u], GUI_BLENDMODE_CUSTOM);
        }

        /*0x42*/
        if (User_Tpms42 == 1u)
        {
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_04_luntai2, GUI_TPMS_PIC_X[3u], GUI_TPMS_PIC_Y[2u], GUI_BLENDMODE_CUSTOM);
        }
        else
        {
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_04_luntai, GUI_TPMS_PIC_X[3u], GUI_TPMS_PIC_Y[2u], GUI_BLENDMODE_CUSTOM);
        }

        /*0x43*/
        if (User_Tpms43 == 1u)
        {
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_04_luntai2, GUI_TPMS_PIC_X[3u], GUI_TPMS_PIC_Y[1u], GUI_BLENDMODE_CUSTOM);
        }
        else
        {
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_04_luntai, GUI_TPMS_PIC_X[3u], GUI_TPMS_PIC_Y[1u], GUI_BLENDMODE_CUSTOM);
        }

        /*0x44*/
        if (User_Tpms44 == 1u)
        {
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_04_luntai2, GUI_TPMS_PIC_X[3u], GUI_TPMS_PIC_Y[0u], GUI_BLENDMODE_CUSTOM);
        }
        else
        {
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_04_luntai, GUI_TPMS_PIC_X[3u], GUI_TPMS_PIC_Y[0u], GUI_BLENDMODE_CUSTOM);
        }
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_TPMS_GasNUM_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域   K_Line_Set.K_Line_LID3E
 --------------------------------------------------------------------------*/
void GUI_BG_TPMS_GasNUM_Display(uint8_t Mode)
{
    uint16_t Gas_Value_0x12 = 0u;
    uint16_t Gas_Value_0x13 = 0u;
    uint16_t Gas_Value_0x22 = 0u;
    uint16_t Gas_Value_0x23 = 0u;
    uint16_t Gas_Value_0x31 = 0u;
    uint16_t Gas_Value_0x32 = 0u;
    uint16_t Gas_Value_0x33 = 0u;
    uint16_t Gas_Value_0x34 = 0u;
    uint16_t Gas_Value_0x41 = 0u;
    uint16_t Gas_Value_0x42 = 0u;
    uint16_t Gas_Value_0x43 = 0u;
    uint16_t Gas_Value_0x44 = 0u;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        Gas_Value_0x12 = Get_DataTPMS_Pressure_Value(FirstLOut);
        Gas_Value_0x13 = Get_DataTPMS_Pressure_Value(FirstROut);
        Gas_Value_0x22 = Get_DataTPMS_Pressure_Value(SecondLIn);
        Gas_Value_0x23 = Get_DataTPMS_Pressure_Value(SecondRIn);
        Gas_Value_0x31 = Get_DataTPMS_Pressure_Value(ThirdLOut);
        Gas_Value_0x32 = Get_DataTPMS_Pressure_Value(ThirdLIn);
        Gas_Value_0x33 = Get_DataTPMS_Pressure_Value(ThirdRIn);
        Gas_Value_0x34 = Get_DataTPMS_Pressure_Value(ThirdROut);
        Gas_Value_0x41 = Get_DataTPMS_Pressure_Value(FourthLOut);
        Gas_Value_0x42 = Get_DataTPMS_Pressure_Value(FourthLIn);
        Gas_Value_0x43 = Get_DataTPMS_Pressure_Value(FourthRIn);
        Gas_Value_0x44 = Get_DataTPMS_Pressure_Value(FourthROut);

        /*0x12*/
        GUI_General_Digit_Display(MENU_Sprite, Gas_Value_0x12, CN_RC_Nb_12_0, 3u, 2u, GUI_TPMS_NUM1_X, GUI_TPMS_NUM_Y[3u], GUI_BLENDMODE_SRC_OVER);

        /*0x13*/
        GUI_General_Digit_Display(MENU_Sprite, Gas_Value_0x13, CN_RC_Nb_12_0, 3u, 2u, GUI_TPMS_NUM1_X, GUI_TPMS_NUM_Y[0u], GUI_BLENDMODE_SRC_OVER);

        /*0x22*/
        GUI_General_Digit_Display(MENU_Sprite, Gas_Value_0x22, CN_RC_Nb_12_0, 3u, 2u, GUI_TPMS_NUM2_X, GUI_TPMS_NUM_Y[3u], GUI_BLENDMODE_SRC_OVER);

        /*0x23*/
        GUI_General_Digit_Display(MENU_Sprite, Gas_Value_0x23, CN_RC_Nb_12_0, 3u, 2u, GUI_TPMS_NUM2_X, GUI_TPMS_NUM_Y[0u], GUI_BLENDMODE_SRC_OVER);

        /*0x31*/
        GUI_General_Digit_Display(MENU_Sprite, Gas_Value_0x31, CN_RC_Nb_12_0, 3u, 2u, GUI_TPMS_NUM3_X, GUI_TPMS_NUM_Y[3u], GUI_BLENDMODE_SRC_OVER);

        /*0x32*/
        GUI_General_Digit_Display(MENU_Sprite, Gas_Value_0x32, CN_RC_Nb_12_0, 3u, 2u, GUI_TPMS_NUM3_X, GUI_TPMS_NUM_Y[2u], GUI_BLENDMODE_SRC_OVER);

        /*0x33*/
        GUI_General_Digit_Display(MENU_Sprite, Gas_Value_0x33, CN_RC_Nb_12_0, 3u, 2u, GUI_TPMS_NUM3_X, GUI_TPMS_NUM_Y[1u], GUI_BLENDMODE_SRC_OVER);

        /*0x34*/
        GUI_General_Digit_Display(MENU_Sprite, Gas_Value_0x34, CN_RC_Nb_12_0, 3u, 2u, GUI_TPMS_NUM3_X, GUI_TPMS_NUM_Y[0u], GUI_BLENDMODE_SRC_OVER);

        /*0x41*/
        GUI_General_Digit_Display(MENU_Sprite, Gas_Value_0x41, CN_RC_Nb_12_0, 3u, 2u, GUI_TPMS_NUM4_X, GUI_TPMS_NUM_Y[3u], GUI_BLENDMODE_SRC_OVER);

        /*0x42*/
        GUI_General_Digit_Display(MENU_Sprite, Gas_Value_0x42, CN_RC_Nb_12_0, 3u, 2u, GUI_TPMS_NUM4_X, GUI_TPMS_NUM_Y[2u], GUI_BLENDMODE_SRC_OVER);

        /*0x43*/
        GUI_General_Digit_Display(MENU_Sprite, Gas_Value_0x43, CN_RC_Nb_12_0, 3u, 2u, GUI_TPMS_NUM4_X, GUI_TPMS_NUM_Y[1u], GUI_BLENDMODE_SRC_OVER);

        /*0x44*/
        GUI_General_Digit_Display(MENU_Sprite, Gas_Value_0x44, CN_RC_Nb_12_0, 3u, 2u, GUI_TPMS_NUM4_X, GUI_TPMS_NUM_Y[0u], GUI_BLENDMODE_SRC_OVER);
    }

    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_TPMS_TempNUM_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域   K_Line_Set.K_Line_LID3E
 --------------------------------------------------------------------------*/
void GUI_BG_TPMS_TempNUM_Display(uint8_t Mode)
{
    uint16_t Temp_Value_0x12 = 0u;
    uint16_t Temp_Value_0x13 = 0u;
    uint16_t Temp_Value_0x22 = 0u;
    uint16_t Temp_Value_0x23 = 0u;
    uint16_t Temp_Value_0x31 = 0u;
    uint16_t Temp_Value_0x32 = 0u;
    uint16_t Temp_Value_0x33 = 0u;
    uint16_t Temp_Value_0x34 = 0u;
    uint16_t Temp_Value_0x41 = 0u;
    uint16_t Temp_Value_0x42 = 0u;
    uint16_t Temp_Value_0x43 = 0u;
    uint16_t Temp_Value_0x44 = 0u;

    uint8_t Temp_Sta_0x12 = STATUS_NONNEGATIVE;
    uint8_t Temp_Sta_0x13 = STATUS_NONNEGATIVE;
    uint8_t Temp_Sta_0x22 = STATUS_NONNEGATIVE;
    uint8_t Temp_Sta_0x23 = STATUS_NONNEGATIVE;
    uint8_t Temp_Sta_0x31 = STATUS_NONNEGATIVE;
    uint8_t Temp_Sta_0x32 = STATUS_NONNEGATIVE;
    uint8_t Temp_Sta_0x33 = STATUS_NONNEGATIVE;
    uint8_t Temp_Sta_0x34 = STATUS_NONNEGATIVE;
    uint8_t Temp_Sta_0x41 = STATUS_NONNEGATIVE;
    uint8_t Temp_Sta_0x42 = STATUS_NONNEGATIVE;
    uint8_t Temp_Sta_0x43 = STATUS_NONNEGATIVE;
    uint8_t Temp_Sta_0x44 = STATUS_NONNEGATIVE;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        Temp_Value_0x12 = Get_DataTPMS_Temp_Value(FirstLOut);
        Temp_Value_0x13 = Get_DataTPMS_Temp_Value(FirstROut);
        Temp_Value_0x22 = Get_DataTPMS_Temp_Value(SecondLIn);
        Temp_Value_0x23 = Get_DataTPMS_Temp_Value(SecondRIn);
        Temp_Value_0x31 = Get_DataTPMS_Temp_Value(ThirdLOut);
        Temp_Value_0x32 = Get_DataTPMS_Temp_Value(ThirdLIn);
        Temp_Value_0x33 = Get_DataTPMS_Temp_Value(ThirdRIn);
        Temp_Value_0x34 = Get_DataTPMS_Temp_Value(ThirdROut);
        Temp_Value_0x41 = Get_DataTPMS_Temp_Value(FourthLOut);
        Temp_Value_0x42 = Get_DataTPMS_Temp_Value(FourthLIn);
        Temp_Value_0x43 = Get_DataTPMS_Temp_Value(FourthRIn);
        Temp_Value_0x44 = Get_DataTPMS_Temp_Value(FourthROut);

        Temp_Sta_0x12 = Get_DataTPMS_Temp_Sta(FirstLOut);
        Temp_Sta_0x13 = Get_DataTPMS_Temp_Sta(FirstROut);
        Temp_Sta_0x22 = Get_DataTPMS_Temp_Sta(SecondLIn);
        Temp_Sta_0x23 = Get_DataTPMS_Temp_Sta(SecondRIn);
        Temp_Sta_0x31 = Get_DataTPMS_Temp_Sta(ThirdLOut);
        Temp_Sta_0x32 = Get_DataTPMS_Temp_Sta(ThirdLIn);
        Temp_Sta_0x33 = Get_DataTPMS_Temp_Sta(ThirdRIn);
        Temp_Sta_0x34 = Get_DataTPMS_Temp_Sta(ThirdROut);
        Temp_Sta_0x41 = Get_DataTPMS_Temp_Sta(FourthLOut);
        Temp_Sta_0x42 = Get_DataTPMS_Temp_Sta(FourthLIn);
        Temp_Sta_0x43 = Get_DataTPMS_Temp_Sta(FourthRIn);
        Temp_Sta_0x44 = Get_DataTPMS_Temp_Sta(FourthROut);

        /*0x12*/
        if (Temp_Sta_0x12 == STATUS_NEGATIVE)
        {
            GUI_General_Digit_Display(MENU_Sprite, Temp_Value_0x12, CN_RC_Nb_12_0, 2u, 1u, GUI_TPMS_NUM1_X, GUI_TPMS_NUM_Y[3u], GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, Nb_12_heng, (GUI_TPMS_MIC3_X[0] + 3u), (GUI_TPMS_NUM_Y[3u] + 9u), GUI_BLENDMODE_SRC_OVER);
        }
        else // if (Temp_Sta_0x12 == STATUS_NONNEGATIVE)
        {
            GUI_General_Digit_Display(MENU_Sprite, Temp_Value_0x12, CN_RC_Nb_12_0, 3u, 2u, GUI_TPMS_NUM1_X, GUI_TPMS_NUM_Y[3u], GUI_BLENDMODE_SRC_OVER);
        }

        /*0x13*/
        if (Temp_Sta_0x13 == STATUS_NEGATIVE)
        {
            GUI_General_Digit_Display(MENU_Sprite, Temp_Value_0x13, CN_RC_Nb_12_0, 2u, 1u, GUI_TPMS_NUM1_X, GUI_TPMS_NUM_Y[0u], GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, Nb_12_heng, (GUI_TPMS_MIC3_X[0] + 3u), (GUI_TPMS_NUM_Y[0u] + 9u), GUI_BLENDMODE_SRC_OVER);
        }
        else // if (Temp_Sta_0x13 == STATUS_NONNEGATIVE)
        {
            GUI_General_Digit_Display(MENU_Sprite, Temp_Value_0x13, CN_RC_Nb_12_0, 3u, 2u, GUI_TPMS_NUM1_X, GUI_TPMS_NUM_Y[0u], GUI_BLENDMODE_SRC_OVER);
        }

        /*0x22*/
        if (Temp_Sta_0x22 == STATUS_NEGATIVE)
        {
            GUI_General_Digit_Display(MENU_Sprite, Temp_Value_0x22, CN_RC_Nb_12_0, 2u, 1u, GUI_TPMS_NUM2_X, GUI_TPMS_NUM_Y[3u], GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, Nb_12_heng, (GUI_TPMS_MIC3_X[1] + 3u), (GUI_TPMS_NUM_Y[3u] + 9u), GUI_BLENDMODE_SRC_OVER);
        }
        else // if (Temp_Sta_0x22 == STATUS_NONNEGATIVE)
        {
            GUI_General_Digit_Display(MENU_Sprite, Temp_Value_0x22, CN_RC_Nb_12_0, 3u, 2u, GUI_TPMS_NUM2_X, GUI_TPMS_NUM_Y[3u], GUI_BLENDMODE_SRC_OVER);
        }

        /*0x23*/
        if (Temp_Sta_0x23 == STATUS_NEGATIVE)
        {
            GUI_General_Digit_Display(MENU_Sprite, Temp_Value_0x23, CN_RC_Nb_12_0, 2u, 1u, GUI_TPMS_NUM2_X, GUI_TPMS_NUM_Y[0u], GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, Nb_12_heng, (GUI_TPMS_MIC3_X[1] + 3u), (GUI_TPMS_NUM_Y[0u] + 9u), GUI_BLENDMODE_SRC_OVER);
        }
        else // if (Temp_Sta_0x23 == STATUS_NONNEGATIVE)
        {
            GUI_General_Digit_Display(MENU_Sprite, Temp_Value_0x23, CN_RC_Nb_12_0, 3u, 2u, GUI_TPMS_NUM2_X, GUI_TPMS_NUM_Y[0u], GUI_BLENDMODE_SRC_OVER);
        }

        /*0x31*/
        if (Temp_Sta_0x31 == STATUS_NEGATIVE)
        {
            GUI_General_Digit_Display(MENU_Sprite, Temp_Value_0x31, CN_RC_Nb_12_0, 2u, 1u, GUI_TPMS_NUM3_X, GUI_TPMS_NUM_Y[3u], GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, Nb_12_heng, (GUI_TPMS_MIC3_X[2] + 3u), (GUI_TPMS_NUM_Y[3u] + 9u), GUI_BLENDMODE_SRC_OVER);
        }
        else // if (Temp_Sta_0x31 == STATUS_NONNEGATIVE)
        {
            GUI_General_Digit_Display(MENU_Sprite, Temp_Value_0x31, CN_RC_Nb_12_0, 3u, 2u, GUI_TPMS_NUM3_X, GUI_TPMS_NUM_Y[3u], GUI_BLENDMODE_SRC_OVER);
        }

        /*0x32*/
        if (Temp_Sta_0x32 == STATUS_NEGATIVE)
        {
            GUI_General_Digit_Display(MENU_Sprite, Temp_Value_0x32, CN_RC_Nb_12_0, 2u, 1u, GUI_TPMS_NUM3_X, GUI_TPMS_NUM_Y[2u], GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, Nb_12_heng, (GUI_TPMS_MIC3_X[2] + 3u), (GUI_TPMS_NUM_Y[2u] + 9u), GUI_BLENDMODE_SRC_OVER);
        }
        else // if (Temp_Sta_0x32 == STATUS_NONNEGATIVE)
        {
            GUI_General_Digit_Display(MENU_Sprite, Temp_Value_0x32, CN_RC_Nb_12_0, 3u, 2u, GUI_TPMS_NUM3_X, GUI_TPMS_NUM_Y[2u], GUI_BLENDMODE_SRC_OVER);
        }

        /*0x33*/
        if (Temp_Sta_0x33 == STATUS_NEGATIVE)
        {
            GUI_General_Digit_Display(MENU_Sprite, Temp_Value_0x33, CN_RC_Nb_12_0, 2u, 1u, GUI_TPMS_NUM3_X, GUI_TPMS_NUM_Y[1u], GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, Nb_12_heng, (GUI_TPMS_MIC3_X[2] + 3u), (GUI_TPMS_NUM_Y[1u] + 9u), GUI_BLENDMODE_SRC_OVER);
        }
        else // if (Temp_Sta_0x33 == STATUS_NONNEGATIVE)
        {
            GUI_General_Digit_Display(MENU_Sprite, Temp_Value_0x33, CN_RC_Nb_12_0, 3u, 2u, GUI_TPMS_NUM3_X, GUI_TPMS_NUM_Y[1u], GUI_BLENDMODE_SRC_OVER);
        }

        /*0x34*/
        if (Temp_Sta_0x34 == STATUS_NEGATIVE)
        {
            GUI_General_Digit_Display(MENU_Sprite, Temp_Value_0x34, CN_RC_Nb_12_0, 2u, 1u, GUI_TPMS_NUM3_X, GUI_TPMS_NUM_Y[0u], GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, Nb_12_heng, (GUI_TPMS_MIC3_X[2] + 3u), (GUI_TPMS_NUM_Y[0u] + 9u), GUI_BLENDMODE_SRC_OVER);
        }
        else // if (Temp_Sta_0x34 == STATUS_NONNEGATIVE)
        {
            GUI_General_Digit_Display(MENU_Sprite, Temp_Value_0x34, CN_RC_Nb_12_0, 3u, 2u, GUI_TPMS_NUM3_X, GUI_TPMS_NUM_Y[0u], GUI_BLENDMODE_SRC_OVER);
        }

        /*0x41*/
        if (Temp_Sta_0x41 == STATUS_NEGATIVE)
        {
            GUI_General_Digit_Display(MENU_Sprite, Temp_Value_0x41, CN_RC_Nb_12_0, 2u, 1u, GUI_TPMS_NUM4_X, GUI_TPMS_NUM_Y[3u], GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, Nb_12_heng, (GUI_TPMS_MIC3_X[3] + 3u), (GUI_TPMS_NUM_Y[3u] + 9u), GUI_BLENDMODE_SRC_OVER);
        }
        else // if (Temp_Sta_0x41 == STATUS_NONNEGATIVE)
        {
            GUI_General_Digit_Display(MENU_Sprite, Temp_Value_0x41, CN_RC_Nb_12_0, 3u, 2u, GUI_TPMS_NUM4_X, GUI_TPMS_NUM_Y[3u], GUI_BLENDMODE_SRC_OVER);
        }

        /*0x42*/
        if (Temp_Sta_0x42 == STATUS_NEGATIVE)
        {
            GUI_General_Digit_Display(MENU_Sprite, Temp_Value_0x42, CN_RC_Nb_12_0, 2u, 1u, GUI_TPMS_NUM4_X, GUI_TPMS_NUM_Y[2u], GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, Nb_12_heng, (GUI_TPMS_MIC3_X[3] + 3u), (GUI_TPMS_NUM_Y[2u] + 9u), GUI_BLENDMODE_SRC_OVER);
        }
        else // if (Temp_Sta_0x42 == STATUS_NONNEGATIVE)
        {
            GUI_General_Digit_Display(MENU_Sprite, Temp_Value_0x42, CN_RC_Nb_12_0, 3u, 2u, GUI_TPMS_NUM4_X, GUI_TPMS_NUM_Y[2u], GUI_BLENDMODE_SRC_OVER);
        }

        /*0x43*/
        if (Temp_Sta_0x43 == STATUS_NEGATIVE)
        {
            GUI_General_Digit_Display(MENU_Sprite, Temp_Value_0x43, CN_RC_Nb_12_0, 2u, 1u, GUI_TPMS_NUM4_X, GUI_TPMS_NUM_Y[1u], GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, Nb_12_heng, (GUI_TPMS_MIC3_X[3] + 3u), (GUI_TPMS_NUM_Y[1u] + 9u), GUI_BLENDMODE_SRC_OVER);
        }
        else // if (Temp_Sta_0x43 == STATUS_NONNEGATIVE)
        {
            GUI_General_Digit_Display(MENU_Sprite, Temp_Value_0x43, CN_RC_Nb_12_0, 3u, 2u, GUI_TPMS_NUM4_X, GUI_TPMS_NUM_Y[1u], GUI_BLENDMODE_SRC_OVER);
        }

        /*0x44*/
        if (Temp_Sta_0x44 == STATUS_NEGATIVE)
        {
            GUI_General_Digit_Display(MENU_Sprite, Temp_Value_0x44, CN_RC_Nb_12_0, 2u, 1u, GUI_TPMS_NUM4_X, GUI_TPMS_NUM_Y[0u], GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, Nb_12_heng, (GUI_TPMS_MIC3_X[3] + 3u), (GUI_TPMS_NUM_Y[0u] + 9u), GUI_BLENDMODE_SRC_OVER);
        }
        else // if (Temp_Sta_0x44 == STATUS_NONNEGATIVE)
        {
            GUI_General_Digit_Display(MENU_Sprite, Temp_Value_0x44, CN_RC_Nb_12_0, 3u, 2u, GUI_TPMS_NUM4_X, GUI_TPMS_NUM_Y[0u], GUI_BLENDMODE_SRC_OVER);
        }
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_RepMenu_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
void GUI_BG_RepMenu_Display(uint8_t Mode)
{
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        /*显示*/
        GUI_General_Display(MENU_Sprite, CN_User_Menu3_01_wenzi, GUI_BLENDMODE_SRC_OVER); /*menu*/
        GUI_General_Display(MENU_Sprite, CN_fengexian, GUI_BLENDMODE_SRC_OVER);           /*line*/
        GUI_General_Display(MENU_Sprite, CN_white_fuwei, GUI_BLENDMODE_SRC_OVER);         /*确认*/
        GUI_General_Display(MENU_Sprite, CN_User_Menu3_01_km, GUI_BLENDMODE_SRC_OVER);    /*KM*/
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_RepMenu_3_1_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
void GUI_BG_RepMenu_3_1_Display(uint8_t Mode)
{
    uint32_t User_Value = 0u;
    uint8_t User_FLAG = 0u;

    uint8_t Sig_Engine_Oil = 0u;
    uint8_t Sig_Starter_OH = 0u;
    uint8_t CanStatus = 0u;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        /*发动机油＆滤清器*/ /*User_ECU.Engine_Oil*/ /*User_App.User_FDJYLQQ = User_ECU.Engine_Oil;*/
        Sig_Engine_Oil = Get_ID_18FF3018_Sig_Engine_Oil_Warnning();/*78*/
        Sig_Starter_OH = Get_ID_18FF3018_Sig_Starter_OH_Warnning();/*12*/
        CanStatus =  CAN_MSG_Status(ID_CanMsg18EF1718_Msg_Count);

        User_Value = (User_ECU.Engine_Oil / 1000u); /*显示数据*/

        if (CanStatus == CAN_SIG_LOST)
        {
            GUI_General_Display(MENU_Sprite, CN_User_Menu3_01_12, GUI_BLENDMODE_SRC_OVER); /*距离更换*/
            GUI_General_Display(MENU_Sprite, CN_User_Menu3_01_ERROR, GUI_BLENDMODE_SRC_OVER); /*error*/
        }
        else
        {
            if (Sig_Engine_Oil == 1u)/*事前报警*/
            {
                GUI_General_Display(MENU_Sprite, CN_User_Menu3_01_14, GUI_BLENDMODE_SRC_OVER); /*即将请更换*/

                if (User_Value >= 1000u)
                {
                    GUI_Translate_Display(MENU_Sprite, Nb_15_douhao, 534u, 281u, GUI_BLENDMODE_SRC_OVER); /*逗号*/
                }
                else
                {
                    GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
                }

                GUI_General_Digit_Display(MENU_Sprite, User_Value, Nb_15_0, 6u, 5u, GUI_REP1_X, 277u, GUI_BLENDMODE_SRC_OVER);
            }
            else if ((Sig_Engine_Oil == 0u) || (Sig_Starter_OH == 0u)) /*无报警*/
            {
                GUI_General_Display(MENU_Sprite, CN_User_Menu3_01_12, GUI_BLENDMODE_SRC_OVER);/*距离更换*/

                if (User_Value >= 1000u)
                {
                    GUI_Translate_Display(MENU_Sprite, Nb_15_douhao, 534u, 281u, GUI_BLENDMODE_SRC_OVER); /*逗号*/
                }
                else
                {
                    GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
                }

                GUI_General_Digit_Display(MENU_Sprite, User_Value, Nb_15_0, 6u, 5u, GUI_REP1_X, 277u, GUI_BLENDMODE_SRC_OVER);
            }
            else if ((Sig_Engine_Oil == 2u) || (Sig_Starter_OH == 2u)) /*本报警*/
            {
                GUI_General_Display(MENU_Sprite, CN_User_Menu3_01_13, GUI_BLENDMODE_SRC_OVER); /*请更换*/

                GUI_Translate_Display(MENU_Sprite, Nb_15_fuhao, 506u, 279u, GUI_BLENDMODE_SRC_OVER);  /*负号*/
                if (User_Value >= 1000u)
                {
                    GUI_Translate_Display(MENU_Sprite, Nb_15_douhao, 534u, 281u, GUI_BLENDMODE_SRC_OVER); /*逗号*/
                }
                else
                {
                    GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
                }

                GUI_General_Digit_Display(MENU_Sprite, User_Value, Nb_15_0, 6u, 5u, GUI_REP1_X, 277u, GUI_BLENDMODE_SRC_OVER);
            }
            else if ((Sig_Engine_Oil == 3u) || (Sig_Starter_OH == 3u))/*空白*/
            {
                GUI_General_Display(MENU_Sprite, CN_User_Menu3_01_12, GUI_BLENDMODE_SRC_OVER); /*距离更换*/
                GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
            }
            else
            {
                GUI_General_Display(MENU_Sprite, CN_User_Menu3_01_12, GUI_BLENDMODE_SRC_OVER); /*距离更换*/
                GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
            }
        }

//        User_Value = User_App.User_FDJYLQQ; /*显示数据*/
//        User_FLAG = State_Flag.User_FDJYLQQ_FLAG; /*显示状态*/
//
//        if (User_Value > 0u)
//        {
//            if (User_Value > 999u)
//            {
//                GUI_General_Display(MENU_Sprite, CN_User_Menu3_01_12, GUI_BLENDMODE_SRC_OVER); /*距离更换*/
//
//                //if (User_Value > 1000)
//                //{
//                //    GUI_General_Display(MENU_Sprite, CN_User_Menu3_01_12, GUI_BLENDMODE_SRC_OVER); /*距离更换*/
//                //}
//                //else
//                //{
//                //    GUI_General_Display(MENU_Sprite, CN_User_Menu3_01_14, GUI_BLENDMODE_SRC_OVER); /*即将更换*/
//                //}
//
//                GUI_Translate_Display(MENU_Sprite, Nb_15_douhao, 534u, 281u, GUI_BLENDMODE_SRC_OVER); /*逗号*/
//            }
//            else
//            {
//                GUI_General_Display(MENU_Sprite, CN_User_Menu3_01_12, GUI_BLENDMODE_SRC_OVER); /*请更换*/
//                GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
//            }
//
//            GUI_General_Digit_Display(MENU_Sprite, User_Value, Nb_15_0, 6u, 5u, GUI_REP1_X, 277u, GUI_BLENDMODE_SRC_OVER);
//        }
//        else
//        {
//            GUI_General_Display(MENU_Sprite, CN_User_Menu3_01_13, GUI_BLENDMODE_SRC_OVER); /*请更换*/
//
//            if (User_FLAG == 1u)
//            {
//                GUI_Translate_Display(MENU_Sprite, Nb_15_douhao, 534u, 281u, GUI_BLENDMODE_SRC_OVER); /*逗号*/
//                GUI_Translate_Display(MENU_Sprite, Nb_15_fuhao, 506u, 279u, GUI_BLENDMODE_SRC_OVER);  /*负号*/
//
//                GUI_General_Digit_Display(MENU_Sprite, 1000u, Nb_15_0, 4u, 3u, GUI_REP_X, 277u, GUI_BLENDMODE_SRC_OVER);
//            }
//            else if (User_FLAG == 3u)
//            {
//                GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
//            }
//        }
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_RepMenu_3_2_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
void GUI_BG_RepMenu_3_2_Display(uint8_t Mode)
{
    uint32_t User_Value = 0u;
    uint8_t User_FLAG = 1u;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        User_Value = User_App.User_RYLQQ; /*显示数据*/
        User_FLAG = State_Flag.User_RYLQQ_FLAG; /*显示状态*/

        if (User_Value > 0u)
        {
            if (User_Value > 999u)
            {
                GUI_General_Display(MENU_Sprite, CN_User_Menu3_01_24, GUI_BLENDMODE_SRC_OVER); /*距离更换*/

                //if (User_Value > 1000)
                //{
                //    GUI_General_Display(MENU_Sprite, CN_User_Menu3_01_24, GUI_BLENDMODE_SRC_OVER); /*距离更换*/
                //}
                //else
                //{
                //    GUI_General_Display(MENU_Sprite, CN_User_Menu3_01_26, GUI_BLENDMODE_SRC_OVER); /*即将更换*/
                //}

                GUI_Translate_Display(MENU_Sprite, Nb_15_douhao, 534u, 281u, GUI_BLENDMODE_SRC_OVER); /*逗号*/
            }
            else
            {
                GUI_General_Display(MENU_Sprite, CN_User_Menu3_01_25, GUI_BLENDMODE_SRC_OVER); /*请更换*/
                GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
            }

            GUI_General_Digit_Display(MENU_Sprite, User_Value, Nb_15_0, 6u, 5u, GUI_REP1_X, 277u, GUI_BLENDMODE_SRC_OVER);
        }
        else
        {
            GUI_General_Display(MENU_Sprite, CN_User_Menu3_01_25, GUI_BLENDMODE_SRC_OVER); /*请更换*/

            if (User_FLAG == 1u)
            {
                GUI_Translate_Display(MENU_Sprite, Nb_15_douhao, 534u, 281u, GUI_BLENDMODE_SRC_OVER); /*逗号*/
                GUI_Translate_Display(MENU_Sprite, Nb_15_fuhao, 506u, 279u, GUI_BLENDMODE_SRC_OVER);  /*负号*/

                GUI_General_Digit_Display(MENU_Sprite, 1000u, Nb_15_0, 4u, 3u, GUI_REP_X, 277u, GUI_BLENDMODE_SRC_OVER);
            }
            else if (User_FLAG == 3u)
            {
                GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
            }
        }
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_RepMenu_3_3_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
void GUI_BG_RepMenu_3_3_Display(uint8_t Mode)
{
    uint32_t User_Value = 0u;
    uint8_t User_FLAG = 1u;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        User_Value = User_App.User_BSXY; /*显示数据*/
        User_FLAG = State_Flag.User_BSXY_FLAG; /*显示状态*/

        if (User_Value > 0u)
        {
            if (User_Value > 999u)
            {
                GUI_General_Display(MENU_Sprite, CN_User_Menu3_01_1, GUI_BLENDMODE_SRC_OVER); /*距离更换*/

                //if (User_Value > 1000)
                //{
                //    GUI_General_Display(MENU_Sprite, CN_User_Menu3_01_1, GUI_BLENDMODE_SRC_OVER); /*距离更换*/
                //}
                //else
                //{
                //    GUI_General_Display(MENU_Sprite, CN_User_Menu3_01_3, GUI_BLENDMODE_SRC_OVER); /*即将更换*/
                //}

                GUI_Translate_Display(MENU_Sprite, Nb_15_douhao, 534u, 281u, GUI_BLENDMODE_SRC_OVER); /*逗号*/
            }
            else
            {
                GUI_General_Display(MENU_Sprite, CN_User_Menu3_01_2, GUI_BLENDMODE_SRC_OVER); /*请更换*/
                GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
            }

            GUI_General_Digit_Display(MENU_Sprite, User_Value, Nb_15_0, 6u, 5u, GUI_REP1_X, 277u, GUI_BLENDMODE_SRC_OVER);
        }
        else
        {
            GUI_General_Display(MENU_Sprite, CN_User_Menu3_01_2, GUI_BLENDMODE_SRC_OVER); /*请更换*/

            if (User_FLAG == 1u)
            {
                GUI_Translate_Display(MENU_Sprite, Nb_15_douhao, 534u, 281u, GUI_BLENDMODE_SRC_OVER); /*逗号*/
                GUI_Translate_Display(MENU_Sprite, Nb_15_fuhao, 506u, 279u, GUI_BLENDMODE_SRC_OVER);  /*负号*/

                GUI_General_Digit_Display(MENU_Sprite, 1000u, Nb_15_0, 4u, 3u, GUI_REP_X, 277u, GUI_BLENDMODE_SRC_OVER);
            }
            else if (User_FLAG == 3u)
            {
                GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
            }
        }
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_RepMenu_3_4_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
void GUI_BG_RepMenu_3_4_Display(uint8_t Mode)
{
    uint32_t User_Value = 0u;
    uint8_t User_FLAG = 1u;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        User_Value = User_App.User_CSQY; /*显示数据*/
        User_FLAG = State_Flag.User_CSQY_FLAG; /*显示状态*/

        if (User_Value > 0u)
        {
            if (User_Value > 999u)
            {
                GUI_General_Display(MENU_Sprite, CN_User_Menu3_01_4, GUI_BLENDMODE_SRC_OVER); /*距离更换*/

                //if (User_Value > 1000)
                //{
                //    GUI_General_Display(MENU_Sprite, CN_User_Menu3_01_4, GUI_BLENDMODE_SRC_OVER); /*距离更换*/
                //}
                //else
                //{
                //    GUI_General_Display(MENU_Sprite, CN_User_Menu3_01_6, GUI_BLENDMODE_SRC_OVER); /*即将更换*/
                //}

                GUI_Translate_Display(MENU_Sprite, Nb_15_douhao, 534u, 281u, GUI_BLENDMODE_SRC_OVER); /*逗号*/
            }
            else
            {
                GUI_General_Display(MENU_Sprite, CN_User_Menu3_01_5, GUI_BLENDMODE_SRC_OVER); /*请更换*/
                GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
            }

            GUI_General_Digit_Display(MENU_Sprite, User_Value, Nb_15_0, 6u, 5u, GUI_REP1_X, 277u, GUI_BLENDMODE_SRC_OVER);
        }
        else
        {
            GUI_General_Display(MENU_Sprite, CN_User_Menu3_01_5, GUI_BLENDMODE_SRC_OVER); /*请更换*/

            if (User_FLAG == 1u)
            {
                GUI_Translate_Display(MENU_Sprite, Nb_15_douhao, 534u, 281u, GUI_BLENDMODE_SRC_OVER); /*逗号*/
                GUI_Translate_Display(MENU_Sprite, Nb_15_fuhao, 506u, 279u, GUI_BLENDMODE_SRC_OVER);  /*负号*/

                GUI_General_Digit_Display(MENU_Sprite, 1000u, Nb_15_0, 4u, 3u, GUI_REP_X, 277u, GUI_BLENDMODE_SRC_OVER);
            }
            else if (User_FLAG == 3u)
            {
                GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
            }
        }
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_RepMenu_3_6_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
void GUI_BG_RepMenu_3_6_Display(uint8_t Mode)
{
    uint32_t User_Value = 0u;
    uint8_t User_FLAG = 1u;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        //User_Value = User_App.User_FDJYLQQ; /*显示数据*/
        //User_FLAG = State_Flag.User_FDJYLQQ_FLAG; /*显示状态*/

        if (User_Value > 0u)
        {
            if (User_Value > 999u)
            {
                GUI_General_Display(MENU_Sprite, CN_User_Menu3_01_24, GUI_BLENDMODE_SRC_OVER); /*距离更换*/

                //if (User_Value > 1000)
                //{
                //    GUI_General_Display(MENU_Sprite, CN_User_Menu3_01_24, GUI_BLENDMODE_SRC_OVER); /*距离更换*/
                //}
                //else
                //{
                //    GUI_General_Display(MENU_Sprite, CN_User_Menu3_01_26, GUI_BLENDMODE_SRC_OVER); /*即将更换*/
                //}

                GUI_Translate_Display(MENU_Sprite, Nb_15_douhao, 534u, 281u, GUI_BLENDMODE_SRC_OVER); /*逗号*/
            }
            else
            {
                GUI_General_Display(MENU_Sprite, CN_User_Menu3_01_25, GUI_BLENDMODE_SRC_OVER); /*请更换*/
                GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
            }

            GUI_General_Digit_Display(MENU_Sprite, User_Value, Nb_15_0, 6u, 5u, GUI_REP1_X, 277u, GUI_BLENDMODE_SRC_OVER);
        }
        else
        {
            GUI_General_Display(MENU_Sprite, CN_User_Menu3_01_25, GUI_BLENDMODE_SRC_OVER); /*请更换*/

            if (User_FLAG == 1u)
            {
                GUI_Translate_Display(MENU_Sprite, Nb_15_douhao, 534u, 281u, GUI_BLENDMODE_SRC_OVER); /*逗号*/
                GUI_Translate_Display(MENU_Sprite, Nb_15_fuhao, 506u, 279u, GUI_BLENDMODE_SRC_OVER);  /*负号*/

                GUI_General_Digit_Display(MENU_Sprite, 1000u, Nb_15_0, 4u, 3u, GUI_REP_X, 277u, GUI_BLENDMODE_SRC_OVER);
            }
            else if (User_FLAG == 3u)
            {
                GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
            }
        }
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_RepMenu_3_7_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
void GUI_BG_RepMenu_3_7_Display(uint8_t Mode)
{
    uint32_t User_Value = 0u;
    uint8_t User_FLAG = 1u;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        User_Value = User_App.User_DLZXY; /*显示数据*/
        User_FLAG = State_Flag.User_DLZXY_FLAG; /*显示状态*/

        if (User_Value > 0u)
        {
            if (User_Value > 999u)
            {
                GUI_General_Display(MENU_Sprite, CN_User_Menu3_01_7, GUI_BLENDMODE_SRC_OVER); /*距离更换*/

                //if (User_Value > 1000)
                //{
                //    GUI_General_Display(MENU_Sprite, CN_User_Menu3_01_7, GUI_BLENDMODE_SRC_OVER); /*距离更换*/
                //}
                //else
                //{
                //    GUI_General_Display(MENU_Sprite, CN_User_Menu3_01_9, GUI_BLENDMODE_SRC_OVER); /*即将更换*/
                //}

                GUI_Translate_Display(MENU_Sprite, Nb_15_douhao, 534u, 281u, GUI_BLENDMODE_SRC_OVER); /*逗号*/
            }
            else
            {
                GUI_General_Display(MENU_Sprite, CN_User_Menu3_01_8, GUI_BLENDMODE_SRC_OVER); /*请更换*/
                GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
            }

            GUI_General_Digit_Display(MENU_Sprite, User_Value, Nb_15_0, 6u, 5u, GUI_REP1_X, 277u, GUI_BLENDMODE_SRC_OVER);
        }
        else
        {

            GUI_General_Display(MENU_Sprite, CN_User_Menu3_01_8, GUI_BLENDMODE_SRC_OVER); /*请更换*/

            if (User_FLAG == 1u)
            {
                GUI_Translate_Display(MENU_Sprite, Nb_15_douhao, 534u, 281u, GUI_BLENDMODE_SRC_OVER); /*逗号*/
                GUI_Translate_Display(MENU_Sprite, Nb_15_fuhao, 506u, 279u, GUI_BLENDMODE_SRC_OVER);  /*负号*/

                GUI_General_Digit_Display(MENU_Sprite, 1000u, Nb_15_0, 4u, 3u, GUI_REP_X, 277u, GUI_BLENDMODE_SRC_OVER);
            }
            else if (User_FLAG == 3u)
            {
                GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
            }
        }
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_RepMenu_3_8_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
void GUI_BG_RepMenu_3_8_Display(uint8_t Mode)
{
    uint32_t User_Value = 0u;
    uint8_t User_FLAG = 1u;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        User_Value = User_App.User_LT; /*显示数据*/
        User_FLAG = State_Flag.User_LT_FLAG; /*显示状态*/

        if (User_Value > 0u)
        {
            if (User_Value > 999u)
            {
                GUI_General_Display(MENU_Sprite, CN_User_Menu3_01_18, GUI_BLENDMODE_SRC_OVER); /*距离更换*/

                //if (User_Value > 1000)
                //{
                //    GUI_General_Display(MENU_Sprite, CN_User_Menu3_01_18, GUI_BLENDMODE_SRC_OVER); /*距离更换*/
                //}
                //else
                //{
                //    GUI_General_Display(MENU_Sprite, CN_User_Menu3_01_20, GUI_BLENDMODE_SRC_OVER); /*即将更换*/
                //}

                GUI_Translate_Display(MENU_Sprite, Nb_15_douhao, 534u, 281u, GUI_BLENDMODE_SRC_OVER); /*逗号*/
            }
            else
            {
                GUI_General_Display(MENU_Sprite, CN_User_Menu3_01_19, GUI_BLENDMODE_SRC_OVER); /*请更换*/
                GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
            }

            GUI_General_Digit_Display(MENU_Sprite, User_Value, Nb_15_0, 6u, 5u, GUI_REP1_X, 277u, GUI_BLENDMODE_SRC_OVER);
        }
        else
        {
            GUI_General_Display(MENU_Sprite, CN_User_Menu3_01_19, GUI_BLENDMODE_SRC_OVER); /*请更换*/

            if (User_FLAG == 1u)
            {
                GUI_Translate_Display(MENU_Sprite, Nb_15_douhao, 534u, 281u, GUI_BLENDMODE_SRC_OVER); /*逗号*/
                GUI_Translate_Display(MENU_Sprite, Nb_15_fuhao, 506u, 279u, GUI_BLENDMODE_SRC_OVER);  /*负号*/

                GUI_General_Digit_Display(MENU_Sprite, 1000u, Nb_15_0, 4u, 3u, GUI_REP_X, 277u, GUI_BLENDMODE_SRC_OVER);
            }
            else if (User_FLAG == 3u)
            {
                GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
            }
        }
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_RepMenuSet_Menu_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
void GUI_BG_RepMenuSet_Menu_Display(uint8_t Mode)
{
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_General_Display(MENU_Sprite, CN_User_Menu3_02_wenzi, GUI_BLENDMODE_SRC_OVER); /*menu*/
        GUI_General_Display(MENU_Sprite, CN_fengexian, GUI_BLENDMODE_SRC_OVER);           /*line*/
        GUI_General_Display(MENU_Sprite, CN_User_Menu3_02_kuang, GUI_BLENDMODE_SRC_OVER); /*框*/
        GUI_General_Display(MENU_Sprite, CN_white_queding, GUI_BLENDMODE_SRC_OVER);       /*ENTER*/
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_RepSetMenu_3_1_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
void GUI_BG_RepSetMenu_3_1_Display(uint8_t Mode)
{
    uint32_t User_Value = 0u;

    User_Value = User_set_Num.User_FDJYLQQ; /*显示数据*/

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_General_Display(MENU_Sprite, CN_User_Menu3_02_1, GUI_BLENDMODE_SRC_OVER); /*menu*/

        if (User_Value)
        {
            if (User_Value > 999)
            {
                GUI_Translate_Display(MENU_Sprite, Nb_15_douhao, 471u, 255u, GUI_BLENDMODE_SRC_OVER);      /*逗号*/
            }
            else
            {
                GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
            }

            GUI_General_Digit_Display(MENU_Sprite, User_Value , Nb_15_0, 6u, 5u, GUI_SETREP_X, 255u, GUI_BLENDMODE_SRC_OVER);
            GUI_General_Display(MENU_Sprite, CN_User_Menu3_02_km, GUI_BLENDMODE_SRC_OVER);    /*KM*/
        }
        else
        {
            GUI_General_Display(MENU_Sprite, CN_User_Menu3_02_10, GUI_BLENDMODE_SRC_OVER);       /*不设定*/
        }
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_RepSetMenu_3_2_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
void GUI_BG_RepSetMenu_3_2_Display(uint8_t Mode)
{
    uint32_t User_Value = 0u;

    User_Value = User_set_Num.User_RYLQQ; /*显示数据*/

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_General_Display(MENU_Sprite, CN_User_Menu3_02_2, GUI_BLENDMODE_SRC_OVER); /*menu*/

        if (User_Value)
        {
            if (User_Value > 999)
            {
                GUI_Translate_Display(MENU_Sprite, Nb_15_douhao, 471u, 255u, GUI_BLENDMODE_SRC_OVER);      /*逗号*/
            }
            else
            {
                GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
            }

            GUI_General_Digit_Display(MENU_Sprite, User_Value , Nb_15_0, 6u, 5u, GUI_SETREP_X, 255u, GUI_BLENDMODE_SRC_OVER);
            GUI_General_Display(MENU_Sprite, CN_User_Menu3_02_km, GUI_BLENDMODE_SRC_OVER);    /*KM*/
        }
        else
        {
            GUI_General_Display(MENU_Sprite, CN_User_Menu3_02_10, GUI_BLENDMODE_SRC_OVER);       /*不设定*/
        }
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_RepSetMenu_3_3_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
void GUI_BG_RepSetMenu_3_3_Display(uint8_t Mode)
{
    uint32_t User_Value = 0u;

    User_Value = User_set_Num.User_BSXY; /*显示数据*/

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_General_Display(MENU_Sprite, CN_User_Menu3_02_3, GUI_BLENDMODE_SRC_OVER); /*menu*/

        if (User_Value)
        {
            if (User_Value > 999)
            {
                GUI_Translate_Display(MENU_Sprite, Nb_15_douhao, 471u, 255u, GUI_BLENDMODE_SRC_OVER);      /*逗号*/
            }
            else
            {
                GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
            }

            GUI_General_Digit_Display(MENU_Sprite, User_Value, Nb_15_0, 6u, 5u, GUI_SETREP_X, 255u, GUI_BLENDMODE_SRC_OVER);
            GUI_General_Display(MENU_Sprite, CN_User_Menu3_02_km, GUI_BLENDMODE_SRC_OVER);    /*KM*/
        }
        else
        {
            GUI_General_Display(MENU_Sprite, CN_User_Menu3_02_10, GUI_BLENDMODE_SRC_OVER);       /*不设定*/
        }
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_RepSetMenu_3_4_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
void GUI_BG_RepSetMenu_3_4_Display(uint8_t Mode)
{
    uint32_t User_Value = 0u;

    User_Value = User_set_Num.User_CSQY; /*显示数据*/

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_General_Display(MENU_Sprite, CN_User_Menu3_02_4, GUI_BLENDMODE_SRC_OVER); /*menu*/

        if (User_Value)
        {
            if (User_Value > 999)
            {
                GUI_Translate_Display(MENU_Sprite, Nb_15_douhao, 471u, 255u, GUI_BLENDMODE_SRC_OVER);      /*逗号*/
            }
            else
            {
                GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
            }

            GUI_General_Digit_Display(MENU_Sprite, User_Value , Nb_15_0, 6u, 5u, GUI_SETREP_X, 255u, GUI_BLENDMODE_SRC_OVER);
            GUI_General_Display(MENU_Sprite, CN_User_Menu3_02_km, GUI_BLENDMODE_SRC_OVER);    /*KM*/
        }
        else
        {
            GUI_General_Display(MENU_Sprite, CN_User_Menu3_02_10, GUI_BLENDMODE_SRC_OVER);       /*不设定*/
        }
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_RepSetMenu_3_5_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
void GUI_BG_RepSetMenu_3_5_Display(uint8_t Mode)
{
    uint32_t User_Value = 0u;

    //User_Value = User_set_Num.User_CSQY; /*显示数据*/

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_General_Display(MENU_Sprite, CN_User_Menu3_02_5, GUI_BLENDMODE_SRC_OVER); /*menu*/

        if (User_Value)
        {
            if (User_Value > 999)
            {
                GUI_Translate_Display(MENU_Sprite, Nb_15_douhao, 471u, 255u, GUI_BLENDMODE_SRC_OVER);      /*逗号*/
            }
            else
            {
                GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
            }

            GUI_General_Digit_Display(MENU_Sprite, User_Value , Nb_15_0, 6u, 5u, GUI_SETREP_X, 255u, GUI_BLENDMODE_SRC_OVER);
            GUI_General_Display(MENU_Sprite, CN_User_Menu3_02_km, GUI_BLENDMODE_SRC_OVER);    /*KM*/
        }
        else
        {
            GUI_General_Display(MENU_Sprite, CN_User_Menu3_02_10, GUI_BLENDMODE_SRC_OVER);       /*不设定*/
        }
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_RepSetMenu_3_6_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
void GUI_BG_RepSetMenu_3_6_Display(uint8_t Mode)
{
    uint32_t User_Value = 0u;

    User_Value = User_set_Num.User_DLZXY; /*显示数据*/

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_General_Display(MENU_Sprite, CN_User_Menu3_02_7, GUI_BLENDMODE_SRC_OVER); /*menu*/

        if (User_Value)
        {
            if (User_Value > 999u)
            {
                GUI_Translate_Display(MENU_Sprite, Nb_15_douhao, 471u, 255u, GUI_BLENDMODE_SRC_OVER);      /*逗号*/
            }
            else
            {
                GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
            }

            GUI_General_Digit_Display(MENU_Sprite, User_Value , Nb_15_0, 6u, 5u, GUI_SETREP_X, 255u, GUI_BLENDMODE_SRC_OVER);
            GUI_General_Display(MENU_Sprite, CN_User_Menu3_02_km, GUI_BLENDMODE_SRC_OVER);    /*KM*/
        }
        else
        {
            GUI_General_Display(MENU_Sprite, CN_User_Menu3_02_10, GUI_BLENDMODE_SRC_OVER);       /*不设定*/
        }
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_RepSetMenu_3_7_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
void GUI_BG_RepSetMenu_3_7_Display(uint8_t Mode)
{
    uint32_t User_Value = 0u;

    User_Value = User_set_Num.User_LT; /*显示数据*/

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_General_Display(MENU_Sprite, CN_User_Menu3_02_8, GUI_BLENDMODE_SRC_OVER); /*menu*/

        if (User_Value)
        {
            if (User_Value > 999)
            {
                GUI_Translate_Display(MENU_Sprite, Nb_15_douhao, 471u, 255u, GUI_BLENDMODE_SRC_OVER);      /*逗号*/
            }
            else
            {
                GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
            }

            GUI_General_Digit_Display(MENU_Sprite, User_Value , Nb_15_0, 6u, 5u, GUI_SETREP_X, 255u, GUI_BLENDMODE_SRC_OVER);
            GUI_General_Display(MENU_Sprite, CN_User_Menu3_02_km, GUI_BLENDMODE_SRC_OVER);    /*KM*/
        }
        else
        {
            GUI_General_Display(MENU_Sprite, CN_User_Menu3_02_10, GUI_BLENDMODE_SRC_OVER);       /*不设定*/
        }
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_UserSet_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
void GUI_BG_UserSet_Display(uint8_t Mode)
{
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_General_Display(MENU_Sprite, CN_User_Menu3_03_wenzi, GUI_BLENDMODE_SRC_OVER); /*menu*/
        GUI_General_Display(MENU_Sprite, CN_fengexian, GUI_BLENDMODE_SRC_OVER);           /*line*/
        GUI_General_Display(MENU_Sprite, CN_white_queding, GUI_BLENDMODE_SRC_OVER);       /*enter*/
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_UserSet_Date_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
void GUI_BG_UserSet_Date_Display(uint8_t Mode)
{
    uint16_t YEAR_Value = 0u;
    uint8_t MOnth_Value = 0u;
    uint8_t Data_Value = 0u;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        YEAR_Value = User_set_Num.Year;
        MOnth_Value = User_set_Num.Month;
        Data_Value = User_set_Num.Date;

        GUI_General_Display(MENU_Sprite, CN_User_Menu3_03_nian, GUI_BLENDMODE_SRC_OVER); /*年*/
        GUI_General_Display(MENU_Sprite, CN_User_Menu3_03_yue, GUI_BLENDMODE_SRC_OVER);  /*月*/
        GUI_General_Display(MENU_Sprite, CN_User_Menu3_03_ri, GUI_BLENDMODE_SRC_OVER);   /*日*/

        switch (bCurMenuIDX)
        {
        case _MN_DSP_LEVEL3_4_MENU_11:
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_yellowkuang, 329u, 214u, GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_greykuang, 434u, 214u, GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_greykuang, 541u, 214u, GUI_BLENDMODE_SRC_OVER);
            break;

        case _MN_DSP_LEVEL3_4_MENU_12:
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_greykuang, 329u, 214u, GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_yellowkuang, 434u, 214u, GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_greykuang, 541u, 214u, GUI_BLENDMODE_SRC_OVER);
            break;

        case _MN_DSP_LEVEL3_4_MENU_13:
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_greykuang, 329u, 214u, GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_greykuang, 434u, 214u, GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_yellowkuang, 541u, 214u, GUI_BLENDMODE_SRC_OVER);
            break;

        default:
            break;
        }

        GUI_General_Digit_Display(MENU_Sprite, 20u, Nb_20_0, 2u, 0u, GUIUsetSetYPos, 226u, GUI_BLENDMODE_SRC_OVER);
        GUI_General_Digit_Display(MENU_Sprite, YEAR_Value, Nb_20_0, 2u, 0u, GUIUsetSetYPosX, 226u, GUI_BLENDMODE_SRC_OVER);

        GUI_General_Digit_Display(MENU_Sprite, MOnth_Value, Nb_20_0, 2u, 0u, GUIUsetSetMPosX, 226u, GUI_BLENDMODE_SRC_OVER);

        GUI_General_Digit_Display(MENU_Sprite, Data_Value, Nb_20_0, 2u, 0u, GUIUsetSetDPosX, 226u, GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_UserSet_Time_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
void GUI_BG_UserSet_Time_Display(uint8_t Mode)
{
    uint8_t Hour_Value = 0u;
    uint8_t Minute_Value = 0u;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        Hour_Value = User_set_Num.Hour;
        Minute_Value = User_set_Num.Minute;

        GUI_Translate_Display(MENU_Sprite, Nb_20_maohao, 440u, 218u, GUI_BLENDMODE_SRC_OVER); /*冒号*/

        switch (bCurMenuIDX)
        {
        case _MN_DSP_LEVEL3_4_MENU_21:
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_yellowkuang, 384u, 214u, GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_greykuang, 458u, 214u, GUI_BLENDMODE_SRC_OVER);

            break;

        case _MN_DSP_LEVEL3_4_MENU_22:
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_greykuang, 384u, 214u, GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_yellowkuang, 458u, 214u, GUI_BLENDMODE_SRC_OVER);

            break;

        default:
            break;
        }

        GUI_General_Digit_Display(MENU_Sprite, Hour_Value, Nb_20_0, 2u, 0u, GUIUsetSetHPosX, 226u, GUI_BLENDMODE_SRC_OVER);

        GUI_General_Digit_Display(MENU_Sprite, Minute_Value, Nb_20_0, 2u, 0u, GUIUsetSetMiPosX, 226u, GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_UserSet_Language_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
void GUI_BG_UserSet_Language_Display(uint8_t Mode)
{
    uint8_t Options_Val = 0u;
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        Options_Val = User_set_Num.User_Language;
        /*英语*/
        if (Options_Val == Language_En)
        {
            GUI_General_Display(MENU_Sprite, CN_User_Menu3_03_19black, GUI_BLENDMODE_SRC_OVER);
        }
        else
        {
            GUI_General_Display(MENU_Sprite, CN_User_Menu3_03_19white, GUI_BLENDMODE_SRC_OVER);
        }

        /*汉语*/
        if (Options_Val == Language_Cn)
        {
            GUI_General_Display(MENU_Sprite, CN_User_Menu3_03_20black, GUI_BLENDMODE_SRC_OVER);
        }
        else
        {
            GUI_General_Display(MENU_Sprite, CN_User_Menu3_03_20white, GUI_BLENDMODE_SRC_OVER);
        }
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_UserSet_SYSD_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
void GUI_BG_UserSet_SYSD_Display(uint8_t Mode)
{
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_General_Display(MENU_Sprite, CN_User_Menu3_03_wenzi, GUI_BLENDMODE_SRC_OVER); /*menu*/
        GUI_General_Display(MENU_Sprite, CN_fengexian, GUI_BLENDMODE_SRC_OVER);           /*line*/
        GUI_General_Display(MENU_Sprite, CN_gundongtiao, GUI_BLENDMODE_SRC_OVER);         /*长度条*/

        if (bCurMenuIDX <= _MN_DSP_LEVEL3_4_MENU_44)
        {
            if (bCurMenuIDX != _MN_DSP_LEVEL3_4_MENU_41)
            {
                GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_7white, 225u, GUI_DISP_MENU_Y[0u], GUI_BLENDMODE_SRC_OVER);
            }
            if (bCurMenuIDX != _MN_DSP_LEVEL3_4_MENU_42)
            {
                GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_8white, 225u, GUI_DISP_MENU_Y[1u], GUI_BLENDMODE_SRC_OVER);
            }
            if (bCurMenuIDX != _MN_DSP_LEVEL3_4_MENU_43)
            {
                GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_9white, 225u, GUI_DISP_MENU_Y[2u], GUI_BLENDMODE_SRC_OVER);
            }
            if (bCurMenuIDX != _MN_DSP_LEVEL3_4_MENU_44)
            {
                GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_10white, 225u, GUI_DISP_MENU_Y[3u], GUI_BLENDMODE_SRC_OVER);
            }
        }
        else if (bCurMenuIDX == _MN_DSP_LEVEL3_4_MENU_45)
        {
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_8white, 225u, GUI_DISP_MENU_Y[0u], GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_9white, 225u, GUI_DISP_MENU_Y[1u], GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_10white, 225u, GUI_DISP_MENU_Y[2u], GUI_BLENDMODE_SRC_OVER);
        }
        else if (bCurMenuIDX == _MN_DSP_LEVEL3_4_MENU_46)
        {
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_9white, 225u, GUI_DISP_MENU_Y[0u], GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_10white, 225u, GUI_DISP_MENU_Y[1u], GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_11white, 225u, GUI_DISP_MENU_Y[2u], GUI_BLENDMODE_SRC_OVER);
        }
        else
        {
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_10white, 225u, GUI_DISP_MENU_Y[0u], GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_11white, 225u, GUI_DISP_MENU_Y[1u], GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_23white, 225u, GUI_DISP_MENU_Y[2u], GUI_BLENDMODE_SRC_OVER);
        }
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_UserSet_SYSD_1_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
void GUI_BG_UserSet_SYSD_1_Display(uint8_t Mode)
{
    uint8_t Flag = 0;
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_Translate_Display(MENU_Sprite, (CN_User_Menu3_03_7black + Flag), 225u, GUI_DISP_MENU_Y[0u], GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_UserSet_SYSD_2_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
void GUI_BG_UserSet_SYSD_2_Display(uint8_t Mode)
{
    uint8_t Flag = 0;
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_Translate_Display(MENU_Sprite, (CN_User_Menu3_03_8black + Flag), 225u, GUI_DISP_MENU_Y[1u], GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_UserSet_SYSD_3_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
void GUI_BG_UserSet_SYSD_3_Display(uint8_t Mode)
{
    uint8_t Flag = 0;
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_Translate_Display(MENU_Sprite, (CN_User_Menu3_03_9black + Flag), 225u, GUI_DISP_MENU_Y[2u], GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_UserSet_SYSD_4_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
void GUI_BG_UserSet_SYSD_4_Display(uint8_t Mode)
{
    uint8_t Flag = 0;
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_Translate_Display(MENU_Sprite, (CN_User_Menu3_03_10black + Flag), 225u, GUI_DISP_MENU_Y[3u], GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_UserSet_SYSD_5_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
void GUI_BG_UserSet_SYSD_5_Display(uint8_t Mode)
{
    uint8_t Flag = 0;
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_Translate_Display(MENU_Sprite, (CN_User_Menu3_03_11black + Flag), 225u, GUI_DISP_MENU_Y[3u], GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_UserSet_SYSD_6_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
void GUI_BG_UserSet_SYSD_6_Display(uint8_t Mode)
{
    uint8_t Flag = 0;
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_Translate_Display(MENU_Sprite, (CN_User_Menu3_03_23black + Flag), 225u, GUI_DISP_MENU_Y[3u], GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_UserSet_SYSD_7_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
void GUI_BG_UserSet_SYSD_7_Display(uint8_t Mode)
{
    uint8_t Flag = 0;
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_Translate_Display(MENU_Sprite, (CN_User_Menu3_03_24black + Flag), 225u, GUI_DISP_MENU_Y[3u], GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_TPMS_PictureSet_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
void GUI_BG_TPMS_PictureSet_Display(uint8_t Mode)
{
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_General_Display(MENU_Sprite, CN_User_Menu3_03_che, GUI_BLENDMODE_SRC_OVER); /*车*/

        /*0x12*/
        GUI_General_Display(MENU_Sprite, CN_User_Menu3_03_0x12, GUI_BLENDMODE_SRC_OVER); /*0x12*/

        if (User_set_Num.User_Tpms == 1u)
        {
            if (User_set_Num.User_TpmsStatus == 1u)
            {
                GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai3, GUI_TPMS_PIC_X[0u], GUI_TPMS_PIC_Y[3u], GUI_BLENDMODE_CUSTOM);
            }
            else if (User_set_Num.User_TpmsStatus == 2u)
            {
                GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai1, GUI_TPMS_PIC_X[0u], GUI_TPMS_PIC_Y[3u], GUI_BLENDMODE_CUSTOM);

                if (FLASH_SYNC_1Hz)
                {
                    GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai_guang, GUI_TPMS_PIC_X[0u], GUI_TPMS_PIC_Y[3u], GUI_BLENDMODE_CUSTOM);
                }
                else
                {
                    GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_CUSTOM);
                }
            }
            else
            {
                if (TPMS_Matching.T01 == 1u)
                {
                    GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai1, GUI_TPMS_PIC_X[0u], GUI_TPMS_PIC_Y[3u], GUI_BLENDMODE_CUSTOM);
                }
                else
                {
                    GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai2, GUI_TPMS_PIC_X[0u], GUI_TPMS_PIC_Y[3u], GUI_BLENDMODE_CUSTOM);
                }
            }
        }
        else
        {
            if (TPMS_Matching.T01 == 1u)
            {
                GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai1, GUI_TPMS_PIC_X[0u], GUI_TPMS_PIC_Y[3u], GUI_BLENDMODE_CUSTOM);
            }
            else
            {
                GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai2, GUI_TPMS_PIC_X[0u], GUI_TPMS_PIC_Y[3u], GUI_BLENDMODE_CUSTOM);
            }
        }

        /*0x13*/
        GUI_General_Display(MENU_Sprite, CN_User_Menu3_03_0x13, GUI_BLENDMODE_SRC_OVER); /*0x13*/

        if (User_set_Num.User_Tpms == 2u)
        {
            if (User_set_Num.User_TpmsStatus == 1u)
            {
                GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai3, GUI_TPMS_PIC_X[0u], GUI_TPMS_PIC_Y[0u], GUI_BLENDMODE_CUSTOM);
            }
            else if (User_set_Num.User_TpmsStatus == 2u)
            {
                GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai1, GUI_TPMS_PIC_X[0u], GUI_TPMS_PIC_Y[0u], GUI_BLENDMODE_CUSTOM);

                if (FLASH_SYNC_1Hz)
                {
                    GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai_guang, GUI_TPMS_PIC_X[0u], GUI_TPMS_PIC_Y[0u], GUI_BLENDMODE_CUSTOM);
                }
                else
                {
                    GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_CUSTOM);
                }
            }
            else
            {
                if (TPMS_Matching.T02 == 1u)
                {
                    GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai1, GUI_TPMS_PIC_X[0u], GUI_TPMS_PIC_Y[0u], GUI_BLENDMODE_CUSTOM);
                }
                else
                {
                    GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai2, GUI_TPMS_PIC_X[0u], GUI_TPMS_PIC_Y[0u], GUI_BLENDMODE_CUSTOM);
                }
            }
        }
        else
        {
            if (TPMS_Matching.T02 == 1u)
            {
                GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai1, GUI_TPMS_PIC_X[0u], GUI_TPMS_PIC_Y[0u], GUI_BLENDMODE_CUSTOM);
            }
            else
            {
                GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai2, GUI_TPMS_PIC_X[0u], GUI_TPMS_PIC_Y[0u], GUI_BLENDMODE_CUSTOM);
            }
        }

        /*0x22*/
        GUI_General_Display(MENU_Sprite, CN_User_Menu3_03_0x22, GUI_BLENDMODE_SRC_OVER); /*0x22*/

        if (User_set_Num.User_Tpms == 3u)
        {
            if (User_set_Num.User_TpmsStatus == 1u)
            {
                GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai3, GUI_TPMS_PIC_X[1u], GUI_TPMS_PIC_Y[3u], GUI_BLENDMODE_CUSTOM);
            }
            else if (User_set_Num.User_TpmsStatus == 2u)
            {
                GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai1, GUI_TPMS_PIC_X[1u], GUI_TPMS_PIC_Y[3u], GUI_BLENDMODE_CUSTOM);

                if (FLASH_SYNC_1Hz)
                {
                    GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai_guang, GUI_TPMS_PIC_X[1u], GUI_TPMS_PIC_Y[3u], GUI_BLENDMODE_CUSTOM);
                }
                else
                {
                    GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_CUSTOM);
                }
            }
            else
            {
                if (TPMS_Matching.T03 == 1u)
                {
                    GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai1, GUI_TPMS_PIC_X[1u], GUI_TPMS_PIC_Y[3u], GUI_BLENDMODE_CUSTOM);
                }
                else
                {
                    GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai2, GUI_TPMS_PIC_X[1u], GUI_TPMS_PIC_Y[3u], GUI_BLENDMODE_CUSTOM);
                }
            }
        }
        else
        {
            if (TPMS_Matching.T03 == 1u)
            {
                GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai1, GUI_TPMS_PIC_X[1u], GUI_TPMS_PIC_Y[3u], GUI_BLENDMODE_CUSTOM);
            }
            else
            {
                GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai2, GUI_TPMS_PIC_X[1u], GUI_TPMS_PIC_Y[3u], GUI_BLENDMODE_CUSTOM);
            }
        }

        /*0x23*/
        GUI_General_Display(MENU_Sprite, CN_User_Menu3_03_0x23, GUI_BLENDMODE_SRC_OVER); /*0x23*/

        if (User_set_Num.User_Tpms == 4u)
        {
            if (User_set_Num.User_TpmsStatus == 1u)
            {
                GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai3, GUI_TPMS_PIC_X[1u], GUI_TPMS_PIC_Y[0u], GUI_BLENDMODE_CUSTOM);
            }
            else if (User_set_Num.User_TpmsStatus == 2u)
            {
                GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai1, GUI_TPMS_PIC_X[1u], GUI_TPMS_PIC_Y[0u], GUI_BLENDMODE_CUSTOM);

                if (FLASH_SYNC_1Hz)
                {
                    GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai_guang, GUI_TPMS_PIC_X[1u], GUI_TPMS_PIC_Y[0u], GUI_BLENDMODE_CUSTOM);
                }
                else
                {
                    GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_CUSTOM);
                }
            }
            else
            {
                if (TPMS_Matching.T04 == 1u)
                {
                    GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai1, GUI_TPMS_PIC_X[1u], GUI_TPMS_PIC_Y[0u], GUI_BLENDMODE_CUSTOM);
                }
                else
                {
                    GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai2, GUI_TPMS_PIC_X[1u], GUI_TPMS_PIC_Y[0u], GUI_BLENDMODE_CUSTOM);
                }
            }
        }
        else
        {
            if (TPMS_Matching.T04 == 1u)
            {
                GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai1, GUI_TPMS_PIC_X[1u], GUI_TPMS_PIC_Y[0u], GUI_BLENDMODE_CUSTOM);
            }
            else
            {
                GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai2, GUI_TPMS_PIC_X[1u], GUI_TPMS_PIC_Y[0u], GUI_BLENDMODE_CUSTOM);
            }
        }

        /*0x31*/
        GUI_General_Display(MENU_Sprite, CN_User_Menu3_03_0x31, GUI_BLENDMODE_SRC_OVER); /*0x31*/

        if (User_set_Num.User_Tpms == 5u)
        {
            if (User_set_Num.User_TpmsStatus == 1u)
            {
                GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai3, GUI_TPMS_PIC_X[2u], GUI_TPMS_PIC_Y[3u], GUI_BLENDMODE_CUSTOM);
            }
            else if (User_set_Num.User_TpmsStatus == 2u)
            {
                GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai1, GUI_TPMS_PIC_X[2u], GUI_TPMS_PIC_Y[3u], GUI_BLENDMODE_CUSTOM);

                if (FLASH_SYNC_1Hz)
                {
                    GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai_guang, GUI_TPMS_PIC_X[2u], GUI_TPMS_PIC_Y[3u], GUI_BLENDMODE_CUSTOM);
                }
                else
                {
                    GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_CUSTOM);
                }
            }
            else
            {
                if (TPMS_Matching.T05 == 1u)
                {
                    GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai1, GUI_TPMS_PIC_X[2u], GUI_TPMS_PIC_Y[3u], GUI_BLENDMODE_CUSTOM);
                }
                else
                {
                    GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai2, GUI_TPMS_PIC_X[2u], GUI_TPMS_PIC_Y[3u], GUI_BLENDMODE_CUSTOM);
                }
            }
        }
        else
        {
            if (TPMS_Matching.T05 == 1u)
            {
                GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai1, GUI_TPMS_PIC_X[2u], GUI_TPMS_PIC_Y[3u], GUI_BLENDMODE_CUSTOM);
            }
            else
            {
                GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai2, GUI_TPMS_PIC_X[2u], GUI_TPMS_PIC_Y[3u], GUI_BLENDMODE_CUSTOM);
            }
        }

        /*0x32*/
        GUI_General_Display(MENU_Sprite, CN_User_Menu3_03_0x32, GUI_BLENDMODE_SRC_OVER); /*0x32*/

        if (User_set_Num.User_Tpms == 6u)
        {
            if (User_set_Num.User_TpmsStatus == 1u)
            {
                GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai3, GUI_TPMS_PIC_X[2u], GUI_TPMS_PIC_Y[2u], GUI_BLENDMODE_CUSTOM);
            }
            else if (User_set_Num.User_TpmsStatus == 2u)
            {
                GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai1, GUI_TPMS_PIC_X[2u], GUI_TPMS_PIC_Y[2u], GUI_BLENDMODE_CUSTOM);

                if (FLASH_SYNC_1Hz)
                {
                    GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai_guang, GUI_TPMS_PIC_X[2u], GUI_TPMS_PIC_Y[2u], GUI_BLENDMODE_CUSTOM);
                }
                else
                {
                    GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_CUSTOM);
                }
            }
            else
            {
                if (TPMS_Matching.T06 == 1u)
                {
                    GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai1, GUI_TPMS_PIC_X[2u], GUI_TPMS_PIC_Y[2u], GUI_BLENDMODE_CUSTOM);
                }
                else
                {
                    GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai2, GUI_TPMS_PIC_X[2u], GUI_TPMS_PIC_Y[2u], GUI_BLENDMODE_CUSTOM);
                }
            }
        }
        else
        {
            if (TPMS_Matching.T06 == 1u)
            {
                GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai1, GUI_TPMS_PIC_X[2u], GUI_TPMS_PIC_Y[2u], GUI_BLENDMODE_CUSTOM);
            }
            else
            {
                GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai2, GUI_TPMS_PIC_X[2u], GUI_TPMS_PIC_Y[2u], GUI_BLENDMODE_CUSTOM);
            }
        }

        /*0x33*/
        GUI_General_Display(MENU_Sprite, CN_User_Menu3_03_0x33, GUI_BLENDMODE_SRC_OVER); /*0x33*/

        if (User_set_Num.User_Tpms == 7u)
        {
            if (User_set_Num.User_TpmsStatus == 1u)
            {
                GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai3, GUI_TPMS_PIC_X[2u], GUI_TPMS_PIC_Y[1u], GUI_BLENDMODE_CUSTOM);
            }
            else if (User_set_Num.User_TpmsStatus == 2u)
            {
                GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai1, GUI_TPMS_PIC_X[2u], GUI_TPMS_PIC_Y[1u], GUI_BLENDMODE_CUSTOM);

                if (FLASH_SYNC_1Hz)
                {
                    GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai_guang, GUI_TPMS_PIC_X[2u], GUI_TPMS_PIC_Y[1u], GUI_BLENDMODE_CUSTOM);
                }
                else
                {
                    GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_CUSTOM);
                }
            }
            else
            {
                if (TPMS_Matching.T07 == 1u)
                {
                    GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai1, GUI_TPMS_PIC_X[2u], GUI_TPMS_PIC_Y[1u], GUI_BLENDMODE_CUSTOM);
                }
                else
                {
                    GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai2, GUI_TPMS_PIC_X[2u], GUI_TPMS_PIC_Y[1u], GUI_BLENDMODE_CUSTOM);
                }
            }
        }
        else
        {
            if (TPMS_Matching.T07 == 1u)
            {
                GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai1, GUI_TPMS_PIC_X[2u], GUI_TPMS_PIC_Y[1u], GUI_BLENDMODE_CUSTOM);
            }
            else
            {
                GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai2, GUI_TPMS_PIC_X[2u], GUI_TPMS_PIC_Y[1u], GUI_BLENDMODE_CUSTOM);
            }
        }

        /*0x34*/
        GUI_General_Display(MENU_Sprite, CN_User_Menu3_03_0x34, GUI_BLENDMODE_SRC_OVER); /*0x34*/

        if (User_set_Num.User_Tpms == 8u)
        {
            if (User_set_Num.User_TpmsStatus == 1u)
            {
                GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai3, GUI_TPMS_PIC_X[2u], GUI_TPMS_PIC_Y[0u], GUI_BLENDMODE_CUSTOM);
            }
            else if (User_set_Num.User_TpmsStatus == 2u)
            {
                GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai1, GUI_TPMS_PIC_X[2u], GUI_TPMS_PIC_Y[0u], GUI_BLENDMODE_CUSTOM);

                if (FLASH_SYNC_1Hz)
                {
                    GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai_guang, GUI_TPMS_PIC_X[2u], GUI_TPMS_PIC_Y[0u], GUI_BLENDMODE_CUSTOM);
                }
                else
                {
                    GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_CUSTOM);
                }
            }
            else
            {
                if (TPMS_Matching.T08 == 1u)
                {
                    GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai1, GUI_TPMS_PIC_X[2u], GUI_TPMS_PIC_Y[0u], GUI_BLENDMODE_CUSTOM);
                }
                else
                {
                    GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai2, GUI_TPMS_PIC_X[2u], GUI_TPMS_PIC_Y[0u], GUI_BLENDMODE_CUSTOM);
                }
            }
        }
        else
        {
            if (TPMS_Matching.T08 == 1u)
            {
                GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai1, GUI_TPMS_PIC_X[2u], GUI_TPMS_PIC_Y[0u], GUI_BLENDMODE_CUSTOM);
            }
            else
            {
                GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai2, GUI_TPMS_PIC_X[2u], GUI_TPMS_PIC_Y[0u], GUI_BLENDMODE_CUSTOM);
            }
        }

        /*0x41*/
        GUI_General_Display(MENU_Sprite, CN_User_Menu3_03_0x41, GUI_BLENDMODE_SRC_OVER); /*0x41*/

        if (User_set_Num.User_Tpms == 9u)
        {
            if (User_set_Num.User_TpmsStatus == 1u)
            {
                GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai3, GUI_TPMS_PIC_X[3u], GUI_TPMS_PIC_Y[3u], GUI_BLENDMODE_CUSTOM);
            }
            else if (User_set_Num.User_TpmsStatus == 2u)
            {
                GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai1, GUI_TPMS_PIC_X[3u], GUI_TPMS_PIC_Y[3u], GUI_BLENDMODE_CUSTOM);

                if (FLASH_SYNC_1Hz)
                {
                    GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai_guang, GUI_TPMS_PIC_X[3u], GUI_TPMS_PIC_Y[3u], GUI_BLENDMODE_CUSTOM);
                }
                else
                {
                    GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_CUSTOM);
                }
            }
            else
            {
                if (TPMS_Matching.T09 == 1u)
                {
                    GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai1, GUI_TPMS_PIC_X[3u], GUI_TPMS_PIC_Y[3u], GUI_BLENDMODE_CUSTOM);
                }
                else
                {
                    GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai2, GUI_TPMS_PIC_X[3u], GUI_TPMS_PIC_Y[3u], GUI_BLENDMODE_CUSTOM);
                }
            }
        }
        else
        {
            if (TPMS_Matching.T09 == 1u)
            {
                GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai1, GUI_TPMS_PIC_X[3u], GUI_TPMS_PIC_Y[3u], GUI_BLENDMODE_CUSTOM);
            }
            else
            {
                GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai2, GUI_TPMS_PIC_X[3u], GUI_TPMS_PIC_Y[3u], GUI_BLENDMODE_CUSTOM);
            }
        }

        /*0x42*/
        GUI_General_Display(MENU_Sprite, CN_User_Menu3_03_0x42, GUI_BLENDMODE_SRC_OVER); /*0x42*/

        if (User_set_Num.User_Tpms == 10u)
        {
            if (User_set_Num.User_TpmsStatus == 1u)
            {
                GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai3, GUI_TPMS_PIC_X[3u], GUI_TPMS_PIC_Y[2u], GUI_BLENDMODE_CUSTOM);
            }
            else if (User_set_Num.User_TpmsStatus == 2u)
            {
                GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai1, GUI_TPMS_PIC_X[3u], GUI_TPMS_PIC_Y[2u], GUI_BLENDMODE_CUSTOM);

                if (FLASH_SYNC_1Hz)
                {
                    GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai_guang, GUI_TPMS_PIC_X[3u], GUI_TPMS_PIC_Y[2u], GUI_BLENDMODE_CUSTOM);
                }
                else
                {
                    GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_CUSTOM);
                }
            }
            else
            {
                if (TPMS_Matching.T10 == 1u)
                {
                    GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai1, GUI_TPMS_PIC_X[3u], GUI_TPMS_PIC_Y[2u], GUI_BLENDMODE_CUSTOM);
                }
                else
                {
                    GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai2, GUI_TPMS_PIC_X[3u], GUI_TPMS_PIC_Y[2u], GUI_BLENDMODE_CUSTOM);
                }
            }
        }
        else
        {
            if (TPMS_Matching.T10 == 1u)
            {
                GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai1, GUI_TPMS_PIC_X[3u], GUI_TPMS_PIC_Y[2u], GUI_BLENDMODE_CUSTOM);
            }
            else
            {
                GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai2, GUI_TPMS_PIC_X[3u], GUI_TPMS_PIC_Y[2u], GUI_BLENDMODE_CUSTOM);
            }
        }

        /*0x43*/
        GUI_General_Display(MENU_Sprite, CN_User_Menu3_03_0x43, GUI_BLENDMODE_SRC_OVER); /*0x43*/

        if (User_set_Num.User_Tpms == 11u)
        {
            if (User_set_Num.User_TpmsStatus == 1u)
            {
                GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai3, GUI_TPMS_PIC_X[3u], GUI_TPMS_PIC_Y[1u], GUI_BLENDMODE_CUSTOM);
            }
            else if (User_set_Num.User_TpmsStatus == 2u)
            {
                GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai1, GUI_TPMS_PIC_X[3u], GUI_TPMS_PIC_Y[1u], GUI_BLENDMODE_CUSTOM);

                if (FLASH_SYNC_1Hz)
                {
                    GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai_guang, GUI_TPMS_PIC_X[3u], GUI_TPMS_PIC_Y[1u], GUI_BLENDMODE_CUSTOM);
                }
                else
                {
                    GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_CUSTOM);
                }
            }
            else
            {
                if (TPMS_Matching.T11 == 1u)
                {
                    GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai1, GUI_TPMS_PIC_X[3u], GUI_TPMS_PIC_Y[1u], GUI_BLENDMODE_CUSTOM);
                }
                else
                {
                    GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai2, GUI_TPMS_PIC_X[3u], GUI_TPMS_PIC_Y[1u], GUI_BLENDMODE_CUSTOM);
                }
            }
        }
        else
        {
            if (TPMS_Matching.T11 == 1u)
            {
                GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai1, GUI_TPMS_PIC_X[3u], GUI_TPMS_PIC_Y[1u], GUI_BLENDMODE_CUSTOM);
            }
            else
            {
                GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai2, GUI_TPMS_PIC_X[3u], GUI_TPMS_PIC_Y[1u], GUI_BLENDMODE_CUSTOM);
            }
        }

        /*0x44*/
        GUI_General_Display(MENU_Sprite, CN_User_Menu3_03_0x44, GUI_BLENDMODE_SRC_OVER); /*0x44*/

        if (User_set_Num.User_Tpms == 12u)
        {
            if (User_set_Num.User_TpmsStatus == 1u)
            {
                GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai3, GUI_TPMS_PIC_X[3u], GUI_TPMS_PIC_Y[0u], GUI_BLENDMODE_CUSTOM);
            }
            else if (User_set_Num.User_TpmsStatus == 2u)
            {
                GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai1, GUI_TPMS_PIC_X[3u], GUI_TPMS_PIC_Y[0u], GUI_BLENDMODE_CUSTOM);

                if (FLASH_SYNC_1Hz)
                {
                    GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai_guang, GUI_TPMS_PIC_X[3u], GUI_TPMS_PIC_Y[0u], GUI_BLENDMODE_CUSTOM);
                }
                else
                {
                    GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_CUSTOM);
                }
            }
            else
            {
                if (TPMS_Matching.T12 == 1u)
                {
                    GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai1, GUI_TPMS_PIC_X[3u], GUI_TPMS_PIC_Y[0u], GUI_BLENDMODE_CUSTOM);
                }
                else
                {
                    GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai2, GUI_TPMS_PIC_X[3u], GUI_TPMS_PIC_Y[0u], GUI_BLENDMODE_CUSTOM);
                }
            }
        }
        else
        {
            if (TPMS_Matching.T12 == 1u)
            {
                GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai1, GUI_TPMS_PIC_X[3u], GUI_TPMS_PIC_Y[0u], GUI_BLENDMODE_CUSTOM);
            }
            else
            {
                GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_luntai2, GUI_TPMS_PIC_X[3u], GUI_TPMS_PIC_Y[0u], GUI_BLENDMODE_CUSTOM);
            }
        }

        /*清楚闪烁*/
        if (User_set_Num.User_TpmsStatus != 2)
        {
            GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
        }
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_UserSet_SYSD_GSL_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_UserSet_SYSD_GSL_Display(uint8_t Mode)
{
    uint32_t User_Value = 0u;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        User_Value = User_set_Num.User_Gsl;

        GUI_General_Display(MENU_Sprite, CN_User_Menu3_03_12, GUI_BLENDMODE_SRC_OVER);/*Menu*/
        GUI_General_Display(MENU_Sprite, CN_User_Menu3_03_kuang, GUI_BLENDMODE_SRC_OVER);/*框*/

        if (User_Value != 0xFF)
        {
            GUI_General_Digit_Display(MENU_Sprite, User_Value, Nb_15_0, 4u, 3u, GUI_SYSSET_X, 255u, GUI_BLENDMODE_SRC_OVER);/*数字*/
            GUI_General_Display(MENU_Sprite, CN_User_Menu3_03_kmh, GUI_BLENDMODE_SRC_OVER);/*km/h*/
        }
        else
        {
            GUI_General_Display(MENU_Sprite, CN_User_Menu3_03_22, GUI_BLENDMODE_SRC_OVER); /*不设定*/
        }
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_UserSet_SYSD_Ybl_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_UserSet_SYSD_Ybl_Display(uint8_t Mode)
{
    uint32_t User_Value = 0u;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        User_Value = User_set_Num.User_Ybl;

        GUI_General_Display(MENU_Sprite, CN_User_Menu3_03_13, GUI_BLENDMODE_SRC_OVER);/*Menu*/
        GUI_General_Display(MENU_Sprite, CN_User_Menu3_03_kuang, GUI_BLENDMODE_SRC_OVER);/*框*/

        if (User_Value != 0xFF)
        {
            GUI_General_Digit_Display(MENU_Sprite, User_Value, Nb_15_0, 4u, 3u, GUI_SYSSET_X, 255u, GUI_BLENDMODE_SRC_OVER);/*数字*/
            GUI_General_Display(MENU_Sprite, CN_User_Menu3_03_kmh, GUI_BLENDMODE_SRC_OVER);/*km/h*/
        }
        else
        {
            GUI_General_Display(MENU_Sprite, CN_User_Menu3_03_22, GUI_BLENDMODE_SRC_OVER); /*不设定*/
        }
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_UserSet_SYSD_Speed_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_UserSet_SYSD_Speed_Display(uint8_t Mode)
{
    uint32_t User_Value = 0u;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        User_Value = User_set_Num.User_Speed;

        GUI_General_Display(MENU_Sprite, CN_User_Menu3_03_14, GUI_BLENDMODE_SRC_OVER);/*Menu*/
        GUI_General_Display(MENU_Sprite, CN_User_Menu3_03_kuang, GUI_BLENDMODE_SRC_OVER);/*框*/

        if (User_Value != 0xFF)
        {
            if (User_Value != 0u)
            {
                GUI_Translate_Display(MENU_Sprite, Nb_15_0, 520u, 255u, GUI_BLENDMODE_CUSTOM);
                GUI_Translate_Display(MENU_Sprite, Nb_15_0, 503u, 255u, GUI_BLENDMODE_CUSTOM);
                GUI_General_Digit_Display(MENU_Sprite, User_Value, Nb_15_0, 2u, 1u, GUI_SYSSPEED, 255u, GUI_BLENDMODE_SRC_OVER);/*数字*/
            }
            else
            {
                GUI_General_Digit_Display(MENU_Sprite, User_Value, Nb_15_0, 4u, 3u, GUI_SYSSET_X, 255u, GUI_BLENDMODE_SRC_OVER);/*数字*/
            }

            GUI_General_Display(MENU_Sprite, CN_User_Menu3_03_rpm, GUI_BLENDMODE_SRC_OVER);/*rmp*/
        }
        else
        {
            GUI_General_Display(MENU_Sprite, CN_User_Menu3_03_22, GUI_BLENDMODE_SRC_OVER); /*不设定*/
        }
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_UserSet_SYSD_JADD_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_UserSet_SYSD_JADD_Display(uint8_t Mode)
{
    uint32_t User_Value = 0u;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        User_Value = User_set_Num.User_JADD;

        GUI_General_Display(MENU_Sprite, CN_User_Menu3_03_15, GUI_BLENDMODE_SRC_OVER);/*Menu*/
        GUI_General_Display(MENU_Sprite, CN_User_Menu3_03_kuang, GUI_BLENDMODE_SRC_OVER);/*框*/

        if (User_Value != 0xFF)
        {
            GUI_General_Digit_Display(MENU_Sprite, User_Value, Nb_15_0, 2u, 0u, GUI_SYSJDD_X, 251u, GUI_BLENDMODE_SRC_OVER);/*数字*/
            GUI_Translate_Display(MENU_Sprite, Nb_15_dian, 454u, 254u, GUI_BLENDMODE_CUSTOM);/*dot*/
            GUI_General_Display(MENU_Sprite, CN_User_Menu3_03_ms2, GUI_BLENDMODE_SRC_OVER);/*m/s2*/
        }
        else
        {
            GUI_General_Display(MENU_Sprite, CN_User_Menu3_03_22, GUI_BLENDMODE_SRC_OVER); /*不设定*/
        }
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_UserSet_SYSD_JSUB_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_UserSet_SYSD_JSUB_Display(uint8_t Mode)
{
    uint32_t User_Value = 0u;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        User_Value = User_set_Num.User_JSUB;

        GUI_General_Display(MENU_Sprite, CN_User_Menu3_03_16, GUI_BLENDMODE_SRC_OVER);/*Menu*/
        GUI_General_Display(MENU_Sprite, CN_User_Menu3_03_kuang, GUI_BLENDMODE_SRC_OVER);/*框*/

        if (User_Value != 0xFF)
        {
            GUI_General_Digit_Display(MENU_Sprite, User_Value, Nb_15_0, 2u, 0u, GUI_SYSJDD_X, 251u, GUI_BLENDMODE_SRC_OVER);/*数字*/
            GUI_Translate_Display(MENU_Sprite, Nb_15_dian, 454u, 254u, GUI_BLENDMODE_CUSTOM);/*dot*/
            GUI_General_Display(MENU_Sprite, CN_User_Menu3_03_ms2, GUI_BLENDMODE_SRC_OVER);/*m/s2*/
        }
        else
        {
            GUI_General_Display(MENU_Sprite, CN_User_Menu3_03_22, GUI_BLENDMODE_SRC_OVER); /*不设定*/
        }
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_UserSet_SYSD_IDLING_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_UserSet_SYSD_IDLING_Display(uint8_t Mode)
{
    uint32_t User_Value = 0u;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        User_Value = User_set_Num.User_IDLING;

        GUI_General_Display(MENU_Sprite, CN_User_Menu3_03_25, GUI_BLENDMODE_SRC_OVER);/*Menu*/
        GUI_General_Display(MENU_Sprite, CN_User_Menu3_03_kuang, GUI_BLENDMODE_SRC_OVER);/*框*/

        if (User_Value == 0u) /*0x00-设定   0xFF-不设定*/
        {
            GUI_General_Display(MENU_Sprite, CN_User_Menu3_03_21, GUI_BLENDMODE_SRC_OVER);/*设定*/
        }
        else
        {
            GUI_General_Display(MENU_Sprite, CN_User_Menu3_03_22, GUI_BLENDMODE_SRC_OVER); /*不设定*/
        }
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_UserSet_SYSD_Parking_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_UserSet_SYSD_Parking_Display(uint8_t Mode)
{
    uint32_t User_Value = 0u;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        User_Value = User_set_Num.User_Parking;

        GUI_General_Display(MENU_Sprite, CN_User_Menu3_03_26, GUI_BLENDMODE_SRC_OVER);/*Menu*/
        GUI_General_Display(MENU_Sprite, CN_User_Menu3_03_kuang, GUI_BLENDMODE_SRC_OVER);/*框*/

        if (User_Value == 0u) /*0x00-设定   0xFF-不设定*/
        {
            GUI_General_Display(MENU_Sprite, CN_User_Menu3_03_21, GUI_BLENDMODE_SRC_OVER);/*设定*/
        }
        else
        {
            GUI_General_Display(MENU_Sprite, CN_User_Menu3_03_22, GUI_BLENDMODE_SRC_OVER); /*不设定*/
        }
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_User_Light1_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_User_Light1_Display(uint8_t Mode)
{
    uint32_t User_NUM1 = 0u;
    uint32_t User_NUM2 = 0u;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_General_Display(MENU_Sprite, CN_User_Menu3_03_Bri_1black, GUI_BLENDMODE_SRC_OVER);
        GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_an   , 261u, 201u, GUI_BLENDMODE_CUSTOM);
        GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_ming , 627u, 201u, GUI_BLENDMODE_CUSTOM);

        User_NUM1 = User_set_Num.User_Light1;

        switch (User_NUM1)
        {
        case 16u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 15u), 199u, GUI_BLENDMODE_CUSTOM);
        case 15u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 14u), 199u, GUI_BLENDMODE_CUSTOM);
        case 14u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 13u), 199u, GUI_BLENDMODE_CUSTOM);
        case 13u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 12u), 199u, GUI_BLENDMODE_CUSTOM);
        case 12u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 11u), 199u, GUI_BLENDMODE_CUSTOM);
        case 11u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 10u), 199u, GUI_BLENDMODE_CUSTOM);
        case 10u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 9u), 199u, GUI_BLENDMODE_CUSTOM);
        case  9u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 8u), 199u, GUI_BLENDMODE_CUSTOM);
        case  8u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 7u), 199u, GUI_BLENDMODE_CUSTOM);
        case  7u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 6u), 199u, GUI_BLENDMODE_CUSTOM);
        case  6u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 5u), 199u, GUI_BLENDMODE_CUSTOM);
        case  5u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 4u), 199u, GUI_BLENDMODE_CUSTOM);
        case  4u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 3u), 199u, GUI_BLENDMODE_CUSTOM);
        case  3u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 2u), 199u, GUI_BLENDMODE_CUSTOM);
        case  2u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 1u), 199u, GUI_BLENDMODE_CUSTOM);
        case  1u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 0u), 199u, GUI_BLENDMODE_CUSTOM);
            break;
        default :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 0u), 199u, GUI_BLENDMODE_CUSTOM);
            break;
        }

        GUI_General_Display(MENU_Sprite, CN_User_Menu3_03_Bri_2gray, GUI_BLENDMODE_SRC_OVER);
        GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_an   , 261u, 291u, GUI_BLENDMODE_CUSTOM);
        GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_ming , 627u, 291u, GUI_BLENDMODE_CUSTOM);

        User_NUM2 = User_set_Num.User_Light2;

        switch (User_NUM2)
        {
        case 16u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 15u), 289u, GUI_BLENDMODE_CUSTOM);
        case 15u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 14u), 289u, GUI_BLENDMODE_CUSTOM);
        case 14u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 13u), 289u, GUI_BLENDMODE_CUSTOM);
        case 13u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 12u), 289u, GUI_BLENDMODE_CUSTOM);
        case 12u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 11u), 289u, GUI_BLENDMODE_CUSTOM);
        case 11u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 10u), 289u, GUI_BLENDMODE_CUSTOM);
        case 10u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 9u), 289u, GUI_BLENDMODE_CUSTOM);
        case  9u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 8u), 289u, GUI_BLENDMODE_CUSTOM);
        case  8u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 7u), 289u, GUI_BLENDMODE_CUSTOM);
        case  7u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 6u), 289u, GUI_BLENDMODE_CUSTOM);
        case  6u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 5u), 289u, GUI_BLENDMODE_CUSTOM);
        case  5u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 4u), 289u, GUI_BLENDMODE_CUSTOM);
        case  4u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 3u), 289u, GUI_BLENDMODE_CUSTOM);
        case  3u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 2u), 289u, GUI_BLENDMODE_CUSTOM);
        case  2u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 1u), 289u, GUI_BLENDMODE_CUSTOM);
        case  1u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 0u), 289u, GUI_BLENDMODE_CUSTOM);
            break;
        default :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 0u), 289u, GUI_BLENDMODE_CUSTOM);
            break;
        }
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_User_Light2_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_User_Light2_Display(uint8_t Mode)
{
    uint32_t User_NUM1 = 0u;
    uint32_t User_NUM2 = 0u;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_General_Display(MENU_Sprite, CN_User_Menu3_03_Bri_1gray, GUI_BLENDMODE_SRC_OVER);
        GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_an   , 261u, 201u, GUI_BLENDMODE_CUSTOM);
        GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_ming , 627u, 201u, GUI_BLENDMODE_CUSTOM);

        User_NUM1 = User_set_Num.User_Light1;

        switch (User_NUM1)
        {
        case 16u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 15u), 199u, GUI_BLENDMODE_CUSTOM);
        case 15u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 14u), 199u, GUI_BLENDMODE_CUSTOM);
        case 14u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 13u), 199u, GUI_BLENDMODE_CUSTOM);
        case 13u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 12u), 199u, GUI_BLENDMODE_CUSTOM);
        case 12u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 11u), 199u, GUI_BLENDMODE_CUSTOM);
        case 11u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 10u), 199u, GUI_BLENDMODE_CUSTOM);
        case 10u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 9u), 199u, GUI_BLENDMODE_CUSTOM);
        case  9u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 8u), 199u, GUI_BLENDMODE_CUSTOM);
        case  8u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 7u), 199u, GUI_BLENDMODE_CUSTOM);
        case  7u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 6u), 199u, GUI_BLENDMODE_CUSTOM);
        case  6u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 5u), 199u, GUI_BLENDMODE_CUSTOM);
        case  5u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 4u), 199u, GUI_BLENDMODE_CUSTOM);
        case  4u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 3u), 199u, GUI_BLENDMODE_CUSTOM);
        case  3u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 2u), 199u, GUI_BLENDMODE_CUSTOM);
        case  2u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 1u), 199u, GUI_BLENDMODE_CUSTOM);
        case  1u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 0u), 199u, GUI_BLENDMODE_CUSTOM);
            break;
        default :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 0u), 199u, GUI_BLENDMODE_CUSTOM);
            break;
        }

        GUI_General_Display(MENU_Sprite, CN_User_Menu3_03_Bri_2black, GUI_BLENDMODE_SRC_OVER);
        GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_an   , 261u, 291u, GUI_BLENDMODE_CUSTOM);
        GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_ming , 627u, 291u, GUI_BLENDMODE_CUSTOM);

        User_NUM2 = User_set_Num.User_Light2;

        switch (User_NUM2)
        {
        case 16u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 15u), 289u, GUI_BLENDMODE_CUSTOM);
        case 15u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 14u), 289u, GUI_BLENDMODE_CUSTOM);
        case 14u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 13u), 289u, GUI_BLENDMODE_CUSTOM);
        case 13u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 12u), 289u, GUI_BLENDMODE_CUSTOM);
        case 12u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 11u), 289u, GUI_BLENDMODE_CUSTOM);
        case 11u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 10u), 289u, GUI_BLENDMODE_CUSTOM);
        case 10u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 9u), 289u, GUI_BLENDMODE_CUSTOM);
        case  9u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 8u), 289u, GUI_BLENDMODE_CUSTOM);
        case  8u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 7u), 289u, GUI_BLENDMODE_CUSTOM);
        case  7u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 6u), 289u, GUI_BLENDMODE_CUSTOM);
        case  6u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 5u), 289u, GUI_BLENDMODE_CUSTOM);
        case  5u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 4u), 289u, GUI_BLENDMODE_CUSTOM);
        case  4u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 3u), 289u, GUI_BLENDMODE_CUSTOM);
        case  3u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 2u), 289u, GUI_BLENDMODE_CUSTOM);
        case  2u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 1u), 289u, GUI_BLENDMODE_CUSTOM);
        case  1u :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 0u), 289u, GUI_BLENDMODE_CUSTOM);
            break;
        default :
            GUI_Translate_Display(MENU_Sprite, CN_User_Menu3_03_Bri_green, (310u + 19u * 0u), 289u, GUI_BLENDMODE_CUSTOM);
            break;
        }
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_Enter_Return_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_Enter_Return_Display(uint8_t Mode)
{
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        /*显示*/
        GUI_General_Display(MENU_Sprite, CN_User_Menu3_01_wenzi, GUI_BLENDMODE_SRC_OVER); /*menu*/
        GUI_General_Display(MENU_Sprite, CN_fengexian, GUI_BLENDMODE_SRC_OVER);           /*line*/

        if (State_Flag.ENTER_RETURN == 0u)
        {
            GUI_General_Display(MENU_Sprite, CN_User_Menu3_01_10, GUI_BLENDMODE_SRC_OVER);
            GUI_General_Display(MENU_Sprite, CN_white_yes, GUI_BLENDMODE_SRC_OVER);
            GUI_General_Display(MENU_Sprite, CN_white_no, GUI_BLENDMODE_SRC_OVER);
        }
        else
        {
            GUI_General_Display(MENU_Sprite, CN_User_Menu3_01_11, GUI_BLENDMODE_SRC_OVER);
            GUI_General_Display(MENU_Sprite, CN_grey_yes, GUI_BLENDMODE_SRC_OVER);
            GUI_General_Display(MENU_Sprite, CN_grey_no, GUI_BLENDMODE_SRC_OVER);
        }
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

void Common_EOL_User_Server(void)
{
    /*发动机油＆滤清器*/
//    if (State_Flag.User_FDJYLQQ_FLAG != 3u)
//    {
//        if (User_App.User_FDJYLQQ > 0 )
//        {
//            if (User_App.User_FDJYLQQ >= (Data_Read_Trip(EM_TRIP_JY) / 10u))
//            {
//                User_App.User_FDJYLQQ = ((uint32_t)K_Line_Set.K_Line_LID4F * 1000u) - Data_Read_Trip(EM_TRIP_JY) / 10u;
//            }
//            else
//            {
//                User_App.User_FDJYLQQ = 0u;
//            }
//
//            if (User_App.User_FDJYLQQ <= 1000)
//            {
//                State_Flag.User_FDJYLQQ_FLAG = 2u;
//            }
//        }
//        else
//        {
//            State_Flag.User_FDJYLQQ_FLAG = 1;
//        }
//    }

    /*燃油滤清器*/
    if ( State_Flag.User_RYLQQ_FLAG != 3u)
    {
        if (User_App.User_RYLQQ > 0 )
        {
            if (User_App.User_RYLQQ >= (Data_Read_Trip(EM_TRIP_RY) / 10u))
            {
                User_App.User_RYLQQ = ((uint32_t)K_Line_User_RYLQQ * 1000u ) - Data_Read_Trip(EM_TRIP_RY) / 10u;
            }
            else
            {
                User_App.User_RYLQQ = 0u;
            }

            if (User_App.User_RYLQQ <= 1000)
            {
                State_Flag.User_RYLQQ_FLAG = 2;
            }
        }
        else
        {
            State_Flag.User_RYLQQ_FLAG = 1;
        }
    }

    /*变速箱油*/
    if (State_Flag.User_BSXY_FLAG != 3u)
    {
        if (User_App.User_BSXY > 0 )
        {
            if (User_App.User_BSXY >= (Data_Read_Trip(EM_TRIP_BSX) / 10u))
            {
                User_App.User_BSXY = ((uint32_t)K_Line_Set.K_Line_LID4A * 1000u) - Data_Read_Trip(EM_TRIP_BSX) / 10u;
            }
            else
            {
                User_App.User_BSXY = 0u;
            }

            if (User_App.User_BSXY <= 1000)
            {
                State_Flag.User_BSXY_FLAG = 2;
            }
        }
        else
        {
            State_Flag.User_BSXY_FLAG = 1;
        }
    }

    /*差速器油*/
    if (State_Flag.User_CSQY_FLAG != 3)
    {
        if (User_App.User_CSQY > 0 )
        {
            if (User_App.User_CSQY >= (Data_Read_Trip(EM_TRIP_CSQ) / 10u))
            {
                User_App.User_CSQY = ((uint32_t)K_Line_Set.K_Line_LID4B * 1000u) - Data_Read_Trip(EM_TRIP_CSQ) / 10u;
            }
            else
            {
                User_App.User_CSQY = 0u;
            }

            if (User_App.User_CSQY <= 1000)
            {
                State_Flag.User_CSQY_FLAG = 2;
            }
        }
        else
        {
            State_Flag.User_CSQY_FLAG = 1;
        }
    }

    /*空气干燥剂*/
    if (State_Flag.User_KQGZJ_FLAG != 3u)
    {
        if (User_App.User_KQGZJ > 0 )
        {
            if (User_App.User_KQGZJ >= (Data_Read_Trip(EM_TRIP_KQGZJ) / 10u))
            {
                User_App.User_KQGZJ = ((uint32_t)K_Line_User_KQGZJ * 1000u) - Data_Read_Trip(EM_TRIP_KQGZJ) / 10u;
            }
            else
            {
                User_App.User_KQGZJ = 0u;
            }

            if (User_App.User_KQGZJ <= 1000)
            {
                State_Flag.User_KQGZJ_FLAG = 2;
            }
        }
        else
        {
            State_Flag.User_KQGZJ_FLAG = 1;
        }
    }

    /*动力转向油*/
    if (State_Flag.User_DLZXY_FLAG != 3u)
    {
        if (User_App.User_DLZXY > 0 )
        {
            if (User_App.User_DLZXY >= (Data_Read_Trip(EM_TRIP_DLZX) / 10u))
            {
                User_App.User_DLZXY = ((uint32_t)K_Line_Set.K_Line_LID4D * 1000u) - Data_Read_Trip(EM_TRIP_DLZX) / 10u;
            }
            else
            {
                User_App.User_DLZXY = 0u;
            }

            if (User_App.User_DLZXY <= 1000)
            {
                State_Flag.User_DLZXY_FLAG = 2 ;
            }
        }
        else
        {
            State_Flag.User_DLZXY_FLAG = 1;
        }
    }

    /*轮胎*/
    if (State_Flag.User_LT_FLAG != 3u)
    {
        if (User_App.User_LT > 0 )
        {
            if (User_App.User_LT >= (Data_Read_Trip(EM_TRIP_LT) / 10u))
            {
                User_App.User_LT = ((uint32_t)K_Line_Set.K_Line_LID4E * 1000u) - Data_Read_Trip(EM_TRIP_LT) / 10u;
            }
            else
            {
                User_App.User_LT = 0u;
            }

            if (User_App.User_LT <= 1000)
            {
                State_Flag.User_LT_FLAG = 2;
            }
        }
        else
        {
            State_Flag.User_LT_FLAG = 1;
        }
    }
}

/******************************************************************************
  GUI_General_Popup
  功  能：
  参  数：
  返回值：无
 ******************************************************************************/
void GUI_General_Popup(void)
{
    uint16_t PopupMsg = 0u;
    uint8_t PopupSnd = 0u;

    PopupMsg = Popup_Get_Current_Message();
    PopupSnd = Popup_Get_Current_Sound();

    GUI_OftenShow_Display();
    GUI_Dynamic_DIsplay();

    Popups_Displaying(PopupMsg);
    Popups_Sound_Playing(PopupSnd);
}

/******************************************************************************
  函数名：GUI_General_Popup_Display
  功  能：通用弹出信息显示程序
  参  数：PopupID：弹出信息名称
  返回值：无
 ******************************************************************************/
void GUI_General_Popup_Display(uint16_t PopupMsg)
{
    uint16_t V_Speed = 0u;

    if (PopupMsg >= POPUP_MSG_NUMBER_TOTAL)
    {
        return;
    }

    V_Speed = Common_Get_Disp_V_Speed();

    if (V_Speed > 66u) /*有车速*/
    {
        if ((PopupMsg == POPUP1_MSG_BRAKE_BLACK) || (PopupMsg == POPUP1_MSG_BRAKE_BRAKE))
        {
            GUI_General_Display(MultiPurpose_Sprite, CN_Alarm_01_image, GUI_BLENDMODE_SRC_OVER); /*红底*/
        }
        else
        {
            /*2022-02-09 调整*/
            ;//GUI_General_Display(MultiPurpose_Sprite, CN_Alarm_01_imageblack, GUI_BLENDMODE_SRC_OVER); /*黑底*/
        }

        if (PopupMsg == POPUP5_MSG_PUSH_DPD_SWITCH2)
        {
            if (FLASH_SYNC_1Hz)
            {
                GUI_General_Display(MultiPurpose_Sprite, GUIGeneralPopupTable[PopupMsg].PICIcon, GUI_BLENDMODE_CUSTOM);
            }
            else
            {
                GUI_General_Display(MultiPurpose_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
            }

            GUI_General_Display(MultiPurpose_Sprite, GUIGeneralPopupTable[PopupMsg].HImageCN1, GUI_BLENDMODE_CUSTOM);
            GUI_General_Display(MultiPurpose_Sprite, GUIGeneralPopupTable[PopupMsg].HImageCN2, GUI_BLENDMODE_CUSTOM);
        }
        else
        {
            GUI_General_Display(MultiPurpose_Sprite, GUIGeneralPopupTable[PopupMsg].PICIcon, GUI_BLENDMODE_CUSTOM);
            GUI_General_Display(MultiPurpose_Sprite, GUIGeneralPopupTable[PopupMsg].HImageCN1, GUI_BLENDMODE_CUSTOM);
            GUI_General_Display(MultiPurpose_Sprite, GUIGeneralPopupTable[PopupMsg].HImageCN2, GUI_BLENDMODE_CUSTOM);
        }
    }
    else
    {
        if ((PopupMsg == POPUP1_MSG_BRAKE_BLACK) || (PopupMsg == POPUP1_MSG_BRAKE_BRAKE))
        {
            GUI_General_Display(MultiPurpose_Sprite, CN_Alarm_01_image, GUI_BLENDMODE_SRC_OVER); /*红底*/
        }
        else
        {
            /*2022-02-09 调整*/
            ;//GUI_General_Display(MultiPurpose_Sprite, CN_Alarm_01_imageblack, GUI_BLENDMODE_SRC_OVER); /*黑底*/
        }

        if (PopupMsg == POPUP5_MSG_PUSH_DPD_SWITCH2)
        {
            if (FLASH_SYNC_1Hz)
            {
                GUI_General_Display(MultiPurpose_Sprite, GUIGeneralPopupTable[PopupMsg].PICIcon, GUI_BLENDMODE_CUSTOM);
            }
            else
            {
                GUI_General_Display(MultiPurpose_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
            }

            GUI_General_Display(MultiPurpose_Sprite, GUIGeneralPopupTable[PopupMsg].HImageCN3, GUI_BLENDMODE_CUSTOM);
            GUI_General_Display(MultiPurpose_Sprite, GUIGeneralPopupTable[PopupMsg].HImageCN4, GUI_BLENDMODE_CUSTOM);
        }
        else
        {
            GUI_General_Display(MultiPurpose_Sprite, GUIGeneralPopupTable[PopupMsg].PICIcon, GUI_BLENDMODE_CUSTOM);
            GUI_General_Display(MultiPurpose_Sprite, GUIGeneralPopupTable[PopupMsg].HImageCN3, GUI_BLENDMODE_CUSTOM);
            GUI_General_Display(MultiPurpose_Sprite, GUIGeneralPopupTable[PopupMsg].HImageCN4, GUI_BLENDMODE_CUSTOM);
        }
    }
}

void Loc_Display_Blue(void)
{
    loc_Disable_Window_App();
    JCUA_Disable_window();
    R_WM_ScreenBgColorSet(0, 0, 0, 0Xff);
    R_WM_FrameEndMark(0, 0);
    R_WM_FrameWait(0, 0);
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_FacMenu_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_FacMenu_Display(uint8_t Mode)
{
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_General_Display(MENU_Sprite, CN_User_Menu1_wenzi, GUI_BLENDMODE_SRC_OVER);  /*menu*/
        GUI_General_Display(MENU_Sprite, CN_fengexian, GUI_BLENDMODE_SRC_OVER);        /*line*/
        GUI_General_Display(MENU_Sprite, CN_gundongtiao, GUI_BLENDMODE_SRC_OVER);      /*长度条*/

        GUI_General_Display(MENU_Sprite, CN_Fty_Menu2_06_1black, GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_FacMenu_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_FacMenu_Display(uint8_t Mode)
{
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        /*显示*/
        GUI_General_Display(MENU_Sprite, CN_Fty_Menu1_wenzi, GUI_BLENDMODE_SRC_OVER);  /*menu*/
        GUI_General_Display(MENU_Sprite, CN_fengexian, GUI_BLENDMODE_SRC_OVER);        /*line*/
        GUI_General_Display(MENU_Sprite, CN_gundongtiao, GUI_BLENDMODE_SRC_OVER);      /*长度条*/

        if (bCurMenuIDX <= _FAC_DSP_LEVEL1MENU_4)
        {
            if (bCurMenuIDX != _FAC_DSP_LEVEL1MENU_1)
            {
                GUI_Translate_Display(MENU_Sprite, CN_Fty_Menu1_01White, 225u, GUI_DISP_MENU_Y[0u], GUI_BLENDMODE_SRC_OVER);
            }
            if (bCurMenuIDX != _FAC_DSP_LEVEL1MENU_2)
            {
                GUI_Translate_Display(MENU_Sprite, CN_Fty_Menu1_02White, 225u, GUI_DISP_MENU_Y[1u], GUI_BLENDMODE_SRC_OVER);
            }
            if (bCurMenuIDX != _FAC_DSP_LEVEL1MENU_3)
            {
                GUI_Translate_Display(MENU_Sprite, CN_Fty_Menu1_07White, 225u, GUI_DISP_MENU_Y[2u], GUI_BLENDMODE_SRC_OVER);
            }
            if (bCurMenuIDX != _FAC_DSP_LEVEL1MENU_4)
            {
                GUI_Translate_Display(MENU_Sprite, CN_Fty_Menu1_08White, 225u, GUI_DISP_MENU_Y[3u], GUI_BLENDMODE_SRC_OVER);
            }
        }
        else if (bCurMenuIDX == _FAC_DSP_LEVEL1MENU_5)
        {
            GUI_Translate_Display(MENU_Sprite, CN_Fty_Menu1_02White, 225u, GUI_DISP_MENU_Y[0u], GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, CN_Fty_Menu1_07White, 225u, GUI_DISP_MENU_Y[1u], GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, CN_Fty_Menu1_08White, 225u, GUI_DISP_MENU_Y[2u], GUI_BLENDMODE_SRC_OVER);
        }
        else
        {
            GUI_Translate_Display(MENU_Sprite, CN_Fty_Menu1_07White, 225u, GUI_DISP_MENU_Y[0u], GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, CN_Fty_Menu1_08White, 225u, GUI_DISP_MENU_Y[1u], GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, CN_Fty_Menu1_09White, 225u, GUI_DISP_MENU_Y[2u], GUI_BLENDMODE_SRC_OVER);
        }
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_FacMenu1_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_FacMenu1_Display(uint8_t Mode)
{
    uint8_t Flag = 0;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_Translate_Display(MENU_Sprite, (CN_Fty_Menu1_01black + Flag), 225u, GUI_DISP_MENU_Y[0u], GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_FacMenu2_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_FacMenu2_Display(uint8_t Mode)
{
    uint8_t Flag = 0;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_Translate_Display(MENU_Sprite, (CN_Fty_Menu1_02black + Flag), 225u, GUI_DISP_MENU_Y[1u], GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_FacMenu3_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_FacMenu3_Display(uint8_t Mode)
{
    uint8_t Flag = 0;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_Translate_Display(MENU_Sprite, (CN_Fty_Menu1_07black + Flag), 225u, GUI_DISP_MENU_Y[2u], GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_FacMenu4_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_FacMenu4_Display(uint8_t Mode)
{
    uint8_t Flag = 0;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_Translate_Display(MENU_Sprite, (CN_Fty_Menu1_08black + Flag), 225u, GUI_DISP_MENU_Y[3u], GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_FacMenu5_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_FacMenu5_Display(uint8_t Mode)
{
    uint8_t Flag = 0;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_Translate_Display(MENU_Sprite, (CN_Fty_Menu1_09black + Flag), 225u, GUI_DISP_MENU_Y[3u], GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_FacMenu6_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_FacMenu6_Display(uint8_t Mode)
{
    uint8_t Flag = 0;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_Translate_Display(MENU_Sprite, (CN_Fty_Menu1_06black + Flag), 225u, GUI_DISP_MENU_Y[3u], GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_Display_DTC_Server
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_Display_DTC_Server(void)
{
    uint8_t i = 0u;
    uint8_t DTCNum = 0u;

    /*发动机故障*/
    //if (DisDTCNum != 0x00u)
    //{
    //    Display_DTC[0u].Disp_True_False = 1u;
    //}
    //else
    //{
    //    Display_DTC[0u].Disp_True_False = 0u;
    //}

    /*刹车故障*/
    if (DisDTCNum != 0x00u)
    {
        Display_DTC[1u].Disp_True_False = 1u;
    }
    else
    {
        Display_DTC[1u].Disp_True_False = 0u;
    }
    /*变速箱故障*/
    //if (DisDTCNum != 0x00u)
    //{
    //    Display_DTC[2u].Disp_True_False = 1u;
    //}
    //else
    //{
    //    Display_DTC[2u].Disp_True_False = 0u;
    //}
    ///*雷达故障码*/
    //if (DisDTCNum != 0x00u)
    //{
    //    Display_DTC[3u].Disp_True_False = 1u;
    //}
    //else
    //{
    //    Display_DTC[3u].Disp_True_False = 0u;
    //}
    ///*摄像头故障码*/
    //if (DisDTCNum != 0x00u)
    //{
    //    Display_DTC[4u].Disp_True_False = 1u;
    //}
    //else
    //{
    //    Display_DTC[4u].Disp_True_False = 0u;
    //}
    ///*液力缓速器故障码*/
    //if (DisDTCNum != 0x00u)
    //{
    //    Display_DTC[5u].Disp_True_False = 1u;
    //}
    //else
    //{
    //    Display_DTC[5u].Disp_True_False = 0u;
    //}
    /*SCR故障*/
    //if (DisDTCNum != 0x00u)
    //{
    //    Display_DTC[0u].Disp_True_False = 1u;
    //}
    //else
    //{
    //    Display_DTC[0u].Disp_True_False = 0u;
    //}

    /*无故障*/
    Display_DTC[DTCNumeber].Disp_True_False = 1u;

    if (Display_DTC[GUIDTCNumDis].Disp_True_False == 1u)
    {
        if (DTCNumTime <= 50u)
        {
            DTCNumTime ++;
        }
        else
        {
            DTCNumTime = 0u;

            GUIDTCNumDis++;

            for ( ; (DTCNumeber - 1u) ; )
            {
                if (Display_DTC[GUIDTCNumDis].Disp_True_False == 0u)
                {
                    GUIDTCNumDis++;
                }
                else
                {
                    break;
                }
            }
        }
    }
    else
    {
        for ( ; (DTCNumeber - 1u) ; )
        {
            if (Display_DTC[GUIDTCNumDis].Disp_True_False == 0u)
            {
                GUIDTCNumDis++;
            }
            else
            {
                break;
            }
        }
    }

    if (GUIDTCNumDis < (DTCNumeber - 1u))
    {
        ;/*Do Nothing !*/
    }
    else
    {
        GUIDTCNumDis = 0u;
    }

    for (i = 0u; i < (DTCNumeber - 1u); i++)
    {
        DTCNum += Display_DTC[i].Disp_True_False;
    }

    if (DTCNum == 0u)
    {
        GUIDTCNumDis = DTCNumeber;
    }

    Display_DTC[GUIDTCNumDis].Disp_Mod_Menu_Cbk(GUI_DISP_MODE_NORMAL);
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_FacMenu6_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_DTCEngine_Display(uint8_t Mode)
{
    uint8_t DTCNumCode = 0u;
    uint32_t DTNumValue = 0u;
    uint8_t Dig[5];

    if (DTCNumTime == 1)
    {
        if (DTCDispNum == DisDTCNum)
        {
            DTCDispNum = 0;
        }

        DTNum = DisDTCNumber[DTCDispNum];

        if (DTCDispNum < DisDTCNum)
        {
            DTCDispNum++;
        }
    }

    DTCNumCode = (uint8_t)(DTNum >> 28u);
    DTNumValue = ((DTNum >> 0x08u) & 0xFFFFFFu);

    Dig[0] = (uint8_t)(DTNumValue % 16u);
    DTNumValue = DTNumValue / 16;
    Dig[1] = (uint8_t)(DTNumValue % 16u);
    DTNumValue = DTNumValue / 16;
    Dig[2] = (uint8_t)(DTNumValue % 16u);
    DTNumValue = DTNumValue / 16;
    Dig[3] = (uint8_t)(DTNumValue % 16u);
    DTNumValue = DTNumValue / 16;
    Dig[4] = (uint8_t)(DTNumValue % 16u);

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_General_Display(MENU_Sprite, CN_User_Menu2_01_wenzi, GUI_BLENDMODE_SRC_OVER); /*menu*/
        GUI_General_Display(MENU_Sprite, CN_fengexian, GUI_BLENDMODE_SRC_OVER);           /*line*/

        GUI_Translate_Display(MENU_Sprite, CN_Alarm_Fault_02_image, 230u, 154u, GUI_BLENDMODE_SRC_OVER);
        GUI_Translate_Display(MENU_Sprite, CN_Alarm_Fault_02_wenzi, 346u, 154u, GUI_BLENDMODE_SRC_OVER);

        switch (DTCNumCode)
        {
        case 0x00u :
            GUI_General_Display(MENU_Sprite, CN_Alarm_Fault_P, GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, CN_Nb_28_0, 378u, 267u, GUI_BLENDMODE_SRC_OVER);
            break;

        case 0x01u :
            GUI_General_Display(MENU_Sprite, CN_Alarm_Fault_P, GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, CN_Nb_28_1, 378u, 267u, GUI_BLENDMODE_SRC_OVER);
            break;

        case 0x02u :
            GUI_General_Display(MENU_Sprite, CN_Alarm_Fault_P, GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, CN_Nb_28_2, 378u, 267u, GUI_BLENDMODE_SRC_OVER);
            break;

        case 0x03u :
            GUI_General_Display(MENU_Sprite, CN_Alarm_Fault_P, GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, CN_Nb_28_3, 378u, 267u, GUI_BLENDMODE_SRC_OVER);
            break;

        case 0x04u :
            GUI_General_Display(MENU_Sprite, CN_Alarm_Fault_C, GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, CN_Nb_28_0, 378u, 267u, GUI_BLENDMODE_SRC_OVER);
            break;

        case 0x05u :
            GUI_General_Display(MENU_Sprite, CN_Alarm_Fault_C, GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, CN_Nb_28_1, 378u, 267u, GUI_BLENDMODE_SRC_OVER);
            break;

        case 0x06u :
            GUI_General_Display(MENU_Sprite, CN_Alarm_Fault_C, GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, CN_Nb_28_2, 378u, 267u, GUI_BLENDMODE_SRC_OVER);
            break;

        case 0x07u :
            GUI_General_Display(MENU_Sprite, CN_Alarm_Fault_C, GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, CN_Nb_28_3, 378u, 267u, GUI_BLENDMODE_SRC_OVER);
            break;

        case 0x08u :
            GUI_General_Display(MENU_Sprite, CN_Alarm_Fault_B, GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, CN_Nb_28_0, 378u, 267u, GUI_BLENDMODE_SRC_OVER);
            break;

        case 0x09u :
            GUI_General_Display(MENU_Sprite, CN_Alarm_Fault_B, GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, CN_Nb_28_1, 378u, 267u, GUI_BLENDMODE_SRC_OVER);
            break;

        case 0x0Au :
            GUI_General_Display(MENU_Sprite, CN_Alarm_Fault_B, GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, CN_Nb_28_2, 378u, 267u, GUI_BLENDMODE_SRC_OVER);
            break;

        case 0x0Bu :
            GUI_General_Display(MENU_Sprite, CN_Alarm_Fault_B, GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, CN_Nb_28_3, 378u, 267u, GUI_BLENDMODE_SRC_OVER);
            break;

        case 0x0Cu :
            GUI_General_Display(MENU_Sprite, CN_Alarm_Fault_U, GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, CN_Nb_28_0, 378u, 267u, GUI_BLENDMODE_SRC_OVER);
            break;

        case 0x0Du :
            GUI_General_Display(MENU_Sprite, CN_Alarm_Fault_U, GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, CN_Nb_28_1, 378u, 267u, GUI_BLENDMODE_SRC_OVER);
            break;

        case 0x0Eu :
            GUI_General_Display(MENU_Sprite, CN_Alarm_Fault_U, GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, CN_Nb_28_2, 378u, 267u, GUI_BLENDMODE_SRC_OVER);
            break;

        case 0x0Fu :
            GUI_General_Display(MENU_Sprite, CN_Alarm_Fault_U, GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, CN_Nb_28_3, 378u, 267u, GUI_BLENDMODE_SRC_OVER);
            break;

        default:
            GUI_General_Display(MENU_Sprite, CN_Alarm_Fault_P, GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, CN_Nb_28_0, 378u, 267u, GUI_BLENDMODE_SRC_OVER);
            break;
        }

        GUI_Translate_Display(MENU_Sprite, CN_Nb_28_heng, 498u, 262u, GUI_BLENDMODE_SRC_OVER); /*-*/

        GUI_Translate_Display(MENU_Sprite, GUIDTCNUM[Dig[0]], 558u, 267u, GUI_BLENDMODE_SRC_OVER);
        GUI_Translate_Display(MENU_Sprite, GUIDTCNUM[Dig[1]], 528u, 267u, GUI_BLENDMODE_SRC_OVER);
        GUI_Translate_Display(MENU_Sprite, GUIDTCNUM[Dig[2]], 468u, 267u, GUI_BLENDMODE_SRC_OVER);
        GUI_Translate_Display(MENU_Sprite, GUIDTCNUM[Dig[3]], 438u, 267u, GUI_BLENDMODE_SRC_OVER);
        GUI_Translate_Display(MENU_Sprite, GUIDTCNUM[Dig[4]], 408u, 267u, GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}
void GUI_BG_MenuDTCEngine_Display(uint8_t Mode)
{
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_General_Display(MENU_Sprite, CN_User_Menu2_01_wenzi, GUI_BLENDMODE_SRC_OVER); /*menu*/
        GUI_General_Display(MENU_Sprite, CN_fengexian, GUI_BLENDMODE_SRC_OVER);           /*line*/

        GUI_Translate_Display(MENU_Sprite, CN_Alarm_Fault_02_image, 230u, 154u, GUI_BLENDMODE_SRC_OVER);
        GUI_Translate_Display(MENU_Sprite, CN_Alarm_Fault_02_wenzi, 346u, 154u, GUI_BLENDMODE_SRC_OVER);

        GUI_Translate_Display(MENU_Sprite, CN_Alarm_Fault_D, 311u, 267u, GUI_BLENDMODE_SRC_OVER);/*D*/
        GUI_Translate_Display(MENU_Sprite, CN_Alarm_Fault_T, 341u, 267u, GUI_BLENDMODE_SRC_OVER);/*T*/
        GUI_Translate_Display(MENU_Sprite, CN_Alarm_Fault_C, 376u, 267u, GUI_BLENDMODE_SRC_OVER);/*C*/

        GUI_Translate_Display(MENU_Sprite, CN_Nb_28_heng, 406u, 262u, GUI_BLENDMODE_SRC_OVER);/*-*/

        GUI_General_Digit_Display(MENU_Sprite, 8888, CN_Nb_28_0, 4u, 0u, GUIBGDTCPosX, 267u, GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}
void GUI_BG_DTCBrake_Display(uint8_t Mode)
{
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_General_Display(MENU_Sprite, CN_User_Menu2_01_wenzi, GUI_BLENDMODE_SRC_OVER); /*menu*/
        GUI_General_Display(MENU_Sprite, CN_fengexian, GUI_BLENDMODE_SRC_OVER);           /*line*/

        GUI_Translate_Display(MENU_Sprite, CN_Alarm_Fault_07_image, 230u, 154u, GUI_BLENDMODE_SRC_OVER);
        GUI_Translate_Display(MENU_Sprite, CN_Alarm_Fault_07_wenzi, 346u, 154u, GUI_BLENDMODE_SRC_OVER);

        GUI_Translate_Display(MENU_Sprite, CN_Alarm_Fault_D, 311u, 267u, GUI_BLENDMODE_SRC_OVER);/*D*/
        GUI_Translate_Display(MENU_Sprite, CN_Alarm_Fault_T, 341u, 267u, GUI_BLENDMODE_SRC_OVER);/*T*/
        GUI_Translate_Display(MENU_Sprite, CN_Alarm_Fault_C, 376u, 267u, GUI_BLENDMODE_SRC_OVER);/*C*/

        GUI_Translate_Display(MENU_Sprite, CN_Nb_28_heng, 406u, 262u, GUI_BLENDMODE_SRC_OVER);/*-*/

        GUI_General_Digit_Display(MENU_Sprite, 8888, CN_Nb_28_0, 4u, 0u, GUIBGDTCPosX, 267u, GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

void GUI_BG_DTCAMT_Display(uint8_t Mode)
{
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_General_Display(MENU_Sprite, CN_User_Menu2_01_wenzi, GUI_BLENDMODE_SRC_OVER); /*menu*/
        GUI_General_Display(MENU_Sprite, CN_fengexian, GUI_BLENDMODE_SRC_OVER);           /*line*/

        GUI_Translate_Display(MENU_Sprite, CN_Alarm_Fault_01_image, 230u, 154u, GUI_BLENDMODE_SRC_OVER);
        GUI_Translate_Display(MENU_Sprite, CN_Alarm_Fault_01_wenzi, 346u, 154u, GUI_BLENDMODE_SRC_OVER);

        GUI_Translate_Display(MENU_Sprite, CN_Alarm_Fault_D, 311u, 267u, GUI_BLENDMODE_SRC_OVER);/*D*/
        GUI_Translate_Display(MENU_Sprite, CN_Alarm_Fault_T, 341u, 267u, GUI_BLENDMODE_SRC_OVER);/*T*/
        GUI_Translate_Display(MENU_Sprite, CN_Alarm_Fault_C, 376u, 267u, GUI_BLENDMODE_SRC_OVER);/*C*/

        GUI_Translate_Display(MENU_Sprite, CN_Nb_28_heng, 406u, 262u, GUI_BLENDMODE_SRC_OVER);/*-*/

        GUI_General_Digit_Display(MENU_Sprite, 8888, CN_Nb_28_0, 4u, 0u, GUIBGDTCPosX, 267u, GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

void GUI_BG_DTCRadar_Display(uint8_t Mode)
{
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_General_Display(MENU_Sprite, CN_User_Menu2_01_wenzi, GUI_BLENDMODE_SRC_OVER); /*menu*/
        GUI_General_Display(MENU_Sprite, CN_fengexian, GUI_BLENDMODE_SRC_OVER);           /*line*/

        GUI_Translate_Display(MENU_Sprite, CN_Alarm_Fault_01_image, 230u, 154u, GUI_BLENDMODE_SRC_OVER);
        GUI_Translate_Display(MENU_Sprite, CN_Alarm_Fault_01_wenzi, 346u, 154u, GUI_BLENDMODE_SRC_OVER);

        GUI_Translate_Display(MENU_Sprite, CN_Alarm_Fault_D, 311u, 267u, GUI_BLENDMODE_SRC_OVER);/*D*/
        GUI_Translate_Display(MENU_Sprite, CN_Alarm_Fault_T, 341u, 267u, GUI_BLENDMODE_SRC_OVER);/*T*/
        GUI_Translate_Display(MENU_Sprite, CN_Alarm_Fault_C, 376u, 267u, GUI_BLENDMODE_SRC_OVER);/*C*/

        GUI_Translate_Display(MENU_Sprite, CN_Nb_28_heng, 406u, 262u, GUI_BLENDMODE_SRC_OVER);/*-*/

        GUI_General_Digit_Display(MENU_Sprite, 8888, CN_Nb_28_0, 4u, 0u, GUIBGDTCPosX, 267u, GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

void GUI_BG_DTCCamera_Display(uint8_t Mode)
{
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_General_Display(MENU_Sprite, CN_User_Menu2_01_wenzi, GUI_BLENDMODE_SRC_OVER); /*menu*/
        GUI_General_Display(MENU_Sprite, CN_fengexian, GUI_BLENDMODE_SRC_OVER);           /*line*/

        GUI_Translate_Display(MENU_Sprite, CN_Alarm_Fault_01_image, 230u, 154u, GUI_BLENDMODE_SRC_OVER);
        GUI_Translate_Display(MENU_Sprite, CN_Alarm_Fault_01_wenzi, 346u, 154u, GUI_BLENDMODE_SRC_OVER);

        GUI_Translate_Display(MENU_Sprite, CN_Alarm_Fault_D, 311u, 267u, GUI_BLENDMODE_SRC_OVER);/*D*/
        GUI_Translate_Display(MENU_Sprite, CN_Alarm_Fault_T, 341u, 267u, GUI_BLENDMODE_SRC_OVER);/*T*/
        GUI_Translate_Display(MENU_Sprite, CN_Alarm_Fault_C, 376u, 267u, GUI_BLENDMODE_SRC_OVER);/*C*/

        GUI_Translate_Display(MENU_Sprite, CN_Nb_28_heng, 406u, 262u, GUI_BLENDMODE_SRC_OVER);/*-*/

        GUI_General_Digit_Display(MENU_Sprite, 8888, CN_Nb_28_0, 4u, 0u, GUIBGDTCPosX, 267u, GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

void GUI_BG_DTCIntarder_Display(uint8_t Mode)
{
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_General_Display(MENU_Sprite, CN_User_Menu2_01_wenzi, GUI_BLENDMODE_SRC_OVER); /*menu*/
        GUI_General_Display(MENU_Sprite, CN_fengexian, GUI_BLENDMODE_SRC_OVER);           /*line*/

        GUI_Translate_Display(MENU_Sprite, CN_Alarm_Fault_01_image, 230u, 154u, GUI_BLENDMODE_SRC_OVER);
        GUI_Translate_Display(MENU_Sprite, CN_Alarm_Fault_01_wenzi, 346u, 154u, GUI_BLENDMODE_SRC_OVER);

        GUI_Translate_Display(MENU_Sprite, CN_Alarm_Fault_D, 311u, 267u, GUI_BLENDMODE_SRC_OVER);/*D*/
        GUI_Translate_Display(MENU_Sprite, CN_Alarm_Fault_T, 341u, 267u, GUI_BLENDMODE_SRC_OVER);/*T*/
        GUI_Translate_Display(MENU_Sprite, CN_Alarm_Fault_C, 376u, 267u, GUI_BLENDMODE_SRC_OVER);/*C*/

        GUI_Translate_Display(MENU_Sprite, CN_Nb_28_heng, 406u, 262u, GUI_BLENDMODE_SRC_OVER);/*-*/

        GUI_General_Digit_Display(MENU_Sprite, 8888, CN_Nb_28_0, 4u, 0u, GUIBGDTCPosX, 267u, GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_DTCSCR_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_DTCSCR_Display(uint8_t Mode)
{
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_General_Display(MENU_Sprite, CN_User_Menu2_01_wenzi, GUI_BLENDMODE_SRC_OVER); /*menu*/
        GUI_General_Display(MENU_Sprite, CN_fengexian, GUI_BLENDMODE_SRC_OVER);           /*line*/

        GUI_Translate_Display(MENU_Sprite, CN_Alarm_Fault_02_image, 230u, 154u, GUI_BLENDMODE_SRC_OVER);
        GUI_Translate_Display(MENU_Sprite, CN_Alarm_Fault_03_wenzi, 346u, 154u, GUI_BLENDMODE_SRC_OVER);

        GUI_General_Display(MENU_Sprite, CN_Alarm_Fault_P, GUI_BLENDMODE_SRC_OVER);
        GUI_Translate_Display(MENU_Sprite, CN_Nb_28_0, 378u, 267u, GUI_BLENDMODE_SRC_OVER);
        GUI_Translate_Display(MENU_Sprite, CN_Nb_28_0, 408u, 267u, GUI_BLENDMODE_SRC_OVER);
        GUI_Translate_Display(MENU_Sprite, CN_Nb_28_0, 438u, 267u, GUI_BLENDMODE_SRC_OVER);
        GUI_Translate_Display(MENU_Sprite, CN_Nb_28_0, 468u, 267u, GUI_BLENDMODE_SRC_OVER);
        GUI_Translate_Display(MENU_Sprite, CN_Nb_28_heng, 498u, 262u, GUI_BLENDMODE_SRC_OVER);
        GUI_Translate_Display(MENU_Sprite, CN_Nb_28_0, 528u, 267u, GUI_BLENDMODE_SRC_OVER);
        GUI_Translate_Display(MENU_Sprite, CN_Nb_28_0, 558u, 267u, GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

void GUI_Display_NULL(uint8_t Mode)
{
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_General_Display(MENU_Sprite, CN_User_Menu2_01_wenzi, GUI_BLENDMODE_SRC_OVER); /*menu*/
        GUI_General_Display(MENU_Sprite, CN_fengexian, GUI_BLENDMODE_SRC_OVER);           /*line*/
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_FacDTCClear1_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_FacDTCClear1_Display(uint8_t Mode)
{
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_General_Display(MENU_Sprite, CN_Fty_Menu2_02_wenzi, GUI_BLENDMODE_SRC_OVER); /*menu*/
        GUI_General_Display(MENU_Sprite, CN_fengexian, GUI_BLENDMODE_SRC_OVER);           /*line*/

        GUI_General_Display(MENU_Sprite, CN_Fty_Menu2_02_1, GUI_BLENDMODE_SRC_OVER);
        GUI_General_Display(MENU_Sprite, CN_white_yes, GUI_BLENDMODE_SRC_OVER);
        GUI_General_Display(MENU_Sprite, CN_white_no, GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_FacDTCClear2_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_FacDTCClear2_Display(uint8_t Mode)
{
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_General_Display(MENU_Sprite, CN_Fty_Menu2_02_wenzi, GUI_BLENDMODE_SRC_OVER); /*menu*/
        GUI_General_Display(MENU_Sprite, CN_fengexian, GUI_BLENDMODE_SRC_OVER);           /*line*/

        GUI_General_Display(MENU_Sprite, CN_Fty_Menu2_02_2, GUI_BLENDMODE_SRC_OVER);
        GUI_General_Display(MENU_Sprite, CN_white_yes, GUI_BLENDMODE_SRC_OVER);
        GUI_General_Display(MENU_Sprite, CN_white_no, GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_FacDTCClear3_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_FacDTCClear3_Display(uint8_t Mode)
{
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_General_Display(MENU_Sprite, CN_Fty_Menu2_02_wenzi, GUI_BLENDMODE_SRC_OVER); /*menu*/
        GUI_General_Display(MENU_Sprite, CN_fengexian, GUI_BLENDMODE_SRC_OVER);           /*line*/

        GUI_General_Display(MENU_Sprite, CN_Fty_Menu2_02_3, GUI_BLENDMODE_SRC_OVER);
        GUI_General_Display(MENU_Sprite, CN_grey_yes, GUI_BLENDMODE_SRC_OVER);
        GUI_General_Display(MENU_Sprite, CN_grey_no, GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_FacDTCClear4_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_FacDTCClear4_Display(uint8_t Mode)
{
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_General_Display(MENU_Sprite, CN_Fty_Menu2_02_wenzi, GUI_BLENDMODE_SRC_OVER); /*menu*/
        GUI_General_Display(MENU_Sprite, CN_fengexian, GUI_BLENDMODE_SRC_OVER);           /*line*/

        GUI_General_Display(MENU_Sprite, CN_Fty_Menu2_02_4, GUI_BLENDMODE_SRC_OVER);
        GUI_General_Display(MENU_Sprite, CN_white_jieshu_1, GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_FacMeter_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_FacMeter_Display(uint8_t Mode)
{
    uint8_t i = 0u;
    uint8_t j = 0u;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        K_LINE_EOL_Val_Server();

        GUI_General_Display(MENU_Sprite, CN_Fty_Menu2_08_wenzi, GUI_BLENDMODE_SRC_OVER); /*menu*/
        GUI_General_Display(MENU_Sprite, CN_fengexian, GUI_BLENDMODE_SRC_OVER);           /*line*/
        GUI_General_Display(MENU_Sprite, CN_gundongtiao, GUI_BLENDMODE_SRC_OVER);         /*长度条*/

        GUI_General_Display(MENU_Sprite, CN_Fty_Menu2_08_biaoge, GUI_BLENDMODE_SRC_OVER);/*框*/
        GUI_Translate_Display(MENU_Sprite, CN_Fty_Menu2_08_L, 285u, 162u, GUI_BLENDMODE_SRC_OVER);/*L*/
        GUI_Translate_Display(MENU_Sprite, CN_Fty_Menu2_08_H, 262u, 174u, GUI_BLENDMODE_SRC_OVER);/*H*/

        if (bCurMenuIDX == _FAC_DSP_LEVEL1_3MENU_1)
        {
            /*标题*/
            for (i = 0; i < 9; i++)
            {
                if (i == 0)
                {
                    for (j = 0; j < 5; j++)
                    {
                        GUI_Translate_Display(MENU_Sprite, GUIMETERY[j], (270u + 44u * i), (196u + 33u * j), GUI_BLENDMODE_SRC_OVER);
                    }
                }
                else
                {
                    GUI_Translate_Display(MENU_Sprite, GUIMETERYNUM[i - 1], (270u + 44u * i), 163u, GUI_BLENDMODE_SRC_OVER);
                }
            }

            /*数字*/
            for (j = 0; j < 5; j++)
            {
                if ((j == 1u) || (j == 3u) || (j == 4u))
                {
                    for (i = 0; i < 3; i++)
                    {
                        if ((j == 1u) && (i == 1u))
                        {
                            ;/*Do Nothing!*/
                        }
                        else
                        {
                            GUI_Translate_Display(MENU_Sprite, GUIMETERYNUM[EolNUM[j][i] / 16u], (302u + 44u * i), (196u + 33u * j), GUI_BLENDMODE_SRC_OVER);
                            GUI_Translate_Display(MENU_Sprite, GUIMETERYNUM[EolNUM[j][i] % 16u], (320u + 44u * i), (196u + 33u * j), GUI_BLENDMODE_SRC_OVER);
                        }
                    }
                }
                else
                {
                    for (i = 0; i < 8; i++)
                    {
                        GUI_Translate_Display(MENU_Sprite, GUIMETERYNUM[EolNUM[j][i] / 16u], (302u + 44u * i), (196u + 33u * j), GUI_BLENDMODE_SRC_OVER);
                        GUI_Translate_Display(MENU_Sprite, GUIMETERYNUM[EolNUM[j][i] % 16u], (320u + 44u * i), (196u + 33u * j), GUI_BLENDMODE_SRC_OVER);
                    }
                }
            }
        }
        else
        {
            /*标题*/
            for (i = 0; i < 9; i++)
            {
                if (i == 0)
                {
                    for (j = 0; j < 5; j++)
                    {
                        GUI_Translate_Display(MENU_Sprite, GUIMETERY[j], (270u + 44u * i), (196u + 33u * j), GUI_BLENDMODE_SRC_OVER);
                    }
                }
                else
                {
                    GUI_Translate_Display(MENU_Sprite, GUIMETERYNUM[i + 7u], (270u + 44u * i), 163u, GUI_BLENDMODE_SRC_OVER);
                }
            }

            /*数字*/
            for (j = 0; j < 5; j++)
            {
                if ((j == 0u) || (j == 2u))
                {
                    for (i = 0; i < 8; i++)
                    {
                        GUI_Translate_Display(MENU_Sprite, GUIMETERYNUM[EolNUM[j + 4u][i] / 16u], (302u + 44u * i), (196u + 33u * j), GUI_BLENDMODE_SRC_OVER);
                        GUI_Translate_Display(MENU_Sprite, GUIMETERYNUM[EolNUM[j + 4u][i] % 16u], (320u + 44u * i), (196u + 33u * j), GUI_BLENDMODE_SRC_OVER);
                    }
                }
                else
                {
                    ;/*Do Nothing!*/
                }
            }
        }
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_FacHIDAutoInit1_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_FacHIDAutoInit1_Display(uint8_t Mode)
{
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_General_Display(MENU_Sprite, CN_Fty_Menu2_07_wenzi, GUI_BLENDMODE_SRC_OVER); /*menu*/
        GUI_General_Display(MENU_Sprite, CN_fengexian, GUI_BLENDMODE_SRC_OVER);           /*line*/
        GUI_General_Display(MENU_Sprite, CN_gundongtiao, GUI_BLENDMODE_SRC_OVER);         /*长度条*/

        GUI_General_Display(MENU_Sprite, CN_Fty_Menu2_05_1, GUI_BLENDMODE_SRC_OVER);
        GUI_General_Display(MENU_Sprite, CN_white_yes, GUI_BLENDMODE_SRC_OVER);
        GUI_General_Display(MENU_Sprite, CN_white_no , GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_FacHIDAutoInit2_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_FacHIDAutoInit2_Display(uint8_t Mode)
{
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_General_Display(MENU_Sprite, CN_Fty_Menu2_07_wenzi, GUI_BLENDMODE_SRC_OVER); /*menu*/
        GUI_General_Display(MENU_Sprite, CN_fengexian, GUI_BLENDMODE_SRC_OVER);           /*line*/
        GUI_General_Display(MENU_Sprite, CN_gundongtiao, GUI_BLENDMODE_SRC_OVER);         /*长度条*/

        GUI_General_Display(MENU_Sprite, CN_Fty_Menu2_05_2, GUI_BLENDMODE_SRC_OVER);
        GUI_General_Display(MENU_Sprite, CN_white_yes, GUI_BLENDMODE_SRC_OVER);
        GUI_General_Display(MENU_Sprite, CN_white_no , GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_FacMeterExit_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_FacMeterExit_Display(uint8_t Mode)
{
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_General_Display(MENU_Sprite, CN_Fty_Menu2_07_wenzi, GUI_BLENDMODE_SRC_OVER); /*menu*/
        GUI_General_Display(MENU_Sprite, CN_fengexian, GUI_BLENDMODE_SRC_OVER);           /*line*/
        GUI_General_Display(MENU_Sprite, CN_gundongtiao, GUI_BLENDMODE_SRC_OVER);         /*长度条*/

        GUI_General_Display(MENU_Sprite, CN_Fty_Menu2_07_1, GUI_BLENDMODE_SRC_OVER);
        GUI_General_Display(MENU_Sprite, CN_white_yes, GUI_BLENDMODE_SRC_OVER);
        GUI_General_Display(MENU_Sprite, CN_white_no , GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_DeaMenu_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_DeaMenu_Display(uint8_t Mode)
{
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_General_Display(MENU_Sprite, CN_User_Menu1_wenzi, GUI_BLENDMODE_SRC_OVER);  /*menu*/
        GUI_General_Display(MENU_Sprite, CN_fengexian, GUI_BLENDMODE_SRC_OVER);        /*line*/
        GUI_General_Display(MENU_Sprite, CN_gundongtiao, GUI_BLENDMODE_SRC_OVER);      /*长度条*/

        GUI_General_Display(MENU_Sprite, CN_DLR_Menu2_07_1black, GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_DeaMenu_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_DeaMenu_Display(uint8_t Mode)
{
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        /*显示*/
        GUI_General_Display(MENU_Sprite, CN_DLR_Menu1_wenzi, GUI_BLENDMODE_SRC_OVER);  /*menu*/
        GUI_General_Display(MENU_Sprite, CN_fengexian, GUI_BLENDMODE_SRC_OVER);        /*line*/
        GUI_General_Display(MENU_Sprite, CN_gundongtiao, GUI_BLENDMODE_SRC_OVER);      /*长度条*/

        if (bCurMenuIDX <= _DEA_DSP_LEVEL1MENU_4)
        {
            if (bCurMenuIDX != _DEA_DSP_LEVEL1MENU_1)
            {
                GUI_Translate_Display(MENU_Sprite, CN_Fty_Menu1_01White, 225u, GUI_DISP_MENU_Y[0u], GUI_BLENDMODE_SRC_OVER);
            }
            if (bCurMenuIDX != _DEA_DSP_LEVEL1MENU_2)
            {
                GUI_Translate_Display(MENU_Sprite, CN_Fty_Menu1_02White, 225u, GUI_DISP_MENU_Y[1u], GUI_BLENDMODE_SRC_OVER);
            }
            if (bCurMenuIDX != _DEA_DSP_LEVEL1MENU_3)
            {
                GUI_Translate_Display(MENU_Sprite, CN_Fty_Menu1_07White, 225u, GUI_DISP_MENU_Y[2u], GUI_BLENDMODE_SRC_OVER);
            }
            if (bCurMenuIDX != _DEA_DSP_LEVEL1MENU_4)
            {
                GUI_Translate_Display(MENU_Sprite, CN_Fty_Menu1_08White, 225u, GUI_DISP_MENU_Y[3u], GUI_BLENDMODE_SRC_OVER);
            }
        }
        else if (bCurMenuIDX == _DEA_DSP_LEVEL1MENU_5)
        {
            GUI_Translate_Display(MENU_Sprite, CN_Fty_Menu1_02White, 225u, GUI_DISP_MENU_Y[0u], GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, CN_Fty_Menu1_07White, 225u, GUI_DISP_MENU_Y[1u], GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, CN_Fty_Menu1_08White, 225u, GUI_DISP_MENU_Y[2u], GUI_BLENDMODE_SRC_OVER);
        }
        else
        {
            GUI_Translate_Display(MENU_Sprite, CN_Fty_Menu1_07White, 225u, GUI_DISP_MENU_Y[0u], GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, CN_Fty_Menu1_08White, 225u, GUI_DISP_MENU_Y[1u], GUI_BLENDMODE_SRC_OVER);
            GUI_Translate_Display(MENU_Sprite, CN_DLR_Menu1_10White, 225u, GUI_DISP_MENU_Y[2u], GUI_BLENDMODE_SRC_OVER);
        }
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_DeaMenu1_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_DeaMenu1_Display(uint8_t Mode)
{
    uint8_t Flag = 0;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_Translate_Display(MENU_Sprite, (CN_Fty_Menu1_01black + Flag), 225u, GUI_DISP_MENU_Y[0u], GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_DeaMenu2_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_DeaMenu2_Display(uint8_t Mode)
{
    uint8_t Flag = 0;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_Translate_Display(MENU_Sprite, (CN_Fty_Menu1_02black + Flag), 225u, GUI_DISP_MENU_Y[1u], GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_DeaMenu3_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_DeaMenu3_Display(uint8_t Mode)
{
    uint8_t Flag = 0;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_Translate_Display(MENU_Sprite, (CN_Fty_Menu1_07black + Flag), 225u, GUI_DISP_MENU_Y[2u], GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_DeaMenu4_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_DeaMenu4_Display(uint8_t Mode)
{
    uint8_t Flag = 0;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_Translate_Display(MENU_Sprite, (CN_Fty_Menu1_08black + Flag), 225u, GUI_DISP_MENU_Y[3u], GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_DeaMenu5_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_DeaMenu5_Display(uint8_t Mode)
{
    uint8_t Flag = 0;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_Translate_Display(MENU_Sprite, (CN_DLR_Menu1_10black + Flag), 225u, GUI_DISP_MENU_Y[3u], GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_DeaMenu6_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_DeaMenu6_Display(uint8_t Mode)
{
    uint8_t Flag = 0;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_Translate_Display(MENU_Sprite, (CN_Fty_Menu1_06black + Flag), 225u, GUI_DISP_MENU_Y[3u], GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_DeaDTCClear1_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_DeaDTCClear1_Display(uint8_t Mode)
{
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_General_Display(MENU_Sprite, CN_Fty_Menu2_02_wenzi, GUI_BLENDMODE_SRC_OVER); /*menu*/
        GUI_General_Display(MENU_Sprite, CN_fengexian, GUI_BLENDMODE_SRC_OVER);           /*line*/

        GUI_General_Display(MENU_Sprite, CN_Fty_Menu2_02_1, GUI_BLENDMODE_SRC_OVER);
        GUI_General_Display(MENU_Sprite, CN_white_yes, GUI_BLENDMODE_SRC_OVER);
        GUI_General_Display(MENU_Sprite, CN_white_no, GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_DeaDTCClear2_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_DeaDTCClear2_Display(uint8_t Mode)
{
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_General_Display(MENU_Sprite, CN_Fty_Menu2_02_wenzi, GUI_BLENDMODE_SRC_OVER); /*menu*/
        GUI_General_Display(MENU_Sprite, CN_fengexian, GUI_BLENDMODE_SRC_OVER);           /*line*/

        GUI_General_Display(MENU_Sprite, CN_Fty_Menu2_02_2, GUI_BLENDMODE_SRC_OVER);
        GUI_General_Display(MENU_Sprite, CN_white_yes, GUI_BLENDMODE_SRC_OVER);
        GUI_General_Display(MENU_Sprite, CN_white_no, GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_DeaDTCClear3_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_DeaDTCClear3_Display(uint8_t Mode)
{
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_General_Display(MENU_Sprite, CN_Fty_Menu2_02_wenzi, GUI_BLENDMODE_SRC_OVER); /*menu*/
        GUI_General_Display(MENU_Sprite, CN_fengexian, GUI_BLENDMODE_SRC_OVER);           /*line*/

        GUI_General_Display(MENU_Sprite, CN_Fty_Menu2_02_3, GUI_BLENDMODE_SRC_OVER);
        GUI_General_Display(MENU_Sprite, CN_grey_yes, GUI_BLENDMODE_SRC_OVER);
        GUI_General_Display(MENU_Sprite, CN_grey_no, GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_DeaDTCClear4_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_DeaDTCClear4_Display(uint8_t Mode)
{
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_General_Display(MENU_Sprite, CN_Fty_Menu2_02_wenzi, GUI_BLENDMODE_SRC_OVER); /*menu*/
        GUI_General_Display(MENU_Sprite, CN_fengexian, GUI_BLENDMODE_SRC_OVER);           /*line*/

        GUI_General_Display(MENU_Sprite, CN_Fty_Menu2_02_4, GUI_BLENDMODE_SRC_OVER);
        GUI_General_Display(MENU_Sprite, CN_white_jieshu_1, GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_DeaMeter_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_DeaMeter_Display(uint8_t Mode)
{
    uint8_t i = 0u;
    uint8_t j = 0u;

    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        K_LINE_EOL_Val_Server();

        GUI_General_Display(MENU_Sprite, CN_Fty_Menu2_08_wenzi, GUI_BLENDMODE_SRC_OVER); /*menu*/
        GUI_General_Display(MENU_Sprite, CN_fengexian, GUI_BLENDMODE_SRC_OVER);           /*line*/
        GUI_General_Display(MENU_Sprite, CN_gundongtiao, GUI_BLENDMODE_SRC_OVER);         /*长度条*/

        GUI_General_Display(MENU_Sprite, CN_Fty_Menu2_08_biaoge, GUI_BLENDMODE_SRC_OVER);/*框*/
        GUI_Translate_Display(MENU_Sprite, CN_Fty_Menu2_08_L, 285u, 162u, GUI_BLENDMODE_SRC_OVER);/*L*/
        GUI_Translate_Display(MENU_Sprite, CN_Fty_Menu2_08_H, 262u, 174u, GUI_BLENDMODE_SRC_OVER);/*H*/

        if (bCurMenuIDX == _DEA_DSP_LEVEL1_3MENU_1)
        {
            /*标题*/
            for (i = 0; i < 9; i++)
            {
                if (i == 0)
                {
                    for (j = 0; j < 5; j++)
                    {
                        GUI_Translate_Display(MENU_Sprite, GUIMETERY[j], (270u + 44u * i), (196u + 33u * j), GUI_BLENDMODE_SRC_OVER);
                    }
                }
                else
                {
                    GUI_Translate_Display(MENU_Sprite, GUIMETERYNUM[i - 1], (270u + 44u * i), 163u, GUI_BLENDMODE_SRC_OVER);
                }
            }

            /*数字*/
            for (j = 0; j < 5; j++)
            {
                if ((j == 1u) || (j == 3u) || (j == 4u))
                {
                    for (i = 0; i < 3; i++)
                    {
                        if ((j == 1u) && (i == 1u))
                        {
                            ;/*Do Nothing!*/
                        }
                        else
                        {
                            GUI_Translate_Display(MENU_Sprite, GUIMETERYNUM[EolNUM[j][i] / 16u], (302u + 44u * i), (196u + 33u * j), GUI_BLENDMODE_SRC_OVER);
                            GUI_Translate_Display(MENU_Sprite, GUIMETERYNUM[EolNUM[j][i] % 16u], (320u + 44u * i), (196u + 33u * j), GUI_BLENDMODE_SRC_OVER);
                        }
                    }
                }
                else
                {
                    for (i = 0; i < 8; i++)
                    {
                        GUI_Translate_Display(MENU_Sprite, GUIMETERYNUM[EolNUM[j][i] / 16u], (302u + 44u * i), (196u + 33u * j), GUI_BLENDMODE_SRC_OVER);
                        GUI_Translate_Display(MENU_Sprite, GUIMETERYNUM[EolNUM[j][i] % 16u], (320u + 44u * i), (196u + 33u * j), GUI_BLENDMODE_SRC_OVER);
                    }
                }
            }
        }
        else
        {
            /*标题*/
            for (i = 0; i < 9; i++)
            {
                if (i == 0)
                {
                    for (j = 0; j < 5; j++)
                    {
                        GUI_Translate_Display(MENU_Sprite, GUIMETERY[j], (270u + 44u * i), (196u + 33u * j), GUI_BLENDMODE_SRC_OVER);
                    }
                }
                else
                {
                    GUI_Translate_Display(MENU_Sprite, GUIMETERYNUM[i + 7u], (270u + 44u * i), 163u, GUI_BLENDMODE_SRC_OVER);
                }
            }

            /*数字*/
            for (j = 0; j < 5; j++)
            {
                if ((j == 0u) || (j == 2u))
                {
                    for (i = 0; i < 8; i++)
                    {
                        GUI_Translate_Display(MENU_Sprite, GUIMETERYNUM[EolNUM[j + 4u][i] / 16u], (302u + 44u * i), (196u + 33u * j), GUI_BLENDMODE_SRC_OVER);
                        GUI_Translate_Display(MENU_Sprite, GUIMETERYNUM[EolNUM[j + 4u][i] % 16u], (320u + 44u * i), (196u + 33u * j), GUI_BLENDMODE_SRC_OVER);
                    }
                }
                else
                {
                    ;/*Do Nothing!*/
                }
            }
        }
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_DeaHIDAutoInit1_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_DeaHIDAutoInit1_Display(uint8_t Mode)
{
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_General_Display(MENU_Sprite, CN_DLR_Menu1_wenzi, GUI_BLENDMODE_SRC_OVER); /*menu*/
        GUI_General_Display(MENU_Sprite, CN_fengexian, GUI_BLENDMODE_SRC_OVER);           /*line*/
        GUI_General_Display(MENU_Sprite, CN_gundongtiao, GUI_BLENDMODE_SRC_OVER);         /*长度条*/

        GUI_General_Display(MENU_Sprite, CN_Fty_Menu2_05_1, GUI_BLENDMODE_SRC_OVER);
        GUI_General_Display(MENU_Sprite, CN_white_yes, GUI_BLENDMODE_SRC_OVER);
        GUI_General_Display(MENU_Sprite, CN_white_no , GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_DeaHIDAutoInit2_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_DeaHIDAutoInit2_Display(uint8_t Mode)
{
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_General_Display(MENU_Sprite, CN_DLR_Menu1_wenzi, GUI_BLENDMODE_SRC_OVER); /*menu*/
        GUI_General_Display(MENU_Sprite, CN_fengexian, GUI_BLENDMODE_SRC_OVER);           /*line*/
        GUI_General_Display(MENU_Sprite, CN_gundongtiao, GUI_BLENDMODE_SRC_OVER);         /*长度条*/

        GUI_General_Display(MENU_Sprite, CN_Fty_Menu2_05_2, GUI_BLENDMODE_SRC_OVER);
        GUI_General_Display(MENU_Sprite, CN_white_yes, GUI_BLENDMODE_SRC_OVER);
        GUI_General_Display(MENU_Sprite, CN_white_no , GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

/*--------------------------------------------------------------------------
 * Function Name  : GUI_BG_DeaMeterExit_Display
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         : 区域
 --------------------------------------------------------------------------*/
void GUI_BG_DeaMeterExit_Display(uint8_t Mode)
{
    if (Mode == GUI_DISP_MODE_NORMAL)
    {
        GUI_General_Display(MENU_Sprite, CN_DLR_Menu1_wenzi, GUI_BLENDMODE_SRC_OVER); /*menu*/
        GUI_General_Display(MENU_Sprite, CN_fengexian, GUI_BLENDMODE_SRC_OVER);           /*line*/
        GUI_General_Display(MENU_Sprite, CN_gundongtiao, GUI_BLENDMODE_SRC_OVER);         /*长度条*/

        GUI_General_Display(MENU_Sprite, CN_Fty_Menu2_07_1, GUI_BLENDMODE_SRC_OVER);
        GUI_General_Display(MENU_Sprite, CN_white_yes, GUI_BLENDMODE_SRC_OVER);
        GUI_General_Display(MENU_Sprite, CN_white_no , GUI_BLENDMODE_SRC_OVER);
    }
    else
    {
        GUI_General_Display(MENU_Sprite, SpriteSize, GUI_BLENDMODE_SRC_OVER);
    }
}

void K_LINE_EOL_Val_Server(void)
{
    EolNUM[0u][0u] = K_Line_Set.K_Line_LID20;
    EolNUM[0u][1u] = K_Line_Set.K_Line_LID21;
    EolNUM[0u][2u] = K_Line_Set.K_Line_LID22;
    EolNUM[0u][3u] = K_Line_Set.K_Line_LID23;
    EolNUM[0u][4u] = K_Line_Set.K_Line_LID24;
    EolNUM[0u][5u] = K_Line_Set.K_Line_LID25;
    EolNUM[0u][6u] = K_Line_Set.K_Line_LID26;
    EolNUM[0u][7u] = K_Line_Set.K_Line_LID27;
    EolNUM[5u][0u] = K_Line_Set.K_Line_LID28;
    EolNUM[5u][1u] = K_Line_Set.K_Line_LID29;
    EolNUM[5u][2u] = K_Line_Set.K_Line_LID2A;
    EolNUM[5u][3u] = K_Line_Set.K_Line_LID2B;
    EolNUM[5u][4u] = K_Line_Set.K_Line_LID2C;
    EolNUM[5u][5u] = K_Line_Set.K_Line_LID2D;
    EolNUM[5u][6u] = K_Line_Set.K_Line_LID2E;
    EolNUM[5u][7u] = K_Line_Set.K_Line_LID2F;
    EolNUM[1u][0u] = K_Line_Set.K_Line_LID30;
    EolNUM[1u][1u] = K_Line_Set.K_Line_LID31;
    EolNUM[1u][2u] = K_Line_Set.K_Line_LID32;
    EolNUM[1u][3u] = K_Line_Set.K_Line_LID33;
    EolNUM[1u][4u] = K_Line_Set.K_Line_LID34;
    EolNUM[1u][5u] = K_Line_Set.K_Line_LID35;
    EolNUM[1u][6u] = K_Line_Set.K_Line_LID36;
    EolNUM[1u][7u] = K_Line_Set.K_Line_LID37;
    EolNUM[6u][0u] = K_Line_Set.K_Line_LID38;
    EolNUM[6u][1u] = K_Line_Set.K_Line_LID39;
    EolNUM[6u][2u] = K_Line_Set.K_Line_LID3A;
    EolNUM[6u][3u] = K_Line_Set.K_Line_LID3B;
    EolNUM[6u][4u] = K_Line_Set.K_Line_LID3C;
    EolNUM[6u][5u] = K_Line_Set.K_Line_LID3D;
    EolNUM[6u][6u] = K_Line_Set.K_Line_LID3E;
    EolNUM[6u][7u] = K_Line_Set.K_Line_LID3F;
    EolNUM[2u][0u] = K_Line_Set.K_Line_LID40;
    EolNUM[2u][1u] = K_Line_Set.K_Line_LID41;
    EolNUM[2u][2u] = K_Line_Set.K_Line_LID42;
    EolNUM[2u][3u] = K_Line_Set.K_Line_LID43;
    EolNUM[2u][4u] = K_Line_Set.K_Line_LID44;
    EolNUM[2u][5u] = K_Line_Set.K_Line_LID45;
    EolNUM[2u][6u] = K_Line_Set.K_Line_LID46;
    EolNUM[2u][7u] = K_Line_Set.K_Line_LID47;
    EolNUM[7u][0u] = K_Line_Set.K_Line_LID48;
    EolNUM[7u][1u] = K_Line_Set.K_Line_LID49;
    EolNUM[7u][2u] = K_Line_Set.K_Line_LID4A;
    EolNUM[7u][3u] = K_Line_Set.K_Line_LID4B;
    EolNUM[7u][4u] = K_Line_Set.K_Line_LID4C;
    EolNUM[7u][5u] = K_Line_Set.K_Line_LID4D;
    EolNUM[7u][6u] = K_Line_Set.K_Line_LID4E;
    EolNUM[7u][7u] = K_Line_Set.K_Line_LID4F;
    EolNUM[3u][0u] = K_Line_Set.K_Line_LID50;
    EolNUM[3u][1u] = K_Line_Set.K_Line_LID51;
    EolNUM[3u][2u] = K_Line_Set.K_Line_LID52;
    EolNUM[3u][3u] = 0u;
    EolNUM[3u][4u] = 0u;
    EolNUM[3u][5u] = 0u;
    EolNUM[3u][6u] = 0u;
    EolNUM[3u][7u] = 0u;
    EolNUM[8u][0u] = 0u;
    EolNUM[8u][1u] = 0u;
    EolNUM[8u][2u] = 0u;
    EolNUM[8u][3u] = 0u;
    EolNUM[8u][4u] = 0u;
    EolNUM[8u][5u] = 0u;
    EolNUM[8u][6u] = 0u;
    EolNUM[8u][7u] = 0u;
    EolNUM[4u][0u] = 1u;
    EolNUM[4u][1u] = 0u;
    EolNUM[4u][2u] = 0u;
    EolNUM[4u][3u] = 0u;
    EolNUM[4u][4u] = 0u;
    EolNUM[4u][5u] = 0u;
    EolNUM[4u][6u] = 0u;
    EolNUM[4u][7u] = 0u;
    EolNUM[9u][0u] = 0u;
    EolNUM[9u][1u] = 0u;
    EolNUM[9u][2u] = 0u;
    EolNUM[9u][3u] = 0u;
    EolNUM[9u][4u] = 0u;
    EolNUM[9u][5u] = 0u;
    EolNUM[9u][6u] = 0u;
    EolNUM[9u][7u] = 0u;
}