#ifndef CAN_FUNC_H
#define CAN_FUNC_H

#include "TYW_stdint.h"

typedef struct
{
    uint32_t TripA_Fuel;
    uint32_t TripA_Average_Speed;
    uint32_t TripA_Fuel_Consume;
    uint32_t TripA_Idling;
    uint32_t TripA_Runing;
    uint32_t TripB_Fuel;
    uint32_t TripB_Average_Speed;
    uint32_t TripB_Fuel_Consume;
    uint32_t TripB_Idling;
    uint32_t TripB_Runing;
    uint32_t Engine_Oil;
    uint32_t Engine_Surplus;
} USER_ECU;
extern USER_ECU User_ECU;

extern uint32_t DisDTCNumber[50];
extern uint32_t DisDTCNum;

#define MAX_MULCANDATALEN 100
typedef union
{
    struct
    {
        uint32_t StructDTC[25];
    } SubDTC;
    uint8_t UnionDTC[100];
} _DATADTC;

typedef struct                          //7 bytes
{
    uint16_t wPGN;                          //打包消息的参数组编号
    uint8_t  bPackage;                      //全部数据包的数
    uint8_t  bLength;                       //整个消息大小的字节数
    uint8_t  bCtrByte;                      //控制字节
    uint8_t  bRcvInfoFlg;                   //有效接收标志，接收到该报文=1
    uint8_t  bRcvBusy;                      // 本标志位有效，表明正在接收多包信息。
    uint8_t  bPrePckNum;                    //上一个包序号
    _DATADTC DataDTC;                       //多包信息缓冲区
} MULCANMSG;

extern MULCANMSG ECM18EBFF00;
extern MULCANMSG ECM18EBFF03;
extern MULCANMSG ECM18EBFF0B;
extern MULCANMSG ECM18EBFF10;
extern MULCANMSG ECM18EBFFA0;
extern MULCANMSG ECM18EBFFE8;

extern void Can_Set_Buff_18FEAE17(uint8_t CopyData[]);

extern void Can_Set_Buff_18FF3E17(uint8_t CopyData[]);

extern void Can_Set_Buff_18FED917(uint8_t CopyData[]);

extern void Can_Set_Buff_18FEE617(uint8_t CopyData[]);

extern void Can_Set_Buff_18EF1817(uint8_t CopyData[]);

extern void Can_Set_Buff_18FEE017(uint8_t CopyData[]);

extern void Can_Set_Buff_18FEFC17(uint8_t CopyData[]);

extern void Can_Set_Buff_18FF2517(uint8_t CopyData[]);

extern void Can_Set_Buff_18FF2A17(uint8_t CopyData[]);

extern void Can_Set_Buff_18FF9D17(uint8_t CopyData[]);

extern void Can_Set_Buff_18FFE517(uint8_t CopyData[]);

extern void Can_Set_Buff_18EF2D17(uint8_t CopyData[]);

extern void Can_Set_Buff_18033317(uint8_t CopyData[]);

extern void Can_Set_Buff_180433A2(uint8_t CopyData[]);

extern void Can_Set_Buff_18EA0017(uint8_t CopyData[]);

void Drive_Info_IC1_STATUS_Rx(void);
void Drive_Info_IC3_STATUS_Rx(void);

uint32_t Common_Data_Get_TripA_Fuel(void);
uint32_t Common_Data_Get_TripA_Average_Speed(void);
uint32_t Common_Data_Get_TripB_Fuel(void);
uint32_t Common_Data_Get_TripB_Average_Speed(void);

void Common_SetTXNum_18033317(void);
uint8_t Common_GetTXNum_18033317(void);

void Id18EF1817_Send_Service(void);
void Id18033317_Send_Service(void);
void Id18FFE517_Send_Service(void);

void MSG_18021733_REC_COPY(uint8_t copy[]);
void Common_SetId18FFE517Msg_TXSUCCESS(void);
uint8_t Common_GetId18FFE517Msg_TXSUCCESS(void);
void Common_Set_LDWS_Flag_Sta(uint8_t Vol);
uint8_t Common_Get_LDWS_Flag_Sta(void);
uint8_t Common_Get_Water_Temp_Level_Flag(void);

void Common_DTC_Server(void);
void GetAllDtcFault(uint32_t* pCurFault, uint8_t* pCurFaultNum, uint32_t* pHisFault, uint8_t* pHisFaultNum);
void swap32(uint32_t *DwData);

void DoCAN_Get_Multi_frame00_Recv(void);
void DoCAN_Get_Multi_frame03_Recv(void);
void DoCAN_Get_Multi_frame0B_Recv(void);
void DoCAN_Get_Multi_frame10_Recv(void);
void DoCAN_Get_Multi_frameA0_Recv(void);
void DoCAN_Get_Multi_frameE8_Recv(void);

#endif