#include "UDS_85Service_Main.h"

/**
  *85服务函数入口
  *@param A_TA_type 收到数据的地址
  *@param A_Length 收到数据的长度
  *@param A_Data 收到数据的数据
  */
void UDS_Service_85_Indication(uint32_t A_TA_type, uint16_t A_Length, uint8_t A_Data[])
{
    uint8_t NRC = positiveResponse;
    setDiagMSG(A_TA_type, A_Length, A_Data);
    if(NRC == positiveResponse)
    {
        NRC = UDS_85Service_NRC11();                                            /*85服务是否支持功能寻址*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_85Service_NRC7F();                                            /*85服务会话是否支持验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_85Service_Sub_NRC13_MinLengthCheck();                         /*85服务最小长度验证S*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_85Service_Sub_NRC12();                                        /*85服务子功能是否支持验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_85Service_Sub_NRC13_TotalLengthCheck();                       /*85服务子功能总长度长度验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_85Service_NRC33();                                            /*85服务解锁等级验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_85Service_NRC22();                                            /*85服务条件验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_85Service_Sub_NRC24();                                        /*85服务子功能请求顺序验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_85Service_Sub_NRC31();                                        /*85服务子功能超出请求范围验证*/
    }
    if(NRC == positiveResponse)
    {
        UDS_85Service_Sub();                                                    /*85服务子功能*/
    }
    clearDiagMSG();                                                             /*清除诊断信息*/
}

/**
  *10服务子功能
  */
void UDS_85Service_Sub(void)
{
    uint8_t NRC = positiveResponse;
    /*if(NRC == positiveResponse)
    {
        NRC = UDS_85Service_Sub_NRC13_MinLengthCheck();                         /*85服务子功能最小长度验证*/
    /*}
    if(NRC == positiveResponse)
    {
        NRC = UDS_85Service_Sub_NRC12();                                        /*85服务子功能是否支持验证*/
    /*}
    if(NRC == positiveResponse)
    {
        NRC = UDS_85Service_Sub_NRC7E();                                        /*85服务子功能会话是否支持验证*/
    /*}
    if(NRC == positiveResponse)
    {
        NRC = UDS_85Service_Sub_NRC31();                                        /*85服务子功能超出请求范围验证*/
    /*}
    if(NRC == positiveResponse)
    {
        NRC = UDS_85Service_Sub_NRC13_TotalLengthCheck();                       /*85服务子功能总长度长度验证*/
    /*}
    if(NRC == positiveResponse)
    {
        NRC = UDS_85Service_Sub_NRC24();                                        /*85服务子功能请求顺序验证*/
    /*}
    if(NRC == positiveResponse)
    {
        NRC = UDS_85Service_Sub_NRC22();                                        /*85服务子功能条件验证*/
    /*}*/
    if(NRC == positiveResponse)
    {
        switch(DiagMSG.msgData.SidDetail.SubID)                                 /*子服务判断*/
        {
        case DTCSettingOn:
            UDS_85Service_Sub01();                                              /*85服务01子功能*/
            break;
        case DTCSettingOff:
            UDS_85Service_Sub02();                                              /*85服务02子功能*/
            break;
        default:
            break;
        }
    }
}

 /**
  *85服务01子功能
  */
void UDS_85Service_Sub01(void)
{
    OpenDTCTest();
    if(DiagMSG.msgData.SidDetail.PositiveSuppression == 0u)
    {
        UDS_Service_Response(0x85u, POSITIVE_RSP, DIAG_ID_Tx, 1u, DiagMSG.msgData.Data);
    }
}

 /**
  *85服务02子功能
  */
void UDS_85Service_Sub02(void)
{
    CloseDTCTest();
    if(DiagMSG.msgData.SidDetail.PositiveSuppression == 0u)
    {
        UDS_Service_Response(0x85u, POSITIVE_RSP, DIAG_ID_Tx, 1u, DiagMSG.msgData.Data);
    }
}
